# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/language/v2/language_service_pb"
require "google/cloud/language/v2/language_service"

class ::Google::Cloud::Language::V2::LanguageService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_analyze_sentiment
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Language::V2::AnalyzeSentimentResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    document = {}
    encoding_type = :NONE

    analyze_sentiment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :analyze_sentiment, name
      assert_kind_of ::Google::Cloud::Language::V2::AnalyzeSentimentRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Language::V2::Document), request["document"]
      assert_equal :NONE, request["encoding_type"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, analyze_sentiment_client_stub do
      # Create client
      client = ::Google::Cloud::Language::V2::LanguageService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.analyze_sentiment({ document: document, encoding_type: encoding_type }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.analyze_sentiment document: document, encoding_type: encoding_type do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.analyze_sentiment ::Google::Cloud::Language::V2::AnalyzeSentimentRequest.new(document: document, encoding_type: encoding_type) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.analyze_sentiment({ document: document, encoding_type: encoding_type }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.analyze_sentiment(::Google::Cloud::Language::V2::AnalyzeSentimentRequest.new(document: document, encoding_type: encoding_type), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, analyze_sentiment_client_stub.call_rpc_count
    end
  end

  def test_analyze_entities
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Language::V2::AnalyzeEntitiesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    document = {}
    encoding_type = :NONE

    analyze_entities_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :analyze_entities, name
      assert_kind_of ::Google::Cloud::Language::V2::AnalyzeEntitiesRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Language::V2::Document), request["document"]
      assert_equal :NONE, request["encoding_type"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, analyze_entities_client_stub do
      # Create client
      client = ::Google::Cloud::Language::V2::LanguageService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.analyze_entities({ document: document, encoding_type: encoding_type }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.analyze_entities document: document, encoding_type: encoding_type do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.analyze_entities ::Google::Cloud::Language::V2::AnalyzeEntitiesRequest.new(document: document, encoding_type: encoding_type) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.analyze_entities({ document: document, encoding_type: encoding_type }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.analyze_entities(::Google::Cloud::Language::V2::AnalyzeEntitiesRequest.new(document: document, encoding_type: encoding_type), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, analyze_entities_client_stub.call_rpc_count
    end
  end

  def test_classify_text
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Language::V2::ClassifyTextResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    document = {}

    classify_text_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :classify_text, name
      assert_kind_of ::Google::Cloud::Language::V2::ClassifyTextRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Language::V2::Document), request["document"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, classify_text_client_stub do
      # Create client
      client = ::Google::Cloud::Language::V2::LanguageService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.classify_text({ document: document }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.classify_text document: document do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.classify_text ::Google::Cloud::Language::V2::ClassifyTextRequest.new(document: document) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.classify_text({ document: document }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.classify_text(::Google::Cloud::Language::V2::ClassifyTextRequest.new(document: document), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, classify_text_client_stub.call_rpc_count
    end
  end

  def test_moderate_text
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Language::V2::ModerateTextResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    document = {}
    model_version = :MODEL_VERSION_UNSPECIFIED

    moderate_text_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :moderate_text, name
      assert_kind_of ::Google::Cloud::Language::V2::ModerateTextRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Language::V2::Document), request["document"]
      assert_equal :MODEL_VERSION_UNSPECIFIED, request["model_version"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, moderate_text_client_stub do
      # Create client
      client = ::Google::Cloud::Language::V2::LanguageService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.moderate_text({ document: document, model_version: model_version }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.moderate_text document: document, model_version: model_version do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.moderate_text ::Google::Cloud::Language::V2::ModerateTextRequest.new(document: document, model_version: model_version) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.moderate_text({ document: document, model_version: model_version }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.moderate_text(::Google::Cloud::Language::V2::ModerateTextRequest.new(document: document, model_version: model_version), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, moderate_text_client_stub.call_rpc_count
    end
  end

  def test_annotate_text
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Language::V2::AnnotateTextResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    document = {}
    features = {}
    encoding_type = :NONE

    annotate_text_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :annotate_text, name
      assert_kind_of ::Google::Cloud::Language::V2::AnnotateTextRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Language::V2::Document), request["document"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Language::V2::AnnotateTextRequest::Features), request["features"]
      assert_equal :NONE, request["encoding_type"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, annotate_text_client_stub do
      # Create client
      client = ::Google::Cloud::Language::V2::LanguageService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.annotate_text({ document: document, features: features, encoding_type: encoding_type }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.annotate_text document: document, features: features, encoding_type: encoding_type do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.annotate_text ::Google::Cloud::Language::V2::AnnotateTextRequest.new(document: document, features: features, encoding_type: encoding_type) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.annotate_text({ document: document, features: features, encoding_type: encoding_type }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.annotate_text(::Google::Cloud::Language::V2::AnnotateTextRequest.new(document: document, features: features, encoding_type: encoding_type), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, annotate_text_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Language::V2::LanguageService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Language::V2::LanguageService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Language::V2::LanguageService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Language::V2::LanguageService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
