# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/kms/v1/service_pb"
require "google/cloud/kms/v1/key_management_service"

class ::Google::Cloud::Kms::V1::KeyManagementService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_key_rings
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Kms::V1::ListKeyRingsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_key_rings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_key_rings, name
      assert_kind_of ::Google::Cloud::Kms::V1::ListKeyRingsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_key_rings_client_stub do
      # Create client
      client = ::Google::Cloud::Kms::V1::KeyManagementService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_key_rings({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_key_rings parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_key_rings ::Google::Cloud::Kms::V1::ListKeyRingsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_key_rings({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_key_rings(::Google::Cloud::Kms::V1::ListKeyRingsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_key_rings_client_stub.call_rpc_count
    end
  end

  def test_list_crypto_keys
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Kms::V1::ListCryptoKeysResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    version_view = :CRYPTO_KEY_VERSION_VIEW_UNSPECIFIED
    filter = "hello world"
    order_by = "hello world"

    list_crypto_keys_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_crypto_keys, name
      assert_kind_of ::Google::Cloud::Kms::V1::ListCryptoKeysRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal :CRYPTO_KEY_VERSION_VIEW_UNSPECIFIED, request["version_view"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_crypto_keys_client_stub do
      # Create client
      client = ::Google::Cloud::Kms::V1::KeyManagementService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_crypto_keys({ parent: parent, page_size: page_size, page_token: page_token, version_view: version_view, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_crypto_keys parent: parent, page_size: page_size, page_token: page_token, version_view: version_view, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_crypto_keys ::Google::Cloud::Kms::V1::ListCryptoKeysRequest.new(parent: parent, page_size: page_size, page_token: page_token, version_view: version_view, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_crypto_keys({ parent: parent, page_size: page_size, page_token: page_token, version_view: version_view, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_crypto_keys(::Google::Cloud::Kms::V1::ListCryptoKeysRequest.new(parent: parent, page_size: page_size, page_token: page_token, version_view: version_view, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_crypto_keys_client_stub.call_rpc_count
    end
  end

  def test_list_crypto_key_versions
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Kms::V1::ListCryptoKeyVersionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    view = :CRYPTO_KEY_VERSION_VIEW_UNSPECIFIED
    filter = "hello world"
    order_by = "hello world"

    list_crypto_key_versions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_crypto_key_versions, name
      assert_kind_of ::Google::Cloud::Kms::V1::ListCryptoKeyVersionsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal :CRYPTO_KEY_VERSION_VIEW_UNSPECIFIED, request["view"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_crypto_key_versions_client_stub do
      # Create client
      client = ::Google::Cloud::Kms::V1::KeyManagementService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_crypto_key_versions({ parent: parent, page_size: page_size, page_token: page_token, view: view, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_crypto_key_versions parent: parent, page_size: page_size, page_token: page_token, view: view, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_crypto_key_versions ::Google::Cloud::Kms::V1::ListCryptoKeyVersionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, view: view, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_crypto_key_versions({ parent: parent, page_size: page_size, page_token: page_token, view: view, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_crypto_key_versions(::Google::Cloud::Kms::V1::ListCryptoKeyVersionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, view: view, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_crypto_key_versions_client_stub.call_rpc_count
    end
  end

  def test_list_import_jobs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Kms::V1::ListImportJobsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_import_jobs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_import_jobs, name
      assert_kind_of ::Google::Cloud::Kms::V1::ListImportJobsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_import_jobs_client_stub do
      # Create client
      client = ::Google::Cloud::Kms::V1::KeyManagementService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_import_jobs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_import_jobs parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_import_jobs ::Google::Cloud::Kms::V1::ListImportJobsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_import_jobs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_import_jobs(::Google::Cloud::Kms::V1::ListImportJobsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_import_jobs_client_stub.call_rpc_count
    end
  end

  def test_get_key_ring
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Kms::V1::KeyRing.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_key_ring_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_key_ring, name
      assert_kind_of ::Google::Cloud::Kms::V1::GetKeyRingRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_key_ring_client_stub do
      # Create client
      client = ::Google::Cloud::Kms::V1::KeyManagementService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_key_ring({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_key_ring name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_key_ring ::Google::Cloud::Kms::V1::GetKeyRingRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_key_ring({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_key_ring(::Google::Cloud::Kms::V1::GetKeyRingRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_key_ring_client_stub.call_rpc_count
    end
  end

  def test_get_crypto_key
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Kms::V1::CryptoKey.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_crypto_key_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_crypto_key, name
      assert_kind_of ::Google::Cloud::Kms::V1::GetCryptoKeyRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_crypto_key_client_stub do
      # Create client
      client = ::Google::Cloud::Kms::V1::KeyManagementService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_crypto_key({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_crypto_key name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_crypto_key ::Google::Cloud::Kms::V1::GetCryptoKeyRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_crypto_key({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_crypto_key(::Google::Cloud::Kms::V1::GetCryptoKeyRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_crypto_key_client_stub.call_rpc_count
    end
  end

  def test_get_crypto_key_version
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Kms::V1::CryptoKeyVersion.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_crypto_key_version_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_crypto_key_version, name
      assert_kind_of ::Google::Cloud::Kms::V1::GetCryptoKeyVersionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_crypto_key_version_client_stub do
      # Create client
      client = ::Google::Cloud::Kms::V1::KeyManagementService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_crypto_key_version({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_crypto_key_version name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_crypto_key_version ::Google::Cloud::Kms::V1::GetCryptoKeyVersionRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_crypto_key_version({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_crypto_key_version(::Google::Cloud::Kms::V1::GetCryptoKeyVersionRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_crypto_key_version_client_stub.call_rpc_count
    end
  end

  def test_get_public_key
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Kms::V1::PublicKey.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    public_key_format = :PUBLIC_KEY_FORMAT_UNSPECIFIED

    get_public_key_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_public_key, name
      assert_kind_of ::Google::Cloud::Kms::V1::GetPublicKeyRequest, request
      assert_equal "hello world", request["name"]
      assert_equal :PUBLIC_KEY_FORMAT_UNSPECIFIED, request["public_key_format"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_public_key_client_stub do
      # Create client
      client = ::Google::Cloud::Kms::V1::KeyManagementService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_public_key({ name: name, public_key_format: public_key_format }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_public_key name: name, public_key_format: public_key_format do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_public_key ::Google::Cloud::Kms::V1::GetPublicKeyRequest.new(name: name, public_key_format: public_key_format) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_public_key({ name: name, public_key_format: public_key_format }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_public_key(::Google::Cloud::Kms::V1::GetPublicKeyRequest.new(name: name, public_key_format: public_key_format), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_public_key_client_stub.call_rpc_count
    end
  end

  def test_get_import_job
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Kms::V1::ImportJob.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_import_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_import_job, name
      assert_kind_of ::Google::Cloud::Kms::V1::GetImportJobRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_import_job_client_stub do
      # Create client
      client = ::Google::Cloud::Kms::V1::KeyManagementService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_import_job({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_import_job name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_import_job ::Google::Cloud::Kms::V1::GetImportJobRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_import_job({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_import_job(::Google::Cloud::Kms::V1::GetImportJobRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_import_job_client_stub.call_rpc_count
    end
  end

  def test_create_key_ring
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Kms::V1::KeyRing.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    key_ring_id = "hello world"
    key_ring = {}

    create_key_ring_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_key_ring, name
      assert_kind_of ::Google::Cloud::Kms::V1::CreateKeyRingRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["key_ring_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Kms::V1::KeyRing), request["key_ring"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_key_ring_client_stub do
      # Create client
      client = ::Google::Cloud::Kms::V1::KeyManagementService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_key_ring({ parent: parent, key_ring_id: key_ring_id, key_ring: key_ring }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_key_ring parent: parent, key_ring_id: key_ring_id, key_ring: key_ring do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_key_ring ::Google::Cloud::Kms::V1::CreateKeyRingRequest.new(parent: parent, key_ring_id: key_ring_id, key_ring: key_ring) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_key_ring({ parent: parent, key_ring_id: key_ring_id, key_ring: key_ring }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_key_ring(::Google::Cloud::Kms::V1::CreateKeyRingRequest.new(parent: parent, key_ring_id: key_ring_id, key_ring: key_ring), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_key_ring_client_stub.call_rpc_count
    end
  end

  def test_create_crypto_key
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Kms::V1::CryptoKey.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    crypto_key_id = "hello world"
    crypto_key = {}
    skip_initial_version_creation = true

    create_crypto_key_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_crypto_key, name
      assert_kind_of ::Google::Cloud::Kms::V1::CreateCryptoKeyRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["crypto_key_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Kms::V1::CryptoKey), request["crypto_key"]
      assert_equal true, request["skip_initial_version_creation"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_crypto_key_client_stub do
      # Create client
      client = ::Google::Cloud::Kms::V1::KeyManagementService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_crypto_key({ parent: parent, crypto_key_id: crypto_key_id, crypto_key: crypto_key, skip_initial_version_creation: skip_initial_version_creation }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_crypto_key parent: parent, crypto_key_id: crypto_key_id, crypto_key: crypto_key, skip_initial_version_creation: skip_initial_version_creation do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_crypto_key ::Google::Cloud::Kms::V1::CreateCryptoKeyRequest.new(parent: parent, crypto_key_id: crypto_key_id, crypto_key: crypto_key, skip_initial_version_creation: skip_initial_version_creation) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_crypto_key({ parent: parent, crypto_key_id: crypto_key_id, crypto_key: crypto_key, skip_initial_version_creation: skip_initial_version_creation }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_crypto_key(::Google::Cloud::Kms::V1::CreateCryptoKeyRequest.new(parent: parent, crypto_key_id: crypto_key_id, crypto_key: crypto_key, skip_initial_version_creation: skip_initial_version_creation), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_crypto_key_client_stub.call_rpc_count
    end
  end

  def test_create_crypto_key_version
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Kms::V1::CryptoKeyVersion.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    crypto_key_version = {}

    create_crypto_key_version_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_crypto_key_version, name
      assert_kind_of ::Google::Cloud::Kms::V1::CreateCryptoKeyVersionRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Kms::V1::CryptoKeyVersion), request["crypto_key_version"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_crypto_key_version_client_stub do
      # Create client
      client = ::Google::Cloud::Kms::V1::KeyManagementService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_crypto_key_version({ parent: parent, crypto_key_version: crypto_key_version }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_crypto_key_version parent: parent, crypto_key_version: crypto_key_version do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_crypto_key_version ::Google::Cloud::Kms::V1::CreateCryptoKeyVersionRequest.new(parent: parent, crypto_key_version: crypto_key_version) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_crypto_key_version({ parent: parent, crypto_key_version: crypto_key_version }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_crypto_key_version(::Google::Cloud::Kms::V1::CreateCryptoKeyVersionRequest.new(parent: parent, crypto_key_version: crypto_key_version), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_crypto_key_version_client_stub.call_rpc_count
    end
  end

  def test_import_crypto_key_version
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Kms::V1::CryptoKeyVersion.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    crypto_key_version = "hello world"
    algorithm = :CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED
    import_job = "hello world"
    wrapped_key = "hello world"
    rsa_aes_wrapped_key = "hello world"

    import_crypto_key_version_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :import_crypto_key_version, name
      assert_kind_of ::Google::Cloud::Kms::V1::ImportCryptoKeyVersionRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["crypto_key_version"]
      assert_equal :CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED, request["algorithm"]
      assert_equal "hello world", request["import_job"]
      assert_equal "hello world", request["wrapped_key"]
      assert_equal "hello world", request["rsa_aes_wrapped_key"]
      assert_equal :rsa_aes_wrapped_key, request.wrapped_key_material
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, import_crypto_key_version_client_stub do
      # Create client
      client = ::Google::Cloud::Kms::V1::KeyManagementService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.import_crypto_key_version({ parent: parent, crypto_key_version: crypto_key_version, algorithm: algorithm, import_job: import_job, wrapped_key: wrapped_key, rsa_aes_wrapped_key: rsa_aes_wrapped_key }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.import_crypto_key_version parent: parent, crypto_key_version: crypto_key_version, algorithm: algorithm, import_job: import_job, wrapped_key: wrapped_key, rsa_aes_wrapped_key: rsa_aes_wrapped_key do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.import_crypto_key_version ::Google::Cloud::Kms::V1::ImportCryptoKeyVersionRequest.new(parent: parent, crypto_key_version: crypto_key_version, algorithm: algorithm, import_job: import_job, wrapped_key: wrapped_key, rsa_aes_wrapped_key: rsa_aes_wrapped_key) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.import_crypto_key_version({ parent: parent, crypto_key_version: crypto_key_version, algorithm: algorithm, import_job: import_job, wrapped_key: wrapped_key, rsa_aes_wrapped_key: rsa_aes_wrapped_key }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.import_crypto_key_version(::Google::Cloud::Kms::V1::ImportCryptoKeyVersionRequest.new(parent: parent, crypto_key_version: crypto_key_version, algorithm: algorithm, import_job: import_job, wrapped_key: wrapped_key, rsa_aes_wrapped_key: rsa_aes_wrapped_key), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, import_crypto_key_version_client_stub.call_rpc_count
    end
  end

  def test_create_import_job
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Kms::V1::ImportJob.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    import_job_id = "hello world"
    import_job = {}

    create_import_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_import_job, name
      assert_kind_of ::Google::Cloud::Kms::V1::CreateImportJobRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["import_job_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Kms::V1::ImportJob), request["import_job"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_import_job_client_stub do
      # Create client
      client = ::Google::Cloud::Kms::V1::KeyManagementService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_import_job({ parent: parent, import_job_id: import_job_id, import_job: import_job }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_import_job parent: parent, import_job_id: import_job_id, import_job: import_job do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_import_job ::Google::Cloud::Kms::V1::CreateImportJobRequest.new(parent: parent, import_job_id: import_job_id, import_job: import_job) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_import_job({ parent: parent, import_job_id: import_job_id, import_job: import_job }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_import_job(::Google::Cloud::Kms::V1::CreateImportJobRequest.new(parent: parent, import_job_id: import_job_id, import_job: import_job), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_import_job_client_stub.call_rpc_count
    end
  end

  def test_update_crypto_key
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Kms::V1::CryptoKey.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    crypto_key = {}
    update_mask = {}

    update_crypto_key_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_crypto_key, name
      assert_kind_of ::Google::Cloud::Kms::V1::UpdateCryptoKeyRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Kms::V1::CryptoKey), request["crypto_key"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_crypto_key_client_stub do
      # Create client
      client = ::Google::Cloud::Kms::V1::KeyManagementService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_crypto_key({ crypto_key: crypto_key, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_crypto_key crypto_key: crypto_key, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_crypto_key ::Google::Cloud::Kms::V1::UpdateCryptoKeyRequest.new(crypto_key: crypto_key, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_crypto_key({ crypto_key: crypto_key, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_crypto_key(::Google::Cloud::Kms::V1::UpdateCryptoKeyRequest.new(crypto_key: crypto_key, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_crypto_key_client_stub.call_rpc_count
    end
  end

  def test_update_crypto_key_version
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Kms::V1::CryptoKeyVersion.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    crypto_key_version = {}
    update_mask = {}

    update_crypto_key_version_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_crypto_key_version, name
      assert_kind_of ::Google::Cloud::Kms::V1::UpdateCryptoKeyVersionRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Kms::V1::CryptoKeyVersion), request["crypto_key_version"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_crypto_key_version_client_stub do
      # Create client
      client = ::Google::Cloud::Kms::V1::KeyManagementService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_crypto_key_version({ crypto_key_version: crypto_key_version, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_crypto_key_version crypto_key_version: crypto_key_version, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_crypto_key_version ::Google::Cloud::Kms::V1::UpdateCryptoKeyVersionRequest.new(crypto_key_version: crypto_key_version, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_crypto_key_version({ crypto_key_version: crypto_key_version, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_crypto_key_version(::Google::Cloud::Kms::V1::UpdateCryptoKeyVersionRequest.new(crypto_key_version: crypto_key_version, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_crypto_key_version_client_stub.call_rpc_count
    end
  end

  def test_update_crypto_key_primary_version
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Kms::V1::CryptoKey.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    crypto_key_version_id = "hello world"

    update_crypto_key_primary_version_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_crypto_key_primary_version, name
      assert_kind_of ::Google::Cloud::Kms::V1::UpdateCryptoKeyPrimaryVersionRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["crypto_key_version_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_crypto_key_primary_version_client_stub do
      # Create client
      client = ::Google::Cloud::Kms::V1::KeyManagementService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_crypto_key_primary_version({ name: name, crypto_key_version_id: crypto_key_version_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_crypto_key_primary_version name: name, crypto_key_version_id: crypto_key_version_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_crypto_key_primary_version ::Google::Cloud::Kms::V1::UpdateCryptoKeyPrimaryVersionRequest.new(name: name, crypto_key_version_id: crypto_key_version_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_crypto_key_primary_version({ name: name, crypto_key_version_id: crypto_key_version_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_crypto_key_primary_version(::Google::Cloud::Kms::V1::UpdateCryptoKeyPrimaryVersionRequest.new(name: name, crypto_key_version_id: crypto_key_version_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_crypto_key_primary_version_client_stub.call_rpc_count
    end
  end

  def test_destroy_crypto_key_version
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Kms::V1::CryptoKeyVersion.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    destroy_crypto_key_version_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :destroy_crypto_key_version, name
      assert_kind_of ::Google::Cloud::Kms::V1::DestroyCryptoKeyVersionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, destroy_crypto_key_version_client_stub do
      # Create client
      client = ::Google::Cloud::Kms::V1::KeyManagementService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.destroy_crypto_key_version({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.destroy_crypto_key_version name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.destroy_crypto_key_version ::Google::Cloud::Kms::V1::DestroyCryptoKeyVersionRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.destroy_crypto_key_version({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.destroy_crypto_key_version(::Google::Cloud::Kms::V1::DestroyCryptoKeyVersionRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, destroy_crypto_key_version_client_stub.call_rpc_count
    end
  end

  def test_restore_crypto_key_version
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Kms::V1::CryptoKeyVersion.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    restore_crypto_key_version_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :restore_crypto_key_version, name
      assert_kind_of ::Google::Cloud::Kms::V1::RestoreCryptoKeyVersionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, restore_crypto_key_version_client_stub do
      # Create client
      client = ::Google::Cloud::Kms::V1::KeyManagementService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.restore_crypto_key_version({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.restore_crypto_key_version name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.restore_crypto_key_version ::Google::Cloud::Kms::V1::RestoreCryptoKeyVersionRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.restore_crypto_key_version({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.restore_crypto_key_version(::Google::Cloud::Kms::V1::RestoreCryptoKeyVersionRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, restore_crypto_key_version_client_stub.call_rpc_count
    end
  end

  def test_encrypt
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Kms::V1::EncryptResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    plaintext = "hello world"
    additional_authenticated_data = "hello world"
    plaintext_crc32c = {}
    additional_authenticated_data_crc32c = {}

    encrypt_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :encrypt, name
      assert_kind_of ::Google::Cloud::Kms::V1::EncryptRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["plaintext"]
      assert_equal "hello world", request["additional_authenticated_data"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Int64Value), request["plaintext_crc32c"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Int64Value), request["additional_authenticated_data_crc32c"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, encrypt_client_stub do
      # Create client
      client = ::Google::Cloud::Kms::V1::KeyManagementService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.encrypt({ name: name, plaintext: plaintext, additional_authenticated_data: additional_authenticated_data, plaintext_crc32c: plaintext_crc32c, additional_authenticated_data_crc32c: additional_authenticated_data_crc32c }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.encrypt name: name, plaintext: plaintext, additional_authenticated_data: additional_authenticated_data, plaintext_crc32c: plaintext_crc32c, additional_authenticated_data_crc32c: additional_authenticated_data_crc32c do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.encrypt ::Google::Cloud::Kms::V1::EncryptRequest.new(name: name, plaintext: plaintext, additional_authenticated_data: additional_authenticated_data, plaintext_crc32c: plaintext_crc32c, additional_authenticated_data_crc32c: additional_authenticated_data_crc32c) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.encrypt({ name: name, plaintext: plaintext, additional_authenticated_data: additional_authenticated_data, plaintext_crc32c: plaintext_crc32c, additional_authenticated_data_crc32c: additional_authenticated_data_crc32c }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.encrypt(::Google::Cloud::Kms::V1::EncryptRequest.new(name: name, plaintext: plaintext, additional_authenticated_data: additional_authenticated_data, plaintext_crc32c: plaintext_crc32c, additional_authenticated_data_crc32c: additional_authenticated_data_crc32c), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, encrypt_client_stub.call_rpc_count
    end
  end

  def test_decrypt
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Kms::V1::DecryptResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    ciphertext = "hello world"
    additional_authenticated_data = "hello world"
    ciphertext_crc32c = {}
    additional_authenticated_data_crc32c = {}

    decrypt_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :decrypt, name
      assert_kind_of ::Google::Cloud::Kms::V1::DecryptRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["ciphertext"]
      assert_equal "hello world", request["additional_authenticated_data"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Int64Value), request["ciphertext_crc32c"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Int64Value), request["additional_authenticated_data_crc32c"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, decrypt_client_stub do
      # Create client
      client = ::Google::Cloud::Kms::V1::KeyManagementService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.decrypt({ name: name, ciphertext: ciphertext, additional_authenticated_data: additional_authenticated_data, ciphertext_crc32c: ciphertext_crc32c, additional_authenticated_data_crc32c: additional_authenticated_data_crc32c }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.decrypt name: name, ciphertext: ciphertext, additional_authenticated_data: additional_authenticated_data, ciphertext_crc32c: ciphertext_crc32c, additional_authenticated_data_crc32c: additional_authenticated_data_crc32c do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.decrypt ::Google::Cloud::Kms::V1::DecryptRequest.new(name: name, ciphertext: ciphertext, additional_authenticated_data: additional_authenticated_data, ciphertext_crc32c: ciphertext_crc32c, additional_authenticated_data_crc32c: additional_authenticated_data_crc32c) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.decrypt({ name: name, ciphertext: ciphertext, additional_authenticated_data: additional_authenticated_data, ciphertext_crc32c: ciphertext_crc32c, additional_authenticated_data_crc32c: additional_authenticated_data_crc32c }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.decrypt(::Google::Cloud::Kms::V1::DecryptRequest.new(name: name, ciphertext: ciphertext, additional_authenticated_data: additional_authenticated_data, ciphertext_crc32c: ciphertext_crc32c, additional_authenticated_data_crc32c: additional_authenticated_data_crc32c), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, decrypt_client_stub.call_rpc_count
    end
  end

  def test_raw_encrypt
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Kms::V1::RawEncryptResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    plaintext = "hello world"
    additional_authenticated_data = "hello world"
    plaintext_crc32c = {}
    additional_authenticated_data_crc32c = {}
    initialization_vector = "hello world"
    initialization_vector_crc32c = {}

    raw_encrypt_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :raw_encrypt, name
      assert_kind_of ::Google::Cloud::Kms::V1::RawEncryptRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["plaintext"]
      assert_equal "hello world", request["additional_authenticated_data"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Int64Value), request["plaintext_crc32c"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Int64Value), request["additional_authenticated_data_crc32c"]
      assert_equal "hello world", request["initialization_vector"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Int64Value), request["initialization_vector_crc32c"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, raw_encrypt_client_stub do
      # Create client
      client = ::Google::Cloud::Kms::V1::KeyManagementService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.raw_encrypt({ name: name, plaintext: plaintext, additional_authenticated_data: additional_authenticated_data, plaintext_crc32c: plaintext_crc32c, additional_authenticated_data_crc32c: additional_authenticated_data_crc32c, initialization_vector: initialization_vector, initialization_vector_crc32c: initialization_vector_crc32c }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.raw_encrypt name: name, plaintext: plaintext, additional_authenticated_data: additional_authenticated_data, plaintext_crc32c: plaintext_crc32c, additional_authenticated_data_crc32c: additional_authenticated_data_crc32c, initialization_vector: initialization_vector, initialization_vector_crc32c: initialization_vector_crc32c do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.raw_encrypt ::Google::Cloud::Kms::V1::RawEncryptRequest.new(name: name, plaintext: plaintext, additional_authenticated_data: additional_authenticated_data, plaintext_crc32c: plaintext_crc32c, additional_authenticated_data_crc32c: additional_authenticated_data_crc32c, initialization_vector: initialization_vector, initialization_vector_crc32c: initialization_vector_crc32c) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.raw_encrypt({ name: name, plaintext: plaintext, additional_authenticated_data: additional_authenticated_data, plaintext_crc32c: plaintext_crc32c, additional_authenticated_data_crc32c: additional_authenticated_data_crc32c, initialization_vector: initialization_vector, initialization_vector_crc32c: initialization_vector_crc32c }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.raw_encrypt(::Google::Cloud::Kms::V1::RawEncryptRequest.new(name: name, plaintext: plaintext, additional_authenticated_data: additional_authenticated_data, plaintext_crc32c: plaintext_crc32c, additional_authenticated_data_crc32c: additional_authenticated_data_crc32c, initialization_vector: initialization_vector, initialization_vector_crc32c: initialization_vector_crc32c), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, raw_encrypt_client_stub.call_rpc_count
    end
  end

  def test_raw_decrypt
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Kms::V1::RawDecryptResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    ciphertext = "hello world"
    additional_authenticated_data = "hello world"
    initialization_vector = "hello world"
    tag_length = 42
    ciphertext_crc32c = {}
    additional_authenticated_data_crc32c = {}
    initialization_vector_crc32c = {}

    raw_decrypt_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :raw_decrypt, name
      assert_kind_of ::Google::Cloud::Kms::V1::RawDecryptRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["ciphertext"]
      assert_equal "hello world", request["additional_authenticated_data"]
      assert_equal "hello world", request["initialization_vector"]
      assert_equal 42, request["tag_length"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Int64Value), request["ciphertext_crc32c"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Int64Value), request["additional_authenticated_data_crc32c"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Int64Value), request["initialization_vector_crc32c"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, raw_decrypt_client_stub do
      # Create client
      client = ::Google::Cloud::Kms::V1::KeyManagementService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.raw_decrypt({ name: name, ciphertext: ciphertext, additional_authenticated_data: additional_authenticated_data, initialization_vector: initialization_vector, tag_length: tag_length, ciphertext_crc32c: ciphertext_crc32c, additional_authenticated_data_crc32c: additional_authenticated_data_crc32c, initialization_vector_crc32c: initialization_vector_crc32c }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.raw_decrypt name: name, ciphertext: ciphertext, additional_authenticated_data: additional_authenticated_data, initialization_vector: initialization_vector, tag_length: tag_length, ciphertext_crc32c: ciphertext_crc32c, additional_authenticated_data_crc32c: additional_authenticated_data_crc32c, initialization_vector_crc32c: initialization_vector_crc32c do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.raw_decrypt ::Google::Cloud::Kms::V1::RawDecryptRequest.new(name: name, ciphertext: ciphertext, additional_authenticated_data: additional_authenticated_data, initialization_vector: initialization_vector, tag_length: tag_length, ciphertext_crc32c: ciphertext_crc32c, additional_authenticated_data_crc32c: additional_authenticated_data_crc32c, initialization_vector_crc32c: initialization_vector_crc32c) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.raw_decrypt({ name: name, ciphertext: ciphertext, additional_authenticated_data: additional_authenticated_data, initialization_vector: initialization_vector, tag_length: tag_length, ciphertext_crc32c: ciphertext_crc32c, additional_authenticated_data_crc32c: additional_authenticated_data_crc32c, initialization_vector_crc32c: initialization_vector_crc32c }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.raw_decrypt(::Google::Cloud::Kms::V1::RawDecryptRequest.new(name: name, ciphertext: ciphertext, additional_authenticated_data: additional_authenticated_data, initialization_vector: initialization_vector, tag_length: tag_length, ciphertext_crc32c: ciphertext_crc32c, additional_authenticated_data_crc32c: additional_authenticated_data_crc32c, initialization_vector_crc32c: initialization_vector_crc32c), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, raw_decrypt_client_stub.call_rpc_count
    end
  end

  def test_asymmetric_sign
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Kms::V1::AsymmetricSignResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    digest = {}
    digest_crc32c = {}
    data = "hello world"
    data_crc32c = {}

    asymmetric_sign_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :asymmetric_sign, name
      assert_kind_of ::Google::Cloud::Kms::V1::AsymmetricSignRequest, request
      assert_equal "hello world", request["name"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Kms::V1::Digest), request["digest"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Int64Value), request["digest_crc32c"]
      assert_equal "hello world", request["data"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Int64Value), request["data_crc32c"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, asymmetric_sign_client_stub do
      # Create client
      client = ::Google::Cloud::Kms::V1::KeyManagementService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.asymmetric_sign({ name: name, digest: digest, digest_crc32c: digest_crc32c, data: data, data_crc32c: data_crc32c }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.asymmetric_sign name: name, digest: digest, digest_crc32c: digest_crc32c, data: data, data_crc32c: data_crc32c do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.asymmetric_sign ::Google::Cloud::Kms::V1::AsymmetricSignRequest.new(name: name, digest: digest, digest_crc32c: digest_crc32c, data: data, data_crc32c: data_crc32c) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.asymmetric_sign({ name: name, digest: digest, digest_crc32c: digest_crc32c, data: data, data_crc32c: data_crc32c }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.asymmetric_sign(::Google::Cloud::Kms::V1::AsymmetricSignRequest.new(name: name, digest: digest, digest_crc32c: digest_crc32c, data: data, data_crc32c: data_crc32c), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, asymmetric_sign_client_stub.call_rpc_count
    end
  end

  def test_asymmetric_decrypt
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Kms::V1::AsymmetricDecryptResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    ciphertext = "hello world"
    ciphertext_crc32c = {}

    asymmetric_decrypt_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :asymmetric_decrypt, name
      assert_kind_of ::Google::Cloud::Kms::V1::AsymmetricDecryptRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["ciphertext"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Int64Value), request["ciphertext_crc32c"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, asymmetric_decrypt_client_stub do
      # Create client
      client = ::Google::Cloud::Kms::V1::KeyManagementService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.asymmetric_decrypt({ name: name, ciphertext: ciphertext, ciphertext_crc32c: ciphertext_crc32c }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.asymmetric_decrypt name: name, ciphertext: ciphertext, ciphertext_crc32c: ciphertext_crc32c do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.asymmetric_decrypt ::Google::Cloud::Kms::V1::AsymmetricDecryptRequest.new(name: name, ciphertext: ciphertext, ciphertext_crc32c: ciphertext_crc32c) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.asymmetric_decrypt({ name: name, ciphertext: ciphertext, ciphertext_crc32c: ciphertext_crc32c }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.asymmetric_decrypt(::Google::Cloud::Kms::V1::AsymmetricDecryptRequest.new(name: name, ciphertext: ciphertext, ciphertext_crc32c: ciphertext_crc32c), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, asymmetric_decrypt_client_stub.call_rpc_count
    end
  end

  def test_mac_sign
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Kms::V1::MacSignResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    data = "hello world"
    data_crc32c = {}

    mac_sign_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :mac_sign, name
      assert_kind_of ::Google::Cloud::Kms::V1::MacSignRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["data"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Int64Value), request["data_crc32c"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, mac_sign_client_stub do
      # Create client
      client = ::Google::Cloud::Kms::V1::KeyManagementService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.mac_sign({ name: name, data: data, data_crc32c: data_crc32c }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.mac_sign name: name, data: data, data_crc32c: data_crc32c do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.mac_sign ::Google::Cloud::Kms::V1::MacSignRequest.new(name: name, data: data, data_crc32c: data_crc32c) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.mac_sign({ name: name, data: data, data_crc32c: data_crc32c }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.mac_sign(::Google::Cloud::Kms::V1::MacSignRequest.new(name: name, data: data, data_crc32c: data_crc32c), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, mac_sign_client_stub.call_rpc_count
    end
  end

  def test_mac_verify
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Kms::V1::MacVerifyResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    data = "hello world"
    data_crc32c = {}
    mac = "hello world"
    mac_crc32c = {}

    mac_verify_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :mac_verify, name
      assert_kind_of ::Google::Cloud::Kms::V1::MacVerifyRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["data"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Int64Value), request["data_crc32c"]
      assert_equal "hello world", request["mac"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Int64Value), request["mac_crc32c"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, mac_verify_client_stub do
      # Create client
      client = ::Google::Cloud::Kms::V1::KeyManagementService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.mac_verify({ name: name, data: data, data_crc32c: data_crc32c, mac: mac, mac_crc32c: mac_crc32c }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.mac_verify name: name, data: data, data_crc32c: data_crc32c, mac: mac, mac_crc32c: mac_crc32c do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.mac_verify ::Google::Cloud::Kms::V1::MacVerifyRequest.new(name: name, data: data, data_crc32c: data_crc32c, mac: mac, mac_crc32c: mac_crc32c) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.mac_verify({ name: name, data: data, data_crc32c: data_crc32c, mac: mac, mac_crc32c: mac_crc32c }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.mac_verify(::Google::Cloud::Kms::V1::MacVerifyRequest.new(name: name, data: data, data_crc32c: data_crc32c, mac: mac, mac_crc32c: mac_crc32c), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, mac_verify_client_stub.call_rpc_count
    end
  end

  def test_decapsulate
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Kms::V1::DecapsulateResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    ciphertext = "hello world"
    ciphertext_crc32c = {}

    decapsulate_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :decapsulate, name
      assert_kind_of ::Google::Cloud::Kms::V1::DecapsulateRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["ciphertext"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Int64Value), request["ciphertext_crc32c"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, decapsulate_client_stub do
      # Create client
      client = ::Google::Cloud::Kms::V1::KeyManagementService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.decapsulate({ name: name, ciphertext: ciphertext, ciphertext_crc32c: ciphertext_crc32c }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.decapsulate name: name, ciphertext: ciphertext, ciphertext_crc32c: ciphertext_crc32c do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.decapsulate ::Google::Cloud::Kms::V1::DecapsulateRequest.new(name: name, ciphertext: ciphertext, ciphertext_crc32c: ciphertext_crc32c) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.decapsulate({ name: name, ciphertext: ciphertext, ciphertext_crc32c: ciphertext_crc32c }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.decapsulate(::Google::Cloud::Kms::V1::DecapsulateRequest.new(name: name, ciphertext: ciphertext, ciphertext_crc32c: ciphertext_crc32c), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, decapsulate_client_stub.call_rpc_count
    end
  end

  def test_generate_random_bytes
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Kms::V1::GenerateRandomBytesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    location = "hello world"
    length_bytes = 42
    protection_level = :PROTECTION_LEVEL_UNSPECIFIED

    generate_random_bytes_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :generate_random_bytes, name
      assert_kind_of ::Google::Cloud::Kms::V1::GenerateRandomBytesRequest, request
      assert_equal "hello world", request["location"]
      assert_equal 42, request["length_bytes"]
      assert_equal :PROTECTION_LEVEL_UNSPECIFIED, request["protection_level"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, generate_random_bytes_client_stub do
      # Create client
      client = ::Google::Cloud::Kms::V1::KeyManagementService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.generate_random_bytes({ location: location, length_bytes: length_bytes, protection_level: protection_level }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.generate_random_bytes location: location, length_bytes: length_bytes, protection_level: protection_level do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.generate_random_bytes ::Google::Cloud::Kms::V1::GenerateRandomBytesRequest.new(location: location, length_bytes: length_bytes, protection_level: protection_level) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.generate_random_bytes({ location: location, length_bytes: length_bytes, protection_level: protection_level }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.generate_random_bytes(::Google::Cloud::Kms::V1::GenerateRandomBytesRequest.new(location: location, length_bytes: length_bytes, protection_level: protection_level), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, generate_random_bytes_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Kms::V1::KeyManagementService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Kms::V1::KeyManagementService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Kms::V1::KeyManagementService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Kms::V1::KeyManagementService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
