# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/kms/v1/service_pb"
require "google/cloud/kms/v1/key_management_service/rest"


class ::Google::Cloud::Kms::V1::KeyManagementService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_key_rings
    # Create test objects.
    client_result = ::Google::Cloud::Kms::V1::ListKeyRingsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_key_rings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Kms::V1::KeyManagementService::Rest::ServiceStub.stub :transcode_list_key_rings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_key_rings_client_stub do
        # Create client
        client = ::Google::Cloud::Kms::V1::KeyManagementService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_key_rings({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_key_rings parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_key_rings ::Google::Cloud::Kms::V1::ListKeyRingsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_key_rings({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_key_rings(::Google::Cloud::Kms::V1::ListKeyRingsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_key_rings_client_stub.call_count
      end
    end
  end

  def test_list_crypto_keys
    # Create test objects.
    client_result = ::Google::Cloud::Kms::V1::ListCryptoKeysResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    version_view = :CRYPTO_KEY_VERSION_VIEW_UNSPECIFIED
    filter = "hello world"
    order_by = "hello world"

    list_crypto_keys_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Kms::V1::KeyManagementService::Rest::ServiceStub.stub :transcode_list_crypto_keys_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_crypto_keys_client_stub do
        # Create client
        client = ::Google::Cloud::Kms::V1::KeyManagementService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_crypto_keys({ parent: parent, page_size: page_size, page_token: page_token, version_view: version_view, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_crypto_keys parent: parent, page_size: page_size, page_token: page_token, version_view: version_view, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_crypto_keys ::Google::Cloud::Kms::V1::ListCryptoKeysRequest.new(parent: parent, page_size: page_size, page_token: page_token, version_view: version_view, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_crypto_keys({ parent: parent, page_size: page_size, page_token: page_token, version_view: version_view, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_crypto_keys(::Google::Cloud::Kms::V1::ListCryptoKeysRequest.new(parent: parent, page_size: page_size, page_token: page_token, version_view: version_view, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_crypto_keys_client_stub.call_count
      end
    end
  end

  def test_list_crypto_key_versions
    # Create test objects.
    client_result = ::Google::Cloud::Kms::V1::ListCryptoKeyVersionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    view = :CRYPTO_KEY_VERSION_VIEW_UNSPECIFIED
    filter = "hello world"
    order_by = "hello world"

    list_crypto_key_versions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Kms::V1::KeyManagementService::Rest::ServiceStub.stub :transcode_list_crypto_key_versions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_crypto_key_versions_client_stub do
        # Create client
        client = ::Google::Cloud::Kms::V1::KeyManagementService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_crypto_key_versions({ parent: parent, page_size: page_size, page_token: page_token, view: view, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_crypto_key_versions parent: parent, page_size: page_size, page_token: page_token, view: view, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_crypto_key_versions ::Google::Cloud::Kms::V1::ListCryptoKeyVersionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, view: view, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_crypto_key_versions({ parent: parent, page_size: page_size, page_token: page_token, view: view, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_crypto_key_versions(::Google::Cloud::Kms::V1::ListCryptoKeyVersionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, view: view, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_crypto_key_versions_client_stub.call_count
      end
    end
  end

  def test_list_import_jobs
    # Create test objects.
    client_result = ::Google::Cloud::Kms::V1::ListImportJobsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_import_jobs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Kms::V1::KeyManagementService::Rest::ServiceStub.stub :transcode_list_import_jobs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_import_jobs_client_stub do
        # Create client
        client = ::Google::Cloud::Kms::V1::KeyManagementService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_import_jobs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_import_jobs parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_import_jobs ::Google::Cloud::Kms::V1::ListImportJobsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_import_jobs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_import_jobs(::Google::Cloud::Kms::V1::ListImportJobsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_import_jobs_client_stub.call_count
      end
    end
  end

  def test_get_key_ring
    # Create test objects.
    client_result = ::Google::Cloud::Kms::V1::KeyRing.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_key_ring_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Kms::V1::KeyManagementService::Rest::ServiceStub.stub :transcode_get_key_ring_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_key_ring_client_stub do
        # Create client
        client = ::Google::Cloud::Kms::V1::KeyManagementService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_key_ring({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_key_ring name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_key_ring ::Google::Cloud::Kms::V1::GetKeyRingRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_key_ring({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_key_ring(::Google::Cloud::Kms::V1::GetKeyRingRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_key_ring_client_stub.call_count
      end
    end
  end

  def test_get_crypto_key
    # Create test objects.
    client_result = ::Google::Cloud::Kms::V1::CryptoKey.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_crypto_key_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Kms::V1::KeyManagementService::Rest::ServiceStub.stub :transcode_get_crypto_key_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_crypto_key_client_stub do
        # Create client
        client = ::Google::Cloud::Kms::V1::KeyManagementService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_crypto_key({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_crypto_key name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_crypto_key ::Google::Cloud::Kms::V1::GetCryptoKeyRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_crypto_key({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_crypto_key(::Google::Cloud::Kms::V1::GetCryptoKeyRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_crypto_key_client_stub.call_count
      end
    end
  end

  def test_get_crypto_key_version
    # Create test objects.
    client_result = ::Google::Cloud::Kms::V1::CryptoKeyVersion.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_crypto_key_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Kms::V1::KeyManagementService::Rest::ServiceStub.stub :transcode_get_crypto_key_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_crypto_key_version_client_stub do
        # Create client
        client = ::Google::Cloud::Kms::V1::KeyManagementService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_crypto_key_version({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_crypto_key_version name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_crypto_key_version ::Google::Cloud::Kms::V1::GetCryptoKeyVersionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_crypto_key_version({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_crypto_key_version(::Google::Cloud::Kms::V1::GetCryptoKeyVersionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_crypto_key_version_client_stub.call_count
      end
    end
  end

  def test_get_public_key
    # Create test objects.
    client_result = ::Google::Cloud::Kms::V1::PublicKey.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    public_key_format = :PUBLIC_KEY_FORMAT_UNSPECIFIED

    get_public_key_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Kms::V1::KeyManagementService::Rest::ServiceStub.stub :transcode_get_public_key_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_public_key_client_stub do
        # Create client
        client = ::Google::Cloud::Kms::V1::KeyManagementService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_public_key({ name: name, public_key_format: public_key_format }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_public_key name: name, public_key_format: public_key_format do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_public_key ::Google::Cloud::Kms::V1::GetPublicKeyRequest.new(name: name, public_key_format: public_key_format) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_public_key({ name: name, public_key_format: public_key_format }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_public_key(::Google::Cloud::Kms::V1::GetPublicKeyRequest.new(name: name, public_key_format: public_key_format), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_public_key_client_stub.call_count
      end
    end
  end

  def test_get_import_job
    # Create test objects.
    client_result = ::Google::Cloud::Kms::V1::ImportJob.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_import_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Kms::V1::KeyManagementService::Rest::ServiceStub.stub :transcode_get_import_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_import_job_client_stub do
        # Create client
        client = ::Google::Cloud::Kms::V1::KeyManagementService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_import_job({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_import_job name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_import_job ::Google::Cloud::Kms::V1::GetImportJobRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_import_job({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_import_job(::Google::Cloud::Kms::V1::GetImportJobRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_import_job_client_stub.call_count
      end
    end
  end

  def test_create_key_ring
    # Create test objects.
    client_result = ::Google::Cloud::Kms::V1::KeyRing.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    key_ring_id = "hello world"
    key_ring = {}

    create_key_ring_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Kms::V1::KeyManagementService::Rest::ServiceStub.stub :transcode_create_key_ring_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_key_ring_client_stub do
        # Create client
        client = ::Google::Cloud::Kms::V1::KeyManagementService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_key_ring({ parent: parent, key_ring_id: key_ring_id, key_ring: key_ring }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_key_ring parent: parent, key_ring_id: key_ring_id, key_ring: key_ring do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_key_ring ::Google::Cloud::Kms::V1::CreateKeyRingRequest.new(parent: parent, key_ring_id: key_ring_id, key_ring: key_ring) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_key_ring({ parent: parent, key_ring_id: key_ring_id, key_ring: key_ring }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_key_ring(::Google::Cloud::Kms::V1::CreateKeyRingRequest.new(parent: parent, key_ring_id: key_ring_id, key_ring: key_ring), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_key_ring_client_stub.call_count
      end
    end
  end

  def test_create_crypto_key
    # Create test objects.
    client_result = ::Google::Cloud::Kms::V1::CryptoKey.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    crypto_key_id = "hello world"
    crypto_key = {}
    skip_initial_version_creation = true

    create_crypto_key_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Kms::V1::KeyManagementService::Rest::ServiceStub.stub :transcode_create_crypto_key_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_crypto_key_client_stub do
        # Create client
        client = ::Google::Cloud::Kms::V1::KeyManagementService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_crypto_key({ parent: parent, crypto_key_id: crypto_key_id, crypto_key: crypto_key, skip_initial_version_creation: skip_initial_version_creation }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_crypto_key parent: parent, crypto_key_id: crypto_key_id, crypto_key: crypto_key, skip_initial_version_creation: skip_initial_version_creation do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_crypto_key ::Google::Cloud::Kms::V1::CreateCryptoKeyRequest.new(parent: parent, crypto_key_id: crypto_key_id, crypto_key: crypto_key, skip_initial_version_creation: skip_initial_version_creation) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_crypto_key({ parent: parent, crypto_key_id: crypto_key_id, crypto_key: crypto_key, skip_initial_version_creation: skip_initial_version_creation }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_crypto_key(::Google::Cloud::Kms::V1::CreateCryptoKeyRequest.new(parent: parent, crypto_key_id: crypto_key_id, crypto_key: crypto_key, skip_initial_version_creation: skip_initial_version_creation), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_crypto_key_client_stub.call_count
      end
    end
  end

  def test_create_crypto_key_version
    # Create test objects.
    client_result = ::Google::Cloud::Kms::V1::CryptoKeyVersion.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    crypto_key_version = {}

    create_crypto_key_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Kms::V1::KeyManagementService::Rest::ServiceStub.stub :transcode_create_crypto_key_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_crypto_key_version_client_stub do
        # Create client
        client = ::Google::Cloud::Kms::V1::KeyManagementService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_crypto_key_version({ parent: parent, crypto_key_version: crypto_key_version }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_crypto_key_version parent: parent, crypto_key_version: crypto_key_version do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_crypto_key_version ::Google::Cloud::Kms::V1::CreateCryptoKeyVersionRequest.new(parent: parent, crypto_key_version: crypto_key_version) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_crypto_key_version({ parent: parent, crypto_key_version: crypto_key_version }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_crypto_key_version(::Google::Cloud::Kms::V1::CreateCryptoKeyVersionRequest.new(parent: parent, crypto_key_version: crypto_key_version), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_crypto_key_version_client_stub.call_count
      end
    end
  end

  def test_import_crypto_key_version
    # Create test objects.
    client_result = ::Google::Cloud::Kms::V1::CryptoKeyVersion.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    crypto_key_version = "hello world"
    algorithm = :CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED
    import_job = "hello world"
    wrapped_key = "hello world"
    rsa_aes_wrapped_key = "hello world"

    import_crypto_key_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Kms::V1::KeyManagementService::Rest::ServiceStub.stub :transcode_import_crypto_key_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, import_crypto_key_version_client_stub do
        # Create client
        client = ::Google::Cloud::Kms::V1::KeyManagementService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.import_crypto_key_version({ parent: parent, crypto_key_version: crypto_key_version, algorithm: algorithm, import_job: import_job, wrapped_key: wrapped_key, rsa_aes_wrapped_key: rsa_aes_wrapped_key }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.import_crypto_key_version parent: parent, crypto_key_version: crypto_key_version, algorithm: algorithm, import_job: import_job, wrapped_key: wrapped_key, rsa_aes_wrapped_key: rsa_aes_wrapped_key do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.import_crypto_key_version ::Google::Cloud::Kms::V1::ImportCryptoKeyVersionRequest.new(parent: parent, crypto_key_version: crypto_key_version, algorithm: algorithm, import_job: import_job, wrapped_key: wrapped_key, rsa_aes_wrapped_key: rsa_aes_wrapped_key) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.import_crypto_key_version({ parent: parent, crypto_key_version: crypto_key_version, algorithm: algorithm, import_job: import_job, wrapped_key: wrapped_key, rsa_aes_wrapped_key: rsa_aes_wrapped_key }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.import_crypto_key_version(::Google::Cloud::Kms::V1::ImportCryptoKeyVersionRequest.new(parent: parent, crypto_key_version: crypto_key_version, algorithm: algorithm, import_job: import_job, wrapped_key: wrapped_key, rsa_aes_wrapped_key: rsa_aes_wrapped_key), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, import_crypto_key_version_client_stub.call_count
      end
    end
  end

  def test_create_import_job
    # Create test objects.
    client_result = ::Google::Cloud::Kms::V1::ImportJob.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    import_job_id = "hello world"
    import_job = {}

    create_import_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Kms::V1::KeyManagementService::Rest::ServiceStub.stub :transcode_create_import_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_import_job_client_stub do
        # Create client
        client = ::Google::Cloud::Kms::V1::KeyManagementService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_import_job({ parent: parent, import_job_id: import_job_id, import_job: import_job }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_import_job parent: parent, import_job_id: import_job_id, import_job: import_job do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_import_job ::Google::Cloud::Kms::V1::CreateImportJobRequest.new(parent: parent, import_job_id: import_job_id, import_job: import_job) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_import_job({ parent: parent, import_job_id: import_job_id, import_job: import_job }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_import_job(::Google::Cloud::Kms::V1::CreateImportJobRequest.new(parent: parent, import_job_id: import_job_id, import_job: import_job), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_import_job_client_stub.call_count
      end
    end
  end

  def test_update_crypto_key
    # Create test objects.
    client_result = ::Google::Cloud::Kms::V1::CryptoKey.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    crypto_key = {}
    update_mask = {}

    update_crypto_key_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Kms::V1::KeyManagementService::Rest::ServiceStub.stub :transcode_update_crypto_key_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_crypto_key_client_stub do
        # Create client
        client = ::Google::Cloud::Kms::V1::KeyManagementService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_crypto_key({ crypto_key: crypto_key, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_crypto_key crypto_key: crypto_key, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_crypto_key ::Google::Cloud::Kms::V1::UpdateCryptoKeyRequest.new(crypto_key: crypto_key, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_crypto_key({ crypto_key: crypto_key, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_crypto_key(::Google::Cloud::Kms::V1::UpdateCryptoKeyRequest.new(crypto_key: crypto_key, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_crypto_key_client_stub.call_count
      end
    end
  end

  def test_update_crypto_key_version
    # Create test objects.
    client_result = ::Google::Cloud::Kms::V1::CryptoKeyVersion.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    crypto_key_version = {}
    update_mask = {}

    update_crypto_key_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Kms::V1::KeyManagementService::Rest::ServiceStub.stub :transcode_update_crypto_key_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_crypto_key_version_client_stub do
        # Create client
        client = ::Google::Cloud::Kms::V1::KeyManagementService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_crypto_key_version({ crypto_key_version: crypto_key_version, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_crypto_key_version crypto_key_version: crypto_key_version, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_crypto_key_version ::Google::Cloud::Kms::V1::UpdateCryptoKeyVersionRequest.new(crypto_key_version: crypto_key_version, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_crypto_key_version({ crypto_key_version: crypto_key_version, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_crypto_key_version(::Google::Cloud::Kms::V1::UpdateCryptoKeyVersionRequest.new(crypto_key_version: crypto_key_version, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_crypto_key_version_client_stub.call_count
      end
    end
  end

  def test_update_crypto_key_primary_version
    # Create test objects.
    client_result = ::Google::Cloud::Kms::V1::CryptoKey.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    crypto_key_version_id = "hello world"

    update_crypto_key_primary_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Kms::V1::KeyManagementService::Rest::ServiceStub.stub :transcode_update_crypto_key_primary_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_crypto_key_primary_version_client_stub do
        # Create client
        client = ::Google::Cloud::Kms::V1::KeyManagementService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_crypto_key_primary_version({ name: name, crypto_key_version_id: crypto_key_version_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_crypto_key_primary_version name: name, crypto_key_version_id: crypto_key_version_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_crypto_key_primary_version ::Google::Cloud::Kms::V1::UpdateCryptoKeyPrimaryVersionRequest.new(name: name, crypto_key_version_id: crypto_key_version_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_crypto_key_primary_version({ name: name, crypto_key_version_id: crypto_key_version_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_crypto_key_primary_version(::Google::Cloud::Kms::V1::UpdateCryptoKeyPrimaryVersionRequest.new(name: name, crypto_key_version_id: crypto_key_version_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_crypto_key_primary_version_client_stub.call_count
      end
    end
  end

  def test_destroy_crypto_key_version
    # Create test objects.
    client_result = ::Google::Cloud::Kms::V1::CryptoKeyVersion.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    destroy_crypto_key_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Kms::V1::KeyManagementService::Rest::ServiceStub.stub :transcode_destroy_crypto_key_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, destroy_crypto_key_version_client_stub do
        # Create client
        client = ::Google::Cloud::Kms::V1::KeyManagementService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.destroy_crypto_key_version({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.destroy_crypto_key_version name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.destroy_crypto_key_version ::Google::Cloud::Kms::V1::DestroyCryptoKeyVersionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.destroy_crypto_key_version({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.destroy_crypto_key_version(::Google::Cloud::Kms::V1::DestroyCryptoKeyVersionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, destroy_crypto_key_version_client_stub.call_count
      end
    end
  end

  def test_restore_crypto_key_version
    # Create test objects.
    client_result = ::Google::Cloud::Kms::V1::CryptoKeyVersion.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    restore_crypto_key_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Kms::V1::KeyManagementService::Rest::ServiceStub.stub :transcode_restore_crypto_key_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, restore_crypto_key_version_client_stub do
        # Create client
        client = ::Google::Cloud::Kms::V1::KeyManagementService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.restore_crypto_key_version({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.restore_crypto_key_version name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.restore_crypto_key_version ::Google::Cloud::Kms::V1::RestoreCryptoKeyVersionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.restore_crypto_key_version({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.restore_crypto_key_version(::Google::Cloud::Kms::V1::RestoreCryptoKeyVersionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, restore_crypto_key_version_client_stub.call_count
      end
    end
  end

  def test_encrypt
    # Create test objects.
    client_result = ::Google::Cloud::Kms::V1::EncryptResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    plaintext = "hello world"
    additional_authenticated_data = "hello world"
    plaintext_crc32c = {}
    additional_authenticated_data_crc32c = {}

    encrypt_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Kms::V1::KeyManagementService::Rest::ServiceStub.stub :transcode_encrypt_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, encrypt_client_stub do
        # Create client
        client = ::Google::Cloud::Kms::V1::KeyManagementService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.encrypt({ name: name, plaintext: plaintext, additional_authenticated_data: additional_authenticated_data, plaintext_crc32c: plaintext_crc32c, additional_authenticated_data_crc32c: additional_authenticated_data_crc32c }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.encrypt name: name, plaintext: plaintext, additional_authenticated_data: additional_authenticated_data, plaintext_crc32c: plaintext_crc32c, additional_authenticated_data_crc32c: additional_authenticated_data_crc32c do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.encrypt ::Google::Cloud::Kms::V1::EncryptRequest.new(name: name, plaintext: plaintext, additional_authenticated_data: additional_authenticated_data, plaintext_crc32c: plaintext_crc32c, additional_authenticated_data_crc32c: additional_authenticated_data_crc32c) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.encrypt({ name: name, plaintext: plaintext, additional_authenticated_data: additional_authenticated_data, plaintext_crc32c: plaintext_crc32c, additional_authenticated_data_crc32c: additional_authenticated_data_crc32c }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.encrypt(::Google::Cloud::Kms::V1::EncryptRequest.new(name: name, plaintext: plaintext, additional_authenticated_data: additional_authenticated_data, plaintext_crc32c: plaintext_crc32c, additional_authenticated_data_crc32c: additional_authenticated_data_crc32c), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, encrypt_client_stub.call_count
      end
    end
  end

  def test_decrypt
    # Create test objects.
    client_result = ::Google::Cloud::Kms::V1::DecryptResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    ciphertext = "hello world"
    additional_authenticated_data = "hello world"
    ciphertext_crc32c = {}
    additional_authenticated_data_crc32c = {}

    decrypt_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Kms::V1::KeyManagementService::Rest::ServiceStub.stub :transcode_decrypt_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, decrypt_client_stub do
        # Create client
        client = ::Google::Cloud::Kms::V1::KeyManagementService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.decrypt({ name: name, ciphertext: ciphertext, additional_authenticated_data: additional_authenticated_data, ciphertext_crc32c: ciphertext_crc32c, additional_authenticated_data_crc32c: additional_authenticated_data_crc32c }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.decrypt name: name, ciphertext: ciphertext, additional_authenticated_data: additional_authenticated_data, ciphertext_crc32c: ciphertext_crc32c, additional_authenticated_data_crc32c: additional_authenticated_data_crc32c do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.decrypt ::Google::Cloud::Kms::V1::DecryptRequest.new(name: name, ciphertext: ciphertext, additional_authenticated_data: additional_authenticated_data, ciphertext_crc32c: ciphertext_crc32c, additional_authenticated_data_crc32c: additional_authenticated_data_crc32c) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.decrypt({ name: name, ciphertext: ciphertext, additional_authenticated_data: additional_authenticated_data, ciphertext_crc32c: ciphertext_crc32c, additional_authenticated_data_crc32c: additional_authenticated_data_crc32c }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.decrypt(::Google::Cloud::Kms::V1::DecryptRequest.new(name: name, ciphertext: ciphertext, additional_authenticated_data: additional_authenticated_data, ciphertext_crc32c: ciphertext_crc32c, additional_authenticated_data_crc32c: additional_authenticated_data_crc32c), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, decrypt_client_stub.call_count
      end
    end
  end

  def test_raw_encrypt
    # Create test objects.
    client_result = ::Google::Cloud::Kms::V1::RawEncryptResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    plaintext = "hello world"
    additional_authenticated_data = "hello world"
    plaintext_crc32c = {}
    additional_authenticated_data_crc32c = {}
    initialization_vector = "hello world"
    initialization_vector_crc32c = {}

    raw_encrypt_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Kms::V1::KeyManagementService::Rest::ServiceStub.stub :transcode_raw_encrypt_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, raw_encrypt_client_stub do
        # Create client
        client = ::Google::Cloud::Kms::V1::KeyManagementService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.raw_encrypt({ name: name, plaintext: plaintext, additional_authenticated_data: additional_authenticated_data, plaintext_crc32c: plaintext_crc32c, additional_authenticated_data_crc32c: additional_authenticated_data_crc32c, initialization_vector: initialization_vector, initialization_vector_crc32c: initialization_vector_crc32c }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.raw_encrypt name: name, plaintext: plaintext, additional_authenticated_data: additional_authenticated_data, plaintext_crc32c: plaintext_crc32c, additional_authenticated_data_crc32c: additional_authenticated_data_crc32c, initialization_vector: initialization_vector, initialization_vector_crc32c: initialization_vector_crc32c do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.raw_encrypt ::Google::Cloud::Kms::V1::RawEncryptRequest.new(name: name, plaintext: plaintext, additional_authenticated_data: additional_authenticated_data, plaintext_crc32c: plaintext_crc32c, additional_authenticated_data_crc32c: additional_authenticated_data_crc32c, initialization_vector: initialization_vector, initialization_vector_crc32c: initialization_vector_crc32c) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.raw_encrypt({ name: name, plaintext: plaintext, additional_authenticated_data: additional_authenticated_data, plaintext_crc32c: plaintext_crc32c, additional_authenticated_data_crc32c: additional_authenticated_data_crc32c, initialization_vector: initialization_vector, initialization_vector_crc32c: initialization_vector_crc32c }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.raw_encrypt(::Google::Cloud::Kms::V1::RawEncryptRequest.new(name: name, plaintext: plaintext, additional_authenticated_data: additional_authenticated_data, plaintext_crc32c: plaintext_crc32c, additional_authenticated_data_crc32c: additional_authenticated_data_crc32c, initialization_vector: initialization_vector, initialization_vector_crc32c: initialization_vector_crc32c), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, raw_encrypt_client_stub.call_count
      end
    end
  end

  def test_raw_decrypt
    # Create test objects.
    client_result = ::Google::Cloud::Kms::V1::RawDecryptResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    ciphertext = "hello world"
    additional_authenticated_data = "hello world"
    initialization_vector = "hello world"
    tag_length = 42
    ciphertext_crc32c = {}
    additional_authenticated_data_crc32c = {}
    initialization_vector_crc32c = {}

    raw_decrypt_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Kms::V1::KeyManagementService::Rest::ServiceStub.stub :transcode_raw_decrypt_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, raw_decrypt_client_stub do
        # Create client
        client = ::Google::Cloud::Kms::V1::KeyManagementService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.raw_decrypt({ name: name, ciphertext: ciphertext, additional_authenticated_data: additional_authenticated_data, initialization_vector: initialization_vector, tag_length: tag_length, ciphertext_crc32c: ciphertext_crc32c, additional_authenticated_data_crc32c: additional_authenticated_data_crc32c, initialization_vector_crc32c: initialization_vector_crc32c }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.raw_decrypt name: name, ciphertext: ciphertext, additional_authenticated_data: additional_authenticated_data, initialization_vector: initialization_vector, tag_length: tag_length, ciphertext_crc32c: ciphertext_crc32c, additional_authenticated_data_crc32c: additional_authenticated_data_crc32c, initialization_vector_crc32c: initialization_vector_crc32c do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.raw_decrypt ::Google::Cloud::Kms::V1::RawDecryptRequest.new(name: name, ciphertext: ciphertext, additional_authenticated_data: additional_authenticated_data, initialization_vector: initialization_vector, tag_length: tag_length, ciphertext_crc32c: ciphertext_crc32c, additional_authenticated_data_crc32c: additional_authenticated_data_crc32c, initialization_vector_crc32c: initialization_vector_crc32c) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.raw_decrypt({ name: name, ciphertext: ciphertext, additional_authenticated_data: additional_authenticated_data, initialization_vector: initialization_vector, tag_length: tag_length, ciphertext_crc32c: ciphertext_crc32c, additional_authenticated_data_crc32c: additional_authenticated_data_crc32c, initialization_vector_crc32c: initialization_vector_crc32c }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.raw_decrypt(::Google::Cloud::Kms::V1::RawDecryptRequest.new(name: name, ciphertext: ciphertext, additional_authenticated_data: additional_authenticated_data, initialization_vector: initialization_vector, tag_length: tag_length, ciphertext_crc32c: ciphertext_crc32c, additional_authenticated_data_crc32c: additional_authenticated_data_crc32c, initialization_vector_crc32c: initialization_vector_crc32c), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, raw_decrypt_client_stub.call_count
      end
    end
  end

  def test_asymmetric_sign
    # Create test objects.
    client_result = ::Google::Cloud::Kms::V1::AsymmetricSignResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    digest = {}
    digest_crc32c = {}
    data = "hello world"
    data_crc32c = {}

    asymmetric_sign_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Kms::V1::KeyManagementService::Rest::ServiceStub.stub :transcode_asymmetric_sign_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, asymmetric_sign_client_stub do
        # Create client
        client = ::Google::Cloud::Kms::V1::KeyManagementService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.asymmetric_sign({ name: name, digest: digest, digest_crc32c: digest_crc32c, data: data, data_crc32c: data_crc32c }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.asymmetric_sign name: name, digest: digest, digest_crc32c: digest_crc32c, data: data, data_crc32c: data_crc32c do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.asymmetric_sign ::Google::Cloud::Kms::V1::AsymmetricSignRequest.new(name: name, digest: digest, digest_crc32c: digest_crc32c, data: data, data_crc32c: data_crc32c) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.asymmetric_sign({ name: name, digest: digest, digest_crc32c: digest_crc32c, data: data, data_crc32c: data_crc32c }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.asymmetric_sign(::Google::Cloud::Kms::V1::AsymmetricSignRequest.new(name: name, digest: digest, digest_crc32c: digest_crc32c, data: data, data_crc32c: data_crc32c), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, asymmetric_sign_client_stub.call_count
      end
    end
  end

  def test_asymmetric_decrypt
    # Create test objects.
    client_result = ::Google::Cloud::Kms::V1::AsymmetricDecryptResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    ciphertext = "hello world"
    ciphertext_crc32c = {}

    asymmetric_decrypt_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Kms::V1::KeyManagementService::Rest::ServiceStub.stub :transcode_asymmetric_decrypt_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, asymmetric_decrypt_client_stub do
        # Create client
        client = ::Google::Cloud::Kms::V1::KeyManagementService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.asymmetric_decrypt({ name: name, ciphertext: ciphertext, ciphertext_crc32c: ciphertext_crc32c }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.asymmetric_decrypt name: name, ciphertext: ciphertext, ciphertext_crc32c: ciphertext_crc32c do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.asymmetric_decrypt ::Google::Cloud::Kms::V1::AsymmetricDecryptRequest.new(name: name, ciphertext: ciphertext, ciphertext_crc32c: ciphertext_crc32c) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.asymmetric_decrypt({ name: name, ciphertext: ciphertext, ciphertext_crc32c: ciphertext_crc32c }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.asymmetric_decrypt(::Google::Cloud::Kms::V1::AsymmetricDecryptRequest.new(name: name, ciphertext: ciphertext, ciphertext_crc32c: ciphertext_crc32c), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, asymmetric_decrypt_client_stub.call_count
      end
    end
  end

  def test_mac_sign
    # Create test objects.
    client_result = ::Google::Cloud::Kms::V1::MacSignResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    data = "hello world"
    data_crc32c = {}

    mac_sign_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Kms::V1::KeyManagementService::Rest::ServiceStub.stub :transcode_mac_sign_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, mac_sign_client_stub do
        # Create client
        client = ::Google::Cloud::Kms::V1::KeyManagementService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.mac_sign({ name: name, data: data, data_crc32c: data_crc32c }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.mac_sign name: name, data: data, data_crc32c: data_crc32c do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.mac_sign ::Google::Cloud::Kms::V1::MacSignRequest.new(name: name, data: data, data_crc32c: data_crc32c) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.mac_sign({ name: name, data: data, data_crc32c: data_crc32c }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.mac_sign(::Google::Cloud::Kms::V1::MacSignRequest.new(name: name, data: data, data_crc32c: data_crc32c), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, mac_sign_client_stub.call_count
      end
    end
  end

  def test_mac_verify
    # Create test objects.
    client_result = ::Google::Cloud::Kms::V1::MacVerifyResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    data = "hello world"
    data_crc32c = {}
    mac = "hello world"
    mac_crc32c = {}

    mac_verify_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Kms::V1::KeyManagementService::Rest::ServiceStub.stub :transcode_mac_verify_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, mac_verify_client_stub do
        # Create client
        client = ::Google::Cloud::Kms::V1::KeyManagementService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.mac_verify({ name: name, data: data, data_crc32c: data_crc32c, mac: mac, mac_crc32c: mac_crc32c }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.mac_verify name: name, data: data, data_crc32c: data_crc32c, mac: mac, mac_crc32c: mac_crc32c do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.mac_verify ::Google::Cloud::Kms::V1::MacVerifyRequest.new(name: name, data: data, data_crc32c: data_crc32c, mac: mac, mac_crc32c: mac_crc32c) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.mac_verify({ name: name, data: data, data_crc32c: data_crc32c, mac: mac, mac_crc32c: mac_crc32c }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.mac_verify(::Google::Cloud::Kms::V1::MacVerifyRequest.new(name: name, data: data, data_crc32c: data_crc32c, mac: mac, mac_crc32c: mac_crc32c), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, mac_verify_client_stub.call_count
      end
    end
  end

  def test_decapsulate
    # Create test objects.
    client_result = ::Google::Cloud::Kms::V1::DecapsulateResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    ciphertext = "hello world"
    ciphertext_crc32c = {}

    decapsulate_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Kms::V1::KeyManagementService::Rest::ServiceStub.stub :transcode_decapsulate_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, decapsulate_client_stub do
        # Create client
        client = ::Google::Cloud::Kms::V1::KeyManagementService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.decapsulate({ name: name, ciphertext: ciphertext, ciphertext_crc32c: ciphertext_crc32c }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.decapsulate name: name, ciphertext: ciphertext, ciphertext_crc32c: ciphertext_crc32c do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.decapsulate ::Google::Cloud::Kms::V1::DecapsulateRequest.new(name: name, ciphertext: ciphertext, ciphertext_crc32c: ciphertext_crc32c) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.decapsulate({ name: name, ciphertext: ciphertext, ciphertext_crc32c: ciphertext_crc32c }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.decapsulate(::Google::Cloud::Kms::V1::DecapsulateRequest.new(name: name, ciphertext: ciphertext, ciphertext_crc32c: ciphertext_crc32c), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, decapsulate_client_stub.call_count
      end
    end
  end

  def test_generate_random_bytes
    # Create test objects.
    client_result = ::Google::Cloud::Kms::V1::GenerateRandomBytesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    location = "hello world"
    length_bytes = 42
    protection_level = :PROTECTION_LEVEL_UNSPECIFIED

    generate_random_bytes_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Kms::V1::KeyManagementService::Rest::ServiceStub.stub :transcode_generate_random_bytes_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, generate_random_bytes_client_stub do
        # Create client
        client = ::Google::Cloud::Kms::V1::KeyManagementService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.generate_random_bytes({ location: location, length_bytes: length_bytes, protection_level: protection_level }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.generate_random_bytes location: location, length_bytes: length_bytes, protection_level: protection_level do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.generate_random_bytes ::Google::Cloud::Kms::V1::GenerateRandomBytesRequest.new(location: location, length_bytes: length_bytes, protection_level: protection_level) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.generate_random_bytes({ location: location, length_bytes: length_bytes, protection_level: protection_level }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.generate_random_bytes(::Google::Cloud::Kms::V1::GenerateRandomBytesRequest.new(location: location, length_bytes: length_bytes, protection_level: protection_level), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, generate_random_bytes_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Kms::V1::KeyManagementService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Kms::V1::KeyManagementService::Rest::Client::Configuration, config
  end
end
