# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/kms/v1/ekm_service_pb"
require "google/cloud/kms/v1/ekm_service"

class ::Google::Cloud::Kms::V1::EkmService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_ekm_connections
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Kms::V1::ListEkmConnectionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_ekm_connections_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_ekm_connections, name
      assert_kind_of ::Google::Cloud::Kms::V1::ListEkmConnectionsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_ekm_connections_client_stub do
      # Create client
      client = ::Google::Cloud::Kms::V1::EkmService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_ekm_connections({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_ekm_connections parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_ekm_connections ::Google::Cloud::Kms::V1::ListEkmConnectionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_ekm_connections({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_ekm_connections(::Google::Cloud::Kms::V1::ListEkmConnectionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_ekm_connections_client_stub.call_rpc_count
    end
  end

  def test_get_ekm_connection
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Kms::V1::EkmConnection.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_ekm_connection_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_ekm_connection, name
      assert_kind_of ::Google::Cloud::Kms::V1::GetEkmConnectionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_ekm_connection_client_stub do
      # Create client
      client = ::Google::Cloud::Kms::V1::EkmService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_ekm_connection({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_ekm_connection name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_ekm_connection ::Google::Cloud::Kms::V1::GetEkmConnectionRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_ekm_connection({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_ekm_connection(::Google::Cloud::Kms::V1::GetEkmConnectionRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_ekm_connection_client_stub.call_rpc_count
    end
  end

  def test_create_ekm_connection
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Kms::V1::EkmConnection.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    ekm_connection_id = "hello world"
    ekm_connection = {}

    create_ekm_connection_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_ekm_connection, name
      assert_kind_of ::Google::Cloud::Kms::V1::CreateEkmConnectionRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["ekm_connection_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Kms::V1::EkmConnection), request["ekm_connection"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_ekm_connection_client_stub do
      # Create client
      client = ::Google::Cloud::Kms::V1::EkmService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_ekm_connection({ parent: parent, ekm_connection_id: ekm_connection_id, ekm_connection: ekm_connection }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_ekm_connection parent: parent, ekm_connection_id: ekm_connection_id, ekm_connection: ekm_connection do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_ekm_connection ::Google::Cloud::Kms::V1::CreateEkmConnectionRequest.new(parent: parent, ekm_connection_id: ekm_connection_id, ekm_connection: ekm_connection) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_ekm_connection({ parent: parent, ekm_connection_id: ekm_connection_id, ekm_connection: ekm_connection }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_ekm_connection(::Google::Cloud::Kms::V1::CreateEkmConnectionRequest.new(parent: parent, ekm_connection_id: ekm_connection_id, ekm_connection: ekm_connection), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_ekm_connection_client_stub.call_rpc_count
    end
  end

  def test_update_ekm_connection
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Kms::V1::EkmConnection.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    ekm_connection = {}
    update_mask = {}

    update_ekm_connection_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_ekm_connection, name
      assert_kind_of ::Google::Cloud::Kms::V1::UpdateEkmConnectionRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Kms::V1::EkmConnection), request["ekm_connection"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_ekm_connection_client_stub do
      # Create client
      client = ::Google::Cloud::Kms::V1::EkmService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_ekm_connection({ ekm_connection: ekm_connection, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_ekm_connection ekm_connection: ekm_connection, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_ekm_connection ::Google::Cloud::Kms::V1::UpdateEkmConnectionRequest.new(ekm_connection: ekm_connection, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_ekm_connection({ ekm_connection: ekm_connection, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_ekm_connection(::Google::Cloud::Kms::V1::UpdateEkmConnectionRequest.new(ekm_connection: ekm_connection, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_ekm_connection_client_stub.call_rpc_count
    end
  end

  def test_get_ekm_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Kms::V1::EkmConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_ekm_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_ekm_config, name
      assert_kind_of ::Google::Cloud::Kms::V1::GetEkmConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_ekm_config_client_stub do
      # Create client
      client = ::Google::Cloud::Kms::V1::EkmService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_ekm_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_ekm_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_ekm_config ::Google::Cloud::Kms::V1::GetEkmConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_ekm_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_ekm_config(::Google::Cloud::Kms::V1::GetEkmConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_ekm_config_client_stub.call_rpc_count
    end
  end

  def test_update_ekm_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Kms::V1::EkmConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    ekm_config = {}
    update_mask = {}

    update_ekm_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_ekm_config, name
      assert_kind_of ::Google::Cloud::Kms::V1::UpdateEkmConfigRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Kms::V1::EkmConfig), request["ekm_config"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_ekm_config_client_stub do
      # Create client
      client = ::Google::Cloud::Kms::V1::EkmService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_ekm_config({ ekm_config: ekm_config, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_ekm_config ekm_config: ekm_config, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_ekm_config ::Google::Cloud::Kms::V1::UpdateEkmConfigRequest.new(ekm_config: ekm_config, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_ekm_config({ ekm_config: ekm_config, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_ekm_config(::Google::Cloud::Kms::V1::UpdateEkmConfigRequest.new(ekm_config: ekm_config, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_ekm_config_client_stub.call_rpc_count
    end
  end

  def test_verify_connectivity
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Kms::V1::VerifyConnectivityResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    verify_connectivity_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :verify_connectivity, name
      assert_kind_of ::Google::Cloud::Kms::V1::VerifyConnectivityRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, verify_connectivity_client_stub do
      # Create client
      client = ::Google::Cloud::Kms::V1::EkmService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.verify_connectivity({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.verify_connectivity name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.verify_connectivity ::Google::Cloud::Kms::V1::VerifyConnectivityRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.verify_connectivity({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.verify_connectivity(::Google::Cloud::Kms::V1::VerifyConnectivityRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, verify_connectivity_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Kms::V1::EkmService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Kms::V1::EkmService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Kms::V1::EkmService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Kms::V1::EkmService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
