# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/kms/v1/autokey_admin_pb"
require "google/cloud/kms/v1/autokey_admin"

class ::Google::Cloud::Kms::V1::AutokeyAdmin::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_update_autokey_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Kms::V1::AutokeyConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    autokey_config = {}
    update_mask = {}

    update_autokey_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_autokey_config, name
      assert_kind_of ::Google::Cloud::Kms::V1::UpdateAutokeyConfigRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Kms::V1::AutokeyConfig), request["autokey_config"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_autokey_config_client_stub do
      # Create client
      client = ::Google::Cloud::Kms::V1::AutokeyAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_autokey_config({ autokey_config: autokey_config, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_autokey_config autokey_config: autokey_config, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_autokey_config ::Google::Cloud::Kms::V1::UpdateAutokeyConfigRequest.new(autokey_config: autokey_config, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_autokey_config({ autokey_config: autokey_config, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_autokey_config(::Google::Cloud::Kms::V1::UpdateAutokeyConfigRequest.new(autokey_config: autokey_config, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_autokey_config_client_stub.call_rpc_count
    end
  end

  def test_get_autokey_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Kms::V1::AutokeyConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_autokey_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_autokey_config, name
      assert_kind_of ::Google::Cloud::Kms::V1::GetAutokeyConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_autokey_config_client_stub do
      # Create client
      client = ::Google::Cloud::Kms::V1::AutokeyAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_autokey_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_autokey_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_autokey_config ::Google::Cloud::Kms::V1::GetAutokeyConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_autokey_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_autokey_config(::Google::Cloud::Kms::V1::GetAutokeyConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_autokey_config_client_stub.call_rpc_count
    end
  end

  def test_show_effective_autokey_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Kms::V1::ShowEffectiveAutokeyConfigResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"

    show_effective_autokey_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :show_effective_autokey_config, name
      assert_kind_of ::Google::Cloud::Kms::V1::ShowEffectiveAutokeyConfigRequest, request
      assert_equal "hello world", request["parent"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, show_effective_autokey_config_client_stub do
      # Create client
      client = ::Google::Cloud::Kms::V1::AutokeyAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.show_effective_autokey_config({ parent: parent }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.show_effective_autokey_config parent: parent do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.show_effective_autokey_config ::Google::Cloud::Kms::V1::ShowEffectiveAutokeyConfigRequest.new(parent: parent) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.show_effective_autokey_config({ parent: parent }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.show_effective_autokey_config(::Google::Cloud::Kms::V1::ShowEffectiveAutokeyConfigRequest.new(parent: parent), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, show_effective_autokey_config_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Kms::V1::AutokeyAdmin::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Kms::V1::AutokeyAdmin::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Kms::V1::AutokeyAdmin::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Kms::V1::AutokeyAdmin::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
