# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Kms
      module V1
        # Request message for
        # {::Google::Cloud::Kms::V1::KeyManagementService::Client#list_key_rings KeyManagementService.ListKeyRings}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the location associated with the
        #     {::Google::Cloud::Kms::V1::KeyRing KeyRings}, in the format
        #     `projects/*/locations/*`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Optional limit on the number of
        #     {::Google::Cloud::Kms::V1::KeyRing KeyRings} to include in the response. Further
        #     {::Google::Cloud::Kms::V1::KeyRing KeyRings} can subsequently be obtained by
        #     including the
        #     {::Google::Cloud::Kms::V1::ListKeyRingsResponse#next_page_token ListKeyRingsResponse.next_page_token}
        #     in a subsequent request.  If unspecified, the server will pick an
        #     appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Optional pagination token, returned earlier via
        #     {::Google::Cloud::Kms::V1::ListKeyRingsResponse#next_page_token ListKeyRingsResponse.next_page_token}.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Only include resources that match the filter in the response. For
        #     more information, see
        #     [Sorting and filtering list
        #     results](https://cloud.google.com/kms/docs/sorting-and-filtering).
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Specify how the results should be sorted. If not specified, the
        #     results will be sorted in the default order.  For more information, see
        #     [Sorting and filtering list
        #     results](https://cloud.google.com/kms/docs/sorting-and-filtering).
        class ListKeyRingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Kms::V1::KeyManagementService::Client#list_crypto_keys KeyManagementService.ListCryptoKeys}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the {::Google::Cloud::Kms::V1::KeyRing KeyRing}
        #     to list, in the format `projects/*/locations/*/keyRings/*`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Optional limit on the number of
        #     {::Google::Cloud::Kms::V1::CryptoKey CryptoKeys} to include in the response.
        #     Further {::Google::Cloud::Kms::V1::CryptoKey CryptoKeys} can subsequently be
        #     obtained by including the
        #     {::Google::Cloud::Kms::V1::ListCryptoKeysResponse#next_page_token ListCryptoKeysResponse.next_page_token}
        #     in a subsequent request.  If unspecified, the server will pick an
        #     appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Optional pagination token, returned earlier via
        #     {::Google::Cloud::Kms::V1::ListCryptoKeysResponse#next_page_token ListCryptoKeysResponse.next_page_token}.
        # @!attribute [rw] version_view
        #   @return [::Google::Cloud::Kms::V1::CryptoKeyVersion::CryptoKeyVersionView]
        #     The fields of the primary version to include in the response.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Only include resources that match the filter in the response. For
        #     more information, see
        #     [Sorting and filtering list
        #     results](https://cloud.google.com/kms/docs/sorting-and-filtering).
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Specify how the results should be sorted. If not specified, the
        #     results will be sorted in the default order. For more information, see
        #     [Sorting and filtering list
        #     results](https://cloud.google.com/kms/docs/sorting-and-filtering).
        class ListCryptoKeysRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Kms::V1::KeyManagementService::Client#list_crypto_key_versions KeyManagementService.ListCryptoKeyVersions}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the
        #     {::Google::Cloud::Kms::V1::CryptoKey CryptoKey} to list, in the format
        #     `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Optional limit on the number of
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersions} to include in the
        #     response. Further {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersions}
        #     can subsequently be obtained by including the
        #     {::Google::Cloud::Kms::V1::ListCryptoKeyVersionsResponse#next_page_token ListCryptoKeyVersionsResponse.next_page_token}
        #     in a subsequent request. If unspecified, the server will pick an
        #     appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Optional pagination token, returned earlier via
        #     {::Google::Cloud::Kms::V1::ListCryptoKeyVersionsResponse#next_page_token ListCryptoKeyVersionsResponse.next_page_token}.
        # @!attribute [rw] view
        #   @return [::Google::Cloud::Kms::V1::CryptoKeyVersion::CryptoKeyVersionView]
        #     The fields to include in the response.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Only include resources that match the filter in the response. For
        #     more information, see
        #     [Sorting and filtering list
        #     results](https://cloud.google.com/kms/docs/sorting-and-filtering).
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Specify how the results should be sorted. If not specified, the
        #     results will be sorted in the default order. For more information, see
        #     [Sorting and filtering list
        #     results](https://cloud.google.com/kms/docs/sorting-and-filtering).
        class ListCryptoKeyVersionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Kms::V1::KeyManagementService::Client#list_import_jobs KeyManagementService.ListImportJobs}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the {::Google::Cloud::Kms::V1::KeyRing KeyRing}
        #     to list, in the format `projects/*/locations/*/keyRings/*`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Optional limit on the number of
        #     {::Google::Cloud::Kms::V1::ImportJob ImportJobs} to include in the response.
        #     Further {::Google::Cloud::Kms::V1::ImportJob ImportJobs} can subsequently be
        #     obtained by including the
        #     {::Google::Cloud::Kms::V1::ListImportJobsResponse#next_page_token ListImportJobsResponse.next_page_token}
        #     in a subsequent request. If unspecified, the server will pick an
        #     appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Optional pagination token, returned earlier via
        #     {::Google::Cloud::Kms::V1::ListImportJobsResponse#next_page_token ListImportJobsResponse.next_page_token}.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Only include resources that match the filter in the response. For
        #     more information, see
        #     [Sorting and filtering list
        #     results](https://cloud.google.com/kms/docs/sorting-and-filtering).
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Specify how the results should be sorted. If not specified, the
        #     results will be sorted in the default order. For more information, see
        #     [Sorting and filtering list
        #     results](https://cloud.google.com/kms/docs/sorting-and-filtering).
        class ListImportJobsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Kms::V1::KeyManagementService::Client#list_key_rings KeyManagementService.ListKeyRings}.
        # @!attribute [rw] key_rings
        #   @return [::Array<::Google::Cloud::Kms::V1::KeyRing>]
        #     The list of {::Google::Cloud::Kms::V1::KeyRing KeyRings}.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token to retrieve next page of results. Pass this value in
        #     {::Google::Cloud::Kms::V1::ListKeyRingsRequest#page_token ListKeyRingsRequest.page_token}
        #     to retrieve the next page of results.
        # @!attribute [rw] total_size
        #   @return [::Integer]
        #     The total number of {::Google::Cloud::Kms::V1::KeyRing KeyRings} that matched
        #     the query.
        #
        #     This field is not populated if
        #     {::Google::Cloud::Kms::V1::ListKeyRingsRequest#filter ListKeyRingsRequest.filter}
        #     is applied.
        class ListKeyRingsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Kms::V1::KeyManagementService::Client#list_crypto_keys KeyManagementService.ListCryptoKeys}.
        # @!attribute [rw] crypto_keys
        #   @return [::Array<::Google::Cloud::Kms::V1::CryptoKey>]
        #     The list of {::Google::Cloud::Kms::V1::CryptoKey CryptoKeys}.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token to retrieve next page of results. Pass this value in
        #     {::Google::Cloud::Kms::V1::ListCryptoKeysRequest#page_token ListCryptoKeysRequest.page_token}
        #     to retrieve the next page of results.
        # @!attribute [rw] total_size
        #   @return [::Integer]
        #     The total number of {::Google::Cloud::Kms::V1::CryptoKey CryptoKeys} that
        #     matched the query.
        #
        #     This field is not populated if
        #     {::Google::Cloud::Kms::V1::ListCryptoKeysRequest#filter ListCryptoKeysRequest.filter}
        #     is applied.
        class ListCryptoKeysResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Kms::V1::KeyManagementService::Client#list_crypto_key_versions KeyManagementService.ListCryptoKeyVersions}.
        # @!attribute [rw] crypto_key_versions
        #   @return [::Array<::Google::Cloud::Kms::V1::CryptoKeyVersion>]
        #     The list of {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersions}.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token to retrieve next page of results. Pass this value in
        #     {::Google::Cloud::Kms::V1::ListCryptoKeyVersionsRequest#page_token ListCryptoKeyVersionsRequest.page_token}
        #     to retrieve the next page of results.
        # @!attribute [rw] total_size
        #   @return [::Integer]
        #     The total number of
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersions} that matched the
        #     query.
        #
        #     This field is not populated if
        #     {::Google::Cloud::Kms::V1::ListCryptoKeyVersionsRequest#filter ListCryptoKeyVersionsRequest.filter}
        #     is applied.
        class ListCryptoKeyVersionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Kms::V1::KeyManagementService::Client#list_import_jobs KeyManagementService.ListImportJobs}.
        # @!attribute [rw] import_jobs
        #   @return [::Array<::Google::Cloud::Kms::V1::ImportJob>]
        #     The list of {::Google::Cloud::Kms::V1::ImportJob ImportJobs}.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token to retrieve next page of results. Pass this value in
        #     {::Google::Cloud::Kms::V1::ListImportJobsRequest#page_token ListImportJobsRequest.page_token}
        #     to retrieve the next page of results.
        # @!attribute [rw] total_size
        #   @return [::Integer]
        #     The total number of {::Google::Cloud::Kms::V1::ImportJob ImportJobs} that
        #     matched the query.
        #
        #     This field is not populated if
        #     {::Google::Cloud::Kms::V1::ListImportJobsRequest#filter ListImportJobsRequest.filter}
        #     is applied.
        class ListImportJobsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Kms::V1::KeyManagementService::Client#get_key_ring KeyManagementService.GetKeyRing}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The {::Google::Cloud::Kms::V1::KeyRing#name name} of the
        #     {::Google::Cloud::Kms::V1::KeyRing KeyRing} to get.
        class GetKeyRingRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Kms::V1::KeyManagementService::Client#get_crypto_key KeyManagementService.GetCryptoKey}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The {::Google::Cloud::Kms::V1::CryptoKey#name name} of the
        #     {::Google::Cloud::Kms::V1::CryptoKey CryptoKey} to get.
        class GetCryptoKeyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Kms::V1::KeyManagementService::Client#get_crypto_key_version KeyManagementService.GetCryptoKeyVersion}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The {::Google::Cloud::Kms::V1::CryptoKeyVersion#name name} of the
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} to get.
        class GetCryptoKeyVersionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Kms::V1::KeyManagementService::Client#get_public_key KeyManagementService.GetPublicKey}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The {::Google::Cloud::Kms::V1::CryptoKeyVersion#name name} of the
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} public key to get.
        # @!attribute [rw] public_key_format
        #   @return [::Google::Cloud::Kms::V1::PublicKey::PublicKeyFormat]
        #     Optional. The {::Google::Cloud::Kms::V1::PublicKey PublicKey} format specified
        #     by the user. This field is required for PQC algorithms. If specified, the
        #     public key will be exported through the
        #     {::Google::Cloud::Kms::V1::PublicKey#public_key public_key} field in the
        #     requested format. Otherwise, the {::Google::Cloud::Kms::V1::PublicKey#pem pem}
        #     field will be populated for non-PQC algorithms, and an error will be
        #     returned for PQC algorithms.
        class GetPublicKeyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Kms::V1::KeyManagementService::Client#get_import_job KeyManagementService.GetImportJob}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The {::Google::Cloud::Kms::V1::ImportJob#name name} of the
        #     {::Google::Cloud::Kms::V1::ImportJob ImportJob} to get.
        class GetImportJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Kms::V1::KeyManagementService::Client#create_key_ring KeyManagementService.CreateKeyRing}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the location associated with the
        #     {::Google::Cloud::Kms::V1::KeyRing KeyRings}, in the format
        #     `projects/*/locations/*`.
        # @!attribute [rw] key_ring_id
        #   @return [::String]
        #     Required. It must be unique within a location and match the regular
        #     expression `[a-zA-Z0-9_-]{1,63}`
        # @!attribute [rw] key_ring
        #   @return [::Google::Cloud::Kms::V1::KeyRing]
        #     Required. A {::Google::Cloud::Kms::V1::KeyRing KeyRing} with initial field
        #     values.
        class CreateKeyRingRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Kms::V1::KeyManagementService::Client#create_crypto_key KeyManagementService.CreateCryptoKey}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The {::Google::Cloud::Kms::V1::KeyRing#name name} of the KeyRing
        #     associated with the {::Google::Cloud::Kms::V1::CryptoKey CryptoKeys}.
        # @!attribute [rw] crypto_key_id
        #   @return [::String]
        #     Required. It must be unique within a KeyRing and match the regular
        #     expression `[a-zA-Z0-9_-]{1,63}`
        # @!attribute [rw] crypto_key
        #   @return [::Google::Cloud::Kms::V1::CryptoKey]
        #     Required. A {::Google::Cloud::Kms::V1::CryptoKey CryptoKey} with initial field
        #     values.
        # @!attribute [rw] skip_initial_version_creation
        #   @return [::Boolean]
        #     If set to true, the request will create a
        #     {::Google::Cloud::Kms::V1::CryptoKey CryptoKey} without any
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersions}. You must
        #     manually call
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client#create_crypto_key_version CreateCryptoKeyVersion}
        #     or
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client#import_crypto_key_version ImportCryptoKeyVersion}
        #     before you can use this {::Google::Cloud::Kms::V1::CryptoKey CryptoKey}.
        class CreateCryptoKeyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Kms::V1::KeyManagementService::Client#create_crypto_key_version KeyManagementService.CreateCryptoKeyVersion}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The {::Google::Cloud::Kms::V1::CryptoKey#name name} of the
        #     {::Google::Cloud::Kms::V1::CryptoKey CryptoKey} associated with the
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersions}.
        # @!attribute [rw] crypto_key_version
        #   @return [::Google::Cloud::Kms::V1::CryptoKeyVersion]
        #     Required. A {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} with
        #     initial field values.
        class CreateCryptoKeyVersionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Kms::V1::KeyManagementService::Client#import_crypto_key_version KeyManagementService.ImportCryptoKeyVersion}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The {::Google::Cloud::Kms::V1::CryptoKey#name name} of the
        #     {::Google::Cloud::Kms::V1::CryptoKey CryptoKey} to be imported into.
        #
        #     The create permission is only required on this key when creating a new
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion}.
        # @!attribute [rw] crypto_key_version
        #   @return [::String]
        #     Optional. The optional {::Google::Cloud::Kms::V1::CryptoKeyVersion#name name} of
        #     an existing {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} to
        #     target for an import operation. If this field is not present, a new
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} containing the
        #     supplied key material is created.
        #
        #     If this field is present, the supplied key material is imported into
        #     the existing {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion}. To
        #     import into an existing
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion}, the
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} must be a child of
        #     {::Google::Cloud::Kms::V1::ImportCryptoKeyVersionRequest#parent ImportCryptoKeyVersionRequest.parent},
        #     have been previously created via
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client#import_crypto_key_version ImportCryptoKeyVersion},
        #     and be in
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion::CryptoKeyVersionState::DESTROYED DESTROYED}
        #     or
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion::CryptoKeyVersionState::IMPORT_FAILED IMPORT_FAILED}
        #     state. The key material and algorithm must match the previous
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} exactly if the
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} has ever contained
        #     key material.
        # @!attribute [rw] algorithm
        #   @return [::Google::Cloud::Kms::V1::CryptoKeyVersion::CryptoKeyVersionAlgorithm]
        #     Required. The
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion::CryptoKeyVersionAlgorithm algorithm}
        #     of the key being imported. This does not need to match the
        #     {::Google::Cloud::Kms::V1::CryptoKey#version_template version_template} of the
        #     {::Google::Cloud::Kms::V1::CryptoKey CryptoKey} this version imports into.
        # @!attribute [rw] import_job
        #   @return [::String]
        #     Required. The {::Google::Cloud::Kms::V1::ImportJob#name name} of the
        #     {::Google::Cloud::Kms::V1::ImportJob ImportJob} that was used to wrap this key
        #     material.
        # @!attribute [rw] wrapped_key
        #   @return [::String]
        #     Optional. The wrapped key material to import.
        #
        #     Before wrapping, key material must be formatted. If importing symmetric key
        #     material, the expected key material format is plain bytes. If importing
        #     asymmetric key material, the expected key material format is PKCS#8-encoded
        #     DER (the PrivateKeyInfo structure from RFC 5208).
        #
        #     When wrapping with import methods
        #     ({::Google::Cloud::Kms::V1::ImportJob::ImportMethod::RSA_OAEP_3072_SHA1_AES_256 RSA_OAEP_3072_SHA1_AES_256}
        #     or
        #     {::Google::Cloud::Kms::V1::ImportJob::ImportMethod::RSA_OAEP_4096_SHA1_AES_256 RSA_OAEP_4096_SHA1_AES_256}
        #     or
        #     {::Google::Cloud::Kms::V1::ImportJob::ImportMethod::RSA_OAEP_3072_SHA256_AES_256 RSA_OAEP_3072_SHA256_AES_256}
        #     or
        #     {::Google::Cloud::Kms::V1::ImportJob::ImportMethod::RSA_OAEP_4096_SHA256_AES_256 RSA_OAEP_4096_SHA256_AES_256}),
        #
        #     this field must contain the concatenation of:
        #     <ol>
        #       <li>An ephemeral AES-256 wrapping key wrapped with the
        #           {::Google::Cloud::Kms::V1::ImportJob#public_key public_key} using
        #           RSAES-OAEP with SHA-1/SHA-256, MGF1 with SHA-1/SHA-256, and an empty
        #           label.
        #       </li>
        #       <li>The formatted key to be imported, wrapped with the ephemeral AES-256
        #           key using AES-KWP (RFC 5649).
        #       </li>
        #     </ol>
        #
        #     This format is the same as the format produced by PKCS#11 mechanism
        #     CKM_RSA_AES_KEY_WRAP.
        #
        #     When wrapping with import methods
        #     ({::Google::Cloud::Kms::V1::ImportJob::ImportMethod::RSA_OAEP_3072_SHA256 RSA_OAEP_3072_SHA256}
        #     or
        #     {::Google::Cloud::Kms::V1::ImportJob::ImportMethod::RSA_OAEP_4096_SHA256 RSA_OAEP_4096_SHA256}),
        #
        #     this field must contain the formatted key to be imported, wrapped with the
        #     {::Google::Cloud::Kms::V1::ImportJob#public_key public_key} using RSAES-OAEP
        #     with SHA-256, MGF1 with SHA-256, and an empty label.
        # @!attribute [rw] rsa_aes_wrapped_key
        #   @return [::String]
        #     Optional. This field has the same meaning as
        #     {::Google::Cloud::Kms::V1::ImportCryptoKeyVersionRequest#wrapped_key wrapped_key}.
        #     Prefer to use that field in new work. Either that field or this field
        #     (but not both) must be specified.
        class ImportCryptoKeyVersionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Kms::V1::KeyManagementService::Client#create_import_job KeyManagementService.CreateImportJob}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The {::Google::Cloud::Kms::V1::KeyRing#name name} of the
        #     {::Google::Cloud::Kms::V1::KeyRing KeyRing} associated with the
        #     {::Google::Cloud::Kms::V1::ImportJob ImportJobs}.
        # @!attribute [rw] import_job_id
        #   @return [::String]
        #     Required. It must be unique within a KeyRing and match the regular
        #     expression `[a-zA-Z0-9_-]{1,63}`
        # @!attribute [rw] import_job
        #   @return [::Google::Cloud::Kms::V1::ImportJob]
        #     Required. An {::Google::Cloud::Kms::V1::ImportJob ImportJob} with initial field
        #     values.
        class CreateImportJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Kms::V1::KeyManagementService::Client#update_crypto_key KeyManagementService.UpdateCryptoKey}.
        # @!attribute [rw] crypto_key
        #   @return [::Google::Cloud::Kms::V1::CryptoKey]
        #     Required. {::Google::Cloud::Kms::V1::CryptoKey CryptoKey} with updated values.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. List of fields to be updated in this request.
        class UpdateCryptoKeyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Kms::V1::KeyManagementService::Client#update_crypto_key_version KeyManagementService.UpdateCryptoKeyVersion}.
        # @!attribute [rw] crypto_key_version
        #   @return [::Google::Cloud::Kms::V1::CryptoKeyVersion]
        #     Required. {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} with
        #     updated values.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. List of fields to be updated in this request.
        class UpdateCryptoKeyVersionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Kms::V1::KeyManagementService::Client#update_crypto_key_primary_version KeyManagementService.UpdateCryptoKeyPrimaryVersion}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the
        #     {::Google::Cloud::Kms::V1::CryptoKey CryptoKey} to update.
        # @!attribute [rw] crypto_key_version_id
        #   @return [::String]
        #     Required. The id of the child
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} to use as primary.
        class UpdateCryptoKeyPrimaryVersionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Kms::V1::KeyManagementService::Client#destroy_crypto_key_version KeyManagementService.DestroyCryptoKeyVersion}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} to destroy.
        class DestroyCryptoKeyVersionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Kms::V1::KeyManagementService::Client#restore_crypto_key_version KeyManagementService.RestoreCryptoKeyVersion}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} to restore.
        class RestoreCryptoKeyVersionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Kms::V1::KeyManagementService::Client#encrypt KeyManagementService.Encrypt}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the
        #     {::Google::Cloud::Kms::V1::CryptoKey CryptoKey} or
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} to use for
        #     encryption.
        #
        #     If a {::Google::Cloud::Kms::V1::CryptoKey CryptoKey} is specified, the server
        #     will use its {::Google::Cloud::Kms::V1::CryptoKey#primary primary version}.
        # @!attribute [rw] plaintext
        #   @return [::String]
        #     Required. The data to encrypt. Must be no larger than 64KiB.
        #
        #     The maximum size depends on the key version's
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersionTemplate#protection_level protection_level}.
        #     For {::Google::Cloud::Kms::V1::ProtectionLevel::SOFTWARE SOFTWARE},
        #     {::Google::Cloud::Kms::V1::ProtectionLevel::EXTERNAL EXTERNAL}, and
        #     {::Google::Cloud::Kms::V1::ProtectionLevel::EXTERNAL_VPC EXTERNAL_VPC} keys, the
        #     plaintext must be no larger than 64KiB. For
        #     {::Google::Cloud::Kms::V1::ProtectionLevel::HSM HSM} keys, the combined length of
        #     the plaintext and additional_authenticated_data fields must be no larger
        #     than 8KiB.
        # @!attribute [rw] additional_authenticated_data
        #   @return [::String]
        #     Optional. Optional data that, if specified, must also be provided during
        #     decryption through
        #     {::Google::Cloud::Kms::V1::DecryptRequest#additional_authenticated_data DecryptRequest.additional_authenticated_data}.
        #
        #     The maximum size depends on the key version's
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersionTemplate#protection_level protection_level}.
        #     For {::Google::Cloud::Kms::V1::ProtectionLevel::SOFTWARE SOFTWARE},
        #     {::Google::Cloud::Kms::V1::ProtectionLevel::EXTERNAL EXTERNAL}, and
        #     {::Google::Cloud::Kms::V1::ProtectionLevel::EXTERNAL_VPC EXTERNAL_VPC} keys the
        #     AAD must be no larger than 64KiB. For
        #     {::Google::Cloud::Kms::V1::ProtectionLevel::HSM HSM} keys, the combined length of
        #     the plaintext and additional_authenticated_data fields must be no larger
        #     than 8KiB.
        # @!attribute [rw] plaintext_crc32c
        #   @return [::Google::Protobuf::Int64Value]
        #     Optional. An optional CRC32C checksum of the
        #     {::Google::Cloud::Kms::V1::EncryptRequest#plaintext EncryptRequest.plaintext}.
        #     If specified,
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
        #     verify the integrity of the received
        #     {::Google::Cloud::Kms::V1::EncryptRequest#plaintext EncryptRequest.plaintext}
        #     using this checksum.
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
        #     report an error if the checksum verification fails. If you receive a
        #     checksum error, your client should verify that
        #     CRC32C({::Google::Cloud::Kms::V1::EncryptRequest#plaintext EncryptRequest.plaintext})
        #     is equal to
        #     {::Google::Cloud::Kms::V1::EncryptRequest#plaintext_crc32c EncryptRequest.plaintext_crc32c},
        #     and if so, perform a limited number of retries. A persistent mismatch may
        #     indicate an issue in your computation of the CRC32C checksum. Note: This
        #     field is defined as int64 for reasons of compatibility across different
        #     languages. However, it is a non-negative integer, which will never exceed
        #     2^32-1, and can be safely downconverted to uint32 in languages that support
        #     this type.
        # @!attribute [rw] additional_authenticated_data_crc32c
        #   @return [::Google::Protobuf::Int64Value]
        #     Optional. An optional CRC32C checksum of the
        #     {::Google::Cloud::Kms::V1::EncryptRequest#additional_authenticated_data EncryptRequest.additional_authenticated_data}.
        #     If specified,
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
        #     verify the integrity of the received
        #     {::Google::Cloud::Kms::V1::EncryptRequest#additional_authenticated_data EncryptRequest.additional_authenticated_data}
        #     using this checksum.
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
        #     report an error if the checksum verification fails. If you receive a
        #     checksum error, your client should verify that
        #     CRC32C({::Google::Cloud::Kms::V1::EncryptRequest#additional_authenticated_data EncryptRequest.additional_authenticated_data})
        #     is equal to
        #     {::Google::Cloud::Kms::V1::EncryptRequest#additional_authenticated_data_crc32c EncryptRequest.additional_authenticated_data_crc32c},
        #     and if so, perform a limited number of retries. A persistent mismatch may
        #     indicate an issue in your computation of the CRC32C checksum. Note: This
        #     field is defined as int64 for reasons of compatibility across different
        #     languages. However, it is a non-negative integer, which will never exceed
        #     2^32-1, and can be safely downconverted to uint32 in languages that support
        #     this type.
        class EncryptRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Kms::V1::KeyManagementService::Client#decrypt KeyManagementService.Decrypt}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the
        #     {::Google::Cloud::Kms::V1::CryptoKey CryptoKey} to use for decryption. The
        #     server will choose the appropriate version.
        # @!attribute [rw] ciphertext
        #   @return [::String]
        #     Required. The encrypted data originally returned in
        #     {::Google::Cloud::Kms::V1::EncryptResponse#ciphertext EncryptResponse.ciphertext}.
        # @!attribute [rw] additional_authenticated_data
        #   @return [::String]
        #     Optional. Optional data that must match the data originally supplied in
        #     {::Google::Cloud::Kms::V1::EncryptRequest#additional_authenticated_data EncryptRequest.additional_authenticated_data}.
        # @!attribute [rw] ciphertext_crc32c
        #   @return [::Google::Protobuf::Int64Value]
        #     Optional. An optional CRC32C checksum of the
        #     {::Google::Cloud::Kms::V1::DecryptRequest#ciphertext DecryptRequest.ciphertext}.
        #     If specified,
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
        #     verify the integrity of the received
        #     {::Google::Cloud::Kms::V1::DecryptRequest#ciphertext DecryptRequest.ciphertext}
        #     using this checksum.
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
        #     report an error if the checksum verification fails. If you receive a
        #     checksum error, your client should verify that
        #     CRC32C({::Google::Cloud::Kms::V1::DecryptRequest#ciphertext DecryptRequest.ciphertext})
        #     is equal to
        #     {::Google::Cloud::Kms::V1::DecryptRequest#ciphertext_crc32c DecryptRequest.ciphertext_crc32c},
        #     and if so, perform a limited number of retries. A persistent mismatch may
        #     indicate an issue in your computation of the CRC32C checksum. Note: This
        #     field is defined as int64 for reasons of compatibility across different
        #     languages. However, it is a non-negative integer, which will never exceed
        #     2^32-1, and can be safely downconverted to uint32 in languages that support
        #     this type.
        # @!attribute [rw] additional_authenticated_data_crc32c
        #   @return [::Google::Protobuf::Int64Value]
        #     Optional. An optional CRC32C checksum of the
        #     {::Google::Cloud::Kms::V1::DecryptRequest#additional_authenticated_data DecryptRequest.additional_authenticated_data}.
        #     If specified,
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
        #     verify the integrity of the received
        #     {::Google::Cloud::Kms::V1::DecryptRequest#additional_authenticated_data DecryptRequest.additional_authenticated_data}
        #     using this checksum.
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
        #     report an error if the checksum verification fails. If you receive a
        #     checksum error, your client should verify that
        #     CRC32C({::Google::Cloud::Kms::V1::DecryptRequest#additional_authenticated_data DecryptRequest.additional_authenticated_data})
        #     is equal to
        #     {::Google::Cloud::Kms::V1::DecryptRequest#additional_authenticated_data_crc32c DecryptRequest.additional_authenticated_data_crc32c},
        #     and if so, perform a limited number of retries. A persistent mismatch may
        #     indicate an issue in your computation of the CRC32C checksum. Note: This
        #     field is defined as int64 for reasons of compatibility across different
        #     languages. However, it is a non-negative integer, which will never exceed
        #     2^32-1, and can be safely downconverted to uint32 in languages that support
        #     this type.
        class DecryptRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Kms::V1::KeyManagementService::Client#raw_encrypt KeyManagementService.RawEncrypt}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} to use for
        #     encryption.
        # @!attribute [rw] plaintext
        #   @return [::String]
        #     Required. The data to encrypt. Must be no larger than 64KiB.
        #
        #     The maximum size depends on the key version's
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersionTemplate#protection_level protection_level}.
        #     For {::Google::Cloud::Kms::V1::ProtectionLevel::SOFTWARE SOFTWARE} keys, the
        #     plaintext must be no larger than 64KiB. For
        #     {::Google::Cloud::Kms::V1::ProtectionLevel::HSM HSM} keys, the combined length of
        #     the plaintext and additional_authenticated_data fields must be no larger
        #     than 8KiB.
        # @!attribute [rw] additional_authenticated_data
        #   @return [::String]
        #     Optional. Optional data that, if specified, must also be provided during
        #     decryption through
        #     {::Google::Cloud::Kms::V1::RawDecryptRequest#additional_authenticated_data RawDecryptRequest.additional_authenticated_data}.
        #
        #     This field may only be used in conjunction with an
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion#algorithm algorithm} that accepts
        #     additional authenticated data (for example, AES-GCM).
        #
        #     The maximum size depends on the key version's
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersionTemplate#protection_level protection_level}.
        #     For {::Google::Cloud::Kms::V1::ProtectionLevel::SOFTWARE SOFTWARE} keys, the
        #     plaintext must be no larger than 64KiB. For
        #     {::Google::Cloud::Kms::V1::ProtectionLevel::HSM HSM} keys, the combined length of
        #     the plaintext and additional_authenticated_data fields must be no larger
        #     than 8KiB.
        # @!attribute [rw] plaintext_crc32c
        #   @return [::Google::Protobuf::Int64Value]
        #     Optional. An optional CRC32C checksum of the
        #     {::Google::Cloud::Kms::V1::RawEncryptRequest#plaintext RawEncryptRequest.plaintext}.
        #     If specified,
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
        #     verify the integrity of the received plaintext using this checksum.
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
        #     report an error if the checksum verification fails. If you receive a
        #     checksum error, your client should verify that CRC32C(plaintext) is equal
        #     to plaintext_crc32c, and if so, perform a limited number of retries. A
        #     persistent mismatch may indicate an issue in your computation of the CRC32C
        #     checksum. Note: This field is defined as int64 for reasons of compatibility
        #     across different languages. However, it is a non-negative integer, which
        #     will never exceed 2^32-1, and can be safely downconverted to uint32 in
        #     languages that support this type.
        # @!attribute [rw] additional_authenticated_data_crc32c
        #   @return [::Google::Protobuf::Int64Value]
        #     Optional. An optional CRC32C checksum of the
        #     {::Google::Cloud::Kms::V1::RawEncryptRequest#additional_authenticated_data RawEncryptRequest.additional_authenticated_data}.
        #     If specified,
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
        #     verify the integrity of the received additional_authenticated_data using
        #     this checksum.
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
        #     report an error if the checksum verification fails. If you receive a
        #     checksum error, your client should verify that
        #     CRC32C(additional_authenticated_data) is equal to
        #     additional_authenticated_data_crc32c, and if so, perform
        #     a limited number of retries. A persistent mismatch may indicate an issue in
        #     your computation of the CRC32C checksum.
        #     Note: This field is defined as int64 for reasons of compatibility across
        #     different languages. However, it is a non-negative integer, which will
        #     never exceed 2^32-1, and can be safely downconverted to uint32 in languages
        #     that support this type.
        # @!attribute [rw] initialization_vector
        #   @return [::String]
        #     Optional. A customer-supplied initialization vector that will be used for
        #     encryption. If it is not provided for AES-CBC and AES-CTR, one will be
        #     generated. It will be returned in
        #     {::Google::Cloud::Kms::V1::RawEncryptResponse#initialization_vector RawEncryptResponse.initialization_vector}.
        # @!attribute [rw] initialization_vector_crc32c
        #   @return [::Google::Protobuf::Int64Value]
        #     Optional. An optional CRC32C checksum of the
        #     {::Google::Cloud::Kms::V1::RawEncryptRequest#initialization_vector RawEncryptRequest.initialization_vector}.
        #     If specified,
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
        #     verify the integrity of the received initialization_vector using this
        #     checksum. {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService}
        #     will report an error if the checksum verification fails. If you receive a
        #     checksum error, your client should verify that
        #     CRC32C(initialization_vector) is equal to
        #     initialization_vector_crc32c, and if so, perform
        #     a limited number of retries. A persistent mismatch may indicate an issue in
        #     your computation of the CRC32C checksum.
        #     Note: This field is defined as int64 for reasons of compatibility across
        #     different languages. However, it is a non-negative integer, which will
        #     never exceed 2^32-1, and can be safely downconverted to uint32 in languages
        #     that support this type.
        class RawEncryptRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Kms::V1::KeyManagementService::Client#raw_decrypt KeyManagementService.RawDecrypt}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} to use for
        #     decryption.
        # @!attribute [rw] ciphertext
        #   @return [::String]
        #     Required. The encrypted data originally returned in
        #     {::Google::Cloud::Kms::V1::RawEncryptResponse#ciphertext RawEncryptResponse.ciphertext}.
        # @!attribute [rw] additional_authenticated_data
        #   @return [::String]
        #     Optional. Optional data that must match the data originally supplied in
        #     {::Google::Cloud::Kms::V1::RawEncryptRequest#additional_authenticated_data RawEncryptRequest.additional_authenticated_data}.
        # @!attribute [rw] initialization_vector
        #   @return [::String]
        #     Required. The initialization vector (IV) used during encryption, which must
        #     match the data originally provided in
        #     {::Google::Cloud::Kms::V1::RawEncryptResponse#initialization_vector RawEncryptResponse.initialization_vector}.
        # @!attribute [rw] tag_length
        #   @return [::Integer]
        #     The length of the authentication tag that is appended to the end of
        #     the ciphertext. If unspecified (0), the default value for the key's
        #     algorithm will be used (for AES-GCM, the default value is 16).
        # @!attribute [rw] ciphertext_crc32c
        #   @return [::Google::Protobuf::Int64Value]
        #     Optional. An optional CRC32C checksum of the
        #     {::Google::Cloud::Kms::V1::RawDecryptRequest#ciphertext RawDecryptRequest.ciphertext}.
        #     If specified,
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
        #     verify the integrity of the received ciphertext using this checksum.
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
        #     report an error if the checksum verification fails. If you receive a
        #     checksum error, your client should verify that CRC32C(ciphertext) is equal
        #     to ciphertext_crc32c, and if so, perform a limited number of retries. A
        #     persistent mismatch may indicate an issue in your computation of the CRC32C
        #     checksum. Note: This field is defined as int64 for reasons of compatibility
        #     across different languages. However, it is a non-negative integer, which
        #     will never exceed 2^32-1, and can be safely downconverted to uint32 in
        #     languages that support this type.
        # @!attribute [rw] additional_authenticated_data_crc32c
        #   @return [::Google::Protobuf::Int64Value]
        #     Optional. An optional CRC32C checksum of the
        #     {::Google::Cloud::Kms::V1::RawDecryptRequest#additional_authenticated_data RawDecryptRequest.additional_authenticated_data}.
        #     If specified,
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
        #     verify the integrity of the received additional_authenticated_data using
        #     this checksum.
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
        #     report an error if the checksum verification fails. If you receive a
        #     checksum error, your client should verify that
        #     CRC32C(additional_authenticated_data) is equal to
        #     additional_authenticated_data_crc32c, and if so, perform
        #     a limited number of retries. A persistent mismatch may indicate an issue in
        #     your computation of the CRC32C checksum.
        #     Note: This field is defined as int64 for reasons of compatibility across
        #     different languages. However, it is a non-negative integer, which will
        #     never exceed 2^32-1, and can be safely downconverted to uint32 in languages
        #     that support this type.
        # @!attribute [rw] initialization_vector_crc32c
        #   @return [::Google::Protobuf::Int64Value]
        #     Optional. An optional CRC32C checksum of the
        #     {::Google::Cloud::Kms::V1::RawDecryptRequest#initialization_vector RawDecryptRequest.initialization_vector}.
        #     If specified,
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
        #     verify the integrity of the received initialization_vector using this
        #     checksum. {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService}
        #     will report an error if the checksum verification fails. If you receive a
        #     checksum error, your client should verify that
        #     CRC32C(initialization_vector) is equal to initialization_vector_crc32c, and
        #     if so, perform a limited number of retries. A persistent mismatch may
        #     indicate an issue in your computation of the CRC32C checksum.
        #     Note: This field is defined as int64 for reasons of compatibility across
        #     different languages. However, it is a non-negative integer, which will
        #     never exceed 2^32-1, and can be safely downconverted to uint32 in languages
        #     that support this type.
        class RawDecryptRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Kms::V1::KeyManagementService::Client#asymmetric_sign KeyManagementService.AsymmetricSign}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} to use for
        #     signing.
        # @!attribute [rw] digest
        #   @return [::Google::Cloud::Kms::V1::Digest]
        #     Optional. The digest of the data to sign. The digest must be produced with
        #     the same digest algorithm as specified by the key version's
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion#algorithm algorithm}.
        #
        #     This field may not be supplied if
        #     {::Google::Cloud::Kms::V1::AsymmetricSignRequest#data AsymmetricSignRequest.data}
        #     is supplied.
        # @!attribute [rw] digest_crc32c
        #   @return [::Google::Protobuf::Int64Value]
        #     Optional. An optional CRC32C checksum of the
        #     {::Google::Cloud::Kms::V1::AsymmetricSignRequest#digest AsymmetricSignRequest.digest}.
        #     If specified,
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
        #     verify the integrity of the received
        #     {::Google::Cloud::Kms::V1::AsymmetricSignRequest#digest AsymmetricSignRequest.digest}
        #     using this checksum.
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
        #     report an error if the checksum verification fails. If you receive a
        #     checksum error, your client should verify that
        #     CRC32C({::Google::Cloud::Kms::V1::AsymmetricSignRequest#digest AsymmetricSignRequest.digest})
        #     is equal to
        #     {::Google::Cloud::Kms::V1::AsymmetricSignRequest#digest_crc32c AsymmetricSignRequest.digest_crc32c},
        #     and if so, perform a limited number of retries. A persistent mismatch may
        #     indicate an issue in your computation of the CRC32C checksum. Note: This
        #     field is defined as int64 for reasons of compatibility across different
        #     languages. However, it is a non-negative integer, which will never exceed
        #     2^32-1, and can be safely downconverted to uint32 in languages that support
        #     this type.
        # @!attribute [rw] data
        #   @return [::String]
        #     Optional. The data to sign.
        #     It can't be supplied if
        #     {::Google::Cloud::Kms::V1::AsymmetricSignRequest#digest AsymmetricSignRequest.digest}
        #     is supplied.
        # @!attribute [rw] data_crc32c
        #   @return [::Google::Protobuf::Int64Value]
        #     Optional. An optional CRC32C checksum of the
        #     {::Google::Cloud::Kms::V1::AsymmetricSignRequest#data AsymmetricSignRequest.data}.
        #     If specified,
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
        #     verify the integrity of the received
        #     {::Google::Cloud::Kms::V1::AsymmetricSignRequest#data AsymmetricSignRequest.data}
        #     using this checksum.
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
        #     report an error if the checksum verification fails. If you receive a
        #     checksum error, your client should verify that
        #     CRC32C({::Google::Cloud::Kms::V1::AsymmetricSignRequest#data AsymmetricSignRequest.data})
        #     is equal to
        #     {::Google::Cloud::Kms::V1::AsymmetricSignRequest#data_crc32c AsymmetricSignRequest.data_crc32c},
        #     and if so, perform a limited number of retries. A persistent mismatch may
        #     indicate an issue in your computation of the CRC32C checksum. Note: This
        #     field is defined as int64 for reasons of compatibility across different
        #     languages. However, it is a non-negative integer, which will never exceed
        #     2^32-1, and can be safely downconverted to uint32 in languages that support
        #     this type.
        class AsymmetricSignRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Kms::V1::KeyManagementService::Client#asymmetric_decrypt KeyManagementService.AsymmetricDecrypt}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} to use for
        #     decryption.
        # @!attribute [rw] ciphertext
        #   @return [::String]
        #     Required. The data encrypted with the named
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion}'s public key using
        #     OAEP.
        # @!attribute [rw] ciphertext_crc32c
        #   @return [::Google::Protobuf::Int64Value]
        #     Optional. An optional CRC32C checksum of the
        #     {::Google::Cloud::Kms::V1::AsymmetricDecryptRequest#ciphertext AsymmetricDecryptRequest.ciphertext}.
        #     If specified,
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
        #     verify the integrity of the received
        #     {::Google::Cloud::Kms::V1::AsymmetricDecryptRequest#ciphertext AsymmetricDecryptRequest.ciphertext}
        #     using this checksum.
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
        #     report an error if the checksum verification fails. If you receive a
        #     checksum error, your client should verify that
        #     CRC32C({::Google::Cloud::Kms::V1::AsymmetricDecryptRequest#ciphertext AsymmetricDecryptRequest.ciphertext})
        #     is equal to
        #     {::Google::Cloud::Kms::V1::AsymmetricDecryptRequest#ciphertext_crc32c AsymmetricDecryptRequest.ciphertext_crc32c},
        #     and if so, perform a limited number of retries. A persistent mismatch may
        #     indicate an issue in your computation of the CRC32C checksum. Note: This
        #     field is defined as int64 for reasons of compatibility across different
        #     languages. However, it is a non-negative integer, which will never exceed
        #     2^32-1, and can be safely downconverted to uint32 in languages that support
        #     this type.
        class AsymmetricDecryptRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Kms::V1::KeyManagementService::Client#mac_sign KeyManagementService.MacSign}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} to use for
        #     signing.
        # @!attribute [rw] data
        #   @return [::String]
        #     Required. The data to sign. The MAC tag is computed over this data field
        #     based on the specific algorithm.
        # @!attribute [rw] data_crc32c
        #   @return [::Google::Protobuf::Int64Value]
        #     Optional. An optional CRC32C checksum of the
        #     {::Google::Cloud::Kms::V1::MacSignRequest#data MacSignRequest.data}. If
        #     specified, {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService}
        #     will verify the integrity of the received
        #     {::Google::Cloud::Kms::V1::MacSignRequest#data MacSignRequest.data} using this
        #     checksum. {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService}
        #     will report an error if the checksum verification fails. If you receive a
        #     checksum error, your client should verify that
        #     CRC32C({::Google::Cloud::Kms::V1::MacSignRequest#data MacSignRequest.data}) is
        #     equal to
        #     {::Google::Cloud::Kms::V1::MacSignRequest#data_crc32c MacSignRequest.data_crc32c},
        #     and if so, perform a limited number of retries. A persistent mismatch may
        #     indicate an issue in your computation of the CRC32C checksum. Note: This
        #     field is defined as int64 for reasons of compatibility across different
        #     languages. However, it is a non-negative integer, which will never exceed
        #     2^32-1, and can be safely downconverted to uint32 in languages that support
        #     this type.
        class MacSignRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Kms::V1::KeyManagementService::Client#mac_verify KeyManagementService.MacVerify}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} to use for
        #     verification.
        # @!attribute [rw] data
        #   @return [::String]
        #     Required. The data used previously as a
        #     {::Google::Cloud::Kms::V1::MacSignRequest#data MacSignRequest.data} to generate
        #     the MAC tag.
        # @!attribute [rw] data_crc32c
        #   @return [::Google::Protobuf::Int64Value]
        #     Optional. An optional CRC32C checksum of the
        #     {::Google::Cloud::Kms::V1::MacVerifyRequest#data MacVerifyRequest.data}. If
        #     specified, {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService}
        #     will verify the integrity of the received
        #     {::Google::Cloud::Kms::V1::MacVerifyRequest#data MacVerifyRequest.data} using
        #     this checksum.
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
        #     report an error if the checksum verification fails. If you receive a
        #     checksum error, your client should verify that
        #     CRC32C({::Google::Cloud::Kms::V1::MacVerifyRequest#data MacVerifyRequest.data})
        #     is equal to
        #     {::Google::Cloud::Kms::V1::MacVerifyRequest#data_crc32c MacVerifyRequest.data_crc32c},
        #     and if so, perform a limited number of retries. A persistent mismatch may
        #     indicate an issue in your computation of the CRC32C checksum. Note: This
        #     field is defined as int64 for reasons of compatibility across different
        #     languages. However, it is a non-negative integer, which will never exceed
        #     2^32-1, and can be safely downconverted to uint32 in languages that support
        #     this type.
        # @!attribute [rw] mac
        #   @return [::String]
        #     Required. The signature to verify.
        # @!attribute [rw] mac_crc32c
        #   @return [::Google::Protobuf::Int64Value]
        #     Optional. An optional CRC32C checksum of the
        #     {::Google::Cloud::Kms::V1::MacVerifyRequest#mac MacVerifyRequest.mac}. If
        #     specified, {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService}
        #     will verify the integrity of the received
        #     {::Google::Cloud::Kms::V1::MacVerifyRequest#mac MacVerifyRequest.mac} using this
        #     checksum. {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService}
        #     will report an error if the checksum verification fails. If you receive a
        #     checksum error, your client should verify that
        #     CRC32C({::Google::Cloud::Kms::V1::MacVerifyRequest#mac MacVerifyRequest.mac}) is
        #     equal to
        #     {::Google::Cloud::Kms::V1::MacVerifyRequest#mac_crc32c MacVerifyRequest.mac_crc32c},
        #     and if so, perform a limited number of retries. A persistent mismatch may
        #     indicate an issue in your computation of the CRC32C checksum. Note: This
        #     field is defined as int64 for reasons of compatibility across different
        #     languages. However, it is a non-negative integer, which will never exceed
        #     2^32-1, and can be safely downconverted to uint32 in languages that support
        #     this type.
        class MacVerifyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Kms::V1::KeyManagementService::Client#decapsulate KeyManagementService.Decapsulate}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} to use for
        #     decapsulation.
        # @!attribute [rw] ciphertext
        #   @return [::String]
        #     Required. The ciphertext produced from encapsulation with the
        #     named {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} public
        #     key(s).
        # @!attribute [rw] ciphertext_crc32c
        #   @return [::Google::Protobuf::Int64Value]
        #     Optional. A CRC32C checksum of the
        #     {::Google::Cloud::Kms::V1::DecapsulateRequest#ciphertext DecapsulateRequest.ciphertext}.
        #     If specified,
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
        #     verify the integrity of the received
        #     {::Google::Cloud::Kms::V1::DecapsulateRequest#ciphertext DecapsulateRequest.ciphertext}
        #     using this checksum.
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
        #     report an error if the checksum verification fails. If you receive a
        #     checksum error, your client should verify that
        #     CRC32C({::Google::Cloud::Kms::V1::DecapsulateRequest#ciphertext DecapsulateRequest.ciphertext})
        #     is equal to
        #     {::Google::Cloud::Kms::V1::DecapsulateRequest#ciphertext_crc32c DecapsulateRequest.ciphertext_crc32c},
        #     and if so, perform a limited number of retries. A persistent mismatch may
        #     indicate an issue in your computation of the CRC32C checksum. Note: This
        #     field is defined as int64 for reasons of compatibility across different
        #     languages. However, it is a non-negative integer, which will never exceed
        #     2^32-1, and can be safely downconverted to uint32 in languages that support
        #     this type.
        class DecapsulateRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Kms::V1::KeyManagementService::Client#generate_random_bytes KeyManagementService.GenerateRandomBytes}.
        # @!attribute [rw] location
        #   @return [::String]
        #     The project-specific location in which to generate random bytes.
        #     For example, "projects/my-project/locations/us-central1".
        # @!attribute [rw] length_bytes
        #   @return [::Integer]
        #     The length in bytes of the amount of randomness to retrieve.  Minimum 8
        #     bytes, maximum 1024 bytes.
        # @!attribute [rw] protection_level
        #   @return [::Google::Cloud::Kms::V1::ProtectionLevel]
        #     The {::Google::Cloud::Kms::V1::ProtectionLevel ProtectionLevel} to use when
        #     generating the random data. Currently, only
        #     {::Google::Cloud::Kms::V1::ProtectionLevel::HSM HSM} protection level is
        #     supported.
        class GenerateRandomBytesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Kms::V1::KeyManagementService::Client#encrypt KeyManagementService.Encrypt}.
        # @!attribute [rw] name
        #   @return [::String]
        #     The resource name of the
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} used in
        #     encryption. Check this field to verify that the intended resource was used
        #     for encryption.
        # @!attribute [rw] ciphertext
        #   @return [::String]
        #     The encrypted data.
        # @!attribute [rw] ciphertext_crc32c
        #   @return [::Google::Protobuf::Int64Value]
        #     Integrity verification field. A CRC32C checksum of the returned
        #     {::Google::Cloud::Kms::V1::EncryptResponse#ciphertext EncryptResponse.ciphertext}.
        #     An integrity check of
        #     {::Google::Cloud::Kms::V1::EncryptResponse#ciphertext EncryptResponse.ciphertext}
        #     can be performed by computing the CRC32C checksum of
        #     {::Google::Cloud::Kms::V1::EncryptResponse#ciphertext EncryptResponse.ciphertext}
        #     and comparing your results to this field. Discard the response in case of
        #     non-matching checksum values, and perform a limited number of retries. A
        #     persistent mismatch may indicate an issue in your computation of the CRC32C
        #     checksum. Note: This field is defined as int64 for reasons of compatibility
        #     across different languages. However, it is a non-negative integer, which
        #     will never exceed 2^32-1, and can be safely downconverted to uint32 in
        #     languages that support this type.
        # @!attribute [rw] verified_plaintext_crc32c
        #   @return [::Boolean]
        #     Integrity verification field. A flag indicating whether
        #     {::Google::Cloud::Kms::V1::EncryptRequest#plaintext_crc32c EncryptRequest.plaintext_crc32c}
        #     was received by
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} and used
        #     for the integrity verification of the
        #     {::Google::Cloud::Kms::V1::EncryptRequest#plaintext plaintext}. A false value of
        #     this field indicates either that
        #     {::Google::Cloud::Kms::V1::EncryptRequest#plaintext_crc32c EncryptRequest.plaintext_crc32c}
        #     was left unset or that it was not delivered to
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService}. If you've
        #     set
        #     {::Google::Cloud::Kms::V1::EncryptRequest#plaintext_crc32c EncryptRequest.plaintext_crc32c}
        #     but this field is still false, discard the response and perform a limited
        #     number of retries.
        # @!attribute [rw] verified_additional_authenticated_data_crc32c
        #   @return [::Boolean]
        #     Integrity verification field. A flag indicating whether
        #     {::Google::Cloud::Kms::V1::EncryptRequest#additional_authenticated_data_crc32c EncryptRequest.additional_authenticated_data_crc32c}
        #     was received by
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} and used
        #     for the integrity verification of the
        #     {::Google::Cloud::Kms::V1::EncryptRequest#additional_authenticated_data AAD}. A
        #     false value of this field indicates either that
        #     {::Google::Cloud::Kms::V1::EncryptRequest#additional_authenticated_data_crc32c EncryptRequest.additional_authenticated_data_crc32c}
        #     was left unset or that it was not delivered to
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService}. If you've
        #     set
        #     {::Google::Cloud::Kms::V1::EncryptRequest#additional_authenticated_data_crc32c EncryptRequest.additional_authenticated_data_crc32c}
        #     but this field is still false, discard the response and perform a limited
        #     number of retries.
        # @!attribute [rw] protection_level
        #   @return [::Google::Cloud::Kms::V1::ProtectionLevel]
        #     The {::Google::Cloud::Kms::V1::ProtectionLevel ProtectionLevel} of the
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} used in
        #     encryption.
        class EncryptResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Kms::V1::KeyManagementService::Client#decrypt KeyManagementService.Decrypt}.
        # @!attribute [rw] plaintext
        #   @return [::String]
        #     The decrypted data originally supplied in
        #     {::Google::Cloud::Kms::V1::EncryptRequest#plaintext EncryptRequest.plaintext}.
        # @!attribute [rw] plaintext_crc32c
        #   @return [::Google::Protobuf::Int64Value]
        #     Integrity verification field. A CRC32C checksum of the returned
        #     {::Google::Cloud::Kms::V1::DecryptResponse#plaintext DecryptResponse.plaintext}.
        #     An integrity check of
        #     {::Google::Cloud::Kms::V1::DecryptResponse#plaintext DecryptResponse.plaintext}
        #     can be performed by computing the CRC32C checksum of
        #     {::Google::Cloud::Kms::V1::DecryptResponse#plaintext DecryptResponse.plaintext}
        #     and comparing your results to this field. Discard the response in case of
        #     non-matching checksum values, and perform a limited number of retries. A
        #     persistent mismatch may indicate an issue in your computation of the CRC32C
        #     checksum. Note: receiving this response message indicates that
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} is able to
        #     successfully decrypt the
        #     {::Google::Cloud::Kms::V1::DecryptRequest#ciphertext ciphertext}. Note: This
        #     field is defined as int64 for reasons of compatibility across different
        #     languages. However, it is a non-negative integer, which will never exceed
        #     2^32-1, and can be safely downconverted to uint32 in languages that support
        #     this type.
        # @!attribute [rw] used_primary
        #   @return [::Boolean]
        #     Whether the Decryption was performed using the primary key version.
        # @!attribute [rw] protection_level
        #   @return [::Google::Cloud::Kms::V1::ProtectionLevel]
        #     The {::Google::Cloud::Kms::V1::ProtectionLevel ProtectionLevel} of the
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} used in
        #     decryption.
        class DecryptResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Kms::V1::KeyManagementService::Client#raw_encrypt KeyManagementService.RawEncrypt}.
        # @!attribute [rw] ciphertext
        #   @return [::String]
        #     The encrypted data. In the case of AES-GCM, the authentication tag
        #     is the {::Google::Cloud::Kms::V1::RawEncryptResponse#tag_length tag_length}
        #     bytes at the end of this field.
        # @!attribute [rw] initialization_vector
        #   @return [::String]
        #     The initialization vector (IV) generated by the service during
        #     encryption. This value must be stored and provided in
        #     {::Google::Cloud::Kms::V1::RawDecryptRequest#initialization_vector RawDecryptRequest.initialization_vector}
        #     at decryption time.
        # @!attribute [rw] tag_length
        #   @return [::Integer]
        #     The length of the authentication tag that is appended to
        #     the end of the ciphertext.
        # @!attribute [rw] ciphertext_crc32c
        #   @return [::Google::Protobuf::Int64Value]
        #     Integrity verification field. A CRC32C checksum of the returned
        #     {::Google::Cloud::Kms::V1::RawEncryptResponse#ciphertext RawEncryptResponse.ciphertext}.
        #     An integrity check of ciphertext can be performed by computing the CRC32C
        #     checksum of ciphertext and comparing your results to this field. Discard
        #     the response in case of non-matching checksum values, and perform a limited
        #     number of retries. A persistent mismatch may indicate an issue in your
        #     computation of the CRC32C checksum. Note: This field is defined as int64
        #     for reasons of compatibility across different languages. However, it is a
        #     non-negative integer, which will never exceed 2^32-1, and can be safely
        #     downconverted to uint32 in languages that support this type.
        # @!attribute [rw] initialization_vector_crc32c
        #   @return [::Google::Protobuf::Int64Value]
        #     Integrity verification field. A CRC32C checksum of the returned
        #     {::Google::Cloud::Kms::V1::RawEncryptResponse#initialization_vector RawEncryptResponse.initialization_vector}.
        #     An integrity check of initialization_vector can be performed by computing
        #     the CRC32C checksum of initialization_vector and comparing your results to
        #     this field. Discard the response in case of non-matching checksum values,
        #     and perform a limited number of retries. A persistent mismatch may indicate
        #     an issue in your computation of the CRC32C checksum. Note: This field is
        #     defined as int64 for reasons of compatibility across different languages.
        #     However, it is a non-negative integer, which will never exceed 2^32-1, and
        #     can be safely downconverted to uint32 in languages that support this type.
        # @!attribute [rw] verified_plaintext_crc32c
        #   @return [::Boolean]
        #     Integrity verification field. A flag indicating whether
        #     {::Google::Cloud::Kms::V1::RawEncryptRequest#plaintext_crc32c RawEncryptRequest.plaintext_crc32c}
        #     was received by
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} and used
        #     for the integrity verification of the plaintext. A false value of this
        #     field indicates either that
        #     {::Google::Cloud::Kms::V1::RawEncryptRequest#plaintext_crc32c RawEncryptRequest.plaintext_crc32c}
        #     was left unset or that it was not delivered to
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService}. If you've
        #     set
        #     {::Google::Cloud::Kms::V1::RawEncryptRequest#plaintext_crc32c RawEncryptRequest.plaintext_crc32c}
        #     but this field is still false, discard the response and perform a limited
        #     number of retries.
        # @!attribute [rw] verified_additional_authenticated_data_crc32c
        #   @return [::Boolean]
        #     Integrity verification field. A flag indicating whether
        #     {::Google::Cloud::Kms::V1::RawEncryptRequest#additional_authenticated_data_crc32c RawEncryptRequest.additional_authenticated_data_crc32c}
        #     was received by
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} and used
        #     for the integrity verification of additional_authenticated_data. A false
        #     value of this field indicates either that //
        #     {::Google::Cloud::Kms::V1::RawEncryptRequest#additional_authenticated_data_crc32c RawEncryptRequest.additional_authenticated_data_crc32c}
        #     was left unset or that it was not delivered to
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService}. If you've
        #     set
        #     {::Google::Cloud::Kms::V1::RawEncryptRequest#additional_authenticated_data_crc32c RawEncryptRequest.additional_authenticated_data_crc32c}
        #     but this field is still false, discard the response and perform a limited
        #     number of retries.
        # @!attribute [rw] verified_initialization_vector_crc32c
        #   @return [::Boolean]
        #     Integrity verification field. A flag indicating whether
        #     {::Google::Cloud::Kms::V1::RawEncryptRequest#initialization_vector_crc32c RawEncryptRequest.initialization_vector_crc32c}
        #     was received by
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} and used
        #     for the integrity verification of initialization_vector. A false value of
        #     this field indicates either that
        #     {::Google::Cloud::Kms::V1::RawEncryptRequest#initialization_vector_crc32c RawEncryptRequest.initialization_vector_crc32c}
        #     was left unset or that it was not delivered to
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService}. If you've
        #     set
        #     {::Google::Cloud::Kms::V1::RawEncryptRequest#initialization_vector_crc32c RawEncryptRequest.initialization_vector_crc32c}
        #     but this field is still false, discard the response and perform a limited
        #     number of retries.
        # @!attribute [rw] name
        #   @return [::String]
        #     The resource name of the
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} used in
        #     encryption. Check this field to verify that the intended resource was used
        #     for encryption.
        # @!attribute [rw] protection_level
        #   @return [::Google::Cloud::Kms::V1::ProtectionLevel]
        #     The {::Google::Cloud::Kms::V1::ProtectionLevel ProtectionLevel} of the
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} used in
        #     encryption.
        class RawEncryptResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Kms::V1::KeyManagementService::Client#raw_decrypt KeyManagementService.RawDecrypt}.
        # @!attribute [rw] plaintext
        #   @return [::String]
        #     The decrypted data.
        # @!attribute [rw] plaintext_crc32c
        #   @return [::Google::Protobuf::Int64Value]
        #     Integrity verification field. A CRC32C checksum of the returned
        #     {::Google::Cloud::Kms::V1::RawDecryptResponse#plaintext RawDecryptResponse.plaintext}.
        #     An integrity check of plaintext can be performed by computing the CRC32C
        #     checksum of plaintext and comparing your results to this field. Discard the
        #     response in case of non-matching checksum values, and perform a limited
        #     number of retries. A persistent mismatch may indicate an issue in your
        #     computation of the CRC32C checksum. Note: receiving this response message
        #     indicates that
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} is able to
        #     successfully decrypt the
        #     {::Google::Cloud::Kms::V1::RawDecryptRequest#ciphertext ciphertext}.
        #     Note: This field is defined as int64 for reasons of compatibility across
        #     different languages. However, it is a non-negative integer, which will
        #     never exceed 2^32-1, and can be safely downconverted to uint32 in languages
        #     that support this type.
        # @!attribute [rw] protection_level
        #   @return [::Google::Cloud::Kms::V1::ProtectionLevel]
        #     The {::Google::Cloud::Kms::V1::ProtectionLevel ProtectionLevel} of the
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} used in
        #     decryption.
        # @!attribute [rw] verified_ciphertext_crc32c
        #   @return [::Boolean]
        #     Integrity verification field. A flag indicating whether
        #     {::Google::Cloud::Kms::V1::RawDecryptRequest#ciphertext_crc32c RawDecryptRequest.ciphertext_crc32c}
        #     was received by
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} and used
        #     for the integrity verification of the ciphertext. A false value of this
        #     field indicates either that
        #     {::Google::Cloud::Kms::V1::RawDecryptRequest#ciphertext_crc32c RawDecryptRequest.ciphertext_crc32c}
        #     was left unset or that it was not delivered to
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService}. If you've
        #     set
        #     {::Google::Cloud::Kms::V1::RawDecryptRequest#ciphertext_crc32c RawDecryptRequest.ciphertext_crc32c}
        #     but this field is still false, discard the response and perform a limited
        #     number of retries.
        # @!attribute [rw] verified_additional_authenticated_data_crc32c
        #   @return [::Boolean]
        #     Integrity verification field. A flag indicating whether
        #     {::Google::Cloud::Kms::V1::RawDecryptRequest#additional_authenticated_data_crc32c RawDecryptRequest.additional_authenticated_data_crc32c}
        #     was received by
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} and used
        #     for the integrity verification of additional_authenticated_data. A false
        #     value of this field indicates either that //
        #     {::Google::Cloud::Kms::V1::RawDecryptRequest#additional_authenticated_data_crc32c RawDecryptRequest.additional_authenticated_data_crc32c}
        #     was left unset or that it was not delivered to
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService}. If you've
        #     set
        #     {::Google::Cloud::Kms::V1::RawDecryptRequest#additional_authenticated_data_crc32c RawDecryptRequest.additional_authenticated_data_crc32c}
        #     but this field is still false, discard the response and perform a limited
        #     number of retries.
        # @!attribute [rw] verified_initialization_vector_crc32c
        #   @return [::Boolean]
        #     Integrity verification field. A flag indicating whether
        #     {::Google::Cloud::Kms::V1::RawDecryptRequest#initialization_vector_crc32c RawDecryptRequest.initialization_vector_crc32c}
        #     was received by
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} and used
        #     for the integrity verification of initialization_vector. A false value of
        #     this field indicates either that
        #     {::Google::Cloud::Kms::V1::RawDecryptRequest#initialization_vector_crc32c RawDecryptRequest.initialization_vector_crc32c}
        #     was left unset or that it was not delivered to
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService}. If you've
        #     set
        #     {::Google::Cloud::Kms::V1::RawDecryptRequest#initialization_vector_crc32c RawDecryptRequest.initialization_vector_crc32c}
        #     but this field is still false, discard the response and perform a limited
        #     number of retries.
        class RawDecryptResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Kms::V1::KeyManagementService::Client#asymmetric_sign KeyManagementService.AsymmetricSign}.
        # @!attribute [rw] signature
        #   @return [::String]
        #     The created signature.
        # @!attribute [rw] signature_crc32c
        #   @return [::Google::Protobuf::Int64Value]
        #     Integrity verification field. A CRC32C checksum of the returned
        #     {::Google::Cloud::Kms::V1::AsymmetricSignResponse#signature AsymmetricSignResponse.signature}.
        #     An integrity check of
        #     {::Google::Cloud::Kms::V1::AsymmetricSignResponse#signature AsymmetricSignResponse.signature}
        #     can be performed by computing the CRC32C checksum of
        #     {::Google::Cloud::Kms::V1::AsymmetricSignResponse#signature AsymmetricSignResponse.signature}
        #     and comparing your results to this field. Discard the response in case of
        #     non-matching checksum values, and perform a limited number of retries. A
        #     persistent mismatch may indicate an issue in your computation of the CRC32C
        #     checksum. Note: This field is defined as int64 for reasons of compatibility
        #     across different languages. However, it is a non-negative integer, which
        #     will never exceed 2^32-1, and can be safely downconverted to uint32 in
        #     languages that support this type.
        # @!attribute [rw] verified_digest_crc32c
        #   @return [::Boolean]
        #     Integrity verification field. A flag indicating whether
        #     {::Google::Cloud::Kms::V1::AsymmetricSignRequest#digest_crc32c AsymmetricSignRequest.digest_crc32c}
        #     was received by
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} and used
        #     for the integrity verification of the
        #     {::Google::Cloud::Kms::V1::AsymmetricSignRequest#digest digest}. A false value
        #     of this field indicates either that
        #     {::Google::Cloud::Kms::V1::AsymmetricSignRequest#digest_crc32c AsymmetricSignRequest.digest_crc32c}
        #     was left unset or that it was not delivered to
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService}. If you've
        #     set
        #     {::Google::Cloud::Kms::V1::AsymmetricSignRequest#digest_crc32c AsymmetricSignRequest.digest_crc32c}
        #     but this field is still false, discard the response and perform a limited
        #     number of retries.
        # @!attribute [rw] name
        #   @return [::String]
        #     The resource name of the
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} used for signing.
        #     Check this field to verify that the intended resource was used for signing.
        # @!attribute [rw] verified_data_crc32c
        #   @return [::Boolean]
        #     Integrity verification field. A flag indicating whether
        #     {::Google::Cloud::Kms::V1::AsymmetricSignRequest#data_crc32c AsymmetricSignRequest.data_crc32c}
        #     was received by
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} and used
        #     for the integrity verification of the
        #     {::Google::Cloud::Kms::V1::AsymmetricSignRequest#data data}. A false value of
        #     this field indicates either that
        #     {::Google::Cloud::Kms::V1::AsymmetricSignRequest#data_crc32c AsymmetricSignRequest.data_crc32c}
        #     was left unset or that it was not delivered to
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService}. If you've
        #     set
        #     {::Google::Cloud::Kms::V1::AsymmetricSignRequest#data_crc32c AsymmetricSignRequest.data_crc32c}
        #     but this field is still false, discard the response and perform a limited
        #     number of retries.
        # @!attribute [rw] protection_level
        #   @return [::Google::Cloud::Kms::V1::ProtectionLevel]
        #     The {::Google::Cloud::Kms::V1::ProtectionLevel ProtectionLevel} of the
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} used for signing.
        class AsymmetricSignResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Kms::V1::KeyManagementService::Client#asymmetric_decrypt KeyManagementService.AsymmetricDecrypt}.
        # @!attribute [rw] plaintext
        #   @return [::String]
        #     The decrypted data originally encrypted with the matching public key.
        # @!attribute [rw] plaintext_crc32c
        #   @return [::Google::Protobuf::Int64Value]
        #     Integrity verification field. A CRC32C checksum of the returned
        #     {::Google::Cloud::Kms::V1::AsymmetricDecryptResponse#plaintext AsymmetricDecryptResponse.plaintext}.
        #     An integrity check of
        #     {::Google::Cloud::Kms::V1::AsymmetricDecryptResponse#plaintext AsymmetricDecryptResponse.plaintext}
        #     can be performed by computing the CRC32C checksum of
        #     {::Google::Cloud::Kms::V1::AsymmetricDecryptResponse#plaintext AsymmetricDecryptResponse.plaintext}
        #     and comparing your results to this field. Discard the response in case of
        #     non-matching checksum values, and perform a limited number of retries. A
        #     persistent mismatch may indicate an issue in your computation of the CRC32C
        #     checksum. Note: This field is defined as int64 for reasons of compatibility
        #     across different languages. However, it is a non-negative integer, which
        #     will never exceed 2^32-1, and can be safely downconverted to uint32 in
        #     languages that support this type.
        # @!attribute [rw] verified_ciphertext_crc32c
        #   @return [::Boolean]
        #     Integrity verification field. A flag indicating whether
        #     {::Google::Cloud::Kms::V1::AsymmetricDecryptRequest#ciphertext_crc32c AsymmetricDecryptRequest.ciphertext_crc32c}
        #     was received by
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} and used
        #     for the integrity verification of the
        #     {::Google::Cloud::Kms::V1::AsymmetricDecryptRequest#ciphertext ciphertext}. A
        #     false value of this field indicates either that
        #     {::Google::Cloud::Kms::V1::AsymmetricDecryptRequest#ciphertext_crc32c AsymmetricDecryptRequest.ciphertext_crc32c}
        #     was left unset or that it was not delivered to
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService}. If you've
        #     set
        #     {::Google::Cloud::Kms::V1::AsymmetricDecryptRequest#ciphertext_crc32c AsymmetricDecryptRequest.ciphertext_crc32c}
        #     but this field is still false, discard the response and perform a limited
        #     number of retries.
        # @!attribute [rw] protection_level
        #   @return [::Google::Cloud::Kms::V1::ProtectionLevel]
        #     The {::Google::Cloud::Kms::V1::ProtectionLevel ProtectionLevel} of the
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} used in
        #     decryption.
        class AsymmetricDecryptResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Kms::V1::KeyManagementService::Client#mac_sign KeyManagementService.MacSign}.
        # @!attribute [rw] name
        #   @return [::String]
        #     The resource name of the
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} used for signing.
        #     Check this field to verify that the intended resource was used for signing.
        # @!attribute [rw] mac
        #   @return [::String]
        #     The created signature.
        # @!attribute [rw] mac_crc32c
        #   @return [::Google::Protobuf::Int64Value]
        #     Integrity verification field. A CRC32C checksum of the returned
        #     {::Google::Cloud::Kms::V1::MacSignResponse#mac MacSignResponse.mac}. An
        #     integrity check of
        #     {::Google::Cloud::Kms::V1::MacSignResponse#mac MacSignResponse.mac} can be
        #     performed by computing the CRC32C checksum of
        #     {::Google::Cloud::Kms::V1::MacSignResponse#mac MacSignResponse.mac} and
        #     comparing your results to this field. Discard the response in case of
        #     non-matching checksum values, and perform a limited number of retries. A
        #     persistent mismatch may indicate an issue in your computation of the CRC32C
        #     checksum. Note: This field is defined as int64 for reasons of compatibility
        #     across different languages. However, it is a non-negative integer, which
        #     will never exceed 2^32-1, and can be safely downconverted to uint32 in
        #     languages that support this type.
        # @!attribute [rw] verified_data_crc32c
        #   @return [::Boolean]
        #     Integrity verification field. A flag indicating whether
        #     {::Google::Cloud::Kms::V1::MacSignRequest#data_crc32c MacSignRequest.data_crc32c}
        #     was received by
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} and used
        #     for the integrity verification of the
        #     {::Google::Cloud::Kms::V1::MacSignRequest#data data}. A false value of this
        #     field indicates either that
        #     {::Google::Cloud::Kms::V1::MacSignRequest#data_crc32c MacSignRequest.data_crc32c}
        #     was left unset or that it was not delivered to
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService}. If you've
        #     set
        #     {::Google::Cloud::Kms::V1::MacSignRequest#data_crc32c MacSignRequest.data_crc32c}
        #     but this field is still false, discard the response and perform a limited
        #     number of retries.
        # @!attribute [rw] protection_level
        #   @return [::Google::Cloud::Kms::V1::ProtectionLevel]
        #     The {::Google::Cloud::Kms::V1::ProtectionLevel ProtectionLevel} of the
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} used for signing.
        class MacSignResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Kms::V1::KeyManagementService::Client#mac_verify KeyManagementService.MacVerify}.
        # @!attribute [rw] name
        #   @return [::String]
        #     The resource name of the
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} used for
        #     verification. Check this field to verify that the intended resource was
        #     used for verification.
        # @!attribute [rw] success
        #   @return [::Boolean]
        #     This field indicates whether or not the verification operation for
        #     {::Google::Cloud::Kms::V1::MacVerifyRequest#mac MacVerifyRequest.mac} over
        #     {::Google::Cloud::Kms::V1::MacVerifyRequest#data MacVerifyRequest.data} was
        #     successful.
        # @!attribute [rw] verified_data_crc32c
        #   @return [::Boolean]
        #     Integrity verification field. A flag indicating whether
        #     {::Google::Cloud::Kms::V1::MacVerifyRequest#data_crc32c MacVerifyRequest.data_crc32c}
        #     was received by
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} and used
        #     for the integrity verification of the
        #     {::Google::Cloud::Kms::V1::MacVerifyRequest#data data}. A false value of this
        #     field indicates either that
        #     {::Google::Cloud::Kms::V1::MacVerifyRequest#data_crc32c MacVerifyRequest.data_crc32c}
        #     was left unset or that it was not delivered to
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService}. If you've
        #     set
        #     {::Google::Cloud::Kms::V1::MacVerifyRequest#data_crc32c MacVerifyRequest.data_crc32c}
        #     but this field is still false, discard the response and perform a limited
        #     number of retries.
        # @!attribute [rw] verified_mac_crc32c
        #   @return [::Boolean]
        #     Integrity verification field. A flag indicating whether
        #     {::Google::Cloud::Kms::V1::MacVerifyRequest#mac_crc32c MacVerifyRequest.mac_crc32c}
        #     was received by
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} and used
        #     for the integrity verification of the
        #     {::Google::Cloud::Kms::V1::MacVerifyRequest#mac data}. A false value of this
        #     field indicates either that
        #     {::Google::Cloud::Kms::V1::MacVerifyRequest#mac_crc32c MacVerifyRequest.mac_crc32c}
        #     was left unset or that it was not delivered to
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService}. If you've
        #     set
        #     {::Google::Cloud::Kms::V1::MacVerifyRequest#mac_crc32c MacVerifyRequest.mac_crc32c}
        #     but this field is still false, discard the response and perform a limited
        #     number of retries.
        # @!attribute [rw] verified_success_integrity
        #   @return [::Boolean]
        #     Integrity verification field. This value is used for the integrity
        #     verification of [MacVerifyResponse.success]. If the value of this field
        #     contradicts the value of [MacVerifyResponse.success], discard the response
        #     and perform a limited number of retries.
        # @!attribute [rw] protection_level
        #   @return [::Google::Cloud::Kms::V1::ProtectionLevel]
        #     The {::Google::Cloud::Kms::V1::ProtectionLevel ProtectionLevel} of the
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} used for
        #     verification.
        class MacVerifyResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Kms::V1::KeyManagementService::Client#decapsulate KeyManagementService.Decapsulate}.
        # @!attribute [rw] name
        #   @return [::String]
        #     The resource name of the
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} used for
        #     decapsulation. Check this field to verify that the intended resource was
        #     used for decapsulation.
        # @!attribute [rw] shared_secret
        #   @return [::String]
        #     The decapsulated shared_secret originally encapsulated with the matching
        #     public key.
        # @!attribute [rw] shared_secret_crc32c
        #   @return [::Integer]
        #     Integrity verification field. A CRC32C checksum of the returned
        #     {::Google::Cloud::Kms::V1::DecapsulateResponse#shared_secret DecapsulateResponse.shared_secret}.
        #     An integrity check of
        #     {::Google::Cloud::Kms::V1::DecapsulateResponse#shared_secret DecapsulateResponse.shared_secret}
        #     can be performed by computing the CRC32C checksum of
        #     {::Google::Cloud::Kms::V1::DecapsulateResponse#shared_secret DecapsulateResponse.shared_secret}
        #     and comparing your results to this field. Discard the response in case of
        #     non-matching checksum values, and perform a limited number of retries. A
        #     persistent mismatch may indicate an issue in your computation of the CRC32C
        #     checksum. Note: receiving this response message indicates that
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} is able to
        #     successfully decrypt the
        #     {::Google::Cloud::Kms::V1::DecapsulateRequest#ciphertext ciphertext}. Note: This
        #     field is defined as int64 for reasons of compatibility across different
        #     languages. However, it is a non-negative integer, which will never exceed
        #     2^32-1, and can be safely downconverted to uint32 in languages that support
        #     this type.
        # @!attribute [rw] verified_ciphertext_crc32c
        #   @return [::Boolean]
        #     Integrity verification field. A flag indicating whether
        #     {::Google::Cloud::Kms::V1::DecapsulateRequest#ciphertext_crc32c DecapsulateRequest.ciphertext_crc32c}
        #     was received by
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} and used
        #     for the integrity verification of the
        #     {::Google::Cloud::Kms::V1::DecapsulateRequest#ciphertext ciphertext}. A false
        #     value of this field indicates either that
        #     {::Google::Cloud::Kms::V1::DecapsulateRequest#ciphertext_crc32c DecapsulateRequest.ciphertext_crc32c}
        #     was left unset or that it was not delivered to
        #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService}. If you've
        #     set
        #     {::Google::Cloud::Kms::V1::DecapsulateRequest#ciphertext_crc32c DecapsulateRequest.ciphertext_crc32c}
        #     but this field is still false, discard the response and perform a limited
        #     number of retries.
        # @!attribute [rw] protection_level
        #   @return [::Google::Cloud::Kms::V1::ProtectionLevel]
        #     The {::Google::Cloud::Kms::V1::ProtectionLevel ProtectionLevel} of the
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} used in
        #     decapsulation.
        class DecapsulateResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Kms::V1::KeyManagementService::Client#generate_random_bytes KeyManagementService.GenerateRandomBytes}.
        # @!attribute [rw] data
        #   @return [::String]
        #     The generated data.
        # @!attribute [rw] data_crc32c
        #   @return [::Google::Protobuf::Int64Value]
        #     Integrity verification field. A CRC32C checksum of the returned
        #     {::Google::Cloud::Kms::V1::GenerateRandomBytesResponse#data GenerateRandomBytesResponse.data}.
        #     An integrity check of
        #     {::Google::Cloud::Kms::V1::GenerateRandomBytesResponse#data GenerateRandomBytesResponse.data}
        #     can be performed by computing the CRC32C checksum of
        #     {::Google::Cloud::Kms::V1::GenerateRandomBytesResponse#data GenerateRandomBytesResponse.data}
        #     and comparing your results to this field. Discard the response in case of
        #     non-matching checksum values, and perform a limited number of retries. A
        #     persistent mismatch may indicate an issue in your computation of the CRC32C
        #     checksum. Note: This field is defined as int64 for reasons of compatibility
        #     across different languages. However, it is a non-negative integer, which
        #     will never exceed 2^32-1, and can be safely downconverted to uint32 in
        #     languages that support this type.
        class GenerateRandomBytesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A {::Google::Cloud::Kms::V1::Digest Digest} holds a cryptographic message digest.
        # @!attribute [rw] sha256
        #   @return [::String]
        #     A message digest produced with the SHA-256 algorithm.
        #
        #     Note: The following fields are mutually exclusive: `sha256`, `sha384`, `sha512`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] sha384
        #   @return [::String]
        #     A message digest produced with the SHA-384 algorithm.
        #
        #     Note: The following fields are mutually exclusive: `sha384`, `sha256`, `sha512`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] sha512
        #   @return [::String]
        #     A message digest produced with the SHA-512 algorithm.
        #
        #     Note: The following fields are mutually exclusive: `sha512`, `sha256`, `sha384`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class Digest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Cloud KMS metadata for the given
        # [google.cloud.location.Location][google.cloud.location.Location].
        # @!attribute [rw] hsm_available
        #   @return [::Boolean]
        #     Indicates whether {::Google::Cloud::Kms::V1::CryptoKey CryptoKeys} with
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersionTemplate#protection_level protection_level}
        #     {::Google::Cloud::Kms::V1::ProtectionLevel::HSM HSM} can be created in this
        #     location.
        # @!attribute [rw] ekm_available
        #   @return [::Boolean]
        #     Indicates whether {::Google::Cloud::Kms::V1::CryptoKey CryptoKeys} with
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersionTemplate#protection_level protection_level}
        #     {::Google::Cloud::Kms::V1::ProtectionLevel::EXTERNAL EXTERNAL} can be created in
        #     this location.
        class LocationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
