# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Kms
      module V1
        # Request message for
        # {::Google::Cloud::Kms::V1::Autokey::Client#create_key_handle Autokey.CreateKeyHandle}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Name of the resource project and location to create the
        #     {::Google::Cloud::Kms::V1::KeyHandle KeyHandle} in, e.g.
        #     `projects/{PROJECT_ID}/locations/{LOCATION}`.
        # @!attribute [rw] key_handle_id
        #   @return [::String]
        #     Optional. Id of the {::Google::Cloud::Kms::V1::KeyHandle KeyHandle}. Must be
        #     unique to the resource project and location. If not provided by the caller,
        #     a new UUID is used.
        # @!attribute [rw] key_handle
        #   @return [::Google::Cloud::Kms::V1::KeyHandle]
        #     Required. {::Google::Cloud::Kms::V1::KeyHandle KeyHandle} to create.
        class CreateKeyHandleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for {::Google::Cloud::Kms::V1::Autokey::Client#get_key_handle GetKeyHandle}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the {::Google::Cloud::Kms::V1::KeyHandle KeyHandle} resource,
        #     e.g.
        #     `projects/{PROJECT_ID}/locations/{LOCATION}/keyHandles/{KEY_HANDLE_ID}`.
        class GetKeyHandleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Resource-oriented representation of a request to Cloud KMS Autokey and the
        # resulting provisioning of a {::Google::Cloud::Kms::V1::CryptoKey CryptoKey}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Name of the {::Google::Cloud::Kms::V1::KeyHandle KeyHandle}
        #     resource, e.g.
        #     `projects/{PROJECT_ID}/locations/{LOCATION}/keyHandles/{KEY_HANDLE_ID}`.
        # @!attribute [r] kms_key
        #   @return [::String]
        #     Output only. Name of a {::Google::Cloud::Kms::V1::CryptoKey CryptoKey} that has
        #     been provisioned for Customer Managed Encryption Key (CMEK) use in the
        #     {::Google::Cloud::Kms::V1::KeyHandle KeyHandle} project and location for the
        #     requested resource type. The {::Google::Cloud::Kms::V1::CryptoKey CryptoKey}
        #     project will reflect the value configured in the
        #     {::Google::Cloud::Kms::V1::AutokeyConfig AutokeyConfig} on the resource
        #     project's ancestor folder at the time of the
        #     {::Google::Cloud::Kms::V1::KeyHandle KeyHandle} creation. If more than one
        #     ancestor folder has a configured
        #     {::Google::Cloud::Kms::V1::AutokeyConfig AutokeyConfig}, the nearest of these
        #     configurations is used.
        # @!attribute [rw] resource_type_selector
        #   @return [::String]
        #     Required. Indicates the resource type that the resulting
        #     {::Google::Cloud::Kms::V1::CryptoKey CryptoKey} is meant to protect, e.g.
        #     `{SERVICE}.googleapis.com/{TYPE}`. See documentation for supported resource
        #     types.
        class KeyHandle
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata message for
        # {::Google::Cloud::Kms::V1::Autokey::Client#create_key_handle CreateKeyHandle} long-running
        # operation response.
        class CreateKeyHandleMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Kms::V1::Autokey::Client#list_key_handles Autokey.ListKeyHandles}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Name of the resource project and location from which to list
        #     {::Google::Cloud::Kms::V1::KeyHandle KeyHandles}, e.g.
        #     `projects/{PROJECT_ID}/locations/{LOCATION}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Optional limit on the number of
        #     {::Google::Cloud::Kms::V1::KeyHandle KeyHandles} to include in the response. The
        #     service may return fewer than this value. Further
        #     {::Google::Cloud::Kms::V1::KeyHandle KeyHandles} can subsequently be obtained by
        #     including the
        #     {::Google::Cloud::Kms::V1::ListKeyHandlesResponse#next_page_token ListKeyHandlesResponse.next_page_token}
        #     in a subsequent request.  If unspecified, at most 100
        #     {::Google::Cloud::Kms::V1::KeyHandle KeyHandles} will be returned.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Optional pagination token, returned earlier via
        #     {::Google::Cloud::Kms::V1::ListKeyHandlesResponse#next_page_token ListKeyHandlesResponse.next_page_token}.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter to apply when listing
        #     {::Google::Cloud::Kms::V1::KeyHandle KeyHandles}, e.g.
        #     `resource_type_selector="{SERVICE}.googleapis.com/{TYPE}"`.
        class ListKeyHandlesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Kms::V1::Autokey::Client#list_key_handles Autokey.ListKeyHandles}.
        # @!attribute [rw] key_handles
        #   @return [::Array<::Google::Cloud::Kms::V1::KeyHandle>]
        #     Resulting {::Google::Cloud::Kms::V1::KeyHandle KeyHandles}.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token to retrieve next page of results. Pass this value in
        #     {::Google::Cloud::Kms::V1::ListKeyHandlesRequest#page_token ListKeyHandlesRequest.page_token}
        #     to retrieve the next page of results.
        class ListKeyHandlesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
