# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/kms/v1/service_pb"
require "google/cloud/location"
require "google/iam/v1"

module Google
  module Cloud
    module Kms
      module V1
        module KeyManagementService
          ##
          # Client for the KeyManagementService service.
          #
          # Google Cloud Key Management Service
          #
          # Manages cryptographic keys and operations using those keys. Implements a REST
          # model with the following objects:
          #
          # * {::Google::Cloud::Kms::V1::KeyRing KeyRing}
          # * {::Google::Cloud::Kms::V1::CryptoKey CryptoKey}
          # * {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion}
          # * {::Google::Cloud::Kms::V1::ImportJob ImportJob}
          #
          # If you are using manual gRPC libraries, see
          # [Using gRPC with Cloud KMS](https://cloud.google.com/kms/docs/grpc).
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "cloudkms.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :key_management_service_stub

            ##
            # Configure the KeyManagementService Client class.
            #
            # See {::Google::Cloud::Kms::V1::KeyManagementService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all KeyManagementService clients
            #   ::Google::Cloud::Kms::V1::KeyManagementService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "Kms", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.list_key_rings.timeout = 60.0
                default_config.rpcs.list_key_rings.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.list_crypto_keys.timeout = 60.0
                default_config.rpcs.list_crypto_keys.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.list_crypto_key_versions.timeout = 60.0
                default_config.rpcs.list_crypto_key_versions.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.list_import_jobs.timeout = 60.0
                default_config.rpcs.list_import_jobs.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.get_key_ring.timeout = 60.0
                default_config.rpcs.get_key_ring.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.get_crypto_key.timeout = 60.0
                default_config.rpcs.get_crypto_key.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.get_crypto_key_version.timeout = 60.0
                default_config.rpcs.get_crypto_key_version.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.get_public_key.timeout = 60.0
                default_config.rpcs.get_public_key.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.get_import_job.timeout = 60.0
                default_config.rpcs.get_import_job.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.create_key_ring.timeout = 60.0
                default_config.rpcs.create_key_ring.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.create_crypto_key.timeout = 60.0
                default_config.rpcs.create_crypto_key.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.create_crypto_key_version.timeout = 60.0

                default_config.rpcs.import_crypto_key_version.timeout = 60.0

                default_config.rpcs.create_import_job.timeout = 60.0
                default_config.rpcs.create_import_job.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.update_crypto_key.timeout = 60.0
                default_config.rpcs.update_crypto_key.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.update_crypto_key_version.timeout = 60.0
                default_config.rpcs.update_crypto_key_version.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.update_crypto_key_primary_version.timeout = 60.0
                default_config.rpcs.update_crypto_key_primary_version.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.destroy_crypto_key_version.timeout = 60.0
                default_config.rpcs.destroy_crypto_key_version.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.restore_crypto_key_version.timeout = 60.0
                default_config.rpcs.restore_crypto_key_version.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.encrypt.timeout = 60.0
                default_config.rpcs.encrypt.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.decrypt.timeout = 60.0
                default_config.rpcs.decrypt.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.asymmetric_sign.timeout = 60.0
                default_config.rpcs.asymmetric_sign.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.asymmetric_decrypt.timeout = 60.0
                default_config.rpcs.asymmetric_decrypt.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.mac_sign.timeout = 60.0
                default_config.rpcs.mac_sign.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.mac_verify.timeout = 60.0
                default_config.rpcs.mac_verify.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.generate_random_bytes.timeout = 60.0
                default_config.rpcs.generate_random_bytes.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the KeyManagementService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::Kms::V1::KeyManagementService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @key_management_service_stub.universe_domain
            end

            ##
            # Create a new KeyManagementService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::Kms::V1::KeyManagementService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::Kms::V1::KeyManagementService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the KeyManagementService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/kms/v1/service_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @key_management_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::Kms::V1::KeyManagementService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @key_management_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @key_management_service_stub.endpoint
                config.universe_domain = @key_management_service_stub.universe_domain
                config.logger = @key_management_service_stub.logger if config.respond_to? :logger=
              end

              @iam_policy_client = Google::Iam::V1::IAMPolicy::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @key_management_service_stub.endpoint
                config.universe_domain = @key_management_service_stub.universe_domain
                config.logger = @key_management_service_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # Get the associated client for mix-in of the IAMPolicy.
            #
            # @return [Google::Iam::V1::IAMPolicy::Client]
            #
            attr_reader :iam_policy_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @key_management_service_stub.logger
            end

            # Service calls

            ##
            # Lists {::Google::Cloud::Kms::V1::KeyRing KeyRings}.
            #
            # @overload list_key_rings(request, options = nil)
            #   Pass arguments to `list_key_rings` via a request object, either of type
            #   {::Google::Cloud::Kms::V1::ListKeyRingsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Kms::V1::ListKeyRingsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_key_rings(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_key_rings` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the location associated with the
            #     {::Google::Cloud::Kms::V1::KeyRing KeyRings}, in the format
            #     `projects/*/locations/*`.
            #   @param page_size [::Integer]
            #     Optional. Optional limit on the number of
            #     {::Google::Cloud::Kms::V1::KeyRing KeyRings} to include in the response. Further
            #     {::Google::Cloud::Kms::V1::KeyRing KeyRings} can subsequently be obtained by
            #     including the
            #     {::Google::Cloud::Kms::V1::ListKeyRingsResponse#next_page_token ListKeyRingsResponse.next_page_token}
            #     in a subsequent request.  If unspecified, the server will pick an
            #     appropriate default.
            #   @param page_token [::String]
            #     Optional. Optional pagination token, returned earlier via
            #     {::Google::Cloud::Kms::V1::ListKeyRingsResponse#next_page_token ListKeyRingsResponse.next_page_token}.
            #   @param filter [::String]
            #     Optional. Only include resources that match the filter in the response. For
            #     more information, see
            #     [Sorting and filtering list
            #     results](https://cloud.google.com/kms/docs/sorting-and-filtering).
            #   @param order_by [::String]
            #     Optional. Specify how the results should be sorted. If not specified, the
            #     results will be sorted in the default order.  For more information, see
            #     [Sorting and filtering list
            #     results](https://cloud.google.com/kms/docs/sorting-and-filtering).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Kms::V1::KeyRing>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Kms::V1::KeyRing>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/kms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Kms::V1::KeyManagementService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Kms::V1::ListKeyRingsRequest.new
            #
            #   # Call the list_key_rings method.
            #   result = client.list_key_rings request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Kms::V1::KeyRing.
            #     p item
            #   end
            #
            def list_key_rings request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Kms::V1::ListKeyRingsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_key_rings.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Kms::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_key_rings.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_key_rings.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @key_management_service_stub.call_rpc :list_key_rings, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @key_management_service_stub, :list_key_rings, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists {::Google::Cloud::Kms::V1::CryptoKey CryptoKeys}.
            #
            # @overload list_crypto_keys(request, options = nil)
            #   Pass arguments to `list_crypto_keys` via a request object, either of type
            #   {::Google::Cloud::Kms::V1::ListCryptoKeysRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Kms::V1::ListCryptoKeysRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_crypto_keys(parent: nil, page_size: nil, page_token: nil, version_view: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_crypto_keys` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the {::Google::Cloud::Kms::V1::KeyRing KeyRing}
            #     to list, in the format `projects/*/locations/*/keyRings/*`.
            #   @param page_size [::Integer]
            #     Optional. Optional limit on the number of
            #     {::Google::Cloud::Kms::V1::CryptoKey CryptoKeys} to include in the response.
            #     Further {::Google::Cloud::Kms::V1::CryptoKey CryptoKeys} can subsequently be
            #     obtained by including the
            #     {::Google::Cloud::Kms::V1::ListCryptoKeysResponse#next_page_token ListCryptoKeysResponse.next_page_token}
            #     in a subsequent request.  If unspecified, the server will pick an
            #     appropriate default.
            #   @param page_token [::String]
            #     Optional. Optional pagination token, returned earlier via
            #     {::Google::Cloud::Kms::V1::ListCryptoKeysResponse#next_page_token ListCryptoKeysResponse.next_page_token}.
            #   @param version_view [::Google::Cloud::Kms::V1::CryptoKeyVersion::CryptoKeyVersionView]
            #     The fields of the primary version to include in the response.
            #   @param filter [::String]
            #     Optional. Only include resources that match the filter in the response. For
            #     more information, see
            #     [Sorting and filtering list
            #     results](https://cloud.google.com/kms/docs/sorting-and-filtering).
            #   @param order_by [::String]
            #     Optional. Specify how the results should be sorted. If not specified, the
            #     results will be sorted in the default order. For more information, see
            #     [Sorting and filtering list
            #     results](https://cloud.google.com/kms/docs/sorting-and-filtering).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Kms::V1::CryptoKey>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Kms::V1::CryptoKey>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/kms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Kms::V1::KeyManagementService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Kms::V1::ListCryptoKeysRequest.new
            #
            #   # Call the list_crypto_keys method.
            #   result = client.list_crypto_keys request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Kms::V1::CryptoKey.
            #     p item
            #   end
            #
            def list_crypto_keys request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Kms::V1::ListCryptoKeysRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_crypto_keys.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Kms::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_crypto_keys.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_crypto_keys.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @key_management_service_stub.call_rpc :list_crypto_keys, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @key_management_service_stub, :list_crypto_keys, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersions}.
            #
            # @overload list_crypto_key_versions(request, options = nil)
            #   Pass arguments to `list_crypto_key_versions` via a request object, either of type
            #   {::Google::Cloud::Kms::V1::ListCryptoKeyVersionsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Kms::V1::ListCryptoKeyVersionsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_crypto_key_versions(parent: nil, page_size: nil, page_token: nil, view: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_crypto_key_versions` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the
            #     {::Google::Cloud::Kms::V1::CryptoKey CryptoKey} to list, in the format
            #     `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
            #   @param page_size [::Integer]
            #     Optional. Optional limit on the number of
            #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersions} to include in the
            #     response. Further {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersions}
            #     can subsequently be obtained by including the
            #     {::Google::Cloud::Kms::V1::ListCryptoKeyVersionsResponse#next_page_token ListCryptoKeyVersionsResponse.next_page_token}
            #     in a subsequent request. If unspecified, the server will pick an
            #     appropriate default.
            #   @param page_token [::String]
            #     Optional. Optional pagination token, returned earlier via
            #     {::Google::Cloud::Kms::V1::ListCryptoKeyVersionsResponse#next_page_token ListCryptoKeyVersionsResponse.next_page_token}.
            #   @param view [::Google::Cloud::Kms::V1::CryptoKeyVersion::CryptoKeyVersionView]
            #     The fields to include in the response.
            #   @param filter [::String]
            #     Optional. Only include resources that match the filter in the response. For
            #     more information, see
            #     [Sorting and filtering list
            #     results](https://cloud.google.com/kms/docs/sorting-and-filtering).
            #   @param order_by [::String]
            #     Optional. Specify how the results should be sorted. If not specified, the
            #     results will be sorted in the default order. For more information, see
            #     [Sorting and filtering list
            #     results](https://cloud.google.com/kms/docs/sorting-and-filtering).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Kms::V1::CryptoKeyVersion>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Kms::V1::CryptoKeyVersion>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/kms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Kms::V1::KeyManagementService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Kms::V1::ListCryptoKeyVersionsRequest.new
            #
            #   # Call the list_crypto_key_versions method.
            #   result = client.list_crypto_key_versions request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Kms::V1::CryptoKeyVersion.
            #     p item
            #   end
            #
            def list_crypto_key_versions request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Kms::V1::ListCryptoKeyVersionsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_crypto_key_versions.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Kms::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_crypto_key_versions.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_crypto_key_versions.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @key_management_service_stub.call_rpc :list_crypto_key_versions, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @key_management_service_stub, :list_crypto_key_versions, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists {::Google::Cloud::Kms::V1::ImportJob ImportJobs}.
            #
            # @overload list_import_jobs(request, options = nil)
            #   Pass arguments to `list_import_jobs` via a request object, either of type
            #   {::Google::Cloud::Kms::V1::ListImportJobsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Kms::V1::ListImportJobsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_import_jobs(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_import_jobs` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the {::Google::Cloud::Kms::V1::KeyRing KeyRing}
            #     to list, in the format `projects/*/locations/*/keyRings/*`.
            #   @param page_size [::Integer]
            #     Optional. Optional limit on the number of
            #     {::Google::Cloud::Kms::V1::ImportJob ImportJobs} to include in the response.
            #     Further {::Google::Cloud::Kms::V1::ImportJob ImportJobs} can subsequently be
            #     obtained by including the
            #     {::Google::Cloud::Kms::V1::ListImportJobsResponse#next_page_token ListImportJobsResponse.next_page_token}
            #     in a subsequent request. If unspecified, the server will pick an
            #     appropriate default.
            #   @param page_token [::String]
            #     Optional. Optional pagination token, returned earlier via
            #     {::Google::Cloud::Kms::V1::ListImportJobsResponse#next_page_token ListImportJobsResponse.next_page_token}.
            #   @param filter [::String]
            #     Optional. Only include resources that match the filter in the response. For
            #     more information, see
            #     [Sorting and filtering list
            #     results](https://cloud.google.com/kms/docs/sorting-and-filtering).
            #   @param order_by [::String]
            #     Optional. Specify how the results should be sorted. If not specified, the
            #     results will be sorted in the default order. For more information, see
            #     [Sorting and filtering list
            #     results](https://cloud.google.com/kms/docs/sorting-and-filtering).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Kms::V1::ImportJob>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Kms::V1::ImportJob>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/kms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Kms::V1::KeyManagementService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Kms::V1::ListImportJobsRequest.new
            #
            #   # Call the list_import_jobs method.
            #   result = client.list_import_jobs request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Kms::V1::ImportJob.
            #     p item
            #   end
            #
            def list_import_jobs request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Kms::V1::ListImportJobsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_import_jobs.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Kms::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_import_jobs.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_import_jobs.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @key_management_service_stub.call_rpc :list_import_jobs, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @key_management_service_stub, :list_import_jobs, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns metadata for a given {::Google::Cloud::Kms::V1::KeyRing KeyRing}.
            #
            # @overload get_key_ring(request, options = nil)
            #   Pass arguments to `get_key_ring` via a request object, either of type
            #   {::Google::Cloud::Kms::V1::GetKeyRingRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Kms::V1::GetKeyRingRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_key_ring(name: nil)
            #   Pass arguments to `get_key_ring` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The {::Google::Cloud::Kms::V1::KeyRing#name name} of the
            #     {::Google::Cloud::Kms::V1::KeyRing KeyRing} to get.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Kms::V1::KeyRing]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Kms::V1::KeyRing]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/kms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Kms::V1::KeyManagementService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Kms::V1::GetKeyRingRequest.new
            #
            #   # Call the get_key_ring method.
            #   result = client.get_key_ring request
            #
            #   # The returned object is of type Google::Cloud::Kms::V1::KeyRing.
            #   p result
            #
            def get_key_ring request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Kms::V1::GetKeyRingRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_key_ring.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Kms::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_key_ring.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_key_ring.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @key_management_service_stub.call_rpc :get_key_ring, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns metadata for a given {::Google::Cloud::Kms::V1::CryptoKey CryptoKey}, as
            # well as its {::Google::Cloud::Kms::V1::CryptoKey#primary primary}
            # {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion}.
            #
            # @overload get_crypto_key(request, options = nil)
            #   Pass arguments to `get_crypto_key` via a request object, either of type
            #   {::Google::Cloud::Kms::V1::GetCryptoKeyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Kms::V1::GetCryptoKeyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_crypto_key(name: nil)
            #   Pass arguments to `get_crypto_key` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The {::Google::Cloud::Kms::V1::CryptoKey#name name} of the
            #     {::Google::Cloud::Kms::V1::CryptoKey CryptoKey} to get.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Kms::V1::CryptoKey]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Kms::V1::CryptoKey]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/kms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Kms::V1::KeyManagementService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Kms::V1::GetCryptoKeyRequest.new
            #
            #   # Call the get_crypto_key method.
            #   result = client.get_crypto_key request
            #
            #   # The returned object is of type Google::Cloud::Kms::V1::CryptoKey.
            #   p result
            #
            def get_crypto_key request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Kms::V1::GetCryptoKeyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_crypto_key.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Kms::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_crypto_key.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_crypto_key.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @key_management_service_stub.call_rpc :get_crypto_key, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns metadata for a given
            # {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion}.
            #
            # @overload get_crypto_key_version(request, options = nil)
            #   Pass arguments to `get_crypto_key_version` via a request object, either of type
            #   {::Google::Cloud::Kms::V1::GetCryptoKeyVersionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Kms::V1::GetCryptoKeyVersionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_crypto_key_version(name: nil)
            #   Pass arguments to `get_crypto_key_version` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The {::Google::Cloud::Kms::V1::CryptoKeyVersion#name name} of the
            #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} to get.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Kms::V1::CryptoKeyVersion]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Kms::V1::CryptoKeyVersion]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/kms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Kms::V1::KeyManagementService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Kms::V1::GetCryptoKeyVersionRequest.new
            #
            #   # Call the get_crypto_key_version method.
            #   result = client.get_crypto_key_version request
            #
            #   # The returned object is of type Google::Cloud::Kms::V1::CryptoKeyVersion.
            #   p result
            #
            def get_crypto_key_version request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Kms::V1::GetCryptoKeyVersionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_crypto_key_version.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Kms::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_crypto_key_version.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_crypto_key_version.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @key_management_service_stub.call_rpc :get_crypto_key_version, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns the public key for the given
            # {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion}. The
            # {::Google::Cloud::Kms::V1::CryptoKey#purpose CryptoKey.purpose} must be
            # {::Google::Cloud::Kms::V1::CryptoKey::CryptoKeyPurpose::ASYMMETRIC_SIGN ASYMMETRIC_SIGN}
            # or
            # {::Google::Cloud::Kms::V1::CryptoKey::CryptoKeyPurpose::ASYMMETRIC_DECRYPT ASYMMETRIC_DECRYPT}.
            #
            # @overload get_public_key(request, options = nil)
            #   Pass arguments to `get_public_key` via a request object, either of type
            #   {::Google::Cloud::Kms::V1::GetPublicKeyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Kms::V1::GetPublicKeyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_public_key(name: nil, public_key_format: nil)
            #   Pass arguments to `get_public_key` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The {::Google::Cloud::Kms::V1::CryptoKeyVersion#name name} of the
            #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} public key to get.
            #   @param public_key_format [::Google::Cloud::Kms::V1::PublicKey::PublicKeyFormat]
            #     Optional. The {::Google::Cloud::Kms::V1::PublicKey PublicKey} format specified
            #     by the user. This field is required for PQC algorithms. If specified, the
            #     public key will be exported through the
            #     {::Google::Cloud::Kms::V1::PublicKey#public_key public_key} field in the
            #     requested format. Otherwise, the {::Google::Cloud::Kms::V1::PublicKey#pem pem}
            #     field will be populated for non-PQC algorithms, and an error will be
            #     returned for PQC algorithms.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Kms::V1::PublicKey]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Kms::V1::PublicKey]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/kms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Kms::V1::KeyManagementService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Kms::V1::GetPublicKeyRequest.new
            #
            #   # Call the get_public_key method.
            #   result = client.get_public_key request
            #
            #   # The returned object is of type Google::Cloud::Kms::V1::PublicKey.
            #   p result
            #
            def get_public_key request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Kms::V1::GetPublicKeyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_public_key.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Kms::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_public_key.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_public_key.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @key_management_service_stub.call_rpc :get_public_key, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns metadata for a given {::Google::Cloud::Kms::V1::ImportJob ImportJob}.
            #
            # @overload get_import_job(request, options = nil)
            #   Pass arguments to `get_import_job` via a request object, either of type
            #   {::Google::Cloud::Kms::V1::GetImportJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Kms::V1::GetImportJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_import_job(name: nil)
            #   Pass arguments to `get_import_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The {::Google::Cloud::Kms::V1::ImportJob#name name} of the
            #     {::Google::Cloud::Kms::V1::ImportJob ImportJob} to get.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Kms::V1::ImportJob]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Kms::V1::ImportJob]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/kms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Kms::V1::KeyManagementService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Kms::V1::GetImportJobRequest.new
            #
            #   # Call the get_import_job method.
            #   result = client.get_import_job request
            #
            #   # The returned object is of type Google::Cloud::Kms::V1::ImportJob.
            #   p result
            #
            def get_import_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Kms::V1::GetImportJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_import_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Kms::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_import_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_import_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @key_management_service_stub.call_rpc :get_import_job, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Create a new {::Google::Cloud::Kms::V1::KeyRing KeyRing} in a given Project and
            # Location.
            #
            # @overload create_key_ring(request, options = nil)
            #   Pass arguments to `create_key_ring` via a request object, either of type
            #   {::Google::Cloud::Kms::V1::CreateKeyRingRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Kms::V1::CreateKeyRingRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_key_ring(parent: nil, key_ring_id: nil, key_ring: nil)
            #   Pass arguments to `create_key_ring` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the location associated with the
            #     {::Google::Cloud::Kms::V1::KeyRing KeyRings}, in the format
            #     `projects/*/locations/*`.
            #   @param key_ring_id [::String]
            #     Required. It must be unique within a location and match the regular
            #     expression `[a-zA-Z0-9_-]{1,63}`
            #   @param key_ring [::Google::Cloud::Kms::V1::KeyRing, ::Hash]
            #     Required. A {::Google::Cloud::Kms::V1::KeyRing KeyRing} with initial field
            #     values.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Kms::V1::KeyRing]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Kms::V1::KeyRing]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/kms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Kms::V1::KeyManagementService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Kms::V1::CreateKeyRingRequest.new
            #
            #   # Call the create_key_ring method.
            #   result = client.create_key_ring request
            #
            #   # The returned object is of type Google::Cloud::Kms::V1::KeyRing.
            #   p result
            #
            def create_key_ring request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Kms::V1::CreateKeyRingRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_key_ring.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Kms::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_key_ring.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_key_ring.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @key_management_service_stub.call_rpc :create_key_ring, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Create a new {::Google::Cloud::Kms::V1::CryptoKey CryptoKey} within a
            # {::Google::Cloud::Kms::V1::KeyRing KeyRing}.
            #
            # {::Google::Cloud::Kms::V1::CryptoKey#purpose CryptoKey.purpose} and
            # {::Google::Cloud::Kms::V1::CryptoKeyVersionTemplate#algorithm CryptoKey.version_template.algorithm}
            # are required.
            #
            # @overload create_crypto_key(request, options = nil)
            #   Pass arguments to `create_crypto_key` via a request object, either of type
            #   {::Google::Cloud::Kms::V1::CreateCryptoKeyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Kms::V1::CreateCryptoKeyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_crypto_key(parent: nil, crypto_key_id: nil, crypto_key: nil, skip_initial_version_creation: nil)
            #   Pass arguments to `create_crypto_key` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The {::Google::Cloud::Kms::V1::KeyRing#name name} of the KeyRing
            #     associated with the {::Google::Cloud::Kms::V1::CryptoKey CryptoKeys}.
            #   @param crypto_key_id [::String]
            #     Required. It must be unique within a KeyRing and match the regular
            #     expression `[a-zA-Z0-9_-]{1,63}`
            #   @param crypto_key [::Google::Cloud::Kms::V1::CryptoKey, ::Hash]
            #     Required. A {::Google::Cloud::Kms::V1::CryptoKey CryptoKey} with initial field
            #     values.
            #   @param skip_initial_version_creation [::Boolean]
            #     If set to true, the request will create a
            #     {::Google::Cloud::Kms::V1::CryptoKey CryptoKey} without any
            #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersions}. You must
            #     manually call
            #     {::Google::Cloud::Kms::V1::KeyManagementService::Client#create_crypto_key_version CreateCryptoKeyVersion}
            #     or
            #     {::Google::Cloud::Kms::V1::KeyManagementService::Client#import_crypto_key_version ImportCryptoKeyVersion}
            #     before you can use this {::Google::Cloud::Kms::V1::CryptoKey CryptoKey}.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Kms::V1::CryptoKey]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Kms::V1::CryptoKey]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/kms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Kms::V1::KeyManagementService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Kms::V1::CreateCryptoKeyRequest.new
            #
            #   # Call the create_crypto_key method.
            #   result = client.create_crypto_key request
            #
            #   # The returned object is of type Google::Cloud::Kms::V1::CryptoKey.
            #   p result
            #
            def create_crypto_key request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Kms::V1::CreateCryptoKeyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_crypto_key.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Kms::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_crypto_key.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_crypto_key.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @key_management_service_stub.call_rpc :create_crypto_key, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Create a new {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} in a
            # {::Google::Cloud::Kms::V1::CryptoKey CryptoKey}.
            #
            # The server will assign the next sequential id. If unset,
            # {::Google::Cloud::Kms::V1::CryptoKeyVersion#state state} will be set to
            # {::Google::Cloud::Kms::V1::CryptoKeyVersion::CryptoKeyVersionState::ENABLED ENABLED}.
            #
            # @overload create_crypto_key_version(request, options = nil)
            #   Pass arguments to `create_crypto_key_version` via a request object, either of type
            #   {::Google::Cloud::Kms::V1::CreateCryptoKeyVersionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Kms::V1::CreateCryptoKeyVersionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_crypto_key_version(parent: nil, crypto_key_version: nil)
            #   Pass arguments to `create_crypto_key_version` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The {::Google::Cloud::Kms::V1::CryptoKey#name name} of the
            #     {::Google::Cloud::Kms::V1::CryptoKey CryptoKey} associated with the
            #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersions}.
            #   @param crypto_key_version [::Google::Cloud::Kms::V1::CryptoKeyVersion, ::Hash]
            #     Required. A {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} with
            #     initial field values.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Kms::V1::CryptoKeyVersion]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Kms::V1::CryptoKeyVersion]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/kms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Kms::V1::KeyManagementService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Kms::V1::CreateCryptoKeyVersionRequest.new
            #
            #   # Call the create_crypto_key_version method.
            #   result = client.create_crypto_key_version request
            #
            #   # The returned object is of type Google::Cloud::Kms::V1::CryptoKeyVersion.
            #   p result
            #
            def create_crypto_key_version request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Kms::V1::CreateCryptoKeyVersionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_crypto_key_version.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Kms::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_crypto_key_version.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_crypto_key_version.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @key_management_service_stub.call_rpc :create_crypto_key_version, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Import wrapped key material into a
            # {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion}.
            #
            # All requests must specify a {::Google::Cloud::Kms::V1::CryptoKey CryptoKey}. If
            # a {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} is additionally
            # specified in the request, key material will be reimported into that
            # version. Otherwise, a new version will be created, and will be assigned the
            # next sequential id within the {::Google::Cloud::Kms::V1::CryptoKey CryptoKey}.
            #
            # @overload import_crypto_key_version(request, options = nil)
            #   Pass arguments to `import_crypto_key_version` via a request object, either of type
            #   {::Google::Cloud::Kms::V1::ImportCryptoKeyVersionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Kms::V1::ImportCryptoKeyVersionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload import_crypto_key_version(parent: nil, crypto_key_version: nil, algorithm: nil, import_job: nil, wrapped_key: nil, rsa_aes_wrapped_key: nil)
            #   Pass arguments to `import_crypto_key_version` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The {::Google::Cloud::Kms::V1::CryptoKey#name name} of the
            #     {::Google::Cloud::Kms::V1::CryptoKey CryptoKey} to be imported into.
            #
            #     The create permission is only required on this key when creating a new
            #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion}.
            #   @param crypto_key_version [::String]
            #     Optional. The optional {::Google::Cloud::Kms::V1::CryptoKeyVersion#name name} of
            #     an existing {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} to
            #     target for an import operation. If this field is not present, a new
            #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} containing the
            #     supplied key material is created.
            #
            #     If this field is present, the supplied key material is imported into
            #     the existing {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion}. To
            #     import into an existing
            #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion}, the
            #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} must be a child of
            #     {::Google::Cloud::Kms::V1::ImportCryptoKeyVersionRequest#parent ImportCryptoKeyVersionRequest.parent},
            #     have been previously created via
            #     {::Google::Cloud::Kms::V1::KeyManagementService::Client#import_crypto_key_version ImportCryptoKeyVersion},
            #     and be in
            #     {::Google::Cloud::Kms::V1::CryptoKeyVersion::CryptoKeyVersionState::DESTROYED DESTROYED}
            #     or
            #     {::Google::Cloud::Kms::V1::CryptoKeyVersion::CryptoKeyVersionState::IMPORT_FAILED IMPORT_FAILED}
            #     state. The key material and algorithm must match the previous
            #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} exactly if the
            #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} has ever contained
            #     key material.
            #   @param algorithm [::Google::Cloud::Kms::V1::CryptoKeyVersion::CryptoKeyVersionAlgorithm]
            #     Required. The
            #     {::Google::Cloud::Kms::V1::CryptoKeyVersion::CryptoKeyVersionAlgorithm algorithm}
            #     of the key being imported. This does not need to match the
            #     {::Google::Cloud::Kms::V1::CryptoKey#version_template version_template} of the
            #     {::Google::Cloud::Kms::V1::CryptoKey CryptoKey} this version imports into.
            #   @param import_job [::String]
            #     Required. The {::Google::Cloud::Kms::V1::ImportJob#name name} of the
            #     {::Google::Cloud::Kms::V1::ImportJob ImportJob} that was used to wrap this key
            #     material.
            #   @param wrapped_key [::String]
            #     Optional. The wrapped key material to import.
            #
            #     Before wrapping, key material must be formatted. If importing symmetric key
            #     material, the expected key material format is plain bytes. If importing
            #     asymmetric key material, the expected key material format is PKCS#8-encoded
            #     DER (the PrivateKeyInfo structure from RFC 5208).
            #
            #     When wrapping with import methods
            #     ({::Google::Cloud::Kms::V1::ImportJob::ImportMethod::RSA_OAEP_3072_SHA1_AES_256 RSA_OAEP_3072_SHA1_AES_256}
            #     or
            #     {::Google::Cloud::Kms::V1::ImportJob::ImportMethod::RSA_OAEP_4096_SHA1_AES_256 RSA_OAEP_4096_SHA1_AES_256}
            #     or
            #     {::Google::Cloud::Kms::V1::ImportJob::ImportMethod::RSA_OAEP_3072_SHA256_AES_256 RSA_OAEP_3072_SHA256_AES_256}
            #     or
            #     {::Google::Cloud::Kms::V1::ImportJob::ImportMethod::RSA_OAEP_4096_SHA256_AES_256 RSA_OAEP_4096_SHA256_AES_256}),
            #
            #     this field must contain the concatenation of:
            #     <ol>
            #       <li>An ephemeral AES-256 wrapping key wrapped with the
            #           {::Google::Cloud::Kms::V1::ImportJob#public_key public_key} using
            #           RSAES-OAEP with SHA-1/SHA-256, MGF1 with SHA-1/SHA-256, and an empty
            #           label.
            #       </li>
            #       <li>The formatted key to be imported, wrapped with the ephemeral AES-256
            #           key using AES-KWP (RFC 5649).
            #       </li>
            #     </ol>
            #
            #     This format is the same as the format produced by PKCS#11 mechanism
            #     CKM_RSA_AES_KEY_WRAP.
            #
            #     When wrapping with import methods
            #     ({::Google::Cloud::Kms::V1::ImportJob::ImportMethod::RSA_OAEP_3072_SHA256 RSA_OAEP_3072_SHA256}
            #     or
            #     {::Google::Cloud::Kms::V1::ImportJob::ImportMethod::RSA_OAEP_4096_SHA256 RSA_OAEP_4096_SHA256}),
            #
            #     this field must contain the formatted key to be imported, wrapped with the
            #     {::Google::Cloud::Kms::V1::ImportJob#public_key public_key} using RSAES-OAEP
            #     with SHA-256, MGF1 with SHA-256, and an empty label.
            #   @param rsa_aes_wrapped_key [::String]
            #     Optional. This field has the same meaning as
            #     {::Google::Cloud::Kms::V1::ImportCryptoKeyVersionRequest#wrapped_key wrapped_key}.
            #     Prefer to use that field in new work. Either that field or this field
            #     (but not both) must be specified.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Kms::V1::CryptoKeyVersion]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Kms::V1::CryptoKeyVersion]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/kms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Kms::V1::KeyManagementService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Kms::V1::ImportCryptoKeyVersionRequest.new
            #
            #   # Call the import_crypto_key_version method.
            #   result = client.import_crypto_key_version request
            #
            #   # The returned object is of type Google::Cloud::Kms::V1::CryptoKeyVersion.
            #   p result
            #
            def import_crypto_key_version request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Kms::V1::ImportCryptoKeyVersionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.import_crypto_key_version.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Kms::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.import_crypto_key_version.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.import_crypto_key_version.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @key_management_service_stub.call_rpc :import_crypto_key_version, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Create a new {::Google::Cloud::Kms::V1::ImportJob ImportJob} within a
            # {::Google::Cloud::Kms::V1::KeyRing KeyRing}.
            #
            # {::Google::Cloud::Kms::V1::ImportJob#import_method ImportJob.import_method} is
            # required.
            #
            # @overload create_import_job(request, options = nil)
            #   Pass arguments to `create_import_job` via a request object, either of type
            #   {::Google::Cloud::Kms::V1::CreateImportJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Kms::V1::CreateImportJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_import_job(parent: nil, import_job_id: nil, import_job: nil)
            #   Pass arguments to `create_import_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The {::Google::Cloud::Kms::V1::KeyRing#name name} of the
            #     {::Google::Cloud::Kms::V1::KeyRing KeyRing} associated with the
            #     {::Google::Cloud::Kms::V1::ImportJob ImportJobs}.
            #   @param import_job_id [::String]
            #     Required. It must be unique within a KeyRing and match the regular
            #     expression `[a-zA-Z0-9_-]{1,63}`
            #   @param import_job [::Google::Cloud::Kms::V1::ImportJob, ::Hash]
            #     Required. An {::Google::Cloud::Kms::V1::ImportJob ImportJob} with initial field
            #     values.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Kms::V1::ImportJob]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Kms::V1::ImportJob]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/kms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Kms::V1::KeyManagementService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Kms::V1::CreateImportJobRequest.new
            #
            #   # Call the create_import_job method.
            #   result = client.create_import_job request
            #
            #   # The returned object is of type Google::Cloud::Kms::V1::ImportJob.
            #   p result
            #
            def create_import_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Kms::V1::CreateImportJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_import_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Kms::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_import_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_import_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @key_management_service_stub.call_rpc :create_import_job, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Update a {::Google::Cloud::Kms::V1::CryptoKey CryptoKey}.
            #
            # @overload update_crypto_key(request, options = nil)
            #   Pass arguments to `update_crypto_key` via a request object, either of type
            #   {::Google::Cloud::Kms::V1::UpdateCryptoKeyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Kms::V1::UpdateCryptoKeyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_crypto_key(crypto_key: nil, update_mask: nil)
            #   Pass arguments to `update_crypto_key` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param crypto_key [::Google::Cloud::Kms::V1::CryptoKey, ::Hash]
            #     Required. {::Google::Cloud::Kms::V1::CryptoKey CryptoKey} with updated values.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. List of fields to be updated in this request.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Kms::V1::CryptoKey]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Kms::V1::CryptoKey]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/kms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Kms::V1::KeyManagementService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Kms::V1::UpdateCryptoKeyRequest.new
            #
            #   # Call the update_crypto_key method.
            #   result = client.update_crypto_key request
            #
            #   # The returned object is of type Google::Cloud::Kms::V1::CryptoKey.
            #   p result
            #
            def update_crypto_key request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Kms::V1::UpdateCryptoKeyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_crypto_key.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Kms::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.crypto_key&.name
                header_params["crypto_key.name"] = request.crypto_key.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_crypto_key.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_crypto_key.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @key_management_service_stub.call_rpc :update_crypto_key, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Update a {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion}'s
            # metadata.
            #
            # {::Google::Cloud::Kms::V1::CryptoKeyVersion#state state} may be changed between
            # {::Google::Cloud::Kms::V1::CryptoKeyVersion::CryptoKeyVersionState::ENABLED ENABLED}
            # and
            # {::Google::Cloud::Kms::V1::CryptoKeyVersion::CryptoKeyVersionState::DISABLED DISABLED}
            # using this method. See
            # {::Google::Cloud::Kms::V1::KeyManagementService::Client#destroy_crypto_key_version DestroyCryptoKeyVersion}
            # and
            # {::Google::Cloud::Kms::V1::KeyManagementService::Client#restore_crypto_key_version RestoreCryptoKeyVersion}
            # to move between other states.
            #
            # @overload update_crypto_key_version(request, options = nil)
            #   Pass arguments to `update_crypto_key_version` via a request object, either of type
            #   {::Google::Cloud::Kms::V1::UpdateCryptoKeyVersionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Kms::V1::UpdateCryptoKeyVersionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_crypto_key_version(crypto_key_version: nil, update_mask: nil)
            #   Pass arguments to `update_crypto_key_version` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param crypto_key_version [::Google::Cloud::Kms::V1::CryptoKeyVersion, ::Hash]
            #     Required. {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} with
            #     updated values.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. List of fields to be updated in this request.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Kms::V1::CryptoKeyVersion]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Kms::V1::CryptoKeyVersion]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/kms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Kms::V1::KeyManagementService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Kms::V1::UpdateCryptoKeyVersionRequest.new
            #
            #   # Call the update_crypto_key_version method.
            #   result = client.update_crypto_key_version request
            #
            #   # The returned object is of type Google::Cloud::Kms::V1::CryptoKeyVersion.
            #   p result
            #
            def update_crypto_key_version request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Kms::V1::UpdateCryptoKeyVersionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_crypto_key_version.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Kms::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.crypto_key_version&.name
                header_params["crypto_key_version.name"] = request.crypto_key_version.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_crypto_key_version.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_crypto_key_version.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @key_management_service_stub.call_rpc :update_crypto_key_version, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Update the version of a {::Google::Cloud::Kms::V1::CryptoKey CryptoKey} that
            # will be used in
            # {::Google::Cloud::Kms::V1::KeyManagementService::Client#encrypt Encrypt}.
            #
            # Returns an error if called on a key whose purpose is not
            # {::Google::Cloud::Kms::V1::CryptoKey::CryptoKeyPurpose::ENCRYPT_DECRYPT ENCRYPT_DECRYPT}.
            #
            # @overload update_crypto_key_primary_version(request, options = nil)
            #   Pass arguments to `update_crypto_key_primary_version` via a request object, either of type
            #   {::Google::Cloud::Kms::V1::UpdateCryptoKeyPrimaryVersionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Kms::V1::UpdateCryptoKeyPrimaryVersionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_crypto_key_primary_version(name: nil, crypto_key_version_id: nil)
            #   Pass arguments to `update_crypto_key_primary_version` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the
            #     {::Google::Cloud::Kms::V1::CryptoKey CryptoKey} to update.
            #   @param crypto_key_version_id [::String]
            #     Required. The id of the child
            #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} to use as primary.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Kms::V1::CryptoKey]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Kms::V1::CryptoKey]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/kms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Kms::V1::KeyManagementService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Kms::V1::UpdateCryptoKeyPrimaryVersionRequest.new
            #
            #   # Call the update_crypto_key_primary_version method.
            #   result = client.update_crypto_key_primary_version request
            #
            #   # The returned object is of type Google::Cloud::Kms::V1::CryptoKey.
            #   p result
            #
            def update_crypto_key_primary_version request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Kms::V1::UpdateCryptoKeyPrimaryVersionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_crypto_key_primary_version.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Kms::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_crypto_key_primary_version.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_crypto_key_primary_version.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @key_management_service_stub.call_rpc :update_crypto_key_primary_version, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Schedule a {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} for
            # destruction.
            #
            # Upon calling this method,
            # {::Google::Cloud::Kms::V1::CryptoKeyVersion#state CryptoKeyVersion.state} will
            # be set to
            # {::Google::Cloud::Kms::V1::CryptoKeyVersion::CryptoKeyVersionState::DESTROY_SCHEDULED DESTROY_SCHEDULED},
            # and {::Google::Cloud::Kms::V1::CryptoKeyVersion#destroy_time destroy_time} will
            # be set to the time
            # {::Google::Cloud::Kms::V1::CryptoKey#destroy_scheduled_duration destroy_scheduled_duration}
            # in the future. At that time, the
            # {::Google::Cloud::Kms::V1::CryptoKeyVersion#state state} will automatically
            # change to
            # {::Google::Cloud::Kms::V1::CryptoKeyVersion::CryptoKeyVersionState::DESTROYED DESTROYED},
            # and the key material will be irrevocably destroyed.
            #
            # Before the
            # {::Google::Cloud::Kms::V1::CryptoKeyVersion#destroy_time destroy_time} is
            # reached,
            # {::Google::Cloud::Kms::V1::KeyManagementService::Client#restore_crypto_key_version RestoreCryptoKeyVersion}
            # may be called to reverse the process.
            #
            # @overload destroy_crypto_key_version(request, options = nil)
            #   Pass arguments to `destroy_crypto_key_version` via a request object, either of type
            #   {::Google::Cloud::Kms::V1::DestroyCryptoKeyVersionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Kms::V1::DestroyCryptoKeyVersionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload destroy_crypto_key_version(name: nil)
            #   Pass arguments to `destroy_crypto_key_version` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the
            #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} to destroy.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Kms::V1::CryptoKeyVersion]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Kms::V1::CryptoKeyVersion]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/kms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Kms::V1::KeyManagementService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Kms::V1::DestroyCryptoKeyVersionRequest.new
            #
            #   # Call the destroy_crypto_key_version method.
            #   result = client.destroy_crypto_key_version request
            #
            #   # The returned object is of type Google::Cloud::Kms::V1::CryptoKeyVersion.
            #   p result
            #
            def destroy_crypto_key_version request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Kms::V1::DestroyCryptoKeyVersionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.destroy_crypto_key_version.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Kms::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.destroy_crypto_key_version.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.destroy_crypto_key_version.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @key_management_service_stub.call_rpc :destroy_crypto_key_version, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Restore a {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} in the
            # {::Google::Cloud::Kms::V1::CryptoKeyVersion::CryptoKeyVersionState::DESTROY_SCHEDULED DESTROY_SCHEDULED}
            # state.
            #
            # Upon restoration of the CryptoKeyVersion,
            # {::Google::Cloud::Kms::V1::CryptoKeyVersion#state state} will be set to
            # {::Google::Cloud::Kms::V1::CryptoKeyVersion::CryptoKeyVersionState::DISABLED DISABLED},
            # and {::Google::Cloud::Kms::V1::CryptoKeyVersion#destroy_time destroy_time} will
            # be cleared.
            #
            # @overload restore_crypto_key_version(request, options = nil)
            #   Pass arguments to `restore_crypto_key_version` via a request object, either of type
            #   {::Google::Cloud::Kms::V1::RestoreCryptoKeyVersionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Kms::V1::RestoreCryptoKeyVersionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload restore_crypto_key_version(name: nil)
            #   Pass arguments to `restore_crypto_key_version` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the
            #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} to restore.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Kms::V1::CryptoKeyVersion]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Kms::V1::CryptoKeyVersion]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/kms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Kms::V1::KeyManagementService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Kms::V1::RestoreCryptoKeyVersionRequest.new
            #
            #   # Call the restore_crypto_key_version method.
            #   result = client.restore_crypto_key_version request
            #
            #   # The returned object is of type Google::Cloud::Kms::V1::CryptoKeyVersion.
            #   p result
            #
            def restore_crypto_key_version request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Kms::V1::RestoreCryptoKeyVersionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.restore_crypto_key_version.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Kms::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.restore_crypto_key_version.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.restore_crypto_key_version.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @key_management_service_stub.call_rpc :restore_crypto_key_version, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Encrypts data, so that it can only be recovered by a call to
            # {::Google::Cloud::Kms::V1::KeyManagementService::Client#decrypt Decrypt}. The
            # {::Google::Cloud::Kms::V1::CryptoKey#purpose CryptoKey.purpose} must be
            # {::Google::Cloud::Kms::V1::CryptoKey::CryptoKeyPurpose::ENCRYPT_DECRYPT ENCRYPT_DECRYPT}.
            #
            # @overload encrypt(request, options = nil)
            #   Pass arguments to `encrypt` via a request object, either of type
            #   {::Google::Cloud::Kms::V1::EncryptRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Kms::V1::EncryptRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload encrypt(name: nil, plaintext: nil, additional_authenticated_data: nil, plaintext_crc32c: nil, additional_authenticated_data_crc32c: nil)
            #   Pass arguments to `encrypt` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the
            #     {::Google::Cloud::Kms::V1::CryptoKey CryptoKey} or
            #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} to use for
            #     encryption.
            #
            #     If a {::Google::Cloud::Kms::V1::CryptoKey CryptoKey} is specified, the server
            #     will use its {::Google::Cloud::Kms::V1::CryptoKey#primary primary version}.
            #   @param plaintext [::String]
            #     Required. The data to encrypt. Must be no larger than 64KiB.
            #
            #     The maximum size depends on the key version's
            #     {::Google::Cloud::Kms::V1::CryptoKeyVersionTemplate#protection_level protection_level}.
            #     For {::Google::Cloud::Kms::V1::ProtectionLevel::SOFTWARE SOFTWARE},
            #     {::Google::Cloud::Kms::V1::ProtectionLevel::EXTERNAL EXTERNAL}, and
            #     {::Google::Cloud::Kms::V1::ProtectionLevel::EXTERNAL_VPC EXTERNAL_VPC} keys, the
            #     plaintext must be no larger than 64KiB. For
            #     {::Google::Cloud::Kms::V1::ProtectionLevel::HSM HSM} keys, the combined length of
            #     the plaintext and additional_authenticated_data fields must be no larger
            #     than 8KiB.
            #   @param additional_authenticated_data [::String]
            #     Optional. Optional data that, if specified, must also be provided during
            #     decryption through
            #     {::Google::Cloud::Kms::V1::DecryptRequest#additional_authenticated_data DecryptRequest.additional_authenticated_data}.
            #
            #     The maximum size depends on the key version's
            #     {::Google::Cloud::Kms::V1::CryptoKeyVersionTemplate#protection_level protection_level}.
            #     For {::Google::Cloud::Kms::V1::ProtectionLevel::SOFTWARE SOFTWARE},
            #     {::Google::Cloud::Kms::V1::ProtectionLevel::EXTERNAL EXTERNAL}, and
            #     {::Google::Cloud::Kms::V1::ProtectionLevel::EXTERNAL_VPC EXTERNAL_VPC} keys the
            #     AAD must be no larger than 64KiB. For
            #     {::Google::Cloud::Kms::V1::ProtectionLevel::HSM HSM} keys, the combined length of
            #     the plaintext and additional_authenticated_data fields must be no larger
            #     than 8KiB.
            #   @param plaintext_crc32c [::Google::Protobuf::Int64Value, ::Hash]
            #     Optional. An optional CRC32C checksum of the
            #     {::Google::Cloud::Kms::V1::EncryptRequest#plaintext EncryptRequest.plaintext}.
            #     If specified,
            #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
            #     verify the integrity of the received
            #     {::Google::Cloud::Kms::V1::EncryptRequest#plaintext EncryptRequest.plaintext}
            #     using this checksum.
            #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
            #     report an error if the checksum verification fails. If you receive a
            #     checksum error, your client should verify that
            #     CRC32C({::Google::Cloud::Kms::V1::EncryptRequest#plaintext EncryptRequest.plaintext})
            #     is equal to
            #     {::Google::Cloud::Kms::V1::EncryptRequest#plaintext_crc32c EncryptRequest.plaintext_crc32c},
            #     and if so, perform a limited number of retries. A persistent mismatch may
            #     indicate an issue in your computation of the CRC32C checksum. Note: This
            #     field is defined as int64 for reasons of compatibility across different
            #     languages. However, it is a non-negative integer, which will never exceed
            #     2^32-1, and can be safely downconverted to uint32 in languages that support
            #     this type.
            #   @param additional_authenticated_data_crc32c [::Google::Protobuf::Int64Value, ::Hash]
            #     Optional. An optional CRC32C checksum of the
            #     {::Google::Cloud::Kms::V1::EncryptRequest#additional_authenticated_data EncryptRequest.additional_authenticated_data}.
            #     If specified,
            #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
            #     verify the integrity of the received
            #     {::Google::Cloud::Kms::V1::EncryptRequest#additional_authenticated_data EncryptRequest.additional_authenticated_data}
            #     using this checksum.
            #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
            #     report an error if the checksum verification fails. If you receive a
            #     checksum error, your client should verify that
            #     CRC32C({::Google::Cloud::Kms::V1::EncryptRequest#additional_authenticated_data EncryptRequest.additional_authenticated_data})
            #     is equal to
            #     {::Google::Cloud::Kms::V1::EncryptRequest#additional_authenticated_data_crc32c EncryptRequest.additional_authenticated_data_crc32c},
            #     and if so, perform a limited number of retries. A persistent mismatch may
            #     indicate an issue in your computation of the CRC32C checksum. Note: This
            #     field is defined as int64 for reasons of compatibility across different
            #     languages. However, it is a non-negative integer, which will never exceed
            #     2^32-1, and can be safely downconverted to uint32 in languages that support
            #     this type.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Kms::V1::EncryptResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Kms::V1::EncryptResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/kms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Kms::V1::KeyManagementService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Kms::V1::EncryptRequest.new
            #
            #   # Call the encrypt method.
            #   result = client.encrypt request
            #
            #   # The returned object is of type Google::Cloud::Kms::V1::EncryptResponse.
            #   p result
            #
            def encrypt request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Kms::V1::EncryptRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.encrypt.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Kms::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.encrypt.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.encrypt.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @key_management_service_stub.call_rpc :encrypt, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Decrypts data that was protected by
            # {::Google::Cloud::Kms::V1::KeyManagementService::Client#encrypt Encrypt}. The
            # {::Google::Cloud::Kms::V1::CryptoKey#purpose CryptoKey.purpose} must be
            # {::Google::Cloud::Kms::V1::CryptoKey::CryptoKeyPurpose::ENCRYPT_DECRYPT ENCRYPT_DECRYPT}.
            #
            # @overload decrypt(request, options = nil)
            #   Pass arguments to `decrypt` via a request object, either of type
            #   {::Google::Cloud::Kms::V1::DecryptRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Kms::V1::DecryptRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload decrypt(name: nil, ciphertext: nil, additional_authenticated_data: nil, ciphertext_crc32c: nil, additional_authenticated_data_crc32c: nil)
            #   Pass arguments to `decrypt` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the
            #     {::Google::Cloud::Kms::V1::CryptoKey CryptoKey} to use for decryption. The
            #     server will choose the appropriate version.
            #   @param ciphertext [::String]
            #     Required. The encrypted data originally returned in
            #     {::Google::Cloud::Kms::V1::EncryptResponse#ciphertext EncryptResponse.ciphertext}.
            #   @param additional_authenticated_data [::String]
            #     Optional. Optional data that must match the data originally supplied in
            #     {::Google::Cloud::Kms::V1::EncryptRequest#additional_authenticated_data EncryptRequest.additional_authenticated_data}.
            #   @param ciphertext_crc32c [::Google::Protobuf::Int64Value, ::Hash]
            #     Optional. An optional CRC32C checksum of the
            #     {::Google::Cloud::Kms::V1::DecryptRequest#ciphertext DecryptRequest.ciphertext}.
            #     If specified,
            #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
            #     verify the integrity of the received
            #     {::Google::Cloud::Kms::V1::DecryptRequest#ciphertext DecryptRequest.ciphertext}
            #     using this checksum.
            #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
            #     report an error if the checksum verification fails. If you receive a
            #     checksum error, your client should verify that
            #     CRC32C({::Google::Cloud::Kms::V1::DecryptRequest#ciphertext DecryptRequest.ciphertext})
            #     is equal to
            #     {::Google::Cloud::Kms::V1::DecryptRequest#ciphertext_crc32c DecryptRequest.ciphertext_crc32c},
            #     and if so, perform a limited number of retries. A persistent mismatch may
            #     indicate an issue in your computation of the CRC32C checksum. Note: This
            #     field is defined as int64 for reasons of compatibility across different
            #     languages. However, it is a non-negative integer, which will never exceed
            #     2^32-1, and can be safely downconverted to uint32 in languages that support
            #     this type.
            #   @param additional_authenticated_data_crc32c [::Google::Protobuf::Int64Value, ::Hash]
            #     Optional. An optional CRC32C checksum of the
            #     {::Google::Cloud::Kms::V1::DecryptRequest#additional_authenticated_data DecryptRequest.additional_authenticated_data}.
            #     If specified,
            #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
            #     verify the integrity of the received
            #     {::Google::Cloud::Kms::V1::DecryptRequest#additional_authenticated_data DecryptRequest.additional_authenticated_data}
            #     using this checksum.
            #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
            #     report an error if the checksum verification fails. If you receive a
            #     checksum error, your client should verify that
            #     CRC32C({::Google::Cloud::Kms::V1::DecryptRequest#additional_authenticated_data DecryptRequest.additional_authenticated_data})
            #     is equal to
            #     {::Google::Cloud::Kms::V1::DecryptRequest#additional_authenticated_data_crc32c DecryptRequest.additional_authenticated_data_crc32c},
            #     and if so, perform a limited number of retries. A persistent mismatch may
            #     indicate an issue in your computation of the CRC32C checksum. Note: This
            #     field is defined as int64 for reasons of compatibility across different
            #     languages. However, it is a non-negative integer, which will never exceed
            #     2^32-1, and can be safely downconverted to uint32 in languages that support
            #     this type.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Kms::V1::DecryptResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Kms::V1::DecryptResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/kms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Kms::V1::KeyManagementService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Kms::V1::DecryptRequest.new
            #
            #   # Call the decrypt method.
            #   result = client.decrypt request
            #
            #   # The returned object is of type Google::Cloud::Kms::V1::DecryptResponse.
            #   p result
            #
            def decrypt request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Kms::V1::DecryptRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.decrypt.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Kms::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.decrypt.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.decrypt.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @key_management_service_stub.call_rpc :decrypt, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Encrypts data using portable cryptographic primitives. Most users should
            # choose {::Google::Cloud::Kms::V1::KeyManagementService::Client#encrypt Encrypt} and
            # {::Google::Cloud::Kms::V1::KeyManagementService::Client#decrypt Decrypt} rather than
            # their raw counterparts. The
            # {::Google::Cloud::Kms::V1::CryptoKey#purpose CryptoKey.purpose} must be
            # {::Google::Cloud::Kms::V1::CryptoKey::CryptoKeyPurpose::RAW_ENCRYPT_DECRYPT RAW_ENCRYPT_DECRYPT}.
            #
            # @overload raw_encrypt(request, options = nil)
            #   Pass arguments to `raw_encrypt` via a request object, either of type
            #   {::Google::Cloud::Kms::V1::RawEncryptRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Kms::V1::RawEncryptRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload raw_encrypt(name: nil, plaintext: nil, additional_authenticated_data: nil, plaintext_crc32c: nil, additional_authenticated_data_crc32c: nil, initialization_vector: nil, initialization_vector_crc32c: nil)
            #   Pass arguments to `raw_encrypt` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the
            #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} to use for
            #     encryption.
            #   @param plaintext [::String]
            #     Required. The data to encrypt. Must be no larger than 64KiB.
            #
            #     The maximum size depends on the key version's
            #     {::Google::Cloud::Kms::V1::CryptoKeyVersionTemplate#protection_level protection_level}.
            #     For {::Google::Cloud::Kms::V1::ProtectionLevel::SOFTWARE SOFTWARE} keys, the
            #     plaintext must be no larger than 64KiB. For
            #     {::Google::Cloud::Kms::V1::ProtectionLevel::HSM HSM} keys, the combined length of
            #     the plaintext and additional_authenticated_data fields must be no larger
            #     than 8KiB.
            #   @param additional_authenticated_data [::String]
            #     Optional. Optional data that, if specified, must also be provided during
            #     decryption through
            #     {::Google::Cloud::Kms::V1::RawDecryptRequest#additional_authenticated_data RawDecryptRequest.additional_authenticated_data}.
            #
            #     This field may only be used in conjunction with an
            #     {::Google::Cloud::Kms::V1::CryptoKeyVersion#algorithm algorithm} that accepts
            #     additional authenticated data (for example, AES-GCM).
            #
            #     The maximum size depends on the key version's
            #     {::Google::Cloud::Kms::V1::CryptoKeyVersionTemplate#protection_level protection_level}.
            #     For {::Google::Cloud::Kms::V1::ProtectionLevel::SOFTWARE SOFTWARE} keys, the
            #     plaintext must be no larger than 64KiB. For
            #     {::Google::Cloud::Kms::V1::ProtectionLevel::HSM HSM} keys, the combined length of
            #     the plaintext and additional_authenticated_data fields must be no larger
            #     than 8KiB.
            #   @param plaintext_crc32c [::Google::Protobuf::Int64Value, ::Hash]
            #     Optional. An optional CRC32C checksum of the
            #     {::Google::Cloud::Kms::V1::RawEncryptRequest#plaintext RawEncryptRequest.plaintext}.
            #     If specified,
            #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
            #     verify the integrity of the received plaintext using this checksum.
            #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
            #     report an error if the checksum verification fails. If you receive a
            #     checksum error, your client should verify that CRC32C(plaintext) is equal
            #     to plaintext_crc32c, and if so, perform a limited number of retries. A
            #     persistent mismatch may indicate an issue in your computation of the CRC32C
            #     checksum. Note: This field is defined as int64 for reasons of compatibility
            #     across different languages. However, it is a non-negative integer, which
            #     will never exceed 2^32-1, and can be safely downconverted to uint32 in
            #     languages that support this type.
            #   @param additional_authenticated_data_crc32c [::Google::Protobuf::Int64Value, ::Hash]
            #     Optional. An optional CRC32C checksum of the
            #     {::Google::Cloud::Kms::V1::RawEncryptRequest#additional_authenticated_data RawEncryptRequest.additional_authenticated_data}.
            #     If specified,
            #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
            #     verify the integrity of the received additional_authenticated_data using
            #     this checksum.
            #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
            #     report an error if the checksum verification fails. If you receive a
            #     checksum error, your client should verify that
            #     CRC32C(additional_authenticated_data) is equal to
            #     additional_authenticated_data_crc32c, and if so, perform
            #     a limited number of retries. A persistent mismatch may indicate an issue in
            #     your computation of the CRC32C checksum.
            #     Note: This field is defined as int64 for reasons of compatibility across
            #     different languages. However, it is a non-negative integer, which will
            #     never exceed 2^32-1, and can be safely downconverted to uint32 in languages
            #     that support this type.
            #   @param initialization_vector [::String]
            #     Optional. A customer-supplied initialization vector that will be used for
            #     encryption. If it is not provided for AES-CBC and AES-CTR, one will be
            #     generated. It will be returned in
            #     {::Google::Cloud::Kms::V1::RawEncryptResponse#initialization_vector RawEncryptResponse.initialization_vector}.
            #   @param initialization_vector_crc32c [::Google::Protobuf::Int64Value, ::Hash]
            #     Optional. An optional CRC32C checksum of the
            #     {::Google::Cloud::Kms::V1::RawEncryptRequest#initialization_vector RawEncryptRequest.initialization_vector}.
            #     If specified,
            #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
            #     verify the integrity of the received initialization_vector using this
            #     checksum. {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService}
            #     will report an error if the checksum verification fails. If you receive a
            #     checksum error, your client should verify that
            #     CRC32C(initialization_vector) is equal to
            #     initialization_vector_crc32c, and if so, perform
            #     a limited number of retries. A persistent mismatch may indicate an issue in
            #     your computation of the CRC32C checksum.
            #     Note: This field is defined as int64 for reasons of compatibility across
            #     different languages. However, it is a non-negative integer, which will
            #     never exceed 2^32-1, and can be safely downconverted to uint32 in languages
            #     that support this type.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Kms::V1::RawEncryptResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Kms::V1::RawEncryptResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/kms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Kms::V1::KeyManagementService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Kms::V1::RawEncryptRequest.new
            #
            #   # Call the raw_encrypt method.
            #   result = client.raw_encrypt request
            #
            #   # The returned object is of type Google::Cloud::Kms::V1::RawEncryptResponse.
            #   p result
            #
            def raw_encrypt request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Kms::V1::RawEncryptRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.raw_encrypt.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Kms::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.raw_encrypt.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.raw_encrypt.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @key_management_service_stub.call_rpc :raw_encrypt, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Decrypts data that was originally encrypted using a raw cryptographic
            # mechanism. The {::Google::Cloud::Kms::V1::CryptoKey#purpose CryptoKey.purpose}
            # must be
            # {::Google::Cloud::Kms::V1::CryptoKey::CryptoKeyPurpose::RAW_ENCRYPT_DECRYPT RAW_ENCRYPT_DECRYPT}.
            #
            # @overload raw_decrypt(request, options = nil)
            #   Pass arguments to `raw_decrypt` via a request object, either of type
            #   {::Google::Cloud::Kms::V1::RawDecryptRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Kms::V1::RawDecryptRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload raw_decrypt(name: nil, ciphertext: nil, additional_authenticated_data: nil, initialization_vector: nil, tag_length: nil, ciphertext_crc32c: nil, additional_authenticated_data_crc32c: nil, initialization_vector_crc32c: nil)
            #   Pass arguments to `raw_decrypt` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the
            #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} to use for
            #     decryption.
            #   @param ciphertext [::String]
            #     Required. The encrypted data originally returned in
            #     {::Google::Cloud::Kms::V1::RawEncryptResponse#ciphertext RawEncryptResponse.ciphertext}.
            #   @param additional_authenticated_data [::String]
            #     Optional. Optional data that must match the data originally supplied in
            #     {::Google::Cloud::Kms::V1::RawEncryptRequest#additional_authenticated_data RawEncryptRequest.additional_authenticated_data}.
            #   @param initialization_vector [::String]
            #     Required. The initialization vector (IV) used during encryption, which must
            #     match the data originally provided in
            #     {::Google::Cloud::Kms::V1::RawEncryptResponse#initialization_vector RawEncryptResponse.initialization_vector}.
            #   @param tag_length [::Integer]
            #     The length of the authentication tag that is appended to the end of
            #     the ciphertext. If unspecified (0), the default value for the key's
            #     algorithm will be used (for AES-GCM, the default value is 16).
            #   @param ciphertext_crc32c [::Google::Protobuf::Int64Value, ::Hash]
            #     Optional. An optional CRC32C checksum of the
            #     {::Google::Cloud::Kms::V1::RawDecryptRequest#ciphertext RawDecryptRequest.ciphertext}.
            #     If specified,
            #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
            #     verify the integrity of the received ciphertext using this checksum.
            #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
            #     report an error if the checksum verification fails. If you receive a
            #     checksum error, your client should verify that CRC32C(ciphertext) is equal
            #     to ciphertext_crc32c, and if so, perform a limited number of retries. A
            #     persistent mismatch may indicate an issue in your computation of the CRC32C
            #     checksum. Note: This field is defined as int64 for reasons of compatibility
            #     across different languages. However, it is a non-negative integer, which
            #     will never exceed 2^32-1, and can be safely downconverted to uint32 in
            #     languages that support this type.
            #   @param additional_authenticated_data_crc32c [::Google::Protobuf::Int64Value, ::Hash]
            #     Optional. An optional CRC32C checksum of the
            #     {::Google::Cloud::Kms::V1::RawDecryptRequest#additional_authenticated_data RawDecryptRequest.additional_authenticated_data}.
            #     If specified,
            #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
            #     verify the integrity of the received additional_authenticated_data using
            #     this checksum.
            #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
            #     report an error if the checksum verification fails. If you receive a
            #     checksum error, your client should verify that
            #     CRC32C(additional_authenticated_data) is equal to
            #     additional_authenticated_data_crc32c, and if so, perform
            #     a limited number of retries. A persistent mismatch may indicate an issue in
            #     your computation of the CRC32C checksum.
            #     Note: This field is defined as int64 for reasons of compatibility across
            #     different languages. However, it is a non-negative integer, which will
            #     never exceed 2^32-1, and can be safely downconverted to uint32 in languages
            #     that support this type.
            #   @param initialization_vector_crc32c [::Google::Protobuf::Int64Value, ::Hash]
            #     Optional. An optional CRC32C checksum of the
            #     {::Google::Cloud::Kms::V1::RawDecryptRequest#initialization_vector RawDecryptRequest.initialization_vector}.
            #     If specified,
            #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
            #     verify the integrity of the received initialization_vector using this
            #     checksum. {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService}
            #     will report an error if the checksum verification fails. If you receive a
            #     checksum error, your client should verify that
            #     CRC32C(initialization_vector) is equal to initialization_vector_crc32c, and
            #     if so, perform a limited number of retries. A persistent mismatch may
            #     indicate an issue in your computation of the CRC32C checksum.
            #     Note: This field is defined as int64 for reasons of compatibility across
            #     different languages. However, it is a non-negative integer, which will
            #     never exceed 2^32-1, and can be safely downconverted to uint32 in languages
            #     that support this type.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Kms::V1::RawDecryptResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Kms::V1::RawDecryptResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/kms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Kms::V1::KeyManagementService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Kms::V1::RawDecryptRequest.new
            #
            #   # Call the raw_decrypt method.
            #   result = client.raw_decrypt request
            #
            #   # The returned object is of type Google::Cloud::Kms::V1::RawDecryptResponse.
            #   p result
            #
            def raw_decrypt request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Kms::V1::RawDecryptRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.raw_decrypt.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Kms::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.raw_decrypt.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.raw_decrypt.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @key_management_service_stub.call_rpc :raw_decrypt, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Signs data using a {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion}
            # with {::Google::Cloud::Kms::V1::CryptoKey#purpose CryptoKey.purpose}
            # ASYMMETRIC_SIGN, producing a signature that can be verified with the public
            # key retrieved from
            # {::Google::Cloud::Kms::V1::KeyManagementService::Client#get_public_key GetPublicKey}.
            #
            # @overload asymmetric_sign(request, options = nil)
            #   Pass arguments to `asymmetric_sign` via a request object, either of type
            #   {::Google::Cloud::Kms::V1::AsymmetricSignRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Kms::V1::AsymmetricSignRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload asymmetric_sign(name: nil, digest: nil, digest_crc32c: nil, data: nil, data_crc32c: nil)
            #   Pass arguments to `asymmetric_sign` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the
            #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} to use for
            #     signing.
            #   @param digest [::Google::Cloud::Kms::V1::Digest, ::Hash]
            #     Optional. The digest of the data to sign. The digest must be produced with
            #     the same digest algorithm as specified by the key version's
            #     {::Google::Cloud::Kms::V1::CryptoKeyVersion#algorithm algorithm}.
            #
            #     This field may not be supplied if
            #     {::Google::Cloud::Kms::V1::AsymmetricSignRequest#data AsymmetricSignRequest.data}
            #     is supplied.
            #   @param digest_crc32c [::Google::Protobuf::Int64Value, ::Hash]
            #     Optional. An optional CRC32C checksum of the
            #     {::Google::Cloud::Kms::V1::AsymmetricSignRequest#digest AsymmetricSignRequest.digest}.
            #     If specified,
            #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
            #     verify the integrity of the received
            #     {::Google::Cloud::Kms::V1::AsymmetricSignRequest#digest AsymmetricSignRequest.digest}
            #     using this checksum.
            #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
            #     report an error if the checksum verification fails. If you receive a
            #     checksum error, your client should verify that
            #     CRC32C({::Google::Cloud::Kms::V1::AsymmetricSignRequest#digest AsymmetricSignRequest.digest})
            #     is equal to
            #     {::Google::Cloud::Kms::V1::AsymmetricSignRequest#digest_crc32c AsymmetricSignRequest.digest_crc32c},
            #     and if so, perform a limited number of retries. A persistent mismatch may
            #     indicate an issue in your computation of the CRC32C checksum. Note: This
            #     field is defined as int64 for reasons of compatibility across different
            #     languages. However, it is a non-negative integer, which will never exceed
            #     2^32-1, and can be safely downconverted to uint32 in languages that support
            #     this type.
            #   @param data [::String]
            #     Optional. The data to sign.
            #     It can't be supplied if
            #     {::Google::Cloud::Kms::V1::AsymmetricSignRequest#digest AsymmetricSignRequest.digest}
            #     is supplied.
            #   @param data_crc32c [::Google::Protobuf::Int64Value, ::Hash]
            #     Optional. An optional CRC32C checksum of the
            #     {::Google::Cloud::Kms::V1::AsymmetricSignRequest#data AsymmetricSignRequest.data}.
            #     If specified,
            #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
            #     verify the integrity of the received
            #     {::Google::Cloud::Kms::V1::AsymmetricSignRequest#data AsymmetricSignRequest.data}
            #     using this checksum.
            #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
            #     report an error if the checksum verification fails. If you receive a
            #     checksum error, your client should verify that
            #     CRC32C({::Google::Cloud::Kms::V1::AsymmetricSignRequest#data AsymmetricSignRequest.data})
            #     is equal to
            #     {::Google::Cloud::Kms::V1::AsymmetricSignRequest#data_crc32c AsymmetricSignRequest.data_crc32c},
            #     and if so, perform a limited number of retries. A persistent mismatch may
            #     indicate an issue in your computation of the CRC32C checksum. Note: This
            #     field is defined as int64 for reasons of compatibility across different
            #     languages. However, it is a non-negative integer, which will never exceed
            #     2^32-1, and can be safely downconverted to uint32 in languages that support
            #     this type.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Kms::V1::AsymmetricSignResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Kms::V1::AsymmetricSignResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/kms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Kms::V1::KeyManagementService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Kms::V1::AsymmetricSignRequest.new
            #
            #   # Call the asymmetric_sign method.
            #   result = client.asymmetric_sign request
            #
            #   # The returned object is of type Google::Cloud::Kms::V1::AsymmetricSignResponse.
            #   p result
            #
            def asymmetric_sign request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Kms::V1::AsymmetricSignRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.asymmetric_sign.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Kms::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.asymmetric_sign.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.asymmetric_sign.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @key_management_service_stub.call_rpc :asymmetric_sign, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Decrypts data that was encrypted with a public key retrieved from
            # {::Google::Cloud::Kms::V1::KeyManagementService::Client#get_public_key GetPublicKey}
            # corresponding to a {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion}
            # with {::Google::Cloud::Kms::V1::CryptoKey#purpose CryptoKey.purpose}
            # ASYMMETRIC_DECRYPT.
            #
            # @overload asymmetric_decrypt(request, options = nil)
            #   Pass arguments to `asymmetric_decrypt` via a request object, either of type
            #   {::Google::Cloud::Kms::V1::AsymmetricDecryptRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Kms::V1::AsymmetricDecryptRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload asymmetric_decrypt(name: nil, ciphertext: nil, ciphertext_crc32c: nil)
            #   Pass arguments to `asymmetric_decrypt` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the
            #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} to use for
            #     decryption.
            #   @param ciphertext [::String]
            #     Required. The data encrypted with the named
            #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion}'s public key using
            #     OAEP.
            #   @param ciphertext_crc32c [::Google::Protobuf::Int64Value, ::Hash]
            #     Optional. An optional CRC32C checksum of the
            #     {::Google::Cloud::Kms::V1::AsymmetricDecryptRequest#ciphertext AsymmetricDecryptRequest.ciphertext}.
            #     If specified,
            #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
            #     verify the integrity of the received
            #     {::Google::Cloud::Kms::V1::AsymmetricDecryptRequest#ciphertext AsymmetricDecryptRequest.ciphertext}
            #     using this checksum.
            #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
            #     report an error if the checksum verification fails. If you receive a
            #     checksum error, your client should verify that
            #     CRC32C({::Google::Cloud::Kms::V1::AsymmetricDecryptRequest#ciphertext AsymmetricDecryptRequest.ciphertext})
            #     is equal to
            #     {::Google::Cloud::Kms::V1::AsymmetricDecryptRequest#ciphertext_crc32c AsymmetricDecryptRequest.ciphertext_crc32c},
            #     and if so, perform a limited number of retries. A persistent mismatch may
            #     indicate an issue in your computation of the CRC32C checksum. Note: This
            #     field is defined as int64 for reasons of compatibility across different
            #     languages. However, it is a non-negative integer, which will never exceed
            #     2^32-1, and can be safely downconverted to uint32 in languages that support
            #     this type.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Kms::V1::AsymmetricDecryptResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Kms::V1::AsymmetricDecryptResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/kms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Kms::V1::KeyManagementService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Kms::V1::AsymmetricDecryptRequest.new
            #
            #   # Call the asymmetric_decrypt method.
            #   result = client.asymmetric_decrypt request
            #
            #   # The returned object is of type Google::Cloud::Kms::V1::AsymmetricDecryptResponse.
            #   p result
            #
            def asymmetric_decrypt request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Kms::V1::AsymmetricDecryptRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.asymmetric_decrypt.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Kms::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.asymmetric_decrypt.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.asymmetric_decrypt.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @key_management_service_stub.call_rpc :asymmetric_decrypt, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Signs data using a {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion}
            # with {::Google::Cloud::Kms::V1::CryptoKey#purpose CryptoKey.purpose} MAC,
            # producing a tag that can be verified by another source with the same key.
            #
            # @overload mac_sign(request, options = nil)
            #   Pass arguments to `mac_sign` via a request object, either of type
            #   {::Google::Cloud::Kms::V1::MacSignRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Kms::V1::MacSignRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload mac_sign(name: nil, data: nil, data_crc32c: nil)
            #   Pass arguments to `mac_sign` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the
            #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} to use for
            #     signing.
            #   @param data [::String]
            #     Required. The data to sign. The MAC tag is computed over this data field
            #     based on the specific algorithm.
            #   @param data_crc32c [::Google::Protobuf::Int64Value, ::Hash]
            #     Optional. An optional CRC32C checksum of the
            #     {::Google::Cloud::Kms::V1::MacSignRequest#data MacSignRequest.data}. If
            #     specified, {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService}
            #     will verify the integrity of the received
            #     {::Google::Cloud::Kms::V1::MacSignRequest#data MacSignRequest.data} using this
            #     checksum. {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService}
            #     will report an error if the checksum verification fails. If you receive a
            #     checksum error, your client should verify that
            #     CRC32C({::Google::Cloud::Kms::V1::MacSignRequest#data MacSignRequest.data}) is
            #     equal to
            #     {::Google::Cloud::Kms::V1::MacSignRequest#data_crc32c MacSignRequest.data_crc32c},
            #     and if so, perform a limited number of retries. A persistent mismatch may
            #     indicate an issue in your computation of the CRC32C checksum. Note: This
            #     field is defined as int64 for reasons of compatibility across different
            #     languages. However, it is a non-negative integer, which will never exceed
            #     2^32-1, and can be safely downconverted to uint32 in languages that support
            #     this type.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Kms::V1::MacSignResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Kms::V1::MacSignResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/kms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Kms::V1::KeyManagementService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Kms::V1::MacSignRequest.new
            #
            #   # Call the mac_sign method.
            #   result = client.mac_sign request
            #
            #   # The returned object is of type Google::Cloud::Kms::V1::MacSignResponse.
            #   p result
            #
            def mac_sign request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Kms::V1::MacSignRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.mac_sign.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Kms::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.mac_sign.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.mac_sign.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @key_management_service_stub.call_rpc :mac_sign, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Verifies MAC tag using a
            # {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} with
            # {::Google::Cloud::Kms::V1::CryptoKey#purpose CryptoKey.purpose} MAC, and returns
            # a response that indicates whether or not the verification was successful.
            #
            # @overload mac_verify(request, options = nil)
            #   Pass arguments to `mac_verify` via a request object, either of type
            #   {::Google::Cloud::Kms::V1::MacVerifyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Kms::V1::MacVerifyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload mac_verify(name: nil, data: nil, data_crc32c: nil, mac: nil, mac_crc32c: nil)
            #   Pass arguments to `mac_verify` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the
            #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} to use for
            #     verification.
            #   @param data [::String]
            #     Required. The data used previously as a
            #     {::Google::Cloud::Kms::V1::MacSignRequest#data MacSignRequest.data} to generate
            #     the MAC tag.
            #   @param data_crc32c [::Google::Protobuf::Int64Value, ::Hash]
            #     Optional. An optional CRC32C checksum of the
            #     {::Google::Cloud::Kms::V1::MacVerifyRequest#data MacVerifyRequest.data}. If
            #     specified, {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService}
            #     will verify the integrity of the received
            #     {::Google::Cloud::Kms::V1::MacVerifyRequest#data MacVerifyRequest.data} using
            #     this checksum.
            #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
            #     report an error if the checksum verification fails. If you receive a
            #     checksum error, your client should verify that
            #     CRC32C({::Google::Cloud::Kms::V1::MacVerifyRequest#data MacVerifyRequest.data})
            #     is equal to
            #     {::Google::Cloud::Kms::V1::MacVerifyRequest#data_crc32c MacVerifyRequest.data_crc32c},
            #     and if so, perform a limited number of retries. A persistent mismatch may
            #     indicate an issue in your computation of the CRC32C checksum. Note: This
            #     field is defined as int64 for reasons of compatibility across different
            #     languages. However, it is a non-negative integer, which will never exceed
            #     2^32-1, and can be safely downconverted to uint32 in languages that support
            #     this type.
            #   @param mac [::String]
            #     Required. The signature to verify.
            #   @param mac_crc32c [::Google::Protobuf::Int64Value, ::Hash]
            #     Optional. An optional CRC32C checksum of the
            #     {::Google::Cloud::Kms::V1::MacVerifyRequest#mac MacVerifyRequest.mac}. If
            #     specified, {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService}
            #     will verify the integrity of the received
            #     {::Google::Cloud::Kms::V1::MacVerifyRequest#mac MacVerifyRequest.mac} using this
            #     checksum. {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService}
            #     will report an error if the checksum verification fails. If you receive a
            #     checksum error, your client should verify that
            #     CRC32C({::Google::Cloud::Kms::V1::MacVerifyRequest#mac MacVerifyRequest.mac}) is
            #     equal to
            #     {::Google::Cloud::Kms::V1::MacVerifyRequest#mac_crc32c MacVerifyRequest.mac_crc32c},
            #     and if so, perform a limited number of retries. A persistent mismatch may
            #     indicate an issue in your computation of the CRC32C checksum. Note: This
            #     field is defined as int64 for reasons of compatibility across different
            #     languages. However, it is a non-negative integer, which will never exceed
            #     2^32-1, and can be safely downconverted to uint32 in languages that support
            #     this type.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Kms::V1::MacVerifyResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Kms::V1::MacVerifyResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/kms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Kms::V1::KeyManagementService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Kms::V1::MacVerifyRequest.new
            #
            #   # Call the mac_verify method.
            #   result = client.mac_verify request
            #
            #   # The returned object is of type Google::Cloud::Kms::V1::MacVerifyResponse.
            #   p result
            #
            def mac_verify request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Kms::V1::MacVerifyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.mac_verify.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Kms::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.mac_verify.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.mac_verify.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @key_management_service_stub.call_rpc :mac_verify, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Decapsulates data that was encapsulated with a public key retrieved from
            # {::Google::Cloud::Kms::V1::KeyManagementService::Client#get_public_key GetPublicKey}
            # corresponding to a {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion}
            # with {::Google::Cloud::Kms::V1::CryptoKey#purpose CryptoKey.purpose}
            # KEY_ENCAPSULATION.
            #
            # @overload decapsulate(request, options = nil)
            #   Pass arguments to `decapsulate` via a request object, either of type
            #   {::Google::Cloud::Kms::V1::DecapsulateRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Kms::V1::DecapsulateRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload decapsulate(name: nil, ciphertext: nil, ciphertext_crc32c: nil)
            #   Pass arguments to `decapsulate` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the
            #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} to use for
            #     decapsulation.
            #   @param ciphertext [::String]
            #     Required. The ciphertext produced from encapsulation with the
            #     named {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} public
            #     key(s).
            #   @param ciphertext_crc32c [::Google::Protobuf::Int64Value, ::Hash]
            #     Optional. A CRC32C checksum of the
            #     {::Google::Cloud::Kms::V1::DecapsulateRequest#ciphertext DecapsulateRequest.ciphertext}.
            #     If specified,
            #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
            #     verify the integrity of the received
            #     {::Google::Cloud::Kms::V1::DecapsulateRequest#ciphertext DecapsulateRequest.ciphertext}
            #     using this checksum.
            #     {::Google::Cloud::Kms::V1::KeyManagementService::Client KeyManagementService} will
            #     report an error if the checksum verification fails. If you receive a
            #     checksum error, your client should verify that
            #     CRC32C({::Google::Cloud::Kms::V1::DecapsulateRequest#ciphertext DecapsulateRequest.ciphertext})
            #     is equal to
            #     {::Google::Cloud::Kms::V1::DecapsulateRequest#ciphertext_crc32c DecapsulateRequest.ciphertext_crc32c},
            #     and if so, perform a limited number of retries. A persistent mismatch may
            #     indicate an issue in your computation of the CRC32C checksum. Note: This
            #     field is defined as int64 for reasons of compatibility across different
            #     languages. However, it is a non-negative integer, which will never exceed
            #     2^32-1, and can be safely downconverted to uint32 in languages that support
            #     this type.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Kms::V1::DecapsulateResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Kms::V1::DecapsulateResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/kms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Kms::V1::KeyManagementService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Kms::V1::DecapsulateRequest.new
            #
            #   # Call the decapsulate method.
            #   result = client.decapsulate request
            #
            #   # The returned object is of type Google::Cloud::Kms::V1::DecapsulateResponse.
            #   p result
            #
            def decapsulate request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Kms::V1::DecapsulateRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.decapsulate.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Kms::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.decapsulate.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.decapsulate.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @key_management_service_stub.call_rpc :decapsulate, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Generate random bytes using the Cloud KMS randomness source in the provided
            # location.
            #
            # @overload generate_random_bytes(request, options = nil)
            #   Pass arguments to `generate_random_bytes` via a request object, either of type
            #   {::Google::Cloud::Kms::V1::GenerateRandomBytesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Kms::V1::GenerateRandomBytesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload generate_random_bytes(location: nil, length_bytes: nil, protection_level: nil)
            #   Pass arguments to `generate_random_bytes` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param location [::String]
            #     The project-specific location in which to generate random bytes.
            #     For example, "projects/my-project/locations/us-central1".
            #   @param length_bytes [::Integer]
            #     The length in bytes of the amount of randomness to retrieve.  Minimum 8
            #     bytes, maximum 1024 bytes.
            #   @param protection_level [::Google::Cloud::Kms::V1::ProtectionLevel]
            #     The {::Google::Cloud::Kms::V1::ProtectionLevel ProtectionLevel} to use when
            #     generating the random data. Currently, only
            #     {::Google::Cloud::Kms::V1::ProtectionLevel::HSM HSM} protection level is
            #     supported.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Kms::V1::GenerateRandomBytesResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Kms::V1::GenerateRandomBytesResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/kms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Kms::V1::KeyManagementService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Kms::V1::GenerateRandomBytesRequest.new
            #
            #   # Call the generate_random_bytes method.
            #   result = client.generate_random_bytes request
            #
            #   # The returned object is of type Google::Cloud::Kms::V1::GenerateRandomBytesResponse.
            #   p result
            #
            def generate_random_bytes request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Kms::V1::GenerateRandomBytesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.generate_random_bytes.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Kms::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.location
                header_params["location"] = request.location
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.generate_random_bytes.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.generate_random_bytes.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @key_management_service_stub.call_rpc :generate_random_bytes, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the KeyManagementService API.
            #
            # This class represents the configuration for KeyManagementService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::Kms::V1::KeyManagementService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # list_key_rings to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::Kms::V1::KeyManagementService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_key_rings.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::Kms::V1::KeyManagementService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_key_rings.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::Kms::V1::KeyManagementService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "cloudkms.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the KeyManagementService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `list_key_rings`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_key_rings
                ##
                # RPC-specific configuration for `list_crypto_keys`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_crypto_keys
                ##
                # RPC-specific configuration for `list_crypto_key_versions`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_crypto_key_versions
                ##
                # RPC-specific configuration for `list_import_jobs`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_import_jobs
                ##
                # RPC-specific configuration for `get_key_ring`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_key_ring
                ##
                # RPC-specific configuration for `get_crypto_key`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_crypto_key
                ##
                # RPC-specific configuration for `get_crypto_key_version`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_crypto_key_version
                ##
                # RPC-specific configuration for `get_public_key`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_public_key
                ##
                # RPC-specific configuration for `get_import_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_import_job
                ##
                # RPC-specific configuration for `create_key_ring`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_key_ring
                ##
                # RPC-specific configuration for `create_crypto_key`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_crypto_key
                ##
                # RPC-specific configuration for `create_crypto_key_version`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_crypto_key_version
                ##
                # RPC-specific configuration for `import_crypto_key_version`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :import_crypto_key_version
                ##
                # RPC-specific configuration for `create_import_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_import_job
                ##
                # RPC-specific configuration for `update_crypto_key`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_crypto_key
                ##
                # RPC-specific configuration for `update_crypto_key_version`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_crypto_key_version
                ##
                # RPC-specific configuration for `update_crypto_key_primary_version`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_crypto_key_primary_version
                ##
                # RPC-specific configuration for `destroy_crypto_key_version`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :destroy_crypto_key_version
                ##
                # RPC-specific configuration for `restore_crypto_key_version`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :restore_crypto_key_version
                ##
                # RPC-specific configuration for `encrypt`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :encrypt
                ##
                # RPC-specific configuration for `decrypt`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :decrypt
                ##
                # RPC-specific configuration for `raw_encrypt`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :raw_encrypt
                ##
                # RPC-specific configuration for `raw_decrypt`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :raw_decrypt
                ##
                # RPC-specific configuration for `asymmetric_sign`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :asymmetric_sign
                ##
                # RPC-specific configuration for `asymmetric_decrypt`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :asymmetric_decrypt
                ##
                # RPC-specific configuration for `mac_sign`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :mac_sign
                ##
                # RPC-specific configuration for `mac_verify`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :mac_verify
                ##
                # RPC-specific configuration for `decapsulate`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :decapsulate
                ##
                # RPC-specific configuration for `generate_random_bytes`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :generate_random_bytes

                # @private
                def initialize parent_rpcs = nil
                  list_key_rings_config = parent_rpcs.list_key_rings if parent_rpcs.respond_to? :list_key_rings
                  @list_key_rings = ::Gapic::Config::Method.new list_key_rings_config
                  list_crypto_keys_config = parent_rpcs.list_crypto_keys if parent_rpcs.respond_to? :list_crypto_keys
                  @list_crypto_keys = ::Gapic::Config::Method.new list_crypto_keys_config
                  list_crypto_key_versions_config = parent_rpcs.list_crypto_key_versions if parent_rpcs.respond_to? :list_crypto_key_versions
                  @list_crypto_key_versions = ::Gapic::Config::Method.new list_crypto_key_versions_config
                  list_import_jobs_config = parent_rpcs.list_import_jobs if parent_rpcs.respond_to? :list_import_jobs
                  @list_import_jobs = ::Gapic::Config::Method.new list_import_jobs_config
                  get_key_ring_config = parent_rpcs.get_key_ring if parent_rpcs.respond_to? :get_key_ring
                  @get_key_ring = ::Gapic::Config::Method.new get_key_ring_config
                  get_crypto_key_config = parent_rpcs.get_crypto_key if parent_rpcs.respond_to? :get_crypto_key
                  @get_crypto_key = ::Gapic::Config::Method.new get_crypto_key_config
                  get_crypto_key_version_config = parent_rpcs.get_crypto_key_version if parent_rpcs.respond_to? :get_crypto_key_version
                  @get_crypto_key_version = ::Gapic::Config::Method.new get_crypto_key_version_config
                  get_public_key_config = parent_rpcs.get_public_key if parent_rpcs.respond_to? :get_public_key
                  @get_public_key = ::Gapic::Config::Method.new get_public_key_config
                  get_import_job_config = parent_rpcs.get_import_job if parent_rpcs.respond_to? :get_import_job
                  @get_import_job = ::Gapic::Config::Method.new get_import_job_config
                  create_key_ring_config = parent_rpcs.create_key_ring if parent_rpcs.respond_to? :create_key_ring
                  @create_key_ring = ::Gapic::Config::Method.new create_key_ring_config
                  create_crypto_key_config = parent_rpcs.create_crypto_key if parent_rpcs.respond_to? :create_crypto_key
                  @create_crypto_key = ::Gapic::Config::Method.new create_crypto_key_config
                  create_crypto_key_version_config = parent_rpcs.create_crypto_key_version if parent_rpcs.respond_to? :create_crypto_key_version
                  @create_crypto_key_version = ::Gapic::Config::Method.new create_crypto_key_version_config
                  import_crypto_key_version_config = parent_rpcs.import_crypto_key_version if parent_rpcs.respond_to? :import_crypto_key_version
                  @import_crypto_key_version = ::Gapic::Config::Method.new import_crypto_key_version_config
                  create_import_job_config = parent_rpcs.create_import_job if parent_rpcs.respond_to? :create_import_job
                  @create_import_job = ::Gapic::Config::Method.new create_import_job_config
                  update_crypto_key_config = parent_rpcs.update_crypto_key if parent_rpcs.respond_to? :update_crypto_key
                  @update_crypto_key = ::Gapic::Config::Method.new update_crypto_key_config
                  update_crypto_key_version_config = parent_rpcs.update_crypto_key_version if parent_rpcs.respond_to? :update_crypto_key_version
                  @update_crypto_key_version = ::Gapic::Config::Method.new update_crypto_key_version_config
                  update_crypto_key_primary_version_config = parent_rpcs.update_crypto_key_primary_version if parent_rpcs.respond_to? :update_crypto_key_primary_version
                  @update_crypto_key_primary_version = ::Gapic::Config::Method.new update_crypto_key_primary_version_config
                  destroy_crypto_key_version_config = parent_rpcs.destroy_crypto_key_version if parent_rpcs.respond_to? :destroy_crypto_key_version
                  @destroy_crypto_key_version = ::Gapic::Config::Method.new destroy_crypto_key_version_config
                  restore_crypto_key_version_config = parent_rpcs.restore_crypto_key_version if parent_rpcs.respond_to? :restore_crypto_key_version
                  @restore_crypto_key_version = ::Gapic::Config::Method.new restore_crypto_key_version_config
                  encrypt_config = parent_rpcs.encrypt if parent_rpcs.respond_to? :encrypt
                  @encrypt = ::Gapic::Config::Method.new encrypt_config
                  decrypt_config = parent_rpcs.decrypt if parent_rpcs.respond_to? :decrypt
                  @decrypt = ::Gapic::Config::Method.new decrypt_config
                  raw_encrypt_config = parent_rpcs.raw_encrypt if parent_rpcs.respond_to? :raw_encrypt
                  @raw_encrypt = ::Gapic::Config::Method.new raw_encrypt_config
                  raw_decrypt_config = parent_rpcs.raw_decrypt if parent_rpcs.respond_to? :raw_decrypt
                  @raw_decrypt = ::Gapic::Config::Method.new raw_decrypt_config
                  asymmetric_sign_config = parent_rpcs.asymmetric_sign if parent_rpcs.respond_to? :asymmetric_sign
                  @asymmetric_sign = ::Gapic::Config::Method.new asymmetric_sign_config
                  asymmetric_decrypt_config = parent_rpcs.asymmetric_decrypt if parent_rpcs.respond_to? :asymmetric_decrypt
                  @asymmetric_decrypt = ::Gapic::Config::Method.new asymmetric_decrypt_config
                  mac_sign_config = parent_rpcs.mac_sign if parent_rpcs.respond_to? :mac_sign
                  @mac_sign = ::Gapic::Config::Method.new mac_sign_config
                  mac_verify_config = parent_rpcs.mac_verify if parent_rpcs.respond_to? :mac_verify
                  @mac_verify = ::Gapic::Config::Method.new mac_verify_config
                  decapsulate_config = parent_rpcs.decapsulate if parent_rpcs.respond_to? :decapsulate
                  @decapsulate = ::Gapic::Config::Method.new decapsulate_config
                  generate_random_bytes_config = parent_rpcs.generate_random_bytes if parent_rpcs.respond_to? :generate_random_bytes
                  @generate_random_bytes = ::Gapic::Config::Method.new generate_random_bytes_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
