# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/kms/v1/ekm_service_pb"
require "google/cloud/location"
require "google/iam/v1"

module Google
  module Cloud
    module Kms
      module V1
        module EkmService
          ##
          # Client for the EkmService service.
          #
          # Google Cloud Key Management EKM Service
          #
          # Manages external cryptographic keys and operations using those keys.
          # Implements a REST model with the following objects:
          # * {::Google::Cloud::Kms::V1::EkmConnection EkmConnection}
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "cloudkms.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :ekm_service_stub

            ##
            # Configure the EkmService Client class.
            #
            # See {::Google::Cloud::Kms::V1::EkmService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all EkmService clients
            #   ::Google::Cloud::Kms::V1::EkmService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "Kms", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.list_ekm_connections.timeout = 60.0
                default_config.rpcs.list_ekm_connections.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.get_ekm_connection.timeout = 60.0
                default_config.rpcs.get_ekm_connection.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.create_ekm_connection.timeout = 60.0
                default_config.rpcs.create_ekm_connection.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.update_ekm_connection.timeout = 60.0
                default_config.rpcs.update_ekm_connection.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the EkmService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::Kms::V1::EkmService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @ekm_service_stub.universe_domain
            end

            ##
            # Create a new EkmService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::Kms::V1::EkmService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::Kms::V1::EkmService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the EkmService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/kms/v1/ekm_service_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @ekm_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::Kms::V1::EkmService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @ekm_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @ekm_service_stub.endpoint
                config.universe_domain = @ekm_service_stub.universe_domain
                config.logger = @ekm_service_stub.logger if config.respond_to? :logger=
              end

              @iam_policy_client = Google::Iam::V1::IAMPolicy::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @ekm_service_stub.endpoint
                config.universe_domain = @ekm_service_stub.universe_domain
                config.logger = @ekm_service_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # Get the associated client for mix-in of the IAMPolicy.
            #
            # @return [Google::Iam::V1::IAMPolicy::Client]
            #
            attr_reader :iam_policy_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @ekm_service_stub.logger
            end

            # Service calls

            ##
            # Lists {::Google::Cloud::Kms::V1::EkmConnection EkmConnections}.
            #
            # @overload list_ekm_connections(request, options = nil)
            #   Pass arguments to `list_ekm_connections` via a request object, either of type
            #   {::Google::Cloud::Kms::V1::ListEkmConnectionsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Kms::V1::ListEkmConnectionsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_ekm_connections(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_ekm_connections` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the location associated with the
            #     {::Google::Cloud::Kms::V1::EkmConnection EkmConnections} to list, in the format
            #     `projects/*/locations/*`.
            #   @param page_size [::Integer]
            #     Optional. Optional limit on the number of
            #     {::Google::Cloud::Kms::V1::EkmConnection EkmConnections} to include in the
            #     response. Further {::Google::Cloud::Kms::V1::EkmConnection EkmConnections} can
            #     subsequently be obtained by including the
            #     {::Google::Cloud::Kms::V1::ListEkmConnectionsResponse#next_page_token ListEkmConnectionsResponse.next_page_token}
            #     in a subsequent request. If unspecified, the server will pick an
            #     appropriate default.
            #   @param page_token [::String]
            #     Optional. Optional pagination token, returned earlier via
            #     {::Google::Cloud::Kms::V1::ListEkmConnectionsResponse#next_page_token ListEkmConnectionsResponse.next_page_token}.
            #   @param filter [::String]
            #     Optional. Only include resources that match the filter in the response. For
            #     more information, see
            #     [Sorting and filtering list
            #     results](https://cloud.google.com/kms/docs/sorting-and-filtering).
            #   @param order_by [::String]
            #     Optional. Specify how the results should be sorted. If not specified, the
            #     results will be sorted in the default order.  For more information, see
            #     [Sorting and filtering list
            #     results](https://cloud.google.com/kms/docs/sorting-and-filtering).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Kms::V1::EkmConnection>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Kms::V1::EkmConnection>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/kms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Kms::V1::EkmService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Kms::V1::ListEkmConnectionsRequest.new
            #
            #   # Call the list_ekm_connections method.
            #   result = client.list_ekm_connections request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Kms::V1::EkmConnection.
            #     p item
            #   end
            #
            def list_ekm_connections request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Kms::V1::ListEkmConnectionsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_ekm_connections.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Kms::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_ekm_connections.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_ekm_connections.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @ekm_service_stub.call_rpc :list_ekm_connections, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @ekm_service_stub, :list_ekm_connections, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns metadata for a given
            # {::Google::Cloud::Kms::V1::EkmConnection EkmConnection}.
            #
            # @overload get_ekm_connection(request, options = nil)
            #   Pass arguments to `get_ekm_connection` via a request object, either of type
            #   {::Google::Cloud::Kms::V1::GetEkmConnectionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Kms::V1::GetEkmConnectionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_ekm_connection(name: nil)
            #   Pass arguments to `get_ekm_connection` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The {::Google::Cloud::Kms::V1::EkmConnection#name name} of the
            #     {::Google::Cloud::Kms::V1::EkmConnection EkmConnection} to get.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Kms::V1::EkmConnection]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Kms::V1::EkmConnection]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/kms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Kms::V1::EkmService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Kms::V1::GetEkmConnectionRequest.new
            #
            #   # Call the get_ekm_connection method.
            #   result = client.get_ekm_connection request
            #
            #   # The returned object is of type Google::Cloud::Kms::V1::EkmConnection.
            #   p result
            #
            def get_ekm_connection request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Kms::V1::GetEkmConnectionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_ekm_connection.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Kms::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_ekm_connection.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_ekm_connection.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @ekm_service_stub.call_rpc :get_ekm_connection, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new {::Google::Cloud::Kms::V1::EkmConnection EkmConnection} in a given
            # Project and Location.
            #
            # @overload create_ekm_connection(request, options = nil)
            #   Pass arguments to `create_ekm_connection` via a request object, either of type
            #   {::Google::Cloud::Kms::V1::CreateEkmConnectionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Kms::V1::CreateEkmConnectionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_ekm_connection(parent: nil, ekm_connection_id: nil, ekm_connection: nil)
            #   Pass arguments to `create_ekm_connection` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the location associated with the
            #     {::Google::Cloud::Kms::V1::EkmConnection EkmConnection}, in the format
            #     `projects/*/locations/*`.
            #   @param ekm_connection_id [::String]
            #     Required. It must be unique within a location and match the regular
            #     expression `[a-zA-Z0-9_-]{1,63}`.
            #   @param ekm_connection [::Google::Cloud::Kms::V1::EkmConnection, ::Hash]
            #     Required. An {::Google::Cloud::Kms::V1::EkmConnection EkmConnection} with
            #     initial field values.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Kms::V1::EkmConnection]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Kms::V1::EkmConnection]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/kms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Kms::V1::EkmService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Kms::V1::CreateEkmConnectionRequest.new
            #
            #   # Call the create_ekm_connection method.
            #   result = client.create_ekm_connection request
            #
            #   # The returned object is of type Google::Cloud::Kms::V1::EkmConnection.
            #   p result
            #
            def create_ekm_connection request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Kms::V1::CreateEkmConnectionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_ekm_connection.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Kms::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_ekm_connection.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_ekm_connection.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @ekm_service_stub.call_rpc :create_ekm_connection, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates an {::Google::Cloud::Kms::V1::EkmConnection EkmConnection}'s metadata.
            #
            # @overload update_ekm_connection(request, options = nil)
            #   Pass arguments to `update_ekm_connection` via a request object, either of type
            #   {::Google::Cloud::Kms::V1::UpdateEkmConnectionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Kms::V1::UpdateEkmConnectionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_ekm_connection(ekm_connection: nil, update_mask: nil)
            #   Pass arguments to `update_ekm_connection` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param ekm_connection [::Google::Cloud::Kms::V1::EkmConnection, ::Hash]
            #     Required. {::Google::Cloud::Kms::V1::EkmConnection EkmConnection} with updated
            #     values.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. List of fields to be updated in this request.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Kms::V1::EkmConnection]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Kms::V1::EkmConnection]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/kms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Kms::V1::EkmService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Kms::V1::UpdateEkmConnectionRequest.new
            #
            #   # Call the update_ekm_connection method.
            #   result = client.update_ekm_connection request
            #
            #   # The returned object is of type Google::Cloud::Kms::V1::EkmConnection.
            #   p result
            #
            def update_ekm_connection request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Kms::V1::UpdateEkmConnectionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_ekm_connection.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Kms::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.ekm_connection&.name
                header_params["ekm_connection.name"] = request.ekm_connection.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_ekm_connection.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_ekm_connection.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @ekm_service_stub.call_rpc :update_ekm_connection, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns the {::Google::Cloud::Kms::V1::EkmConfig EkmConfig} singleton resource
            # for a given project and location.
            #
            # @overload get_ekm_config(request, options = nil)
            #   Pass arguments to `get_ekm_config` via a request object, either of type
            #   {::Google::Cloud::Kms::V1::GetEkmConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Kms::V1::GetEkmConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_ekm_config(name: nil)
            #   Pass arguments to `get_ekm_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The {::Google::Cloud::Kms::V1::EkmConfig#name name} of the
            #     {::Google::Cloud::Kms::V1::EkmConfig EkmConfig} to get.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Kms::V1::EkmConfig]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Kms::V1::EkmConfig]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/kms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Kms::V1::EkmService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Kms::V1::GetEkmConfigRequest.new
            #
            #   # Call the get_ekm_config method.
            #   result = client.get_ekm_config request
            #
            #   # The returned object is of type Google::Cloud::Kms::V1::EkmConfig.
            #   p result
            #
            def get_ekm_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Kms::V1::GetEkmConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_ekm_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Kms::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_ekm_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_ekm_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @ekm_service_stub.call_rpc :get_ekm_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the {::Google::Cloud::Kms::V1::EkmConfig EkmConfig} singleton resource
            # for a given project and location.
            #
            # @overload update_ekm_config(request, options = nil)
            #   Pass arguments to `update_ekm_config` via a request object, either of type
            #   {::Google::Cloud::Kms::V1::UpdateEkmConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Kms::V1::UpdateEkmConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_ekm_config(ekm_config: nil, update_mask: nil)
            #   Pass arguments to `update_ekm_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param ekm_config [::Google::Cloud::Kms::V1::EkmConfig, ::Hash]
            #     Required. {::Google::Cloud::Kms::V1::EkmConfig EkmConfig} with updated values.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. List of fields to be updated in this request.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Kms::V1::EkmConfig]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Kms::V1::EkmConfig]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/kms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Kms::V1::EkmService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Kms::V1::UpdateEkmConfigRequest.new
            #
            #   # Call the update_ekm_config method.
            #   result = client.update_ekm_config request
            #
            #   # The returned object is of type Google::Cloud::Kms::V1::EkmConfig.
            #   p result
            #
            def update_ekm_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Kms::V1::UpdateEkmConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_ekm_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Kms::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.ekm_config&.name
                header_params["ekm_config.name"] = request.ekm_config.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_ekm_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_ekm_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @ekm_service_stub.call_rpc :update_ekm_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Verifies that Cloud KMS can successfully connect to the external key
            # manager specified by an {::Google::Cloud::Kms::V1::EkmConnection EkmConnection}.
            # If there is an error connecting to the EKM, this method returns a
            # FAILED_PRECONDITION status containing structured information as described
            # at https://cloud.google.com/kms/docs/reference/ekm_errors.
            #
            # @overload verify_connectivity(request, options = nil)
            #   Pass arguments to `verify_connectivity` via a request object, either of type
            #   {::Google::Cloud::Kms::V1::VerifyConnectivityRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Kms::V1::VerifyConnectivityRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload verify_connectivity(name: nil)
            #   Pass arguments to `verify_connectivity` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The {::Google::Cloud::Kms::V1::EkmConnection#name name} of the
            #     {::Google::Cloud::Kms::V1::EkmConnection EkmConnection} to verify.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Kms::V1::VerifyConnectivityResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Kms::V1::VerifyConnectivityResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/kms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Kms::V1::EkmService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Kms::V1::VerifyConnectivityRequest.new
            #
            #   # Call the verify_connectivity method.
            #   result = client.verify_connectivity request
            #
            #   # The returned object is of type Google::Cloud::Kms::V1::VerifyConnectivityResponse.
            #   p result
            #
            def verify_connectivity request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Kms::V1::VerifyConnectivityRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.verify_connectivity.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Kms::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.verify_connectivity.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.verify_connectivity.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @ekm_service_stub.call_rpc :verify_connectivity, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the EkmService API.
            #
            # This class represents the configuration for EkmService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::Kms::V1::EkmService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # list_ekm_connections to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::Kms::V1::EkmService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_ekm_connections.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::Kms::V1::EkmService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_ekm_connections.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::Kms::V1::EkmService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "cloudkms.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the EkmService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `list_ekm_connections`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_ekm_connections
                ##
                # RPC-specific configuration for `get_ekm_connection`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_ekm_connection
                ##
                # RPC-specific configuration for `create_ekm_connection`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_ekm_connection
                ##
                # RPC-specific configuration for `update_ekm_connection`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_ekm_connection
                ##
                # RPC-specific configuration for `get_ekm_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_ekm_config
                ##
                # RPC-specific configuration for `update_ekm_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_ekm_config
                ##
                # RPC-specific configuration for `verify_connectivity`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :verify_connectivity

                # @private
                def initialize parent_rpcs = nil
                  list_ekm_connections_config = parent_rpcs.list_ekm_connections if parent_rpcs.respond_to? :list_ekm_connections
                  @list_ekm_connections = ::Gapic::Config::Method.new list_ekm_connections_config
                  get_ekm_connection_config = parent_rpcs.get_ekm_connection if parent_rpcs.respond_to? :get_ekm_connection
                  @get_ekm_connection = ::Gapic::Config::Method.new get_ekm_connection_config
                  create_ekm_connection_config = parent_rpcs.create_ekm_connection if parent_rpcs.respond_to? :create_ekm_connection
                  @create_ekm_connection = ::Gapic::Config::Method.new create_ekm_connection_config
                  update_ekm_connection_config = parent_rpcs.update_ekm_connection if parent_rpcs.respond_to? :update_ekm_connection
                  @update_ekm_connection = ::Gapic::Config::Method.new update_ekm_connection_config
                  get_ekm_config_config = parent_rpcs.get_ekm_config if parent_rpcs.respond_to? :get_ekm_config
                  @get_ekm_config = ::Gapic::Config::Method.new get_ekm_config_config
                  update_ekm_config_config = parent_rpcs.update_ekm_config if parent_rpcs.respond_to? :update_ekm_config
                  @update_ekm_config = ::Gapic::Config::Method.new update_ekm_config_config
                  verify_connectivity_config = parent_rpcs.verify_connectivity if parent_rpcs.respond_to? :verify_connectivity
                  @verify_connectivity = ::Gapic::Config::Method.new verify_connectivity_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
