# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/cloud/kms/v1/autokey.proto for package 'google.cloud.kms.v1'
# Original file comments:
# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/cloud/kms/v1/autokey_pb'

module Google
  module Cloud
    module Kms
      module V1
        module Autokey
          # Provides interfaces for using [Cloud KMS
          # Autokey](https://cloud.google.com/kms/help/autokey) to provision new
          # [CryptoKeys][google.cloud.kms.v1.CryptoKey], ready for Customer Managed
          # Encryption Key (CMEK) use, on-demand. To support certain client tooling, this
          # feature is modeled around a [KeyHandle][google.cloud.kms.v1.KeyHandle]
          # resource: creating a [KeyHandle][google.cloud.kms.v1.KeyHandle] in a resource
          # project and given location triggers Cloud KMS Autokey to provision a
          # [CryptoKey][google.cloud.kms.v1.CryptoKey] in the configured key project and
          # the same location.
          #
          # Prior to use in a given resource project,
          # [UpdateAutokeyConfig][google.cloud.kms.v1.AutokeyAdmin.UpdateAutokeyConfig]
          # should have been called on an ancestor folder, setting the key project where
          # Cloud KMS Autokey should create new
          # [CryptoKeys][google.cloud.kms.v1.CryptoKey]. See documentation for additional
          # prerequisites. To check what key project, if any, is currently configured on
          # a resource project's ancestor folder, see
          # [ShowEffectiveAutokeyConfig][google.cloud.kms.v1.AutokeyAdmin.ShowEffectiveAutokeyConfig].
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.cloud.kms.v1.Autokey'

            # Creates a new [KeyHandle][google.cloud.kms.v1.KeyHandle], triggering the
            # provisioning of a new [CryptoKey][google.cloud.kms.v1.CryptoKey] for CMEK
            # use with the given resource type in the configured key project and the same
            # location. [GetOperation][google.longrunning.Operations.GetOperation] should
            # be used to resolve the resulting long-running operation and get the
            # resulting [KeyHandle][google.cloud.kms.v1.KeyHandle] and
            # [CryptoKey][google.cloud.kms.v1.CryptoKey].
            rpc :CreateKeyHandle, ::Google::Cloud::Kms::V1::CreateKeyHandleRequest, ::Google::Longrunning::Operation
            # Returns the [KeyHandle][google.cloud.kms.v1.KeyHandle].
            rpc :GetKeyHandle, ::Google::Cloud::Kms::V1::GetKeyHandleRequest, ::Google::Cloud::Kms::V1::KeyHandle
            # Lists [KeyHandles][google.cloud.kms.v1.KeyHandle].
            rpc :ListKeyHandles, ::Google::Cloud::Kms::V1::ListKeyHandlesRequest, ::Google::Cloud::Kms::V1::ListKeyHandlesResponse
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
