# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/common"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/kms/v1/version"

require "google/cloud/kms/v1/autokey_admin/credentials"
require "google/cloud/kms/v1/autokey_admin/paths"
require "google/cloud/kms/v1/autokey_admin/client"
require "google/cloud/kms/v1/autokey_admin/rest"

module Google
  module Cloud
    module Kms
      module V1
        ##
        # Provides interfaces for managing [Cloud KMS
        # Autokey](https://cloud.google.com/kms/help/autokey) folder-level
        # configurations. A configuration is inherited by all descendent projects. A
        # configuration at one folder overrides any other configurations in its
        # ancestry. Setting a configuration on a folder is a prerequisite for Cloud KMS
        # Autokey, so that users working in a descendant project can request
        # provisioned {::Google::Cloud::Kms::V1::CryptoKey CryptoKeys}, ready for Customer
        # Managed Encryption Key (CMEK) use, on-demand.
        #
        # @example Load this service and instantiate a gRPC client
        #
        #     require "google/cloud/kms/v1/autokey_admin"
        #     client = ::Google::Cloud::Kms::V1::AutokeyAdmin::Client.new
        #
        # @example Load this service and instantiate a REST client
        #
        #     require "google/cloud/kms/v1/autokey_admin/rest"
        #     client = ::Google::Cloud::Kms::V1::AutokeyAdmin::Rest::Client.new
        #
        module AutokeyAdmin
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "autokey_admin", "helpers.rb"
require "google/cloud/kms/v1/autokey_admin/helpers" if ::File.file? helper_path
