# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/rest"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/kms/v1/version"
require "google/cloud/kms/v1/bindings_override"

require "google/cloud/kms/v1/autokey/credentials"
require "google/cloud/kms/v1/autokey/paths"
require "google/cloud/kms/v1/autokey/rest/operations"
require "google/cloud/kms/v1/autokey/rest/client"

module Google
  module Cloud
    module Kms
      module V1
        ##
        # Provides interfaces for using [Cloud KMS
        # Autokey](https://cloud.google.com/kms/help/autokey) to provision new
        # {::Google::Cloud::Kms::V1::CryptoKey CryptoKeys}, ready for Customer Managed
        # Encryption Key (CMEK) use, on-demand. To support certain client tooling, this
        # feature is modeled around a {::Google::Cloud::Kms::V1::KeyHandle KeyHandle}
        # resource: creating a {::Google::Cloud::Kms::V1::KeyHandle KeyHandle} in a resource
        # project and given location triggers Cloud KMS Autokey to provision a
        # {::Google::Cloud::Kms::V1::CryptoKey CryptoKey} in the configured key project and
        # the same location.
        #
        # Prior to use in a given resource project,
        # {::Google::Cloud::Kms::V1::AutokeyAdmin::Client#update_autokey_config UpdateAutokeyConfig}
        # should have been called on an ancestor folder, setting the key project where
        # Cloud KMS Autokey should create new
        # {::Google::Cloud::Kms::V1::CryptoKey CryptoKeys}. See documentation for additional
        # prerequisites. To check what key project, if any, is currently configured on
        # a resource project's ancestor folder, see
        # {::Google::Cloud::Kms::V1::AutokeyAdmin::Client#show_effective_autokey_config ShowEffectiveAutokeyConfig}.
        #
        # To load this service and instantiate a REST client:
        #
        #     require "google/cloud/kms/v1/autokey/rest"
        #     client = ::Google::Cloud::Kms::V1::Autokey::Rest::Client.new
        #
        module Autokey
          # Client for the REST transport
          module Rest
          end
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "rest", "helpers.rb"
require "google/cloud/kms/v1/autokey/rest/helpers" if ::File.file? helper_path
