# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Kms
      module V1
        # A {::Google::Cloud::Kms::V1::KeyRing KeyRing} is a toplevel logical grouping of
        # {::Google::Cloud::Kms::V1::CryptoKey CryptoKeys}.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The resource name for the
        #     {::Google::Cloud::Kms::V1::KeyRing KeyRing} in the format
        #     `projects/*/locations/*/keyRings/*`.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which this {::Google::Cloud::Kms::V1::KeyRing KeyRing}
        #     was created.
        class KeyRing
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A {::Google::Cloud::Kms::V1::CryptoKey CryptoKey} represents a logical key that
        # can be used for cryptographic operations.
        #
        # A {::Google::Cloud::Kms::V1::CryptoKey CryptoKey} is made up of zero or more
        # {::Google::Cloud::Kms::V1::CryptoKeyVersion versions}, which represent the actual
        # key material used in cryptographic operations.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The resource name for this
        #     {::Google::Cloud::Kms::V1::CryptoKey CryptoKey} in the format
        #     `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
        # @!attribute [r] primary
        #   @return [::Google::Cloud::Kms::V1::CryptoKeyVersion]
        #     Output only. A copy of the "primary"
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} that will be used
        #     by [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt] when this
        #     {::Google::Cloud::Kms::V1::CryptoKey CryptoKey} is given in
        #     [EncryptRequest.name][google.cloud.kms.v1.EncryptRequest.name].
        #
        #     The {::Google::Cloud::Kms::V1::CryptoKey CryptoKey}'s primary version can be
        #     updated via
        #     [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion].
        #
        #     Keys with {::Google::Cloud::Kms::V1::CryptoKey#purpose purpose}
        #     {::Google::Cloud::Kms::V1::CryptoKey::CryptoKeyPurpose::ENCRYPT_DECRYPT ENCRYPT_DECRYPT}
        #     may have a primary. For other keys, this field will be omitted.
        # @!attribute [rw] purpose
        #   @return [::Google::Cloud::Kms::V1::CryptoKey::CryptoKeyPurpose]
        #     Immutable. The immutable purpose of this
        #     {::Google::Cloud::Kms::V1::CryptoKey CryptoKey}.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which this
        #     {::Google::Cloud::Kms::V1::CryptoKey CryptoKey} was created.
        # @!attribute [rw] next_rotation_time
        #   @return [::Google::Protobuf::Timestamp]
        #     At {::Google::Cloud::Kms::V1::CryptoKey#next_rotation_time next_rotation_time},
        #     the Key Management Service will automatically:
        #
        #     1. Create a new version of this {::Google::Cloud::Kms::V1::CryptoKey CryptoKey}.
        #     2. Mark the new version as primary.
        #
        #     Key rotations performed manually via
        #     [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion]
        #     and
        #     [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion]
        #     do not affect
        #     {::Google::Cloud::Kms::V1::CryptoKey#next_rotation_time next_rotation_time}.
        #
        #     Keys with {::Google::Cloud::Kms::V1::CryptoKey#purpose purpose}
        #     {::Google::Cloud::Kms::V1::CryptoKey::CryptoKeyPurpose::ENCRYPT_DECRYPT ENCRYPT_DECRYPT}
        #     support automatic rotation. For other keys, this field must be omitted.
        # @!attribute [rw] rotation_period
        #   @return [::Google::Protobuf::Duration]
        #     {::Google::Cloud::Kms::V1::CryptoKey#next_rotation_time next_rotation_time}
        #     will be advanced by this period when the service automatically rotates a
        #     key. Must be at least 24 hours and at most 876,000 hours.
        #
        #     If {::Google::Cloud::Kms::V1::CryptoKey#rotation_period rotation_period} is
        #     set,
        #     {::Google::Cloud::Kms::V1::CryptoKey#next_rotation_time next_rotation_time}
        #     must also be set.
        #
        #     Keys with {::Google::Cloud::Kms::V1::CryptoKey#purpose purpose}
        #     {::Google::Cloud::Kms::V1::CryptoKey::CryptoKeyPurpose::ENCRYPT_DECRYPT ENCRYPT_DECRYPT}
        #     support automatic rotation. For other keys, this field must be omitted.
        # @!attribute [rw] version_template
        #   @return [::Google::Cloud::Kms::V1::CryptoKeyVersionTemplate]
        #     A template describing settings for new
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} instances. The
        #     properties of new {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion}
        #     instances created by either
        #     [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion]
        #     or auto-rotation are controlled by this template.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels with user-defined metadata. For more information, see
        #     [Labeling Keys](https://cloud.google.com/kms/docs/labeling-keys).
        # @!attribute [rw] import_only
        #   @return [::Boolean]
        #     Immutable. Whether this key may contain imported versions only.
        # @!attribute [rw] destroy_scheduled_duration
        #   @return [::Google::Protobuf::Duration]
        #     Immutable. The period of time that versions of this key spend in the
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion::CryptoKeyVersionState::DESTROY_SCHEDULED DESTROY_SCHEDULED}
        #     state before transitioning to
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion::CryptoKeyVersionState::DESTROYED DESTROYED}.
        #     If not specified at creation time, the default duration is 30 days.
        # @!attribute [rw] crypto_key_backend
        #   @return [::String]
        #     Immutable. The resource name of the backend environment where the key
        #     material for all {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersions}
        #     associated with this {::Google::Cloud::Kms::V1::CryptoKey CryptoKey} reside and
        #     where all related cryptographic operations are performed. Only applicable
        #     if {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersions} have a
        #     {::Google::Cloud::Kms::V1::ProtectionLevel ProtectionLevel} of
        #     {::Google::Cloud::Kms::V1::ProtectionLevel::EXTERNAL_VPC EXTERNAL_VPC}, with the
        #     resource name in the format `projects/*/locations/*/ekmConnections/*`.
        #     Note, this list is non-exhaustive and may apply to additional
        #     {::Google::Cloud::Kms::V1::ProtectionLevel ProtectionLevels} in the future.
        # @!attribute [rw] key_access_justifications_policy
        #   @return [::Google::Cloud::Kms::V1::KeyAccessJustificationsPolicy]
        #     Optional. The policy used for Key Access Justifications Policy Enforcement.
        #     If this field is present and this key is enrolled in Key Access
        #     Justifications Policy Enforcement, the policy will be evaluated in encrypt,
        #     decrypt, and sign operations, and the operation will fail if rejected by
        #     the policy. The policy is defined by specifying zero or more allowed
        #     justification codes.
        #     https://cloud.google.com/assured-workloads/key-access-justifications/docs/justification-codes
        #     By default, this field is absent, and all justification codes are allowed.
        class CryptoKey
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # {::Google::Cloud::Kms::V1::CryptoKey::CryptoKeyPurpose CryptoKeyPurpose}
          # describes the cryptographic capabilities of a
          # {::Google::Cloud::Kms::V1::CryptoKey CryptoKey}. A given key can only be used
          # for the operations allowed by its purpose. For more information, see [Key
          # purposes](https://cloud.google.com/kms/docs/algorithms#key_purposes).
          module CryptoKeyPurpose
            # Not specified.
            CRYPTO_KEY_PURPOSE_UNSPECIFIED = 0

            # {::Google::Cloud::Kms::V1::CryptoKey CryptoKeys} with this purpose may be used
            # with [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt] and
            # [Decrypt][google.cloud.kms.v1.KeyManagementService.Decrypt].
            ENCRYPT_DECRYPT = 1

            # {::Google::Cloud::Kms::V1::CryptoKey CryptoKeys} with this purpose may be used
            # with
            # [AsymmetricSign][google.cloud.kms.v1.KeyManagementService.AsymmetricSign]
            # and
            # [GetPublicKey][google.cloud.kms.v1.KeyManagementService.GetPublicKey].
            ASYMMETRIC_SIGN = 5

            # {::Google::Cloud::Kms::V1::CryptoKey CryptoKeys} with this purpose may be used
            # with
            # [AsymmetricDecrypt][google.cloud.kms.v1.KeyManagementService.AsymmetricDecrypt]
            # and
            # [GetPublicKey][google.cloud.kms.v1.KeyManagementService.GetPublicKey].
            ASYMMETRIC_DECRYPT = 6

            # {::Google::Cloud::Kms::V1::CryptoKey CryptoKeys} with this purpose may be used
            # with [RawEncrypt][google.cloud.kms.v1.KeyManagementService.RawEncrypt]
            # and [RawDecrypt][google.cloud.kms.v1.KeyManagementService.RawDecrypt].
            # This purpose is meant to be used for interoperable symmetric
            # encryption and does not support automatic CryptoKey rotation.
            RAW_ENCRYPT_DECRYPT = 7

            # {::Google::Cloud::Kms::V1::CryptoKey CryptoKeys} with this purpose may be used
            # with [MacSign][google.cloud.kms.v1.KeyManagementService.MacSign].
            MAC = 9

            # {::Google::Cloud::Kms::V1::CryptoKey CryptoKeys} with this purpose may be used
            # with
            # [GetPublicKey][google.cloud.kms.v1.KeyManagementService.GetPublicKey]
            # and [Decapsulate][google.cloud.kms.v1.KeyManagementService.Decapsulate].
            KEY_ENCAPSULATION = 10
          end
        end

        # A {::Google::Cloud::Kms::V1::CryptoKeyVersionTemplate CryptoKeyVersionTemplate}
        # specifies the properties to use when creating a new
        # {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion}, either manually
        # with
        # [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion]
        # or automatically as a result of auto-rotation.
        # @!attribute [rw] protection_level
        #   @return [::Google::Cloud::Kms::V1::ProtectionLevel]
        #     {::Google::Cloud::Kms::V1::ProtectionLevel ProtectionLevel} to use when creating
        #     a {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} based on this
        #     template. Immutable. Defaults to
        #     {::Google::Cloud::Kms::V1::ProtectionLevel::SOFTWARE SOFTWARE}.
        # @!attribute [rw] algorithm
        #   @return [::Google::Cloud::Kms::V1::CryptoKeyVersion::CryptoKeyVersionAlgorithm]
        #     Required.
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion::CryptoKeyVersionAlgorithm Algorithm}
        #     to use when creating a
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} based on this
        #     template.
        #
        #     For backwards compatibility, GOOGLE_SYMMETRIC_ENCRYPTION is implied if both
        #     this field is omitted and
        #     {::Google::Cloud::Kms::V1::CryptoKey#purpose CryptoKey.purpose} is
        #     {::Google::Cloud::Kms::V1::CryptoKey::CryptoKeyPurpose::ENCRYPT_DECRYPT ENCRYPT_DECRYPT}.
        class CryptoKeyVersionTemplate
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Contains an HSM-generated attestation about a key operation. For more
        # information, see [Verifying attestations]
        # (https://cloud.google.com/kms/docs/attest-key).
        # @!attribute [r] format
        #   @return [::Google::Cloud::Kms::V1::KeyOperationAttestation::AttestationFormat]
        #     Output only. The format of the attestation data.
        # @!attribute [r] content
        #   @return [::String]
        #     Output only. The attestation data provided by the HSM when the key
        #     operation was performed.
        # @!attribute [r] cert_chains
        #   @return [::Google::Cloud::Kms::V1::KeyOperationAttestation::CertificateChains]
        #     Output only. The certificate chains needed to validate the attestation
        class KeyOperationAttestation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Certificate chains needed to verify the attestation.
          # Certificates in chains are PEM-encoded and are ordered based on
          # https://tools.ietf.org/html/rfc5246#section-7.4.2.
          # @!attribute [rw] cavium_certs
          #   @return [::Array<::String>]
          #     Cavium certificate chain corresponding to the attestation.
          # @!attribute [rw] google_card_certs
          #   @return [::Array<::String>]
          #     Google card certificate chain corresponding to the attestation.
          # @!attribute [rw] google_partition_certs
          #   @return [::Array<::String>]
          #     Google partition certificate chain corresponding to the attestation.
          class CertificateChains
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Attestation formats provided by the HSM.
          module AttestationFormat
            # Not specified.
            ATTESTATION_FORMAT_UNSPECIFIED = 0

            # Cavium HSM attestation compressed with gzip. Note that this format is
            # defined by Cavium and subject to change at any time.
            #
            # See
            # https://www.marvell.com/products/security-solutions/nitrox-hs-adapters/software-key-attestation.html.
            CAVIUM_V1_COMPRESSED = 3

            # Cavium HSM attestation V2 compressed with gzip. This is a new format
            # introduced in Cavium's version 3.2-08.
            CAVIUM_V2_COMPRESSED = 4
          end
        end

        # A {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} represents an
        # individual cryptographic key, and the associated key material.
        #
        # An
        # {::Google::Cloud::Kms::V1::CryptoKeyVersion::CryptoKeyVersionState::ENABLED ENABLED}
        # version can be used for cryptographic operations.
        #
        # For security reasons, the raw cryptographic key material represented by a
        # {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} can never be viewed
        # or exported. It can only be used to encrypt, decrypt, or sign data when an
        # authorized user or application invokes Cloud KMS.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The resource name for this
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} in the format
        #     `projects/*/locations/*/keyRings/*/cryptoKeys/*/cryptoKeyVersions/*`.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::Kms::V1::CryptoKeyVersion::CryptoKeyVersionState]
        #     The current state of the
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion}.
        # @!attribute [r] protection_level
        #   @return [::Google::Cloud::Kms::V1::ProtectionLevel]
        #     Output only. The {::Google::Cloud::Kms::V1::ProtectionLevel ProtectionLevel}
        #     describing how crypto operations are performed with this
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion}.
        # @!attribute [r] algorithm
        #   @return [::Google::Cloud::Kms::V1::CryptoKeyVersion::CryptoKeyVersionAlgorithm]
        #     Output only. The
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion::CryptoKeyVersionAlgorithm CryptoKeyVersionAlgorithm}
        #     that this {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion}
        #     supports.
        # @!attribute [r] attestation
        #   @return [::Google::Cloud::Kms::V1::KeyOperationAttestation]
        #     Output only. Statement that was generated and signed by the HSM at key
        #     creation time. Use this statement to verify attributes of the key as stored
        #     on the HSM, independently of Google. Only provided for key versions with
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion#protection_level protection_level}
        #     {::Google::Cloud::Kms::V1::ProtectionLevel::HSM HSM}.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which this
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} was created.
        # @!attribute [r] generate_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time this
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion}'s key material was
        #     generated.
        # @!attribute [r] destroy_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time this
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion}'s key material is
        #     scheduled for destruction. Only present if
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion#state state} is
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion::CryptoKeyVersionState::DESTROY_SCHEDULED DESTROY_SCHEDULED}.
        # @!attribute [r] destroy_event_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time this CryptoKeyVersion's key material was
        #     destroyed. Only present if
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion#state state} is
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion::CryptoKeyVersionState::DESTROYED DESTROYED}.
        # @!attribute [r] import_job
        #   @return [::String]
        #     Output only. The name of the {::Google::Cloud::Kms::V1::ImportJob ImportJob}
        #     used in the most recent import of this
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion}. Only present if
        #     the underlying key material was imported.
        # @!attribute [r] import_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which this
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion}'s key material was
        #     most recently imported.
        # @!attribute [r] import_failure_reason
        #   @return [::String]
        #     Output only. The root cause of the most recent import failure. Only present
        #     if {::Google::Cloud::Kms::V1::CryptoKeyVersion#state state} is
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion::CryptoKeyVersionState::IMPORT_FAILED IMPORT_FAILED}.
        # @!attribute [r] generation_failure_reason
        #   @return [::String]
        #     Output only. The root cause of the most recent generation failure. Only
        #     present if {::Google::Cloud::Kms::V1::CryptoKeyVersion#state state} is
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion::CryptoKeyVersionState::GENERATION_FAILED GENERATION_FAILED}.
        # @!attribute [r] external_destruction_failure_reason
        #   @return [::String]
        #     Output only. The root cause of the most recent external destruction
        #     failure. Only present if
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion#state state} is
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion::CryptoKeyVersionState::EXTERNAL_DESTRUCTION_FAILED EXTERNAL_DESTRUCTION_FAILED}.
        # @!attribute [rw] external_protection_level_options
        #   @return [::Google::Cloud::Kms::V1::ExternalProtectionLevelOptions]
        #     ExternalProtectionLevelOptions stores a group of additional fields for
        #     configuring a {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} that
        #     are specific to the
        #     {::Google::Cloud::Kms::V1::ProtectionLevel::EXTERNAL EXTERNAL} protection level
        #     and {::Google::Cloud::Kms::V1::ProtectionLevel::EXTERNAL_VPC EXTERNAL_VPC}
        #     protection levels.
        # @!attribute [r] reimport_eligible
        #   @return [::Boolean]
        #     Output only. Whether or not this key version is eligible for reimport, by
        #     being specified as a target in
        #     [ImportCryptoKeyVersionRequest.crypto_key_version][google.cloud.kms.v1.ImportCryptoKeyVersionRequest.crypto_key_version].
        class CryptoKeyVersion
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The algorithm of the
          # {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion}, indicating what
          # parameters must be used for each cryptographic operation.
          #
          # The
          # {::Google::Cloud::Kms::V1::CryptoKeyVersion::CryptoKeyVersionAlgorithm::GOOGLE_SYMMETRIC_ENCRYPTION GOOGLE_SYMMETRIC_ENCRYPTION}
          # algorithm is usable with
          # {::Google::Cloud::Kms::V1::CryptoKey#purpose CryptoKey.purpose}
          # {::Google::Cloud::Kms::V1::CryptoKey::CryptoKeyPurpose::ENCRYPT_DECRYPT ENCRYPT_DECRYPT}.
          #
          # Algorithms beginning with `RSA_SIGN_` are usable with
          # {::Google::Cloud::Kms::V1::CryptoKey#purpose CryptoKey.purpose}
          # {::Google::Cloud::Kms::V1::CryptoKey::CryptoKeyPurpose::ASYMMETRIC_SIGN ASYMMETRIC_SIGN}.
          #
          # The fields in the name after `RSA_SIGN_` correspond to the following
          # parameters: padding algorithm, modulus bit length, and digest algorithm.
          #
          # For PSS, the salt length used is equal to the length of digest
          # algorithm. For example,
          # {::Google::Cloud::Kms::V1::CryptoKeyVersion::CryptoKeyVersionAlgorithm::RSA_SIGN_PSS_2048_SHA256 RSA_SIGN_PSS_2048_SHA256}
          # will use PSS with a salt length of 256 bits or 32 bytes.
          #
          # Algorithms beginning with `RSA_DECRYPT_` are usable with
          # {::Google::Cloud::Kms::V1::CryptoKey#purpose CryptoKey.purpose}
          # {::Google::Cloud::Kms::V1::CryptoKey::CryptoKeyPurpose::ASYMMETRIC_DECRYPT ASYMMETRIC_DECRYPT}.
          #
          # The fields in the name after `RSA_DECRYPT_` correspond to the following
          # parameters: padding algorithm, modulus bit length, and digest algorithm.
          #
          # Algorithms beginning with `EC_SIGN_` are usable with
          # {::Google::Cloud::Kms::V1::CryptoKey#purpose CryptoKey.purpose}
          # {::Google::Cloud::Kms::V1::CryptoKey::CryptoKeyPurpose::ASYMMETRIC_SIGN ASYMMETRIC_SIGN}.
          #
          # The fields in the name after `EC_SIGN_` correspond to the following
          # parameters: elliptic curve, digest algorithm.
          #
          # Algorithms beginning with `HMAC_` are usable with
          # {::Google::Cloud::Kms::V1::CryptoKey#purpose CryptoKey.purpose}
          # {::Google::Cloud::Kms::V1::CryptoKey::CryptoKeyPurpose::MAC MAC}.
          #
          # The suffix following `HMAC_` corresponds to the hash algorithm being used
          # (eg. SHA256).
          #
          # Algorithms beginning with `PQ_` are post-quantum.
          #
          # For more information, see [Key purposes and algorithms]
          # (https://cloud.google.com/kms/docs/algorithms).
          module CryptoKeyVersionAlgorithm
            # Not specified.
            CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED = 0

            # Creates symmetric encryption keys.
            GOOGLE_SYMMETRIC_ENCRYPTION = 1

            # AES-GCM (Galois Counter Mode) using 128-bit keys.
            AES_128_GCM = 41

            # AES-GCM (Galois Counter Mode) using 256-bit keys.
            AES_256_GCM = 19

            # AES-CBC (Cipher Block Chaining Mode) using 128-bit keys.
            AES_128_CBC = 42

            # AES-CBC (Cipher Block Chaining Mode) using 256-bit keys.
            AES_256_CBC = 43

            # AES-CTR (Counter Mode) using 128-bit keys.
            AES_128_CTR = 44

            # AES-CTR (Counter Mode) using 256-bit keys.
            AES_256_CTR = 45

            # RSASSA-PSS 2048 bit key with a SHA256 digest.
            RSA_SIGN_PSS_2048_SHA256 = 2

            # RSASSA-PSS 3072 bit key with a SHA256 digest.
            RSA_SIGN_PSS_3072_SHA256 = 3

            # RSASSA-PSS 4096 bit key with a SHA256 digest.
            RSA_SIGN_PSS_4096_SHA256 = 4

            # RSASSA-PSS 4096 bit key with a SHA512 digest.
            RSA_SIGN_PSS_4096_SHA512 = 15

            # RSASSA-PKCS1-v1_5 with a 2048 bit key and a SHA256 digest.
            RSA_SIGN_PKCS1_2048_SHA256 = 5

            # RSASSA-PKCS1-v1_5 with a 3072 bit key and a SHA256 digest.
            RSA_SIGN_PKCS1_3072_SHA256 = 6

            # RSASSA-PKCS1-v1_5 with a 4096 bit key and a SHA256 digest.
            RSA_SIGN_PKCS1_4096_SHA256 = 7

            # RSASSA-PKCS1-v1_5 with a 4096 bit key and a SHA512 digest.
            RSA_SIGN_PKCS1_4096_SHA512 = 16

            # RSASSA-PKCS1-v1_5 signing without encoding, with a 2048 bit key.
            RSA_SIGN_RAW_PKCS1_2048 = 28

            # RSASSA-PKCS1-v1_5 signing without encoding, with a 3072 bit key.
            RSA_SIGN_RAW_PKCS1_3072 = 29

            # RSASSA-PKCS1-v1_5 signing without encoding, with a 4096 bit key.
            RSA_SIGN_RAW_PKCS1_4096 = 30

            # RSAES-OAEP 2048 bit key with a SHA256 digest.
            RSA_DECRYPT_OAEP_2048_SHA256 = 8

            # RSAES-OAEP 3072 bit key with a SHA256 digest.
            RSA_DECRYPT_OAEP_3072_SHA256 = 9

            # RSAES-OAEP 4096 bit key with a SHA256 digest.
            RSA_DECRYPT_OAEP_4096_SHA256 = 10

            # RSAES-OAEP 4096 bit key with a SHA512 digest.
            RSA_DECRYPT_OAEP_4096_SHA512 = 17

            # RSAES-OAEP 2048 bit key with a SHA1 digest.
            RSA_DECRYPT_OAEP_2048_SHA1 = 37

            # RSAES-OAEP 3072 bit key with a SHA1 digest.
            RSA_DECRYPT_OAEP_3072_SHA1 = 38

            # RSAES-OAEP 4096 bit key with a SHA1 digest.
            RSA_DECRYPT_OAEP_4096_SHA1 = 39

            # ECDSA on the NIST P-256 curve with a SHA256 digest.
            # Other hash functions can also be used:
            # https://cloud.google.com/kms/docs/create-validate-signatures#ecdsa_support_for_other_hash_algorithms
            EC_SIGN_P256_SHA256 = 12

            # ECDSA on the NIST P-384 curve with a SHA384 digest.
            # Other hash functions can also be used:
            # https://cloud.google.com/kms/docs/create-validate-signatures#ecdsa_support_for_other_hash_algorithms
            EC_SIGN_P384_SHA384 = 13

            # ECDSA on the non-NIST secp256k1 curve. This curve is only supported for
            # HSM protection level.
            # Other hash functions can also be used:
            # https://cloud.google.com/kms/docs/create-validate-signatures#ecdsa_support_for_other_hash_algorithms
            EC_SIGN_SECP256K1_SHA256 = 31

            # EdDSA on the Curve25519 in pure mode (taking data as input).
            EC_SIGN_ED25519 = 40

            # HMAC-SHA256 signing with a 256 bit key.
            HMAC_SHA256 = 32

            # HMAC-SHA1 signing with a 160 bit key.
            HMAC_SHA1 = 33

            # HMAC-SHA384 signing with a 384 bit key.
            HMAC_SHA384 = 34

            # HMAC-SHA512 signing with a 512 bit key.
            HMAC_SHA512 = 35

            # HMAC-SHA224 signing with a 224 bit key.
            HMAC_SHA224 = 36

            # Algorithm representing symmetric encryption by an external key manager.
            EXTERNAL_SYMMETRIC_ENCRYPTION = 18

            # ML-KEM-768 (FIPS 203)
            ML_KEM_768 = 47

            # ML-KEM-1024 (FIPS 203)
            ML_KEM_1024 = 48

            # X-Wing hybrid KEM combining ML-KEM-768 with X25519 following
            # datatracker.ietf.org/doc/draft-connolly-cfrg-xwing-kem/.
            KEM_XWING = 63

            # The post-quantum Module-Lattice-Based Digital Signature Algorithm, at
            # security level 3. Randomized version.
            PQ_SIGN_ML_DSA_65 = 56

            # The post-quantum stateless hash-based digital signature algorithm, at
            # security level 1. Randomized version.
            PQ_SIGN_SLH_DSA_SHA2_128S = 57
          end

          # The state of a {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion},
          # indicating if it can be used.
          module CryptoKeyVersionState
            # Not specified.
            CRYPTO_KEY_VERSION_STATE_UNSPECIFIED = 0

            # This version is still being generated. It may not be used, enabled,
            # disabled, or destroyed yet. Cloud KMS will automatically mark this
            # version
            # {::Google::Cloud::Kms::V1::CryptoKeyVersion::CryptoKeyVersionState::ENABLED ENABLED}
            # as soon as the version is ready.
            PENDING_GENERATION = 5

            # This version may be used for cryptographic operations.
            ENABLED = 1

            # This version may not be used, but the key material is still available,
            # and the version can be placed back into the
            # {::Google::Cloud::Kms::V1::CryptoKeyVersion::CryptoKeyVersionState::ENABLED ENABLED}
            # state.
            DISABLED = 2

            # The key material of this version is destroyed and no longer stored.
            # This version may only become
            # {::Google::Cloud::Kms::V1::CryptoKeyVersion::CryptoKeyVersionState::ENABLED ENABLED}
            # again if this version is
            # {::Google::Cloud::Kms::V1::CryptoKeyVersion#reimport_eligible reimport_eligible}
            # and the original key material is reimported with a call to
            # [KeyManagementService.ImportCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.ImportCryptoKeyVersion].
            DESTROYED = 3

            # This version is scheduled for destruction, and will be destroyed soon.
            # Call
            # [RestoreCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.RestoreCryptoKeyVersion]
            # to put it back into the
            # {::Google::Cloud::Kms::V1::CryptoKeyVersion::CryptoKeyVersionState::DISABLED DISABLED}
            # state.
            DESTROY_SCHEDULED = 4

            # This version is still being imported. It may not be used, enabled,
            # disabled, or destroyed yet. Cloud KMS will automatically mark this
            # version
            # {::Google::Cloud::Kms::V1::CryptoKeyVersion::CryptoKeyVersionState::ENABLED ENABLED}
            # as soon as the version is ready.
            PENDING_IMPORT = 6

            # This version was not imported successfully. It may not be used, enabled,
            # disabled, or destroyed. The submitted key material has been discarded.
            # Additional details can be found in
            # {::Google::Cloud::Kms::V1::CryptoKeyVersion#import_failure_reason CryptoKeyVersion.import_failure_reason}.
            IMPORT_FAILED = 7

            # This version was not generated successfully. It may not be used, enabled,
            # disabled, or destroyed. Additional details can be found in
            # {::Google::Cloud::Kms::V1::CryptoKeyVersion#generation_failure_reason CryptoKeyVersion.generation_failure_reason}.
            GENERATION_FAILED = 8

            # This version was destroyed, and it may not be used or enabled again.
            # Cloud KMS is waiting for the corresponding key material residing in an
            # external key manager to be destroyed.
            PENDING_EXTERNAL_DESTRUCTION = 9

            # This version was destroyed, and it may not be used or enabled again.
            # However, Cloud KMS could not confirm that the corresponding key material
            # residing in an external key manager was destroyed. Additional details can
            # be found in
            # {::Google::Cloud::Kms::V1::CryptoKeyVersion#external_destruction_failure_reason CryptoKeyVersion.external_destruction_failure_reason}.
            EXTERNAL_DESTRUCTION_FAILED = 10
          end

          # A view for {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion}s.
          # Controls the level of detail returned for
          # {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersions} in
          # [KeyManagementService.ListCryptoKeyVersions][google.cloud.kms.v1.KeyManagementService.ListCryptoKeyVersions]
          # and
          # [KeyManagementService.ListCryptoKeys][google.cloud.kms.v1.KeyManagementService.ListCryptoKeys].
          module CryptoKeyVersionView
            # Default view for each
            # {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion}. Does not
            # include the
            # {::Google::Cloud::Kms::V1::CryptoKeyVersion#attestation attestation} field.
            CRYPTO_KEY_VERSION_VIEW_UNSPECIFIED = 0

            # Provides all fields in each
            # {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion}, including the
            # {::Google::Cloud::Kms::V1::CryptoKeyVersion#attestation attestation}.
            FULL = 1
          end
        end

        # Data with integrity verification field.
        # @!attribute [rw] data
        #   @return [::String]
        #     Raw Data.
        # @!attribute [rw] crc32c_checksum
        #   @return [::Google::Protobuf::Int64Value]
        #     Integrity verification field. A CRC32C
        #     checksum of the returned
        #     {::Google::Cloud::Kms::V1::ChecksummedData#data ChecksummedData.data}. An
        #     integrity check of
        #     {::Google::Cloud::Kms::V1::ChecksummedData#data ChecksummedData.data} can be
        #     performed by computing the CRC32C checksum of
        #     {::Google::Cloud::Kms::V1::ChecksummedData#data ChecksummedData.data} and
        #     comparing your results to this field. Discard the response in case of
        #     non-matching checksum values, and perform a limited number of retries. A
        #     persistent mismatch may indicate an issue in your computation of the CRC32C
        #     checksum. Note: This field is defined as int64 for reasons of compatibility
        #     across different languages. However, it is a non-negative integer, which
        #     will never exceed `2^32-1`, and can be safely downconverted to uint32 in
        #     languages that support this type.
        class ChecksummedData
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The public keys for a given
        # {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion}. Obtained via
        # [GetPublicKey][google.cloud.kms.v1.KeyManagementService.GetPublicKey].
        # @!attribute [rw] pem
        #   @return [::String]
        #     The public key, encoded in PEM format. For more information, see the
        #     [RFC 7468](https://tools.ietf.org/html/rfc7468) sections for
        #     [General Considerations](https://tools.ietf.org/html/rfc7468#section-2) and
        #     [Textual Encoding of Subject Public Key Info]
        #     (https://tools.ietf.org/html/rfc7468#section-13).
        # @!attribute [rw] algorithm
        #   @return [::Google::Cloud::Kms::V1::CryptoKeyVersion::CryptoKeyVersionAlgorithm]
        #     The
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion::CryptoKeyVersionAlgorithm Algorithm}
        #     associated with this key.
        # @!attribute [rw] pem_crc32c
        #   @return [::Google::Protobuf::Int64Value]
        #     Integrity verification field. A CRC32C checksum of the returned
        #     {::Google::Cloud::Kms::V1::PublicKey#pem PublicKey.pem}. An integrity check of
        #     {::Google::Cloud::Kms::V1::PublicKey#pem PublicKey.pem} can be performed by
        #     computing the CRC32C checksum of
        #     {::Google::Cloud::Kms::V1::PublicKey#pem PublicKey.pem} and comparing your
        #     results to this field. Discard the response in case of non-matching
        #     checksum values, and perform a limited number of retries. A persistent
        #     mismatch may indicate an issue in your computation of the CRC32C checksum.
        #     Note: This field is defined as int64 for reasons of compatibility across
        #     different languages. However, it is a non-negative integer, which will
        #     never exceed `2^32-1`, and can be safely downconverted to uint32 in
        #     languages that support this type.
        #
        #     NOTE: This field is in Beta.
        # @!attribute [rw] name
        #   @return [::String]
        #     The {::Google::Cloud::Kms::V1::CryptoKeyVersion#name name} of the
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} public key.
        #     Provided here for verification.
        #
        #     NOTE: This field is in Beta.
        # @!attribute [rw] protection_level
        #   @return [::Google::Cloud::Kms::V1::ProtectionLevel]
        #     The {::Google::Cloud::Kms::V1::ProtectionLevel ProtectionLevel} of the
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} public key.
        # @!attribute [rw] public_key_format
        #   @return [::Google::Cloud::Kms::V1::PublicKey::PublicKeyFormat]
        #     The {::Google::Cloud::Kms::V1::PublicKey PublicKey} format specified by the
        #     customer through the
        #     [public_key_format][google.cloud.kms.v1.GetPublicKeyRequest.public_key_format]
        #     field.
        # @!attribute [rw] public_key
        #   @return [::Google::Cloud::Kms::V1::ChecksummedData]
        #     This field contains the public key (with integrity verification), formatted
        #     according to the
        #     {::Google::Cloud::Kms::V1::PublicKey#public_key_format public_key_format} field.
        class PublicKey
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The supported {::Google::Cloud::Kms::V1::PublicKey PublicKey} formats.
          module PublicKeyFormat
            # If the
            # [public_key_format][google.cloud.kms.v1.GetPublicKeyRequest.public_key_format]
            # field is not specified:
            # - For PQC algorithms, an error will be returned.
            # - For non-PQC algorithms, the default format is PEM, and the field
            #   {::Google::Cloud::Kms::V1::PublicKey#pem pem} will be populated.
            #
            # Otherwise, the public key will be exported through the
            # {::Google::Cloud::Kms::V1::PublicKey#public_key public_key} field in the
            # requested format.
            PUBLIC_KEY_FORMAT_UNSPECIFIED = 0

            # The returned public key will be encoded in PEM format.
            # See the [RFC7468](https://tools.ietf.org/html/rfc7468) sections for
            # [General Considerations](https://tools.ietf.org/html/rfc7468#section-2)
            # and [Textual Encoding of Subject Public Key Info]
            # (https://tools.ietf.org/html/rfc7468#section-13) for more information.
            PEM = 1

            # The returned public key will be encoded in DER format (the
            # PrivateKeyInfo structure from RFC 5208).
            DER = 2

            # This is supported only for PQC algorithms.
            # The key material is returned in the format defined by NIST PQC
            # standards (FIPS 203, FIPS 204, and FIPS 205).
            NIST_PQC = 3

            # The returned public key is in raw bytes format defined in its standard
            # https://datatracker.ietf.org/doc/draft-connolly-cfrg-xwing-kem.
            XWING_RAW_BYTES = 4
          end
        end

        # An {::Google::Cloud::Kms::V1::ImportJob ImportJob} can be used to create
        # {::Google::Cloud::Kms::V1::CryptoKey CryptoKeys} and
        # {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersions} using pre-existing
        # key material, generated outside of Cloud KMS.
        #
        # When an {::Google::Cloud::Kms::V1::ImportJob ImportJob} is created, Cloud KMS will
        # generate a "wrapping key", which is a public/private key pair. You use the
        # wrapping key to encrypt (also known as wrap) the pre-existing key material to
        # protect it during the import process. The nature of the wrapping key depends
        # on the choice of
        # {::Google::Cloud::Kms::V1::ImportJob#import_method import_method}. When the
        # wrapping key generation is complete, the
        # {::Google::Cloud::Kms::V1::ImportJob#state state} will be set to
        # {::Google::Cloud::Kms::V1::ImportJob::ImportJobState::ACTIVE ACTIVE} and the
        # {::Google::Cloud::Kms::V1::ImportJob#public_key public_key} can be fetched. The
        # fetched public key can then be used to wrap your pre-existing key material.
        #
        # Once the key material is wrapped, it can be imported into a new
        # {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} in an existing
        # {::Google::Cloud::Kms::V1::CryptoKey CryptoKey} by calling
        # [ImportCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.ImportCryptoKeyVersion].
        # Multiple {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersions} can be
        # imported with a single {::Google::Cloud::Kms::V1::ImportJob ImportJob}. Cloud KMS
        # uses the private key portion of the wrapping key to unwrap the key material.
        # Only Cloud KMS has access to the private key.
        #
        # An {::Google::Cloud::Kms::V1::ImportJob ImportJob} expires 3 days after it is
        # created. Once expired, Cloud KMS will no longer be able to import or unwrap
        # any key material that was wrapped with the
        # {::Google::Cloud::Kms::V1::ImportJob ImportJob}'s public key.
        #
        # For more information, see
        # [Importing a key](https://cloud.google.com/kms/docs/importing-a-key).
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The resource name for this
        #     {::Google::Cloud::Kms::V1::ImportJob ImportJob} in the format
        #     `projects/*/locations/*/keyRings/*/importJobs/*`.
        # @!attribute [rw] import_method
        #   @return [::Google::Cloud::Kms::V1::ImportJob::ImportMethod]
        #     Required. Immutable. The wrapping method to be used for incoming key
        #     material.
        # @!attribute [rw] protection_level
        #   @return [::Google::Cloud::Kms::V1::ProtectionLevel]
        #     Required. Immutable. The protection level of the
        #     {::Google::Cloud::Kms::V1::ImportJob ImportJob}. This must match the
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersionTemplate#protection_level protection_level}
        #     of the {::Google::Cloud::Kms::V1::CryptoKey#version_template version_template}
        #     on the {::Google::Cloud::Kms::V1::CryptoKey CryptoKey} you attempt to import
        #     into.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which this
        #     {::Google::Cloud::Kms::V1::ImportJob ImportJob} was created.
        # @!attribute [r] generate_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time this {::Google::Cloud::Kms::V1::ImportJob ImportJob}'s key
        #     material was generated.
        # @!attribute [r] expire_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which this
        #     {::Google::Cloud::Kms::V1::ImportJob ImportJob} is scheduled for expiration and
        #     can no longer be used to import key material.
        # @!attribute [r] expire_event_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time this {::Google::Cloud::Kms::V1::ImportJob ImportJob}
        #     expired. Only present if {::Google::Cloud::Kms::V1::ImportJob#state state} is
        #     {::Google::Cloud::Kms::V1::ImportJob::ImportJobState::EXPIRED EXPIRED}.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Kms::V1::ImportJob::ImportJobState]
        #     Output only. The current state of the
        #     {::Google::Cloud::Kms::V1::ImportJob ImportJob}, indicating if it can be used.
        # @!attribute [r] public_key
        #   @return [::Google::Cloud::Kms::V1::ImportJob::WrappingPublicKey]
        #     Output only. The public key with which to wrap key material prior to
        #     import. Only returned if {::Google::Cloud::Kms::V1::ImportJob#state state} is
        #     {::Google::Cloud::Kms::V1::ImportJob::ImportJobState::ACTIVE ACTIVE}.
        # @!attribute [r] attestation
        #   @return [::Google::Cloud::Kms::V1::KeyOperationAttestation]
        #     Output only. Statement that was generated and signed by the key creator
        #     (for example, an HSM) at key creation time. Use this statement to verify
        #     attributes of the key as stored on the HSM, independently of Google.
        #     Only present if the chosen
        #     {::Google::Cloud::Kms::V1::ImportJob::ImportMethod ImportMethod} is one with a
        #     protection level of {::Google::Cloud::Kms::V1::ProtectionLevel::HSM HSM}.
        class ImportJob
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The public key component of the wrapping key. For details of the type of
          # key this public key corresponds to, see the
          # {::Google::Cloud::Kms::V1::ImportJob::ImportMethod ImportMethod}.
          # @!attribute [rw] pem
          #   @return [::String]
          #     The public key, encoded in PEM format. For more information, see the [RFC
          #     7468](https://tools.ietf.org/html/rfc7468) sections for [General
          #     Considerations](https://tools.ietf.org/html/rfc7468#section-2) and
          #     [Textual Encoding of Subject Public Key Info]
          #     (https://tools.ietf.org/html/rfc7468#section-13).
          class WrappingPublicKey
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # {::Google::Cloud::Kms::V1::ImportJob::ImportMethod ImportMethod} describes the
          # key wrapping method chosen for this
          # {::Google::Cloud::Kms::V1::ImportJob ImportJob}.
          module ImportMethod
            # Not specified.
            IMPORT_METHOD_UNSPECIFIED = 0

            # This ImportMethod represents the CKM_RSA_AES_KEY_WRAP key wrapping
            # scheme defined in the PKCS #11 standard. In summary, this involves
            # wrapping the raw key with an ephemeral AES key, and wrapping the
            # ephemeral AES key with a 3072 bit RSA key. For more details, see
            # [RSA AES key wrap
            # mechanism](http://docs.oasis-open.org/pkcs11/pkcs11-curr/v2.40/cos01/pkcs11-curr-v2.40-cos01.html#_Toc408226908).
            RSA_OAEP_3072_SHA1_AES_256 = 1

            # This ImportMethod represents the CKM_RSA_AES_KEY_WRAP key wrapping
            # scheme defined in the PKCS #11 standard. In summary, this involves
            # wrapping the raw key with an ephemeral AES key, and wrapping the
            # ephemeral AES key with a 4096 bit RSA key. For more details, see
            # [RSA AES key wrap
            # mechanism](http://docs.oasis-open.org/pkcs11/pkcs11-curr/v2.40/cos01/pkcs11-curr-v2.40-cos01.html#_Toc408226908).
            RSA_OAEP_4096_SHA1_AES_256 = 2

            # This ImportMethod represents the CKM_RSA_AES_KEY_WRAP key wrapping
            # scheme defined in the PKCS #11 standard. In summary, this involves
            # wrapping the raw key with an ephemeral AES key, and wrapping the
            # ephemeral AES key with a 3072 bit RSA key. For more details, see
            # [RSA AES key wrap
            # mechanism](http://docs.oasis-open.org/pkcs11/pkcs11-curr/v2.40/cos01/pkcs11-curr-v2.40-cos01.html#_Toc408226908).
            RSA_OAEP_3072_SHA256_AES_256 = 3

            # This ImportMethod represents the CKM_RSA_AES_KEY_WRAP key wrapping
            # scheme defined in the PKCS #11 standard. In summary, this involves
            # wrapping the raw key with an ephemeral AES key, and wrapping the
            # ephemeral AES key with a 4096 bit RSA key. For more details, see
            # [RSA AES key wrap
            # mechanism](http://docs.oasis-open.org/pkcs11/pkcs11-curr/v2.40/cos01/pkcs11-curr-v2.40-cos01.html#_Toc408226908).
            RSA_OAEP_4096_SHA256_AES_256 = 4

            # This ImportMethod represents RSAES-OAEP with a 3072 bit RSA key. The
            # key material to be imported is wrapped directly with the RSA key. Due
            # to technical limitations of RSA wrapping, this method cannot be used to
            # wrap RSA keys for import.
            RSA_OAEP_3072_SHA256 = 5

            # This ImportMethod represents RSAES-OAEP with a 4096 bit RSA key. The
            # key material to be imported is wrapped directly with the RSA key. Due
            # to technical limitations of RSA wrapping, this method cannot be used to
            # wrap RSA keys for import.
            RSA_OAEP_4096_SHA256 = 6
          end

          # The state of the {::Google::Cloud::Kms::V1::ImportJob ImportJob}, indicating if
          # it can be used.
          module ImportJobState
            # Not specified.
            IMPORT_JOB_STATE_UNSPECIFIED = 0

            # The wrapping key for this job is still being generated. It may not be
            # used. Cloud KMS will automatically mark this job as
            # {::Google::Cloud::Kms::V1::ImportJob::ImportJobState::ACTIVE ACTIVE} as soon as
            # the wrapping key is generated.
            PENDING_GENERATION = 1

            # This job may be used in
            # [CreateCryptoKey][google.cloud.kms.v1.KeyManagementService.CreateCryptoKey]
            # and
            # [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion]
            # requests.
            ACTIVE = 2

            # This job can no longer be used and may not leave this state once entered.
            EXPIRED = 3
          end
        end

        # ExternalProtectionLevelOptions stores a group of additional fields for
        # configuring a {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} that
        # are specific to the {::Google::Cloud::Kms::V1::ProtectionLevel::EXTERNAL EXTERNAL}
        # protection level and
        # {::Google::Cloud::Kms::V1::ProtectionLevel::EXTERNAL_VPC EXTERNAL_VPC} protection
        # levels.
        # @!attribute [rw] external_key_uri
        #   @return [::String]
        #     The URI for an external resource that this
        #     {::Google::Cloud::Kms::V1::CryptoKeyVersion CryptoKeyVersion} represents.
        # @!attribute [rw] ekm_connection_key_path
        #   @return [::String]
        #     The path to the external key material on the EKM when using
        #     [EkmConnection][google.cloud.kms.v1.EkmConnection] e.g., "v0/my/key". Set
        #     this field instead of external_key_uri when using an
        #     [EkmConnection][google.cloud.kms.v1.EkmConnection].
        class ExternalProtectionLevelOptions
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A
        # {::Google::Cloud::Kms::V1::KeyAccessJustificationsPolicy KeyAccessJustificationsPolicy}
        # specifies zero or more allowed
        # {::Google::Cloud::Kms::V1::AccessReason AccessReason} values for encrypt, decrypt,
        # and sign operations on a {::Google::Cloud::Kms::V1::CryptoKey CryptoKey}.
        # @!attribute [rw] allowed_access_reasons
        #   @return [::Array<::Google::Cloud::Kms::V1::AccessReason>]
        #     The list of allowed reasons for access to a
        #     {::Google::Cloud::Kms::V1::CryptoKey CryptoKey}. Zero allowed access reasons
        #     means all encrypt, decrypt, and sign operations for the
        #     {::Google::Cloud::Kms::V1::CryptoKey CryptoKey} associated with this policy will
        #     fail.
        class KeyAccessJustificationsPolicy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # {::Google::Cloud::Kms::V1::ProtectionLevel ProtectionLevel} specifies how
        # cryptographic operations are performed. For more information, see [Protection
        # levels] (https://cloud.google.com/kms/docs/algorithms#protection_levels).
        module ProtectionLevel
          # Not specified.
          PROTECTION_LEVEL_UNSPECIFIED = 0

          # Crypto operations are performed in software.
          SOFTWARE = 1

          # Crypto operations are performed in a Hardware Security Module.
          HSM = 2

          # Crypto operations are performed by an external key manager.
          EXTERNAL = 3

          # Crypto operations are performed in an EKM-over-VPC backend.
          EXTERNAL_VPC = 4
        end

        # Describes the reason for a data access. Please refer to
        # https://cloud.google.com/assured-workloads/key-access-justifications/docs/justification-codes
        # for the detailed semantic meaning of justification reason codes.
        module AccessReason
          # Unspecified access reason.
          REASON_UNSPECIFIED = 0

          # Customer-initiated support.
          CUSTOMER_INITIATED_SUPPORT = 1

          # Google-initiated access for system management and troubleshooting.
          GOOGLE_INITIATED_SERVICE = 2

          # Google-initiated access in response to a legal request or legal process.
          THIRD_PARTY_DATA_REQUEST = 3

          # Google-initiated access for security, fraud, abuse, or compliance purposes.
          GOOGLE_INITIATED_REVIEW = 4

          # Customer uses their account to perform any access to their own data which
          # their IAM policy authorizes.
          CUSTOMER_INITIATED_ACCESS = 5

          # Google systems access customer data to help optimize the structure of the
          # data or quality for future uses by the customer.
          GOOGLE_INITIATED_SYSTEM_OPERATION = 6

          # No reason is expected for this key request.
          REASON_NOT_EXPECTED = 7

          # Deprecated: This code is no longer generated by Google Cloud. The
          # GOOGLE_RESPONSE_TO_PRODUCTION_ALERT justification codes available in both
          # Key Access Justifications and Access Transparency logs provide
          # customer-visible signals of emergency access in more precise contexts.
          #
          # Customer uses their account to perform any access to their own data which
          # their IAM policy authorizes, and one of the following is true:
          #
          # * A Google administrator has reset the root-access account associated with
          #   the user's organization within the past 7 days.
          # * A Google-initiated emergency access operation has interacted with a
          #   resource in the same project or folder as the currently accessed resource
          #   within the past 7 days.
          MODIFIED_CUSTOMER_INITIATED_ACCESS = 8

          # Deprecated: This code is no longer generated by Google Cloud. The
          # GOOGLE_RESPONSE_TO_PRODUCTION_ALERT justification codes available in both
          # Key Access Justifications and Access Transparency logs provide
          # customer-visible signals of emergency access in more precise contexts.
          #
          # Google systems access customer data to help optimize the structure of the
          # data or quality for future uses by the customer, and one of the following
          # is true:
          #
          # * A Google administrator has reset the root-access account associated with
          #   the user's organization within the past 7 days.
          # * A Google-initiated emergency access operation has interacted with a
          #   resource in the same project or folder as the currently accessed resource
          #   within the past 7 days.
          MODIFIED_GOOGLE_INITIATED_SYSTEM_OPERATION = 9

          # Google-initiated access to maintain system reliability.
          GOOGLE_RESPONSE_TO_PRODUCTION_ALERT = 10

          # One of the following operations is being executed while simultaneously
          # encountering an internal technical issue which prevented a more precise
          # justification code from being generated:
          #
          # * Your account has been used to perform any access to your own data which
          #   your IAM policy authorizes.
          # * An automated Google system operates on encrypted customer data which your
          #   IAM policy authorizes.
          # * Customer-initiated Google support access.
          # * Google-initiated support access to protect system reliability.
          CUSTOMER_AUTHORIZED_WORKFLOW_SERVICING = 11
        end
      end
    end
  end
end
