# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Kms
      module Inventory
        module V1
          # Request message for
          # {::Google::Cloud::Kms::Inventory::V1::KeyTrackingService::Client#get_protected_resources_summary KeyTrackingService.GetProtectedResourcesSummary}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name of the
          #     {::Google::Cloud::Kms::V1::CryptoKey CryptoKey}.
          class GetProtectedResourcesSummaryRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Aggregate information about the resources protected by a Cloud KMS key in the
          # same Cloud organization as the key.
          # @!attribute [rw] name
          #   @return [::String]
          #     The full name of the ProtectedResourcesSummary resource.
          #     Example:
          #     projects/test-project/locations/us/keyRings/test-keyring/cryptoKeys/test-key/protectedResourcesSummary
          # @!attribute [rw] resource_count
          #   @return [::Integer]
          #     The total number of protected resources in the same Cloud organization as
          #     the key.
          # @!attribute [rw] project_count
          #   @return [::Integer]
          #     The number of distinct Cloud projects in the same Cloud organization as the
          #     key that have resources protected by the key.
          # @!attribute [rw] resource_types
          #   @return [::Google::Protobuf::Map{::String => ::Integer}]
          #     The number of resources protected by the key grouped by resource type.
          # @!attribute [rw] cloud_products
          #   @return [::Google::Protobuf::Map{::String => ::Integer}]
          #     The number of resources protected by the key grouped by Cloud product.
          # @!attribute [rw] locations
          #   @return [::Google::Protobuf::Map{::String => ::Integer}]
          #     The number of resources protected by the key grouped by region.
          class ProtectedResourcesSummary
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::Integer]
            class ResourceTypesEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::Integer]
            class CloudProductsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::Integer]
            class LocationsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Request message for
          # {::Google::Cloud::Kms::Inventory::V1::KeyTrackingService::Client#search_protected_resources KeyTrackingService.SearchProtectedResources}.
          # @!attribute [rw] scope
          #   @return [::String]
          #     Required. Resource name of the organization.
          #     Example: organizations/123
          # @!attribute [rw] crypto_key
          #   @return [::String]
          #     Required. The resource name of the
          #     {::Google::Cloud::Kms::V1::CryptoKey CryptoKey}.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     The maximum number of resources to return. The service may return fewer
          #     than this value.
          #     If unspecified, at most 500 resources will be returned.
          #     The maximum value is 500; values above 500 will be coerced to 500.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     A page token, received from a previous
          #     {::Google::Cloud::Kms::Inventory::V1::KeyTrackingService::Client#search_protected_resources KeyTrackingService.SearchProtectedResources}
          #     call. Provide this to retrieve the subsequent page.
          #
          #     When paginating, all other parameters provided to
          #     {::Google::Cloud::Kms::Inventory::V1::KeyTrackingService::Client#search_protected_resources KeyTrackingService.SearchProtectedResources}
          #     must match the call that provided the page token.
          # @!attribute [rw] resource_types
          #   @return [::Array<::String>]
          #     Optional. A list of resource types that this request searches for. If
          #     empty, it will search all the [trackable resource
          #     types](https://cloud.google.com/kms/docs/view-key-usage#tracked-resource-types).
          #
          #     Regular expressions are also supported. For example:
          #
          #     * `compute.googleapis.com.*` snapshots resources whose type starts
          #     with `compute.googleapis.com`.
          #     * `.*Image` snapshots resources whose type ends with `Image`.
          #     * `.*Image.*` snapshots resources whose type contains `Image`.
          #
          #     See [RE2](https://github.com/google/re2/wiki/Syntax) for all supported
          #     regular expression syntax. If the regular expression does not match any
          #     supported resource type, an INVALID_ARGUMENT error will be returned.
          class SearchProtectedResourcesRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for
          # {::Google::Cloud::Kms::Inventory::V1::KeyTrackingService::Client#search_protected_resources KeyTrackingService.SearchProtectedResources}.
          # @!attribute [rw] protected_resources
          #   @return [::Array<::Google::Cloud::Kms::Inventory::V1::ProtectedResource>]
          #     Protected resources for this page.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     A token that can be sent as `page_token` to retrieve the next page.
          #     If this field is omitted, there are no subsequent pages.
          class SearchProtectedResourcesResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Metadata about a resource protected by a Cloud KMS key.
          # @!attribute [rw] name
          #   @return [::String]
          #     The full resource name of the resource.
          #     Example:
          #     `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`.
          # @!attribute [rw] project
          #   @return [::String]
          #     Format: `projects/{PROJECT_NUMBER}`.
          # @!attribute [rw] project_id
          #   @return [::String]
          #     The ID of the project that owns the resource.
          # @!attribute [rw] cloud_product
          #   @return [::String]
          #     The Cloud product that owns the resource.
          #     Example: `compute`
          # @!attribute [rw] resource_type
          #   @return [::String]
          #     Example: `compute.googleapis.com/Disk`
          # @!attribute [rw] location
          #   @return [::String]
          #     Location can be `global`, regional like `us-east1`, or zonal like
          #     `us-west1-b`.
          # @!attribute [rw] labels
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     A key-value pair of the resource's labels (v1) to their values.
          # @!attribute [rw] crypto_key_version
          #   @return [::String]
          #     The name of the Cloud KMS
          #     [CryptoKeyVersion](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys.cryptoKeyVersions?hl=en)
          #     used to protect this resource via CMEK. This field is empty if the
          #     Google Cloud product owning the resource does not provide key version data
          #     to Asset Inventory. If there are multiple key versions protecting the
          #     resource, then this is same value as the first element of
          #     crypto_key_versions.
          # @!attribute [rw] crypto_key_versions
          #   @return [::Array<::String>]
          #     The names of the Cloud KMS
          #     [CryptoKeyVersion](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys.cryptoKeyVersions?hl=en)
          #     used to protect this resource via CMEK. This field is empty if the
          #     Google Cloud product owning the resource does not provide key versions data
          #     to Asset Inventory. The first element of this field is stored in
          #     crypto_key_version.
          # @!attribute [r] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time at which this resource was created. The granularity
          #     is in seconds. Timestamp.nanos will always be 0.
          class ProtectedResource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class LabelsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end
        end
      end
    end
  end
end
