# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Kms
      module Inventory
        module V1
          module KeyTrackingService
            # Path helper methods for the KeyTrackingService API.
            module Paths
              ##
              # Create a fully-qualified Organization resource string.
              #
              # The resource will be in the following format:
              #
              # `organizations/{organization}`
              #
              # @param organization [String]
              #
              # @return [::String]
              def organization_path organization:
                "organizations/#{organization}"
              end

              ##
              # Create a fully-qualified ProtectedResourcesSummary resource string.
              #
              # @overload protected_resources_summary_path(project:, location:, key_ring:, crypto_key:)
              #   The resource will be in the following format:
              #
              #   `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/protectedResourcesSummary`
              #
              #   @param project [String]
              #   @param location [String]
              #   @param key_ring [String]
              #   @param crypto_key [String]
              #
              # @overload protected_resources_summary_path(project:, location:, key_ring:, crypto_key:, crypto_key_version:)
              #   The resource will be in the following format:
              #
              #   `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{crypto_key_version}/protectedResourcesSummary`
              #
              #   @param project [String]
              #   @param location [String]
              #   @param key_ring [String]
              #   @param crypto_key [String]
              #   @param crypto_key_version [String]
              #
              # @return [::String]
              def protected_resources_summary_path **args
                resources = {
                  "crypto_key:key_ring:location:project" => (proc do |project:, location:, key_ring:, crypto_key:|
                    raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                    raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                    raise ::ArgumentError, "key_ring cannot contain /" if key_ring.to_s.include? "/"

                    "projects/#{project}/locations/#{location}/keyRings/#{key_ring}/cryptoKeys/#{crypto_key}/protectedResourcesSummary"
                  end),
                  "crypto_key:crypto_key_version:key_ring:location:project" => (proc do |project:, location:, key_ring:, crypto_key:, crypto_key_version:|
                    raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                    raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                    raise ::ArgumentError, "key_ring cannot contain /" if key_ring.to_s.include? "/"
                    raise ::ArgumentError, "crypto_key cannot contain /" if crypto_key.to_s.include? "/"

                    "projects/#{project}/locations/#{location}/keyRings/#{key_ring}/cryptoKeys/#{crypto_key}/cryptoKeyVersions/#{crypto_key_version}/protectedResourcesSummary"
                  end)
                }

                resource = resources[args.keys.sort.join(":")]
                raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
                resource.call(**args)
              end

              extend self
            end
          end
        end
      end
    end
  end
end
