# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/iap/v1/service_pb"
require "google/cloud/iap/v1/identity_aware_proxy_o_auth_service"

class ::Google::Cloud::Iap::V1::IdentityAwareProxyOAuthService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_brands
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Iap::V1::ListBrandsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"

    list_brands_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_brands, name
      assert_kind_of ::Google::Cloud::Iap::V1::ListBrandsRequest, request
      assert_equal "hello world", request["parent"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_brands_client_stub do
      # Create client
      client = ::Google::Cloud::Iap::V1::IdentityAwareProxyOAuthService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_brands({ parent: parent }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_brands parent: parent do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_brands ::Google::Cloud::Iap::V1::ListBrandsRequest.new(parent: parent) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_brands({ parent: parent }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_brands(::Google::Cloud::Iap::V1::ListBrandsRequest.new(parent: parent), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_brands_client_stub.call_rpc_count
    end
  end

  def test_create_brand
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Iap::V1::Brand.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    brand = {}

    create_brand_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_brand, name
      assert_kind_of ::Google::Cloud::Iap::V1::CreateBrandRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Iap::V1::Brand), request["brand"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_brand_client_stub do
      # Create client
      client = ::Google::Cloud::Iap::V1::IdentityAwareProxyOAuthService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_brand({ parent: parent, brand: brand }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_brand parent: parent, brand: brand do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_brand ::Google::Cloud::Iap::V1::CreateBrandRequest.new(parent: parent, brand: brand) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_brand({ parent: parent, brand: brand }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_brand(::Google::Cloud::Iap::V1::CreateBrandRequest.new(parent: parent, brand: brand), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_brand_client_stub.call_rpc_count
    end
  end

  def test_get_brand
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Iap::V1::Brand.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_brand_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_brand, name
      assert_kind_of ::Google::Cloud::Iap::V1::GetBrandRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_brand_client_stub do
      # Create client
      client = ::Google::Cloud::Iap::V1::IdentityAwareProxyOAuthService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_brand({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_brand name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_brand ::Google::Cloud::Iap::V1::GetBrandRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_brand({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_brand(::Google::Cloud::Iap::V1::GetBrandRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_brand_client_stub.call_rpc_count
    end
  end

  def test_create_identity_aware_proxy_client
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Iap::V1::IdentityAwareProxyClient.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    identity_aware_proxy_client = {}

    create_identity_aware_proxy_client_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_identity_aware_proxy_client, name
      assert_kind_of ::Google::Cloud::Iap::V1::CreateIdentityAwareProxyClientRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Iap::V1::IdentityAwareProxyClient), request["identity_aware_proxy_client"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_identity_aware_proxy_client_client_stub do
      # Create client
      client = ::Google::Cloud::Iap::V1::IdentityAwareProxyOAuthService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_identity_aware_proxy_client({ parent: parent, identity_aware_proxy_client: identity_aware_proxy_client }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_identity_aware_proxy_client parent: parent, identity_aware_proxy_client: identity_aware_proxy_client do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_identity_aware_proxy_client ::Google::Cloud::Iap::V1::CreateIdentityAwareProxyClientRequest.new(parent: parent, identity_aware_proxy_client: identity_aware_proxy_client) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_identity_aware_proxy_client({ parent: parent, identity_aware_proxy_client: identity_aware_proxy_client }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_identity_aware_proxy_client(::Google::Cloud::Iap::V1::CreateIdentityAwareProxyClientRequest.new(parent: parent, identity_aware_proxy_client: identity_aware_proxy_client), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_identity_aware_proxy_client_client_stub.call_rpc_count
    end
  end

  def test_list_identity_aware_proxy_clients
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Iap::V1::ListIdentityAwareProxyClientsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_identity_aware_proxy_clients_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_identity_aware_proxy_clients, name
      assert_kind_of ::Google::Cloud::Iap::V1::ListIdentityAwareProxyClientsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_identity_aware_proxy_clients_client_stub do
      # Create client
      client = ::Google::Cloud::Iap::V1::IdentityAwareProxyOAuthService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_identity_aware_proxy_clients({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_identity_aware_proxy_clients parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_identity_aware_proxy_clients ::Google::Cloud::Iap::V1::ListIdentityAwareProxyClientsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_identity_aware_proxy_clients({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_identity_aware_proxy_clients(::Google::Cloud::Iap::V1::ListIdentityAwareProxyClientsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_identity_aware_proxy_clients_client_stub.call_rpc_count
    end
  end

  def test_get_identity_aware_proxy_client
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Iap::V1::IdentityAwareProxyClient.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_identity_aware_proxy_client_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_identity_aware_proxy_client, name
      assert_kind_of ::Google::Cloud::Iap::V1::GetIdentityAwareProxyClientRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_identity_aware_proxy_client_client_stub do
      # Create client
      client = ::Google::Cloud::Iap::V1::IdentityAwareProxyOAuthService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_identity_aware_proxy_client({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_identity_aware_proxy_client name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_identity_aware_proxy_client ::Google::Cloud::Iap::V1::GetIdentityAwareProxyClientRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_identity_aware_proxy_client({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_identity_aware_proxy_client(::Google::Cloud::Iap::V1::GetIdentityAwareProxyClientRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_identity_aware_proxy_client_client_stub.call_rpc_count
    end
  end

  def test_reset_identity_aware_proxy_client_secret
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Iap::V1::IdentityAwareProxyClient.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    reset_identity_aware_proxy_client_secret_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :reset_identity_aware_proxy_client_secret, name
      assert_kind_of ::Google::Cloud::Iap::V1::ResetIdentityAwareProxyClientSecretRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, reset_identity_aware_proxy_client_secret_client_stub do
      # Create client
      client = ::Google::Cloud::Iap::V1::IdentityAwareProxyOAuthService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.reset_identity_aware_proxy_client_secret({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.reset_identity_aware_proxy_client_secret name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.reset_identity_aware_proxy_client_secret ::Google::Cloud::Iap::V1::ResetIdentityAwareProxyClientSecretRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.reset_identity_aware_proxy_client_secret({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.reset_identity_aware_proxy_client_secret(::Google::Cloud::Iap::V1::ResetIdentityAwareProxyClientSecretRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, reset_identity_aware_proxy_client_secret_client_stub.call_rpc_count
    end
  end

  def test_delete_identity_aware_proxy_client
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_identity_aware_proxy_client_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_identity_aware_proxy_client, name
      assert_kind_of ::Google::Cloud::Iap::V1::DeleteIdentityAwareProxyClientRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_identity_aware_proxy_client_client_stub do
      # Create client
      client = ::Google::Cloud::Iap::V1::IdentityAwareProxyOAuthService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_identity_aware_proxy_client({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_identity_aware_proxy_client name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_identity_aware_proxy_client ::Google::Cloud::Iap::V1::DeleteIdentityAwareProxyClientRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_identity_aware_proxy_client({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_identity_aware_proxy_client(::Google::Cloud::Iap::V1::DeleteIdentityAwareProxyClientRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_identity_aware_proxy_client_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Iap::V1::IdentityAwareProxyOAuthService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Iap::V1::IdentityAwareProxyOAuthService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Iap::V1::IdentityAwareProxyOAuthService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Iap::V1::IdentityAwareProxyOAuthService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
