# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Iap
      module V1
        # The request to ListTunnelDestGroups.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Google Cloud Project ID and location.
        #     In the following format:
        #     `projects/{project_number/id}/iap_tunnel/locations/{location}`.
        #     A `-` can be used for the location to group across all locations.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of groups to return. The service might return fewer than
        #     this value.
        #     If unspecified, at most 100 groups are returned.
        #     The maximum value is 1000; values above 1000 are coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListTunnelDestGroups`
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     `ListTunnelDestGroups` must match the call that provided the page
        #     token.
        class ListTunnelDestGroupsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response from ListTunnelDestGroups.
        # @!attribute [rw] tunnel_dest_groups
        #   @return [::Array<::Google::Cloud::Iap::V1::TunnelDestGroup>]
        #     TunnelDestGroup existing in the project.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that you can send as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListTunnelDestGroupsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to CreateTunnelDestGroup.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Google Cloud Project ID and location.
        #     In the following format:
        #     `projects/{project_number/id}/iap_tunnel/locations/{location}`.
        # @!attribute [rw] tunnel_dest_group
        #   @return [::Google::Cloud::Iap::V1::TunnelDestGroup]
        #     Required. The TunnelDestGroup to create.
        # @!attribute [rw] tunnel_dest_group_id
        #   @return [::String]
        #     Required. The ID to use for the TunnelDestGroup, which becomes the final
        #     component of the resource name.
        #
        #     This value must be 4-63 characters, and valid characters
        #     are `[a-z]-`.
        class CreateTunnelDestGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to GetTunnelDestGroup.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the TunnelDestGroup to be fetched.
        #     In the following format:
        #     `projects/{project_number/id}/iap_tunnel/locations/{location}/destGroups/{dest_group}`.
        class GetTunnelDestGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to DeleteTunnelDestGroup.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the TunnelDestGroup to delete.
        #     In the following format:
        #     `projects/{project_number/id}/iap_tunnel/locations/{location}/destGroups/{dest_group}`.
        class DeleteTunnelDestGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to UpdateTunnelDestGroup.
        # @!attribute [rw] tunnel_dest_group
        #   @return [::Google::Cloud::Iap::V1::TunnelDestGroup]
        #     Required. The new values for the TunnelDestGroup.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     A field mask that specifies which IAP settings to update.
        #     If omitted, then all of the settings are updated. See
        #     https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
        class UpdateTunnelDestGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A TunnelDestGroup.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Identifier for the TunnelDestGroup. Must be unique within the
        #     project and contain only lower case letters (a-z) and dashes (-).
        # @!attribute [rw] cidrs
        #   @return [::Array<::String>]
        #     Optional. Unordered list. List of CIDRs that this group applies to.
        # @!attribute [rw] fqdns
        #   @return [::Array<::String>]
        #     Optional. Unordered list. List of FQDNs that this group applies to.
        class TunnelDestGroup
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request sent to GetIapSettings.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name for which to retrieve the settings.
        #     Authorization: Requires the `getSettings` permission for the associated
        #     resource.
        class GetIapSettingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request sent to UpdateIapSettings.
        # @!attribute [rw] iap_settings
        #   @return [::Google::Cloud::Iap::V1::IapSettings]
        #     Required. The new values for the IAP settings to be updated.
        #     Authorization: Requires the `updateSettings` permission for the associated
        #     resource.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The field mask specifying which IAP settings should be updated.
        #     If omitted, then all of the settings are updated. See
        #     https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask.
        #
        #     Note: All IAP reauth settings must always be set together, using the
        #     field mask: `iapSettings.accessSettings.reauthSettings`.
        class UpdateIapSettingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The IAP configurable settings.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the IAP protected resource.
        # @!attribute [rw] access_settings
        #   @return [::Google::Cloud::Iap::V1::AccessSettings]
        #     Optional. Top level wrapper for all access related setting in IAP
        # @!attribute [rw] application_settings
        #   @return [::Google::Cloud::Iap::V1::ApplicationSettings]
        #     Optional. Top level wrapper for all application related settings in IAP
        class IapSettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Access related settings for IAP protected apps.
        # @!attribute [rw] gcip_settings
        #   @return [::Google::Cloud::Iap::V1::GcipSettings]
        #     Optional. GCIP claims and endpoint configurations for 3p identity
        #     providers.
        # @!attribute [rw] cors_settings
        #   @return [::Google::Cloud::Iap::V1::CorsSettings]
        #     Optional. Configuration to allow cross-origin requests via IAP.
        # @!attribute [rw] oauth_settings
        #   @return [::Google::Cloud::Iap::V1::OAuthSettings]
        #     Optional. Settings to configure IAP's OAuth behavior.
        # @!attribute [rw] reauth_settings
        #   @return [::Google::Cloud::Iap::V1::ReauthSettings]
        #     Optional. Settings to configure reauthentication policies in IAP.
        # @!attribute [rw] allowed_domains_settings
        #   @return [::Google::Cloud::Iap::V1::AllowedDomainsSettings]
        #     Optional. Settings to configure and enable allowed domains.
        # @!attribute [rw] workforce_identity_settings
        #   @return [::Google::Cloud::Iap::V1::WorkforceIdentitySettings]
        #     Optional. Settings to configure the workforce identity federation,
        #     including workforce pools and OAuth 2.0 settings.
        # @!attribute [rw] identity_sources
        #   @return [::Array<::Google::Cloud::Iap::V1::AccessSettings::IdentitySource>]
        #     Optional. Identity sources that IAP can use to authenticate the end user.
        #     Only one identity source can be configured.
        class AccessSettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Types of identity source supported by IAP.
          module IdentitySource
            # IdentitySource Unspecified.
            # When selected, IAP relies on which identity settings are fully configured
            # to redirect the traffic to. The precedence order is
            # WorkforceIdentitySettings > GcipSettings. If none is set, default to use
            # Google identity.
            IDENTITY_SOURCE_UNSPECIFIED = 0

            # Use external identities set up on Google Cloud Workforce Identity
            # Federation.
            WORKFORCE_IDENTITY_FEDERATION = 3
          end
        end

        # Allows customers to configure tenant IDs for a Cloud Identity Platform (GCIP)
        # instance for each application.
        # @!attribute [rw] tenant_ids
        #   @return [::Array<::String>]
        #     Optional. GCIP tenant IDs that are linked to the IAP resource. `tenant_ids`
        #     could be a string beginning with a number character to indicate
        #     authenticating with GCIP tenant flow, or in the format of
        #     `_<ProjectNumber>` to indicate authenticating with GCIP agent flow. If
        #     agent flow is used, `tenant_ids` should only contain one single element,
        #     while for tenant flow, `tenant_ids` can contain multiple elements.
        # @!attribute [rw] login_page_uri
        #   @return [::Google::Protobuf::StringValue]
        #     Login page URI associated with the GCIP tenants.
        #     Typically, all resources within the same project share the same login page,
        #     though it could be overridden at the sub resource level.
        class GcipSettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Allows customers to configure HTTP request paths that'll allow HTTP
        # `OPTIONS` call to bypass authentication and authorization.
        # @!attribute [rw] allow_http_options
        #   @return [::Google::Protobuf::BoolValue]
        #     Configuration to allow HTTP `OPTIONS` calls to skip
        #     authentication and authorization. If undefined, IAP will not apply any
        #     special logic to `OPTIONS` requests.
        class CorsSettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for OAuth login&consent flow behavior as well as for OAuth
        # Credentials.
        # @!attribute [rw] login_hint
        #   @return [::Google::Protobuf::StringValue]
        #     Domain hint to send as hd=? parameter in OAuth request flow. Enables
        #     redirect to primary IDP by skipping Google's login screen.
        #     https://developers.google.com/identity/protocols/OpenIDConnect#hd-param
        #     Note: IAP does not verify that the id token's hd claim matches this value
        #     since access behavior is managed by IAM policies.
        # @!attribute [rw] programmatic_clients
        #   @return [::Array<::String>]
        #     Optional. List of client ids allowed to use IAP programmatically.
        class OAuthSettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # WorkforceIdentitySettings allows customers to configure workforce pools and
        # OAuth 2.0 settings to gate their applications using a third-party IdP with
        # access control.
        # @!attribute [rw] workforce_pools
        #   @return [::Array<::String>]
        #     The workforce pool resources. Only one workforce pool is accepted.
        # @!attribute [rw] oauth2
        #   @return [::Google::Cloud::Iap::V1::OAuth2]
        #     OAuth 2.0 settings for IAP to perform OIDC flow with workforce identity
        #     federation services.
        class WorkforceIdentitySettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The OAuth 2.0 Settings
        # @!attribute [rw] client_id
        #   @return [::String]
        #     The OAuth 2.0 client ID registered in the workforce identity federation
        #     OAuth 2.0 Server.
        # @!attribute [rw] client_secret
        #   @return [::String]
        #     Input only. The OAuth 2.0 client secret created while registering the
        #     client ID.
        # @!attribute [r] client_secret_sha256
        #   @return [::String]
        #     Output only. SHA256 hash value for the client secret. This field is
        #     returned by IAP when the settings are retrieved.
        class OAuth2
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for IAP reauthentication policies.
        # @!attribute [rw] method
        #   @return [::Google::Cloud::Iap::V1::ReauthSettings::Method]
        #     Optional. Reauth method requested.
        # @!attribute [rw] max_age
        #   @return [::Google::Protobuf::Duration]
        #     Optional. Reauth session lifetime, how long before a user has to
        #     reauthenticate again.
        # @!attribute [rw] policy_type
        #   @return [::Google::Cloud::Iap::V1::ReauthSettings::PolicyType]
        #     Optional. How IAP determines the effective policy in cases of hierarchical
        #     policies. Policies are merged from higher in the hierarchy to lower in the
        #     hierarchy.
        class ReauthSettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Types of reauthentication methods supported by IAP.
          module Method
            # Reauthentication disabled.
            METHOD_UNSPECIFIED = 0

            # Prompts the user to log in again.
            LOGIN = 1

            PASSWORD = 2

            # User must use their secure key 2nd factor device.
            SECURE_KEY = 3

            # User can use any enabled 2nd factor.
            ENROLLED_SECOND_FACTORS = 4
          end

          # Type of policy in the case of hierarchical policies.
          module PolicyType
            # Default value. This value is unused.
            POLICY_TYPE_UNSPECIFIED = 0

            # This policy acts as a minimum to other policies, lower in the hierarchy.
            # Effective policy may only be the same or stricter.
            MINIMUM = 1

            # This policy acts as a default if no other reauth policy is set.
            DEFAULT = 2
          end
        end

        # Configuration for IAP allowed domains. Lets you to restrict access to an app
        # and allow access to only the domains that you list.
        # @!attribute [rw] enable
        #   @return [::Boolean]
        #     Optional. Configuration for customers to opt in for the feature.
        # @!attribute [rw] domains
        #   @return [::Array<::String>]
        #     Optional. List of trusted domains.
        class AllowedDomainsSettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Wrapper over application specific settings for IAP.
        # @!attribute [rw] csm_settings
        #   @return [::Google::Cloud::Iap::V1::CsmSettings]
        #     Optional. Settings to configure IAP's behavior for a service mesh.
        # @!attribute [rw] access_denied_page_settings
        #   @return [::Google::Cloud::Iap::V1::AccessDeniedPageSettings]
        #     Optional. Customization for Access Denied page.
        # @!attribute [rw] cookie_domain
        #   @return [::Google::Protobuf::StringValue]
        #     The Domain value to set for cookies generated by IAP. This value is not
        #     validated by the API, but will be ignored at runtime if invalid.
        # @!attribute [rw] attribute_propagation_settings
        #   @return [::Google::Cloud::Iap::V1::AttributePropagationSettings]
        #     Optional. Settings to configure attribute propagation.
        class ApplicationSettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for RCToken generated for service mesh workloads protected by
        # IAP. RCToken are IAP generated JWTs that can be verified at the application.
        # The RCToken is primarily used for service mesh deployments, and can be scoped
        # to a single mesh by configuring the audience field accordingly.
        # @!attribute [rw] rctoken_aud
        #   @return [::Google::Protobuf::StringValue]
        #     Audience claim set in the generated RCToken. This value is not validated by
        #     IAP.
        class CsmSettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Custom content configuration for access denied page.
        # IAP allows customers to define a custom URI to use as the error page when
        # access is denied to users. If IAP prevents access to this page, the default
        # IAP error page will be displayed instead.
        # @!attribute [rw] access_denied_page_uri
        #   @return [::Google::Protobuf::StringValue]
        #     The URI to be redirected to when access is denied.
        # @!attribute [rw] generate_troubleshooting_uri
        #   @return [::Google::Protobuf::BoolValue]
        #     Whether to generate a troubleshooting URL on access denied events to this
        #     application.
        # @!attribute [rw] remediation_token_generation_enabled
        #   @return [::Google::Protobuf::BoolValue]
        #     Whether to generate remediation token on access denied events to this
        #     application.
        class AccessDeniedPageSettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for propagating attributes to applications protected
        # by IAP.
        # @!attribute [rw] expression
        #   @return [::String]
        #     Optional. Raw string CEL expression. Must return a list of attributes. A
        #     maximum of 45 attributes can be selected. Expressions can select different
        #     attribute types from `attributes`: `attributes.saml_attributes`,
        #     `attributes.iap_attributes`. The following functions are supported:
        #
        #      - filter `<list>.filter(<iter_var>, <predicate>)`: Returns a subset of
        #      `<list>` where `<predicate>` is true for every item.
        #
        #      - in `<var> in <list>`: Returns true if `<list>` contains `<var>`.
        #
        #      - selectByName `<list>.selectByName(<string>)`: Returns the attribute
        #      in
        #      `<list>` with the given `<string>` name, otherwise returns empty.
        #
        #      - emitAs `<attribute>.emitAs(<string>)`: Sets the `<attribute>` name
        #      field to the given `<string>` for propagation in selected output
        #      credentials.
        #
        #      - strict `<attribute>.strict()`: Ignores the `x-goog-iap-attr-` prefix
        #      for the provided `<attribute>` when propagating with the `HEADER` output
        #      credential, such as request headers.
        #
        #      - append `<target_list>.append(<attribute>)` OR
        #      `<target_list>.append(<list>)`: Appends the provided `<attribute>` or
        #      `<list>` to the end of `<target_list>`.
        #
        #     Example expression: `attributes.saml_attributes.filter(x, x.name in
        #     ['test']).append(attributes.iap_attributes.selectByName('exact').emitAs('custom').strict())`
        # @!attribute [rw] output_credentials
        #   @return [::Array<::Google::Cloud::Iap::V1::AttributePropagationSettings::OutputCredentials>]
        #     Optional. Which output credentials attributes selected by the CEL
        #     expression should be propagated in. All attributes will be fully duplicated
        #     in each selected output credential.
        # @!attribute [rw] enable
        #   @return [::Boolean]
        #     Optional. Whether the provided attribute propagation settings should be
        #     evaluated on user requests. If set to true, attributes returned from the
        #     expression will be propagated in the set output credentials.
        class AttributePropagationSettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Supported output credentials for attribute propagation. Each output
          # credential maps to a "field" in the response. For example, selecting JWT
          # will propagate all attributes in the IAP JWT, header in the headers, etc.
          module OutputCredentials
            # An output credential is required.
            OUTPUT_CREDENTIALS_UNSPECIFIED = 0

            # Propagate attributes in the headers with "x-goog-iap-attr-" prefix.
            HEADER = 1

            # Propagate attributes in the JWT of the form: `"additional_claims": {
            # "my_attribute": ["value1", "value2"] }`
            JWT = 2

            # Propagate attributes in the RCToken of the form: `"additional_claims": {
            # "my_attribute": ["value1", "value2"] }`
            RCTOKEN = 3
          end
        end

        # Request sent to IAP Expression Linter endpoint.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the IAP protected resource.
        # @!attribute [rw] expression
        #   @return [::String]
        #     Required. User input string expression. Should be of the form
        #     `attributes.saml_attributes.filter(attribute, attribute.name in
        #     ['\\{attribute_name}', '\\{attribute_name}'])`
        class ValidateIapAttributeExpressionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # IAP Expression Linter endpoint returns empty response body.
        class ValidateIapAttributeExpressionResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request sent to ListBrands.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. GCP Project number/id.
        #     In the following format: projects/\\{project_number/id}.
        class ListBrandsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListBrands.
        # @!attribute [rw] brands
        #   @return [::Array<::Google::Cloud::Iap::V1::Brand>]
        #     Brands existing in the project.
        class ListBrandsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request sent to CreateBrand.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. GCP Project number/id under which the brand is to be created.
        #     In the following format: projects/\\{project_number/id}.
        # @!attribute [rw] brand
        #   @return [::Google::Cloud::Iap::V1::Brand]
        #     Required. The brand to be created.
        class CreateBrandRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request sent to GetBrand.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the brand to be fetched.
        #     In the following format: projects/\\{project_number/id}/brands/\\{brand}.
        class GetBrandRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request sent to ListIdentityAwareProxyClients.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Full brand path.
        #     In the following format: projects/\\{project_number/id}/brands/\\{brand}.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of clients to return. The service may return fewer than
        #     this value.
        #     If unspecified, at most 100 clients will be returned.
        #     The maximum value is 1000; values above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListIdentityAwareProxyClients`
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     `ListIdentityAwareProxyClients` must match the call that provided the page
        #     token.
        class ListIdentityAwareProxyClientsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListIdentityAwareProxyClients.
        # @!attribute [rw] identity_aware_proxy_clients
        #   @return [::Array<::Google::Cloud::Iap::V1::IdentityAwareProxyClient>]
        #     Clients existing in the brand.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be send as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListIdentityAwareProxyClientsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request sent to CreateIdentityAwareProxyClient.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Path to create the client in.
        #     In the following format:
        #     projects/\\{project_number/id}/brands/\\{brand}.
        #     The project must belong to a G Suite account.
        # @!attribute [rw] identity_aware_proxy_client
        #   @return [::Google::Cloud::Iap::V1::IdentityAwareProxyClient]
        #     Required. Identity Aware Proxy Client to be created.
        class CreateIdentityAwareProxyClientRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request sent to GetIdentityAwareProxyClient.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the Identity Aware Proxy client to be fetched.
        #     In the following format:
        #     projects/\\{project_number/id}/brands/\\{brand}/identityAwareProxyClients/\\{client_id}.
        class GetIdentityAwareProxyClientRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request sent to ResetIdentityAwareProxyClientSecret.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the Identity Aware Proxy client to that will have its
        #     secret reset. In the following format:
        #     projects/\\{project_number/id}/brands/\\{brand}/identityAwareProxyClients/\\{client_id}.
        class ResetIdentityAwareProxyClientSecretRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request sent to DeleteIdentityAwareProxyClient.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the Identity Aware Proxy client to be deleted.
        #     In the following format:
        #     projects/\\{project_number/id}/brands/\\{brand}/identityAwareProxyClients/\\{client_id}.
        class DeleteIdentityAwareProxyClientRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # OAuth brand data.
        # NOTE: Only contains a portion of the data that describes a brand.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Identifier of the brand.
        #     NOTE: GCP project number achieves the same brand identification purpose as
        #     only one brand per project can be created.
        # @!attribute [rw] support_email
        #   @return [::String]
        #     Support email displayed on the OAuth consent screen.
        # @!attribute [rw] application_title
        #   @return [::String]
        #     Application name displayed on OAuth consent screen.
        # @!attribute [r] org_internal_only
        #   @return [::Boolean]
        #     Output only. Whether the brand is only intended for usage inside the
        #     G Suite organization only.
        class Brand
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Contains the data that describes an Identity Aware Proxy owned client.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Unique identifier of the OAuth client.
        # @!attribute [r] secret
        #   @return [::String]
        #     Output only. Client secret of the OAuth client.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Human-friendly name given to the OAuth client.
        class IdentityAwareProxyClient
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
