# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/iap/v1/service_pb"

module Google
  module Cloud
    module Iap
      module V1
        module IdentityAwareProxyOAuthService
          ##
          # Client for the IdentityAwareProxyOAuthService service.
          #
          # API to programmatically create, list and retrieve Identity Aware Proxy (IAP)
          # OAuth brands; and create, retrieve, delete and reset-secret of IAP OAuth
          # clients.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "iap.$UNIVERSE_DOMAIN$"

            # @private
            attr_reader :identity_aware_proxy_o_auth_service_stub

            ##
            # Configure the IdentityAwareProxyOAuthService Client class.
            #
            # See {::Google::Cloud::Iap::V1::IdentityAwareProxyOAuthService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all IdentityAwareProxyOAuthService clients
            #   ::Google::Cloud::Iap::V1::IdentityAwareProxyOAuthService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "Iap", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.timeout = 60.0

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the IdentityAwareProxyOAuthService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::Iap::V1::IdentityAwareProxyOAuthService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @identity_aware_proxy_o_auth_service_stub.universe_domain
            end

            ##
            # Create a new IdentityAwareProxyOAuthService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::Iap::V1::IdentityAwareProxyOAuthService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::Iap::V1::IdentityAwareProxyOAuthService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the IdentityAwareProxyOAuthService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/iap/v1/service_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @identity_aware_proxy_o_auth_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::Iap::V1::IdentityAwareProxyOAuthService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @identity_aware_proxy_o_auth_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end
            end

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @identity_aware_proxy_o_auth_service_stub.logger
            end

            # Service calls

            ##
            # Lists the existing brands for the project.
            #
            # @overload list_brands(request, options = nil)
            #   Pass arguments to `list_brands` via a request object, either of type
            #   {::Google::Cloud::Iap::V1::ListBrandsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Iap::V1::ListBrandsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_brands(parent: nil)
            #   Pass arguments to `list_brands` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. GCP Project number/id.
            #     In the following format: projects/\\{project_number/id}.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Iap::V1::ListBrandsResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Iap::V1::ListBrandsResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/iap/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Iap::V1::IdentityAwareProxyOAuthService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Iap::V1::ListBrandsRequest.new
            #
            #   # Call the list_brands method.
            #   result = client.list_brands request
            #
            #   # The returned object is of type Google::Cloud::Iap::V1::ListBrandsResponse.
            #   p result
            #
            def list_brands request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Iap::V1::ListBrandsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_brands.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Iap::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_brands.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_brands.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @identity_aware_proxy_o_auth_service_stub.call_rpc :list_brands, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Constructs a new OAuth brand for the project if one does not exist.
            # The created brand is "internal only", meaning that OAuth clients created
            # under it only accept requests from users who belong to the same Google
            # Workspace organization as the project. The brand is created in an
            # un-reviewed status. NOTE: The "internal only" status can be manually
            # changed in the Google Cloud Console. Requires that a brand does not already
            # exist for the project, and that the specified support email is owned by the
            # caller.
            #
            # @overload create_brand(request, options = nil)
            #   Pass arguments to `create_brand` via a request object, either of type
            #   {::Google::Cloud::Iap::V1::CreateBrandRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Iap::V1::CreateBrandRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_brand(parent: nil, brand: nil)
            #   Pass arguments to `create_brand` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. GCP Project number/id under which the brand is to be created.
            #     In the following format: projects/\\{project_number/id}.
            #   @param brand [::Google::Cloud::Iap::V1::Brand, ::Hash]
            #     Required. The brand to be created.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Iap::V1::Brand]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Iap::V1::Brand]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/iap/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Iap::V1::IdentityAwareProxyOAuthService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Iap::V1::CreateBrandRequest.new
            #
            #   # Call the create_brand method.
            #   result = client.create_brand request
            #
            #   # The returned object is of type Google::Cloud::Iap::V1::Brand.
            #   p result
            #
            def create_brand request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Iap::V1::CreateBrandRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_brand.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Iap::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_brand.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_brand.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @identity_aware_proxy_o_auth_service_stub.call_rpc :create_brand, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Retrieves the OAuth brand of the project.
            #
            # @overload get_brand(request, options = nil)
            #   Pass arguments to `get_brand` via a request object, either of type
            #   {::Google::Cloud::Iap::V1::GetBrandRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Iap::V1::GetBrandRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_brand(name: nil)
            #   Pass arguments to `get_brand` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the brand to be fetched.
            #     In the following format: projects/\\{project_number/id}/brands/\\{brand}.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Iap::V1::Brand]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Iap::V1::Brand]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/iap/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Iap::V1::IdentityAwareProxyOAuthService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Iap::V1::GetBrandRequest.new
            #
            #   # Call the get_brand method.
            #   result = client.get_brand request
            #
            #   # The returned object is of type Google::Cloud::Iap::V1::Brand.
            #   p result
            #
            def get_brand request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Iap::V1::GetBrandRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_brand.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Iap::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_brand.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_brand.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @identity_aware_proxy_o_auth_service_stub.call_rpc :get_brand, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates an Identity Aware Proxy (IAP) OAuth client. The client is owned
            # by IAP. Requires that the brand for the project exists and that it is
            # set for internal-only use.
            #
            # @overload create_identity_aware_proxy_client(request, options = nil)
            #   Pass arguments to `create_identity_aware_proxy_client` via a request object, either of type
            #   {::Google::Cloud::Iap::V1::CreateIdentityAwareProxyClientRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Iap::V1::CreateIdentityAwareProxyClientRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_identity_aware_proxy_client(parent: nil, identity_aware_proxy_client: nil)
            #   Pass arguments to `create_identity_aware_proxy_client` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Path to create the client in.
            #     In the following format:
            #     projects/\\{project_number/id}/brands/\\{brand}.
            #     The project must belong to a G Suite account.
            #   @param identity_aware_proxy_client [::Google::Cloud::Iap::V1::IdentityAwareProxyClient, ::Hash]
            #     Required. Identity Aware Proxy Client to be created.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Iap::V1::IdentityAwareProxyClient]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Iap::V1::IdentityAwareProxyClient]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/iap/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Iap::V1::IdentityAwareProxyOAuthService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Iap::V1::CreateIdentityAwareProxyClientRequest.new
            #
            #   # Call the create_identity_aware_proxy_client method.
            #   result = client.create_identity_aware_proxy_client request
            #
            #   # The returned object is of type Google::Cloud::Iap::V1::IdentityAwareProxyClient.
            #   p result
            #
            def create_identity_aware_proxy_client request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Iap::V1::CreateIdentityAwareProxyClientRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_identity_aware_proxy_client.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Iap::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_identity_aware_proxy_client.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_identity_aware_proxy_client.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @identity_aware_proxy_o_auth_service_stub.call_rpc :create_identity_aware_proxy_client, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists the existing clients for the brand.
            #
            # @overload list_identity_aware_proxy_clients(request, options = nil)
            #   Pass arguments to `list_identity_aware_proxy_clients` via a request object, either of type
            #   {::Google::Cloud::Iap::V1::ListIdentityAwareProxyClientsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Iap::V1::ListIdentityAwareProxyClientsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_identity_aware_proxy_clients(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_identity_aware_proxy_clients` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Full brand path.
            #     In the following format: projects/\\{project_number/id}/brands/\\{brand}.
            #   @param page_size [::Integer]
            #     The maximum number of clients to return. The service may return fewer than
            #     this value.
            #     If unspecified, at most 100 clients will be returned.
            #     The maximum value is 1000; values above 1000 will be coerced to 1000.
            #   @param page_token [::String]
            #     A page token, received from a previous `ListIdentityAwareProxyClients`
            #     call. Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     `ListIdentityAwareProxyClients` must match the call that provided the page
            #     token.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Iap::V1::IdentityAwareProxyClient>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Iap::V1::IdentityAwareProxyClient>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/iap/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Iap::V1::IdentityAwareProxyOAuthService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Iap::V1::ListIdentityAwareProxyClientsRequest.new
            #
            #   # Call the list_identity_aware_proxy_clients method.
            #   result = client.list_identity_aware_proxy_clients request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Iap::V1::IdentityAwareProxyClient.
            #     p item
            #   end
            #
            def list_identity_aware_proxy_clients request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Iap::V1::ListIdentityAwareProxyClientsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_identity_aware_proxy_clients.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Iap::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_identity_aware_proxy_clients.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_identity_aware_proxy_clients.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @identity_aware_proxy_o_auth_service_stub.call_rpc :list_identity_aware_proxy_clients, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @identity_aware_proxy_o_auth_service_stub, :list_identity_aware_proxy_clients, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Retrieves an Identity Aware Proxy (IAP) OAuth client.
            # Requires that the client is owned by IAP.
            #
            # @overload get_identity_aware_proxy_client(request, options = nil)
            #   Pass arguments to `get_identity_aware_proxy_client` via a request object, either of type
            #   {::Google::Cloud::Iap::V1::GetIdentityAwareProxyClientRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Iap::V1::GetIdentityAwareProxyClientRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_identity_aware_proxy_client(name: nil)
            #   Pass arguments to `get_identity_aware_proxy_client` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the Identity Aware Proxy client to be fetched.
            #     In the following format:
            #     projects/\\{project_number/id}/brands/\\{brand}/identityAwareProxyClients/\\{client_id}.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Iap::V1::IdentityAwareProxyClient]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Iap::V1::IdentityAwareProxyClient]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/iap/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Iap::V1::IdentityAwareProxyOAuthService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Iap::V1::GetIdentityAwareProxyClientRequest.new
            #
            #   # Call the get_identity_aware_proxy_client method.
            #   result = client.get_identity_aware_proxy_client request
            #
            #   # The returned object is of type Google::Cloud::Iap::V1::IdentityAwareProxyClient.
            #   p result
            #
            def get_identity_aware_proxy_client request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Iap::V1::GetIdentityAwareProxyClientRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_identity_aware_proxy_client.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Iap::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_identity_aware_proxy_client.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_identity_aware_proxy_client.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @identity_aware_proxy_o_auth_service_stub.call_rpc :get_identity_aware_proxy_client, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Resets an Identity Aware Proxy (IAP) OAuth client secret. Useful if the
            # secret was compromised. Requires that the client is owned by IAP.
            #
            # @overload reset_identity_aware_proxy_client_secret(request, options = nil)
            #   Pass arguments to `reset_identity_aware_proxy_client_secret` via a request object, either of type
            #   {::Google::Cloud::Iap::V1::ResetIdentityAwareProxyClientSecretRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Iap::V1::ResetIdentityAwareProxyClientSecretRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload reset_identity_aware_proxy_client_secret(name: nil)
            #   Pass arguments to `reset_identity_aware_proxy_client_secret` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the Identity Aware Proxy client to that will have its
            #     secret reset. In the following format:
            #     projects/\\{project_number/id}/brands/\\{brand}/identityAwareProxyClients/\\{client_id}.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Iap::V1::IdentityAwareProxyClient]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Iap::V1::IdentityAwareProxyClient]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/iap/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Iap::V1::IdentityAwareProxyOAuthService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Iap::V1::ResetIdentityAwareProxyClientSecretRequest.new
            #
            #   # Call the reset_identity_aware_proxy_client_secret method.
            #   result = client.reset_identity_aware_proxy_client_secret request
            #
            #   # The returned object is of type Google::Cloud::Iap::V1::IdentityAwareProxyClient.
            #   p result
            #
            def reset_identity_aware_proxy_client_secret request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Iap::V1::ResetIdentityAwareProxyClientSecretRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.reset_identity_aware_proxy_client_secret.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Iap::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.reset_identity_aware_proxy_client_secret.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.reset_identity_aware_proxy_client_secret.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @identity_aware_proxy_o_auth_service_stub.call_rpc :reset_identity_aware_proxy_client_secret, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes an Identity Aware Proxy (IAP) OAuth client. Useful for removing
            # obsolete clients, managing the number of clients in a given project, and
            # cleaning up after tests. Requires that the client is owned by IAP.
            #
            # @overload delete_identity_aware_proxy_client(request, options = nil)
            #   Pass arguments to `delete_identity_aware_proxy_client` via a request object, either of type
            #   {::Google::Cloud::Iap::V1::DeleteIdentityAwareProxyClientRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Iap::V1::DeleteIdentityAwareProxyClientRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_identity_aware_proxy_client(name: nil)
            #   Pass arguments to `delete_identity_aware_proxy_client` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the Identity Aware Proxy client to be deleted.
            #     In the following format:
            #     projects/\\{project_number/id}/brands/\\{brand}/identityAwareProxyClients/\\{client_id}.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/iap/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Iap::V1::IdentityAwareProxyOAuthService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Iap::V1::DeleteIdentityAwareProxyClientRequest.new
            #
            #   # Call the delete_identity_aware_proxy_client method.
            #   result = client.delete_identity_aware_proxy_client request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_identity_aware_proxy_client request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Iap::V1::DeleteIdentityAwareProxyClientRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_identity_aware_proxy_client.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Iap::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_identity_aware_proxy_client.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_identity_aware_proxy_client.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @identity_aware_proxy_o_auth_service_stub.call_rpc :delete_identity_aware_proxy_client, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the IdentityAwareProxyOAuthService API.
            #
            # This class represents the configuration for IdentityAwareProxyOAuthService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::Iap::V1::IdentityAwareProxyOAuthService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # list_brands to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::Iap::V1::IdentityAwareProxyOAuthService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_brands.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::Iap::V1::IdentityAwareProxyOAuthService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_brands.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::Iap::V1::IdentityAwareProxyOAuthService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "iap.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the IdentityAwareProxyOAuthService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `list_brands`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_brands
                ##
                # RPC-specific configuration for `create_brand`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_brand
                ##
                # RPC-specific configuration for `get_brand`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_brand
                ##
                # RPC-specific configuration for `create_identity_aware_proxy_client`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_identity_aware_proxy_client
                ##
                # RPC-specific configuration for `list_identity_aware_proxy_clients`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_identity_aware_proxy_clients
                ##
                # RPC-specific configuration for `get_identity_aware_proxy_client`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_identity_aware_proxy_client
                ##
                # RPC-specific configuration for `reset_identity_aware_proxy_client_secret`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :reset_identity_aware_proxy_client_secret
                ##
                # RPC-specific configuration for `delete_identity_aware_proxy_client`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_identity_aware_proxy_client

                # @private
                def initialize parent_rpcs = nil
                  list_brands_config = parent_rpcs.list_brands if parent_rpcs.respond_to? :list_brands
                  @list_brands = ::Gapic::Config::Method.new list_brands_config
                  create_brand_config = parent_rpcs.create_brand if parent_rpcs.respond_to? :create_brand
                  @create_brand = ::Gapic::Config::Method.new create_brand_config
                  get_brand_config = parent_rpcs.get_brand if parent_rpcs.respond_to? :get_brand
                  @get_brand = ::Gapic::Config::Method.new get_brand_config
                  create_identity_aware_proxy_client_config = parent_rpcs.create_identity_aware_proxy_client if parent_rpcs.respond_to? :create_identity_aware_proxy_client
                  @create_identity_aware_proxy_client = ::Gapic::Config::Method.new create_identity_aware_proxy_client_config
                  list_identity_aware_proxy_clients_config = parent_rpcs.list_identity_aware_proxy_clients if parent_rpcs.respond_to? :list_identity_aware_proxy_clients
                  @list_identity_aware_proxy_clients = ::Gapic::Config::Method.new list_identity_aware_proxy_clients_config
                  get_identity_aware_proxy_client_config = parent_rpcs.get_identity_aware_proxy_client if parent_rpcs.respond_to? :get_identity_aware_proxy_client
                  @get_identity_aware_proxy_client = ::Gapic::Config::Method.new get_identity_aware_proxy_client_config
                  reset_identity_aware_proxy_client_secret_config = parent_rpcs.reset_identity_aware_proxy_client_secret if parent_rpcs.respond_to? :reset_identity_aware_proxy_client_secret
                  @reset_identity_aware_proxy_client_secret = ::Gapic::Config::Method.new reset_identity_aware_proxy_client_secret_config
                  delete_identity_aware_proxy_client_config = parent_rpcs.delete_identity_aware_proxy_client if parent_rpcs.respond_to? :delete_identity_aware_proxy_client
                  @delete_identity_aware_proxy_client = ::Gapic::Config::Method.new delete_identity_aware_proxy_client_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
