# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/iap/v1/service_pb"
require "google/cloud/iap/v1/identity_aware_proxy_admin_service/rest/service_stub"

module Google
  module Cloud
    module Iap
      module V1
        module IdentityAwareProxyAdminService
          module Rest
            ##
            # REST client for the IdentityAwareProxyAdminService service.
            #
            # APIs for Identity-Aware Proxy Admin configurations.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "iap.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :identity_aware_proxy_admin_service_stub

              ##
              # Configure the IdentityAwareProxyAdminService Client class.
              #
              # See {::Google::Cloud::Iap::V1::IdentityAwareProxyAdminService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all IdentityAwareProxyAdminService clients
              #   ::Google::Cloud::Iap::V1::IdentityAwareProxyAdminService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "Iap", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.timeout = 60.0

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the IdentityAwareProxyAdminService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::Iap::V1::IdentityAwareProxyAdminService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @identity_aware_proxy_admin_service_stub.universe_domain
              end

              ##
              # Create a new IdentityAwareProxyAdminService REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::Iap::V1::IdentityAwareProxyAdminService::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::Iap::V1::IdentityAwareProxyAdminService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the IdentityAwareProxyAdminService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @identity_aware_proxy_admin_service_stub = ::Google::Cloud::Iap::V1::IdentityAwareProxyAdminService::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @identity_aware_proxy_admin_service_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end
              end

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @identity_aware_proxy_admin_service_stub.logger
              end

              # Service calls

              ##
              # Sets the access control policy for an Identity-Aware Proxy protected
              # resource. Replaces any existing policy.
              # More information about managing access via IAP can be found at:
              # https://cloud.google.com/iap/docs/managing-access#managing_access_via_the_api
              #
              # @overload set_iam_policy(request, options = nil)
              #   Pass arguments to `set_iam_policy` via a request object, either of type
              #   {::Google::Iam::V1::SetIamPolicyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Iam::V1::SetIamPolicyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload set_iam_policy(resource: nil, policy: nil, update_mask: nil)
              #   Pass arguments to `set_iam_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param resource [::String]
              #     REQUIRED: The resource for which the policy is being specified.
              #     See the operation documentation for the appropriate value for this field.
              #   @param policy [::Google::Iam::V1::Policy, ::Hash]
              #     REQUIRED: The complete policy to be applied to the `resource`. The size of
              #     the policy is limited to a few 10s of KB. An empty policy is a
              #     valid policy but certain Cloud Platform services (such as Projects)
              #     might reject them.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
              #     the fields in the mask will be modified. If no mask is provided, the
              #     following default mask is used:
              #
              #     `paths: "bindings, etag"`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Iam::V1::Policy]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Iam::V1::Policy]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/iap/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Iap::V1::IdentityAwareProxyAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Iam::V1::SetIamPolicyRequest.new
              #
              #   # Call the set_iam_policy method.
              #   result = client.set_iam_policy request
              #
              #   # The returned object is of type Google::Iam::V1::Policy.
              #   p result
              #
              def set_iam_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::SetIamPolicyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.set_iam_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Iap::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.set_iam_policy.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.set_iam_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @identity_aware_proxy_admin_service_stub.set_iam_policy request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the access control policy for an Identity-Aware Proxy protected
              # resource.
              # More information about managing access via IAP can be found at:
              # https://cloud.google.com/iap/docs/managing-access#managing_access_via_the_api
              #
              # @overload get_iam_policy(request, options = nil)
              #   Pass arguments to `get_iam_policy` via a request object, either of type
              #   {::Google::Iam::V1::GetIamPolicyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Iam::V1::GetIamPolicyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_iam_policy(resource: nil, options: nil)
              #   Pass arguments to `get_iam_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param resource [::String]
              #     REQUIRED: The resource for which the policy is being requested.
              #     See the operation documentation for the appropriate value for this field.
              #   @param options [::Google::Iam::V1::GetPolicyOptions, ::Hash]
              #     OPTIONAL: A `GetPolicyOptions` object for specifying options to
              #     `GetIamPolicy`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Iam::V1::Policy]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Iam::V1::Policy]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/iap/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Iap::V1::IdentityAwareProxyAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Iam::V1::GetIamPolicyRequest.new
              #
              #   # Call the get_iam_policy method.
              #   result = client.get_iam_policy request
              #
              #   # The returned object is of type Google::Iam::V1::Policy.
              #   p result
              #
              def get_iam_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::GetIamPolicyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_iam_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Iap::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_iam_policy.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_iam_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @identity_aware_proxy_admin_service_stub.get_iam_policy request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns permissions that a caller has on the Identity-Aware Proxy protected
              # resource.
              # More information about managing access via IAP can be found at:
              # https://cloud.google.com/iap/docs/managing-access#managing_access_via_the_api
              #
              # @overload test_iam_permissions(request, options = nil)
              #   Pass arguments to `test_iam_permissions` via a request object, either of type
              #   {::Google::Iam::V1::TestIamPermissionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Iam::V1::TestIamPermissionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload test_iam_permissions(resource: nil, permissions: nil)
              #   Pass arguments to `test_iam_permissions` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param resource [::String]
              #     REQUIRED: The resource for which the policy detail is being requested.
              #     See the operation documentation for the appropriate value for this field.
              #   @param permissions [::Array<::String>]
              #     The set of permissions to check for the `resource`. Permissions with
              #     wildcards (such as '*' or 'storage.*') are not allowed. For more
              #     information see
              #     [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Iam::V1::TestIamPermissionsResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Iam::V1::TestIamPermissionsResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/iap/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Iap::V1::IdentityAwareProxyAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Iam::V1::TestIamPermissionsRequest.new
              #
              #   # Call the test_iam_permissions method.
              #   result = client.test_iam_permissions request
              #
              #   # The returned object is of type Google::Iam::V1::TestIamPermissionsResponse.
              #   p result
              #
              def test_iam_permissions request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::TestIamPermissionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.test_iam_permissions.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Iap::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.test_iam_permissions.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.test_iam_permissions.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @identity_aware_proxy_admin_service_stub.test_iam_permissions request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the IAP settings on a particular IAP protected resource.
              #
              # @overload get_iap_settings(request, options = nil)
              #   Pass arguments to `get_iap_settings` via a request object, either of type
              #   {::Google::Cloud::Iap::V1::GetIapSettingsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Iap::V1::GetIapSettingsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_iap_settings(name: nil)
              #   Pass arguments to `get_iap_settings` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name for which to retrieve the settings.
              #     Authorization: Requires the `getSettings` permission for the associated
              #     resource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Iap::V1::IapSettings]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Iap::V1::IapSettings]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/iap/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Iap::V1::IdentityAwareProxyAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Iap::V1::GetIapSettingsRequest.new
              #
              #   # Call the get_iap_settings method.
              #   result = client.get_iap_settings request
              #
              #   # The returned object is of type Google::Cloud::Iap::V1::IapSettings.
              #   p result
              #
              def get_iap_settings request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Iap::V1::GetIapSettingsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_iap_settings.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Iap::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_iap_settings.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_iap_settings.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @identity_aware_proxy_admin_service_stub.get_iap_settings request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the IAP settings on a particular IAP protected resource. It
              # replaces all fields unless the `update_mask` is set.
              #
              # @overload update_iap_settings(request, options = nil)
              #   Pass arguments to `update_iap_settings` via a request object, either of type
              #   {::Google::Cloud::Iap::V1::UpdateIapSettingsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Iap::V1::UpdateIapSettingsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_iap_settings(iap_settings: nil, update_mask: nil)
              #   Pass arguments to `update_iap_settings` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param iap_settings [::Google::Cloud::Iap::V1::IapSettings, ::Hash]
              #     Required. The new values for the IAP settings to be updated.
              #     Authorization: Requires the `updateSettings` permission for the associated
              #     resource.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     The field mask specifying which IAP settings should be updated.
              #     If omitted, then all of the settings are updated. See
              #     https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask.
              #
              #     Note: All IAP reauth settings must always be set together, using the
              #     field mask: `iapSettings.accessSettings.reauthSettings`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Iap::V1::IapSettings]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Iap::V1::IapSettings]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/iap/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Iap::V1::IdentityAwareProxyAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Iap::V1::UpdateIapSettingsRequest.new
              #
              #   # Call the update_iap_settings method.
              #   result = client.update_iap_settings request
              #
              #   # The returned object is of type Google::Cloud::Iap::V1::IapSettings.
              #   p result
              #
              def update_iap_settings request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Iap::V1::UpdateIapSettingsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_iap_settings.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Iap::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_iap_settings.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_iap_settings.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @identity_aware_proxy_admin_service_stub.update_iap_settings request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Validates that a given CEL expression conforms to IAP restrictions.
              #
              # @overload validate_iap_attribute_expression(request, options = nil)
              #   Pass arguments to `validate_iap_attribute_expression` via a request object, either of type
              #   {::Google::Cloud::Iap::V1::ValidateIapAttributeExpressionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Iap::V1::ValidateIapAttributeExpressionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload validate_iap_attribute_expression(name: nil, expression: nil)
              #   Pass arguments to `validate_iap_attribute_expression` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the IAP protected resource.
              #   @param expression [::String]
              #     Required. User input string expression. Should be of the form
              #     `attributes.saml_attributes.filter(attribute, attribute.name in
              #     ['\\{attribute_name}', '\\{attribute_name}'])`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Iap::V1::ValidateIapAttributeExpressionResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Iap::V1::ValidateIapAttributeExpressionResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/iap/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Iap::V1::IdentityAwareProxyAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Iap::V1::ValidateIapAttributeExpressionRequest.new
              #
              #   # Call the validate_iap_attribute_expression method.
              #   result = client.validate_iap_attribute_expression request
              #
              #   # The returned object is of type Google::Cloud::Iap::V1::ValidateIapAttributeExpressionResponse.
              #   p result
              #
              def validate_iap_attribute_expression request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Iap::V1::ValidateIapAttributeExpressionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.validate_iap_attribute_expression.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Iap::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.validate_iap_attribute_expression.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.validate_iap_attribute_expression.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @identity_aware_proxy_admin_service_stub.validate_iap_attribute_expression request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists the existing TunnelDestGroups. To group across all locations, use a
              # `-` as the location ID. For example:
              # `/v1/projects/123/iap_tunnel/locations/-/destGroups`
              #
              # @overload list_tunnel_dest_groups(request, options = nil)
              #   Pass arguments to `list_tunnel_dest_groups` via a request object, either of type
              #   {::Google::Cloud::Iap::V1::ListTunnelDestGroupsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Iap::V1::ListTunnelDestGroupsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_tunnel_dest_groups(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_tunnel_dest_groups` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Google Cloud Project ID and location.
              #     In the following format:
              #     `projects/{project_number/id}/iap_tunnel/locations/{location}`.
              #     A `-` can be used for the location to group across all locations.
              #   @param page_size [::Integer]
              #     The maximum number of groups to return. The service might return fewer than
              #     this value.
              #     If unspecified, at most 100 groups are returned.
              #     The maximum value is 1000; values above 1000 are coerced to 1000.
              #   @param page_token [::String]
              #     A page token, received from a previous `ListTunnelDestGroups`
              #     call. Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to
              #     `ListTunnelDestGroups` must match the call that provided the page
              #     token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Iap::V1::TunnelDestGroup>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Iap::V1::TunnelDestGroup>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/iap/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Iap::V1::IdentityAwareProxyAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Iap::V1::ListTunnelDestGroupsRequest.new
              #
              #   # Call the list_tunnel_dest_groups method.
              #   result = client.list_tunnel_dest_groups request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Iap::V1::TunnelDestGroup.
              #     p item
              #   end
              #
              def list_tunnel_dest_groups request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Iap::V1::ListTunnelDestGroupsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_tunnel_dest_groups.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Iap::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_tunnel_dest_groups.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_tunnel_dest_groups.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @identity_aware_proxy_admin_service_stub.list_tunnel_dest_groups request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @identity_aware_proxy_admin_service_stub, :list_tunnel_dest_groups, "tunnel_dest_groups", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new TunnelDestGroup.
              #
              # @overload create_tunnel_dest_group(request, options = nil)
              #   Pass arguments to `create_tunnel_dest_group` via a request object, either of type
              #   {::Google::Cloud::Iap::V1::CreateTunnelDestGroupRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Iap::V1::CreateTunnelDestGroupRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_tunnel_dest_group(parent: nil, tunnel_dest_group: nil, tunnel_dest_group_id: nil)
              #   Pass arguments to `create_tunnel_dest_group` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Google Cloud Project ID and location.
              #     In the following format:
              #     `projects/{project_number/id}/iap_tunnel/locations/{location}`.
              #   @param tunnel_dest_group [::Google::Cloud::Iap::V1::TunnelDestGroup, ::Hash]
              #     Required. The TunnelDestGroup to create.
              #   @param tunnel_dest_group_id [::String]
              #     Required. The ID to use for the TunnelDestGroup, which becomes the final
              #     component of the resource name.
              #
              #     This value must be 4-63 characters, and valid characters
              #     are `[a-z]-`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Iap::V1::TunnelDestGroup]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Iap::V1::TunnelDestGroup]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/iap/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Iap::V1::IdentityAwareProxyAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Iap::V1::CreateTunnelDestGroupRequest.new
              #
              #   # Call the create_tunnel_dest_group method.
              #   result = client.create_tunnel_dest_group request
              #
              #   # The returned object is of type Google::Cloud::Iap::V1::TunnelDestGroup.
              #   p result
              #
              def create_tunnel_dest_group request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Iap::V1::CreateTunnelDestGroupRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_tunnel_dest_group.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Iap::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_tunnel_dest_group.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_tunnel_dest_group.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @identity_aware_proxy_admin_service_stub.create_tunnel_dest_group request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Retrieves an existing TunnelDestGroup.
              #
              # @overload get_tunnel_dest_group(request, options = nil)
              #   Pass arguments to `get_tunnel_dest_group` via a request object, either of type
              #   {::Google::Cloud::Iap::V1::GetTunnelDestGroupRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Iap::V1::GetTunnelDestGroupRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_tunnel_dest_group(name: nil)
              #   Pass arguments to `get_tunnel_dest_group` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the TunnelDestGroup to be fetched.
              #     In the following format:
              #     `projects/{project_number/id}/iap_tunnel/locations/{location}/destGroups/{dest_group}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Iap::V1::TunnelDestGroup]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Iap::V1::TunnelDestGroup]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/iap/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Iap::V1::IdentityAwareProxyAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Iap::V1::GetTunnelDestGroupRequest.new
              #
              #   # Call the get_tunnel_dest_group method.
              #   result = client.get_tunnel_dest_group request
              #
              #   # The returned object is of type Google::Cloud::Iap::V1::TunnelDestGroup.
              #   p result
              #
              def get_tunnel_dest_group request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Iap::V1::GetTunnelDestGroupRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_tunnel_dest_group.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Iap::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_tunnel_dest_group.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_tunnel_dest_group.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @identity_aware_proxy_admin_service_stub.get_tunnel_dest_group request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a TunnelDestGroup.
              #
              # @overload delete_tunnel_dest_group(request, options = nil)
              #   Pass arguments to `delete_tunnel_dest_group` via a request object, either of type
              #   {::Google::Cloud::Iap::V1::DeleteTunnelDestGroupRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Iap::V1::DeleteTunnelDestGroupRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_tunnel_dest_group(name: nil)
              #   Pass arguments to `delete_tunnel_dest_group` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the TunnelDestGroup to delete.
              #     In the following format:
              #     `projects/{project_number/id}/iap_tunnel/locations/{location}/destGroups/{dest_group}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/iap/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Iap::V1::IdentityAwareProxyAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Iap::V1::DeleteTunnelDestGroupRequest.new
              #
              #   # Call the delete_tunnel_dest_group method.
              #   result = client.delete_tunnel_dest_group request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_tunnel_dest_group request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Iap::V1::DeleteTunnelDestGroupRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_tunnel_dest_group.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Iap::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_tunnel_dest_group.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_tunnel_dest_group.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @identity_aware_proxy_admin_service_stub.delete_tunnel_dest_group request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a TunnelDestGroup.
              #
              # @overload update_tunnel_dest_group(request, options = nil)
              #   Pass arguments to `update_tunnel_dest_group` via a request object, either of type
              #   {::Google::Cloud::Iap::V1::UpdateTunnelDestGroupRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Iap::V1::UpdateTunnelDestGroupRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_tunnel_dest_group(tunnel_dest_group: nil, update_mask: nil)
              #   Pass arguments to `update_tunnel_dest_group` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param tunnel_dest_group [::Google::Cloud::Iap::V1::TunnelDestGroup, ::Hash]
              #     Required. The new values for the TunnelDestGroup.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     A field mask that specifies which IAP settings to update.
              #     If omitted, then all of the settings are updated. See
              #     https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Iap::V1::TunnelDestGroup]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Iap::V1::TunnelDestGroup]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/iap/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Iap::V1::IdentityAwareProxyAdminService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Iap::V1::UpdateTunnelDestGroupRequest.new
              #
              #   # Call the update_tunnel_dest_group method.
              #   result = client.update_tunnel_dest_group request
              #
              #   # The returned object is of type Google::Cloud::Iap::V1::TunnelDestGroup.
              #   p result
              #
              def update_tunnel_dest_group request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Iap::V1::UpdateTunnelDestGroupRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_tunnel_dest_group.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Iap::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_tunnel_dest_group.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_tunnel_dest_group.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @identity_aware_proxy_admin_service_stub.update_tunnel_dest_group request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the IdentityAwareProxyAdminService REST API.
              #
              # This class represents the configuration for IdentityAwareProxyAdminService REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::Iap::V1::IdentityAwareProxyAdminService::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # set_iam_policy to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::Iap::V1::IdentityAwareProxyAdminService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.set_iam_policy.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::Iap::V1::IdentityAwareProxyAdminService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.set_iam_policy.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "iap.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the IdentityAwareProxyAdminService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `set_iam_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :set_iam_policy
                  ##
                  # RPC-specific configuration for `get_iam_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_iam_policy
                  ##
                  # RPC-specific configuration for `test_iam_permissions`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :test_iam_permissions
                  ##
                  # RPC-specific configuration for `get_iap_settings`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_iap_settings
                  ##
                  # RPC-specific configuration for `update_iap_settings`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_iap_settings
                  ##
                  # RPC-specific configuration for `validate_iap_attribute_expression`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :validate_iap_attribute_expression
                  ##
                  # RPC-specific configuration for `list_tunnel_dest_groups`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_tunnel_dest_groups
                  ##
                  # RPC-specific configuration for `create_tunnel_dest_group`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_tunnel_dest_group
                  ##
                  # RPC-specific configuration for `get_tunnel_dest_group`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_tunnel_dest_group
                  ##
                  # RPC-specific configuration for `delete_tunnel_dest_group`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_tunnel_dest_group
                  ##
                  # RPC-specific configuration for `update_tunnel_dest_group`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_tunnel_dest_group

                  # @private
                  def initialize parent_rpcs = nil
                    set_iam_policy_config = parent_rpcs.set_iam_policy if parent_rpcs.respond_to? :set_iam_policy
                    @set_iam_policy = ::Gapic::Config::Method.new set_iam_policy_config
                    get_iam_policy_config = parent_rpcs.get_iam_policy if parent_rpcs.respond_to? :get_iam_policy
                    @get_iam_policy = ::Gapic::Config::Method.new get_iam_policy_config
                    test_iam_permissions_config = parent_rpcs.test_iam_permissions if parent_rpcs.respond_to? :test_iam_permissions
                    @test_iam_permissions = ::Gapic::Config::Method.new test_iam_permissions_config
                    get_iap_settings_config = parent_rpcs.get_iap_settings if parent_rpcs.respond_to? :get_iap_settings
                    @get_iap_settings = ::Gapic::Config::Method.new get_iap_settings_config
                    update_iap_settings_config = parent_rpcs.update_iap_settings if parent_rpcs.respond_to? :update_iap_settings
                    @update_iap_settings = ::Gapic::Config::Method.new update_iap_settings_config
                    validate_iap_attribute_expression_config = parent_rpcs.validate_iap_attribute_expression if parent_rpcs.respond_to? :validate_iap_attribute_expression
                    @validate_iap_attribute_expression = ::Gapic::Config::Method.new validate_iap_attribute_expression_config
                    list_tunnel_dest_groups_config = parent_rpcs.list_tunnel_dest_groups if parent_rpcs.respond_to? :list_tunnel_dest_groups
                    @list_tunnel_dest_groups = ::Gapic::Config::Method.new list_tunnel_dest_groups_config
                    create_tunnel_dest_group_config = parent_rpcs.create_tunnel_dest_group if parent_rpcs.respond_to? :create_tunnel_dest_group
                    @create_tunnel_dest_group = ::Gapic::Config::Method.new create_tunnel_dest_group_config
                    get_tunnel_dest_group_config = parent_rpcs.get_tunnel_dest_group if parent_rpcs.respond_to? :get_tunnel_dest_group
                    @get_tunnel_dest_group = ::Gapic::Config::Method.new get_tunnel_dest_group_config
                    delete_tunnel_dest_group_config = parent_rpcs.delete_tunnel_dest_group if parent_rpcs.respond_to? :delete_tunnel_dest_group
                    @delete_tunnel_dest_group = ::Gapic::Config::Method.new delete_tunnel_dest_group_config
                    update_tunnel_dest_group_config = parent_rpcs.update_tunnel_dest_group if parent_rpcs.respond_to? :update_tunnel_dest_group
                    @update_tunnel_dest_group = ::Gapic::Config::Method.new update_tunnel_dest_group_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
