# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Iap
      module V1
        module IdentityAwareProxyAdminService
          # Path helper methods for the IdentityAwareProxyAdminService API.
          module Paths
            ##
            # Create a fully-qualified TunnelDestGroup resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/iap_tunnel/locations/{location}/destGroups/{dest_group}`
            #
            # @param project [String]
            # @param location [String]
            # @param dest_group [String]
            #
            # @return [::String]
            def tunnel_dest_group_path project:, location:, dest_group:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/iap_tunnel/locations/#{location}/destGroups/#{dest_group}"
            end

            ##
            # Create a fully-qualified TunnelLocation resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/iap_tunnel/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def tunnel_location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/iap_tunnel/locations/#{location}"
            end

            extend self
          end
        end
      end
    end
  end
end
