# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/hypercompute_cluster/v1beta/hypercompute_cluster"

class ::Google::Cloud::HypercomputeCluster::V1beta::HypercomputeCluster::ClientPathsTest < Minitest::Test
  class DummyStub
    def endpoint
      "endpoint.example.com"
    end
  
    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_bucket_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::HypercomputeCluster::V1beta::HypercomputeCluster::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.bucket_path project: "value0", bucket: "value1"
      assert_equal "projects/value0/buckets/value1", path
    end
  end

  def test_cluster_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::HypercomputeCluster::V1beta::HypercomputeCluster::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.cluster_path project: "value0", location: "value1", cluster: "value2"
      assert_equal "projects/value0/locations/value1/clusters/value2", path
    end
  end

  def test_compute_instance_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::HypercomputeCluster::V1beta::HypercomputeCluster::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.compute_instance_path project: "value0", zone: "value1", instance: "value2"
      assert_equal "projects/value0/zones/value1/instances/value2", path
    end
  end

  def test_disk_type_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::HypercomputeCluster::V1beta::HypercomputeCluster::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.disk_type_path project: "value0", zone: "value1", disk_type: "value2"
      assert_equal "projects/value0/zones/value1/diskTypes/value2", path
    end
  end

  def test_file_instance_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::HypercomputeCluster::V1beta::HypercomputeCluster::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.file_instance_path project: "value0", location: "value1", instance: "value2"
      assert_equal "projects/value0/locations/value1/instances/value2", path
    end
  end

  def test_location_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::HypercomputeCluster::V1beta::HypercomputeCluster::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.location_path project: "value0", location: "value1"
      assert_equal "projects/value0/locations/value1", path
    end
  end

  def test_lustre_instance_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::HypercomputeCluster::V1beta::HypercomputeCluster::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.lustre_instance_path project: "value0", location: "value1", instance: "value2"
      assert_equal "projects/value0/locations/value1/instances/value2", path
    end
  end

  def test_network_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::HypercomputeCluster::V1beta::HypercomputeCluster::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.network_path project: "value0", network: "value1"
      assert_equal "projects/value0/global/networks/value1", path
    end
  end

  def test_reservation_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::HypercomputeCluster::V1beta::HypercomputeCluster::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.reservation_path project: "value0", zone: "value1", reservation: "value2"
      assert_equal "projects/value0/zones/value1/reservations/value2", path
    end
  end

  def test_subnetwork_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::HypercomputeCluster::V1beta::HypercomputeCluster::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.subnetwork_path project: "value0", region: "value1", subnetwork: "value2"
      assert_equal "projects/value0/regions/value1/subnetworks/value2", path
    end
  end
end
