# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module HypercomputeCluster
      module V1beta
        # A collection of virtual machines and connected resources forming a
        # high-performance computing cluster capable of running large-scale, tightly
        # coupled workloads. A cluster combines a set a compute resources that perform
        # computations, storage resources that contain inputs and store outputs, an
        # orchestrator that is responsible for assigning jobs to compute resources, and
        # network resources that connect everything together.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. [Relative resource name](https://google.aip.dev/122) of the
        #     cluster, in the format
        #     `projects/{project}/locations/{location}/clusters/{cluster}`.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. User-provided description of the cluster.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional.
        #     [Labels](https://cloud.google.com/compute/docs/labeling-resources) applied
        #     to the cluster. Labels can be used to organize clusters and to filter them
        #     in queries.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time that the cluster was originally created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time that the cluster was most recently updated.
        # @!attribute [r] reconciling
        #   @return [::Boolean]
        #     Output only. Indicates whether changes to the cluster are currently in
        #     flight. If this is `true`, then the current state might not match the
        #     cluster's intended state.
        # @!attribute [rw] network_resources
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::HypercomputeCluster::V1beta::NetworkResource}]
        #     Optional. Network resources available to the cluster. Must contain at most
        #     one value. Keys specify the ID of the network resource by which it can be
        #     referenced elsewhere, and must conform to
        #     [RFC-1034](https://datatracker.ietf.org/doc/html/rfc1034) (lower-case,
        #     alphanumeric, and at most 63 characters).
        # @!attribute [rw] storage_resources
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::HypercomputeCluster::V1beta::StorageResource}]
        #     Optional. Storage resources available to the cluster. Keys specify the ID
        #     of the storage resource by which it can be referenced elsewhere, and must
        #     conform to [RFC-1034](https://datatracker.ietf.org/doc/html/rfc1034)
        #     (lower-case, alphanumeric, and at most 63 characters).
        # @!attribute [rw] compute_resources
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::HypercomputeCluster::V1beta::ComputeResource}]
        #     Optional. Compute resources available to the cluster. Keys specify the ID
        #     of the compute resource by which it can be referenced elsewhere, and must
        #     conform to [RFC-1034](https://datatracker.ietf.org/doc/html/rfc1034)
        #     (lower-case, alphanumeric, and at most 63 characters).
        # @!attribute [rw] orchestrator
        #   @return [::Google::Cloud::HypercomputeCluster::V1beta::Orchestrator]
        #     Optional. Orchestrator that is responsible for scheduling and running jobs
        #     on the cluster.
        class Cluster
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::HypercomputeCluster::V1beta::NetworkResource]
          class NetworkResourcesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::HypercomputeCluster::V1beta::StorageResource]
          class StorageResourcesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::HypercomputeCluster::V1beta::ComputeResource]
          class ComputeResourcesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Request message for
        # {::Google::Cloud::HypercomputeCluster::V1beta::HypercomputeCluster::Client#list_clusters ListClusters}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent location of the clusters to list, in the format
        #     `projects/{project}/locations/{location}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Maximum number of clusters to return. The service may return
        #     fewer than this value.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token received from a previous `ListClusters` call.
        #     Provide this to retrieve the subsequent page. When paginating, all other
        #     parameters provided to `ListClusters` must match the call that provided the
        #     page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. [Filter](https://google.aip.dev/160) to apply to the returned
        #     results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. How to order the resulting clusters. Must be one of the following
        #     strings:
        #
        #     * `name`
        #     * `name desc`
        #     * `create_time`
        #     * `create_time desc`
        #
        #     If not specified, clusters will be returned in an arbitrary order.
        class ListClustersRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::HypercomputeCluster::V1beta::HypercomputeCluster::Client#list_clusters ListClusters}.
        # @!attribute [rw] clusters
        #   @return [::Array<::Google::Cloud::HypercomputeCluster::V1beta::Cluster>]
        #     Clusters in the specified location.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as `page_token` to retrieve the next page. If this
        #     field is absent, there are no subsequent pages.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListClustersResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::HypercomputeCluster::V1beta::HypercomputeCluster::Client#get_cluster GetCluster}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the cluster to retrieve, in the format
        #     `projects/{project}/locations/{location}/clusters/{cluster}`.
        class GetClusterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::HypercomputeCluster::V1beta::HypercomputeCluster::Client#create_cluster CreateCluster}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent location in which the cluster should be created, in the
        #     format `projects/{project}/locations/{location}`.
        # @!attribute [rw] cluster_id
        #   @return [::String]
        #     Required. ID of the cluster to create. Must conform to
        #     [RFC-1034](https://datatracker.ietf.org/doc/html/rfc1034) (lower-case,
        #     alphanumeric, and at most 63 characters).
        # @!attribute [rw] cluster
        #   @return [::Google::Cloud::HypercomputeCluster::V1beta::Cluster]
        #     Required. Cluster to create.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A unique identifier for this request. A random UUID is
        #     recommended. This request is idempotent if and only if `request_id` is
        #     provided.
        class CreateClusterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::HypercomputeCluster::V1beta::HypercomputeCluster::Client#update_cluster UpdateCluster}.
        # @!attribute [rw] cluster
        #   @return [::Google::Cloud::HypercomputeCluster::V1beta::Cluster]
        #     Required. Cluster to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Mask specifying which fields in the cluster to update. All paths
        #     must be specified explicitly - wildcards are not supported. At least one
        #     path must be provided.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A unique identifier for this request. A random UUID is
        #     recommended. This request is idempotent if and only if `request_id` is
        #     provided.
        class UpdateClusterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::HypercomputeCluster::V1beta::HypercomputeCluster::Client#delete_cluster DeleteCluster}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the cluster to delete, in the format
        #     `projects/{project}/locations/{location}/clusters/{cluster}`.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A unique identifier for this request. A random UUID is
        #     recommended. This request is idempotent if and only if `request_id` is
        #     provided.
        class DeleteClusterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A resource representing a network that connects the various components of a
        # cluster together.
        # @!attribute [rw] network
        #   @return [::Google::Cloud::HypercomputeCluster::V1beta::NetworkReference]
        #     Reference to a network in Google Compute Engine.
        # @!attribute [rw] config
        #   @return [::Google::Cloud::HypercomputeCluster::V1beta::NetworkResourceConfig]
        #     Immutable. Configuration for this network resource, which describes how it
        #     should be created or imported. This field only controls how the network
        #     resource is initially created or imported. Subsequent changes to the
        #     network resource should be made via the resource's API and will not be
        #     reflected in the configuration.
        class NetworkResource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A reference to a [VPC network](https://cloud.google.com/vpc/docs/vpc) in
        # Google Compute Engine.
        # @!attribute [r] network
        #   @return [::String]
        #     Output only. Name of the network, in the format
        #     `projects/{project}/global/networks/{network}`.
        # @!attribute [r] subnetwork
        #   @return [::String]
        #     Output only. Name of the particular subnetwork being used by the cluster,
        #     in the format
        #     `projects/{project}/regions/{region}/subnetworks/{subnetwork}`.
        class NetworkReference
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Describes how a network resource should be initialized. Each network resource
        # can either be imported from an existing Google Cloud resource or initialized
        # when the cluster is created.
        # @!attribute [rw] new_network
        #   @return [::Google::Cloud::HypercomputeCluster::V1beta::NewNetworkConfig]
        #     Optional. Immutable. If set, indicates that a new network should be
        #     created.
        #
        #     Note: The following fields are mutually exclusive: `new_network`, `existing_network`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] existing_network
        #   @return [::Google::Cloud::HypercomputeCluster::V1beta::ExistingNetworkConfig]
        #     Optional. Immutable. If set, indicates that an existing network should be
        #     imported.
        #
        #     Note: The following fields are mutually exclusive: `existing_network`, `new_network`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class NetworkResourceConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # When set in a
        # {::Google::Cloud::HypercomputeCluster::V1beta::NetworkResourceConfig NetworkResourceConfig},
        # indicates that a new network should be created.
        # @!attribute [rw] network
        #   @return [::String]
        #     Required. Immutable. Name of the network to create, in the format
        #     `projects/{project}/global/networks/{network}`.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Immutable. Description of the network. Maximum of 2048
        #     characters.
        class NewNetworkConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # When set in a
        # {::Google::Cloud::HypercomputeCluster::V1beta::NetworkResourceConfig NetworkResourceConfig},
        # indicates that an existing network should be imported.
        # @!attribute [rw] network
        #   @return [::String]
        #     Required. Immutable. Name of the network to import, in the format
        #     `projects/{project}/global/networks/{network}`.
        # @!attribute [rw] subnetwork
        #   @return [::String]
        #     Required. Immutable. Particular subnetwork to use, in the format
        #     `projects/{project}/regions/{region}/subnetworks/{subnetwork}`.
        class ExistingNetworkConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A resource representing a form of persistent storage that is accessible to
        # compute resources in the cluster.
        # @!attribute [rw] filestore
        #   @return [::Google::Cloud::HypercomputeCluster::V1beta::FilestoreReference]
        #     Reference to a Filestore instance. Populated if and only if the storage
        #     resource was configured to use Filestore.
        #
        #     Note: The following fields are mutually exclusive: `filestore`, `bucket`, `lustre`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] bucket
        #   @return [::Google::Cloud::HypercomputeCluster::V1beta::BucketReference]
        #     Reference to a Google Cloud Storage bucket. Populated if and only if the
        #     storage resource was configured to use Google Cloud Storage.
        #
        #     Note: The following fields are mutually exclusive: `bucket`, `filestore`, `lustre`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] lustre
        #   @return [::Google::Cloud::HypercomputeCluster::V1beta::LustreReference]
        #     Reference to a Managed Lustre instance. Populated if and only if the
        #     storage resource was configured to use Managed Lustre.
        #
        #     Note: The following fields are mutually exclusive: `lustre`, `filestore`, `bucket`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] config
        #   @return [::Google::Cloud::HypercomputeCluster::V1beta::StorageResourceConfig]
        #     Required. Immutable. Configuration for this storage resource, which
        #     describes how it should be created or imported. This field only controls
        #     how the storage resource is initially created or imported. Subsequent
        #     changes to the storage resource should be made via the resource's API and
        #     will not be reflected in the configuration.
        class StorageResource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A reference to a [Filestore](https://cloud.google.com/filestore) instance.
        # @!attribute [r] filestore
        #   @return [::String]
        #     Output only. Name of the Filestore instance, in the format
        #     `projects/{project}/locations/{location}/instances/{instance}`
        class FilestoreReference
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A reference to a [Google Cloud Storage](https://cloud.google.com/storage)
        # bucket.
        # @!attribute [r] bucket
        #   @return [::String]
        #     Output only. Name of the bucket.
        class BucketReference
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A reference to a [Managed
        # Lustre](https://cloud.google.com/products/managed-lustre) instance.
        # @!attribute [r] lustre
        #   @return [::String]
        #     Output only. Name of the Managed Lustre instance, in the format
        #     `projects/{project}/locations/{location}/instances/{instance}`
        class LustreReference
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Describes how a storage resource should be initialized. Each storage resource
        # can either be imported from an existing Google Cloud resource or initialized
        # when the cluster is created.
        # @!attribute [rw] new_filestore
        #   @return [::Google::Cloud::HypercomputeCluster::V1beta::NewFilestoreConfig]
        #     Optional. Immutable. If set, indicates that a new Filestore instance
        #     should be created.
        #
        #     Note: The following fields are mutually exclusive: `new_filestore`, `existing_filestore`, `new_bucket`, `existing_bucket`, `new_lustre`, `existing_lustre`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] existing_filestore
        #   @return [::Google::Cloud::HypercomputeCluster::V1beta::ExistingFilestoreConfig]
        #     Optional. Immutable. If set, indicates that an existing Filestore
        #     instance should be imported.
        #
        #     Note: The following fields are mutually exclusive: `existing_filestore`, `new_filestore`, `new_bucket`, `existing_bucket`, `new_lustre`, `existing_lustre`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] new_bucket
        #   @return [::Google::Cloud::HypercomputeCluster::V1beta::NewBucketConfig]
        #     Optional. Immutable. If set, indicates that a new Cloud Storage bucket
        #     should be created.
        #
        #     Note: The following fields are mutually exclusive: `new_bucket`, `new_filestore`, `existing_filestore`, `existing_bucket`, `new_lustre`, `existing_lustre`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] existing_bucket
        #   @return [::Google::Cloud::HypercomputeCluster::V1beta::ExistingBucketConfig]
        #     Optional. Immutable. If set, indicates that an existing Cloud Storage
        #     bucket should be imported.
        #
        #     Note: The following fields are mutually exclusive: `existing_bucket`, `new_filestore`, `existing_filestore`, `new_bucket`, `new_lustre`, `existing_lustre`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] new_lustre
        #   @return [::Google::Cloud::HypercomputeCluster::V1beta::NewLustreConfig]
        #     Optional. Immutable. If set, indicates that a new Managed Lustre instance
        #     should be created.
        #
        #     Note: The following fields are mutually exclusive: `new_lustre`, `new_filestore`, `existing_filestore`, `new_bucket`, `existing_bucket`, `existing_lustre`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] existing_lustre
        #   @return [::Google::Cloud::HypercomputeCluster::V1beta::ExistingLustreConfig]
        #     Optional. Immutable. If set, indicates that an existing Managed Lustre
        #     instance should be imported.
        #
        #     Note: The following fields are mutually exclusive: `existing_lustre`, `new_filestore`, `existing_filestore`, `new_bucket`, `existing_bucket`, `new_lustre`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class StorageResourceConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # When set in a
        # {::Google::Cloud::HypercomputeCluster::V1beta::StorageResourceConfig StorageResourceConfig},
        # indicates that a new [Filestore](https://cloud.google.com/filestore) instance
        # should be created.
        # @!attribute [rw] filestore
        #   @return [::String]
        #     Required. Immutable. Name of the Filestore instance to create, in the
        #     format `projects/{project}/locations/{location}/instances/{instance}`
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Immutable. Description of the instance. Maximum of 2048
        #     characters.
        # @!attribute [rw] file_shares
        #   @return [::Array<::Google::Cloud::HypercomputeCluster::V1beta::FileShareConfig>]
        #     Required. Immutable. File system shares on the instance. Exactly one file
        #     share must be specified.
        # @!attribute [rw] tier
        #   @return [::Google::Cloud::HypercomputeCluster::V1beta::NewFilestoreConfig::Tier]
        #     Required. Immutable. Service tier to use for the instance.
        # @!attribute [rw] protocol
        #   @return [::Google::Cloud::HypercomputeCluster::V1beta::NewFilestoreConfig::Protocol]
        #     Optional. Immutable. Access protocol to use for all file shares in the
        #     instance. Defaults to NFS V3 if not set.
        class NewFilestoreConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Available [service
          # tiers](https://cloud.google.com/filestore/docs/service-tiers) for Filestore
          # instances.
          module Tier
            # Not set.
            TIER_UNSPECIFIED = 0

            # Offers expanded capacity and performance scaling capabilities suitable
            # for high-performance computing application requirements.
            ZONAL = 4

            # Offers features and availability needed for mission-critical,
            # high-performance computing workloads.
            REGIONAL = 6
          end

          # File access protocol for Filestore instances.
          module Protocol
            # Not set.
            PROTOCOL_UNSPECIFIED = 0

            # NFS 3.0.
            NFSV3 = 1

            # NFS 4.1.
            NFSV41 = 2
          end
        end

        # Message describing filestore configuration
        # @!attribute [rw] capacity_gb
        #   @return [::Integer]
        #     Required. Size of the filestore in GB. Must be between 1024 and 102400, and
        #     must meet scalability requirements described at
        #     https://cloud.google.com/filestore/docs/service-tiers.
        # @!attribute [rw] file_share
        #   @return [::String]
        #     Required. Filestore share location
        class FileShareConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # When set in a
        # {::Google::Cloud::HypercomputeCluster::V1beta::StorageResourceConfig StorageResourceConfig},
        # indicates that an existing [Filestore](https://cloud.google.com/filestore)
        # instance should be imported.
        # @!attribute [rw] filestore
        #   @return [::String]
        #     Required. Immutable. Name of the Filestore instance to import, in the
        #     format `projects/{project}/locations/{location}/instances/{instance}`
        class ExistingFilestoreConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # When set in a
        # {::Google::Cloud::HypercomputeCluster::V1beta::StorageResourceConfig StorageResourceConfig},
        # indicates that a new [Google Cloud Storage](https://cloud.google.com/storage)
        # bucket should be created.
        # @!attribute [rw] autoclass
        #   @return [::Google::Cloud::HypercomputeCluster::V1beta::GcsAutoclassConfig]
        #     Optional. Immutable. If set, indicates that the bucket should use
        #     [Autoclass](https://cloud.google.com/storage/docs/autoclass).
        #
        #     Note: The following fields are mutually exclusive: `autoclass`, `storage_class`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] storage_class
        #   @return [::Google::Cloud::HypercomputeCluster::V1beta::NewBucketConfig::StorageClass]
        #     Optional. Immutable. If set, uses the provided storage class as the
        #     bucket's default storage class.
        #
        #     Note: The following fields are mutually exclusive: `storage_class`, `autoclass`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] bucket
        #   @return [::String]
        #     Required. Immutable. Name of the Cloud Storage bucket to create.
        # @!attribute [rw] hierarchical_namespace
        #   @return [::Google::Cloud::HypercomputeCluster::V1beta::GcsHierarchicalNamespaceConfig]
        #     Optional. Immutable. If set, indicates that the bucket should use
        #     [hierarchical
        #     namespaces](https://cloud.google.com/storage/docs/hns-overview).
        class NewBucketConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # [Storage class](https://cloud.google.com/storage/docs/storage-classes) for
          # a Cloud Storage bucket.
          module StorageClass
            # Not set.
            STORAGE_CLASS_UNSPECIFIED = 0

            # Best for data that is frequently accessed.
            STANDARD = 1

            # Low-cost storage for data that is accessed less frequently.
            NEARLINE = 2

            # Very low-cost storage for infrequently accessed data.
            COLDLINE = 3

            # Lowest-cost storage for data archiving, online backup, and disaster
            # recovery.
            ARCHIVE = 4
          end
        end

        # Message describing Google Cloud Storage autoclass configuration
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     Required. Enables Auto-class feature.
        # @!attribute [rw] terminal_storage_class
        #   @return [::Google::Cloud::HypercomputeCluster::V1beta::GcsAutoclassConfig::TerminalStorageClass]
        #     Optional. Terminal storage class of the autoclass bucket
        class GcsAutoclassConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Terminal storage class types of the autoclass bucket
          module TerminalStorageClass
            # Unspecified terminal storage class
            TERMINAL_STORAGE_CLASS_UNSPECIFIED = 0
          end
        end

        # Message describing Google Cloud Storage hierarchical namespace configuration
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     Required. Enables hierarchical namespace setup for the bucket.
        class GcsHierarchicalNamespaceConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # When set in a
        # {::Google::Cloud::HypercomputeCluster::V1beta::StorageResourceConfig StorageResourceConfig},
        # indicates that an existing [Google Cloud
        # Storage](https://cloud.google.com/storage) bucket should be imported.
        # @!attribute [rw] bucket
        #   @return [::String]
        #     Required. Immutable. Name of the Cloud Storage bucket to import.
        class ExistingBucketConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # When set in a
        # {::Google::Cloud::HypercomputeCluster::V1beta::StorageResourceConfig StorageResourceConfig},
        # indicates that a new [Managed
        # Lustre](https://cloud.google.com/products/managed-lustre) instance should be
        # created.
        # @!attribute [rw] lustre
        #   @return [::String]
        #     Required. Immutable. Name of the Managed Lustre instance to create, in the
        #     format `projects/{project}/locations/{location}/instances/{instance}`
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Immutable. Description of the Managed Lustre instance. Maximum of
        #     2048 characters.
        # @!attribute [rw] filesystem
        #   @return [::String]
        #     Required. Immutable. Filesystem name for this instance. This name is used
        #     by client-side tools, including when mounting the instance. Must be 8
        #     characters or less and can only contain letters and numbers.
        # @!attribute [rw] capacity_gb
        #   @return [::Integer]
        #     Required. Immutable. Storage capacity of the instance in gibibytes (GiB).
        #     Allowed values are between 18000 and 7632000.
        class NewLustreConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # When set in a
        # {::Google::Cloud::HypercomputeCluster::V1beta::StorageResourceConfig StorageResourceConfig},
        # indicates that an existing [Managed
        # Lustre](https://cloud.google.com/products/managed-lustre) instance should be
        # imported.
        # @!attribute [rw] lustre
        #   @return [::String]
        #     Required. Immutable. Name of the Managed Lustre instance to import, in the
        #     format `projects/{project}/locations/{location}/instances/{instance}`
        class ExistingLustreConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A resource defining how virtual machines and accelerators should be
        # provisioned for the cluster.
        # @!attribute [rw] config
        #   @return [::Google::Cloud::HypercomputeCluster::V1beta::ComputeResourceConfig]
        #     Required. Immutable. Configuration for this compute resource, which
        #     describes how it should be created at runtime.
        class ComputeResource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Describes how a compute resource should be created at runtime.
        # @!attribute [rw] new_on_demand_instances
        #   @return [::Google::Cloud::HypercomputeCluster::V1beta::NewOnDemandInstancesConfig]
        #     Optional. Immutable. If set, indicates that this resource should use
        #     on-demand VMs.
        #
        #     Note: The following fields are mutually exclusive: `new_on_demand_instances`, `new_spot_instances`, `new_reserved_instances`, `new_flex_start_instances`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] new_spot_instances
        #   @return [::Google::Cloud::HypercomputeCluster::V1beta::NewSpotInstancesConfig]
        #     Optional. Immutable. If set, indicates that this resource should use spot
        #     VMs.
        #
        #     Note: The following fields are mutually exclusive: `new_spot_instances`, `new_on_demand_instances`, `new_reserved_instances`, `new_flex_start_instances`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] new_reserved_instances
        #   @return [::Google::Cloud::HypercomputeCluster::V1beta::NewReservedInstancesConfig]
        #     Optional. Immutable. If set, indicates that this resource should use
        #     reserved VMs.
        #
        #     Note: The following fields are mutually exclusive: `new_reserved_instances`, `new_on_demand_instances`, `new_spot_instances`, `new_flex_start_instances`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] new_flex_start_instances
        #   @return [::Google::Cloud::HypercomputeCluster::V1beta::NewFlexStartInstancesConfig]
        #     Optional. Immutable. If set, indicates that this resource should use
        #     flex-start VMs.
        #
        #     Note: The following fields are mutually exclusive: `new_flex_start_instances`, `new_on_demand_instances`, `new_spot_instances`, `new_reserved_instances`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class ComputeResourceConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # When set in a
        # {::Google::Cloud::HypercomputeCluster::V1beta::ComputeResourceConfig ComputeResourceConfig},
        # indicates that on-demand (i.e., using the standard provisioning model) VM
        # instances should be created.
        # @!attribute [rw] zone
        #   @return [::String]
        #     Required. Immutable. Name of the zone in which VM instances should run,
        #     e.g., `us-central1-a`. Must be in the same region as the cluster, and must
        #     match the zone of any other resources specified in the cluster.
        # @!attribute [rw] machine_type
        #   @return [::String]
        #     Required. Immutable. Name of the Compute Engine [machine
        #     type](https://cloud.google.com/compute/docs/machine-resource) to use, e.g.
        #     `n2-standard-2`.
        class NewOnDemandInstancesConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # When set in a
        # {::Google::Cloud::HypercomputeCluster::V1beta::ComputeResourceConfig ComputeResourceConfig},
        # indicates that [spot
        # VM](https://cloud.google.com/compute/docs/instances/spot) instances should be
        # created.
        # @!attribute [rw] zone
        #   @return [::String]
        #     Required. Immutable. Name of the zone in which VM instances should run,
        #     e.g., `us-central1-a`. Must be in the same region as the cluster, and must
        #     match the zone of any other resources specified in the cluster.
        # @!attribute [rw] machine_type
        #   @return [::String]
        #     Required. Immutable. Name of the Compute Engine [machine
        #     type](https://cloud.google.com/compute/docs/machine-resource) to use, e.g.
        #     `n2-standard-2`.
        class NewSpotInstancesConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # When set in a
        # {::Google::Cloud::HypercomputeCluster::V1beta::ComputeResourceConfig ComputeResourceConfig},
        # indicates that VM instances should be created from a
        # [reservation](https://cloud.google.com/compute/docs/instances/reservations-overview).
        # @!attribute [rw] reservation
        #   @return [::String]
        #     Optional. Immutable. Name of the reservation from which VM instances
        #     should be created, in the format
        #     `projects/{project}/zones/{zone}/reservations/{reservation}`.
        class NewReservedInstancesConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # When set in a
        # {::Google::Cloud::HypercomputeCluster::V1beta::ComputeResourceConfig ComputeResourceConfig},
        # indicates that VM instances should be created using [Flex
        # Start](https://cloud.google.com/compute/docs/instances/provisioning-models).
        # @!attribute [rw] zone
        #   @return [::String]
        #     Required. Immutable. Name of the zone in which VM instances should run,
        #     e.g., `us-central1-a`. Must be in the same region as the cluster, and must
        #     match the zone of any other resources specified in the cluster.
        # @!attribute [rw] machine_type
        #   @return [::String]
        #     Required. Immutable. Name of the Compute Engine [machine
        #     type](https://cloud.google.com/compute/docs/machine-resource) to use, e.g.
        #     `n2-standard-2`.
        # @!attribute [rw] max_duration
        #   @return [::Google::Protobuf::Duration]
        #     Required. Immutable. Specifies the time limit for created instances.
        #     Instances will be terminated at the end of this duration.
        class NewFlexStartInstancesConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A [Persistent disk](https://cloud.google.com/compute/docs/disks) used as the
        # boot disk for a Compute Engine VM instance.
        # @!attribute [rw] type
        #   @return [::String]
        #     Required. Immutable. [Persistent disk
        #     type](https://cloud.google.com/compute/docs/disks#disk-types), in the
        #     format `projects/{project}/zones/{zone}/diskTypes/{disk_type}`.
        # @!attribute [rw] size_gb
        #   @return [::Integer]
        #     Required. Immutable. Size of the disk in gigabytes. Must be at least 10GB.
        class BootDisk
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The component responsible for scheduling and running workloads on the
        # cluster as well as providing the user interface for interacting with the
        # cluster at runtime.
        # @!attribute [rw] slurm
        #   @return [::Google::Cloud::HypercomputeCluster::V1beta::SlurmOrchestrator]
        #     Optional. If set, indicates that the cluster should use Slurm as the
        #     orchestrator.
        class Orchestrator
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # When set in
        # {::Google::Cloud::HypercomputeCluster::V1beta::Orchestrator Orchestrator},
        # indicates that the cluster should use [Slurm](https://slurm.schedmd.com/) as
        # the orchestrator.
        # @!attribute [rw] login_nodes
        #   @return [::Google::Cloud::HypercomputeCluster::V1beta::SlurmLoginNodes]
        #     Required. Configuration for login nodes, which allow users to access the
        #     cluster over SSH.
        # @!attribute [rw] node_sets
        #   @return [::Array<::Google::Cloud::HypercomputeCluster::V1beta::SlurmNodeSet>]
        #     Required. Configuration of Slurm nodesets, which define groups of compute
        #     resources that can be used by Slurm. At least one compute node is required.
        # @!attribute [rw] partitions
        #   @return [::Array<::Google::Cloud::HypercomputeCluster::V1beta::SlurmPartition>]
        #     Required. Configuration of Slurm partitions, which group one or more
        #     nodesets. Acts as a queue against which jobs can be submitted. At least one
        #     partition is required.
        # @!attribute [rw] default_partition
        #   @return [::String]
        #     Optional. Default partition to use for submitted jobs that do not
        #     explicitly specify a partition. Required if and only if there is more than
        #     one partition, in which case it must match the id of one of the partitions.
        # @!attribute [rw] prolog_bash_scripts
        #   @return [::Array<::String>]
        #     Optional. Slurm [prolog
        #     scripts](https://slurm.schedmd.com/prolog_epilog.html), which will be
        #     executed by compute nodes before a node begins running a new job. Values
        #     must not be empty.
        # @!attribute [rw] epilog_bash_scripts
        #   @return [::Array<::String>]
        #     Optional. Slurm [epilog
        #     scripts](https://slurm.schedmd.com/prolog_epilog.html), which will be
        #     executed by compute nodes whenever a node finishes running a job. Values
        #     must not be empty.
        class SlurmOrchestrator
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for Slurm nodesets in the cluster. Nodesets are groups of
        # compute nodes used by Slurm that are responsible for running workloads
        # submitted to the cluster.
        # @!attribute [rw] compute_instance
        #   @return [::Google::Cloud::HypercomputeCluster::V1beta::ComputeInstanceSlurmNodeSet]
        #     Optional. If set, indicates that the nodeset should be backed by Compute
        #     Engine instances.
        # @!attribute [rw] id
        #   @return [::String]
        #     Required. Identifier for the nodeset, which allows it to be referenced by
        #     partitions. Must conform to
        #     [RFC-1034](https://datatracker.ietf.org/doc/html/rfc1034) (lower-case,
        #     alphanumeric, and at most 63 characters).
        # @!attribute [rw] compute_id
        #   @return [::String]
        #     Optional. ID of the compute resource on which this nodeset will run. Must
        #     match a key in the cluster's
        #     [compute_resources](Cluster.compute_resources).
        # @!attribute [rw] storage_configs
        #   @return [::Array<::Google::Cloud::HypercomputeCluster::V1beta::StorageConfig>]
        #     Optional. How [storage
        #     resources][google.cloud.hypercomputecluster.v1beta.StorageResource] should
        #     be mounted on each compute node.
        # @!attribute [rw] static_node_count
        #   @return [::Integer]
        #     Optional. Number of nodes to be statically created for this nodeset. The
        #     cluster will attempt to ensure that at least this many nodes exist at all
        #     times.
        # @!attribute [rw] max_dynamic_node_count
        #   @return [::Integer]
        #     Optional. Controls how many additional nodes a cluster can bring online to
        #     handle workloads. Set this value to enable dynamic node creation and limit
        #     the number of additional nodes the cluster can bring online. Leave empty if
        #     you do not want the cluster to create nodes dynamically, and instead rely
        #     only on static nodes.
        class SlurmNodeSet
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # When set in a
        # {::Google::Cloud::HypercomputeCluster::V1beta::SlurmNodeSet SlurmNodeSet},
        # indicates that the nodeset should be backed by Compute Engine VM instances.
        # @!attribute [rw] startup_script
        #   @return [::String]
        #     Optional. [Startup
        #     script](https://cloud.google.com/compute/docs/instances/startup-scripts/linux)
        #     to be run on each VM instance in the nodeset. Max 256KB.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional.
        #     [Labels](https://cloud.google.com/compute/docs/labeling-resources) that
        #     should be applied to each VM instance in the nodeset.
        # @!attribute [rw] boot_disk
        #   @return [::Google::Cloud::HypercomputeCluster::V1beta::BootDisk]
        #     Optional. Boot disk for the compute instance
        class ComputeInstanceSlurmNodeSet
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Configuration for Slurm partitions in the cluster. Partitions are groups of
        # nodesets, and are how clients specify where their workloads should be run.
        # @!attribute [rw] id
        #   @return [::String]
        #     Required. ID of the partition, which is how users will identify it. Must
        #     conform to [RFC-1034](https://datatracker.ietf.org/doc/html/rfc1034)
        #     (lower-case, alphanumeric, and at most 63 characters).
        # @!attribute [rw] node_set_ids
        #   @return [::Array<::String>]
        #     Required. IDs of the nodesets that make up this partition. Values must
        #     match
        #     {::Google::Cloud::HypercomputeCluster::V1beta::SlurmNodeSet#id SlurmNodeSet.id}.
        class SlurmPartition
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for Slurm [login
        # nodes](https://slurm.schedmd.com/quickstart_admin.html#login) in the cluster.
        # Login nodes are Compute Engine VM instances that allow users to access the
        # cluster over SSH.
        # @!attribute [rw] count
        #   @return [::Integer]
        #     Required. Number of login node instances to create.
        # @!attribute [rw] zone
        #   @return [::String]
        #     Required. Name of the zone in which login nodes should run, e.g.,
        #     `us-central1-a`. Must be in the same region as the cluster, and must match
        #     the zone of any other resources specified in the cluster.
        # @!attribute [rw] machine_type
        #   @return [::String]
        #     Required. Name of the Compute Engine [machine
        #     type](https://cloud.google.com/compute/docs/machine-resource) to use for
        #     login nodes, e.g. `n2-standard-2`.
        # @!attribute [rw] startup_script
        #   @return [::String]
        #     Optional. [Startup
        #     script](https://cloud.google.com/compute/docs/instances/startup-scripts/linux)
        #     to be run on each login node instance. Max 256KB.
        # @!attribute [rw] enable_os_login
        #   @return [::Boolean]
        #     Optional. Whether [OS Login](https://cloud.google.com/compute/docs/oslogin)
        #     should be enabled on login node instances.
        # @!attribute [rw] enable_public_ips
        #   @return [::Boolean]
        #     Optional. Whether login node instances should be assigned [external IP
        #     addresses](https://cloud.google.com/compute/docs/ip-addresses#externaladdresses).
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional.
        #     [Labels](https://cloud.google.com/compute/docs/labeling-resources) that
        #     should be applied to each login node instance.
        # @!attribute [rw] storage_configs
        #   @return [::Array<::Google::Cloud::HypercomputeCluster::V1beta::StorageConfig>]
        #     Optional. How [storage
        #     resources][google.cloud.hypercomputecluster.v1beta.StorageResource] should
        #     be mounted on each login node.
        # @!attribute [r] instances
        #   @return [::Array<::Google::Cloud::HypercomputeCluster::V1beta::ComputeInstance>]
        #     Output only. Information about the login node instances that were created
        #     in Compute Engine.
        # @!attribute [rw] boot_disk
        #   @return [::Google::Cloud::HypercomputeCluster::V1beta::BootDisk]
        #     Optional. Boot disk for the login node.
        class SlurmLoginNodes
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Description of how a [storage
        # resource][google.cloud.hypercomputecluster.v1beta.StorageResource] should be
        # mounted on a VM instance.
        # @!attribute [rw] id
        #   @return [::String]
        #     Required. ID of the storage resource to mount, which must match a key in
        #     the cluster's [storage_resources](Cluster.storage_resources).
        # @!attribute [rw] local_mount
        #   @return [::String]
        #     Required. A directory inside the VM instance's file system where the
        #     storage resource should be mounted (e.g., `/mnt/share`).
        class StorageConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details about a Compute Engine
        # [instance](https://cloud.google.com/compute/docs/instances).
        # @!attribute [r] instance
        #   @return [::String]
        #     Output only. Name of the VM instance, in the format
        #     `projects/{project}/zones/{zone}/instances/{instance}`.
        class ComputeInstance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
