# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module HypercomputeCluster
      module V1beta
        module HypercomputeCluster
          # Path helper methods for the HypercomputeCluster API.
          module Paths
            ##
            # Create a fully-qualified Bucket resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/buckets/{bucket}`
            #
            # @param project [String]
            # @param bucket [String]
            #
            # @return [::String]
            def bucket_path project:, bucket:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/buckets/#{bucket}"
            end

            ##
            # Create a fully-qualified Cluster resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/clusters/{cluster}`
            #
            # @param project [String]
            # @param location [String]
            # @param cluster [String]
            #
            # @return [::String]
            def cluster_path project:, location:, cluster:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/clusters/#{cluster}"
            end

            ##
            # Create a fully-qualified ComputeInstance resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/zones/{zone}/instances/{instance}`
            #
            # @param project [String]
            # @param zone [String]
            # @param instance [String]
            #
            # @return [::String]
            def compute_instance_path project:, zone:, instance:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "zone cannot contain /" if zone.to_s.include? "/"

              "projects/#{project}/zones/#{zone}/instances/#{instance}"
            end

            ##
            # Create a fully-qualified DiskType resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/zones/{zone}/diskTypes/{disk_type}`
            #
            # @param project [String]
            # @param zone [String]
            # @param disk_type [String]
            #
            # @return [::String]
            def disk_type_path project:, zone:, disk_type:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "zone cannot contain /" if zone.to_s.include? "/"

              "projects/#{project}/zones/#{zone}/diskTypes/#{disk_type}"
            end

            ##
            # Create a fully-qualified FileInstance resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/instances/{instance}`
            #
            # @param project [String]
            # @param location [String]
            # @param instance [String]
            #
            # @return [::String]
            def file_instance_path project:, location:, instance:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/instances/#{instance}"
            end

            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            ##
            # Create a fully-qualified LustreInstance resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/instances/{instance}`
            #
            # @param project [String]
            # @param location [String]
            # @param instance [String]
            #
            # @return [::String]
            def lustre_instance_path project:, location:, instance:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/instances/#{instance}"
            end

            ##
            # Create a fully-qualified Network resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/global/networks/{network}`
            #
            # @param project [String]
            # @param network [String]
            #
            # @return [::String]
            def network_path project:, network:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/global/networks/#{network}"
            end

            ##
            # Create a fully-qualified Reservation resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/zones/{zone}/reservations/{reservation}`
            #
            # @param project [String]
            # @param zone [String]
            # @param reservation [String]
            #
            # @return [::String]
            def reservation_path project:, zone:, reservation:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "zone cannot contain /" if zone.to_s.include? "/"

              "projects/#{project}/zones/#{zone}/reservations/#{reservation}"
            end

            ##
            # Create a fully-qualified Subnetwork resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/regions/{region}/subnetworks/{subnetwork}`
            #
            # @param project [String]
            # @param region [String]
            # @param subnetwork [String]
            #
            # @return [::String]
            def subnetwork_path project:, region:, subnetwork:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "region cannot contain /" if region.to_s.include? "/"

              "projects/#{project}/regions/#{region}/subnetworks/#{subnetwork}"
            end

            extend self
          end
        end
      end
    end
  end
end
