# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/gsuiteaddons/v1/gsuiteaddons_pb"
require "google/cloud/gsuite_add_ons/v1/gsuite_add_ons/rest"


class ::Google::Cloud::GSuiteAddOns::V1::GSuiteAddOns::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_get_authorization
    # Create test objects.
    client_result = ::Google::Cloud::GSuiteAddOns::V1::Authorization.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_authorization_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GSuiteAddOns::V1::GSuiteAddOns::Rest::ServiceStub.stub :transcode_get_authorization_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_authorization_client_stub do
        # Create client
        client = ::Google::Cloud::GSuiteAddOns::V1::GSuiteAddOns::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_authorization({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_authorization name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_authorization ::Google::Cloud::GSuiteAddOns::V1::GetAuthorizationRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_authorization({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_authorization(::Google::Cloud::GSuiteAddOns::V1::GetAuthorizationRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_authorization_client_stub.call_count
      end
    end
  end

  def test_create_deployment
    # Create test objects.
    client_result = ::Google::Cloud::GSuiteAddOns::V1::Deployment.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    deployment_id = "hello world"
    deployment = {}

    create_deployment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GSuiteAddOns::V1::GSuiteAddOns::Rest::ServiceStub.stub :transcode_create_deployment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_deployment_client_stub do
        # Create client
        client = ::Google::Cloud::GSuiteAddOns::V1::GSuiteAddOns::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_deployment({ parent: parent, deployment_id: deployment_id, deployment: deployment }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_deployment parent: parent, deployment_id: deployment_id, deployment: deployment do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_deployment ::Google::Cloud::GSuiteAddOns::V1::CreateDeploymentRequest.new(parent: parent, deployment_id: deployment_id, deployment: deployment) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_deployment({ parent: parent, deployment_id: deployment_id, deployment: deployment }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_deployment(::Google::Cloud::GSuiteAddOns::V1::CreateDeploymentRequest.new(parent: parent, deployment_id: deployment_id, deployment: deployment), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_deployment_client_stub.call_count
      end
    end
  end

  def test_replace_deployment
    # Create test objects.
    client_result = ::Google::Cloud::GSuiteAddOns::V1::Deployment.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    deployment = {}

    replace_deployment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GSuiteAddOns::V1::GSuiteAddOns::Rest::ServiceStub.stub :transcode_replace_deployment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, replace_deployment_client_stub do
        # Create client
        client = ::Google::Cloud::GSuiteAddOns::V1::GSuiteAddOns::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.replace_deployment({ deployment: deployment }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.replace_deployment deployment: deployment do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.replace_deployment ::Google::Cloud::GSuiteAddOns::V1::ReplaceDeploymentRequest.new(deployment: deployment) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.replace_deployment({ deployment: deployment }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.replace_deployment(::Google::Cloud::GSuiteAddOns::V1::ReplaceDeploymentRequest.new(deployment: deployment), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, replace_deployment_client_stub.call_count
      end
    end
  end

  def test_get_deployment
    # Create test objects.
    client_result = ::Google::Cloud::GSuiteAddOns::V1::Deployment.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_deployment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GSuiteAddOns::V1::GSuiteAddOns::Rest::ServiceStub.stub :transcode_get_deployment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_deployment_client_stub do
        # Create client
        client = ::Google::Cloud::GSuiteAddOns::V1::GSuiteAddOns::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_deployment({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_deployment name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_deployment ::Google::Cloud::GSuiteAddOns::V1::GetDeploymentRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_deployment({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_deployment(::Google::Cloud::GSuiteAddOns::V1::GetDeploymentRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_deployment_client_stub.call_count
      end
    end
  end

  def test_list_deployments
    # Create test objects.
    client_result = ::Google::Cloud::GSuiteAddOns::V1::ListDeploymentsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_deployments_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GSuiteAddOns::V1::GSuiteAddOns::Rest::ServiceStub.stub :transcode_list_deployments_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_deployments_client_stub do
        # Create client
        client = ::Google::Cloud::GSuiteAddOns::V1::GSuiteAddOns::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_deployments({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_deployments parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_deployments ::Google::Cloud::GSuiteAddOns::V1::ListDeploymentsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_deployments({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_deployments(::Google::Cloud::GSuiteAddOns::V1::ListDeploymentsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_deployments_client_stub.call_count
      end
    end
  end

  def test_delete_deployment
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"

    delete_deployment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GSuiteAddOns::V1::GSuiteAddOns::Rest::ServiceStub.stub :transcode_delete_deployment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_deployment_client_stub do
        # Create client
        client = ::Google::Cloud::GSuiteAddOns::V1::GSuiteAddOns::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_deployment({ name: name, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_deployment name: name, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_deployment ::Google::Cloud::GSuiteAddOns::V1::DeleteDeploymentRequest.new(name: name, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_deployment({ name: name, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_deployment(::Google::Cloud::GSuiteAddOns::V1::DeleteDeploymentRequest.new(name: name, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_deployment_client_stub.call_count
      end
    end
  end

  def test_install_deployment
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    install_deployment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GSuiteAddOns::V1::GSuiteAddOns::Rest::ServiceStub.stub :transcode_install_deployment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, install_deployment_client_stub do
        # Create client
        client = ::Google::Cloud::GSuiteAddOns::V1::GSuiteAddOns::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.install_deployment({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.install_deployment name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.install_deployment ::Google::Cloud::GSuiteAddOns::V1::InstallDeploymentRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.install_deployment({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.install_deployment(::Google::Cloud::GSuiteAddOns::V1::InstallDeploymentRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, install_deployment_client_stub.call_count
      end
    end
  end

  def test_uninstall_deployment
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    uninstall_deployment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GSuiteAddOns::V1::GSuiteAddOns::Rest::ServiceStub.stub :transcode_uninstall_deployment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, uninstall_deployment_client_stub do
        # Create client
        client = ::Google::Cloud::GSuiteAddOns::V1::GSuiteAddOns::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.uninstall_deployment({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.uninstall_deployment name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.uninstall_deployment ::Google::Cloud::GSuiteAddOns::V1::UninstallDeploymentRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.uninstall_deployment({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.uninstall_deployment(::Google::Cloud::GSuiteAddOns::V1::UninstallDeploymentRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, uninstall_deployment_client_stub.call_count
      end
    end
  end

  def test_get_install_status
    # Create test objects.
    client_result = ::Google::Cloud::GSuiteAddOns::V1::InstallStatus.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_install_status_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GSuiteAddOns::V1::GSuiteAddOns::Rest::ServiceStub.stub :transcode_get_install_status_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_install_status_client_stub do
        # Create client
        client = ::Google::Cloud::GSuiteAddOns::V1::GSuiteAddOns::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_install_status({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_install_status name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_install_status ::Google::Cloud::GSuiteAddOns::V1::GetInstallStatusRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_install_status({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_install_status(::Google::Cloud::GSuiteAddOns::V1::GetInstallStatusRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_install_status_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::GSuiteAddOns::V1::GSuiteAddOns::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::GSuiteAddOns::V1::GSuiteAddOns::Rest::Client::Configuration, config
  end
end
