# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Apps
    module Script
      module Type
        # Add-on configuration that is shared across all add-on host applications.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The display name of the add-on.
        # @!attribute [rw] logo_url
        #   @return [::String]
        #     Required. The URL for the logo image shown in the add-on toolbar.
        # @!attribute [rw] layout_properties
        #   @return [::Google::Apps::Script::Type::LayoutProperties]
        #     Common layout properties for the add-on cards.
        # @!attribute [rw] add_on_widget_set
        #   @return [::Google::Apps::Script::Type::AddOnWidgetSet]
        #     The widgets used in the add-on. If this field is not specified,
        #     it indicates that default set is used.
        # @!attribute [rw] use_locale_from_app
        #   @return [::Boolean]
        #     Whether to pass locale information from host app.
        # @!attribute [rw] homepage_trigger
        #   @return [::Google::Apps::Script::Type::HomepageExtensionPoint]
        #     Defines an endpoint that will be executed in any context, in
        #     any host. Any cards generated by this function will always be available to
        #     the user, but may be eclipsed by contextual content when this add-on
        #     declares more targeted triggers.
        # @!attribute [rw] universal_actions
        #   @return [::Array<::Google::Apps::Script::Type::UniversalActionExtensionPoint>]
        #     Defines a list of extension points in the universal action menu which
        #     serves as a setting menu for the add-on. The extension point can be
        #     link URL to open or an endpoint to execute as a form
        #     submission.
        # @!attribute [rw] open_link_url_prefixes
        #   @return [::Google::Protobuf::ListValue]
        #     An OpenLink action
        #     can only use a URL with an HTTPS, MAILTO or TEL scheme.  For HTTPS links,
        #     the URL must also
        #     [match](/gmail/add-ons/concepts/manifests#whitelisting_urls) one of the
        #     prefixes specified in this whitelist. If the prefix omits the scheme, HTTPS
        #     is assumed.  Notice that HTTP links are automatically rewritten to HTTPS
        #     links.
        class CommonAddOnManifest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Card layout properties shared across all add-on host applications.
        # @!attribute [rw] primary_color
        #   @return [::String]
        #     The primary color of the add-on. It sets the color of toolbar. If no
        #     primary color is set explicitly, the default value provided by the
        #     framework is used.
        # @!attribute [rw] secondary_color
        #   @return [::String]
        #     The secondary color of the add-on. It sets the color of buttons.
        #     If primary color is set but no secondary color is set, the
        #     secondary color is the same as the primary color. If neither primary
        #     color nor secondary color is set, the default value provided by the
        #     framework is used.
        class LayoutProperties
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Options for sending requests to add-on HTTP endpoints
        # @!attribute [rw] authorization_header
        #   @return [::Google::Apps::Script::Type::HttpAuthorizationHeader]
        #     Configuration for the token sent in the HTTP Authorization header
        class HttpOptions
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Authorization header sent in add-on HTTP requests
        module HttpAuthorizationHeader
          # Default value, equivalent to `SYSTEM_ID_TOKEN`
          HTTP_AUTHORIZATION_HEADER_UNSPECIFIED = 0

          # Send an ID token for the project-specific Google Workspace add-ons system
          # service account (default)
          SYSTEM_ID_TOKEN = 1

          # Send an ID token for the end user
          USER_ID_TOKEN = 2

          # Do not send an Authentication header
          NONE = 3
        end
      end
    end
  end
end
