# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Apps
    module Script
      module Type
        module Gmail
          # Properties customizing the appearance and execution of a Gmail add-on.
          # @!attribute [rw] homepage_trigger
          #   @return [::Google::Apps::Script::Type::HomepageExtensionPoint]
          #     Defines an endpoint that will be executed in contexts that don't
          #     match a declared contextual trigger. Any cards generated by this function
          #     will always be available to the user, but may be eclipsed by contextual
          #     content when this add-on declares more targeted triggers.
          #
          #     If present, this overrides the configuration from
          #     `addOns.common.homepageTrigger`.
          # @!attribute [rw] contextual_triggers
          #   @return [::Array<::Google::Apps::Script::Type::Gmail::ContextualTrigger>]
          #     Defines the set of conditions that trigger the add-on.
          # @!attribute [rw] universal_actions
          #   @return [::Array<::Google::Apps::Script::Type::Gmail::UniversalAction>]
          #     Defines set of [universal
          #     actions](/gmail/add-ons/how-tos/universal-actions) for the add-on. The user
          #     triggers universal actions from the add-on toolbar menu.
          # @!attribute [rw] compose_trigger
          #   @return [::Google::Apps::Script::Type::Gmail::ComposeTrigger]
          #     Defines the compose time trigger for a compose time add-on. This is the
          #     trigger that causes an add-on to take action when the user is composing an
          #     email.
          #     All compose time addons are required to have the
          #     gmail.addons.current.action.compose scope even though it might not edit the
          #     draft.
          # @!attribute [rw] authorization_check_function
          #   @return [::String]
          #     The name of an endpoint that verifies that the add-on has
          #     all the required third-party authorizations, by probing the third-party
          #     APIs. If the probe fails, the function should throw an exception to
          #     initiate the authorization flow. This function is called before each
          #     invocation of the add-on, in order to ensure a smooth user experience.
          class GmailAddOnManifest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # An action that is always available in the add-on toolbar menu regardless of
          # message context.
          # @!attribute [rw] text
          #   @return [::String]
          #     Required. User-visible text describing the action, for example, "Add a new
          #     contact."
          # @!attribute [rw] open_link
          #   @return [::String]
          #     A link that is opened by Gmail when the user triggers the action.
          #
          #     Note: The following fields are mutually exclusive: `open_link`, `run_function`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] run_function
          #   @return [::String]
          #     An endpoint that is called when the user triggers the
          #     action. See the [universal actions
          #     guide](/gmail/add-ons/how-tos/universal-actions) for details.
          #
          #     Note: The following fields are mutually exclusive: `run_function`, `open_link`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class UniversalAction
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A trigger that activates when user is composing an email.
          # @!attribute [rw] actions
          #   @return [::Array<::Google::Apps::Script::Type::MenuItemExtensionPoint>]
          #     Defines the set of actions for compose time add-on. These are actions
          #     that user can trigger on a compose time addon.
          # @!attribute [rw] draft_access
          #   @return [::Google::Apps::Script::Type::Gmail::ComposeTrigger::DraftAccess]
          #     Define the level of data access when a compose time addon is triggered.
          class ComposeTrigger
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # An enum defining the level of data access this compose trigger requires.
            module DraftAccess
              # Default value when nothing is set for DraftAccess.
              UNSPECIFIED = 0

              # NONE means compose trigger won't be able to access any data of the draft
              # when a compose addon is triggered.
              NONE = 1

              # METADATA gives compose trigger the permission to access the metadata of
              # the draft when a compose addon is triggered. This includes the audience
              # list (To/cc list) of a draft message.
              METADATA = 2
            end
          end

          # Defines a trigger that fires when the open email meets a specific criteria.
          # When the trigger fires, it executes a specific endpoint, usually
          # in order to create new cards and update the UI.
          # @!attribute [rw] unconditional
          #   @return [::Google::Apps::Script::Type::Gmail::UnconditionalTrigger]
          #     UnconditionalTriggers are executed when any mail message is opened.
          # @!attribute [rw] on_trigger_function
          #   @return [::String]
          #     Required. The name of the endpoint to call when a message matches the
          #     trigger.
          class ContextualTrigger
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A trigger that fires when any email message is opened.
          class UnconditionalTrigger
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
