# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Apps
    module Script
      module Type
        # Common format for declaring a  menu item, or button, that appears within a
        # host app.
        # @!attribute [rw] run_function
        #   @return [::String]
        #     Required. The endpoint to execute when this extension point is
        #     activated.
        # @!attribute [rw] label
        #   @return [::String]
        #     Required. User-visible text describing the action taken by activating this
        #     extension point. For example, "Insert invoice".
        # @!attribute [rw] logo_url
        #   @return [::String]
        #     The URL for the logo image shown in the add-on toolbar.
        #
        #     If not set, defaults to the add-on's primary logo URL.
        class MenuItemExtensionPoint
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Common format for declaring an add-on's home-page view.
        # @!attribute [rw] run_function
        #   @return [::String]
        #     Required. The endpoint to execute when this extension point is
        #     activated.
        # @!attribute [rw] enabled
        #   @return [::Google::Protobuf::BoolValue]
        #     Optional. If set to `false`, disable the home-page view in this context.
        #
        #     Defaults to `true` if unset.
        #
        #     If an add-ons custom home-page view is disabled, an autogenerated overview
        #     card will be provided for users instead.
        class HomepageExtensionPoint
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Format for declaring a universal action menu item extension point.
        # @!attribute [rw] label
        #   @return [::String]
        #     Required. User-visible text describing the action taken by activating this
        #     extension point, for example, "Add a new contact".
        # @!attribute [rw] open_link
        #   @return [::String]
        #     URL to be opened by the UniversalAction.
        #
        #     Note: The following fields are mutually exclusive: `open_link`, `run_function`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] run_function
        #   @return [::String]
        #     Endpoint to be run by the UniversalAction.
        #
        #     Note: The following fields are mutually exclusive: `run_function`, `open_link`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class UniversalActionExtensionPoint
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
