# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/gsuiteaddons/v1/gsuiteaddons_pb"
require "google/cloud/gsuite_add_ons/v1/gsuite_add_ons/rest/service_stub"

module Google
  module Cloud
    module GSuiteAddOns
      module V1
        module GSuiteAddOns
          module Rest
            ##
            # REST client for the GSuiteAddOns service.
            #
            # A service for managing Google Workspace add-ons deployments.
            #
            # A Google Workspace add-on is a third-party embedded component that can be
            # installed in Google Workspace Applications like Gmail, Calendar, Drive, and
            # the Google Docs, Sheets, and Slides editors. Google Workspace add-ons can
            # display UI cards, receive contextual information from the host application,
            # and perform actions in the host application (See:
            # https://developers.google.com/gsuite/add-ons/overview for more information).
            #
            # A Google Workspace add-on deployment resource specifies metadata about the
            # add-on, including a specification of the entry points in the host application
            # that trigger add-on executions (see:
            # https://developers.google.com/gsuite/add-ons/concepts/gsuite-manifests).
            # Add-on deployments defined via the Google Workspace add-ons API define their
            # entrypoints using HTTPS URLs (See:
            # https://developers.google.com/gsuite/add-ons/guides/alternate-runtimes),
            #
            # A Google Workspace add-on deployment can be installed in developer mode,
            # which allows an add-on developer to test the experience an end-user would see
            # when installing and running the add-on in their G Suite applications.  When
            # running in developer mode, more detailed error messages are exposed in the
            # add-on UI to aid in debugging.
            #
            # A Google Workspace add-on deployment can be published to Google Workspace
            # Marketplace, which allows other Google Workspace users to discover and
            # install the add-on.  See:
            # https://developers.google.com/gsuite/add-ons/how-tos/publish-add-on-overview
            # for details.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "gsuiteaddons.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :g_suite_add_ons_stub

              ##
              # Configure the GSuiteAddOns Client class.
              #
              # See {::Google::Cloud::GSuiteAddOns::V1::GSuiteAddOns::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all GSuiteAddOns clients
              #   ::Google::Cloud::GSuiteAddOns::V1::GSuiteAddOns::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "GSuiteAddOns", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.timeout = 10.0
                  default_config.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 2]
                  }

                  default_config.rpcs.get_authorization.timeout = 120.0

                  default_config.rpcs.create_deployment.timeout = 10.0

                  default_config.rpcs.delete_deployment.timeout = 10.0

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the GSuiteAddOns Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::GSuiteAddOns::V1::GSuiteAddOns::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @g_suite_add_ons_stub.universe_domain
              end

              ##
              # Create a new GSuiteAddOns REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::GSuiteAddOns::V1::GSuiteAddOns::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::GSuiteAddOns::V1::GSuiteAddOns::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the GSuiteAddOns client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @g_suite_add_ons_stub = ::Google::Cloud::GSuiteAddOns::V1::GSuiteAddOns::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @g_suite_add_ons_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end
              end

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @g_suite_add_ons_stub.logger
              end

              # Service calls

              ##
              # Gets the authorization information for deployments in a given project.
              #
              # @overload get_authorization(request, options = nil)
              #   Pass arguments to `get_authorization` via a request object, either of type
              #   {::Google::Cloud::GSuiteAddOns::V1::GetAuthorizationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GSuiteAddOns::V1::GetAuthorizationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_authorization(name: nil)
              #   Pass arguments to `get_authorization` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the project for which to get the Google Workspace add-ons
              #     authorization information.
              #
              #     Example: `projects/my_project/authorization`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::GSuiteAddOns::V1::Authorization]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::GSuiteAddOns::V1::Authorization]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gsuite_add_ons/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GSuiteAddOns::V1::GSuiteAddOns::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GSuiteAddOns::V1::GetAuthorizationRequest.new
              #
              #   # Call the get_authorization method.
              #   result = client.get_authorization request
              #
              #   # The returned object is of type Google::Cloud::GSuiteAddOns::V1::Authorization.
              #   p result
              #
              def get_authorization request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GSuiteAddOns::V1::GetAuthorizationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_authorization.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GSuiteAddOns::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_authorization.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_authorization.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @g_suite_add_ons_stub.get_authorization request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a deployment with the specified name and configuration.
              #
              # @overload create_deployment(request, options = nil)
              #   Pass arguments to `create_deployment` via a request object, either of type
              #   {::Google::Cloud::GSuiteAddOns::V1::CreateDeploymentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GSuiteAddOns::V1::CreateDeploymentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_deployment(parent: nil, deployment_id: nil, deployment: nil)
              #   Pass arguments to `create_deployment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Name of the project in which to create the deployment.
              #
              #     Example: `projects/my_project`.
              #   @param deployment_id [::String]
              #     Required. The id to use for this deployment.  The full name of the created
              #     resource will be `projects/<project_number>/deployments/<deployment_id>`.
              #   @param deployment [::Google::Cloud::GSuiteAddOns::V1::Deployment, ::Hash]
              #     Required. The deployment to create (deployment.name cannot be set).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::GSuiteAddOns::V1::Deployment]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::GSuiteAddOns::V1::Deployment]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gsuite_add_ons/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GSuiteAddOns::V1::GSuiteAddOns::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GSuiteAddOns::V1::CreateDeploymentRequest.new
              #
              #   # Call the create_deployment method.
              #   result = client.create_deployment request
              #
              #   # The returned object is of type Google::Cloud::GSuiteAddOns::V1::Deployment.
              #   p result
              #
              def create_deployment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GSuiteAddOns::V1::CreateDeploymentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_deployment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GSuiteAddOns::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_deployment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_deployment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @g_suite_add_ons_stub.create_deployment request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates or replaces a deployment with the specified name.
              #
              # @overload replace_deployment(request, options = nil)
              #   Pass arguments to `replace_deployment` via a request object, either of type
              #   {::Google::Cloud::GSuiteAddOns::V1::ReplaceDeploymentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GSuiteAddOns::V1::ReplaceDeploymentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload replace_deployment(deployment: nil)
              #   Pass arguments to `replace_deployment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param deployment [::Google::Cloud::GSuiteAddOns::V1::Deployment, ::Hash]
              #     Required. The deployment to create or replace.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::GSuiteAddOns::V1::Deployment]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::GSuiteAddOns::V1::Deployment]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gsuite_add_ons/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GSuiteAddOns::V1::GSuiteAddOns::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GSuiteAddOns::V1::ReplaceDeploymentRequest.new
              #
              #   # Call the replace_deployment method.
              #   result = client.replace_deployment request
              #
              #   # The returned object is of type Google::Cloud::GSuiteAddOns::V1::Deployment.
              #   p result
              #
              def replace_deployment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GSuiteAddOns::V1::ReplaceDeploymentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.replace_deployment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GSuiteAddOns::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.replace_deployment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.replace_deployment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @g_suite_add_ons_stub.replace_deployment request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the deployment with the specified name.
              #
              # @overload get_deployment(request, options = nil)
              #   Pass arguments to `get_deployment` via a request object, either of type
              #   {::Google::Cloud::GSuiteAddOns::V1::GetDeploymentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GSuiteAddOns::V1::GetDeploymentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_deployment(name: nil)
              #   Pass arguments to `get_deployment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The full resource name of the deployment to get.
              #
              #     Example:  `projects/my_project/deployments/my_deployment`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::GSuiteAddOns::V1::Deployment]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::GSuiteAddOns::V1::Deployment]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gsuite_add_ons/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GSuiteAddOns::V1::GSuiteAddOns::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GSuiteAddOns::V1::GetDeploymentRequest.new
              #
              #   # Call the get_deployment method.
              #   result = client.get_deployment request
              #
              #   # The returned object is of type Google::Cloud::GSuiteAddOns::V1::Deployment.
              #   p result
              #
              def get_deployment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GSuiteAddOns::V1::GetDeploymentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_deployment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GSuiteAddOns::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_deployment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_deployment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @g_suite_add_ons_stub.get_deployment request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all deployments in a particular project.
              #
              # @overload list_deployments(request, options = nil)
              #   Pass arguments to `list_deployments` via a request object, either of type
              #   {::Google::Cloud::GSuiteAddOns::V1::ListDeploymentsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GSuiteAddOns::V1::ListDeploymentsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_deployments(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_deployments` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Name of the project in which to create the deployment.
              #
              #     Example: `projects/my_project`.
              #   @param page_size [::Integer]
              #     The maximum number of deployments to return. The service may return fewer
              #     than this value.
              #     If unspecified, at most 1000 deployments will be returned.
              #     The maximum value is 1000; values above 1000 will be coerced to 1000.
              #   @param page_token [::String]
              #     A page token, received from a previous `ListDeployments` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to `ListDeployments` must
              #     match the call that provided the page token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::GSuiteAddOns::V1::Deployment>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::GSuiteAddOns::V1::Deployment>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gsuite_add_ons/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GSuiteAddOns::V1::GSuiteAddOns::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GSuiteAddOns::V1::ListDeploymentsRequest.new
              #
              #   # Call the list_deployments method.
              #   result = client.list_deployments request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::GSuiteAddOns::V1::Deployment.
              #     p item
              #   end
              #
              def list_deployments request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GSuiteAddOns::V1::ListDeploymentsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_deployments.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GSuiteAddOns::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_deployments.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_deployments.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @g_suite_add_ons_stub.list_deployments request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @g_suite_add_ons_stub, :list_deployments, "deployments", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes the deployment with the given name.
              #
              # @overload delete_deployment(request, options = nil)
              #   Pass arguments to `delete_deployment` via a request object, either of type
              #   {::Google::Cloud::GSuiteAddOns::V1::DeleteDeploymentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GSuiteAddOns::V1::DeleteDeploymentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_deployment(name: nil, etag: nil)
              #   Pass arguments to `delete_deployment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The full resource name of the deployment to delete.
              #
              #     Example:  `projects/my_project/deployments/my_deployment`.
              #   @param etag [::String]
              #     The etag of the deployment to delete.
              #     If this is provided, it must match the server's etag.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gsuite_add_ons/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GSuiteAddOns::V1::GSuiteAddOns::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GSuiteAddOns::V1::DeleteDeploymentRequest.new
              #
              #   # Call the delete_deployment method.
              #   result = client.delete_deployment request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_deployment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GSuiteAddOns::V1::DeleteDeploymentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_deployment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GSuiteAddOns::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_deployment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_deployment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @g_suite_add_ons_stub.delete_deployment request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Installs a deployment in developer mode.
              # See:
              # https://developers.google.com/gsuite/add-ons/how-tos/testing-gsuite-addons.
              #
              # @overload install_deployment(request, options = nil)
              #   Pass arguments to `install_deployment` via a request object, either of type
              #   {::Google::Cloud::GSuiteAddOns::V1::InstallDeploymentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GSuiteAddOns::V1::InstallDeploymentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload install_deployment(name: nil)
              #   Pass arguments to `install_deployment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The full resource name of the deployment to install.
              #
              #     Example:  `projects/my_project/deployments/my_deployment`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gsuite_add_ons/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GSuiteAddOns::V1::GSuiteAddOns::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GSuiteAddOns::V1::InstallDeploymentRequest.new
              #
              #   # Call the install_deployment method.
              #   result = client.install_deployment request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def install_deployment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GSuiteAddOns::V1::InstallDeploymentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.install_deployment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GSuiteAddOns::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.install_deployment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.install_deployment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @g_suite_add_ons_stub.install_deployment request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Uninstalls a developer mode deployment.
              # See:
              # https://developers.google.com/gsuite/add-ons/how-tos/testing-gsuite-addons.
              #
              # @overload uninstall_deployment(request, options = nil)
              #   Pass arguments to `uninstall_deployment` via a request object, either of type
              #   {::Google::Cloud::GSuiteAddOns::V1::UninstallDeploymentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GSuiteAddOns::V1::UninstallDeploymentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload uninstall_deployment(name: nil)
              #   Pass arguments to `uninstall_deployment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The full resource name of the deployment to install.
              #
              #     Example:  `projects/my_project/deployments/my_deployment`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gsuite_add_ons/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GSuiteAddOns::V1::GSuiteAddOns::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GSuiteAddOns::V1::UninstallDeploymentRequest.new
              #
              #   # Call the uninstall_deployment method.
              #   result = client.uninstall_deployment request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def uninstall_deployment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GSuiteAddOns::V1::UninstallDeploymentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.uninstall_deployment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GSuiteAddOns::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.uninstall_deployment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.uninstall_deployment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @g_suite_add_ons_stub.uninstall_deployment request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Fetches the install status of a developer mode deployment.
              #
              # @overload get_install_status(request, options = nil)
              #   Pass arguments to `get_install_status` via a request object, either of type
              #   {::Google::Cloud::GSuiteAddOns::V1::GetInstallStatusRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GSuiteAddOns::V1::GetInstallStatusRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_install_status(name: nil)
              #   Pass arguments to `get_install_status` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The full resource name of the deployment.
              #
              #     Example:  `projects/my_project/deployments/my_deployment/installStatus`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::GSuiteAddOns::V1::InstallStatus]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::GSuiteAddOns::V1::InstallStatus]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gsuite_add_ons/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GSuiteAddOns::V1::GSuiteAddOns::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GSuiteAddOns::V1::GetInstallStatusRequest.new
              #
              #   # Call the get_install_status method.
              #   result = client.get_install_status request
              #
              #   # The returned object is of type Google::Cloud::GSuiteAddOns::V1::InstallStatus.
              #   p result
              #
              def get_install_status request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GSuiteAddOns::V1::GetInstallStatusRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_install_status.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GSuiteAddOns::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_install_status.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_install_status.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @g_suite_add_ons_stub.get_install_status request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the GSuiteAddOns REST API.
              #
              # This class represents the configuration for GSuiteAddOns REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::GSuiteAddOns::V1::GSuiteAddOns::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # get_authorization to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::GSuiteAddOns::V1::GSuiteAddOns::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.get_authorization.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::GSuiteAddOns::V1::GSuiteAddOns::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.get_authorization.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "gsuiteaddons.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the GSuiteAddOns API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `get_authorization`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_authorization
                  ##
                  # RPC-specific configuration for `create_deployment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_deployment
                  ##
                  # RPC-specific configuration for `replace_deployment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :replace_deployment
                  ##
                  # RPC-specific configuration for `get_deployment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_deployment
                  ##
                  # RPC-specific configuration for `list_deployments`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_deployments
                  ##
                  # RPC-specific configuration for `delete_deployment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_deployment
                  ##
                  # RPC-specific configuration for `install_deployment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :install_deployment
                  ##
                  # RPC-specific configuration for `uninstall_deployment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :uninstall_deployment
                  ##
                  # RPC-specific configuration for `get_install_status`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_install_status

                  # @private
                  def initialize parent_rpcs = nil
                    get_authorization_config = parent_rpcs.get_authorization if parent_rpcs.respond_to? :get_authorization
                    @get_authorization = ::Gapic::Config::Method.new get_authorization_config
                    create_deployment_config = parent_rpcs.create_deployment if parent_rpcs.respond_to? :create_deployment
                    @create_deployment = ::Gapic::Config::Method.new create_deployment_config
                    replace_deployment_config = parent_rpcs.replace_deployment if parent_rpcs.respond_to? :replace_deployment
                    @replace_deployment = ::Gapic::Config::Method.new replace_deployment_config
                    get_deployment_config = parent_rpcs.get_deployment if parent_rpcs.respond_to? :get_deployment
                    @get_deployment = ::Gapic::Config::Method.new get_deployment_config
                    list_deployments_config = parent_rpcs.list_deployments if parent_rpcs.respond_to? :list_deployments
                    @list_deployments = ::Gapic::Config::Method.new list_deployments_config
                    delete_deployment_config = parent_rpcs.delete_deployment if parent_rpcs.respond_to? :delete_deployment
                    @delete_deployment = ::Gapic::Config::Method.new delete_deployment_config
                    install_deployment_config = parent_rpcs.install_deployment if parent_rpcs.respond_to? :install_deployment
                    @install_deployment = ::Gapic::Config::Method.new install_deployment_config
                    uninstall_deployment_config = parent_rpcs.uninstall_deployment if parent_rpcs.respond_to? :uninstall_deployment
                    @uninstall_deployment = ::Gapic::Config::Method.new uninstall_deployment_config
                    get_install_status_config = parent_rpcs.get_install_status if parent_rpcs.respond_to? :get_install_status
                    @get_install_status = ::Gapic::Config::Method.new get_install_status_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
