# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/gkerecommender/v1/gkerecommender_pb"
require "google/cloud/gke_recommender/v1/gke_inference_quickstart"

class ::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_fetch_models
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::GkeRecommender::V1::FetchModelsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    page_size = 42
    page_token = "hello world"

    fetch_models_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :fetch_models, name
      assert_kind_of ::Google::Cloud::GkeRecommender::V1::FetchModelsRequest, request
      assert_equal 42, request["page_size"]
      assert request.has_page_size?
      assert_equal "hello world", request["page_token"]
      assert request.has_page_token?
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, fetch_models_client_stub do
      # Create client
      client = ::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.fetch_models({ page_size: page_size, page_token: page_token }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.fetch_models page_size: page_size, page_token: page_token do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.fetch_models ::Google::Cloud::GkeRecommender::V1::FetchModelsRequest.new(page_size: page_size, page_token: page_token) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.fetch_models({ page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.fetch_models(::Google::Cloud::GkeRecommender::V1::FetchModelsRequest.new(page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, fetch_models_client_stub.call_rpc_count
    end
  end

  def test_fetch_model_servers
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::GkeRecommender::V1::FetchModelServersResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    model = "hello world"
    page_size = 42
    page_token = "hello world"

    fetch_model_servers_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :fetch_model_servers, name
      assert_kind_of ::Google::Cloud::GkeRecommender::V1::FetchModelServersRequest, request
      assert_equal "hello world", request["model"]
      assert_equal 42, request["page_size"]
      assert request.has_page_size?
      assert_equal "hello world", request["page_token"]
      assert request.has_page_token?
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, fetch_model_servers_client_stub do
      # Create client
      client = ::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.fetch_model_servers({ model: model, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.fetch_model_servers model: model, page_size: page_size, page_token: page_token do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.fetch_model_servers ::Google::Cloud::GkeRecommender::V1::FetchModelServersRequest.new(model: model, page_size: page_size, page_token: page_token) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.fetch_model_servers({ model: model, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.fetch_model_servers(::Google::Cloud::GkeRecommender::V1::FetchModelServersRequest.new(model: model, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, fetch_model_servers_client_stub.call_rpc_count
    end
  end

  def test_fetch_model_server_versions
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::GkeRecommender::V1::FetchModelServerVersionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    model = "hello world"
    model_server = "hello world"
    page_size = 42
    page_token = "hello world"

    fetch_model_server_versions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :fetch_model_server_versions, name
      assert_kind_of ::Google::Cloud::GkeRecommender::V1::FetchModelServerVersionsRequest, request
      assert_equal "hello world", request["model"]
      assert_equal "hello world", request["model_server"]
      assert_equal 42, request["page_size"]
      assert request.has_page_size?
      assert_equal "hello world", request["page_token"]
      assert request.has_page_token?
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, fetch_model_server_versions_client_stub do
      # Create client
      client = ::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.fetch_model_server_versions({ model: model, model_server: model_server, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.fetch_model_server_versions model: model, model_server: model_server, page_size: page_size, page_token: page_token do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.fetch_model_server_versions ::Google::Cloud::GkeRecommender::V1::FetchModelServerVersionsRequest.new(model: model, model_server: model_server, page_size: page_size, page_token: page_token) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.fetch_model_server_versions({ model: model, model_server: model_server, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.fetch_model_server_versions(::Google::Cloud::GkeRecommender::V1::FetchModelServerVersionsRequest.new(model: model, model_server: model_server, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, fetch_model_server_versions_client_stub.call_rpc_count
    end
  end

  def test_fetch_profiles
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::GkeRecommender::V1::FetchProfilesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    model = "hello world"
    model_server = "hello world"
    model_server_version = "hello world"
    performance_requirements = {}
    page_size = 42
    page_token = "hello world"

    fetch_profiles_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :fetch_profiles, name
      assert_kind_of ::Google::Cloud::GkeRecommender::V1::FetchProfilesRequest, request
      assert_equal "hello world", request["model"]
      assert_equal "hello world", request["model_server"]
      assert_equal "hello world", request["model_server_version"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::GkeRecommender::V1::PerformanceRequirements), request["performance_requirements"]
      assert_equal 42, request["page_size"]
      assert request.has_page_size?
      assert_equal "hello world", request["page_token"]
      assert request.has_page_token?
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, fetch_profiles_client_stub do
      # Create client
      client = ::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.fetch_profiles({ model: model, model_server: model_server, model_server_version: model_server_version, performance_requirements: performance_requirements, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.fetch_profiles model: model, model_server: model_server, model_server_version: model_server_version, performance_requirements: performance_requirements, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.fetch_profiles ::Google::Cloud::GkeRecommender::V1::FetchProfilesRequest.new(model: model, model_server: model_server, model_server_version: model_server_version, performance_requirements: performance_requirements, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.fetch_profiles({ model: model, model_server: model_server, model_server_version: model_server_version, performance_requirements: performance_requirements, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.fetch_profiles(::Google::Cloud::GkeRecommender::V1::FetchProfilesRequest.new(model: model, model_server: model_server, model_server_version: model_server_version, performance_requirements: performance_requirements, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, fetch_profiles_client_stub.call_rpc_count
    end
  end

  def test_generate_optimized_manifest
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::GkeRecommender::V1::GenerateOptimizedManifestResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    model_server_info = {}
    accelerator_type = "hello world"
    kubernetes_namespace = "hello world"
    performance_requirements = {}
    storage_config = {}

    generate_optimized_manifest_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :generate_optimized_manifest, name
      assert_kind_of ::Google::Cloud::GkeRecommender::V1::GenerateOptimizedManifestRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::GkeRecommender::V1::ModelServerInfo), request["model_server_info"]
      assert_equal "hello world", request["accelerator_type"]
      assert_equal "hello world", request["kubernetes_namespace"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::GkeRecommender::V1::PerformanceRequirements), request["performance_requirements"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::GkeRecommender::V1::StorageConfig), request["storage_config"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, generate_optimized_manifest_client_stub do
      # Create client
      client = ::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.generate_optimized_manifest({ model_server_info: model_server_info, accelerator_type: accelerator_type, kubernetes_namespace: kubernetes_namespace, performance_requirements: performance_requirements, storage_config: storage_config }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.generate_optimized_manifest model_server_info: model_server_info, accelerator_type: accelerator_type, kubernetes_namespace: kubernetes_namespace, performance_requirements: performance_requirements, storage_config: storage_config do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.generate_optimized_manifest ::Google::Cloud::GkeRecommender::V1::GenerateOptimizedManifestRequest.new(model_server_info: model_server_info, accelerator_type: accelerator_type, kubernetes_namespace: kubernetes_namespace, performance_requirements: performance_requirements, storage_config: storage_config) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.generate_optimized_manifest({ model_server_info: model_server_info, accelerator_type: accelerator_type, kubernetes_namespace: kubernetes_namespace, performance_requirements: performance_requirements, storage_config: storage_config }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.generate_optimized_manifest(::Google::Cloud::GkeRecommender::V1::GenerateOptimizedManifestRequest.new(model_server_info: model_server_info, accelerator_type: accelerator_type, kubernetes_namespace: kubernetes_namespace, performance_requirements: performance_requirements, storage_config: storage_config), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, generate_optimized_manifest_client_stub.call_rpc_count
    end
  end

  def test_fetch_benchmarking_data
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::GkeRecommender::V1::FetchBenchmarkingDataResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    model_server_info = {}
    instance_type = "hello world"
    pricing_model = "hello world"

    fetch_benchmarking_data_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :fetch_benchmarking_data, name
      assert_kind_of ::Google::Cloud::GkeRecommender::V1::FetchBenchmarkingDataRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::GkeRecommender::V1::ModelServerInfo), request["model_server_info"]
      assert_equal "hello world", request["instance_type"]
      assert_equal "hello world", request["pricing_model"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, fetch_benchmarking_data_client_stub do
      # Create client
      client = ::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.fetch_benchmarking_data({ model_server_info: model_server_info, instance_type: instance_type, pricing_model: pricing_model }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.fetch_benchmarking_data model_server_info: model_server_info, instance_type: instance_type, pricing_model: pricing_model do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.fetch_benchmarking_data ::Google::Cloud::GkeRecommender::V1::FetchBenchmarkingDataRequest.new(model_server_info: model_server_info, instance_type: instance_type, pricing_model: pricing_model) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.fetch_benchmarking_data({ model_server_info: model_server_info, instance_type: instance_type, pricing_model: pricing_model }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.fetch_benchmarking_data(::Google::Cloud::GkeRecommender::V1::FetchBenchmarkingDataRequest.new(model_server_info: model_server_info, instance_type: instance_type, pricing_model: pricing_model), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, fetch_benchmarking_data_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
