# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/gkerecommender/v1/gkerecommender_pb"
require "google/cloud/gke_recommender/v1/gke_inference_quickstart/rest"


class ::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_fetch_models
    # Create test objects.
    client_result = ::Google::Cloud::GkeRecommender::V1::FetchModelsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    page_size = 42
    page_token = "hello world"

    fetch_models_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Rest::ServiceStub.stub :transcode_fetch_models_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, fetch_models_client_stub do
        # Create client
        client = ::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.fetch_models({ page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.fetch_models page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.fetch_models ::Google::Cloud::GkeRecommender::V1::FetchModelsRequest.new(page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.fetch_models({ page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.fetch_models(::Google::Cloud::GkeRecommender::V1::FetchModelsRequest.new(page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, fetch_models_client_stub.call_count
      end
    end
  end

  def test_fetch_model_servers
    # Create test objects.
    client_result = ::Google::Cloud::GkeRecommender::V1::FetchModelServersResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    model = "hello world"
    page_size = 42
    page_token = "hello world"

    fetch_model_servers_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Rest::ServiceStub.stub :transcode_fetch_model_servers_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, fetch_model_servers_client_stub do
        # Create client
        client = ::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.fetch_model_servers({ model: model, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.fetch_model_servers model: model, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.fetch_model_servers ::Google::Cloud::GkeRecommender::V1::FetchModelServersRequest.new(model: model, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.fetch_model_servers({ model: model, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.fetch_model_servers(::Google::Cloud::GkeRecommender::V1::FetchModelServersRequest.new(model: model, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, fetch_model_servers_client_stub.call_count
      end
    end
  end

  def test_fetch_model_server_versions
    # Create test objects.
    client_result = ::Google::Cloud::GkeRecommender::V1::FetchModelServerVersionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    model = "hello world"
    model_server = "hello world"
    page_size = 42
    page_token = "hello world"

    fetch_model_server_versions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Rest::ServiceStub.stub :transcode_fetch_model_server_versions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, fetch_model_server_versions_client_stub do
        # Create client
        client = ::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.fetch_model_server_versions({ model: model, model_server: model_server, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.fetch_model_server_versions model: model, model_server: model_server, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.fetch_model_server_versions ::Google::Cloud::GkeRecommender::V1::FetchModelServerVersionsRequest.new(model: model, model_server: model_server, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.fetch_model_server_versions({ model: model, model_server: model_server, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.fetch_model_server_versions(::Google::Cloud::GkeRecommender::V1::FetchModelServerVersionsRequest.new(model: model, model_server: model_server, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, fetch_model_server_versions_client_stub.call_count
      end
    end
  end

  def test_fetch_profiles
    # Create test objects.
    client_result = ::Google::Cloud::GkeRecommender::V1::FetchProfilesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    model = "hello world"
    model_server = "hello world"
    model_server_version = "hello world"
    performance_requirements = {}
    page_size = 42
    page_token = "hello world"

    fetch_profiles_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Rest::ServiceStub.stub :transcode_fetch_profiles_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, fetch_profiles_client_stub do
        # Create client
        client = ::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.fetch_profiles({ model: model, model_server: model_server, model_server_version: model_server_version, performance_requirements: performance_requirements, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.fetch_profiles model: model, model_server: model_server, model_server_version: model_server_version, performance_requirements: performance_requirements, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.fetch_profiles ::Google::Cloud::GkeRecommender::V1::FetchProfilesRequest.new(model: model, model_server: model_server, model_server_version: model_server_version, performance_requirements: performance_requirements, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.fetch_profiles({ model: model, model_server: model_server, model_server_version: model_server_version, performance_requirements: performance_requirements, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.fetch_profiles(::Google::Cloud::GkeRecommender::V1::FetchProfilesRequest.new(model: model, model_server: model_server, model_server_version: model_server_version, performance_requirements: performance_requirements, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, fetch_profiles_client_stub.call_count
      end
    end
  end

  def test_generate_optimized_manifest
    # Create test objects.
    client_result = ::Google::Cloud::GkeRecommender::V1::GenerateOptimizedManifestResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    model_server_info = {}
    accelerator_type = "hello world"
    kubernetes_namespace = "hello world"
    performance_requirements = {}
    storage_config = {}

    generate_optimized_manifest_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Rest::ServiceStub.stub :transcode_generate_optimized_manifest_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, generate_optimized_manifest_client_stub do
        # Create client
        client = ::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.generate_optimized_manifest({ model_server_info: model_server_info, accelerator_type: accelerator_type, kubernetes_namespace: kubernetes_namespace, performance_requirements: performance_requirements, storage_config: storage_config }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.generate_optimized_manifest model_server_info: model_server_info, accelerator_type: accelerator_type, kubernetes_namespace: kubernetes_namespace, performance_requirements: performance_requirements, storage_config: storage_config do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.generate_optimized_manifest ::Google::Cloud::GkeRecommender::V1::GenerateOptimizedManifestRequest.new(model_server_info: model_server_info, accelerator_type: accelerator_type, kubernetes_namespace: kubernetes_namespace, performance_requirements: performance_requirements, storage_config: storage_config) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.generate_optimized_manifest({ model_server_info: model_server_info, accelerator_type: accelerator_type, kubernetes_namespace: kubernetes_namespace, performance_requirements: performance_requirements, storage_config: storage_config }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.generate_optimized_manifest(::Google::Cloud::GkeRecommender::V1::GenerateOptimizedManifestRequest.new(model_server_info: model_server_info, accelerator_type: accelerator_type, kubernetes_namespace: kubernetes_namespace, performance_requirements: performance_requirements, storage_config: storage_config), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, generate_optimized_manifest_client_stub.call_count
      end
    end
  end

  def test_fetch_benchmarking_data
    # Create test objects.
    client_result = ::Google::Cloud::GkeRecommender::V1::FetchBenchmarkingDataResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    model_server_info = {}
    instance_type = "hello world"
    pricing_model = "hello world"

    fetch_benchmarking_data_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Rest::ServiceStub.stub :transcode_fetch_benchmarking_data_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, fetch_benchmarking_data_client_stub do
        # Create client
        client = ::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.fetch_benchmarking_data({ model_server_info: model_server_info, instance_type: instance_type, pricing_model: pricing_model }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.fetch_benchmarking_data model_server_info: model_server_info, instance_type: instance_type, pricing_model: pricing_model do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.fetch_benchmarking_data ::Google::Cloud::GkeRecommender::V1::FetchBenchmarkingDataRequest.new(model_server_info: model_server_info, instance_type: instance_type, pricing_model: pricing_model) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.fetch_benchmarking_data({ model_server_info: model_server_info, instance_type: instance_type, pricing_model: pricing_model }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.fetch_benchmarking_data(::Google::Cloud::GkeRecommender::V1::FetchBenchmarkingDataRequest.new(model_server_info: model_server_info, instance_type: instance_type, pricing_model: pricing_model), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, fetch_benchmarking_data_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Rest::Client::Configuration, config
  end
end
