# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module GkeRecommender
      module V1
        # Request message for
        # {::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Client#fetch_models GkeInferenceQuickstart.FetchModels}.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The target number of results to return in a single response.
        #     If not specified, a default value will be chosen by the service.
        #     Note that the response may include a partial list and a caller should
        #     only rely on the response's
        #     {::Google::Cloud::GkeRecommender::V1::FetchModelsResponse#next_page_token next_page_token}
        #     to determine if there are more instances left to be queried.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The value of
        #     {::Google::Cloud::GkeRecommender::V1::FetchModelsResponse#next_page_token next_page_token}
        #     received from a previous `FetchModelsRequest` call.
        #     Provide this to retrieve the subsequent page in a multi-page list of
        #     results. When paginating, all other parameters provided to
        #     `FetchModelsRequest` must match the call that provided the page token.
        class FetchModelsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Client#fetch_models GkeInferenceQuickstart.FetchModels}.
        # @!attribute [r] models
        #   @return [::Array<::String>]
        #     Output only. List of available models. Open-source models follow the
        #     Huggingface Hub `owner/model_name` format.
        # @!attribute [r] next_page_token
        #   @return [::String]
        #     Output only. A token which may be sent as
        #     [page_token][FetchModelsResponse.page_token] in a subsequent
        #     `FetchModelsResponse` call to retrieve the next page of results.
        #     If this field is omitted or empty, then there are no more results to
        #     return.
        class FetchModelsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Client#fetch_model_servers GkeInferenceQuickstart.FetchModelServers}.
        # @!attribute [rw] model
        #   @return [::String]
        #     Required. The model for which to list model servers. Open-source models
        #     follow the Huggingface Hub `owner/model_name` format. Use
        #     {::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Client#fetch_models GkeInferenceQuickstart.FetchModels}
        #     to find available models.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The target number of results to return in a single response.
        #     If not specified, a default value will be chosen by the service.
        #     Note that the response may include a partial list and a caller should
        #     only rely on the response's
        #     {::Google::Cloud::GkeRecommender::V1::FetchModelServersResponse#next_page_token next_page_token}
        #     to determine if there are more instances left to be queried.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The value of
        #     {::Google::Cloud::GkeRecommender::V1::FetchModelServersResponse#next_page_token next_page_token}
        #     received from a previous `FetchModelServersRequest` call.
        #     Provide this to retrieve the subsequent page in a multi-page list of
        #     results. When paginating, all other parameters provided to
        #     `FetchModelServersRequest` must match the call that provided the page
        #     token.
        class FetchModelServersRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Client#fetch_model_servers GkeInferenceQuickstart.FetchModelServers}.
        # @!attribute [r] model_servers
        #   @return [::Array<::String>]
        #     Output only. List of available model servers. Open-source model servers use
        #     simplified, lowercase names (e.g., `vllm`).
        # @!attribute [r] next_page_token
        #   @return [::String]
        #     Output only. A token which may be sent as
        #     [page_token][FetchModelServersResponse.page_token] in a subsequent
        #     `FetchModelServersResponse` call to retrieve the next page of results.
        #     If this field is omitted or empty, then there are no more results to
        #     return.
        class FetchModelServersResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Client#fetch_model_server_versions GkeInferenceQuickstart.FetchModelServerVersions}.
        # @!attribute [rw] model
        #   @return [::String]
        #     Required. The model for which to list model server versions. Open-source
        #     models follow the Huggingface Hub `owner/model_name` format. Use
        #     {::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Client#fetch_models GkeInferenceQuickstart.FetchModels}
        #     to find available models.
        # @!attribute [rw] model_server
        #   @return [::String]
        #     Required. The model server for which to list versions. Open-source model
        #     servers use simplified, lowercase names (e.g., `vllm`). Use
        #     {::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Client#fetch_model_servers GkeInferenceQuickstart.FetchModelServers}
        #     to find available model servers.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The target number of results to return in a single response.
        #     If not specified, a default value will be chosen by the service.
        #     Note that the response may include a partial list and a caller should
        #     only rely on the response's
        #     {::Google::Cloud::GkeRecommender::V1::FetchModelServerVersionsResponse#next_page_token next_page_token}
        #     to determine if there are more instances left to be queried.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The value of
        #     {::Google::Cloud::GkeRecommender::V1::FetchModelServerVersionsResponse#next_page_token next_page_token}
        #     received from a previous `FetchModelServerVersionsRequest` call.
        #     Provide this to retrieve the subsequent page in a multi-page list of
        #     results. When paginating, all other parameters provided to
        #     `FetchModelServerVersionsRequest` must match the call that provided the
        #     page token.
        class FetchModelServerVersionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Client#fetch_model_server_versions GkeInferenceQuickstart.FetchModelServerVersions}.
        # @!attribute [r] model_server_versions
        #   @return [::Array<::String>]
        #     Output only. A list of available model server versions.
        # @!attribute [r] next_page_token
        #   @return [::String]
        #     Output only. A token which may be sent as
        #     [page_token][FetchModelServerVersionsResponse.page_token] in a subsequent
        #     `FetchModelServerVersionsResponse` call to retrieve the next page of
        #     results. If this field is omitted or empty, then there are no more results
        #     to return.
        class FetchModelServerVersionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Client#fetch_benchmarking_data GkeInferenceQuickstart.FetchBenchmarkingData}.
        # @!attribute [rw] model_server_info
        #   @return [::Google::Cloud::GkeRecommender::V1::ModelServerInfo]
        #     Required. The model server configuration to get benchmarking data for. Use
        #     {::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Client#fetch_profiles GkeInferenceQuickstart.FetchProfiles}
        #     to find valid configurations.
        # @!attribute [rw] instance_type
        #   @return [::String]
        #     Optional. The instance type to filter benchmarking data. Instance types are
        #     in the format `a2-highgpu-1g`. If not provided, all instance types for the
        #     given profile's `model_server_info` will be returned. Use
        #     {::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Client#fetch_profiles GkeInferenceQuickstart.FetchProfiles}
        #     to find available instance types.
        # @!attribute [rw] pricing_model
        #   @return [::String]
        #     Optional. The pricing model to use for the benchmarking data. Defaults to
        #     `spot`.
        class FetchBenchmarkingDataRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Client#fetch_benchmarking_data GkeInferenceQuickstart.FetchBenchmarkingData}.
        # @!attribute [r] profile
        #   @return [::Array<::Google::Cloud::GkeRecommender::V1::Profile>]
        #     Output only. List of profiles containing their respective benchmarking
        #     data.
        class FetchBenchmarkingDataResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Client#fetch_profiles GkeInferenceQuickstart.FetchProfiles}.
        # @!attribute [rw] model
        #   @return [::String]
        #     Optional. The model to filter profiles by. Open-source models follow the
        #     Huggingface Hub `owner/model_name` format. If not provided, all models are
        #     returned. Use
        #     {::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Client#fetch_models GkeInferenceQuickstart.FetchModels}
        #     to find available models.
        # @!attribute [rw] model_server
        #   @return [::String]
        #     Optional. The model server to filter profiles by. If not provided, all
        #     model servers are returned. Use
        #     {::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Client#fetch_model_servers GkeInferenceQuickstart.FetchModelServers}
        #     to find available model servers for a given model.
        # @!attribute [rw] model_server_version
        #   @return [::String]
        #     Optional. The model server version to filter profiles by. If not provided,
        #     all model server versions are returned. Use
        #     {::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Client#fetch_model_server_versions GkeInferenceQuickstart.FetchModelServerVersions}
        #     to find available versions for a given model and server.
        # @!attribute [rw] performance_requirements
        #   @return [::Google::Cloud::GkeRecommender::V1::PerformanceRequirements]
        #     Optional. The performance requirements to filter profiles. Profiles that do
        #     not meet these requirements are filtered out. If not provided, all profiles
        #     are returned.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The target number of results to return in a single response. If
        #     not specified, a default value will be chosen by the service. Note that the
        #     response may include a partial list and a caller should only rely on the
        #     response's
        #     {::Google::Cloud::GkeRecommender::V1::FetchProfilesResponse#next_page_token next_page_token}
        #     to determine if there are more instances left to be queried.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The value of
        #     {::Google::Cloud::GkeRecommender::V1::FetchProfilesResponse#next_page_token next_page_token}
        #     received from a previous `FetchProfilesRequest` call.
        #     Provide this to retrieve the subsequent page in a multi-page list of
        #     results. When paginating, all other parameters provided to
        #     `FetchProfilesRequest` must match the call that provided the page
        #     token.
        class FetchProfilesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Performance requirements for a profile and or model deployment.
        # @!attribute [rw] target_ntpot_milliseconds
        #   @return [::Integer]
        #     Optional. The target Normalized Time Per Output Token (NTPOT) in
        #     milliseconds. NTPOT is calculated as `request_latency /
        #     total_output_tokens`. If not provided, this target will not be enforced.
        # @!attribute [rw] target_ttft_milliseconds
        #   @return [::Integer]
        #     Optional. The target Time To First Token (TTFT) in milliseconds. TTFT is
        #     the time it takes to generate the first token for a request.  If not
        #     provided, this target will not be enforced.
        # @!attribute [rw] target_cost
        #   @return [::Google::Cloud::GkeRecommender::V1::Cost]
        #     Optional. The target cost for running a profile's model server. If not
        #     provided, this requirement will not be enforced.
        class PerformanceRequirements
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents an amount of money in a specific currency.
        # @!attribute [r] units
        #   @return [::Integer]
        #     Output only. The whole units of the amount.
        #     For example if `currencyCode` is `"USD"`, then 1 unit is one US dollar.
        # @!attribute [r] nanos
        #   @return [::Integer]
        #     Output only. Number of nano (10^-9) units of the amount.
        #     The value must be between -999,999,999 and +999,999,999 inclusive.
        #     If `units` is positive, `nanos` must be positive or zero.
        #     If `units` is zero, `nanos` can be positive, zero, or negative.
        #     If `units` is negative, `nanos` must be negative or zero.
        #     For example $-1.75 is represented as `units`=-1 and `nanos`=-750,000,000.
        class Amount
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Cost for running a model deployment on a given instance type. Currently, only
        # USD currency code is supported.
        # @!attribute [rw] cost_per_million_output_tokens
        #   @return [::Google::Cloud::GkeRecommender::V1::Amount]
        #     Optional. The cost per million output tokens, calculated as:
        #     $/output token = GPU $/s / (1/output-to-input-cost-ratio * input tokens/s +
        #     output tokens/s)
        # @!attribute [rw] cost_per_million_input_tokens
        #   @return [::Google::Cloud::GkeRecommender::V1::Amount]
        #     Optional. The cost per million input tokens. $/input token = ($/output
        #     token) / output-to-input-cost-ratio.
        # @!attribute [rw] pricing_model
        #   @return [::String]
        #     Optional. The pricing model used to calculate the cost. Can be one of:
        #     `3-years-cud`, `1-year-cud`, `on-demand`, `spot`. If not provided, `spot`
        #     will be used.
        # @!attribute [rw] output_input_cost_ratio
        #   @return [::Float]
        #     Optional. The output-to-input cost ratio. This determines how the total GPU
        #     cost is split between input and output tokens. If not provided, `4.0` is
        #     used, assuming a 4:1 output:input cost ratio.
        class Cost
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a range of throughput values in tokens per second.
        # @!attribute [r] min
        #   @return [::Integer]
        #     Output only. The minimum value of the range.
        # @!attribute [r] max
        #   @return [::Integer]
        #     Output only. The maximum value of the range.
        class TokensPerSecondRange
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a range of latency values in milliseconds.
        # @!attribute [r] min
        #   @return [::Integer]
        #     Output only. The minimum value of the range.
        # @!attribute [r] max
        #   @return [::Integer]
        #     Output only. The maximum value of the range.
        class MillisecondRange
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Performance range for a model deployment.
        # @!attribute [r] throughput_output_range
        #   @return [::Google::Cloud::GkeRecommender::V1::TokensPerSecondRange]
        #     Output only. The range of throughput in output tokens per second. This is
        #     measured as total_output_tokens_generated_by_server /
        #     elapsed_time_in_seconds.
        # @!attribute [r] ttft_range
        #   @return [::Google::Cloud::GkeRecommender::V1::MillisecondRange]
        #     Output only. The range of TTFT (Time To First Token) in milliseconds. TTFT
        #     is the time it takes to generate the first token for a request.
        # @!attribute [r] ntpot_range
        #   @return [::Google::Cloud::GkeRecommender::V1::MillisecondRange]
        #     Output only. The range of NTPOT (Normalized Time Per Output Token) in
        #     milliseconds. NTPOT is the request latency normalized by the number of
        #     output tokens, measured as request_latency / total_output_tokens.
        class PerformanceRange
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Client#fetch_profiles GkeInferenceQuickstart.FetchProfiles}.
        # @!attribute [r] profile
        #   @return [::Array<::Google::Cloud::GkeRecommender::V1::Profile>]
        #     Output only. List of profiles that match the given model server info and
        #     performance requirements (if provided).
        # @!attribute [r] performance_range
        #   @return [::Google::Cloud::GkeRecommender::V1::PerformanceRange]
        #     Output only. The combined range of performance values observed across all
        #     profiles in this response.
        # @!attribute [r] comments
        #   @return [::String]
        #     Output only. Additional comments related to the response.
        # @!attribute [r] next_page_token
        #   @return [::String]
        #     Output only. A token which may be sent as
        #     [page_token][FetchProfilesResponse.page_token] in a subsequent
        #     `FetchProfilesResponse` call to retrieve the next page of results. If this
        #     field is omitted or empty, then there are no more results to return.
        class FetchProfilesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Model server information gives. Valid model server info combinations can
        # be found using
        # {::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Client#fetch_profiles GkeInferenceQuickstart.FetchProfiles}.
        # @!attribute [rw] model
        #   @return [::String]
        #     Required. The model. Open-source models follow the Huggingface Hub
        #     `owner/model_name` format. Use
        #     {::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Client#fetch_models GkeInferenceQuickstart.FetchModels}
        #     to find available models.
        # @!attribute [rw] model_server
        #   @return [::String]
        #     Required. The model server. Open-source model servers use simplified,
        #     lowercase names (e.g., `vllm`). Use
        #     {::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Client#fetch_model_servers GkeInferenceQuickstart.FetchModelServers}
        #     to find available servers.
        # @!attribute [rw] model_server_version
        #   @return [::String]
        #     Optional. The model server version. Use
        #     {::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Client#fetch_model_server_versions GkeInferenceQuickstart.FetchModelServerVersions}
        #     to find available versions. If not provided, the latest available version
        #     is used.
        class ModelServerInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Resources used by a model deployment.
        # @!attribute [r] accelerator_count
        #   @return [::Integer]
        #     Output only. The number of accelerators (e.g., GPUs or TPUs) used by the
        #     model deployment on the Kubernetes node.
        class ResourcesUsed
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Performance statistics for a model deployment.
        # @!attribute [r] queries_per_second
        #   @return [::Float]
        #     Output only. The number of queries per second.
        #     Note: This metric can vary widely based on context length and may not be a
        #     reliable measure of LLM throughput.
        # @!attribute [r] output_tokens_per_second
        #   @return [::Integer]
        #     Output only. The number of output tokens per second. This is the throughput
        #     measured as total_output_tokens_generated_by_server /
        #     elapsed_time_in_seconds.
        # @!attribute [r] ntpot_milliseconds
        #   @return [::Integer]
        #     Output only. The Normalized Time Per Output Token (NTPOT) in milliseconds.
        #     This is the request latency normalized by the number of output tokens,
        #     measured as request_latency / total_output_tokens.
        # @!attribute [r] ttft_milliseconds
        #   @return [::Integer]
        #     Output only. The Time To First Token (TTFT) in milliseconds. This is the
        #     time it takes to generate the first token for a request.
        # @!attribute [r] cost
        #   @return [::Array<::Google::Cloud::GkeRecommender::V1::Cost>]
        #     Output only. The cost of running the model deployment.
        class PerformanceStats
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A profile containing information about a model deployment.
        # @!attribute [r] model_server_info
        #   @return [::Google::Cloud::GkeRecommender::V1::ModelServerInfo]
        #     Output only. The model server configuration. Use
        #     {::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Client#fetch_profiles GkeInferenceQuickstart.FetchProfiles}
        #     to find valid configurations.
        # @!attribute [r] accelerator_type
        #   @return [::String]
        #     Output only. The accelerator type. Expected format: `nvidia-h100-80gb`.
        # @!attribute [r] tpu_topology
        #   @return [::String]
        #     Output only. The TPU topology (if applicable).
        # @!attribute [r] instance_type
        #   @return [::String]
        #     Output only. The instance type. Expected format: `a2-highgpu-1g`.
        # @!attribute [r] resources_used
        #   @return [::Google::Cloud::GkeRecommender::V1::ResourcesUsed]
        #     Output only. The resources used by the model deployment.
        # @!attribute [r] performance_stats
        #   @return [::Array<::Google::Cloud::GkeRecommender::V1::PerformanceStats>]
        #     Output only. The performance statistics for this profile.
        class Profile
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Client#generate_optimized_manifest GkeInferenceQuickstart.GenerateOptimizedManifest}.
        # @!attribute [rw] model_server_info
        #   @return [::Google::Cloud::GkeRecommender::V1::ModelServerInfo]
        #     Required. The model server configuration to generate the manifest for. Use
        #     {::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Client#fetch_profiles GkeInferenceQuickstart.FetchProfiles}
        #     to find valid configurations.
        # @!attribute [rw] accelerator_type
        #   @return [::String]
        #     Required. The accelerator type. Use
        #     {::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Client#fetch_profiles GkeInferenceQuickstart.FetchProfiles}
        #     to find valid accelerators for a given `model_server_info`.
        # @!attribute [rw] kubernetes_namespace
        #   @return [::String]
        #     Optional. The kubernetes namespace to deploy the manifests in.
        # @!attribute [rw] performance_requirements
        #   @return [::Google::Cloud::GkeRecommender::V1::PerformanceRequirements]
        #     Optional. The performance requirements to use for generating Horizontal Pod
        #     Autoscaler (HPA) resources. If provided, the manifest includes HPA
        #     resources to adjust the model server replica count to maintain the
        #     specified targets (e.g., NTPOT, TTFT) at a P50 latency. Cost targets are
        #     not currently supported for HPA generation. If the specified targets are
        #     not achievable, the HPA manifest will not be generated.
        # @!attribute [rw] storage_config
        #   @return [::Google::Cloud::GkeRecommender::V1::StorageConfig]
        #     Optional. The storage configuration for the model. If not provided, the
        #     model is loaded from Huggingface.
        class GenerateOptimizedManifestRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A Kubernetes manifest.
        # @!attribute [r] kind
        #   @return [::String]
        #     Output only. Kubernetes resource kind.
        # @!attribute [r] api_version
        #   @return [::String]
        #     Output only. Kubernetes API version.
        # @!attribute [r] content
        #   @return [::String]
        #     Output only. YAML content.
        class KubernetesManifest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Client#generate_optimized_manifest GkeInferenceQuickstart.GenerateOptimizedManifest}.
        # @!attribute [r] kubernetes_manifests
        #   @return [::Array<::Google::Cloud::GkeRecommender::V1::KubernetesManifest>]
        #     Output only. A list of generated Kubernetes manifests.
        # @!attribute [r] comments
        #   @return [::Array<::String>]
        #     Output only. Comments related to deploying the generated manifests.
        # @!attribute [r] manifest_version
        #   @return [::String]
        #     Output only. Additional information about the versioned dependencies used
        #     to generate the manifests. See [Run best practice inference with GKE
        #     Inference Quickstart
        #     recipes](https://cloud.google.com/kubernetes-engine/docs/how-to/machine-learning/inference/inference-quickstart)
        #     for details.
        class GenerateOptimizedManifestResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Storage configuration for a model deployment.
        # @!attribute [rw] model_bucket_uri
        #   @return [::String]
        #     Optional. The Google Cloud Storage bucket URI to load the model from. This
        #     URI must point to the directory containing the model's config file
        #     (`config.json`) and model weights. A tuned GCSFuse setup can improve
        #     LLM Pod startup time by more than 7x. Expected format:
        #     `gs://<bucket-name>/<path-to-model>`.
        # @!attribute [rw] xla_cache_bucket_uri
        #   @return [::String]
        #     Optional. The URI for the GCS bucket containing the XLA compilation cache.
        #     If using TPUs, the XLA cache will be written to the same path as
        #     `model_bucket_uri`. This can speed up vLLM model preparation for repeated
        #     deployments.
        class StorageConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
