# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/cloud/gkerecommender/v1/gkerecommender.proto for package 'Google.Cloud.GkeRecommender.V1'
# Original file comments:
# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/cloud/gkerecommender/v1/gkerecommender_pb'

module Google
  module Cloud
    module GkeRecommender
      module V1
        module GkeInferenceQuickstart
          # GKE Inference Quickstart (GIQ) service provides profiles with performance
          # metrics for popular models and model servers across multiple accelerators.
          # These profiles help generate optimized best practices for running inference
          # on GKE.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.cloud.gkerecommender.v1.GkeInferenceQuickstart'

            # Fetches available models. Open-source models follow the Huggingface Hub
            # `owner/model_name` format.
            rpc :FetchModels, ::Google::Cloud::GkeRecommender::V1::FetchModelsRequest, ::Google::Cloud::GkeRecommender::V1::FetchModelsResponse
            # Fetches available model servers. Open-source model servers use simplified,
            # lowercase names (e.g., `vllm`).
            rpc :FetchModelServers, ::Google::Cloud::GkeRecommender::V1::FetchModelServersRequest, ::Google::Cloud::GkeRecommender::V1::FetchModelServersResponse
            # Fetches available model server versions. Open-source servers use their own
            # versioning schemas (e.g., `vllm` uses semver like `v1.0.0`).
            #
            # Some model servers have different versioning schemas depending on the
            # accelerator. For example, `vllm` uses semver on GPUs, but returns nightly
            # build tags on TPUs. All available versions will be returned when different
            # schemas are present.
            rpc :FetchModelServerVersions, ::Google::Cloud::GkeRecommender::V1::FetchModelServerVersionsRequest, ::Google::Cloud::GkeRecommender::V1::FetchModelServerVersionsResponse
            # Fetches available profiles. A profile contains performance metrics and
            # cost information for a specific model server setup. Profiles can be
            # filtered by parameters. If no filters are provided, all profiles are
            # returned.
            #
            # Profiles display a single value per performance metric based on the
            # provided performance requirements. If no requirements are given, the
            # metrics represent the inflection point. See [Run best practice inference
            # with GKE Inference Quickstart
            # recipes](https://cloud.google.com/kubernetes-engine/docs/how-to/machine-learning/inference/inference-quickstart#how)
            # for details.
            rpc :FetchProfiles, ::Google::Cloud::GkeRecommender::V1::FetchProfilesRequest, ::Google::Cloud::GkeRecommender::V1::FetchProfilesResponse
            # Generates an optimized deployment manifest for a given model and model
            # server, based on the specified accelerator, performance targets, and
            # configurations. See [Run best practice inference with GKE Inference
            # Quickstart
            # recipes](https://cloud.google.com/kubernetes-engine/docs/how-to/machine-learning/inference/inference-quickstart)
            # for deployment details.
            rpc :GenerateOptimizedManifest, ::Google::Cloud::GkeRecommender::V1::GenerateOptimizedManifestRequest, ::Google::Cloud::GkeRecommender::V1::GenerateOptimizedManifestResponse
            # Fetches all of the benchmarking data available for a profile. Benchmarking
            # data returns all of the performance metrics available for a given model
            # server setup on a given instance type.
            rpc :FetchBenchmarkingData, ::Google::Cloud::GkeRecommender::V1::FetchBenchmarkingDataRequest, ::Google::Cloud::GkeRecommender::V1::FetchBenchmarkingDataResponse
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
