# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/gkerecommender/v1/gkerecommender_pb"
require "google/cloud/gke_recommender/v1/gke_inference_quickstart/rest/service_stub"

module Google
  module Cloud
    module GkeRecommender
      module V1
        module GkeInferenceQuickstart
          module Rest
            ##
            # REST client for the GkeInferenceQuickstart service.
            #
            # GKE Inference Quickstart (GIQ) service provides profiles with performance
            # metrics for popular models and model servers across multiple accelerators.
            # These profiles help generate optimized best practices for running inference
            # on GKE.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "gkerecommender.$UNIVERSE_DOMAIN$"

              # @private
              attr_reader :gke_inference_quickstart_stub

              ##
              # Configure the GkeInferenceQuickstart Client class.
              #
              # See {::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all GkeInferenceQuickstart clients
              #   ::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "GkeRecommender", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.fetch_models.timeout = 60.0

                  default_config.rpcs.fetch_model_servers.timeout = 60.0

                  default_config.rpcs.fetch_model_server_versions.timeout = 60.0

                  default_config.rpcs.fetch_profiles.timeout = 60.0

                  default_config.rpcs.generate_optimized_manifest.timeout = 60.0

                  default_config.rpcs.fetch_benchmarking_data.timeout = 60.0

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the GkeInferenceQuickstart Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @gke_inference_quickstart_stub.universe_domain
              end

              ##
              # Create a new GkeInferenceQuickstart REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the GkeInferenceQuickstart client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @gke_inference_quickstart_stub = ::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @gke_inference_quickstart_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end
              end

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @gke_inference_quickstart_stub.logger
              end

              # Service calls

              ##
              # Fetches available models. Open-source models follow the Huggingface Hub
              # `owner/model_name` format.
              #
              # @overload fetch_models(request, options = nil)
              #   Pass arguments to `fetch_models` via a request object, either of type
              #   {::Google::Cloud::GkeRecommender::V1::FetchModelsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GkeRecommender::V1::FetchModelsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload fetch_models(page_size: nil, page_token: nil)
              #   Pass arguments to `fetch_models` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param page_size [::Integer]
              #     Optional. The target number of results to return in a single response.
              #     If not specified, a default value will be chosen by the service.
              #     Note that the response may include a partial list and a caller should
              #     only rely on the response's
              #     {::Google::Cloud::GkeRecommender::V1::FetchModelsResponse#next_page_token next_page_token}
              #     to determine if there are more instances left to be queried.
              #   @param page_token [::String]
              #     Optional. The value of
              #     {::Google::Cloud::GkeRecommender::V1::FetchModelsResponse#next_page_token next_page_token}
              #     received from a previous `FetchModelsRequest` call.
              #     Provide this to retrieve the subsequent page in a multi-page list of
              #     results. When paginating, all other parameters provided to
              #     `FetchModelsRequest` must match the call that provided the page token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::GkeRecommender::V1::FetchModelsResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::GkeRecommender::V1::FetchModelsResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gke_recommender/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GkeRecommender::V1::FetchModelsRequest.new
              #
              #   # Call the fetch_models method.
              #   result = client.fetch_models request
              #
              #   # The returned object is of type Google::Cloud::GkeRecommender::V1::FetchModelsResponse.
              #   p result
              #
              def fetch_models request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeRecommender::V1::FetchModelsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.fetch_models.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GkeRecommender::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.fetch_models.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.fetch_models.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @gke_inference_quickstart_stub.fetch_models request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Fetches available model servers. Open-source model servers use simplified,
              # lowercase names (e.g., `vllm`).
              #
              # @overload fetch_model_servers(request, options = nil)
              #   Pass arguments to `fetch_model_servers` via a request object, either of type
              #   {::Google::Cloud::GkeRecommender::V1::FetchModelServersRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GkeRecommender::V1::FetchModelServersRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload fetch_model_servers(model: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `fetch_model_servers` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param model [::String]
              #     Required. The model for which to list model servers. Open-source models
              #     follow the Huggingface Hub `owner/model_name` format. Use
              #     {::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Rest::Client#fetch_models GkeInferenceQuickstart.FetchModels}
              #     to find available models.
              #   @param page_size [::Integer]
              #     Optional. The target number of results to return in a single response.
              #     If not specified, a default value will be chosen by the service.
              #     Note that the response may include a partial list and a caller should
              #     only rely on the response's
              #     {::Google::Cloud::GkeRecommender::V1::FetchModelServersResponse#next_page_token next_page_token}
              #     to determine if there are more instances left to be queried.
              #   @param page_token [::String]
              #     Optional. The value of
              #     {::Google::Cloud::GkeRecommender::V1::FetchModelServersResponse#next_page_token next_page_token}
              #     received from a previous `FetchModelServersRequest` call.
              #     Provide this to retrieve the subsequent page in a multi-page list of
              #     results. When paginating, all other parameters provided to
              #     `FetchModelServersRequest` must match the call that provided the page
              #     token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::GkeRecommender::V1::FetchModelServersResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::GkeRecommender::V1::FetchModelServersResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gke_recommender/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GkeRecommender::V1::FetchModelServersRequest.new
              #
              #   # Call the fetch_model_servers method.
              #   result = client.fetch_model_servers request
              #
              #   # The returned object is of type Google::Cloud::GkeRecommender::V1::FetchModelServersResponse.
              #   p result
              #
              def fetch_model_servers request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeRecommender::V1::FetchModelServersRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.fetch_model_servers.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GkeRecommender::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.fetch_model_servers.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.fetch_model_servers.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @gke_inference_quickstart_stub.fetch_model_servers request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Fetches available model server versions. Open-source servers use their own
              # versioning schemas (e.g., `vllm` uses semver like `v1.0.0`).
              #
              # Some model servers have different versioning schemas depending on the
              # accelerator. For example, `vllm` uses semver on GPUs, but returns nightly
              # build tags on TPUs. All available versions will be returned when different
              # schemas are present.
              #
              # @overload fetch_model_server_versions(request, options = nil)
              #   Pass arguments to `fetch_model_server_versions` via a request object, either of type
              #   {::Google::Cloud::GkeRecommender::V1::FetchModelServerVersionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GkeRecommender::V1::FetchModelServerVersionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload fetch_model_server_versions(model: nil, model_server: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `fetch_model_server_versions` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param model [::String]
              #     Required. The model for which to list model server versions. Open-source
              #     models follow the Huggingface Hub `owner/model_name` format. Use
              #     {::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Rest::Client#fetch_models GkeInferenceQuickstart.FetchModels}
              #     to find available models.
              #   @param model_server [::String]
              #     Required. The model server for which to list versions. Open-source model
              #     servers use simplified, lowercase names (e.g., `vllm`). Use
              #     {::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Rest::Client#fetch_model_servers GkeInferenceQuickstart.FetchModelServers}
              #     to find available model servers.
              #   @param page_size [::Integer]
              #     Optional. The target number of results to return in a single response.
              #     If not specified, a default value will be chosen by the service.
              #     Note that the response may include a partial list and a caller should
              #     only rely on the response's
              #     {::Google::Cloud::GkeRecommender::V1::FetchModelServerVersionsResponse#next_page_token next_page_token}
              #     to determine if there are more instances left to be queried.
              #   @param page_token [::String]
              #     Optional. The value of
              #     {::Google::Cloud::GkeRecommender::V1::FetchModelServerVersionsResponse#next_page_token next_page_token}
              #     received from a previous `FetchModelServerVersionsRequest` call.
              #     Provide this to retrieve the subsequent page in a multi-page list of
              #     results. When paginating, all other parameters provided to
              #     `FetchModelServerVersionsRequest` must match the call that provided the
              #     page token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::GkeRecommender::V1::FetchModelServerVersionsResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::GkeRecommender::V1::FetchModelServerVersionsResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gke_recommender/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GkeRecommender::V1::FetchModelServerVersionsRequest.new
              #
              #   # Call the fetch_model_server_versions method.
              #   result = client.fetch_model_server_versions request
              #
              #   # The returned object is of type Google::Cloud::GkeRecommender::V1::FetchModelServerVersionsResponse.
              #   p result
              #
              def fetch_model_server_versions request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeRecommender::V1::FetchModelServerVersionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.fetch_model_server_versions.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GkeRecommender::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.fetch_model_server_versions.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.fetch_model_server_versions.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @gke_inference_quickstart_stub.fetch_model_server_versions request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Fetches available profiles. A profile contains performance metrics and
              # cost information for a specific model server setup. Profiles can be
              # filtered by parameters. If no filters are provided, all profiles are
              # returned.
              #
              # Profiles display a single value per performance metric based on the
              # provided performance requirements. If no requirements are given, the
              # metrics represent the inflection point. See [Run best practice inference
              # with GKE Inference Quickstart
              # recipes](https://cloud.google.com/kubernetes-engine/docs/how-to/machine-learning/inference/inference-quickstart#how)
              # for details.
              #
              # @overload fetch_profiles(request, options = nil)
              #   Pass arguments to `fetch_profiles` via a request object, either of type
              #   {::Google::Cloud::GkeRecommender::V1::FetchProfilesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GkeRecommender::V1::FetchProfilesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload fetch_profiles(model: nil, model_server: nil, model_server_version: nil, performance_requirements: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `fetch_profiles` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param model [::String]
              #     Optional. The model to filter profiles by. Open-source models follow the
              #     Huggingface Hub `owner/model_name` format. If not provided, all models are
              #     returned. Use
              #     {::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Rest::Client#fetch_models GkeInferenceQuickstart.FetchModels}
              #     to find available models.
              #   @param model_server [::String]
              #     Optional. The model server to filter profiles by. If not provided, all
              #     model servers are returned. Use
              #     {::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Rest::Client#fetch_model_servers GkeInferenceQuickstart.FetchModelServers}
              #     to find available model servers for a given model.
              #   @param model_server_version [::String]
              #     Optional. The model server version to filter profiles by. If not provided,
              #     all model server versions are returned. Use
              #     {::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Rest::Client#fetch_model_server_versions GkeInferenceQuickstart.FetchModelServerVersions}
              #     to find available versions for a given model and server.
              #   @param performance_requirements [::Google::Cloud::GkeRecommender::V1::PerformanceRequirements, ::Hash]
              #     Optional. The performance requirements to filter profiles. Profiles that do
              #     not meet these requirements are filtered out. If not provided, all profiles
              #     are returned.
              #   @param page_size [::Integer]
              #     Optional. The target number of results to return in a single response. If
              #     not specified, a default value will be chosen by the service. Note that the
              #     response may include a partial list and a caller should only rely on the
              #     response's
              #     {::Google::Cloud::GkeRecommender::V1::FetchProfilesResponse#next_page_token next_page_token}
              #     to determine if there are more instances left to be queried.
              #   @param page_token [::String]
              #     Optional. The value of
              #     {::Google::Cloud::GkeRecommender::V1::FetchProfilesResponse#next_page_token next_page_token}
              #     received from a previous `FetchProfilesRequest` call.
              #     Provide this to retrieve the subsequent page in a multi-page list of
              #     results. When paginating, all other parameters provided to
              #     `FetchProfilesRequest` must match the call that provided the page
              #     token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::GkeRecommender::V1::Profile>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::GkeRecommender::V1::Profile>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gke_recommender/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GkeRecommender::V1::FetchProfilesRequest.new
              #
              #   # Call the fetch_profiles method.
              #   result = client.fetch_profiles request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::GkeRecommender::V1::Profile.
              #     p item
              #   end
              #
              def fetch_profiles request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeRecommender::V1::FetchProfilesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.fetch_profiles.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GkeRecommender::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.fetch_profiles.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.fetch_profiles.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @gke_inference_quickstart_stub.fetch_profiles request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @gke_inference_quickstart_stub, :fetch_profiles, "profile", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Generates an optimized deployment manifest for a given model and model
              # server, based on the specified accelerator, performance targets, and
              # configurations. See [Run best practice inference with GKE Inference
              # Quickstart
              # recipes](https://cloud.google.com/kubernetes-engine/docs/how-to/machine-learning/inference/inference-quickstart)
              # for deployment details.
              #
              # @overload generate_optimized_manifest(request, options = nil)
              #   Pass arguments to `generate_optimized_manifest` via a request object, either of type
              #   {::Google::Cloud::GkeRecommender::V1::GenerateOptimizedManifestRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GkeRecommender::V1::GenerateOptimizedManifestRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload generate_optimized_manifest(model_server_info: nil, accelerator_type: nil, kubernetes_namespace: nil, performance_requirements: nil, storage_config: nil)
              #   Pass arguments to `generate_optimized_manifest` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param model_server_info [::Google::Cloud::GkeRecommender::V1::ModelServerInfo, ::Hash]
              #     Required. The model server configuration to generate the manifest for. Use
              #     {::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Rest::Client#fetch_profiles GkeInferenceQuickstart.FetchProfiles}
              #     to find valid configurations.
              #   @param accelerator_type [::String]
              #     Required. The accelerator type. Use
              #     {::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Rest::Client#fetch_profiles GkeInferenceQuickstart.FetchProfiles}
              #     to find valid accelerators for a given `model_server_info`.
              #   @param kubernetes_namespace [::String]
              #     Optional. The kubernetes namespace to deploy the manifests in.
              #   @param performance_requirements [::Google::Cloud::GkeRecommender::V1::PerformanceRequirements, ::Hash]
              #     Optional. The performance requirements to use for generating Horizontal Pod
              #     Autoscaler (HPA) resources. If provided, the manifest includes HPA
              #     resources to adjust the model server replica count to maintain the
              #     specified targets (e.g., NTPOT, TTFT) at a P50 latency. Cost targets are
              #     not currently supported for HPA generation. If the specified targets are
              #     not achievable, the HPA manifest will not be generated.
              #   @param storage_config [::Google::Cloud::GkeRecommender::V1::StorageConfig, ::Hash]
              #     Optional. The storage configuration for the model. If not provided, the
              #     model is loaded from Huggingface.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::GkeRecommender::V1::GenerateOptimizedManifestResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::GkeRecommender::V1::GenerateOptimizedManifestResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gke_recommender/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GkeRecommender::V1::GenerateOptimizedManifestRequest.new
              #
              #   # Call the generate_optimized_manifest method.
              #   result = client.generate_optimized_manifest request
              #
              #   # The returned object is of type Google::Cloud::GkeRecommender::V1::GenerateOptimizedManifestResponse.
              #   p result
              #
              def generate_optimized_manifest request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeRecommender::V1::GenerateOptimizedManifestRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.generate_optimized_manifest.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GkeRecommender::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.generate_optimized_manifest.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.generate_optimized_manifest.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @gke_inference_quickstart_stub.generate_optimized_manifest request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Fetches all of the benchmarking data available for a profile. Benchmarking
              # data returns all of the performance metrics available for a given model
              # server setup on a given instance type.
              #
              # @overload fetch_benchmarking_data(request, options = nil)
              #   Pass arguments to `fetch_benchmarking_data` via a request object, either of type
              #   {::Google::Cloud::GkeRecommender::V1::FetchBenchmarkingDataRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GkeRecommender::V1::FetchBenchmarkingDataRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload fetch_benchmarking_data(model_server_info: nil, instance_type: nil, pricing_model: nil)
              #   Pass arguments to `fetch_benchmarking_data` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param model_server_info [::Google::Cloud::GkeRecommender::V1::ModelServerInfo, ::Hash]
              #     Required. The model server configuration to get benchmarking data for. Use
              #     {::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Rest::Client#fetch_profiles GkeInferenceQuickstart.FetchProfiles}
              #     to find valid configurations.
              #   @param instance_type [::String]
              #     Optional. The instance type to filter benchmarking data. Instance types are
              #     in the format `a2-highgpu-1g`. If not provided, all instance types for the
              #     given profile's `model_server_info` will be returned. Use
              #     {::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Rest::Client#fetch_profiles GkeInferenceQuickstart.FetchProfiles}
              #     to find available instance types.
              #   @param pricing_model [::String]
              #     Optional. The pricing model to use for the benchmarking data. Defaults to
              #     `spot`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::GkeRecommender::V1::FetchBenchmarkingDataResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::GkeRecommender::V1::FetchBenchmarkingDataResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gke_recommender/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GkeRecommender::V1::FetchBenchmarkingDataRequest.new
              #
              #   # Call the fetch_benchmarking_data method.
              #   result = client.fetch_benchmarking_data request
              #
              #   # The returned object is of type Google::Cloud::GkeRecommender::V1::FetchBenchmarkingDataResponse.
              #   p result
              #
              def fetch_benchmarking_data request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeRecommender::V1::FetchBenchmarkingDataRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.fetch_benchmarking_data.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GkeRecommender::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.fetch_benchmarking_data.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.fetch_benchmarking_data.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @gke_inference_quickstart_stub.fetch_benchmarking_data request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the GkeInferenceQuickstart REST API.
              #
              # This class represents the configuration for GkeInferenceQuickstart REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # fetch_models to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.fetch_models.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.fetch_models.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "gkerecommender.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the GkeInferenceQuickstart API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `fetch_models`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :fetch_models
                  ##
                  # RPC-specific configuration for `fetch_model_servers`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :fetch_model_servers
                  ##
                  # RPC-specific configuration for `fetch_model_server_versions`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :fetch_model_server_versions
                  ##
                  # RPC-specific configuration for `fetch_profiles`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :fetch_profiles
                  ##
                  # RPC-specific configuration for `generate_optimized_manifest`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :generate_optimized_manifest
                  ##
                  # RPC-specific configuration for `fetch_benchmarking_data`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :fetch_benchmarking_data

                  # @private
                  def initialize parent_rpcs = nil
                    fetch_models_config = parent_rpcs.fetch_models if parent_rpcs.respond_to? :fetch_models
                    @fetch_models = ::Gapic::Config::Method.new fetch_models_config
                    fetch_model_servers_config = parent_rpcs.fetch_model_servers if parent_rpcs.respond_to? :fetch_model_servers
                    @fetch_model_servers = ::Gapic::Config::Method.new fetch_model_servers_config
                    fetch_model_server_versions_config = parent_rpcs.fetch_model_server_versions if parent_rpcs.respond_to? :fetch_model_server_versions
                    @fetch_model_server_versions = ::Gapic::Config::Method.new fetch_model_server_versions_config
                    fetch_profiles_config = parent_rpcs.fetch_profiles if parent_rpcs.respond_to? :fetch_profiles
                    @fetch_profiles = ::Gapic::Config::Method.new fetch_profiles_config
                    generate_optimized_manifest_config = parent_rpcs.generate_optimized_manifest if parent_rpcs.respond_to? :generate_optimized_manifest
                    @generate_optimized_manifest = ::Gapic::Config::Method.new generate_optimized_manifest_config
                    fetch_benchmarking_data_config = parent_rpcs.fetch_benchmarking_data if parent_rpcs.respond_to? :fetch_benchmarking_data
                    @fetch_benchmarking_data = ::Gapic::Config::Method.new fetch_benchmarking_data_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
