# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/common"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/gke_recommender/v1/version"

require "google/cloud/gke_recommender/v1/gke_inference_quickstart/credentials"
require "google/cloud/gke_recommender/v1/gke_inference_quickstart/client"
require "google/cloud/gke_recommender/v1/gke_inference_quickstart/rest"

module Google
  module Cloud
    module GkeRecommender
      module V1
        ##
        # GKE Inference Quickstart (GIQ) service provides profiles with performance
        # metrics for popular models and model servers across multiple accelerators.
        # These profiles help generate optimized best practices for running inference
        # on GKE.
        #
        # @example Load this service and instantiate a gRPC client
        #
        #     require "google/cloud/gke_recommender/v1/gke_inference_quickstart"
        #     client = ::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Client.new
        #
        # @example Load this service and instantiate a REST client
        #
        #     require "google/cloud/gke_recommender/v1/gke_inference_quickstart/rest"
        #     client = ::Google::Cloud::GkeRecommender::V1::GkeInferenceQuickstart::Rest::Client.new
        #
        module GkeInferenceQuickstart
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "gke_inference_quickstart", "helpers.rb"
require "google/cloud/gke_recommender/v1/gke_inference_quickstart/helpers" if ::File.file? helper_path
