# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/gkemulticloud/v1/azure_service_pb"
require "google/cloud/gke_multi_cloud/v1/azure_clusters"

class ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_azure_client
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    azure_client = {}
    azure_client_id = "hello world"
    validate_only = true

    create_azure_client_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_azure_client, name
      assert_kind_of ::Google::Cloud::GkeMultiCloud::V1::CreateAzureClientRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::GkeMultiCloud::V1::AzureClient), request["azure_client"]
      assert_equal "hello world", request["azure_client_id"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_azure_client_client_stub do
      # Create client
      client = ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_azure_client({ parent: parent, azure_client: azure_client, azure_client_id: azure_client_id, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_azure_client parent: parent, azure_client: azure_client, azure_client_id: azure_client_id, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_azure_client ::Google::Cloud::GkeMultiCloud::V1::CreateAzureClientRequest.new(parent: parent, azure_client: azure_client, azure_client_id: azure_client_id, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_azure_client({ parent: parent, azure_client: azure_client, azure_client_id: azure_client_id, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_azure_client(::Google::Cloud::GkeMultiCloud::V1::CreateAzureClientRequest.new(parent: parent, azure_client: azure_client, azure_client_id: azure_client_id, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_azure_client_client_stub.call_rpc_count
    end
  end

  def test_get_azure_client
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::GkeMultiCloud::V1::AzureClient.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_azure_client_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_azure_client, name
      assert_kind_of ::Google::Cloud::GkeMultiCloud::V1::GetAzureClientRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_azure_client_client_stub do
      # Create client
      client = ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_azure_client({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_azure_client name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_azure_client ::Google::Cloud::GkeMultiCloud::V1::GetAzureClientRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_azure_client({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_azure_client(::Google::Cloud::GkeMultiCloud::V1::GetAzureClientRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_azure_client_client_stub.call_rpc_count
    end
  end

  def test_list_azure_clients
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::GkeMultiCloud::V1::ListAzureClientsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_azure_clients_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_azure_clients, name
      assert_kind_of ::Google::Cloud::GkeMultiCloud::V1::ListAzureClientsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_azure_clients_client_stub do
      # Create client
      client = ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_azure_clients({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_azure_clients parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_azure_clients ::Google::Cloud::GkeMultiCloud::V1::ListAzureClientsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_azure_clients({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_azure_clients(::Google::Cloud::GkeMultiCloud::V1::ListAzureClientsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_azure_clients_client_stub.call_rpc_count
    end
  end

  def test_delete_azure_client
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    allow_missing = true
    validate_only = true

    delete_azure_client_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_azure_client, name
      assert_kind_of ::Google::Cloud::GkeMultiCloud::V1::DeleteAzureClientRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["allow_missing"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_azure_client_client_stub do
      # Create client
      client = ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_azure_client({ name: name, allow_missing: allow_missing, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_azure_client name: name, allow_missing: allow_missing, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_azure_client ::Google::Cloud::GkeMultiCloud::V1::DeleteAzureClientRequest.new(name: name, allow_missing: allow_missing, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_azure_client({ name: name, allow_missing: allow_missing, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_azure_client(::Google::Cloud::GkeMultiCloud::V1::DeleteAzureClientRequest.new(name: name, allow_missing: allow_missing, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_azure_client_client_stub.call_rpc_count
    end
  end

  def test_create_azure_cluster
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    azure_cluster = {}
    azure_cluster_id = "hello world"
    validate_only = true

    create_azure_cluster_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_azure_cluster, name
      assert_kind_of ::Google::Cloud::GkeMultiCloud::V1::CreateAzureClusterRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::GkeMultiCloud::V1::AzureCluster), request["azure_cluster"]
      assert_equal "hello world", request["azure_cluster_id"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_azure_cluster_client_stub do
      # Create client
      client = ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_azure_cluster({ parent: parent, azure_cluster: azure_cluster, azure_cluster_id: azure_cluster_id, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_azure_cluster parent: parent, azure_cluster: azure_cluster, azure_cluster_id: azure_cluster_id, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_azure_cluster ::Google::Cloud::GkeMultiCloud::V1::CreateAzureClusterRequest.new(parent: parent, azure_cluster: azure_cluster, azure_cluster_id: azure_cluster_id, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_azure_cluster({ parent: parent, azure_cluster: azure_cluster, azure_cluster_id: azure_cluster_id, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_azure_cluster(::Google::Cloud::GkeMultiCloud::V1::CreateAzureClusterRequest.new(parent: parent, azure_cluster: azure_cluster, azure_cluster_id: azure_cluster_id, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_azure_cluster_client_stub.call_rpc_count
    end
  end

  def test_update_azure_cluster
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    azure_cluster = {}
    validate_only = true
    update_mask = {}

    update_azure_cluster_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_azure_cluster, name
      assert_kind_of ::Google::Cloud::GkeMultiCloud::V1::UpdateAzureClusterRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::GkeMultiCloud::V1::AzureCluster), request["azure_cluster"]
      assert_equal true, request["validate_only"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_azure_cluster_client_stub do
      # Create client
      client = ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_azure_cluster({ azure_cluster: azure_cluster, validate_only: validate_only, update_mask: update_mask }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_azure_cluster azure_cluster: azure_cluster, validate_only: validate_only, update_mask: update_mask do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_azure_cluster ::Google::Cloud::GkeMultiCloud::V1::UpdateAzureClusterRequest.new(azure_cluster: azure_cluster, validate_only: validate_only, update_mask: update_mask) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_azure_cluster({ azure_cluster: azure_cluster, validate_only: validate_only, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_azure_cluster(::Google::Cloud::GkeMultiCloud::V1::UpdateAzureClusterRequest.new(azure_cluster: azure_cluster, validate_only: validate_only, update_mask: update_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_azure_cluster_client_stub.call_rpc_count
    end
  end

  def test_get_azure_cluster
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::GkeMultiCloud::V1::AzureCluster.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_azure_cluster_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_azure_cluster, name
      assert_kind_of ::Google::Cloud::GkeMultiCloud::V1::GetAzureClusterRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_azure_cluster_client_stub do
      # Create client
      client = ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_azure_cluster({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_azure_cluster name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_azure_cluster ::Google::Cloud::GkeMultiCloud::V1::GetAzureClusterRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_azure_cluster({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_azure_cluster(::Google::Cloud::GkeMultiCloud::V1::GetAzureClusterRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_azure_cluster_client_stub.call_rpc_count
    end
  end

  def test_list_azure_clusters
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::GkeMultiCloud::V1::ListAzureClustersResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_azure_clusters_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_azure_clusters, name
      assert_kind_of ::Google::Cloud::GkeMultiCloud::V1::ListAzureClustersRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_azure_clusters_client_stub do
      # Create client
      client = ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_azure_clusters({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_azure_clusters parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_azure_clusters ::Google::Cloud::GkeMultiCloud::V1::ListAzureClustersRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_azure_clusters({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_azure_clusters(::Google::Cloud::GkeMultiCloud::V1::ListAzureClustersRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_azure_clusters_client_stub.call_rpc_count
    end
  end

  def test_delete_azure_cluster
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    allow_missing = true
    validate_only = true
    etag = "hello world"
    ignore_errors = true

    delete_azure_cluster_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_azure_cluster, name
      assert_kind_of ::Google::Cloud::GkeMultiCloud::V1::DeleteAzureClusterRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["allow_missing"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["etag"]
      assert_equal true, request["ignore_errors"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_azure_cluster_client_stub do
      # Create client
      client = ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_azure_cluster({ name: name, allow_missing: allow_missing, validate_only: validate_only, etag: etag, ignore_errors: ignore_errors }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_azure_cluster name: name, allow_missing: allow_missing, validate_only: validate_only, etag: etag, ignore_errors: ignore_errors do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_azure_cluster ::Google::Cloud::GkeMultiCloud::V1::DeleteAzureClusterRequest.new(name: name, allow_missing: allow_missing, validate_only: validate_only, etag: etag, ignore_errors: ignore_errors) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_azure_cluster({ name: name, allow_missing: allow_missing, validate_only: validate_only, etag: etag, ignore_errors: ignore_errors }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_azure_cluster(::Google::Cloud::GkeMultiCloud::V1::DeleteAzureClusterRequest.new(name: name, allow_missing: allow_missing, validate_only: validate_only, etag: etag, ignore_errors: ignore_errors), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_azure_cluster_client_stub.call_rpc_count
    end
  end

  def test_generate_azure_cluster_agent_token
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::GkeMultiCloud::V1::GenerateAzureClusterAgentTokenResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    azure_cluster = "hello world"
    subject_token = "hello world"
    subject_token_type = "hello world"
    version = "hello world"
    node_pool_id = "hello world"
    grant_type = "hello world"
    audience = "hello world"
    scope = "hello world"
    requested_token_type = "hello world"
    options = "hello world"

    generate_azure_cluster_agent_token_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :generate_azure_cluster_agent_token, name
      assert_kind_of ::Google::Cloud::GkeMultiCloud::V1::GenerateAzureClusterAgentTokenRequest, request
      assert_equal "hello world", request["azure_cluster"]
      assert_equal "hello world", request["subject_token"]
      assert_equal "hello world", request["subject_token_type"]
      assert_equal "hello world", request["version"]
      assert_equal "hello world", request["node_pool_id"]
      assert_equal "hello world", request["grant_type"]
      assert_equal "hello world", request["audience"]
      assert_equal "hello world", request["scope"]
      assert_equal "hello world", request["requested_token_type"]
      assert_equal "hello world", request["options"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, generate_azure_cluster_agent_token_client_stub do
      # Create client
      client = ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.generate_azure_cluster_agent_token({ azure_cluster: azure_cluster, subject_token: subject_token, subject_token_type: subject_token_type, version: version, node_pool_id: node_pool_id, grant_type: grant_type, audience: audience, scope: scope, requested_token_type: requested_token_type, options: options }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.generate_azure_cluster_agent_token azure_cluster: azure_cluster, subject_token: subject_token, subject_token_type: subject_token_type, version: version, node_pool_id: node_pool_id, grant_type: grant_type, audience: audience, scope: scope, requested_token_type: requested_token_type, options: options do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.generate_azure_cluster_agent_token ::Google::Cloud::GkeMultiCloud::V1::GenerateAzureClusterAgentTokenRequest.new(azure_cluster: azure_cluster, subject_token: subject_token, subject_token_type: subject_token_type, version: version, node_pool_id: node_pool_id, grant_type: grant_type, audience: audience, scope: scope, requested_token_type: requested_token_type, options: options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.generate_azure_cluster_agent_token({ azure_cluster: azure_cluster, subject_token: subject_token, subject_token_type: subject_token_type, version: version, node_pool_id: node_pool_id, grant_type: grant_type, audience: audience, scope: scope, requested_token_type: requested_token_type, options: options }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.generate_azure_cluster_agent_token(::Google::Cloud::GkeMultiCloud::V1::GenerateAzureClusterAgentTokenRequest.new(azure_cluster: azure_cluster, subject_token: subject_token, subject_token_type: subject_token_type, version: version, node_pool_id: node_pool_id, grant_type: grant_type, audience: audience, scope: scope, requested_token_type: requested_token_type, options: options), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, generate_azure_cluster_agent_token_client_stub.call_rpc_count
    end
  end

  def test_generate_azure_access_token
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::GkeMultiCloud::V1::GenerateAzureAccessTokenResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    azure_cluster = "hello world"

    generate_azure_access_token_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :generate_azure_access_token, name
      assert_kind_of ::Google::Cloud::GkeMultiCloud::V1::GenerateAzureAccessTokenRequest, request
      assert_equal "hello world", request["azure_cluster"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, generate_azure_access_token_client_stub do
      # Create client
      client = ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.generate_azure_access_token({ azure_cluster: azure_cluster }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.generate_azure_access_token azure_cluster: azure_cluster do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.generate_azure_access_token ::Google::Cloud::GkeMultiCloud::V1::GenerateAzureAccessTokenRequest.new(azure_cluster: azure_cluster) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.generate_azure_access_token({ azure_cluster: azure_cluster }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.generate_azure_access_token(::Google::Cloud::GkeMultiCloud::V1::GenerateAzureAccessTokenRequest.new(azure_cluster: azure_cluster), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, generate_azure_access_token_client_stub.call_rpc_count
    end
  end

  def test_create_azure_node_pool
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    azure_node_pool = {}
    azure_node_pool_id = "hello world"
    validate_only = true

    create_azure_node_pool_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_azure_node_pool, name
      assert_kind_of ::Google::Cloud::GkeMultiCloud::V1::CreateAzureNodePoolRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::GkeMultiCloud::V1::AzureNodePool), request["azure_node_pool"]
      assert_equal "hello world", request["azure_node_pool_id"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_azure_node_pool_client_stub do
      # Create client
      client = ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_azure_node_pool({ parent: parent, azure_node_pool: azure_node_pool, azure_node_pool_id: azure_node_pool_id, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_azure_node_pool parent: parent, azure_node_pool: azure_node_pool, azure_node_pool_id: azure_node_pool_id, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_azure_node_pool ::Google::Cloud::GkeMultiCloud::V1::CreateAzureNodePoolRequest.new(parent: parent, azure_node_pool: azure_node_pool, azure_node_pool_id: azure_node_pool_id, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_azure_node_pool({ parent: parent, azure_node_pool: azure_node_pool, azure_node_pool_id: azure_node_pool_id, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_azure_node_pool(::Google::Cloud::GkeMultiCloud::V1::CreateAzureNodePoolRequest.new(parent: parent, azure_node_pool: azure_node_pool, azure_node_pool_id: azure_node_pool_id, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_azure_node_pool_client_stub.call_rpc_count
    end
  end

  def test_update_azure_node_pool
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    azure_node_pool = {}
    validate_only = true
    update_mask = {}

    update_azure_node_pool_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_azure_node_pool, name
      assert_kind_of ::Google::Cloud::GkeMultiCloud::V1::UpdateAzureNodePoolRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::GkeMultiCloud::V1::AzureNodePool), request["azure_node_pool"]
      assert_equal true, request["validate_only"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_azure_node_pool_client_stub do
      # Create client
      client = ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_azure_node_pool({ azure_node_pool: azure_node_pool, validate_only: validate_only, update_mask: update_mask }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_azure_node_pool azure_node_pool: azure_node_pool, validate_only: validate_only, update_mask: update_mask do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_azure_node_pool ::Google::Cloud::GkeMultiCloud::V1::UpdateAzureNodePoolRequest.new(azure_node_pool: azure_node_pool, validate_only: validate_only, update_mask: update_mask) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_azure_node_pool({ azure_node_pool: azure_node_pool, validate_only: validate_only, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_azure_node_pool(::Google::Cloud::GkeMultiCloud::V1::UpdateAzureNodePoolRequest.new(azure_node_pool: azure_node_pool, validate_only: validate_only, update_mask: update_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_azure_node_pool_client_stub.call_rpc_count
    end
  end

  def test_get_azure_node_pool
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::GkeMultiCloud::V1::AzureNodePool.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_azure_node_pool_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_azure_node_pool, name
      assert_kind_of ::Google::Cloud::GkeMultiCloud::V1::GetAzureNodePoolRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_azure_node_pool_client_stub do
      # Create client
      client = ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_azure_node_pool({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_azure_node_pool name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_azure_node_pool ::Google::Cloud::GkeMultiCloud::V1::GetAzureNodePoolRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_azure_node_pool({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_azure_node_pool(::Google::Cloud::GkeMultiCloud::V1::GetAzureNodePoolRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_azure_node_pool_client_stub.call_rpc_count
    end
  end

  def test_list_azure_node_pools
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::GkeMultiCloud::V1::ListAzureNodePoolsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_azure_node_pools_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_azure_node_pools, name
      assert_kind_of ::Google::Cloud::GkeMultiCloud::V1::ListAzureNodePoolsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_azure_node_pools_client_stub do
      # Create client
      client = ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_azure_node_pools({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_azure_node_pools parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_azure_node_pools ::Google::Cloud::GkeMultiCloud::V1::ListAzureNodePoolsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_azure_node_pools({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_azure_node_pools(::Google::Cloud::GkeMultiCloud::V1::ListAzureNodePoolsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_azure_node_pools_client_stub.call_rpc_count
    end
  end

  def test_delete_azure_node_pool
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    validate_only = true
    allow_missing = true
    etag = "hello world"
    ignore_errors = true

    delete_azure_node_pool_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_azure_node_pool, name
      assert_kind_of ::Google::Cloud::GkeMultiCloud::V1::DeleteAzureNodePoolRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["validate_only"]
      assert_equal true, request["allow_missing"]
      assert_equal "hello world", request["etag"]
      assert_equal true, request["ignore_errors"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_azure_node_pool_client_stub do
      # Create client
      client = ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_azure_node_pool({ name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag, ignore_errors: ignore_errors }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_azure_node_pool name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag, ignore_errors: ignore_errors do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_azure_node_pool ::Google::Cloud::GkeMultiCloud::V1::DeleteAzureNodePoolRequest.new(name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag, ignore_errors: ignore_errors) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_azure_node_pool({ name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag, ignore_errors: ignore_errors }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_azure_node_pool(::Google::Cloud::GkeMultiCloud::V1::DeleteAzureNodePoolRequest.new(name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag, ignore_errors: ignore_errors), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_azure_node_pool_client_stub.call_rpc_count
    end
  end

  def test_get_azure_open_id_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::GkeMultiCloud::V1::AzureOpenIdConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    azure_cluster = "hello world"

    get_azure_open_id_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_azure_open_id_config, name
      assert_kind_of ::Google::Cloud::GkeMultiCloud::V1::GetAzureOpenIdConfigRequest, request
      assert_equal "hello world", request["azure_cluster"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_azure_open_id_config_client_stub do
      # Create client
      client = ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_azure_open_id_config({ azure_cluster: azure_cluster }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_azure_open_id_config azure_cluster: azure_cluster do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_azure_open_id_config ::Google::Cloud::GkeMultiCloud::V1::GetAzureOpenIdConfigRequest.new(azure_cluster: azure_cluster) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_azure_open_id_config({ azure_cluster: azure_cluster }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_azure_open_id_config(::Google::Cloud::GkeMultiCloud::V1::GetAzureOpenIdConfigRequest.new(azure_cluster: azure_cluster), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_azure_open_id_config_client_stub.call_rpc_count
    end
  end

  def test_get_azure_json_web_keys
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::GkeMultiCloud::V1::AzureJsonWebKeys.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    azure_cluster = "hello world"

    get_azure_json_web_keys_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_azure_json_web_keys, name
      assert_kind_of ::Google::Cloud::GkeMultiCloud::V1::GetAzureJsonWebKeysRequest, request
      assert_equal "hello world", request["azure_cluster"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_azure_json_web_keys_client_stub do
      # Create client
      client = ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_azure_json_web_keys({ azure_cluster: azure_cluster }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_azure_json_web_keys azure_cluster: azure_cluster do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_azure_json_web_keys ::Google::Cloud::GkeMultiCloud::V1::GetAzureJsonWebKeysRequest.new(azure_cluster: azure_cluster) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_azure_json_web_keys({ azure_cluster: azure_cluster }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_azure_json_web_keys(::Google::Cloud::GkeMultiCloud::V1::GetAzureJsonWebKeysRequest.new(azure_cluster: azure_cluster), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_azure_json_web_keys_client_stub.call_rpc_count
    end
  end

  def test_get_azure_server_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::GkeMultiCloud::V1::AzureServerConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_azure_server_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_azure_server_config, name
      assert_kind_of ::Google::Cloud::GkeMultiCloud::V1::GetAzureServerConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_azure_server_config_client_stub do
      # Create client
      client = ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_azure_server_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_azure_server_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_azure_server_config ::Google::Cloud::GkeMultiCloud::V1::GetAzureServerConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_azure_server_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_azure_server_config(::Google::Cloud::GkeMultiCloud::V1::GetAzureServerConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_azure_server_config_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Operations, client.operations_client
  end
end
