# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/gkemulticloud/v1/azure_service_pb"
require "google/cloud/gke_multi_cloud/v1/azure_clusters/rest"


class ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_azure_client
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    azure_client = {}
    azure_client_id = "hello world"
    validate_only = true

    create_azure_client_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Rest::ServiceStub.stub :transcode_create_azure_client_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_azure_client_client_stub do
        # Create client
        client = ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_azure_client({ parent: parent, azure_client: azure_client, azure_client_id: azure_client_id, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_azure_client parent: parent, azure_client: azure_client, azure_client_id: azure_client_id, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_azure_client ::Google::Cloud::GkeMultiCloud::V1::CreateAzureClientRequest.new(parent: parent, azure_client: azure_client, azure_client_id: azure_client_id, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_azure_client({ parent: parent, azure_client: azure_client, azure_client_id: azure_client_id, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_azure_client(::Google::Cloud::GkeMultiCloud::V1::CreateAzureClientRequest.new(parent: parent, azure_client: azure_client, azure_client_id: azure_client_id, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_azure_client_client_stub.call_count
      end
    end
  end

  def test_get_azure_client
    # Create test objects.
    client_result = ::Google::Cloud::GkeMultiCloud::V1::AzureClient.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_azure_client_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Rest::ServiceStub.stub :transcode_get_azure_client_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_azure_client_client_stub do
        # Create client
        client = ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_azure_client({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_azure_client name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_azure_client ::Google::Cloud::GkeMultiCloud::V1::GetAzureClientRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_azure_client({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_azure_client(::Google::Cloud::GkeMultiCloud::V1::GetAzureClientRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_azure_client_client_stub.call_count
      end
    end
  end

  def test_list_azure_clients
    # Create test objects.
    client_result = ::Google::Cloud::GkeMultiCloud::V1::ListAzureClientsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_azure_clients_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Rest::ServiceStub.stub :transcode_list_azure_clients_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_azure_clients_client_stub do
        # Create client
        client = ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_azure_clients({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_azure_clients parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_azure_clients ::Google::Cloud::GkeMultiCloud::V1::ListAzureClientsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_azure_clients({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_azure_clients(::Google::Cloud::GkeMultiCloud::V1::ListAzureClientsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_azure_clients_client_stub.call_count
      end
    end
  end

  def test_delete_azure_client
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    allow_missing = true
    validate_only = true

    delete_azure_client_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Rest::ServiceStub.stub :transcode_delete_azure_client_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_azure_client_client_stub do
        # Create client
        client = ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_azure_client({ name: name, allow_missing: allow_missing, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_azure_client name: name, allow_missing: allow_missing, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_azure_client ::Google::Cloud::GkeMultiCloud::V1::DeleteAzureClientRequest.new(name: name, allow_missing: allow_missing, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_azure_client({ name: name, allow_missing: allow_missing, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_azure_client(::Google::Cloud::GkeMultiCloud::V1::DeleteAzureClientRequest.new(name: name, allow_missing: allow_missing, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_azure_client_client_stub.call_count
      end
    end
  end

  def test_create_azure_cluster
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    azure_cluster = {}
    azure_cluster_id = "hello world"
    validate_only = true

    create_azure_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Rest::ServiceStub.stub :transcode_create_azure_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_azure_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_azure_cluster({ parent: parent, azure_cluster: azure_cluster, azure_cluster_id: azure_cluster_id, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_azure_cluster parent: parent, azure_cluster: azure_cluster, azure_cluster_id: azure_cluster_id, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_azure_cluster ::Google::Cloud::GkeMultiCloud::V1::CreateAzureClusterRequest.new(parent: parent, azure_cluster: azure_cluster, azure_cluster_id: azure_cluster_id, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_azure_cluster({ parent: parent, azure_cluster: azure_cluster, azure_cluster_id: azure_cluster_id, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_azure_cluster(::Google::Cloud::GkeMultiCloud::V1::CreateAzureClusterRequest.new(parent: parent, azure_cluster: azure_cluster, azure_cluster_id: azure_cluster_id, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_azure_cluster_client_stub.call_count
      end
    end
  end

  def test_update_azure_cluster
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    azure_cluster = {}
    validate_only = true
    update_mask = {}

    update_azure_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Rest::ServiceStub.stub :transcode_update_azure_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_azure_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_azure_cluster({ azure_cluster: azure_cluster, validate_only: validate_only, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_azure_cluster azure_cluster: azure_cluster, validate_only: validate_only, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_azure_cluster ::Google::Cloud::GkeMultiCloud::V1::UpdateAzureClusterRequest.new(azure_cluster: azure_cluster, validate_only: validate_only, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_azure_cluster({ azure_cluster: azure_cluster, validate_only: validate_only, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_azure_cluster(::Google::Cloud::GkeMultiCloud::V1::UpdateAzureClusterRequest.new(azure_cluster: azure_cluster, validate_only: validate_only, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_azure_cluster_client_stub.call_count
      end
    end
  end

  def test_get_azure_cluster
    # Create test objects.
    client_result = ::Google::Cloud::GkeMultiCloud::V1::AzureCluster.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_azure_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Rest::ServiceStub.stub :transcode_get_azure_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_azure_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_azure_cluster({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_azure_cluster name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_azure_cluster ::Google::Cloud::GkeMultiCloud::V1::GetAzureClusterRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_azure_cluster({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_azure_cluster(::Google::Cloud::GkeMultiCloud::V1::GetAzureClusterRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_azure_cluster_client_stub.call_count
      end
    end
  end

  def test_list_azure_clusters
    # Create test objects.
    client_result = ::Google::Cloud::GkeMultiCloud::V1::ListAzureClustersResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_azure_clusters_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Rest::ServiceStub.stub :transcode_list_azure_clusters_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_azure_clusters_client_stub do
        # Create client
        client = ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_azure_clusters({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_azure_clusters parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_azure_clusters ::Google::Cloud::GkeMultiCloud::V1::ListAzureClustersRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_azure_clusters({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_azure_clusters(::Google::Cloud::GkeMultiCloud::V1::ListAzureClustersRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_azure_clusters_client_stub.call_count
      end
    end
  end

  def test_delete_azure_cluster
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    allow_missing = true
    validate_only = true
    etag = "hello world"
    ignore_errors = true

    delete_azure_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Rest::ServiceStub.stub :transcode_delete_azure_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_azure_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_azure_cluster({ name: name, allow_missing: allow_missing, validate_only: validate_only, etag: etag, ignore_errors: ignore_errors }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_azure_cluster name: name, allow_missing: allow_missing, validate_only: validate_only, etag: etag, ignore_errors: ignore_errors do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_azure_cluster ::Google::Cloud::GkeMultiCloud::V1::DeleteAzureClusterRequest.new(name: name, allow_missing: allow_missing, validate_only: validate_only, etag: etag, ignore_errors: ignore_errors) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_azure_cluster({ name: name, allow_missing: allow_missing, validate_only: validate_only, etag: etag, ignore_errors: ignore_errors }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_azure_cluster(::Google::Cloud::GkeMultiCloud::V1::DeleteAzureClusterRequest.new(name: name, allow_missing: allow_missing, validate_only: validate_only, etag: etag, ignore_errors: ignore_errors), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_azure_cluster_client_stub.call_count
      end
    end
  end

  def test_generate_azure_cluster_agent_token
    # Create test objects.
    client_result = ::Google::Cloud::GkeMultiCloud::V1::GenerateAzureClusterAgentTokenResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    azure_cluster = "hello world"
    subject_token = "hello world"
    subject_token_type = "hello world"
    version = "hello world"
    node_pool_id = "hello world"
    grant_type = "hello world"
    audience = "hello world"
    scope = "hello world"
    requested_token_type = "hello world"
    options = "hello world"

    generate_azure_cluster_agent_token_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Rest::ServiceStub.stub :transcode_generate_azure_cluster_agent_token_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, generate_azure_cluster_agent_token_client_stub do
        # Create client
        client = ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.generate_azure_cluster_agent_token({ azure_cluster: azure_cluster, subject_token: subject_token, subject_token_type: subject_token_type, version: version, node_pool_id: node_pool_id, grant_type: grant_type, audience: audience, scope: scope, requested_token_type: requested_token_type, options: options }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.generate_azure_cluster_agent_token azure_cluster: azure_cluster, subject_token: subject_token, subject_token_type: subject_token_type, version: version, node_pool_id: node_pool_id, grant_type: grant_type, audience: audience, scope: scope, requested_token_type: requested_token_type, options: options do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.generate_azure_cluster_agent_token ::Google::Cloud::GkeMultiCloud::V1::GenerateAzureClusterAgentTokenRequest.new(azure_cluster: azure_cluster, subject_token: subject_token, subject_token_type: subject_token_type, version: version, node_pool_id: node_pool_id, grant_type: grant_type, audience: audience, scope: scope, requested_token_type: requested_token_type, options: options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.generate_azure_cluster_agent_token({ azure_cluster: azure_cluster, subject_token: subject_token, subject_token_type: subject_token_type, version: version, node_pool_id: node_pool_id, grant_type: grant_type, audience: audience, scope: scope, requested_token_type: requested_token_type, options: options }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.generate_azure_cluster_agent_token(::Google::Cloud::GkeMultiCloud::V1::GenerateAzureClusterAgentTokenRequest.new(azure_cluster: azure_cluster, subject_token: subject_token, subject_token_type: subject_token_type, version: version, node_pool_id: node_pool_id, grant_type: grant_type, audience: audience, scope: scope, requested_token_type: requested_token_type, options: options), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, generate_azure_cluster_agent_token_client_stub.call_count
      end
    end
  end

  def test_generate_azure_access_token
    # Create test objects.
    client_result = ::Google::Cloud::GkeMultiCloud::V1::GenerateAzureAccessTokenResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    azure_cluster = "hello world"

    generate_azure_access_token_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Rest::ServiceStub.stub :transcode_generate_azure_access_token_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, generate_azure_access_token_client_stub do
        # Create client
        client = ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.generate_azure_access_token({ azure_cluster: azure_cluster }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.generate_azure_access_token azure_cluster: azure_cluster do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.generate_azure_access_token ::Google::Cloud::GkeMultiCloud::V1::GenerateAzureAccessTokenRequest.new(azure_cluster: azure_cluster) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.generate_azure_access_token({ azure_cluster: azure_cluster }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.generate_azure_access_token(::Google::Cloud::GkeMultiCloud::V1::GenerateAzureAccessTokenRequest.new(azure_cluster: azure_cluster), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, generate_azure_access_token_client_stub.call_count
      end
    end
  end

  def test_create_azure_node_pool
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    azure_node_pool = {}
    azure_node_pool_id = "hello world"
    validate_only = true

    create_azure_node_pool_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Rest::ServiceStub.stub :transcode_create_azure_node_pool_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_azure_node_pool_client_stub do
        # Create client
        client = ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_azure_node_pool({ parent: parent, azure_node_pool: azure_node_pool, azure_node_pool_id: azure_node_pool_id, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_azure_node_pool parent: parent, azure_node_pool: azure_node_pool, azure_node_pool_id: azure_node_pool_id, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_azure_node_pool ::Google::Cloud::GkeMultiCloud::V1::CreateAzureNodePoolRequest.new(parent: parent, azure_node_pool: azure_node_pool, azure_node_pool_id: azure_node_pool_id, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_azure_node_pool({ parent: parent, azure_node_pool: azure_node_pool, azure_node_pool_id: azure_node_pool_id, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_azure_node_pool(::Google::Cloud::GkeMultiCloud::V1::CreateAzureNodePoolRequest.new(parent: parent, azure_node_pool: azure_node_pool, azure_node_pool_id: azure_node_pool_id, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_azure_node_pool_client_stub.call_count
      end
    end
  end

  def test_update_azure_node_pool
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    azure_node_pool = {}
    validate_only = true
    update_mask = {}

    update_azure_node_pool_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Rest::ServiceStub.stub :transcode_update_azure_node_pool_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_azure_node_pool_client_stub do
        # Create client
        client = ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_azure_node_pool({ azure_node_pool: azure_node_pool, validate_only: validate_only, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_azure_node_pool azure_node_pool: azure_node_pool, validate_only: validate_only, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_azure_node_pool ::Google::Cloud::GkeMultiCloud::V1::UpdateAzureNodePoolRequest.new(azure_node_pool: azure_node_pool, validate_only: validate_only, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_azure_node_pool({ azure_node_pool: azure_node_pool, validate_only: validate_only, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_azure_node_pool(::Google::Cloud::GkeMultiCloud::V1::UpdateAzureNodePoolRequest.new(azure_node_pool: azure_node_pool, validate_only: validate_only, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_azure_node_pool_client_stub.call_count
      end
    end
  end

  def test_get_azure_node_pool
    # Create test objects.
    client_result = ::Google::Cloud::GkeMultiCloud::V1::AzureNodePool.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_azure_node_pool_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Rest::ServiceStub.stub :transcode_get_azure_node_pool_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_azure_node_pool_client_stub do
        # Create client
        client = ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_azure_node_pool({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_azure_node_pool name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_azure_node_pool ::Google::Cloud::GkeMultiCloud::V1::GetAzureNodePoolRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_azure_node_pool({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_azure_node_pool(::Google::Cloud::GkeMultiCloud::V1::GetAzureNodePoolRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_azure_node_pool_client_stub.call_count
      end
    end
  end

  def test_list_azure_node_pools
    # Create test objects.
    client_result = ::Google::Cloud::GkeMultiCloud::V1::ListAzureNodePoolsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_azure_node_pools_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Rest::ServiceStub.stub :transcode_list_azure_node_pools_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_azure_node_pools_client_stub do
        # Create client
        client = ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_azure_node_pools({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_azure_node_pools parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_azure_node_pools ::Google::Cloud::GkeMultiCloud::V1::ListAzureNodePoolsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_azure_node_pools({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_azure_node_pools(::Google::Cloud::GkeMultiCloud::V1::ListAzureNodePoolsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_azure_node_pools_client_stub.call_count
      end
    end
  end

  def test_delete_azure_node_pool
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    validate_only = true
    allow_missing = true
    etag = "hello world"
    ignore_errors = true

    delete_azure_node_pool_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Rest::ServiceStub.stub :transcode_delete_azure_node_pool_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_azure_node_pool_client_stub do
        # Create client
        client = ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_azure_node_pool({ name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag, ignore_errors: ignore_errors }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_azure_node_pool name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag, ignore_errors: ignore_errors do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_azure_node_pool ::Google::Cloud::GkeMultiCloud::V1::DeleteAzureNodePoolRequest.new(name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag, ignore_errors: ignore_errors) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_azure_node_pool({ name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag, ignore_errors: ignore_errors }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_azure_node_pool(::Google::Cloud::GkeMultiCloud::V1::DeleteAzureNodePoolRequest.new(name: name, validate_only: validate_only, allow_missing: allow_missing, etag: etag, ignore_errors: ignore_errors), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_azure_node_pool_client_stub.call_count
      end
    end
  end

  def test_get_azure_open_id_config
    # Create test objects.
    client_result = ::Google::Cloud::GkeMultiCloud::V1::AzureOpenIdConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    azure_cluster = "hello world"

    get_azure_open_id_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Rest::ServiceStub.stub :transcode_get_azure_open_id_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_azure_open_id_config_client_stub do
        # Create client
        client = ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_azure_open_id_config({ azure_cluster: azure_cluster }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_azure_open_id_config azure_cluster: azure_cluster do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_azure_open_id_config ::Google::Cloud::GkeMultiCloud::V1::GetAzureOpenIdConfigRequest.new(azure_cluster: azure_cluster) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_azure_open_id_config({ azure_cluster: azure_cluster }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_azure_open_id_config(::Google::Cloud::GkeMultiCloud::V1::GetAzureOpenIdConfigRequest.new(azure_cluster: azure_cluster), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_azure_open_id_config_client_stub.call_count
      end
    end
  end

  def test_get_azure_json_web_keys
    # Create test objects.
    client_result = ::Google::Cloud::GkeMultiCloud::V1::AzureJsonWebKeys.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    azure_cluster = "hello world"

    get_azure_json_web_keys_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Rest::ServiceStub.stub :transcode_get_azure_json_web_keys_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_azure_json_web_keys_client_stub do
        # Create client
        client = ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_azure_json_web_keys({ azure_cluster: azure_cluster }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_azure_json_web_keys azure_cluster: azure_cluster do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_azure_json_web_keys ::Google::Cloud::GkeMultiCloud::V1::GetAzureJsonWebKeysRequest.new(azure_cluster: azure_cluster) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_azure_json_web_keys({ azure_cluster: azure_cluster }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_azure_json_web_keys(::Google::Cloud::GkeMultiCloud::V1::GetAzureJsonWebKeysRequest.new(azure_cluster: azure_cluster), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_azure_json_web_keys_client_stub.call_count
      end
    end
  end

  def test_get_azure_server_config
    # Create test objects.
    client_result = ::Google::Cloud::GkeMultiCloud::V1::AzureServerConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_azure_server_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Rest::ServiceStub.stub :transcode_get_azure_server_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_azure_server_config_client_stub do
        # Create client
        client = ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_azure_server_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_azure_server_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_azure_server_config ::Google::Cloud::GkeMultiCloud::V1::GetAzureServerConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_azure_server_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_azure_server_config(::Google::Cloud::GkeMultiCloud::V1::GetAzureServerConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_azure_server_config_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Rest::Client::Configuration, config
  end
end
