# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/gkemulticloud/v1/aws_service_pb"
require "google/cloud/gke_multi_cloud/v1/aws_clusters/rest"


class ::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_aws_cluster
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    aws_cluster = {}
    aws_cluster_id = "hello world"
    validate_only = true

    create_aws_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::ServiceStub.stub :transcode_create_aws_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_aws_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_aws_cluster({ parent: parent, aws_cluster: aws_cluster, aws_cluster_id: aws_cluster_id, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_aws_cluster parent: parent, aws_cluster: aws_cluster, aws_cluster_id: aws_cluster_id, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_aws_cluster ::Google::Cloud::GkeMultiCloud::V1::CreateAwsClusterRequest.new(parent: parent, aws_cluster: aws_cluster, aws_cluster_id: aws_cluster_id, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_aws_cluster({ parent: parent, aws_cluster: aws_cluster, aws_cluster_id: aws_cluster_id, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_aws_cluster(::Google::Cloud::GkeMultiCloud::V1::CreateAwsClusterRequest.new(parent: parent, aws_cluster: aws_cluster, aws_cluster_id: aws_cluster_id, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_aws_cluster_client_stub.call_count
      end
    end
  end

  def test_update_aws_cluster
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    aws_cluster = {}
    validate_only = true
    update_mask = {}

    update_aws_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::ServiceStub.stub :transcode_update_aws_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_aws_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_aws_cluster({ aws_cluster: aws_cluster, validate_only: validate_only, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_aws_cluster aws_cluster: aws_cluster, validate_only: validate_only, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_aws_cluster ::Google::Cloud::GkeMultiCloud::V1::UpdateAwsClusterRequest.new(aws_cluster: aws_cluster, validate_only: validate_only, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_aws_cluster({ aws_cluster: aws_cluster, validate_only: validate_only, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_aws_cluster(::Google::Cloud::GkeMultiCloud::V1::UpdateAwsClusterRequest.new(aws_cluster: aws_cluster, validate_only: validate_only, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_aws_cluster_client_stub.call_count
      end
    end
  end

  def test_get_aws_cluster
    # Create test objects.
    client_result = ::Google::Cloud::GkeMultiCloud::V1::AwsCluster.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_aws_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::ServiceStub.stub :transcode_get_aws_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_aws_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_aws_cluster({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_aws_cluster name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_aws_cluster ::Google::Cloud::GkeMultiCloud::V1::GetAwsClusterRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_aws_cluster({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_aws_cluster(::Google::Cloud::GkeMultiCloud::V1::GetAwsClusterRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_aws_cluster_client_stub.call_count
      end
    end
  end

  def test_list_aws_clusters
    # Create test objects.
    client_result = ::Google::Cloud::GkeMultiCloud::V1::ListAwsClustersResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_aws_clusters_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::ServiceStub.stub :transcode_list_aws_clusters_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_aws_clusters_client_stub do
        # Create client
        client = ::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_aws_clusters({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_aws_clusters parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_aws_clusters ::Google::Cloud::GkeMultiCloud::V1::ListAwsClustersRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_aws_clusters({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_aws_clusters(::Google::Cloud::GkeMultiCloud::V1::ListAwsClustersRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_aws_clusters_client_stub.call_count
      end
    end
  end

  def test_delete_aws_cluster
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    validate_only = true
    allow_missing = true
    ignore_errors = true
    etag = "hello world"

    delete_aws_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::ServiceStub.stub :transcode_delete_aws_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_aws_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_aws_cluster({ name: name, validate_only: validate_only, allow_missing: allow_missing, ignore_errors: ignore_errors, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_aws_cluster name: name, validate_only: validate_only, allow_missing: allow_missing, ignore_errors: ignore_errors, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_aws_cluster ::Google::Cloud::GkeMultiCloud::V1::DeleteAwsClusterRequest.new(name: name, validate_only: validate_only, allow_missing: allow_missing, ignore_errors: ignore_errors, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_aws_cluster({ name: name, validate_only: validate_only, allow_missing: allow_missing, ignore_errors: ignore_errors, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_aws_cluster(::Google::Cloud::GkeMultiCloud::V1::DeleteAwsClusterRequest.new(name: name, validate_only: validate_only, allow_missing: allow_missing, ignore_errors: ignore_errors, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_aws_cluster_client_stub.call_count
      end
    end
  end

  def test_generate_aws_cluster_agent_token
    # Create test objects.
    client_result = ::Google::Cloud::GkeMultiCloud::V1::GenerateAwsClusterAgentTokenResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    aws_cluster = "hello world"
    subject_token = "hello world"
    subject_token_type = "hello world"
    version = "hello world"
    node_pool_id = "hello world"
    grant_type = "hello world"
    audience = "hello world"
    scope = "hello world"
    requested_token_type = "hello world"
    options = "hello world"

    generate_aws_cluster_agent_token_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::ServiceStub.stub :transcode_generate_aws_cluster_agent_token_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, generate_aws_cluster_agent_token_client_stub do
        # Create client
        client = ::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.generate_aws_cluster_agent_token({ aws_cluster: aws_cluster, subject_token: subject_token, subject_token_type: subject_token_type, version: version, node_pool_id: node_pool_id, grant_type: grant_type, audience: audience, scope: scope, requested_token_type: requested_token_type, options: options }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.generate_aws_cluster_agent_token aws_cluster: aws_cluster, subject_token: subject_token, subject_token_type: subject_token_type, version: version, node_pool_id: node_pool_id, grant_type: grant_type, audience: audience, scope: scope, requested_token_type: requested_token_type, options: options do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.generate_aws_cluster_agent_token ::Google::Cloud::GkeMultiCloud::V1::GenerateAwsClusterAgentTokenRequest.new(aws_cluster: aws_cluster, subject_token: subject_token, subject_token_type: subject_token_type, version: version, node_pool_id: node_pool_id, grant_type: grant_type, audience: audience, scope: scope, requested_token_type: requested_token_type, options: options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.generate_aws_cluster_agent_token({ aws_cluster: aws_cluster, subject_token: subject_token, subject_token_type: subject_token_type, version: version, node_pool_id: node_pool_id, grant_type: grant_type, audience: audience, scope: scope, requested_token_type: requested_token_type, options: options }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.generate_aws_cluster_agent_token(::Google::Cloud::GkeMultiCloud::V1::GenerateAwsClusterAgentTokenRequest.new(aws_cluster: aws_cluster, subject_token: subject_token, subject_token_type: subject_token_type, version: version, node_pool_id: node_pool_id, grant_type: grant_type, audience: audience, scope: scope, requested_token_type: requested_token_type, options: options), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, generate_aws_cluster_agent_token_client_stub.call_count
      end
    end
  end

  def test_generate_aws_access_token
    # Create test objects.
    client_result = ::Google::Cloud::GkeMultiCloud::V1::GenerateAwsAccessTokenResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    aws_cluster = "hello world"

    generate_aws_access_token_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::ServiceStub.stub :transcode_generate_aws_access_token_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, generate_aws_access_token_client_stub do
        # Create client
        client = ::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.generate_aws_access_token({ aws_cluster: aws_cluster }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.generate_aws_access_token aws_cluster: aws_cluster do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.generate_aws_access_token ::Google::Cloud::GkeMultiCloud::V1::GenerateAwsAccessTokenRequest.new(aws_cluster: aws_cluster) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.generate_aws_access_token({ aws_cluster: aws_cluster }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.generate_aws_access_token(::Google::Cloud::GkeMultiCloud::V1::GenerateAwsAccessTokenRequest.new(aws_cluster: aws_cluster), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, generate_aws_access_token_client_stub.call_count
      end
    end
  end

  def test_create_aws_node_pool
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    aws_node_pool = {}
    aws_node_pool_id = "hello world"
    validate_only = true

    create_aws_node_pool_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::ServiceStub.stub :transcode_create_aws_node_pool_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_aws_node_pool_client_stub do
        # Create client
        client = ::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_aws_node_pool({ parent: parent, aws_node_pool: aws_node_pool, aws_node_pool_id: aws_node_pool_id, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_aws_node_pool parent: parent, aws_node_pool: aws_node_pool, aws_node_pool_id: aws_node_pool_id, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_aws_node_pool ::Google::Cloud::GkeMultiCloud::V1::CreateAwsNodePoolRequest.new(parent: parent, aws_node_pool: aws_node_pool, aws_node_pool_id: aws_node_pool_id, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_aws_node_pool({ parent: parent, aws_node_pool: aws_node_pool, aws_node_pool_id: aws_node_pool_id, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_aws_node_pool(::Google::Cloud::GkeMultiCloud::V1::CreateAwsNodePoolRequest.new(parent: parent, aws_node_pool: aws_node_pool, aws_node_pool_id: aws_node_pool_id, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_aws_node_pool_client_stub.call_count
      end
    end
  end

  def test_update_aws_node_pool
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    aws_node_pool = {}
    validate_only = true
    update_mask = {}

    update_aws_node_pool_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::ServiceStub.stub :transcode_update_aws_node_pool_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_aws_node_pool_client_stub do
        # Create client
        client = ::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_aws_node_pool({ aws_node_pool: aws_node_pool, validate_only: validate_only, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_aws_node_pool aws_node_pool: aws_node_pool, validate_only: validate_only, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_aws_node_pool ::Google::Cloud::GkeMultiCloud::V1::UpdateAwsNodePoolRequest.new(aws_node_pool: aws_node_pool, validate_only: validate_only, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_aws_node_pool({ aws_node_pool: aws_node_pool, validate_only: validate_only, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_aws_node_pool(::Google::Cloud::GkeMultiCloud::V1::UpdateAwsNodePoolRequest.new(aws_node_pool: aws_node_pool, validate_only: validate_only, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_aws_node_pool_client_stub.call_count
      end
    end
  end

  def test_rollback_aws_node_pool_update
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    respect_pdb = true

    rollback_aws_node_pool_update_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::ServiceStub.stub :transcode_rollback_aws_node_pool_update_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, rollback_aws_node_pool_update_client_stub do
        # Create client
        client = ::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.rollback_aws_node_pool_update({ name: name, respect_pdb: respect_pdb }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.rollback_aws_node_pool_update name: name, respect_pdb: respect_pdb do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.rollback_aws_node_pool_update ::Google::Cloud::GkeMultiCloud::V1::RollbackAwsNodePoolUpdateRequest.new(name: name, respect_pdb: respect_pdb) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.rollback_aws_node_pool_update({ name: name, respect_pdb: respect_pdb }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.rollback_aws_node_pool_update(::Google::Cloud::GkeMultiCloud::V1::RollbackAwsNodePoolUpdateRequest.new(name: name, respect_pdb: respect_pdb), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, rollback_aws_node_pool_update_client_stub.call_count
      end
    end
  end

  def test_get_aws_node_pool
    # Create test objects.
    client_result = ::Google::Cloud::GkeMultiCloud::V1::AwsNodePool.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_aws_node_pool_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::ServiceStub.stub :transcode_get_aws_node_pool_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_aws_node_pool_client_stub do
        # Create client
        client = ::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_aws_node_pool({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_aws_node_pool name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_aws_node_pool ::Google::Cloud::GkeMultiCloud::V1::GetAwsNodePoolRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_aws_node_pool({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_aws_node_pool(::Google::Cloud::GkeMultiCloud::V1::GetAwsNodePoolRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_aws_node_pool_client_stub.call_count
      end
    end
  end

  def test_list_aws_node_pools
    # Create test objects.
    client_result = ::Google::Cloud::GkeMultiCloud::V1::ListAwsNodePoolsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_aws_node_pools_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::ServiceStub.stub :transcode_list_aws_node_pools_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_aws_node_pools_client_stub do
        # Create client
        client = ::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_aws_node_pools({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_aws_node_pools parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_aws_node_pools ::Google::Cloud::GkeMultiCloud::V1::ListAwsNodePoolsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_aws_node_pools({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_aws_node_pools(::Google::Cloud::GkeMultiCloud::V1::ListAwsNodePoolsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_aws_node_pools_client_stub.call_count
      end
    end
  end

  def test_delete_aws_node_pool
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    validate_only = true
    allow_missing = true
    ignore_errors = true
    etag = "hello world"

    delete_aws_node_pool_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::ServiceStub.stub :transcode_delete_aws_node_pool_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_aws_node_pool_client_stub do
        # Create client
        client = ::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_aws_node_pool({ name: name, validate_only: validate_only, allow_missing: allow_missing, ignore_errors: ignore_errors, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_aws_node_pool name: name, validate_only: validate_only, allow_missing: allow_missing, ignore_errors: ignore_errors, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_aws_node_pool ::Google::Cloud::GkeMultiCloud::V1::DeleteAwsNodePoolRequest.new(name: name, validate_only: validate_only, allow_missing: allow_missing, ignore_errors: ignore_errors, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_aws_node_pool({ name: name, validate_only: validate_only, allow_missing: allow_missing, ignore_errors: ignore_errors, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_aws_node_pool(::Google::Cloud::GkeMultiCloud::V1::DeleteAwsNodePoolRequest.new(name: name, validate_only: validate_only, allow_missing: allow_missing, ignore_errors: ignore_errors, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_aws_node_pool_client_stub.call_count
      end
    end
  end

  def test_get_aws_open_id_config
    # Create test objects.
    client_result = ::Google::Cloud::GkeMultiCloud::V1::AwsOpenIdConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    aws_cluster = "hello world"

    get_aws_open_id_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::ServiceStub.stub :transcode_get_aws_open_id_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_aws_open_id_config_client_stub do
        # Create client
        client = ::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_aws_open_id_config({ aws_cluster: aws_cluster }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_aws_open_id_config aws_cluster: aws_cluster do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_aws_open_id_config ::Google::Cloud::GkeMultiCloud::V1::GetAwsOpenIdConfigRequest.new(aws_cluster: aws_cluster) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_aws_open_id_config({ aws_cluster: aws_cluster }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_aws_open_id_config(::Google::Cloud::GkeMultiCloud::V1::GetAwsOpenIdConfigRequest.new(aws_cluster: aws_cluster), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_aws_open_id_config_client_stub.call_count
      end
    end
  end

  def test_get_aws_json_web_keys
    # Create test objects.
    client_result = ::Google::Cloud::GkeMultiCloud::V1::AwsJsonWebKeys.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    aws_cluster = "hello world"

    get_aws_json_web_keys_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::ServiceStub.stub :transcode_get_aws_json_web_keys_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_aws_json_web_keys_client_stub do
        # Create client
        client = ::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_aws_json_web_keys({ aws_cluster: aws_cluster }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_aws_json_web_keys aws_cluster: aws_cluster do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_aws_json_web_keys ::Google::Cloud::GkeMultiCloud::V1::GetAwsJsonWebKeysRequest.new(aws_cluster: aws_cluster) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_aws_json_web_keys({ aws_cluster: aws_cluster }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_aws_json_web_keys(::Google::Cloud::GkeMultiCloud::V1::GetAwsJsonWebKeysRequest.new(aws_cluster: aws_cluster), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_aws_json_web_keys_client_stub.call_count
      end
    end
  end

  def test_get_aws_server_config
    # Create test objects.
    client_result = ::Google::Cloud::GkeMultiCloud::V1::AwsServerConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_aws_server_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::ServiceStub.stub :transcode_get_aws_server_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_aws_server_config_client_stub do
        # Create client
        client = ::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_aws_server_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_aws_server_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_aws_server_config ::Google::Cloud::GkeMultiCloud::V1::GetAwsServerConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_aws_server_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_aws_server_config(::Google::Cloud::GkeMultiCloud::V1::GetAwsServerConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_aws_server_config_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::Client::Configuration, config
  end
end
