# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/gkemulticloud/v1/attached_service_pb"
require "google/cloud/gke_multi_cloud/v1/attached_clusters"

class ::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_attached_cluster
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    attached_cluster = {}
    attached_cluster_id = "hello world"
    validate_only = true

    create_attached_cluster_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_attached_cluster, name
      assert_kind_of ::Google::Cloud::GkeMultiCloud::V1::CreateAttachedClusterRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::GkeMultiCloud::V1::AttachedCluster), request["attached_cluster"]
      assert_equal "hello world", request["attached_cluster_id"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_attached_cluster_client_stub do
      # Create client
      client = ::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_attached_cluster({ parent: parent, attached_cluster: attached_cluster, attached_cluster_id: attached_cluster_id, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_attached_cluster parent: parent, attached_cluster: attached_cluster, attached_cluster_id: attached_cluster_id, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_attached_cluster ::Google::Cloud::GkeMultiCloud::V1::CreateAttachedClusterRequest.new(parent: parent, attached_cluster: attached_cluster, attached_cluster_id: attached_cluster_id, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_attached_cluster({ parent: parent, attached_cluster: attached_cluster, attached_cluster_id: attached_cluster_id, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_attached_cluster(::Google::Cloud::GkeMultiCloud::V1::CreateAttachedClusterRequest.new(parent: parent, attached_cluster: attached_cluster, attached_cluster_id: attached_cluster_id, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_attached_cluster_client_stub.call_rpc_count
    end
  end

  def test_update_attached_cluster
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    attached_cluster = {}
    validate_only = true
    update_mask = {}

    update_attached_cluster_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_attached_cluster, name
      assert_kind_of ::Google::Cloud::GkeMultiCloud::V1::UpdateAttachedClusterRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::GkeMultiCloud::V1::AttachedCluster), request["attached_cluster"]
      assert_equal true, request["validate_only"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_attached_cluster_client_stub do
      # Create client
      client = ::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_attached_cluster({ attached_cluster: attached_cluster, validate_only: validate_only, update_mask: update_mask }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_attached_cluster attached_cluster: attached_cluster, validate_only: validate_only, update_mask: update_mask do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_attached_cluster ::Google::Cloud::GkeMultiCloud::V1::UpdateAttachedClusterRequest.new(attached_cluster: attached_cluster, validate_only: validate_only, update_mask: update_mask) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_attached_cluster({ attached_cluster: attached_cluster, validate_only: validate_only, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_attached_cluster(::Google::Cloud::GkeMultiCloud::V1::UpdateAttachedClusterRequest.new(attached_cluster: attached_cluster, validate_only: validate_only, update_mask: update_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_attached_cluster_client_stub.call_rpc_count
    end
  end

  def test_import_attached_cluster
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    validate_only = true
    fleet_membership = "hello world"
    platform_version = "hello world"
    distribution = "hello world"
    proxy_config = {}

    import_attached_cluster_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :import_attached_cluster, name
      assert_kind_of ::Google::Cloud::GkeMultiCloud::V1::ImportAttachedClusterRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["fleet_membership"]
      assert_equal "hello world", request["platform_version"]
      assert_equal "hello world", request["distribution"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::GkeMultiCloud::V1::AttachedProxyConfig), request["proxy_config"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, import_attached_cluster_client_stub do
      # Create client
      client = ::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.import_attached_cluster({ parent: parent, validate_only: validate_only, fleet_membership: fleet_membership, platform_version: platform_version, distribution: distribution, proxy_config: proxy_config }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.import_attached_cluster parent: parent, validate_only: validate_only, fleet_membership: fleet_membership, platform_version: platform_version, distribution: distribution, proxy_config: proxy_config do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.import_attached_cluster ::Google::Cloud::GkeMultiCloud::V1::ImportAttachedClusterRequest.new(parent: parent, validate_only: validate_only, fleet_membership: fleet_membership, platform_version: platform_version, distribution: distribution, proxy_config: proxy_config) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.import_attached_cluster({ parent: parent, validate_only: validate_only, fleet_membership: fleet_membership, platform_version: platform_version, distribution: distribution, proxy_config: proxy_config }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.import_attached_cluster(::Google::Cloud::GkeMultiCloud::V1::ImportAttachedClusterRequest.new(parent: parent, validate_only: validate_only, fleet_membership: fleet_membership, platform_version: platform_version, distribution: distribution, proxy_config: proxy_config), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, import_attached_cluster_client_stub.call_rpc_count
    end
  end

  def test_get_attached_cluster
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::GkeMultiCloud::V1::AttachedCluster.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_attached_cluster_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_attached_cluster, name
      assert_kind_of ::Google::Cloud::GkeMultiCloud::V1::GetAttachedClusterRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_attached_cluster_client_stub do
      # Create client
      client = ::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_attached_cluster({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_attached_cluster name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_attached_cluster ::Google::Cloud::GkeMultiCloud::V1::GetAttachedClusterRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_attached_cluster({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_attached_cluster(::Google::Cloud::GkeMultiCloud::V1::GetAttachedClusterRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_attached_cluster_client_stub.call_rpc_count
    end
  end

  def test_list_attached_clusters
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::GkeMultiCloud::V1::ListAttachedClustersResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_attached_clusters_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_attached_clusters, name
      assert_kind_of ::Google::Cloud::GkeMultiCloud::V1::ListAttachedClustersRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_attached_clusters_client_stub do
      # Create client
      client = ::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_attached_clusters({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_attached_clusters parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_attached_clusters ::Google::Cloud::GkeMultiCloud::V1::ListAttachedClustersRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_attached_clusters({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_attached_clusters(::Google::Cloud::GkeMultiCloud::V1::ListAttachedClustersRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_attached_clusters_client_stub.call_rpc_count
    end
  end

  def test_delete_attached_cluster
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    validate_only = true
    allow_missing = true
    ignore_errors = true
    etag = "hello world"

    delete_attached_cluster_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_attached_cluster, name
      assert_kind_of ::Google::Cloud::GkeMultiCloud::V1::DeleteAttachedClusterRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["validate_only"]
      assert_equal true, request["allow_missing"]
      assert_equal true, request["ignore_errors"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_attached_cluster_client_stub do
      # Create client
      client = ::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_attached_cluster({ name: name, validate_only: validate_only, allow_missing: allow_missing, ignore_errors: ignore_errors, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_attached_cluster name: name, validate_only: validate_only, allow_missing: allow_missing, ignore_errors: ignore_errors, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_attached_cluster ::Google::Cloud::GkeMultiCloud::V1::DeleteAttachedClusterRequest.new(name: name, validate_only: validate_only, allow_missing: allow_missing, ignore_errors: ignore_errors, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_attached_cluster({ name: name, validate_only: validate_only, allow_missing: allow_missing, ignore_errors: ignore_errors, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_attached_cluster(::Google::Cloud::GkeMultiCloud::V1::DeleteAttachedClusterRequest.new(name: name, validate_only: validate_only, allow_missing: allow_missing, ignore_errors: ignore_errors, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_attached_cluster_client_stub.call_rpc_count
    end
  end

  def test_get_attached_server_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::GkeMultiCloud::V1::AttachedServerConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_attached_server_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_attached_server_config, name
      assert_kind_of ::Google::Cloud::GkeMultiCloud::V1::GetAttachedServerConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_attached_server_config_client_stub do
      # Create client
      client = ::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_attached_server_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_attached_server_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_attached_server_config ::Google::Cloud::GkeMultiCloud::V1::GetAttachedServerConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_attached_server_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_attached_server_config(::Google::Cloud::GkeMultiCloud::V1::GetAttachedServerConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_attached_server_config_client_stub.call_rpc_count
    end
  end

  def test_generate_attached_cluster_install_manifest
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::GkeMultiCloud::V1::GenerateAttachedClusterInstallManifestResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    attached_cluster_id = "hello world"
    platform_version = "hello world"
    proxy_config = {}

    generate_attached_cluster_install_manifest_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :generate_attached_cluster_install_manifest, name
      assert_kind_of ::Google::Cloud::GkeMultiCloud::V1::GenerateAttachedClusterInstallManifestRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["attached_cluster_id"]
      assert_equal "hello world", request["platform_version"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::GkeMultiCloud::V1::AttachedProxyConfig), request["proxy_config"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, generate_attached_cluster_install_manifest_client_stub do
      # Create client
      client = ::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.generate_attached_cluster_install_manifest({ parent: parent, attached_cluster_id: attached_cluster_id, platform_version: platform_version, proxy_config: proxy_config }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.generate_attached_cluster_install_manifest parent: parent, attached_cluster_id: attached_cluster_id, platform_version: platform_version, proxy_config: proxy_config do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.generate_attached_cluster_install_manifest ::Google::Cloud::GkeMultiCloud::V1::GenerateAttachedClusterInstallManifestRequest.new(parent: parent, attached_cluster_id: attached_cluster_id, platform_version: platform_version, proxy_config: proxy_config) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.generate_attached_cluster_install_manifest({ parent: parent, attached_cluster_id: attached_cluster_id, platform_version: platform_version, proxy_config: proxy_config }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.generate_attached_cluster_install_manifest(::Google::Cloud::GkeMultiCloud::V1::GenerateAttachedClusterInstallManifestRequest.new(parent: parent, attached_cluster_id: attached_cluster_id, platform_version: platform_version, proxy_config: proxy_config), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, generate_attached_cluster_install_manifest_client_stub.call_rpc_count
    end
  end

  def test_generate_attached_cluster_agent_token
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::GkeMultiCloud::V1::GenerateAttachedClusterAgentTokenResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    attached_cluster = "hello world"
    subject_token = "hello world"
    subject_token_type = "hello world"
    version = "hello world"
    grant_type = "hello world"
    audience = "hello world"
    scope = "hello world"
    requested_token_type = "hello world"
    options = "hello world"

    generate_attached_cluster_agent_token_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :generate_attached_cluster_agent_token, name
      assert_kind_of ::Google::Cloud::GkeMultiCloud::V1::GenerateAttachedClusterAgentTokenRequest, request
      assert_equal "hello world", request["attached_cluster"]
      assert_equal "hello world", request["subject_token"]
      assert_equal "hello world", request["subject_token_type"]
      assert_equal "hello world", request["version"]
      assert_equal "hello world", request["grant_type"]
      assert_equal "hello world", request["audience"]
      assert_equal "hello world", request["scope"]
      assert_equal "hello world", request["requested_token_type"]
      assert_equal "hello world", request["options"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, generate_attached_cluster_agent_token_client_stub do
      # Create client
      client = ::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.generate_attached_cluster_agent_token({ attached_cluster: attached_cluster, subject_token: subject_token, subject_token_type: subject_token_type, version: version, grant_type: grant_type, audience: audience, scope: scope, requested_token_type: requested_token_type, options: options }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.generate_attached_cluster_agent_token attached_cluster: attached_cluster, subject_token: subject_token, subject_token_type: subject_token_type, version: version, grant_type: grant_type, audience: audience, scope: scope, requested_token_type: requested_token_type, options: options do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.generate_attached_cluster_agent_token ::Google::Cloud::GkeMultiCloud::V1::GenerateAttachedClusterAgentTokenRequest.new(attached_cluster: attached_cluster, subject_token: subject_token, subject_token_type: subject_token_type, version: version, grant_type: grant_type, audience: audience, scope: scope, requested_token_type: requested_token_type, options: options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.generate_attached_cluster_agent_token({ attached_cluster: attached_cluster, subject_token: subject_token, subject_token_type: subject_token_type, version: version, grant_type: grant_type, audience: audience, scope: scope, requested_token_type: requested_token_type, options: options }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.generate_attached_cluster_agent_token(::Google::Cloud::GkeMultiCloud::V1::GenerateAttachedClusterAgentTokenRequest.new(attached_cluster: attached_cluster, subject_token: subject_token, subject_token_type: subject_token_type, version: version, grant_type: grant_type, audience: audience, scope: scope, requested_token_type: requested_token_type, options: options), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, generate_attached_cluster_agent_token_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Operations, client.operations_client
  end
end
