# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/gkemulticloud/v1/attached_service_pb"
require "google/cloud/gke_multi_cloud/v1/attached_clusters/rest"


class ::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_attached_cluster
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    attached_cluster = {}
    attached_cluster_id = "hello world"
    validate_only = true

    create_attached_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Rest::ServiceStub.stub :transcode_create_attached_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_attached_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_attached_cluster({ parent: parent, attached_cluster: attached_cluster, attached_cluster_id: attached_cluster_id, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_attached_cluster parent: parent, attached_cluster: attached_cluster, attached_cluster_id: attached_cluster_id, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_attached_cluster ::Google::Cloud::GkeMultiCloud::V1::CreateAttachedClusterRequest.new(parent: parent, attached_cluster: attached_cluster, attached_cluster_id: attached_cluster_id, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_attached_cluster({ parent: parent, attached_cluster: attached_cluster, attached_cluster_id: attached_cluster_id, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_attached_cluster(::Google::Cloud::GkeMultiCloud::V1::CreateAttachedClusterRequest.new(parent: parent, attached_cluster: attached_cluster, attached_cluster_id: attached_cluster_id, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_attached_cluster_client_stub.call_count
      end
    end
  end

  def test_update_attached_cluster
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    attached_cluster = {}
    validate_only = true
    update_mask = {}

    update_attached_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Rest::ServiceStub.stub :transcode_update_attached_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_attached_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_attached_cluster({ attached_cluster: attached_cluster, validate_only: validate_only, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_attached_cluster attached_cluster: attached_cluster, validate_only: validate_only, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_attached_cluster ::Google::Cloud::GkeMultiCloud::V1::UpdateAttachedClusterRequest.new(attached_cluster: attached_cluster, validate_only: validate_only, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_attached_cluster({ attached_cluster: attached_cluster, validate_only: validate_only, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_attached_cluster(::Google::Cloud::GkeMultiCloud::V1::UpdateAttachedClusterRequest.new(attached_cluster: attached_cluster, validate_only: validate_only, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_attached_cluster_client_stub.call_count
      end
    end
  end

  def test_import_attached_cluster
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    validate_only = true
    fleet_membership = "hello world"
    platform_version = "hello world"
    distribution = "hello world"
    proxy_config = {}

    import_attached_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Rest::ServiceStub.stub :transcode_import_attached_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, import_attached_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.import_attached_cluster({ parent: parent, validate_only: validate_only, fleet_membership: fleet_membership, platform_version: platform_version, distribution: distribution, proxy_config: proxy_config }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.import_attached_cluster parent: parent, validate_only: validate_only, fleet_membership: fleet_membership, platform_version: platform_version, distribution: distribution, proxy_config: proxy_config do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.import_attached_cluster ::Google::Cloud::GkeMultiCloud::V1::ImportAttachedClusterRequest.new(parent: parent, validate_only: validate_only, fleet_membership: fleet_membership, platform_version: platform_version, distribution: distribution, proxy_config: proxy_config) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.import_attached_cluster({ parent: parent, validate_only: validate_only, fleet_membership: fleet_membership, platform_version: platform_version, distribution: distribution, proxy_config: proxy_config }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.import_attached_cluster(::Google::Cloud::GkeMultiCloud::V1::ImportAttachedClusterRequest.new(parent: parent, validate_only: validate_only, fleet_membership: fleet_membership, platform_version: platform_version, distribution: distribution, proxy_config: proxy_config), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, import_attached_cluster_client_stub.call_count
      end
    end
  end

  def test_get_attached_cluster
    # Create test objects.
    client_result = ::Google::Cloud::GkeMultiCloud::V1::AttachedCluster.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_attached_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Rest::ServiceStub.stub :transcode_get_attached_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_attached_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_attached_cluster({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_attached_cluster name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_attached_cluster ::Google::Cloud::GkeMultiCloud::V1::GetAttachedClusterRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_attached_cluster({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_attached_cluster(::Google::Cloud::GkeMultiCloud::V1::GetAttachedClusterRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_attached_cluster_client_stub.call_count
      end
    end
  end

  def test_list_attached_clusters
    # Create test objects.
    client_result = ::Google::Cloud::GkeMultiCloud::V1::ListAttachedClustersResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_attached_clusters_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Rest::ServiceStub.stub :transcode_list_attached_clusters_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_attached_clusters_client_stub do
        # Create client
        client = ::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_attached_clusters({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_attached_clusters parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_attached_clusters ::Google::Cloud::GkeMultiCloud::V1::ListAttachedClustersRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_attached_clusters({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_attached_clusters(::Google::Cloud::GkeMultiCloud::V1::ListAttachedClustersRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_attached_clusters_client_stub.call_count
      end
    end
  end

  def test_delete_attached_cluster
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    validate_only = true
    allow_missing = true
    ignore_errors = true
    etag = "hello world"

    delete_attached_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Rest::ServiceStub.stub :transcode_delete_attached_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_attached_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_attached_cluster({ name: name, validate_only: validate_only, allow_missing: allow_missing, ignore_errors: ignore_errors, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_attached_cluster name: name, validate_only: validate_only, allow_missing: allow_missing, ignore_errors: ignore_errors, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_attached_cluster ::Google::Cloud::GkeMultiCloud::V1::DeleteAttachedClusterRequest.new(name: name, validate_only: validate_only, allow_missing: allow_missing, ignore_errors: ignore_errors, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_attached_cluster({ name: name, validate_only: validate_only, allow_missing: allow_missing, ignore_errors: ignore_errors, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_attached_cluster(::Google::Cloud::GkeMultiCloud::V1::DeleteAttachedClusterRequest.new(name: name, validate_only: validate_only, allow_missing: allow_missing, ignore_errors: ignore_errors, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_attached_cluster_client_stub.call_count
      end
    end
  end

  def test_get_attached_server_config
    # Create test objects.
    client_result = ::Google::Cloud::GkeMultiCloud::V1::AttachedServerConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_attached_server_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Rest::ServiceStub.stub :transcode_get_attached_server_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_attached_server_config_client_stub do
        # Create client
        client = ::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_attached_server_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_attached_server_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_attached_server_config ::Google::Cloud::GkeMultiCloud::V1::GetAttachedServerConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_attached_server_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_attached_server_config(::Google::Cloud::GkeMultiCloud::V1::GetAttachedServerConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_attached_server_config_client_stub.call_count
      end
    end
  end

  def test_generate_attached_cluster_install_manifest
    # Create test objects.
    client_result = ::Google::Cloud::GkeMultiCloud::V1::GenerateAttachedClusterInstallManifestResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    attached_cluster_id = "hello world"
    platform_version = "hello world"
    proxy_config = {}

    generate_attached_cluster_install_manifest_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Rest::ServiceStub.stub :transcode_generate_attached_cluster_install_manifest_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, generate_attached_cluster_install_manifest_client_stub do
        # Create client
        client = ::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.generate_attached_cluster_install_manifest({ parent: parent, attached_cluster_id: attached_cluster_id, platform_version: platform_version, proxy_config: proxy_config }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.generate_attached_cluster_install_manifest parent: parent, attached_cluster_id: attached_cluster_id, platform_version: platform_version, proxy_config: proxy_config do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.generate_attached_cluster_install_manifest ::Google::Cloud::GkeMultiCloud::V1::GenerateAttachedClusterInstallManifestRequest.new(parent: parent, attached_cluster_id: attached_cluster_id, platform_version: platform_version, proxy_config: proxy_config) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.generate_attached_cluster_install_manifest({ parent: parent, attached_cluster_id: attached_cluster_id, platform_version: platform_version, proxy_config: proxy_config }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.generate_attached_cluster_install_manifest(::Google::Cloud::GkeMultiCloud::V1::GenerateAttachedClusterInstallManifestRequest.new(parent: parent, attached_cluster_id: attached_cluster_id, platform_version: platform_version, proxy_config: proxy_config), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, generate_attached_cluster_install_manifest_client_stub.call_count
      end
    end
  end

  def test_generate_attached_cluster_agent_token
    # Create test objects.
    client_result = ::Google::Cloud::GkeMultiCloud::V1::GenerateAttachedClusterAgentTokenResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    attached_cluster = "hello world"
    subject_token = "hello world"
    subject_token_type = "hello world"
    version = "hello world"
    grant_type = "hello world"
    audience = "hello world"
    scope = "hello world"
    requested_token_type = "hello world"
    options = "hello world"

    generate_attached_cluster_agent_token_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Rest::ServiceStub.stub :transcode_generate_attached_cluster_agent_token_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, generate_attached_cluster_agent_token_client_stub do
        # Create client
        client = ::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.generate_attached_cluster_agent_token({ attached_cluster: attached_cluster, subject_token: subject_token, subject_token_type: subject_token_type, version: version, grant_type: grant_type, audience: audience, scope: scope, requested_token_type: requested_token_type, options: options }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.generate_attached_cluster_agent_token attached_cluster: attached_cluster, subject_token: subject_token, subject_token_type: subject_token_type, version: version, grant_type: grant_type, audience: audience, scope: scope, requested_token_type: requested_token_type, options: options do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.generate_attached_cluster_agent_token ::Google::Cloud::GkeMultiCloud::V1::GenerateAttachedClusterAgentTokenRequest.new(attached_cluster: attached_cluster, subject_token: subject_token, subject_token_type: subject_token_type, version: version, grant_type: grant_type, audience: audience, scope: scope, requested_token_type: requested_token_type, options: options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.generate_attached_cluster_agent_token({ attached_cluster: attached_cluster, subject_token: subject_token, subject_token_type: subject_token_type, version: version, grant_type: grant_type, audience: audience, scope: scope, requested_token_type: requested_token_type, options: options }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.generate_attached_cluster_agent_token(::Google::Cloud::GkeMultiCloud::V1::GenerateAttachedClusterAgentTokenRequest.new(attached_cluster: attached_cluster, subject_token: subject_token, subject_token_type: subject_token_type, version: version, grant_type: grant_type, audience: audience, scope: scope, requested_token_type: requested_token_type, options: options), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, generate_attached_cluster_agent_token_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Rest::Client::Configuration, config
  end
end
