# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module GkeMultiCloud
      module V1
        # Jwk is a JSON Web Key as specified in RFC 7517.
        # @!attribute [rw] kty
        #   @return [::String]
        #     Key Type.
        # @!attribute [rw] alg
        #   @return [::String]
        #     Algorithm.
        # @!attribute [rw] use
        #   @return [::String]
        #     Permitted uses for the public keys.
        # @!attribute [rw] kid
        #   @return [::String]
        #     Key ID.
        # @!attribute [rw] n
        #   @return [::String]
        #     Used for RSA keys.
        # @!attribute [rw] e
        #   @return [::String]
        #     Used for RSA keys.
        # @!attribute [rw] x
        #   @return [::String]
        #     Used for ECDSA keys.
        # @!attribute [rw] y
        #   @return [::String]
        #     Used for ECDSA keys.
        # @!attribute [rw] crv
        #   @return [::String]
        #     Used for ECDSA keys.
        class Jwk
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Workload Identity settings.
        # @!attribute [rw] issuer_uri
        #   @return [::String]
        #     The OIDC issuer URL for this cluster.
        # @!attribute [rw] workload_pool
        #   @return [::String]
        #     The Workload Identity Pool associated to the cluster.
        # @!attribute [rw] identity_provider
        #   @return [::String]
        #     The ID of the OIDC Identity Provider (IdP) associated to the Workload
        #     Identity Pool.
        class WorkloadIdentityConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Constraints applied to pods.
        # @!attribute [rw] max_pods_per_node
        #   @return [::Integer]
        #     Required. The maximum number of pods to schedule on a single node.
        class MaxPodsConstraint
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata about a long-running operation.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which this operation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which this operation was completed.
        # @!attribute [r] target
        #   @return [::String]
        #     Output only. The name of the resource associated to this operation.
        # @!attribute [r] status_detail
        #   @return [::String]
        #     Output only. Human-readable status of the operation, if any.
        # @!attribute [r] error_detail
        #   @return [::String]
        #     Output only. Human-readable status of any error that occurred during the
        #     operation.
        # @!attribute [r] verb
        #   @return [::String]
        #     Output only. The verb associated with the API method which triggered this
        #     operation. Possible values are "create", "delete", "update" and "import".
        # @!attribute [r] requested_cancellation
        #   @return [::Boolean]
        #     Output only. Identifies whether cancellation has been requested for the
        #     operation. Operations that have successfully been cancelled have
        #     {::Google::Longrunning::Operation#error google.longrunning.Operation.error}
        #     value with a {::Google::Rpc::Status#code google.rpc.Status.code} of 1,
        #     corresponding to `Code.CANCELLED`.
        class OperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The taint content for the node taint.
        # @!attribute [rw] key
        #   @return [::String]
        #     Required. Key for the taint.
        # @!attribute [rw] value
        #   @return [::String]
        #     Required. Value for the taint.
        # @!attribute [rw] effect
        #   @return [::Google::Cloud::GkeMultiCloud::V1::NodeTaint::Effect]
        #     Required. The taint effect.
        class NodeTaint
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The taint effect.
          module Effect
            # Not set.
            EFFECT_UNSPECIFIED = 0

            # Do not allow new pods to schedule onto the node unless they tolerate the
            # taint, but allow all pods submitted to Kubelet without going through the
            # scheduler to start, and allow all already-running pods to continue
            # running. Enforced by the scheduler.
            NO_SCHEDULE = 1

            # Like TaintEffectNoSchedule, but the scheduler tries not to schedule
            # new pods onto the node, rather than prohibiting new pods from scheduling
            # onto the node entirely. Enforced by the scheduler.
            PREFER_NO_SCHEDULE = 2

            # Evict any already-running pods that do not tolerate the taint.
            # Currently enforced by NodeController.
            NO_EXECUTE = 3
          end
        end

        # Configuration for node pool kubelet options.
        # @!attribute [rw] insecure_kubelet_readonly_port_enabled
        #   @return [::Boolean]
        #     Optional. Enable the insecure kubelet read only port.
        # @!attribute [rw] cpu_manager_policy
        #   @return [::String]
        #     Optional. Control the CPU management policy on the node.
        #     See
        #     https://kubernetes.io/docs/tasks/administer-cluster/cpu-management-policies/
        #
        #     The following values are allowed.
        #     * "none": the default, which represents the existing scheduling behavior.
        #     * "static": allows pods with certain resource characteristics to be granted
        #     increased CPU affinity and exclusivity on the node.
        #     The default value is 'none' if unspecified.
        # @!attribute [rw] cpu_cfs_quota
        #   @return [::Boolean]
        #     Optional. Enable CPU CFS quota enforcement for containers that specify CPU
        #     limits.
        #
        #     This option is enabled by default which makes kubelet use CFS quota
        #     (https://www.kernel.org/doc/Documentation/scheduler/sched-bwc.txt) to
        #     enforce container CPU limits. Otherwise, CPU limits will not be enforced at
        #     all.
        #
        #     Disable this option to mitigate CPU throttling problems while still having
        #     your pods to be in Guaranteed QoS class by specifying the CPU limits.
        #
        #     The default value is 'true' if unspecified.
        # @!attribute [rw] cpu_cfs_quota_period
        #   @return [::String]
        #     Optional. Set the CPU CFS quota period value 'cpu.cfs_period_us'.
        #
        #     The string must be a sequence of decimal numbers, each with optional
        #     fraction and a unit suffix, such as "300ms".
        #     Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h".
        #     The value must be a positive duration.
        #
        #     The default value is '100ms' if unspecified.
        # @!attribute [rw] pod_pids_limit
        #   @return [::Integer]
        #     Optional. Set the Pod PID limits. See
        #     https://kubernetes.io/docs/concepts/policy/pid-limiting/#pod-pid-limits
        #
        #     Controls the maximum number of processes allowed to run in a pod. The value
        #     must be greater than or equal to 1024 and less than 4194304.
        class NodeKubeletConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Fleet related configuration.
        #
        # Fleets are a Google Cloud concept for logically organizing clusters,
        # letting you use and manage multi-cluster capabilities and apply
        # consistent policies across your systems.
        #
        # See [Anthos
        # Fleets](https://cloud.google.com/anthos/multicluster-management/fleets) for
        # more details on Anthos multi-cluster capabilities using Fleets.
        # @!attribute [rw] project
        #   @return [::String]
        #     Required. The name of the Fleet host project where this cluster will be
        #     registered.
        #
        #     Project names are formatted as
        #     `projects/<project-number>`.
        # @!attribute [r] membership
        #   @return [::String]
        #     Output only. The name of the managed Hub Membership resource associated to
        #     this cluster.
        #
        #     Membership names are formatted as
        #     `projects/<project-number>/locations/global/membership/<cluster-id>`.
        class Fleet
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Parameters that describe the Logging configuration in a cluster.
        # @!attribute [rw] component_config
        #   @return [::Google::Cloud::GkeMultiCloud::V1::LoggingComponentConfig]
        #     The configuration of the logging components;
        class LoggingConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Parameters that describe the Logging component configuration in a cluster.
        # @!attribute [rw] enable_components
        #   @return [::Array<::Google::Cloud::GkeMultiCloud::V1::LoggingComponentConfig::Component>]
        #     The components to be enabled.
        class LoggingComponentConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The components of the logging configuration;
          module Component
            # No component is specified
            COMPONENT_UNSPECIFIED = 0

            # This indicates that system logging components is enabled.
            SYSTEM_COMPONENTS = 1

            # This indicates that user workload logging component is enabled.
            WORKLOADS = 2
          end
        end

        # Parameters that describe the Monitoring configuration in a cluster.
        # @!attribute [rw] managed_prometheus_config
        #   @return [::Google::Cloud::GkeMultiCloud::V1::ManagedPrometheusConfig]
        #     Enable Google Cloud Managed Service for Prometheus in the cluster.
        # @!attribute [rw] cloud_monitoring_config
        #   @return [::Google::Cloud::GkeMultiCloud::V1::CloudMonitoringConfig]
        #     Optionally enable GKE metrics.
        #     Only for Attached Clusters.
        class MonitoringConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ManagedPrometheusConfig defines the configuration for
        # Google Cloud Managed Service for Prometheus.
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     Enable Managed Collection.
        class ManagedPrometheusConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # CloudMonitoringConfig defines the configuration for
        # built-in Cloud Logging and Monitoring.
        # Only for Attached Clusters.
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     Enable GKE-native logging and metrics.
        #     Only for Attached Clusters.
        class CloudMonitoringConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for Binary Authorization.
        # @!attribute [rw] evaluation_mode
        #   @return [::Google::Cloud::GkeMultiCloud::V1::BinaryAuthorization::EvaluationMode]
        #     Mode of operation for binauthz policy evaluation. If unspecified, defaults
        #     to DISABLED.
        class BinaryAuthorization
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Binary Authorization mode of operation.
          module EvaluationMode
            # Default value
            EVALUATION_MODE_UNSPECIFIED = 0

            # Disable BinaryAuthorization
            DISABLED = 1

            # Enforce Kubernetes admission requests with BinaryAuthorization using the
            # project's singleton policy.
            PROJECT_SINGLETON_POLICY_ENFORCE = 2
          end
        end

        # SecurityPostureConfig defines the flags needed to enable/disable features for
        # the Security Posture API.
        # @!attribute [rw] vulnerability_mode
        #   @return [::Google::Cloud::GkeMultiCloud::V1::SecurityPostureConfig::VulnerabilityMode]
        #     Sets which mode to use for vulnerability scanning.
        class SecurityPostureConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # VulnerabilityMode defines enablement mode for vulnerability scanning.
          module VulnerabilityMode
            # Default value not specified.
            VULNERABILITY_MODE_UNSPECIFIED = 0

            # Disables vulnerability scanning on the cluster.
            VULNERABILITY_DISABLED = 1

            # Applies the Security Posture's vulnerability on cluster Enterprise level
            # features.
            VULNERABILITY_ENTERPRISE = 2
          end
        end
      end
    end
  end
end
