# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module GkeMultiCloud
      module V1
        # Request message for `AwsClusters.CreateAwsCluster` method.
        # @deprecated This message is deprecated and may be removed in the next major version update.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent location where this
        #     {::Google::Cloud::GkeMultiCloud::V1::AwsCluster AwsCluster} resource will be
        #     created.
        #
        #     Location names are formatted as `projects/<project-id>/locations/<region>`.
        #
        #     See [Resource Names](https://cloud.google.com/apis/design/resource_names)
        #     for more details on Google Cloud resource names.
        # @!attribute [rw] aws_cluster
        #   @return [::Google::Cloud::GkeMultiCloud::V1::AwsCluster]
        #     Required. The specification of the
        #     {::Google::Cloud::GkeMultiCloud::V1::AwsCluster AwsCluster} to create.
        # @!attribute [rw] aws_cluster_id
        #   @return [::String]
        #     Required. A client provided ID the resource. Must be unique within the
        #     parent resource.
        #
        #     The provided ID will be part of the
        #     {::Google::Cloud::GkeMultiCloud::V1::AwsCluster AwsCluster} resource name
        #     formatted as
        #     `projects/<project-id>/locations/<region>/awsClusters/<cluster-id>`.
        #
        #     Valid characters are `/[a-z][0-9]-/`. Cannot be longer than 63 characters.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     If set, only validate the request, but do not actually create the cluster.
        class CreateAwsClusterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for `AwsClusters.UpdateAwsCluster` method.
        # @deprecated This message is deprecated and may be removed in the next major version update.
        # @!attribute [rw] aws_cluster
        #   @return [::Google::Cloud::GkeMultiCloud::V1::AwsCluster]
        #     Required. The {::Google::Cloud::GkeMultiCloud::V1::AwsCluster AwsCluster}
        #     resource to update.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     If set, only validate the request, but do not actually update the cluster.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Mask of fields to update. At least one path must be supplied in
        #     this field. The elements of the repeated paths field can only include these
        #     fields from {::Google::Cloud::GkeMultiCloud::V1::AwsCluster AwsCluster}:
        #
        #      *   `description`.
        #      *   `annotations`.
        #      *   `control_plane.version`.
        #      *   `authorization.admin_users`.
        #      *   `authorization.admin_groups`.
        #      *   `binary_authorization.evaluation_mode`.
        #      *   `control_plane.aws_services_authentication.role_arn`.
        #      *   `control_plane.aws_services_authentication.role_session_name`.
        #      *   `control_plane.config_encryption.kms_key_arn`.
        #      *   `control_plane.instance_type`.
        #      *   `control_plane.security_group_ids`.
        #      *   `control_plane.proxy_config`.
        #      *   `control_plane.proxy_config.secret_arn`.
        #      *   `control_plane.proxy_config.secret_version`.
        #      *   `control_plane.root_volume.size_gib`.
        #      *   `control_plane.root_volume.volume_type`.
        #      *   `control_plane.root_volume.iops`.
        #      *   `control_plane.root_volume.throughput`.
        #      *   `control_plane.root_volume.kms_key_arn`.
        #      *   `control_plane.ssh_config`.
        #      *   `control_plane.ssh_config.ec2_key_pair`.
        #      *   `control_plane.instance_placement.tenancy`.
        #      *   `control_plane.iam_instance_profile`.
        #      *   `logging_config.component_config.enable_components`.
        #      *   `control_plane.tags`.
        #      *   `monitoring_config.managed_prometheus_config.enabled`.
        #      *   `networking.per_node_pool_sg_rules_disabled`.
        class UpdateAwsClusterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for `AwsClusters.GetAwsCluster` method.
        # @deprecated This message is deprecated and may be removed in the next major version update.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the
        #     {::Google::Cloud::GkeMultiCloud::V1::AwsCluster AwsCluster} resource to
        #     describe.
        #
        #     `AwsCluster` names are formatted as
        #     `projects/<project-id>/locations/<region>/awsClusters/<cluster-id>`.
        #
        #     See [Resource Names](https://cloud.google.com/apis/design/resource_names)
        #     for more details on Google Cloud Platform resource names.
        class GetAwsClusterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for `AwsClusters.ListAwsClusters` method.
        # @deprecated This message is deprecated and may be removed in the next major version update.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent location which owns this collection of
        #     {::Google::Cloud::GkeMultiCloud::V1::AwsCluster AwsCluster} resources.
        #
        #     Location names are formatted as `projects/<project-id>/locations/<region>`.
        #
        #     See [Resource Names](https://cloud.google.com/apis/design/resource_names)
        #     for more details on Google Cloud Platform resource names.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of items to return.
        #
        #     If not specified, a default value of 50 will be used by the service.
        #     Regardless of the pageSize value, the response can include a partial list
        #     and a caller should only rely on response's
        #     {::Google::Cloud::GkeMultiCloud::V1::ListAwsClustersResponse#next_page_token nextPageToken}
        #     to determine if there are more instances left to be queried.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The `nextPageToken` value returned from a previous
        #     {::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Client#list_aws_clusters awsClusters.list}
        #     request, if any.
        class ListAwsClustersRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for `AwsClusters.ListAwsClusters` method.
        # @deprecated This message is deprecated and may be removed in the next major version update.
        # @!attribute [rw] aws_clusters
        #   @return [::Array<::Google::Cloud::GkeMultiCloud::V1::AwsCluster>]
        #     A list of {::Google::Cloud::GkeMultiCloud::V1::AwsCluster AwsCluster} resources
        #     in the specified Google Cloud Platform project and region region.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are no more
        #     results in the list.
        class ListAwsClustersResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for `AwsClusters.DeleteAwsCluster` method.
        # @deprecated This message is deprecated and may be removed in the next major version update.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name the
        #     {::Google::Cloud::GkeMultiCloud::V1::AwsCluster AwsCluster} to delete.
        #
        #     `AwsCluster` names are formatted as
        #     `projects/<project-id>/locations/<region>/awsClusters/<cluster-id>`.
        #
        #     See [Resource Names](https://cloud.google.com/apis/design/resource_names)
        #     for more details on Google Cloud Platform resource names.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     If set, only validate the request, but do not actually delete the resource.
        # @!attribute [rw] allow_missing
        #   @return [::Boolean]
        #     If set to true, and the
        #     {::Google::Cloud::GkeMultiCloud::V1::AwsCluster AwsCluster} resource is not
        #     found, the request will succeed but no action will be taken on the server
        #     and a completed {::Google::Longrunning::Operation Operation} will be returned.
        #
        #     Useful for idempotent deletion.
        # @!attribute [rw] ignore_errors
        #   @return [::Boolean]
        #     Optional. If set to true, the deletion of
        #     {::Google::Cloud::GkeMultiCloud::V1::AwsCluster AwsCluster} resource will
        #     succeed even if errors occur during deleting in cluster resources. Using
        #     this parameter may result in orphaned resources in the cluster.
        # @!attribute [rw] etag
        #   @return [::String]
        #     The current etag of the
        #     {::Google::Cloud::GkeMultiCloud::V1::AwsCluster AwsCluster}.
        #
        #     Allows clients to perform deletions through optimistic concurrency control.
        #
        #     If the provided etag does not match the current etag of the cluster,
        #     the request will fail and an ABORTED error will be returned.
        class DeleteAwsClusterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for `AwsClusters.CreateAwsNodePool` method.
        # @deprecated This message is deprecated and may be removed in the next major version update.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The {::Google::Cloud::GkeMultiCloud::V1::AwsCluster AwsCluster}
        #     resource where this node pool will be created.
        #
        #     `AwsCluster` names are formatted as
        #     `projects/<project-id>/locations/<region>/awsClusters/<cluster-id>`.
        #
        #     See [Resource Names](https://cloud.google.com/apis/design/resource_names)
        #     for more details on Google Cloud resource names.
        # @!attribute [rw] aws_node_pool
        #   @return [::Google::Cloud::GkeMultiCloud::V1::AwsNodePool]
        #     Required. The specification of the
        #     {::Google::Cloud::GkeMultiCloud::V1::AwsNodePool AwsNodePool} to create.
        # @!attribute [rw] aws_node_pool_id
        #   @return [::String]
        #     Required. A client provided ID the resource. Must be unique within the
        #     parent resource.
        #
        #     The provided ID will be part of the
        #     {::Google::Cloud::GkeMultiCloud::V1::AwsNodePool AwsNodePool} resource name
        #     formatted as
        #     `projects/<project-id>/locations/<region>/awsClusters/<cluster-id>/awsNodePools/<node-pool-id>`.
        #
        #     Valid characters are `/[a-z][0-9]-/`. Cannot be longer than 63 characters.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     If set, only validate the request, but do not actually create the node
        #     pool.
        class CreateAwsNodePoolRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for `AwsClusters.UpdateAwsNodePool` method.
        # @deprecated This message is deprecated and may be removed in the next major version update.
        # @!attribute [rw] aws_node_pool
        #   @return [::Google::Cloud::GkeMultiCloud::V1::AwsNodePool]
        #     Required. The {::Google::Cloud::GkeMultiCloud::V1::AwsNodePool AwsNodePool}
        #     resource to update.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     If set, only validate the request, but don't actually update the node pool.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Mask of fields to update. At least one path must be supplied in
        #     this field. The elements of the repeated paths field can only include these
        #     fields from {::Google::Cloud::GkeMultiCloud::V1::AwsNodePool AwsNodePool}:
        #
        #      *   `annotations`.
        #      *   `version`.
        #      *   `autoscaling.min_node_count`.
        #      *   `autoscaling.max_node_count`.
        #      *   `config.config_encryption.kms_key_arn`.
        #      *   `config.security_group_ids`.
        #      *   `config.root_volume.iops`.
        #      *   `config.root_volume.throughput`.
        #      *   `config.root_volume.kms_key_arn`.
        #      *   `config.root_volume.volume_type`.
        #      *   `config.root_volume.size_gib`.
        #      *   `config.proxy_config`.
        #      *   `config.proxy_config.secret_arn`.
        #      *   `config.proxy_config.secret_version`.
        #      *   `config.ssh_config`.
        #      *   `config.ssh_config.ec2_key_pair`.
        #      *   `config.instance_placement.tenancy`.
        #      *   `config.iam_instance_profile`.
        #      *   `config.labels`.
        #      *   `config.tags`.
        #      *   `config.autoscaling_metrics_collection`.
        #      *   `config.autoscaling_metrics_collection.granularity`.
        #      *   `config.autoscaling_metrics_collection.metrics`.
        #      *   `config.instance_type`.
        #      *   `management.auto_repair`.
        #      *   `management`.
        #      *   `update_settings`.
        #      *   `update_settings.surge_settings`.
        #      *   `update_settings.surge_settings.max_surge`.
        #      *   `update_settings.surge_settings.max_unavailable`.
        class UpdateAwsNodePoolRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for `AwsClusters.RollbackAwsNodePoolUpdate` method.
        # @deprecated This message is deprecated and may be removed in the next major version update.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the
        #     {::Google::Cloud::GkeMultiCloud::V1::AwsNodePool AwsNodePool} resource to
        #     rollback.
        #
        #     `AwsNodePool` names are formatted as
        #     `projects/<project-id>/locations/<region>/awsClusters/<cluster-id>/awsNodePools/<node-pool-id>`.
        #
        #     See [Resource Names](https://cloud.google.com/apis/design/resource_names)
        #     for more details on Google Cloud resource names.
        # @!attribute [rw] respect_pdb
        #   @return [::Boolean]
        #     Optional. Option for rollback to ignore the PodDisruptionBudget when
        #     draining the node pool nodes. Default value is false.
        class RollbackAwsNodePoolUpdateRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for `AwsClusters.GetAwsNodePool` method.
        # @deprecated This message is deprecated and may be removed in the next major version update.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the
        #     {::Google::Cloud::GkeMultiCloud::V1::AwsNodePool AwsNodePool} resource to
        #     describe.
        #
        #     `AwsNodePool` names are formatted as
        #     `projects/<project-id>/locations/<region>/awsClusters/<cluster-id>/awsNodePools/<node-pool-id>`.
        #
        #     See [Resource Names](https://cloud.google.com/apis/design/resource_names)
        #     for more details on Google Cloud resource names.
        class GetAwsNodePoolRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for `AwsClusters.ListAwsNodePools` method.
        # @deprecated This message is deprecated and may be removed in the next major version update.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent `AwsCluster` which owns this collection of
        #     {::Google::Cloud::GkeMultiCloud::V1::AwsNodePool AwsNodePool} resources.
        #
        #     `AwsCluster` names are formatted as
        #     `projects/<project-id>/locations/<region>/awsClusters/<cluster-id>`.
        #
        #     See [Resource Names](https://cloud.google.com/apis/design/resource_names)
        #     for more details on Google Cloud resource names.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of items to return.
        #
        #     If not specified, a default value of 50 will be used by the service.
        #     Regardless of the pageSize value, the response can include a partial list
        #     and a caller should only rely on response's
        #     {::Google::Cloud::GkeMultiCloud::V1::ListAwsNodePoolsResponse#next_page_token nextPageToken}
        #     to determine if there are more instances left to be queried.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The `nextPageToken` value returned from a previous
        #     {::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Client#list_aws_node_pools awsNodePools.list}
        #     request, if any.
        class ListAwsNodePoolsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for `AwsClusters.ListAwsNodePools` method.
        # @deprecated This message is deprecated and may be removed in the next major version update.
        # @!attribute [rw] aws_node_pools
        #   @return [::Array<::Google::Cloud::GkeMultiCloud::V1::AwsNodePool>]
        #     A list of {::Google::Cloud::GkeMultiCloud::V1::AwsNodePool AwsNodePool}
        #     resources in the specified `AwsCluster`.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are no more
        #     results in the list.
        class ListAwsNodePoolsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for `AwsClusters.DeleteAwsNodePool` method.
        # @deprecated This message is deprecated and may be removed in the next major version update.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name the
        #     {::Google::Cloud::GkeMultiCloud::V1::AwsNodePool AwsNodePool} to delete.
        #
        #     `AwsNodePool` names are formatted as
        #     `projects/<project-id>/locations/<region>/awsClusters/<cluster-id>/awsNodePools/<node-pool-id>`.
        #
        #     See [Resource Names](https://cloud.google.com/apis/design/resource_names)
        #     for more details on Google Cloud resource names.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     If set, only validate the request, but do not actually delete the node
        #     pool.
        # @!attribute [rw] allow_missing
        #   @return [::Boolean]
        #     If set to true, and the
        #     {::Google::Cloud::GkeMultiCloud::V1::AwsNodePool AwsNodePool} resource is not
        #     found, the request will succeed but no action will be taken on the server
        #     and a completed {::Google::Longrunning::Operation Operation} will be returned.
        #
        #     Useful for idempotent deletion.
        # @!attribute [rw] ignore_errors
        #   @return [::Boolean]
        #     Optional. If set to true, the deletion of
        #     {::Google::Cloud::GkeMultiCloud::V1::AwsNodePool AwsNodePool} resource will
        #     succeed even if errors occur during deleting in node pool resources. Using
        #     this parameter may result in orphaned resources in the node pool.
        # @!attribute [rw] etag
        #   @return [::String]
        #     The current ETag of the
        #     {::Google::Cloud::GkeMultiCloud::V1::AwsNodePool AwsNodePool}.
        #
        #     Allows clients to perform deletions through optimistic concurrency control.
        #
        #     If the provided ETag does not match the current etag of the node pool,
        #     the request will fail and an ABORTED error will be returned.
        class DeleteAwsNodePoolRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # GetAwsOpenIdConfigRequest gets the OIDC discovery document for the
        # cluster. See the OpenID Connect Discovery 1.0 specification for details.
        # @deprecated This message is deprecated and may be removed in the next major version update.
        # @!attribute [rw] aws_cluster
        #   @return [::String]
        #     Required. The AwsCluster, which owns the OIDC discovery document.
        #     Format:
        #     projects/\\{project}/locations/\\{location}/awsClusters/\\{cluster}
        class GetAwsOpenIdConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # GetAwsJsonWebKeysRequest gets the public component of the keys used by the
        # cluster to sign token requests. This will be the jwks_uri for the discover
        # document returned by getOpenIDConfig. See the OpenID Connect
        # Discovery 1.0 specification for details.
        # @deprecated This message is deprecated and may be removed in the next major version update.
        # @!attribute [rw] aws_cluster
        #   @return [::String]
        #     Required. The AwsCluster, which owns the JsonWebKeys.
        #     Format:
        #     projects/\\{project}/locations/\\{location}/awsClusters/\\{cluster}
        class GetAwsJsonWebKeysRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # GetAwsServerConfigRequest gets the server config of GKE cluster on AWS.
        # @deprecated This message is deprecated and may be removed in the next major version update.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the
        #     {::Google::Cloud::GkeMultiCloud::V1::AwsServerConfig AwsServerConfig} resource
        #     to describe.
        #
        #     `AwsServerConfig` names are formatted as
        #     `projects/<project-id>/locations/<region>/awsServerConfig`.
        #
        #     See [Resource Names](https://cloud.google.com/apis/design/resource_names)
        #     for more details on Google Cloud resource names.
        class GetAwsServerConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for `AwsClusters.GenerateAwsAccessToken` method.
        # @deprecated This message is deprecated and may be removed in the next major version update.
        # @!attribute [rw] aws_cluster
        #   @return [::String]
        #     Required. The name of the
        #     {::Google::Cloud::GkeMultiCloud::V1::AwsCluster AwsCluster} resource to
        #     authenticate to.
        #
        #     `AwsCluster` names are formatted as
        #     `projects/<project-id>/locations/<region>/awsClusters/<cluster-id>`.
        #
        #     See [Resource Names](https://cloud.google.com/apis/design/resource_names)
        #     for more details on Google Cloud resource names.
        class GenerateAwsAccessTokenRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for `AwsClusters.GenerateAwsAccessToken` method.
        # @deprecated This message is deprecated and may be removed in the next major version update.
        # @!attribute [r] access_token
        #   @return [::String]
        #     Output only. Access token to authenticate to k8s api-server.
        # @!attribute [r] expiration_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp at which the token will expire.
        class GenerateAwsAccessTokenResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @deprecated This message is deprecated and may be removed in the next major version update.
        # @!attribute [rw] aws_cluster
        #   @return [::String]
        #     Required.
        # @!attribute [rw] subject_token
        #   @return [::String]
        #     Required.
        # @!attribute [rw] subject_token_type
        #   @return [::String]
        #     Required.
        # @!attribute [rw] version
        #   @return [::String]
        #     Required.
        # @!attribute [rw] node_pool_id
        #   @return [::String]
        #     Optional.
        # @!attribute [rw] grant_type
        #   @return [::String]
        #     Optional.
        # @!attribute [rw] audience
        #   @return [::String]
        #     Optional.
        # @!attribute [rw] scope
        #   @return [::String]
        #     Optional.
        # @!attribute [rw] requested_token_type
        #   @return [::String]
        #     Optional.
        # @!attribute [rw] options
        #   @return [::String]
        #     Optional.
        class GenerateAwsClusterAgentTokenRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @deprecated This message is deprecated and may be removed in the next major version update.
        # @!attribute [rw] access_token
        #   @return [::String]
        # @!attribute [rw] expires_in
        #   @return [::Integer]
        # @!attribute [rw] token_type
        #   @return [::String]
        class GenerateAwsClusterAgentTokenResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
