# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/gkemulticloud/v1/azure_service_pb"

module Google
  module Cloud
    module GkeMultiCloud
      module V1
        module AzureClusters
          ##
          # Client for the AzureClusters service.
          #
          # The AzureClusters API provides a single centrally managed service
          # to create and manage Anthos clusters that run on Azure infrastructure.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "gkemulticloud.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :azure_clusters_stub

            ##
            # Configure the AzureClusters Client class.
            #
            # See {::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @deprecated This service is deprecated and may be removed in the next major version update.
            #
            # @example
            #
            #   # Modify the configuration for all AzureClusters clients
            #   ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "GkeMultiCloud", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.create_azure_client.timeout = 60.0

                default_config.rpcs.get_azure_client.timeout = 60.0
                default_config.rpcs.get_azure_client.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_azure_clients.timeout = 60.0
                default_config.rpcs.list_azure_clients.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.delete_azure_client.timeout = 60.0

                default_config.rpcs.create_azure_cluster.timeout = 60.0

                default_config.rpcs.update_azure_cluster.timeout = 60.0

                default_config.rpcs.get_azure_cluster.timeout = 60.0
                default_config.rpcs.get_azure_cluster.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_azure_clusters.timeout = 60.0
                default_config.rpcs.list_azure_clusters.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.delete_azure_cluster.timeout = 60.0

                default_config.rpcs.generate_azure_cluster_agent_token.timeout = 60.0
                default_config.rpcs.generate_azure_cluster_agent_token.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.generate_azure_access_token.timeout = 60.0
                default_config.rpcs.generate_azure_access_token.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_azure_node_pool.timeout = 60.0

                default_config.rpcs.update_azure_node_pool.timeout = 60.0

                default_config.rpcs.get_azure_node_pool.timeout = 60.0
                default_config.rpcs.get_azure_node_pool.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_azure_node_pools.timeout = 60.0
                default_config.rpcs.list_azure_node_pools.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.delete_azure_node_pool.timeout = 60.0

                default_config.rpcs.get_azure_open_id_config.timeout = 60.0
                default_config.rpcs.get_azure_open_id_config.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_azure_json_web_keys.timeout = 60.0
                default_config.rpcs.get_azure_json_web_keys.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_azure_server_config.timeout = 60.0
                default_config.rpcs.get_azure_server_config.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the AzureClusters Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @azure_clusters_stub.universe_domain
            end

            ##
            # Create a new AzureClusters client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the AzureClusters client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/gkemulticloud/v1/azure_service_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @azure_clusters_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @azure_clusters_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Operations]
            #
            attr_reader :operations_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @azure_clusters_stub.logger
            end

            # Service calls

            ##
            # Creates a new {::Google::Cloud::GkeMultiCloud::V1::AzureClient AzureClient}
            # resource on a given Google Cloud project and region.
            #
            # `AzureClient` resources hold client authentication
            # information needed by the Anthos Multicloud API to manage Azure resources
            # on your Azure subscription on your behalf.
            #
            # If successful, the response contains a newly created
            # {::Google::Longrunning::Operation Operation} resource that can be
            # described to track the status of the operation.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload create_azure_client(request, options = nil)
            #   Pass arguments to `create_azure_client` via a request object, either of type
            #   {::Google::Cloud::GkeMultiCloud::V1::CreateAzureClientRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeMultiCloud::V1::CreateAzureClientRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_azure_client(parent: nil, azure_client: nil, azure_client_id: nil, validate_only: nil)
            #   Pass arguments to `create_azure_client` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent location where this
            #     {::Google::Cloud::GkeMultiCloud::V1::AzureClient AzureClient} resource will be
            #     created.
            #
            #     Location names are formatted as `projects/<project-id>/locations/<region>`.
            #
            #     See [Resource Names](https://cloud.google.com/apis/design/resource_names)
            #     for more details on Google Cloud resource names.
            #   @param azure_client [::Google::Cloud::GkeMultiCloud::V1::AzureClient, ::Hash]
            #     Required. The specification of the
            #     {::Google::Cloud::GkeMultiCloud::V1::AzureClient AzureClient} to create.
            #   @param azure_client_id [::String]
            #     Required. A client provided ID the resource. Must be unique within the
            #     parent resource.
            #
            #     The provided ID will be part of the
            #     {::Google::Cloud::GkeMultiCloud::V1::AzureClient AzureClient} resource name
            #     formatted as
            #     `projects/<project-id>/locations/<region>/azureClients/<client-id>`.
            #
            #     Valid characters are `/[a-z][0-9]-/`. Cannot be longer than 63 characters.
            #   @param validate_only [::Boolean]
            #     If set, only validate the request, but do not actually create the client.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_multi_cloud/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeMultiCloud::V1::CreateAzureClientRequest.new
            #
            #   # Call the create_azure_client method.
            #   result = client.create_azure_client request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_azure_client request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeMultiCloud::V1::CreateAzureClientRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_azure_client.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeMultiCloud::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_azure_client.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_azure_client.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @azure_clusters_stub.call_rpc :create_azure_client, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Describes a specific
            # {::Google::Cloud::GkeMultiCloud::V1::AzureClient AzureClient} resource.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload get_azure_client(request, options = nil)
            #   Pass arguments to `get_azure_client` via a request object, either of type
            #   {::Google::Cloud::GkeMultiCloud::V1::GetAzureClientRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeMultiCloud::V1::GetAzureClientRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_azure_client(name: nil)
            #   Pass arguments to `get_azure_client` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the
            #     {::Google::Cloud::GkeMultiCloud::V1::AzureClient AzureClient} resource to
            #     describe.
            #
            #     {::Google::Cloud::GkeMultiCloud::V1::AzureClient AzureClient} names are
            #     formatted as
            #     `projects/<project-id>/locations/<region>/azureClients/<client-id>`.
            #
            #     See [Resource Names](https://cloud.google.com/apis/design/resource_names)
            #     for more details on Google Cloud resource names.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::GkeMultiCloud::V1::AzureClient]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::GkeMultiCloud::V1::AzureClient]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_multi_cloud/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeMultiCloud::V1::GetAzureClientRequest.new
            #
            #   # Call the get_azure_client method.
            #   result = client.get_azure_client request
            #
            #   # The returned object is of type Google::Cloud::GkeMultiCloud::V1::AzureClient.
            #   p result
            #
            def get_azure_client request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeMultiCloud::V1::GetAzureClientRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_azure_client.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeMultiCloud::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_azure_client.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_azure_client.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @azure_clusters_stub.call_rpc :get_azure_client, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists all {::Google::Cloud::GkeMultiCloud::V1::AzureClient AzureClient}
            # resources on a given Google Cloud project and region.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload list_azure_clients(request, options = nil)
            #   Pass arguments to `list_azure_clients` via a request object, either of type
            #   {::Google::Cloud::GkeMultiCloud::V1::ListAzureClientsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeMultiCloud::V1::ListAzureClientsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_azure_clients(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_azure_clients` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent location which owns this collection of
            #     {::Google::Cloud::GkeMultiCloud::V1::AzureClient AzureClient} resources.
            #
            #     Location names are formatted as `projects/<project-id>/locations/<region>`.
            #
            #     See [Resource Names](https://cloud.google.com/apis/design/resource_names)
            #     for more details on Google Cloud Platform resource names.
            #   @param page_size [::Integer]
            #     The maximum number of items to return.
            #
            #     If not specified, a default value of 50 will be used by the service.
            #     Regardless of the pageSize value, the response can include a partial list
            #     and a caller should only rely on response's
            #     {::Google::Cloud::GkeMultiCloud::V1::ListAzureClientsResponse#next_page_token nextPageToken}
            #     to determine if there are more instances left to be queried.
            #   @param page_token [::String]
            #     The `nextPageToken` value returned from a previous
            #     {::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client#list_azure_clients azureClients.list}
            #     request, if any.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::GkeMultiCloud::V1::AzureClient>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::GkeMultiCloud::V1::AzureClient>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_multi_cloud/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeMultiCloud::V1::ListAzureClientsRequest.new
            #
            #   # Call the list_azure_clients method.
            #   result = client.list_azure_clients request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::GkeMultiCloud::V1::AzureClient.
            #     p item
            #   end
            #
            def list_azure_clients request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeMultiCloud::V1::ListAzureClientsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_azure_clients.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeMultiCloud::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_azure_clients.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_azure_clients.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @azure_clusters_stub.call_rpc :list_azure_clients, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @azure_clusters_stub, :list_azure_clients, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a specific {::Google::Cloud::GkeMultiCloud::V1::AzureClient AzureClient}
            # resource.
            #
            # If the client is used by one or more clusters, deletion will
            # fail and a `FAILED_PRECONDITION` error will be returned.
            #
            # If successful, the response contains a newly created
            # {::Google::Longrunning::Operation Operation} resource that can be
            # described to track the status of the operation.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload delete_azure_client(request, options = nil)
            #   Pass arguments to `delete_azure_client` via a request object, either of type
            #   {::Google::Cloud::GkeMultiCloud::V1::DeleteAzureClientRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeMultiCloud::V1::DeleteAzureClientRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_azure_client(name: nil, allow_missing: nil, validate_only: nil)
            #   Pass arguments to `delete_azure_client` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name the
            #     {::Google::Cloud::GkeMultiCloud::V1::AzureClient AzureClient} to delete.
            #
            #     {::Google::Cloud::GkeMultiCloud::V1::AzureClient AzureClient} names are
            #     formatted as
            #     `projects/<project-id>/locations/<region>/azureClients/<client-id>`.
            #
            #     See [Resource Names](https://cloud.google.com/apis/design/resource_names)
            #     for more details on Google Cloud resource names.
            #   @param allow_missing [::Boolean]
            #     If set to true, and the
            #     {::Google::Cloud::GkeMultiCloud::V1::AzureClient AzureClient} resource is not
            #     found, the request will succeed but no action will be taken on the server
            #     and a completed {::Google::Longrunning::Operation Operation} will be returned.
            #
            #     Useful for idempotent deletion.
            #   @param validate_only [::Boolean]
            #     If set, only validate the request, but do not actually delete the resource.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_multi_cloud/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeMultiCloud::V1::DeleteAzureClientRequest.new
            #
            #   # Call the delete_azure_client method.
            #   result = client.delete_azure_client request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_azure_client request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeMultiCloud::V1::DeleteAzureClientRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_azure_client.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeMultiCloud::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_azure_client.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_azure_client.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @azure_clusters_stub.call_rpc :delete_azure_client, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new {::Google::Cloud::GkeMultiCloud::V1::AzureCluster AzureCluster}
            # resource on a given Google Cloud Platform project and region.
            #
            # If successful, the response contains a newly created
            # {::Google::Longrunning::Operation Operation} resource that can be
            # described to track the status of the operation.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload create_azure_cluster(request, options = nil)
            #   Pass arguments to `create_azure_cluster` via a request object, either of type
            #   {::Google::Cloud::GkeMultiCloud::V1::CreateAzureClusterRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeMultiCloud::V1::CreateAzureClusterRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_azure_cluster(parent: nil, azure_cluster: nil, azure_cluster_id: nil, validate_only: nil)
            #   Pass arguments to `create_azure_cluster` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent location where this
            #     {::Google::Cloud::GkeMultiCloud::V1::AzureCluster AzureCluster} resource will be
            #     created.
            #
            #     Location names are formatted as `projects/<project-id>/locations/<region>`.
            #
            #     See [Resource Names](https://cloud.google.com/apis/design/resource_names)
            #     for more details on Google Cloud resource names.
            #   @param azure_cluster [::Google::Cloud::GkeMultiCloud::V1::AzureCluster, ::Hash]
            #     Required. The specification of the
            #     {::Google::Cloud::GkeMultiCloud::V1::AzureCluster AzureCluster} to create.
            #   @param azure_cluster_id [::String]
            #     Required. A client provided ID the resource. Must be unique within the
            #     parent resource.
            #
            #     The provided ID will be part of the
            #     {::Google::Cloud::GkeMultiCloud::V1::AzureCluster AzureCluster} resource name
            #     formatted as
            #     `projects/<project-id>/locations/<region>/azureClusters/<cluster-id>`.
            #
            #     Valid characters are `/[a-z][0-9]-/`. Cannot be longer than 63 characters.
            #   @param validate_only [::Boolean]
            #     If set, only validate the request, but do not actually create the cluster.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_multi_cloud/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeMultiCloud::V1::CreateAzureClusterRequest.new
            #
            #   # Call the create_azure_cluster method.
            #   result = client.create_azure_cluster request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_azure_cluster request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeMultiCloud::V1::CreateAzureClusterRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_azure_cluster.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeMultiCloud::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_azure_cluster.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_azure_cluster.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @azure_clusters_stub.call_rpc :create_azure_cluster, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates an {::Google::Cloud::GkeMultiCloud::V1::AzureCluster AzureCluster}.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload update_azure_cluster(request, options = nil)
            #   Pass arguments to `update_azure_cluster` via a request object, either of type
            #   {::Google::Cloud::GkeMultiCloud::V1::UpdateAzureClusterRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeMultiCloud::V1::UpdateAzureClusterRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_azure_cluster(azure_cluster: nil, validate_only: nil, update_mask: nil)
            #   Pass arguments to `update_azure_cluster` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param azure_cluster [::Google::Cloud::GkeMultiCloud::V1::AzureCluster, ::Hash]
            #     Required. The {::Google::Cloud::GkeMultiCloud::V1::AzureCluster AzureCluster}
            #     resource to update.
            #   @param validate_only [::Boolean]
            #     If set, only validate the request, but do not actually update the cluster.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Mask of fields to update. At least one path must be supplied in
            #     this field. The elements of the repeated paths field can only include these
            #     fields from {::Google::Cloud::GkeMultiCloud::V1::AzureCluster AzureCluster}:
            #
            #      *   `description`.
            #      *   `azureClient`.
            #      *   `control_plane.version`.
            #      *   `control_plane.vm_size`.
            #      *   `annotations`.
            #      *   `authorization.admin_users`.
            #      *   `authorization.admin_groups`.
            #      *   `control_plane.root_volume.size_gib`.
            #      *   `azure_services_authentication`.
            #      *   `azure_services_authentication.tenant_id`.
            #      *   `azure_services_authentication.application_id`.
            #      *   `control_plane.proxy_config`.
            #      *   `control_plane.proxy_config.resource_group_id`.
            #      *   `control_plane.proxy_config.secret_id`.
            #      *   `control_plane.ssh_config.authorized_key`.
            #      *   `logging_config.component_config.enable_components`
            #      *   `monitoring_config.managed_prometheus_config.enabled`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_multi_cloud/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeMultiCloud::V1::UpdateAzureClusterRequest.new
            #
            #   # Call the update_azure_cluster method.
            #   result = client.update_azure_cluster request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_azure_cluster request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeMultiCloud::V1::UpdateAzureClusterRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_azure_cluster.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeMultiCloud::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.azure_cluster&.name
                header_params["azure_cluster.name"] = request.azure_cluster.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_azure_cluster.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_azure_cluster.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @azure_clusters_stub.call_rpc :update_azure_cluster, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Describes a specific
            # {::Google::Cloud::GkeMultiCloud::V1::AzureCluster AzureCluster} resource.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload get_azure_cluster(request, options = nil)
            #   Pass arguments to `get_azure_cluster` via a request object, either of type
            #   {::Google::Cloud::GkeMultiCloud::V1::GetAzureClusterRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeMultiCloud::V1::GetAzureClusterRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_azure_cluster(name: nil)
            #   Pass arguments to `get_azure_cluster` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the
            #     {::Google::Cloud::GkeMultiCloud::V1::AzureCluster AzureCluster} resource to
            #     describe.
            #
            #     `AzureCluster` names are formatted as
            #     `projects/<project-id>/locations/<region>/azureClusters/<cluster-id>`.
            #
            #     See [Resource Names](https://cloud.google.com/apis/design/resource_names)
            #     for more details on Google Cloud Platform resource names.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::GkeMultiCloud::V1::AzureCluster]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::GkeMultiCloud::V1::AzureCluster]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_multi_cloud/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeMultiCloud::V1::GetAzureClusterRequest.new
            #
            #   # Call the get_azure_cluster method.
            #   result = client.get_azure_cluster request
            #
            #   # The returned object is of type Google::Cloud::GkeMultiCloud::V1::AzureCluster.
            #   p result
            #
            def get_azure_cluster request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeMultiCloud::V1::GetAzureClusterRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_azure_cluster.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeMultiCloud::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_azure_cluster.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_azure_cluster.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @azure_clusters_stub.call_rpc :get_azure_cluster, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists all {::Google::Cloud::GkeMultiCloud::V1::AzureCluster AzureCluster}
            # resources on a given Google Cloud project and region.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload list_azure_clusters(request, options = nil)
            #   Pass arguments to `list_azure_clusters` via a request object, either of type
            #   {::Google::Cloud::GkeMultiCloud::V1::ListAzureClustersRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeMultiCloud::V1::ListAzureClustersRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_azure_clusters(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_azure_clusters` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent location which owns this collection of
            #     {::Google::Cloud::GkeMultiCloud::V1::AzureCluster AzureCluster} resources.
            #
            #     Location names are formatted as `projects/<project-id>/locations/<region>`.
            #
            #     See [Resource Names](https://cloud.google.com/apis/design/resource_names)
            #     for more details on Google Cloud Platform resource names.
            #   @param page_size [::Integer]
            #     The maximum number of items to return.
            #
            #     If not specified, a default value of 50 will be used by the service.
            #     Regardless of the pageSize value, the response can include a partial list
            #     and a caller should only rely on response's
            #     {::Google::Cloud::GkeMultiCloud::V1::ListAzureClustersResponse#next_page_token nextPageToken}
            #     to determine if there are more instances left to be queried.
            #   @param page_token [::String]
            #     The `nextPageToken` value returned from a previous
            #     {::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client#list_azure_clusters azureClusters.list}
            #     request, if any.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::GkeMultiCloud::V1::AzureCluster>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::GkeMultiCloud::V1::AzureCluster>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_multi_cloud/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeMultiCloud::V1::ListAzureClustersRequest.new
            #
            #   # Call the list_azure_clusters method.
            #   result = client.list_azure_clusters request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::GkeMultiCloud::V1::AzureCluster.
            #     p item
            #   end
            #
            def list_azure_clusters request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeMultiCloud::V1::ListAzureClustersRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_azure_clusters.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeMultiCloud::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_azure_clusters.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_azure_clusters.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @azure_clusters_stub.call_rpc :list_azure_clusters, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @azure_clusters_stub, :list_azure_clusters, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a specific
            # {::Google::Cloud::GkeMultiCloud::V1::AzureCluster AzureCluster} resource.
            #
            # Fails if the cluster has one or more associated
            # {::Google::Cloud::GkeMultiCloud::V1::AzureNodePool AzureNodePool} resources.
            #
            # If successful, the response contains a newly created
            # {::Google::Longrunning::Operation Operation} resource that can be
            # described to track the status of the operation.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload delete_azure_cluster(request, options = nil)
            #   Pass arguments to `delete_azure_cluster` via a request object, either of type
            #   {::Google::Cloud::GkeMultiCloud::V1::DeleteAzureClusterRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeMultiCloud::V1::DeleteAzureClusterRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_azure_cluster(name: nil, allow_missing: nil, validate_only: nil, etag: nil, ignore_errors: nil)
            #   Pass arguments to `delete_azure_cluster` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name the
            #     {::Google::Cloud::GkeMultiCloud::V1::AzureCluster AzureCluster} to delete.
            #
            #     `AzureCluster` names are formatted as
            #     `projects/<project-id>/locations/<region>/azureClusters/<cluster-id>`.
            #
            #     See [Resource Names](https://cloud.google.com/apis/design/resource_names)
            #     for more details on Google Cloud Platform resource names.
            #   @param allow_missing [::Boolean]
            #     If set to true, and the
            #     {::Google::Cloud::GkeMultiCloud::V1::AzureCluster AzureCluster} resource is not
            #     found, the request will succeed but no action will be taken on the server
            #     and a completed {::Google::Longrunning::Operation Operation} will be returned.
            #
            #     Useful for idempotent deletion.
            #   @param validate_only [::Boolean]
            #     If set, only validate the request, but do not actually delete the resource.
            #   @param etag [::String]
            #     The current etag of the
            #     {::Google::Cloud::GkeMultiCloud::V1::AzureCluster AzureCluster}.
            #
            #     Allows clients to perform deletions through optimistic concurrency control.
            #
            #     If the provided etag does not match the current etag of the cluster,
            #     the request will fail and an ABORTED error will be returned.
            #   @param ignore_errors [::Boolean]
            #     Optional. If set to true, the deletion of
            #     {::Google::Cloud::GkeMultiCloud::V1::AzureCluster AzureCluster} resource will
            #     succeed even if errors occur during deleting in cluster resources. Using
            #     this parameter may result in orphaned resources in the cluster.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_multi_cloud/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeMultiCloud::V1::DeleteAzureClusterRequest.new
            #
            #   # Call the delete_azure_cluster method.
            #   result = client.delete_azure_cluster request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_azure_cluster request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeMultiCloud::V1::DeleteAzureClusterRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_azure_cluster.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeMultiCloud::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_azure_cluster.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_azure_cluster.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @azure_clusters_stub.call_rpc :delete_azure_cluster, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Generates an access token for a cluster agent.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload generate_azure_cluster_agent_token(request, options = nil)
            #   Pass arguments to `generate_azure_cluster_agent_token` via a request object, either of type
            #   {::Google::Cloud::GkeMultiCloud::V1::GenerateAzureClusterAgentTokenRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeMultiCloud::V1::GenerateAzureClusterAgentTokenRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload generate_azure_cluster_agent_token(azure_cluster: nil, subject_token: nil, subject_token_type: nil, version: nil, node_pool_id: nil, grant_type: nil, audience: nil, scope: nil, requested_token_type: nil, options: nil)
            #   Pass arguments to `generate_azure_cluster_agent_token` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param azure_cluster [::String]
            #     Required.
            #   @param subject_token [::String]
            #     Required.
            #   @param subject_token_type [::String]
            #     Required.
            #   @param version [::String]
            #     Required.
            #   @param node_pool_id [::String]
            #     Optional.
            #   @param grant_type [::String]
            #     Optional.
            #   @param audience [::String]
            #     Optional.
            #   @param scope [::String]
            #     Optional.
            #   @param requested_token_type [::String]
            #     Optional.
            #   @param options [::String]
            #     Optional.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::GkeMultiCloud::V1::GenerateAzureClusterAgentTokenResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::GkeMultiCloud::V1::GenerateAzureClusterAgentTokenResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_multi_cloud/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeMultiCloud::V1::GenerateAzureClusterAgentTokenRequest.new
            #
            #   # Call the generate_azure_cluster_agent_token method.
            #   result = client.generate_azure_cluster_agent_token request
            #
            #   # The returned object is of type Google::Cloud::GkeMultiCloud::V1::GenerateAzureClusterAgentTokenResponse.
            #   p result
            #
            def generate_azure_cluster_agent_token request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeMultiCloud::V1::GenerateAzureClusterAgentTokenRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.generate_azure_cluster_agent_token.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeMultiCloud::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.azure_cluster
                header_params["azure_cluster"] = request.azure_cluster
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.generate_azure_cluster_agent_token.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.generate_azure_cluster_agent_token.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @azure_clusters_stub.call_rpc :generate_azure_cluster_agent_token, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Generates a short-lived access token to authenticate to a given
            # {::Google::Cloud::GkeMultiCloud::V1::AzureCluster AzureCluster} resource.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload generate_azure_access_token(request, options = nil)
            #   Pass arguments to `generate_azure_access_token` via a request object, either of type
            #   {::Google::Cloud::GkeMultiCloud::V1::GenerateAzureAccessTokenRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeMultiCloud::V1::GenerateAzureAccessTokenRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload generate_azure_access_token(azure_cluster: nil)
            #   Pass arguments to `generate_azure_access_token` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param azure_cluster [::String]
            #     Required. The name of the
            #     {::Google::Cloud::GkeMultiCloud::V1::AzureCluster AzureCluster} resource to
            #     authenticate to.
            #
            #     `AzureCluster` names are formatted as
            #     `projects/<project-id>/locations/<region>/azureClusters/<cluster-id>`.
            #
            #     See [Resource Names](https://cloud.google.com/apis/design/resource_names)
            #     for more details on Google Cloud resource names.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::GkeMultiCloud::V1::GenerateAzureAccessTokenResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::GkeMultiCloud::V1::GenerateAzureAccessTokenResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_multi_cloud/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeMultiCloud::V1::GenerateAzureAccessTokenRequest.new
            #
            #   # Call the generate_azure_access_token method.
            #   result = client.generate_azure_access_token request
            #
            #   # The returned object is of type Google::Cloud::GkeMultiCloud::V1::GenerateAzureAccessTokenResponse.
            #   p result
            #
            def generate_azure_access_token request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeMultiCloud::V1::GenerateAzureAccessTokenRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.generate_azure_access_token.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeMultiCloud::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.azure_cluster
                header_params["azure_cluster"] = request.azure_cluster
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.generate_azure_access_token.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.generate_azure_access_token.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @azure_clusters_stub.call_rpc :generate_azure_access_token, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new {::Google::Cloud::GkeMultiCloud::V1::AzureNodePool AzureNodePool},
            # attached to a given
            # {::Google::Cloud::GkeMultiCloud::V1::AzureCluster AzureCluster}.
            #
            # If successful, the response contains a newly created
            # {::Google::Longrunning::Operation Operation} resource that can be
            # described to track the status of the operation.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload create_azure_node_pool(request, options = nil)
            #   Pass arguments to `create_azure_node_pool` via a request object, either of type
            #   {::Google::Cloud::GkeMultiCloud::V1::CreateAzureNodePoolRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeMultiCloud::V1::CreateAzureNodePoolRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_azure_node_pool(parent: nil, azure_node_pool: nil, azure_node_pool_id: nil, validate_only: nil)
            #   Pass arguments to `create_azure_node_pool` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The {::Google::Cloud::GkeMultiCloud::V1::AzureCluster AzureCluster}
            #     resource where this node pool will be created.
            #
            #     `AzureCluster` names are formatted as
            #     `projects/<project-id>/locations/<region>/azureClusters/<cluster-id>`.
            #
            #     See [Resource Names](https://cloud.google.com/apis/design/resource_names)
            #     for more details on Google Cloud resource names.
            #   @param azure_node_pool [::Google::Cloud::GkeMultiCloud::V1::AzureNodePool, ::Hash]
            #     Required. The specification of the
            #     {::Google::Cloud::GkeMultiCloud::V1::AzureNodePool AzureNodePool} to create.
            #   @param azure_node_pool_id [::String]
            #     Required. A client provided ID the resource. Must be unique within the
            #     parent resource.
            #
            #     The provided ID will be part of the
            #     {::Google::Cloud::GkeMultiCloud::V1::AzureNodePool AzureNodePool} resource name
            #     formatted as
            #     `projects/<project-id>/locations/<region>/azureClusters/<cluster-id>/azureNodePools/<node-pool-id>`.
            #
            #     Valid characters are `/[a-z][0-9]-/`. Cannot be longer than 63 characters.
            #   @param validate_only [::Boolean]
            #     If set, only validate the request, but do not actually create the node
            #     pool.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_multi_cloud/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeMultiCloud::V1::CreateAzureNodePoolRequest.new
            #
            #   # Call the create_azure_node_pool method.
            #   result = client.create_azure_node_pool request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_azure_node_pool request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeMultiCloud::V1::CreateAzureNodePoolRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_azure_node_pool.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeMultiCloud::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_azure_node_pool.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_azure_node_pool.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @azure_clusters_stub.call_rpc :create_azure_node_pool, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates an {::Google::Cloud::GkeMultiCloud::V1::AzureNodePool AzureNodePool}.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload update_azure_node_pool(request, options = nil)
            #   Pass arguments to `update_azure_node_pool` via a request object, either of type
            #   {::Google::Cloud::GkeMultiCloud::V1::UpdateAzureNodePoolRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeMultiCloud::V1::UpdateAzureNodePoolRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_azure_node_pool(azure_node_pool: nil, validate_only: nil, update_mask: nil)
            #   Pass arguments to `update_azure_node_pool` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param azure_node_pool [::Google::Cloud::GkeMultiCloud::V1::AzureNodePool, ::Hash]
            #     Required. The {::Google::Cloud::GkeMultiCloud::V1::AzureNodePool AzureNodePool}
            #     resource to update.
            #   @param validate_only [::Boolean]
            #     If set, only validate the request, but don't actually update the node pool.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Mask of fields to update. At least one path must be supplied in
            #     this field. The elements of the repeated paths field can only include these
            #     fields from {::Google::Cloud::GkeMultiCloud::V1::AzureNodePool AzureNodePool}:
            #
            #      *.  `annotations`.
            #      *   `version`.
            #      *   `autoscaling.min_node_count`.
            #      *   `autoscaling.max_node_count`.
            #      *   `config.ssh_config.authorized_key`.
            #      *   `management.auto_repair`.
            #      *   `management`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_multi_cloud/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeMultiCloud::V1::UpdateAzureNodePoolRequest.new
            #
            #   # Call the update_azure_node_pool method.
            #   result = client.update_azure_node_pool request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_azure_node_pool request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeMultiCloud::V1::UpdateAzureNodePoolRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_azure_node_pool.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeMultiCloud::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.azure_node_pool&.name
                header_params["azure_node_pool.name"] = request.azure_node_pool.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_azure_node_pool.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_azure_node_pool.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @azure_clusters_stub.call_rpc :update_azure_node_pool, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Describes a specific
            # {::Google::Cloud::GkeMultiCloud::V1::AzureNodePool AzureNodePool} resource.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload get_azure_node_pool(request, options = nil)
            #   Pass arguments to `get_azure_node_pool` via a request object, either of type
            #   {::Google::Cloud::GkeMultiCloud::V1::GetAzureNodePoolRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeMultiCloud::V1::GetAzureNodePoolRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_azure_node_pool(name: nil)
            #   Pass arguments to `get_azure_node_pool` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the
            #     {::Google::Cloud::GkeMultiCloud::V1::AzureNodePool AzureNodePool} resource to
            #     describe.
            #
            #     `AzureNodePool` names are formatted as
            #     `projects/<project-id>/locations/<region>/azureClusters/<cluster-id>/azureNodePools/<node-pool-id>`.
            #
            #     See [Resource Names](https://cloud.google.com/apis/design/resource_names)
            #     for more details on Google Cloud resource names.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::GkeMultiCloud::V1::AzureNodePool]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::GkeMultiCloud::V1::AzureNodePool]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_multi_cloud/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeMultiCloud::V1::GetAzureNodePoolRequest.new
            #
            #   # Call the get_azure_node_pool method.
            #   result = client.get_azure_node_pool request
            #
            #   # The returned object is of type Google::Cloud::GkeMultiCloud::V1::AzureNodePool.
            #   p result
            #
            def get_azure_node_pool request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeMultiCloud::V1::GetAzureNodePoolRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_azure_node_pool.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeMultiCloud::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_azure_node_pool.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_azure_node_pool.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @azure_clusters_stub.call_rpc :get_azure_node_pool, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists all {::Google::Cloud::GkeMultiCloud::V1::AzureNodePool AzureNodePool}
            # resources on a given
            # {::Google::Cloud::GkeMultiCloud::V1::AzureCluster AzureCluster}.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload list_azure_node_pools(request, options = nil)
            #   Pass arguments to `list_azure_node_pools` via a request object, either of type
            #   {::Google::Cloud::GkeMultiCloud::V1::ListAzureNodePoolsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeMultiCloud::V1::ListAzureNodePoolsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_azure_node_pools(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_azure_node_pools` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent `AzureCluster` which owns this collection of
            #     {::Google::Cloud::GkeMultiCloud::V1::AzureNodePool AzureNodePool} resources.
            #
            #     `AzureCluster` names are formatted as
            #     `projects/<project-id>/locations/<region>/azureClusters/<cluster-id>`.
            #
            #     See [Resource Names](https://cloud.google.com/apis/design/resource_names)
            #     for more details on Google Cloud resource names.
            #   @param page_size [::Integer]
            #     The maximum number of items to return.
            #
            #     If not specified, a default value of 50 will be used by the service.
            #     Regardless of the pageSize value, the response can include a partial list
            #     and a caller should only rely on response's
            #     {::Google::Cloud::GkeMultiCloud::V1::ListAzureNodePoolsResponse#next_page_token nextPageToken}
            #     to determine if there are more instances left to be queried.
            #   @param page_token [::String]
            #     The `nextPageToken` value returned from a previous
            #     {::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client#list_azure_node_pools azureNodePools.list}
            #     request, if any.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::GkeMultiCloud::V1::AzureNodePool>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::GkeMultiCloud::V1::AzureNodePool>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_multi_cloud/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeMultiCloud::V1::ListAzureNodePoolsRequest.new
            #
            #   # Call the list_azure_node_pools method.
            #   result = client.list_azure_node_pools request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::GkeMultiCloud::V1::AzureNodePool.
            #     p item
            #   end
            #
            def list_azure_node_pools request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeMultiCloud::V1::ListAzureNodePoolsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_azure_node_pools.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeMultiCloud::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_azure_node_pools.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_azure_node_pools.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @azure_clusters_stub.call_rpc :list_azure_node_pools, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @azure_clusters_stub, :list_azure_node_pools, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a specific
            # {::Google::Cloud::GkeMultiCloud::V1::AzureNodePool AzureNodePool} resource.
            #
            # If successful, the response contains a newly created
            # {::Google::Longrunning::Operation Operation} resource that can be
            # described to track the status of the operation.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload delete_azure_node_pool(request, options = nil)
            #   Pass arguments to `delete_azure_node_pool` via a request object, either of type
            #   {::Google::Cloud::GkeMultiCloud::V1::DeleteAzureNodePoolRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeMultiCloud::V1::DeleteAzureNodePoolRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_azure_node_pool(name: nil, validate_only: nil, allow_missing: nil, etag: nil, ignore_errors: nil)
            #   Pass arguments to `delete_azure_node_pool` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name the
            #     {::Google::Cloud::GkeMultiCloud::V1::AzureNodePool AzureNodePool} to delete.
            #
            #     `AzureNodePool` names are formatted as
            #     `projects/<project-id>/locations/<region>/azureClusters/<cluster-id>/azureNodePools/<node-pool-id>`.
            #
            #     See [Resource Names](https://cloud.google.com/apis/design/resource_names)
            #     for more details on Google Cloud resource names.
            #   @param validate_only [::Boolean]
            #     If set, only validate the request, but do not actually delete the node
            #     pool.
            #   @param allow_missing [::Boolean]
            #     If set to true, and the
            #     {::Google::Cloud::GkeMultiCloud::V1::AzureNodePool AzureNodePool} resource is
            #     not found, the request will succeed but no action will be taken on the
            #     server and a completed {::Google::Longrunning::Operation Operation} will be
            #     returned.
            #
            #     Useful for idempotent deletion.
            #   @param etag [::String]
            #     The current ETag of the
            #     {::Google::Cloud::GkeMultiCloud::V1::AzureNodePool AzureNodePool}.
            #
            #     Allows clients to perform deletions through optimistic concurrency control.
            #
            #     If the provided ETag does not match the current etag of the node pool,
            #     the request will fail and an ABORTED error will be returned.
            #   @param ignore_errors [::Boolean]
            #     Optional. If set to true, the deletion of
            #     {::Google::Cloud::GkeMultiCloud::V1::AzureNodePool AzureNodePool} resource will
            #     succeed even if errors occur during deleting in node pool resources. Using
            #     this parameter may result in orphaned resources in the node pool.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_multi_cloud/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeMultiCloud::V1::DeleteAzureNodePoolRequest.new
            #
            #   # Call the delete_azure_node_pool method.
            #   result = client.delete_azure_node_pool request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_azure_node_pool request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeMultiCloud::V1::DeleteAzureNodePoolRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_azure_node_pool.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeMultiCloud::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_azure_node_pool.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_azure_node_pool.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @azure_clusters_stub.call_rpc :delete_azure_node_pool, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets the OIDC discovery document for the cluster.
            # See the
            # [OpenID Connect Discovery 1.0
            # specification](https://openid.net/specs/openid-connect-discovery-1_0.html)
            # for details.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload get_azure_open_id_config(request, options = nil)
            #   Pass arguments to `get_azure_open_id_config` via a request object, either of type
            #   {::Google::Cloud::GkeMultiCloud::V1::GetAzureOpenIdConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeMultiCloud::V1::GetAzureOpenIdConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_azure_open_id_config(azure_cluster: nil)
            #   Pass arguments to `get_azure_open_id_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param azure_cluster [::String]
            #     Required. The AzureCluster, which owns the OIDC discovery document.
            #     Format:
            #     projects/<project-id>/locations/<region>/azureClusters/<cluster-id>
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::GkeMultiCloud::V1::AzureOpenIdConfig]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::GkeMultiCloud::V1::AzureOpenIdConfig]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_multi_cloud/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeMultiCloud::V1::GetAzureOpenIdConfigRequest.new
            #
            #   # Call the get_azure_open_id_config method.
            #   result = client.get_azure_open_id_config request
            #
            #   # The returned object is of type Google::Cloud::GkeMultiCloud::V1::AzureOpenIdConfig.
            #   p result
            #
            def get_azure_open_id_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeMultiCloud::V1::GetAzureOpenIdConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_azure_open_id_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeMultiCloud::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.azure_cluster
                header_params["azure_cluster"] = request.azure_cluster
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_azure_open_id_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_azure_open_id_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @azure_clusters_stub.call_rpc :get_azure_open_id_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets the public component of the cluster signing keys in
            # JSON Web Key format.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload get_azure_json_web_keys(request, options = nil)
            #   Pass arguments to `get_azure_json_web_keys` via a request object, either of type
            #   {::Google::Cloud::GkeMultiCloud::V1::GetAzureJsonWebKeysRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeMultiCloud::V1::GetAzureJsonWebKeysRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_azure_json_web_keys(azure_cluster: nil)
            #   Pass arguments to `get_azure_json_web_keys` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param azure_cluster [::String]
            #     Required. The AzureCluster, which owns the JsonWebKeys.
            #     Format:
            #     `projects/<project-id>/locations/<region>/azureClusters/<cluster-id>`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::GkeMultiCloud::V1::AzureJsonWebKeys]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::GkeMultiCloud::V1::AzureJsonWebKeys]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_multi_cloud/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeMultiCloud::V1::GetAzureJsonWebKeysRequest.new
            #
            #   # Call the get_azure_json_web_keys method.
            #   result = client.get_azure_json_web_keys request
            #
            #   # The returned object is of type Google::Cloud::GkeMultiCloud::V1::AzureJsonWebKeys.
            #   p result
            #
            def get_azure_json_web_keys request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeMultiCloud::V1::GetAzureJsonWebKeysRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_azure_json_web_keys.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeMultiCloud::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.azure_cluster
                header_params["azure_cluster"] = request.azure_cluster
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_azure_json_web_keys.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_azure_json_web_keys.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @azure_clusters_stub.call_rpc :get_azure_json_web_keys, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns information, such as supported Azure regions and Kubernetes
            # versions, on a given Google Cloud location.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload get_azure_server_config(request, options = nil)
            #   Pass arguments to `get_azure_server_config` via a request object, either of type
            #   {::Google::Cloud::GkeMultiCloud::V1::GetAzureServerConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeMultiCloud::V1::GetAzureServerConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_azure_server_config(name: nil)
            #   Pass arguments to `get_azure_server_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the
            #     {::Google::Cloud::GkeMultiCloud::V1::AzureServerConfig AzureServerConfig}
            #     resource to describe.
            #
            #     `AzureServerConfig` names are formatted as
            #     `projects/<project-id>/locations/<region>/azureServerConfig`.
            #
            #     See [Resource Names](https://cloud.google.com/apis/design/resource_names)
            #     for more details on Google Cloud resource names.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::GkeMultiCloud::V1::AzureServerConfig]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::GkeMultiCloud::V1::AzureServerConfig]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_multi_cloud/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeMultiCloud::V1::GetAzureServerConfigRequest.new
            #
            #   # Call the get_azure_server_config method.
            #   result = client.get_azure_server_config request
            #
            #   # The returned object is of type Google::Cloud::GkeMultiCloud::V1::AzureServerConfig.
            #   p result
            #
            def get_azure_server_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeMultiCloud::V1::GetAzureServerConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_azure_server_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeMultiCloud::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_azure_server_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_azure_server_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @azure_clusters_stub.call_rpc :get_azure_server_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the AzureClusters API.
            #
            # This class represents the configuration for AzureClusters,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # create_azure_client to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_azure_client.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_azure_client.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::GkeMultiCloud::V1::AzureClusters::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "gkemulticloud.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the AzureClusters API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `create_azure_client`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_azure_client
                ##
                # RPC-specific configuration for `get_azure_client`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_azure_client
                ##
                # RPC-specific configuration for `list_azure_clients`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_azure_clients
                ##
                # RPC-specific configuration for `delete_azure_client`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_azure_client
                ##
                # RPC-specific configuration for `create_azure_cluster`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_azure_cluster
                ##
                # RPC-specific configuration for `update_azure_cluster`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_azure_cluster
                ##
                # RPC-specific configuration for `get_azure_cluster`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_azure_cluster
                ##
                # RPC-specific configuration for `list_azure_clusters`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_azure_clusters
                ##
                # RPC-specific configuration for `delete_azure_cluster`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_azure_cluster
                ##
                # RPC-specific configuration for `generate_azure_cluster_agent_token`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :generate_azure_cluster_agent_token
                ##
                # RPC-specific configuration for `generate_azure_access_token`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :generate_azure_access_token
                ##
                # RPC-specific configuration for `create_azure_node_pool`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_azure_node_pool
                ##
                # RPC-specific configuration for `update_azure_node_pool`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_azure_node_pool
                ##
                # RPC-specific configuration for `get_azure_node_pool`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_azure_node_pool
                ##
                # RPC-specific configuration for `list_azure_node_pools`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_azure_node_pools
                ##
                # RPC-specific configuration for `delete_azure_node_pool`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_azure_node_pool
                ##
                # RPC-specific configuration for `get_azure_open_id_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_azure_open_id_config
                ##
                # RPC-specific configuration for `get_azure_json_web_keys`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_azure_json_web_keys
                ##
                # RPC-specific configuration for `get_azure_server_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_azure_server_config

                # @private
                def initialize parent_rpcs = nil
                  create_azure_client_config = parent_rpcs.create_azure_client if parent_rpcs.respond_to? :create_azure_client
                  @create_azure_client = ::Gapic::Config::Method.new create_azure_client_config
                  get_azure_client_config = parent_rpcs.get_azure_client if parent_rpcs.respond_to? :get_azure_client
                  @get_azure_client = ::Gapic::Config::Method.new get_azure_client_config
                  list_azure_clients_config = parent_rpcs.list_azure_clients if parent_rpcs.respond_to? :list_azure_clients
                  @list_azure_clients = ::Gapic::Config::Method.new list_azure_clients_config
                  delete_azure_client_config = parent_rpcs.delete_azure_client if parent_rpcs.respond_to? :delete_azure_client
                  @delete_azure_client = ::Gapic::Config::Method.new delete_azure_client_config
                  create_azure_cluster_config = parent_rpcs.create_azure_cluster if parent_rpcs.respond_to? :create_azure_cluster
                  @create_azure_cluster = ::Gapic::Config::Method.new create_azure_cluster_config
                  update_azure_cluster_config = parent_rpcs.update_azure_cluster if parent_rpcs.respond_to? :update_azure_cluster
                  @update_azure_cluster = ::Gapic::Config::Method.new update_azure_cluster_config
                  get_azure_cluster_config = parent_rpcs.get_azure_cluster if parent_rpcs.respond_to? :get_azure_cluster
                  @get_azure_cluster = ::Gapic::Config::Method.new get_azure_cluster_config
                  list_azure_clusters_config = parent_rpcs.list_azure_clusters if parent_rpcs.respond_to? :list_azure_clusters
                  @list_azure_clusters = ::Gapic::Config::Method.new list_azure_clusters_config
                  delete_azure_cluster_config = parent_rpcs.delete_azure_cluster if parent_rpcs.respond_to? :delete_azure_cluster
                  @delete_azure_cluster = ::Gapic::Config::Method.new delete_azure_cluster_config
                  generate_azure_cluster_agent_token_config = parent_rpcs.generate_azure_cluster_agent_token if parent_rpcs.respond_to? :generate_azure_cluster_agent_token
                  @generate_azure_cluster_agent_token = ::Gapic::Config::Method.new generate_azure_cluster_agent_token_config
                  generate_azure_access_token_config = parent_rpcs.generate_azure_access_token if parent_rpcs.respond_to? :generate_azure_access_token
                  @generate_azure_access_token = ::Gapic::Config::Method.new generate_azure_access_token_config
                  create_azure_node_pool_config = parent_rpcs.create_azure_node_pool if parent_rpcs.respond_to? :create_azure_node_pool
                  @create_azure_node_pool = ::Gapic::Config::Method.new create_azure_node_pool_config
                  update_azure_node_pool_config = parent_rpcs.update_azure_node_pool if parent_rpcs.respond_to? :update_azure_node_pool
                  @update_azure_node_pool = ::Gapic::Config::Method.new update_azure_node_pool_config
                  get_azure_node_pool_config = parent_rpcs.get_azure_node_pool if parent_rpcs.respond_to? :get_azure_node_pool
                  @get_azure_node_pool = ::Gapic::Config::Method.new get_azure_node_pool_config
                  list_azure_node_pools_config = parent_rpcs.list_azure_node_pools if parent_rpcs.respond_to? :list_azure_node_pools
                  @list_azure_node_pools = ::Gapic::Config::Method.new list_azure_node_pools_config
                  delete_azure_node_pool_config = parent_rpcs.delete_azure_node_pool if parent_rpcs.respond_to? :delete_azure_node_pool
                  @delete_azure_node_pool = ::Gapic::Config::Method.new delete_azure_node_pool_config
                  get_azure_open_id_config_config = parent_rpcs.get_azure_open_id_config if parent_rpcs.respond_to? :get_azure_open_id_config
                  @get_azure_open_id_config = ::Gapic::Config::Method.new get_azure_open_id_config_config
                  get_azure_json_web_keys_config = parent_rpcs.get_azure_json_web_keys if parent_rpcs.respond_to? :get_azure_json_web_keys
                  @get_azure_json_web_keys = ::Gapic::Config::Method.new get_azure_json_web_keys_config
                  get_azure_server_config_config = parent_rpcs.get_azure_server_config if parent_rpcs.respond_to? :get_azure_server_config
                  @get_azure_server_config = ::Gapic::Config::Method.new get_azure_server_config_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
