# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/gkemulticloud/v1/aws_service_pb"
require "google/cloud/gke_multi_cloud/v1/aws_clusters/rest/service_stub"

module Google
  module Cloud
    module GkeMultiCloud
      module V1
        module AwsClusters
          module Rest
            ##
            # REST client for the AwsClusters service.
            #
            # The AwsClusters API provides a single centrally managed service
            # to create and manage Anthos clusters that run on AWS infrastructure.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "gkemulticloud.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :aws_clusters_stub

              ##
              # Configure the AwsClusters Client class.
              #
              # See {::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::Client::Configuration}
              # for a description of the configuration fields.
              # @deprecated This service is deprecated and may be removed in the next major version update.
              #
              # @example
              #
              #   # Modify the configuration for all AwsClusters clients
              #   ::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "GkeMultiCloud", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.create_aws_cluster.timeout = 60.0

                  default_config.rpcs.update_aws_cluster.timeout = 60.0

                  default_config.rpcs.get_aws_cluster.timeout = 60.0
                  default_config.rpcs.get_aws_cluster.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.list_aws_clusters.timeout = 60.0
                  default_config.rpcs.list_aws_clusters.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.delete_aws_cluster.timeout = 60.0

                  default_config.rpcs.generate_aws_cluster_agent_token.timeout = 60.0
                  default_config.rpcs.generate_aws_cluster_agent_token.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.generate_aws_access_token.timeout = 60.0
                  default_config.rpcs.generate_aws_access_token.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.create_aws_node_pool.timeout = 60.0

                  default_config.rpcs.update_aws_node_pool.timeout = 60.0

                  default_config.rpcs.rollback_aws_node_pool_update.timeout = 60.0

                  default_config.rpcs.get_aws_node_pool.timeout = 60.0
                  default_config.rpcs.get_aws_node_pool.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.list_aws_node_pools.timeout = 60.0
                  default_config.rpcs.list_aws_node_pools.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.delete_aws_node_pool.timeout = 60.0

                  default_config.rpcs.get_aws_open_id_config.timeout = 60.0
                  default_config.rpcs.get_aws_open_id_config.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_aws_json_web_keys.timeout = 60.0
                  default_config.rpcs.get_aws_json_web_keys.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_aws_server_config.timeout = 60.0
                  default_config.rpcs.get_aws_server_config.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the AwsClusters Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @aws_clusters_stub.universe_domain
              end

              ##
              # Create a new AwsClusters REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the AwsClusters client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @aws_clusters_stub = ::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @aws_clusters_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @aws_clusters_stub.logger
              end

              # Service calls

              ##
              # Creates a new {::Google::Cloud::GkeMultiCloud::V1::AwsCluster AwsCluster}
              # resource on a given Google Cloud Platform project and region.
              #
              # If successful, the response contains a newly created
              # {::Google::Longrunning::Operation Operation} resource that can be
              # described to track the status of the operation.
              #
              # @overload create_aws_cluster(request, options = nil)
              #   Pass arguments to `create_aws_cluster` via a request object, either of type
              #   {::Google::Cloud::GkeMultiCloud::V1::CreateAwsClusterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GkeMultiCloud::V1::CreateAwsClusterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_aws_cluster(parent: nil, aws_cluster: nil, aws_cluster_id: nil, validate_only: nil)
              #   Pass arguments to `create_aws_cluster` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent location where this
              #     {::Google::Cloud::GkeMultiCloud::V1::AwsCluster AwsCluster} resource will be
              #     created.
              #
              #     Location names are formatted as `projects/<project-id>/locations/<region>`.
              #
              #     See [Resource Names](https://cloud.google.com/apis/design/resource_names)
              #     for more details on Google Cloud resource names.
              #   @param aws_cluster [::Google::Cloud::GkeMultiCloud::V1::AwsCluster, ::Hash]
              #     Required. The specification of the
              #     {::Google::Cloud::GkeMultiCloud::V1::AwsCluster AwsCluster} to create.
              #   @param aws_cluster_id [::String]
              #     Required. A client provided ID the resource. Must be unique within the
              #     parent resource.
              #
              #     The provided ID will be part of the
              #     {::Google::Cloud::GkeMultiCloud::V1::AwsCluster AwsCluster} resource name
              #     formatted as
              #     `projects/<project-id>/locations/<region>/awsClusters/<cluster-id>`.
              #
              #     Valid characters are `/[a-z][0-9]-/`. Cannot be longer than 63 characters.
              #   @param validate_only [::Boolean]
              #     If set, only validate the request, but do not actually create the cluster.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gke_multi_cloud/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GkeMultiCloud::V1::CreateAwsClusterRequest.new
              #
              #   # Call the create_aws_cluster method.
              #   result = client.create_aws_cluster request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_aws_cluster request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeMultiCloud::V1::CreateAwsClusterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_aws_cluster.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GkeMultiCloud::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_aws_cluster.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_aws_cluster.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @aws_clusters_stub.create_aws_cluster request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates an {::Google::Cloud::GkeMultiCloud::V1::AwsCluster AwsCluster}.
              #
              # @overload update_aws_cluster(request, options = nil)
              #   Pass arguments to `update_aws_cluster` via a request object, either of type
              #   {::Google::Cloud::GkeMultiCloud::V1::UpdateAwsClusterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GkeMultiCloud::V1::UpdateAwsClusterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_aws_cluster(aws_cluster: nil, validate_only: nil, update_mask: nil)
              #   Pass arguments to `update_aws_cluster` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param aws_cluster [::Google::Cloud::GkeMultiCloud::V1::AwsCluster, ::Hash]
              #     Required. The {::Google::Cloud::GkeMultiCloud::V1::AwsCluster AwsCluster}
              #     resource to update.
              #   @param validate_only [::Boolean]
              #     If set, only validate the request, but do not actually update the cluster.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Mask of fields to update. At least one path must be supplied in
              #     this field. The elements of the repeated paths field can only include these
              #     fields from {::Google::Cloud::GkeMultiCloud::V1::AwsCluster AwsCluster}:
              #
              #      *   `description`.
              #      *   `annotations`.
              #      *   `control_plane.version`.
              #      *   `authorization.admin_users`.
              #      *   `authorization.admin_groups`.
              #      *   `binary_authorization.evaluation_mode`.
              #      *   `control_plane.aws_services_authentication.role_arn`.
              #      *   `control_plane.aws_services_authentication.role_session_name`.
              #      *   `control_plane.config_encryption.kms_key_arn`.
              #      *   `control_plane.instance_type`.
              #      *   `control_plane.security_group_ids`.
              #      *   `control_plane.proxy_config`.
              #      *   `control_plane.proxy_config.secret_arn`.
              #      *   `control_plane.proxy_config.secret_version`.
              #      *   `control_plane.root_volume.size_gib`.
              #      *   `control_plane.root_volume.volume_type`.
              #      *   `control_plane.root_volume.iops`.
              #      *   `control_plane.root_volume.throughput`.
              #      *   `control_plane.root_volume.kms_key_arn`.
              #      *   `control_plane.ssh_config`.
              #      *   `control_plane.ssh_config.ec2_key_pair`.
              #      *   `control_plane.instance_placement.tenancy`.
              #      *   `control_plane.iam_instance_profile`.
              #      *   `logging_config.component_config.enable_components`.
              #      *   `control_plane.tags`.
              #      *   `monitoring_config.managed_prometheus_config.enabled`.
              #      *   `networking.per_node_pool_sg_rules_disabled`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gke_multi_cloud/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GkeMultiCloud::V1::UpdateAwsClusterRequest.new
              #
              #   # Call the update_aws_cluster method.
              #   result = client.update_aws_cluster request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_aws_cluster request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeMultiCloud::V1::UpdateAwsClusterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_aws_cluster.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GkeMultiCloud::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_aws_cluster.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_aws_cluster.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @aws_clusters_stub.update_aws_cluster request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Describes a specific {::Google::Cloud::GkeMultiCloud::V1::AwsCluster AwsCluster}
              # resource.
              #
              # @overload get_aws_cluster(request, options = nil)
              #   Pass arguments to `get_aws_cluster` via a request object, either of type
              #   {::Google::Cloud::GkeMultiCloud::V1::GetAwsClusterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GkeMultiCloud::V1::GetAwsClusterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_aws_cluster(name: nil)
              #   Pass arguments to `get_aws_cluster` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the
              #     {::Google::Cloud::GkeMultiCloud::V1::AwsCluster AwsCluster} resource to
              #     describe.
              #
              #     `AwsCluster` names are formatted as
              #     `projects/<project-id>/locations/<region>/awsClusters/<cluster-id>`.
              #
              #     See [Resource Names](https://cloud.google.com/apis/design/resource_names)
              #     for more details on Google Cloud Platform resource names.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::GkeMultiCloud::V1::AwsCluster]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::GkeMultiCloud::V1::AwsCluster]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gke_multi_cloud/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GkeMultiCloud::V1::GetAwsClusterRequest.new
              #
              #   # Call the get_aws_cluster method.
              #   result = client.get_aws_cluster request
              #
              #   # The returned object is of type Google::Cloud::GkeMultiCloud::V1::AwsCluster.
              #   p result
              #
              def get_aws_cluster request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeMultiCloud::V1::GetAwsClusterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_aws_cluster.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GkeMultiCloud::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_aws_cluster.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_aws_cluster.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @aws_clusters_stub.get_aws_cluster request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all {::Google::Cloud::GkeMultiCloud::V1::AwsCluster AwsCluster} resources
              # on a given Google Cloud project and region.
              #
              # @overload list_aws_clusters(request, options = nil)
              #   Pass arguments to `list_aws_clusters` via a request object, either of type
              #   {::Google::Cloud::GkeMultiCloud::V1::ListAwsClustersRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GkeMultiCloud::V1::ListAwsClustersRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_aws_clusters(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_aws_clusters` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent location which owns this collection of
              #     {::Google::Cloud::GkeMultiCloud::V1::AwsCluster AwsCluster} resources.
              #
              #     Location names are formatted as `projects/<project-id>/locations/<region>`.
              #
              #     See [Resource Names](https://cloud.google.com/apis/design/resource_names)
              #     for more details on Google Cloud Platform resource names.
              #   @param page_size [::Integer]
              #     The maximum number of items to return.
              #
              #     If not specified, a default value of 50 will be used by the service.
              #     Regardless of the pageSize value, the response can include a partial list
              #     and a caller should only rely on response's
              #     {::Google::Cloud::GkeMultiCloud::V1::ListAwsClustersResponse#next_page_token nextPageToken}
              #     to determine if there are more instances left to be queried.
              #   @param page_token [::String]
              #     The `nextPageToken` value returned from a previous
              #     {::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::Client#list_aws_clusters awsClusters.list}
              #     request, if any.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::GkeMultiCloud::V1::AwsCluster>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::GkeMultiCloud::V1::AwsCluster>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gke_multi_cloud/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GkeMultiCloud::V1::ListAwsClustersRequest.new
              #
              #   # Call the list_aws_clusters method.
              #   result = client.list_aws_clusters request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::GkeMultiCloud::V1::AwsCluster.
              #     p item
              #   end
              #
              def list_aws_clusters request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeMultiCloud::V1::ListAwsClustersRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_aws_clusters.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GkeMultiCloud::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_aws_clusters.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_aws_clusters.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @aws_clusters_stub.list_aws_clusters request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @aws_clusters_stub, :list_aws_clusters, "aws_clusters", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a specific {::Google::Cloud::GkeMultiCloud::V1::AwsCluster AwsCluster}
              # resource.
              #
              # Fails if the cluster has one or more associated
              # {::Google::Cloud::GkeMultiCloud::V1::AwsNodePool AwsNodePool} resources.
              #
              # If successful, the response contains a newly created
              # {::Google::Longrunning::Operation Operation} resource that can be
              # described to track the status of the operation.
              #
              # @overload delete_aws_cluster(request, options = nil)
              #   Pass arguments to `delete_aws_cluster` via a request object, either of type
              #   {::Google::Cloud::GkeMultiCloud::V1::DeleteAwsClusterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GkeMultiCloud::V1::DeleteAwsClusterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_aws_cluster(name: nil, validate_only: nil, allow_missing: nil, ignore_errors: nil, etag: nil)
              #   Pass arguments to `delete_aws_cluster` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name the
              #     {::Google::Cloud::GkeMultiCloud::V1::AwsCluster AwsCluster} to delete.
              #
              #     `AwsCluster` names are formatted as
              #     `projects/<project-id>/locations/<region>/awsClusters/<cluster-id>`.
              #
              #     See [Resource Names](https://cloud.google.com/apis/design/resource_names)
              #     for more details on Google Cloud Platform resource names.
              #   @param validate_only [::Boolean]
              #     If set, only validate the request, but do not actually delete the resource.
              #   @param allow_missing [::Boolean]
              #     If set to true, and the
              #     {::Google::Cloud::GkeMultiCloud::V1::AwsCluster AwsCluster} resource is not
              #     found, the request will succeed but no action will be taken on the server
              #     and a completed {::Google::Longrunning::Operation Operation} will be returned.
              #
              #     Useful for idempotent deletion.
              #   @param ignore_errors [::Boolean]
              #     Optional. If set to true, the deletion of
              #     {::Google::Cloud::GkeMultiCloud::V1::AwsCluster AwsCluster} resource will
              #     succeed even if errors occur during deleting in cluster resources. Using
              #     this parameter may result in orphaned resources in the cluster.
              #   @param etag [::String]
              #     The current etag of the
              #     {::Google::Cloud::GkeMultiCloud::V1::AwsCluster AwsCluster}.
              #
              #     Allows clients to perform deletions through optimistic concurrency control.
              #
              #     If the provided etag does not match the current etag of the cluster,
              #     the request will fail and an ABORTED error will be returned.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gke_multi_cloud/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GkeMultiCloud::V1::DeleteAwsClusterRequest.new
              #
              #   # Call the delete_aws_cluster method.
              #   result = client.delete_aws_cluster request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_aws_cluster request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeMultiCloud::V1::DeleteAwsClusterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_aws_cluster.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GkeMultiCloud::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_aws_cluster.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_aws_cluster.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @aws_clusters_stub.delete_aws_cluster request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Generates an access token for a cluster agent.
              #
              # @overload generate_aws_cluster_agent_token(request, options = nil)
              #   Pass arguments to `generate_aws_cluster_agent_token` via a request object, either of type
              #   {::Google::Cloud::GkeMultiCloud::V1::GenerateAwsClusterAgentTokenRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GkeMultiCloud::V1::GenerateAwsClusterAgentTokenRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload generate_aws_cluster_agent_token(aws_cluster: nil, subject_token: nil, subject_token_type: nil, version: nil, node_pool_id: nil, grant_type: nil, audience: nil, scope: nil, requested_token_type: nil, options: nil)
              #   Pass arguments to `generate_aws_cluster_agent_token` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param aws_cluster [::String]
              #     Required.
              #   @param subject_token [::String]
              #     Required.
              #   @param subject_token_type [::String]
              #     Required.
              #   @param version [::String]
              #     Required.
              #   @param node_pool_id [::String]
              #     Optional.
              #   @param grant_type [::String]
              #     Optional.
              #   @param audience [::String]
              #     Optional.
              #   @param scope [::String]
              #     Optional.
              #   @param requested_token_type [::String]
              #     Optional.
              #   @param options [::String]
              #     Optional.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::GkeMultiCloud::V1::GenerateAwsClusterAgentTokenResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::GkeMultiCloud::V1::GenerateAwsClusterAgentTokenResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gke_multi_cloud/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GkeMultiCloud::V1::GenerateAwsClusterAgentTokenRequest.new
              #
              #   # Call the generate_aws_cluster_agent_token method.
              #   result = client.generate_aws_cluster_agent_token request
              #
              #   # The returned object is of type Google::Cloud::GkeMultiCloud::V1::GenerateAwsClusterAgentTokenResponse.
              #   p result
              #
              def generate_aws_cluster_agent_token request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeMultiCloud::V1::GenerateAwsClusterAgentTokenRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.generate_aws_cluster_agent_token.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GkeMultiCloud::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.generate_aws_cluster_agent_token.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.generate_aws_cluster_agent_token.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @aws_clusters_stub.generate_aws_cluster_agent_token request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Generates a short-lived access token to authenticate to a given
              # {::Google::Cloud::GkeMultiCloud::V1::AwsCluster AwsCluster} resource.
              #
              # @overload generate_aws_access_token(request, options = nil)
              #   Pass arguments to `generate_aws_access_token` via a request object, either of type
              #   {::Google::Cloud::GkeMultiCloud::V1::GenerateAwsAccessTokenRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GkeMultiCloud::V1::GenerateAwsAccessTokenRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload generate_aws_access_token(aws_cluster: nil)
              #   Pass arguments to `generate_aws_access_token` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param aws_cluster [::String]
              #     Required. The name of the
              #     {::Google::Cloud::GkeMultiCloud::V1::AwsCluster AwsCluster} resource to
              #     authenticate to.
              #
              #     `AwsCluster` names are formatted as
              #     `projects/<project-id>/locations/<region>/awsClusters/<cluster-id>`.
              #
              #     See [Resource Names](https://cloud.google.com/apis/design/resource_names)
              #     for more details on Google Cloud resource names.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::GkeMultiCloud::V1::GenerateAwsAccessTokenResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::GkeMultiCloud::V1::GenerateAwsAccessTokenResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gke_multi_cloud/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GkeMultiCloud::V1::GenerateAwsAccessTokenRequest.new
              #
              #   # Call the generate_aws_access_token method.
              #   result = client.generate_aws_access_token request
              #
              #   # The returned object is of type Google::Cloud::GkeMultiCloud::V1::GenerateAwsAccessTokenResponse.
              #   p result
              #
              def generate_aws_access_token request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeMultiCloud::V1::GenerateAwsAccessTokenRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.generate_aws_access_token.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GkeMultiCloud::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.generate_aws_access_token.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.generate_aws_access_token.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @aws_clusters_stub.generate_aws_access_token request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new {::Google::Cloud::GkeMultiCloud::V1::AwsNodePool AwsNodePool},
              # attached to a given {::Google::Cloud::GkeMultiCloud::V1::AwsCluster AwsCluster}.
              #
              # If successful, the response contains a newly created
              # {::Google::Longrunning::Operation Operation} resource that can be
              # described to track the status of the operation.
              #
              # @overload create_aws_node_pool(request, options = nil)
              #   Pass arguments to `create_aws_node_pool` via a request object, either of type
              #   {::Google::Cloud::GkeMultiCloud::V1::CreateAwsNodePoolRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GkeMultiCloud::V1::CreateAwsNodePoolRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_aws_node_pool(parent: nil, aws_node_pool: nil, aws_node_pool_id: nil, validate_only: nil)
              #   Pass arguments to `create_aws_node_pool` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The {::Google::Cloud::GkeMultiCloud::V1::AwsCluster AwsCluster}
              #     resource where this node pool will be created.
              #
              #     `AwsCluster` names are formatted as
              #     `projects/<project-id>/locations/<region>/awsClusters/<cluster-id>`.
              #
              #     See [Resource Names](https://cloud.google.com/apis/design/resource_names)
              #     for more details on Google Cloud resource names.
              #   @param aws_node_pool [::Google::Cloud::GkeMultiCloud::V1::AwsNodePool, ::Hash]
              #     Required. The specification of the
              #     {::Google::Cloud::GkeMultiCloud::V1::AwsNodePool AwsNodePool} to create.
              #   @param aws_node_pool_id [::String]
              #     Required. A client provided ID the resource. Must be unique within the
              #     parent resource.
              #
              #     The provided ID will be part of the
              #     {::Google::Cloud::GkeMultiCloud::V1::AwsNodePool AwsNodePool} resource name
              #     formatted as
              #     `projects/<project-id>/locations/<region>/awsClusters/<cluster-id>/awsNodePools/<node-pool-id>`.
              #
              #     Valid characters are `/[a-z][0-9]-/`. Cannot be longer than 63 characters.
              #   @param validate_only [::Boolean]
              #     If set, only validate the request, but do not actually create the node
              #     pool.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gke_multi_cloud/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GkeMultiCloud::V1::CreateAwsNodePoolRequest.new
              #
              #   # Call the create_aws_node_pool method.
              #   result = client.create_aws_node_pool request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_aws_node_pool request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeMultiCloud::V1::CreateAwsNodePoolRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_aws_node_pool.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GkeMultiCloud::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_aws_node_pool.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_aws_node_pool.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @aws_clusters_stub.create_aws_node_pool request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates an {::Google::Cloud::GkeMultiCloud::V1::AwsNodePool AwsNodePool}.
              #
              # @overload update_aws_node_pool(request, options = nil)
              #   Pass arguments to `update_aws_node_pool` via a request object, either of type
              #   {::Google::Cloud::GkeMultiCloud::V1::UpdateAwsNodePoolRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GkeMultiCloud::V1::UpdateAwsNodePoolRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_aws_node_pool(aws_node_pool: nil, validate_only: nil, update_mask: nil)
              #   Pass arguments to `update_aws_node_pool` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param aws_node_pool [::Google::Cloud::GkeMultiCloud::V1::AwsNodePool, ::Hash]
              #     Required. The {::Google::Cloud::GkeMultiCloud::V1::AwsNodePool AwsNodePool}
              #     resource to update.
              #   @param validate_only [::Boolean]
              #     If set, only validate the request, but don't actually update the node pool.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Mask of fields to update. At least one path must be supplied in
              #     this field. The elements of the repeated paths field can only include these
              #     fields from {::Google::Cloud::GkeMultiCloud::V1::AwsNodePool AwsNodePool}:
              #
              #      *   `annotations`.
              #      *   `version`.
              #      *   `autoscaling.min_node_count`.
              #      *   `autoscaling.max_node_count`.
              #      *   `config.config_encryption.kms_key_arn`.
              #      *   `config.security_group_ids`.
              #      *   `config.root_volume.iops`.
              #      *   `config.root_volume.throughput`.
              #      *   `config.root_volume.kms_key_arn`.
              #      *   `config.root_volume.volume_type`.
              #      *   `config.root_volume.size_gib`.
              #      *   `config.proxy_config`.
              #      *   `config.proxy_config.secret_arn`.
              #      *   `config.proxy_config.secret_version`.
              #      *   `config.ssh_config`.
              #      *   `config.ssh_config.ec2_key_pair`.
              #      *   `config.instance_placement.tenancy`.
              #      *   `config.iam_instance_profile`.
              #      *   `config.labels`.
              #      *   `config.tags`.
              #      *   `config.autoscaling_metrics_collection`.
              #      *   `config.autoscaling_metrics_collection.granularity`.
              #      *   `config.autoscaling_metrics_collection.metrics`.
              #      *   `config.instance_type`.
              #      *   `management.auto_repair`.
              #      *   `management`.
              #      *   `update_settings`.
              #      *   `update_settings.surge_settings`.
              #      *   `update_settings.surge_settings.max_surge`.
              #      *   `update_settings.surge_settings.max_unavailable`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gke_multi_cloud/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GkeMultiCloud::V1::UpdateAwsNodePoolRequest.new
              #
              #   # Call the update_aws_node_pool method.
              #   result = client.update_aws_node_pool request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_aws_node_pool request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeMultiCloud::V1::UpdateAwsNodePoolRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_aws_node_pool.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GkeMultiCloud::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_aws_node_pool.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_aws_node_pool.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @aws_clusters_stub.update_aws_node_pool request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Rolls back a previously aborted or failed
              # {::Google::Cloud::GkeMultiCloud::V1::AwsNodePool AwsNodePool} update request.
              # Makes no changes if the last update request successfully finished.
              # If an update request is in progress, you cannot rollback the update.
              # You must first cancel or let it finish unsuccessfully before you can
              # rollback.
              #
              # @overload rollback_aws_node_pool_update(request, options = nil)
              #   Pass arguments to `rollback_aws_node_pool_update` via a request object, either of type
              #   {::Google::Cloud::GkeMultiCloud::V1::RollbackAwsNodePoolUpdateRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GkeMultiCloud::V1::RollbackAwsNodePoolUpdateRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload rollback_aws_node_pool_update(name: nil, respect_pdb: nil)
              #   Pass arguments to `rollback_aws_node_pool_update` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the
              #     {::Google::Cloud::GkeMultiCloud::V1::AwsNodePool AwsNodePool} resource to
              #     rollback.
              #
              #     `AwsNodePool` names are formatted as
              #     `projects/<project-id>/locations/<region>/awsClusters/<cluster-id>/awsNodePools/<node-pool-id>`.
              #
              #     See [Resource Names](https://cloud.google.com/apis/design/resource_names)
              #     for more details on Google Cloud resource names.
              #   @param respect_pdb [::Boolean]
              #     Optional. Option for rollback to ignore the PodDisruptionBudget when
              #     draining the node pool nodes. Default value is false.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gke_multi_cloud/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GkeMultiCloud::V1::RollbackAwsNodePoolUpdateRequest.new
              #
              #   # Call the rollback_aws_node_pool_update method.
              #   result = client.rollback_aws_node_pool_update request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def rollback_aws_node_pool_update request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeMultiCloud::V1::RollbackAwsNodePoolUpdateRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.rollback_aws_node_pool_update.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GkeMultiCloud::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.rollback_aws_node_pool_update.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.rollback_aws_node_pool_update.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @aws_clusters_stub.rollback_aws_node_pool_update request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Describes a specific
              # {::Google::Cloud::GkeMultiCloud::V1::AwsNodePool AwsNodePool} resource.
              #
              # @overload get_aws_node_pool(request, options = nil)
              #   Pass arguments to `get_aws_node_pool` via a request object, either of type
              #   {::Google::Cloud::GkeMultiCloud::V1::GetAwsNodePoolRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GkeMultiCloud::V1::GetAwsNodePoolRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_aws_node_pool(name: nil)
              #   Pass arguments to `get_aws_node_pool` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the
              #     {::Google::Cloud::GkeMultiCloud::V1::AwsNodePool AwsNodePool} resource to
              #     describe.
              #
              #     `AwsNodePool` names are formatted as
              #     `projects/<project-id>/locations/<region>/awsClusters/<cluster-id>/awsNodePools/<node-pool-id>`.
              #
              #     See [Resource Names](https://cloud.google.com/apis/design/resource_names)
              #     for more details on Google Cloud resource names.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::GkeMultiCloud::V1::AwsNodePool]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::GkeMultiCloud::V1::AwsNodePool]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gke_multi_cloud/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GkeMultiCloud::V1::GetAwsNodePoolRequest.new
              #
              #   # Call the get_aws_node_pool method.
              #   result = client.get_aws_node_pool request
              #
              #   # The returned object is of type Google::Cloud::GkeMultiCloud::V1::AwsNodePool.
              #   p result
              #
              def get_aws_node_pool request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeMultiCloud::V1::GetAwsNodePoolRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_aws_node_pool.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GkeMultiCloud::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_aws_node_pool.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_aws_node_pool.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @aws_clusters_stub.get_aws_node_pool request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all {::Google::Cloud::GkeMultiCloud::V1::AwsNodePool AwsNodePool}
              # resources on a given
              # {::Google::Cloud::GkeMultiCloud::V1::AwsCluster AwsCluster}.
              #
              # @overload list_aws_node_pools(request, options = nil)
              #   Pass arguments to `list_aws_node_pools` via a request object, either of type
              #   {::Google::Cloud::GkeMultiCloud::V1::ListAwsNodePoolsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GkeMultiCloud::V1::ListAwsNodePoolsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_aws_node_pools(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_aws_node_pools` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent `AwsCluster` which owns this collection of
              #     {::Google::Cloud::GkeMultiCloud::V1::AwsNodePool AwsNodePool} resources.
              #
              #     `AwsCluster` names are formatted as
              #     `projects/<project-id>/locations/<region>/awsClusters/<cluster-id>`.
              #
              #     See [Resource Names](https://cloud.google.com/apis/design/resource_names)
              #     for more details on Google Cloud resource names.
              #   @param page_size [::Integer]
              #     The maximum number of items to return.
              #
              #     If not specified, a default value of 50 will be used by the service.
              #     Regardless of the pageSize value, the response can include a partial list
              #     and a caller should only rely on response's
              #     {::Google::Cloud::GkeMultiCloud::V1::ListAwsNodePoolsResponse#next_page_token nextPageToken}
              #     to determine if there are more instances left to be queried.
              #   @param page_token [::String]
              #     The `nextPageToken` value returned from a previous
              #     {::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::Client#list_aws_node_pools awsNodePools.list}
              #     request, if any.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::GkeMultiCloud::V1::AwsNodePool>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::GkeMultiCloud::V1::AwsNodePool>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gke_multi_cloud/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GkeMultiCloud::V1::ListAwsNodePoolsRequest.new
              #
              #   # Call the list_aws_node_pools method.
              #   result = client.list_aws_node_pools request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::GkeMultiCloud::V1::AwsNodePool.
              #     p item
              #   end
              #
              def list_aws_node_pools request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeMultiCloud::V1::ListAwsNodePoolsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_aws_node_pools.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GkeMultiCloud::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_aws_node_pools.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_aws_node_pools.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @aws_clusters_stub.list_aws_node_pools request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @aws_clusters_stub, :list_aws_node_pools, "aws_node_pools", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a specific {::Google::Cloud::GkeMultiCloud::V1::AwsNodePool AwsNodePool}
              # resource.
              #
              # If successful, the response contains a newly created
              # {::Google::Longrunning::Operation Operation} resource that can be
              # described to track the status of the operation.
              #
              # @overload delete_aws_node_pool(request, options = nil)
              #   Pass arguments to `delete_aws_node_pool` via a request object, either of type
              #   {::Google::Cloud::GkeMultiCloud::V1::DeleteAwsNodePoolRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GkeMultiCloud::V1::DeleteAwsNodePoolRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_aws_node_pool(name: nil, validate_only: nil, allow_missing: nil, ignore_errors: nil, etag: nil)
              #   Pass arguments to `delete_aws_node_pool` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name the
              #     {::Google::Cloud::GkeMultiCloud::V1::AwsNodePool AwsNodePool} to delete.
              #
              #     `AwsNodePool` names are formatted as
              #     `projects/<project-id>/locations/<region>/awsClusters/<cluster-id>/awsNodePools/<node-pool-id>`.
              #
              #     See [Resource Names](https://cloud.google.com/apis/design/resource_names)
              #     for more details on Google Cloud resource names.
              #   @param validate_only [::Boolean]
              #     If set, only validate the request, but do not actually delete the node
              #     pool.
              #   @param allow_missing [::Boolean]
              #     If set to true, and the
              #     {::Google::Cloud::GkeMultiCloud::V1::AwsNodePool AwsNodePool} resource is not
              #     found, the request will succeed but no action will be taken on the server
              #     and a completed {::Google::Longrunning::Operation Operation} will be returned.
              #
              #     Useful for idempotent deletion.
              #   @param ignore_errors [::Boolean]
              #     Optional. If set to true, the deletion of
              #     {::Google::Cloud::GkeMultiCloud::V1::AwsNodePool AwsNodePool} resource will
              #     succeed even if errors occur during deleting in node pool resources. Using
              #     this parameter may result in orphaned resources in the node pool.
              #   @param etag [::String]
              #     The current ETag of the
              #     {::Google::Cloud::GkeMultiCloud::V1::AwsNodePool AwsNodePool}.
              #
              #     Allows clients to perform deletions through optimistic concurrency control.
              #
              #     If the provided ETag does not match the current etag of the node pool,
              #     the request will fail and an ABORTED error will be returned.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gke_multi_cloud/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GkeMultiCloud::V1::DeleteAwsNodePoolRequest.new
              #
              #   # Call the delete_aws_node_pool method.
              #   result = client.delete_aws_node_pool request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_aws_node_pool request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeMultiCloud::V1::DeleteAwsNodePoolRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_aws_node_pool.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GkeMultiCloud::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_aws_node_pool.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_aws_node_pool.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @aws_clusters_stub.delete_aws_node_pool request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the OIDC discovery document for the cluster.
              # See the
              # [OpenID Connect Discovery 1.0
              # specification](https://openid.net/specs/openid-connect-discovery-1_0.html)
              # for details.
              #
              # @overload get_aws_open_id_config(request, options = nil)
              #   Pass arguments to `get_aws_open_id_config` via a request object, either of type
              #   {::Google::Cloud::GkeMultiCloud::V1::GetAwsOpenIdConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GkeMultiCloud::V1::GetAwsOpenIdConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_aws_open_id_config(aws_cluster: nil)
              #   Pass arguments to `get_aws_open_id_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param aws_cluster [::String]
              #     Required. The AwsCluster, which owns the OIDC discovery document.
              #     Format:
              #     projects/\\{project}/locations/\\{location}/awsClusters/\\{cluster}
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::GkeMultiCloud::V1::AwsOpenIdConfig]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::GkeMultiCloud::V1::AwsOpenIdConfig]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gke_multi_cloud/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GkeMultiCloud::V1::GetAwsOpenIdConfigRequest.new
              #
              #   # Call the get_aws_open_id_config method.
              #   result = client.get_aws_open_id_config request
              #
              #   # The returned object is of type Google::Cloud::GkeMultiCloud::V1::AwsOpenIdConfig.
              #   p result
              #
              def get_aws_open_id_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeMultiCloud::V1::GetAwsOpenIdConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_aws_open_id_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GkeMultiCloud::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_aws_open_id_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_aws_open_id_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @aws_clusters_stub.get_aws_open_id_config request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the public component of the cluster signing keys in
              # JSON Web Key format.
              #
              # @overload get_aws_json_web_keys(request, options = nil)
              #   Pass arguments to `get_aws_json_web_keys` via a request object, either of type
              #   {::Google::Cloud::GkeMultiCloud::V1::GetAwsJsonWebKeysRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GkeMultiCloud::V1::GetAwsJsonWebKeysRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_aws_json_web_keys(aws_cluster: nil)
              #   Pass arguments to `get_aws_json_web_keys` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param aws_cluster [::String]
              #     Required. The AwsCluster, which owns the JsonWebKeys.
              #     Format:
              #     projects/\\{project}/locations/\\{location}/awsClusters/\\{cluster}
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::GkeMultiCloud::V1::AwsJsonWebKeys]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::GkeMultiCloud::V1::AwsJsonWebKeys]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gke_multi_cloud/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GkeMultiCloud::V1::GetAwsJsonWebKeysRequest.new
              #
              #   # Call the get_aws_json_web_keys method.
              #   result = client.get_aws_json_web_keys request
              #
              #   # The returned object is of type Google::Cloud::GkeMultiCloud::V1::AwsJsonWebKeys.
              #   p result
              #
              def get_aws_json_web_keys request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeMultiCloud::V1::GetAwsJsonWebKeysRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_aws_json_web_keys.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GkeMultiCloud::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_aws_json_web_keys.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_aws_json_web_keys.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @aws_clusters_stub.get_aws_json_web_keys request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns information, such as supported AWS regions and Kubernetes
              # versions, on a given Google Cloud location.
              #
              # @overload get_aws_server_config(request, options = nil)
              #   Pass arguments to `get_aws_server_config` via a request object, either of type
              #   {::Google::Cloud::GkeMultiCloud::V1::GetAwsServerConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GkeMultiCloud::V1::GetAwsServerConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_aws_server_config(name: nil)
              #   Pass arguments to `get_aws_server_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the
              #     {::Google::Cloud::GkeMultiCloud::V1::AwsServerConfig AwsServerConfig} resource
              #     to describe.
              #
              #     `AwsServerConfig` names are formatted as
              #     `projects/<project-id>/locations/<region>/awsServerConfig`.
              #
              #     See [Resource Names](https://cloud.google.com/apis/design/resource_names)
              #     for more details on Google Cloud resource names.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::GkeMultiCloud::V1::AwsServerConfig]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::GkeMultiCloud::V1::AwsServerConfig]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gke_multi_cloud/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GkeMultiCloud::V1::GetAwsServerConfigRequest.new
              #
              #   # Call the get_aws_server_config method.
              #   result = client.get_aws_server_config request
              #
              #   # The returned object is of type Google::Cloud::GkeMultiCloud::V1::AwsServerConfig.
              #   p result
              #
              def get_aws_server_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeMultiCloud::V1::GetAwsServerConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_aws_server_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GkeMultiCloud::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_aws_server_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_aws_server_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @aws_clusters_stub.get_aws_server_config request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the AwsClusters REST API.
              #
              # This class represents the configuration for AwsClusters REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # create_aws_cluster to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_aws_cluster.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::GkeMultiCloud::V1::AwsClusters::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_aws_cluster.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "gkemulticloud.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the AwsClusters API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `create_aws_cluster`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_aws_cluster
                  ##
                  # RPC-specific configuration for `update_aws_cluster`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_aws_cluster
                  ##
                  # RPC-specific configuration for `get_aws_cluster`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_aws_cluster
                  ##
                  # RPC-specific configuration for `list_aws_clusters`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_aws_clusters
                  ##
                  # RPC-specific configuration for `delete_aws_cluster`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_aws_cluster
                  ##
                  # RPC-specific configuration for `generate_aws_cluster_agent_token`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :generate_aws_cluster_agent_token
                  ##
                  # RPC-specific configuration for `generate_aws_access_token`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :generate_aws_access_token
                  ##
                  # RPC-specific configuration for `create_aws_node_pool`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_aws_node_pool
                  ##
                  # RPC-specific configuration for `update_aws_node_pool`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_aws_node_pool
                  ##
                  # RPC-specific configuration for `rollback_aws_node_pool_update`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :rollback_aws_node_pool_update
                  ##
                  # RPC-specific configuration for `get_aws_node_pool`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_aws_node_pool
                  ##
                  # RPC-specific configuration for `list_aws_node_pools`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_aws_node_pools
                  ##
                  # RPC-specific configuration for `delete_aws_node_pool`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_aws_node_pool
                  ##
                  # RPC-specific configuration for `get_aws_open_id_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_aws_open_id_config
                  ##
                  # RPC-specific configuration for `get_aws_json_web_keys`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_aws_json_web_keys
                  ##
                  # RPC-specific configuration for `get_aws_server_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_aws_server_config

                  # @private
                  def initialize parent_rpcs = nil
                    create_aws_cluster_config = parent_rpcs.create_aws_cluster if parent_rpcs.respond_to? :create_aws_cluster
                    @create_aws_cluster = ::Gapic::Config::Method.new create_aws_cluster_config
                    update_aws_cluster_config = parent_rpcs.update_aws_cluster if parent_rpcs.respond_to? :update_aws_cluster
                    @update_aws_cluster = ::Gapic::Config::Method.new update_aws_cluster_config
                    get_aws_cluster_config = parent_rpcs.get_aws_cluster if parent_rpcs.respond_to? :get_aws_cluster
                    @get_aws_cluster = ::Gapic::Config::Method.new get_aws_cluster_config
                    list_aws_clusters_config = parent_rpcs.list_aws_clusters if parent_rpcs.respond_to? :list_aws_clusters
                    @list_aws_clusters = ::Gapic::Config::Method.new list_aws_clusters_config
                    delete_aws_cluster_config = parent_rpcs.delete_aws_cluster if parent_rpcs.respond_to? :delete_aws_cluster
                    @delete_aws_cluster = ::Gapic::Config::Method.new delete_aws_cluster_config
                    generate_aws_cluster_agent_token_config = parent_rpcs.generate_aws_cluster_agent_token if parent_rpcs.respond_to? :generate_aws_cluster_agent_token
                    @generate_aws_cluster_agent_token = ::Gapic::Config::Method.new generate_aws_cluster_agent_token_config
                    generate_aws_access_token_config = parent_rpcs.generate_aws_access_token if parent_rpcs.respond_to? :generate_aws_access_token
                    @generate_aws_access_token = ::Gapic::Config::Method.new generate_aws_access_token_config
                    create_aws_node_pool_config = parent_rpcs.create_aws_node_pool if parent_rpcs.respond_to? :create_aws_node_pool
                    @create_aws_node_pool = ::Gapic::Config::Method.new create_aws_node_pool_config
                    update_aws_node_pool_config = parent_rpcs.update_aws_node_pool if parent_rpcs.respond_to? :update_aws_node_pool
                    @update_aws_node_pool = ::Gapic::Config::Method.new update_aws_node_pool_config
                    rollback_aws_node_pool_update_config = parent_rpcs.rollback_aws_node_pool_update if parent_rpcs.respond_to? :rollback_aws_node_pool_update
                    @rollback_aws_node_pool_update = ::Gapic::Config::Method.new rollback_aws_node_pool_update_config
                    get_aws_node_pool_config = parent_rpcs.get_aws_node_pool if parent_rpcs.respond_to? :get_aws_node_pool
                    @get_aws_node_pool = ::Gapic::Config::Method.new get_aws_node_pool_config
                    list_aws_node_pools_config = parent_rpcs.list_aws_node_pools if parent_rpcs.respond_to? :list_aws_node_pools
                    @list_aws_node_pools = ::Gapic::Config::Method.new list_aws_node_pools_config
                    delete_aws_node_pool_config = parent_rpcs.delete_aws_node_pool if parent_rpcs.respond_to? :delete_aws_node_pool
                    @delete_aws_node_pool = ::Gapic::Config::Method.new delete_aws_node_pool_config
                    get_aws_open_id_config_config = parent_rpcs.get_aws_open_id_config if parent_rpcs.respond_to? :get_aws_open_id_config
                    @get_aws_open_id_config = ::Gapic::Config::Method.new get_aws_open_id_config_config
                    get_aws_json_web_keys_config = parent_rpcs.get_aws_json_web_keys if parent_rpcs.respond_to? :get_aws_json_web_keys
                    @get_aws_json_web_keys = ::Gapic::Config::Method.new get_aws_json_web_keys_config
                    get_aws_server_config_config = parent_rpcs.get_aws_server_config if parent_rpcs.respond_to? :get_aws_server_config
                    @get_aws_server_config = ::Gapic::Config::Method.new get_aws_server_config_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
