# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/gkemulticloud/v1/attached_service_pb"

module Google
  module Cloud
    module GkeMultiCloud
      module V1
        module AttachedClusters
          ##
          # Client for the AttachedClusters service.
          #
          # The AttachedClusters API provides a single centrally managed service
          # to register and manage Anthos attached clusters that run on customer's owned
          # infrastructure.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "gkemulticloud.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :attached_clusters_stub

            ##
            # Configure the AttachedClusters Client class.
            #
            # See {::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all AttachedClusters clients
            #   ::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "GkeMultiCloud", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.create_attached_cluster.timeout = 60.0

                default_config.rpcs.update_attached_cluster.timeout = 60.0

                default_config.rpcs.import_attached_cluster.timeout = 60.0

                default_config.rpcs.get_attached_cluster.timeout = 60.0
                default_config.rpcs.get_attached_cluster.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_attached_clusters.timeout = 60.0
                default_config.rpcs.list_attached_clusters.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.delete_attached_cluster.timeout = 60.0

                default_config.rpcs.get_attached_server_config.timeout = 60.0
                default_config.rpcs.get_attached_server_config.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.generate_attached_cluster_install_manifest.timeout = 60.0
                default_config.rpcs.generate_attached_cluster_install_manifest.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.generate_attached_cluster_agent_token.timeout = 60.0
                default_config.rpcs.generate_attached_cluster_agent_token.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the AttachedClusters Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @attached_clusters_stub.universe_domain
            end

            ##
            # Create a new AttachedClusters client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the AttachedClusters client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/gkemulticloud/v1/attached_service_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @attached_clusters_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @attached_clusters_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Operations]
            #
            attr_reader :operations_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @attached_clusters_stub.logger
            end

            # Service calls

            ##
            # Creates a new
            # {::Google::Cloud::GkeMultiCloud::V1::AttachedCluster AttachedCluster} resource
            # on a given Google Cloud Platform project and region.
            #
            # If successful, the response contains a newly created
            # {::Google::Longrunning::Operation Operation} resource that can be
            # described to track the status of the operation.
            #
            # @overload create_attached_cluster(request, options = nil)
            #   Pass arguments to `create_attached_cluster` via a request object, either of type
            #   {::Google::Cloud::GkeMultiCloud::V1::CreateAttachedClusterRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeMultiCloud::V1::CreateAttachedClusterRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_attached_cluster(parent: nil, attached_cluster: nil, attached_cluster_id: nil, validate_only: nil)
            #   Pass arguments to `create_attached_cluster` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent location where this
            #     {::Google::Cloud::GkeMultiCloud::V1::AttachedCluster AttachedCluster} resource
            #     will be created.
            #
            #     Location names are formatted as `projects/<project-id>/locations/<region>`.
            #
            #     See [Resource Names](https://cloud.google.com/apis/design/resource_names)
            #     for more details on Google Cloud resource names.
            #   @param attached_cluster [::Google::Cloud::GkeMultiCloud::V1::AttachedCluster, ::Hash]
            #     Required. The specification of the
            #     {::Google::Cloud::GkeMultiCloud::V1::AttachedCluster AttachedCluster} to create.
            #   @param attached_cluster_id [::String]
            #     Required. A client provided ID the resource. Must be unique within the
            #     parent resource.
            #
            #     The provided ID will be part of the
            #     {::Google::Cloud::GkeMultiCloud::V1::AttachedCluster AttachedCluster} resource
            #     name formatted as
            #     `projects/<project-id>/locations/<region>/attachedClusters/<cluster-id>`.
            #
            #     Valid characters are `/[a-z][0-9]-/`. Cannot be longer than 63 characters.
            #   @param validate_only [::Boolean]
            #     If set, only validate the request, but do not actually create the cluster.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_multi_cloud/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeMultiCloud::V1::CreateAttachedClusterRequest.new
            #
            #   # Call the create_attached_cluster method.
            #   result = client.create_attached_cluster request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_attached_cluster request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeMultiCloud::V1::CreateAttachedClusterRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_attached_cluster.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeMultiCloud::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_attached_cluster.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_attached_cluster.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @attached_clusters_stub.call_rpc :create_attached_cluster, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates an
            # {::Google::Cloud::GkeMultiCloud::V1::AttachedCluster AttachedCluster}.
            #
            # @overload update_attached_cluster(request, options = nil)
            #   Pass arguments to `update_attached_cluster` via a request object, either of type
            #   {::Google::Cloud::GkeMultiCloud::V1::UpdateAttachedClusterRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeMultiCloud::V1::UpdateAttachedClusterRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_attached_cluster(attached_cluster: nil, validate_only: nil, update_mask: nil)
            #   Pass arguments to `update_attached_cluster` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param attached_cluster [::Google::Cloud::GkeMultiCloud::V1::AttachedCluster, ::Hash]
            #     Required. The
            #     {::Google::Cloud::GkeMultiCloud::V1::AttachedCluster AttachedCluster} resource
            #     to update.
            #   @param validate_only [::Boolean]
            #     If set, only validate the request, but do not actually update the cluster.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Mask of fields to update. At least one path must be supplied in
            #     this field. The elements of the repeated paths field can only include these
            #     fields from
            #     {::Google::Cloud::GkeMultiCloud::V1::AttachedCluster AttachedCluster}:
            #
            #      *   `annotations`.
            #      *   `authorization.admin_groups`.
            #      *   `authorization.admin_users`.
            #      *   `binary_authorization.evaluation_mode`.
            #      *   `description`.
            #      *   `logging_config.component_config.enable_components`.
            #      *   `monitoring_config.managed_prometheus_config.enabled`.
            #      *   `platform_version`.
            #      *   `proxy_config.kubernetes_secret.name`.
            #      *   `proxy_config.kubernetes_secret.namespace`.
            #      *   `security_posture_config.vulnerability_mode`
            #      *   `monitoring_config.cloud_monitoring_config.enabled`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_multi_cloud/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeMultiCloud::V1::UpdateAttachedClusterRequest.new
            #
            #   # Call the update_attached_cluster method.
            #   result = client.update_attached_cluster request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_attached_cluster request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeMultiCloud::V1::UpdateAttachedClusterRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_attached_cluster.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeMultiCloud::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.attached_cluster&.name
                header_params["attached_cluster.name"] = request.attached_cluster.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_attached_cluster.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_attached_cluster.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @attached_clusters_stub.call_rpc :update_attached_cluster, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Imports creates a new
            # {::Google::Cloud::GkeMultiCloud::V1::AttachedCluster AttachedCluster} resource
            # by importing an existing Fleet Membership resource.
            #
            # Attached Clusters created before the introduction of the Anthos Multi-Cloud
            # API can be imported through this method.
            #
            # If successful, the response contains a newly created
            # {::Google::Longrunning::Operation Operation} resource that can be
            # described to track the status of the operation.
            #
            # @overload import_attached_cluster(request, options = nil)
            #   Pass arguments to `import_attached_cluster` via a request object, either of type
            #   {::Google::Cloud::GkeMultiCloud::V1::ImportAttachedClusterRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeMultiCloud::V1::ImportAttachedClusterRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload import_attached_cluster(parent: nil, validate_only: nil, fleet_membership: nil, platform_version: nil, distribution: nil, proxy_config: nil)
            #   Pass arguments to `import_attached_cluster` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent location where this
            #     {::Google::Cloud::GkeMultiCloud::V1::AttachedCluster AttachedCluster} resource
            #     will be created.
            #
            #     Location names are formatted as `projects/<project-id>/locations/<region>`.
            #
            #     See [Resource Names](https://cloud.google.com/apis/design/resource_names)
            #     for more details on Google Cloud resource names.
            #   @param validate_only [::Boolean]
            #     If set, only validate the request, but do not actually import the cluster.
            #   @param fleet_membership [::String]
            #     Required. The name of the fleet membership resource to import.
            #   @param platform_version [::String]
            #     Required. The platform version for the cluster (e.g. `1.19.0-gke.1000`).
            #
            #     You can list all supported versions on a given Google Cloud region by
            #     calling
            #     {::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Client#get_attached_server_config GetAttachedServerConfig}.
            #   @param distribution [::String]
            #     Required. The Kubernetes distribution of the underlying attached cluster.
            #
            #     Supported values: ["eks", "aks", "generic"].
            #   @param proxy_config [::Google::Cloud::GkeMultiCloud::V1::AttachedProxyConfig, ::Hash]
            #     Optional. Proxy configuration for outbound HTTP(S) traffic.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_multi_cloud/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeMultiCloud::V1::ImportAttachedClusterRequest.new
            #
            #   # Call the import_attached_cluster method.
            #   result = client.import_attached_cluster request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def import_attached_cluster request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeMultiCloud::V1::ImportAttachedClusterRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.import_attached_cluster.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeMultiCloud::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.import_attached_cluster.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.import_attached_cluster.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @attached_clusters_stub.call_rpc :import_attached_cluster, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Describes a specific
            # {::Google::Cloud::GkeMultiCloud::V1::AttachedCluster AttachedCluster} resource.
            #
            # @overload get_attached_cluster(request, options = nil)
            #   Pass arguments to `get_attached_cluster` via a request object, either of type
            #   {::Google::Cloud::GkeMultiCloud::V1::GetAttachedClusterRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeMultiCloud::V1::GetAttachedClusterRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_attached_cluster(name: nil)
            #   Pass arguments to `get_attached_cluster` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the
            #     {::Google::Cloud::GkeMultiCloud::V1::AttachedCluster AttachedCluster} resource
            #     to describe.
            #
            #     `AttachedCluster` names are formatted as
            #     `projects/<project-id>/locations/<region>/attachedClusters/<cluster-id>`.
            #
            #     See [Resource Names](https://cloud.google.com/apis/design/resource_names)
            #     for more details on Google Cloud Platform resource names.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::GkeMultiCloud::V1::AttachedCluster]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::GkeMultiCloud::V1::AttachedCluster]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_multi_cloud/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeMultiCloud::V1::GetAttachedClusterRequest.new
            #
            #   # Call the get_attached_cluster method.
            #   result = client.get_attached_cluster request
            #
            #   # The returned object is of type Google::Cloud::GkeMultiCloud::V1::AttachedCluster.
            #   p result
            #
            def get_attached_cluster request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeMultiCloud::V1::GetAttachedClusterRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_attached_cluster.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeMultiCloud::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_attached_cluster.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_attached_cluster.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @attached_clusters_stub.call_rpc :get_attached_cluster, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists all {::Google::Cloud::GkeMultiCloud::V1::AttachedCluster AttachedCluster}
            # resources on a given Google Cloud project and region.
            #
            # @overload list_attached_clusters(request, options = nil)
            #   Pass arguments to `list_attached_clusters` via a request object, either of type
            #   {::Google::Cloud::GkeMultiCloud::V1::ListAttachedClustersRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeMultiCloud::V1::ListAttachedClustersRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_attached_clusters(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_attached_clusters` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent location which owns this collection of
            #     {::Google::Cloud::GkeMultiCloud::V1::AttachedCluster AttachedCluster} resources.
            #
            #     Location names are formatted as `projects/<project-id>/locations/<region>`.
            #
            #     See [Resource Names](https://cloud.google.com/apis/design/resource_names)
            #     for more details on Google Cloud Platform resource names.
            #   @param page_size [::Integer]
            #     The maximum number of items to return.
            #
            #     If not specified, a default value of 50 will be used by the service.
            #     Regardless of the pageSize value, the response can include a partial list
            #     and a caller should only rely on response's
            #     {::Google::Cloud::GkeMultiCloud::V1::ListAttachedClustersResponse#next_page_token nextPageToken}
            #     to determine if there are more instances left to be queried.
            #   @param page_token [::String]
            #     The `nextPageToken` value returned from a previous
            #     {::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Client#list_attached_clusters attachedClusters.list}
            #     request, if any.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::GkeMultiCloud::V1::AttachedCluster>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::GkeMultiCloud::V1::AttachedCluster>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_multi_cloud/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeMultiCloud::V1::ListAttachedClustersRequest.new
            #
            #   # Call the list_attached_clusters method.
            #   result = client.list_attached_clusters request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::GkeMultiCloud::V1::AttachedCluster.
            #     p item
            #   end
            #
            def list_attached_clusters request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeMultiCloud::V1::ListAttachedClustersRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_attached_clusters.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeMultiCloud::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_attached_clusters.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_attached_clusters.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @attached_clusters_stub.call_rpc :list_attached_clusters, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @attached_clusters_stub, :list_attached_clusters, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a specific
            # {::Google::Cloud::GkeMultiCloud::V1::AttachedCluster AttachedCluster} resource.
            #
            # If successful, the response contains a newly created
            # {::Google::Longrunning::Operation Operation} resource that can be
            # described to track the status of the operation.
            #
            # @overload delete_attached_cluster(request, options = nil)
            #   Pass arguments to `delete_attached_cluster` via a request object, either of type
            #   {::Google::Cloud::GkeMultiCloud::V1::DeleteAttachedClusterRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeMultiCloud::V1::DeleteAttachedClusterRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_attached_cluster(name: nil, validate_only: nil, allow_missing: nil, ignore_errors: nil, etag: nil)
            #   Pass arguments to `delete_attached_cluster` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name the
            #     {::Google::Cloud::GkeMultiCloud::V1::AttachedCluster AttachedCluster} to delete.
            #
            #     `AttachedCluster` names are formatted as
            #     `projects/<project-id>/locations/<region>/attachedClusters/<cluster-id>`.
            #
            #     See [Resource Names](https://cloud.google.com/apis/design/resource_names)
            #     for more details on Google Cloud Platform resource names.
            #   @param validate_only [::Boolean]
            #     If set, only validate the request, but do not actually delete the resource.
            #   @param allow_missing [::Boolean]
            #     If set to true, and the
            #     {::Google::Cloud::GkeMultiCloud::V1::AttachedCluster AttachedCluster} resource
            #     is not found, the request will succeed but no action will be taken on the
            #     server and a completed {::Google::Longrunning::Operation Operation} will be
            #     returned.
            #
            #     Useful for idempotent deletion.
            #   @param ignore_errors [::Boolean]
            #     If set to true, the deletion of
            #     {::Google::Cloud::GkeMultiCloud::V1::AttachedCluster AttachedCluster} resource
            #     will succeed even if errors occur during deleting in cluster resources.
            #     Using this parameter may result in orphaned resources in the cluster.
            #   @param etag [::String]
            #     The current etag of the
            #     {::Google::Cloud::GkeMultiCloud::V1::AttachedCluster AttachedCluster}.
            #
            #     Allows clients to perform deletions through optimistic concurrency control.
            #
            #     If the provided etag does not match the current etag of the cluster,
            #     the request will fail and an ABORTED error will be returned.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_multi_cloud/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeMultiCloud::V1::DeleteAttachedClusterRequest.new
            #
            #   # Call the delete_attached_cluster method.
            #   result = client.delete_attached_cluster request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_attached_cluster request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeMultiCloud::V1::DeleteAttachedClusterRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_attached_cluster.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeMultiCloud::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_attached_cluster.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_attached_cluster.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @attached_clusters_stub.call_rpc :delete_attached_cluster, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns information, such as supported Kubernetes versions, on a given
            # Google Cloud location.
            #
            # @overload get_attached_server_config(request, options = nil)
            #   Pass arguments to `get_attached_server_config` via a request object, either of type
            #   {::Google::Cloud::GkeMultiCloud::V1::GetAttachedServerConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeMultiCloud::V1::GetAttachedServerConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_attached_server_config(name: nil)
            #   Pass arguments to `get_attached_server_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the
            #     {::Google::Cloud::GkeMultiCloud::V1::AttachedServerConfig AttachedServerConfig}
            #     resource to describe.
            #
            #     `AttachedServerConfig` names are formatted as
            #     `projects/<project-id>/locations/<region>/attachedServerConfig`.
            #
            #     See [Resource Names](https://cloud.google.com/apis/design/resource_names)
            #     for more details on Google Cloud resource names.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::GkeMultiCloud::V1::AttachedServerConfig]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::GkeMultiCloud::V1::AttachedServerConfig]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_multi_cloud/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeMultiCloud::V1::GetAttachedServerConfigRequest.new
            #
            #   # Call the get_attached_server_config method.
            #   result = client.get_attached_server_config request
            #
            #   # The returned object is of type Google::Cloud::GkeMultiCloud::V1::AttachedServerConfig.
            #   p result
            #
            def get_attached_server_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeMultiCloud::V1::GetAttachedServerConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_attached_server_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeMultiCloud::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_attached_server_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_attached_server_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @attached_clusters_stub.call_rpc :get_attached_server_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Generates the install manifest to be installed on the target cluster.
            #
            # @overload generate_attached_cluster_install_manifest(request, options = nil)
            #   Pass arguments to `generate_attached_cluster_install_manifest` via a request object, either of type
            #   {::Google::Cloud::GkeMultiCloud::V1::GenerateAttachedClusterInstallManifestRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeMultiCloud::V1::GenerateAttachedClusterInstallManifestRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload generate_attached_cluster_install_manifest(parent: nil, attached_cluster_id: nil, platform_version: nil, proxy_config: nil)
            #   Pass arguments to `generate_attached_cluster_install_manifest` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent location where this
            #     {::Google::Cloud::GkeMultiCloud::V1::AttachedCluster AttachedCluster} resource
            #     will be created.
            #
            #     Location names are formatted as `projects/<project-id>/locations/<region>`.
            #
            #     See [Resource Names](https://cloud.google.com/apis/design/resource_names)
            #     for more details on Google Cloud resource names.
            #   @param attached_cluster_id [::String]
            #     Required. A client provided ID of the resource. Must be unique within the
            #     parent resource.
            #
            #     The provided ID will be part of the
            #     {::Google::Cloud::GkeMultiCloud::V1::AttachedCluster AttachedCluster} resource
            #     name formatted as
            #     `projects/<project-id>/locations/<region>/attachedClusters/<cluster-id>`.
            #
            #     Valid characters are `/[a-z][0-9]-/`. Cannot be longer than 63 characters.
            #
            #     When generating an install manifest for importing an existing Membership
            #     resource, the attached_cluster_id field must be the Membership id.
            #
            #     Membership names are formatted as
            #     `projects/<project-id>/locations/<region>/memberships/<membership-id>`.
            #   @param platform_version [::String]
            #     Required. The platform version for the cluster (e.g. `1.19.0-gke.1000`).
            #
            #     You can list all supported versions on a given Google Cloud region by
            #     calling
            #     {::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Client#get_attached_server_config GetAttachedServerConfig}.
            #   @param proxy_config [::Google::Cloud::GkeMultiCloud::V1::AttachedProxyConfig, ::Hash]
            #     Optional. Proxy configuration for outbound HTTP(S) traffic.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::GkeMultiCloud::V1::GenerateAttachedClusterInstallManifestResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::GkeMultiCloud::V1::GenerateAttachedClusterInstallManifestResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_multi_cloud/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeMultiCloud::V1::GenerateAttachedClusterInstallManifestRequest.new
            #
            #   # Call the generate_attached_cluster_install_manifest method.
            #   result = client.generate_attached_cluster_install_manifest request
            #
            #   # The returned object is of type Google::Cloud::GkeMultiCloud::V1::GenerateAttachedClusterInstallManifestResponse.
            #   p result
            #
            def generate_attached_cluster_install_manifest request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeMultiCloud::V1::GenerateAttachedClusterInstallManifestRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.generate_attached_cluster_install_manifest.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeMultiCloud::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.generate_attached_cluster_install_manifest.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.generate_attached_cluster_install_manifest.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @attached_clusters_stub.call_rpc :generate_attached_cluster_install_manifest, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Generates an access token for a cluster agent.
            #
            # @overload generate_attached_cluster_agent_token(request, options = nil)
            #   Pass arguments to `generate_attached_cluster_agent_token` via a request object, either of type
            #   {::Google::Cloud::GkeMultiCloud::V1::GenerateAttachedClusterAgentTokenRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::GkeMultiCloud::V1::GenerateAttachedClusterAgentTokenRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload generate_attached_cluster_agent_token(attached_cluster: nil, subject_token: nil, subject_token_type: nil, version: nil, grant_type: nil, audience: nil, scope: nil, requested_token_type: nil, options: nil)
            #   Pass arguments to `generate_attached_cluster_agent_token` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param attached_cluster [::String]
            #     Required.
            #   @param subject_token [::String]
            #     Required.
            #   @param subject_token_type [::String]
            #     Required.
            #   @param version [::String]
            #     Required.
            #   @param grant_type [::String]
            #     Optional.
            #   @param audience [::String]
            #     Optional.
            #   @param scope [::String]
            #     Optional.
            #   @param requested_token_type [::String]
            #     Optional.
            #   @param options [::String]
            #     Optional.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::GkeMultiCloud::V1::GenerateAttachedClusterAgentTokenResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::GkeMultiCloud::V1::GenerateAttachedClusterAgentTokenResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/gke_multi_cloud/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::GkeMultiCloud::V1::GenerateAttachedClusterAgentTokenRequest.new
            #
            #   # Call the generate_attached_cluster_agent_token method.
            #   result = client.generate_attached_cluster_agent_token request
            #
            #   # The returned object is of type Google::Cloud::GkeMultiCloud::V1::GenerateAttachedClusterAgentTokenResponse.
            #   p result
            #
            def generate_attached_cluster_agent_token request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeMultiCloud::V1::GenerateAttachedClusterAgentTokenRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.generate_attached_cluster_agent_token.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::GkeMultiCloud::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.attached_cluster
                header_params["attached_cluster"] = request.attached_cluster
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.generate_attached_cluster_agent_token.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.generate_attached_cluster_agent_token.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @attached_clusters_stub.call_rpc :generate_attached_cluster_agent_token, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the AttachedClusters API.
            #
            # This class represents the configuration for AttachedClusters,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # create_attached_cluster to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_attached_cluster.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_attached_cluster.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::GkeMultiCloud::V1::AttachedClusters::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "gkemulticloud.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the AttachedClusters API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `create_attached_cluster`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_attached_cluster
                ##
                # RPC-specific configuration for `update_attached_cluster`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_attached_cluster
                ##
                # RPC-specific configuration for `import_attached_cluster`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :import_attached_cluster
                ##
                # RPC-specific configuration for `get_attached_cluster`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_attached_cluster
                ##
                # RPC-specific configuration for `list_attached_clusters`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_attached_clusters
                ##
                # RPC-specific configuration for `delete_attached_cluster`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_attached_cluster
                ##
                # RPC-specific configuration for `get_attached_server_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_attached_server_config
                ##
                # RPC-specific configuration for `generate_attached_cluster_install_manifest`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :generate_attached_cluster_install_manifest
                ##
                # RPC-specific configuration for `generate_attached_cluster_agent_token`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :generate_attached_cluster_agent_token

                # @private
                def initialize parent_rpcs = nil
                  create_attached_cluster_config = parent_rpcs.create_attached_cluster if parent_rpcs.respond_to? :create_attached_cluster
                  @create_attached_cluster = ::Gapic::Config::Method.new create_attached_cluster_config
                  update_attached_cluster_config = parent_rpcs.update_attached_cluster if parent_rpcs.respond_to? :update_attached_cluster
                  @update_attached_cluster = ::Gapic::Config::Method.new update_attached_cluster_config
                  import_attached_cluster_config = parent_rpcs.import_attached_cluster if parent_rpcs.respond_to? :import_attached_cluster
                  @import_attached_cluster = ::Gapic::Config::Method.new import_attached_cluster_config
                  get_attached_cluster_config = parent_rpcs.get_attached_cluster if parent_rpcs.respond_to? :get_attached_cluster
                  @get_attached_cluster = ::Gapic::Config::Method.new get_attached_cluster_config
                  list_attached_clusters_config = parent_rpcs.list_attached_clusters if parent_rpcs.respond_to? :list_attached_clusters
                  @list_attached_clusters = ::Gapic::Config::Method.new list_attached_clusters_config
                  delete_attached_cluster_config = parent_rpcs.delete_attached_cluster if parent_rpcs.respond_to? :delete_attached_cluster
                  @delete_attached_cluster = ::Gapic::Config::Method.new delete_attached_cluster_config
                  get_attached_server_config_config = parent_rpcs.get_attached_server_config if parent_rpcs.respond_to? :get_attached_server_config
                  @get_attached_server_config = ::Gapic::Config::Method.new get_attached_server_config_config
                  generate_attached_cluster_install_manifest_config = parent_rpcs.generate_attached_cluster_install_manifest if parent_rpcs.respond_to? :generate_attached_cluster_install_manifest
                  @generate_attached_cluster_install_manifest = ::Gapic::Config::Method.new generate_attached_cluster_install_manifest_config
                  generate_attached_cluster_agent_token_config = parent_rpcs.generate_attached_cluster_agent_token if parent_rpcs.respond_to? :generate_attached_cluster_agent_token
                  @generate_attached_cluster_agent_token = ::Gapic::Config::Method.new generate_attached_cluster_agent_token_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
