# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/cloud/gkehub/v1beta1/membership.proto for package 'Google.Cloud.GkeHub.V1beta1'
# Original file comments:
# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/cloud/gkehub/v1beta1/membership_pb'

module Google
  module Cloud
    module GkeHub
      module V1beta1
        module GkeHubMembershipService
          # The GKE Hub MembershipService handles the registration of many Kubernetes
          # clusters to Google Cloud, represented with the
          # [Membership][google.cloud.gkehub.v1beta1.Membership] resource.
          #
          # GKE Hub is currently available in the global region and all regions in
          # https://cloud.google.com/compute/docs/regions-zones.
          #
          # **Membership management may be non-trivial:** it is recommended to use one
          # of the Google-provided client libraries or tools where possible when working
          # with Membership resources.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.cloud.gkehub.v1beta1.GkeHubMembershipService'

            # Lists Memberships in a given project and location.
            rpc :ListMemberships, ::Google::Cloud::GkeHub::V1beta1::ListMembershipsRequest, ::Google::Cloud::GkeHub::V1beta1::ListMembershipsResponse
            # Gets the details of a Membership.
            rpc :GetMembership, ::Google::Cloud::GkeHub::V1beta1::GetMembershipRequest, ::Google::Cloud::GkeHub::V1beta1::Membership
            # Creates a new Membership.
            #
            # **This is currently only supported for GKE clusters on Google Cloud**.
            # To register other clusters, follow the instructions at
            # https://cloud.google.com/anthos/multicluster-management/connect/registering-a-cluster.
            rpc :CreateMembership, ::Google::Cloud::GkeHub::V1beta1::CreateMembershipRequest, ::Google::Longrunning::Operation
            # Removes a Membership.
            #
            # **This is currently only supported for GKE clusters on Google Cloud**.
            # To unregister other clusters, follow the instructions at
            # https://cloud.google.com/anthos/multicluster-management/connect/unregistering-a-cluster.
            rpc :DeleteMembership, ::Google::Cloud::GkeHub::V1beta1::DeleteMembershipRequest, ::Google::Longrunning::Operation
            # Updates an existing Membership.
            rpc :UpdateMembership, ::Google::Cloud::GkeHub::V1beta1::UpdateMembershipRequest, ::Google::Longrunning::Operation
            # Generates the manifest for deployment of the GKE connect agent.
            #
            # **This method is used internally by Google-provided libraries.**
            # Most clients should not need to call this method directly.
            rpc :GenerateConnectManifest, ::Google::Cloud::GkeHub::V1beta1::GenerateConnectManifestRequest, ::Google::Cloud::GkeHub::V1beta1::GenerateConnectManifestResponse
            # ValidateExclusivity validates the state of exclusivity in the cluster.
            # The validation does not depend on an existing Hub membership resource.
            rpc :ValidateExclusivity, ::Google::Cloud::GkeHub::V1beta1::ValidateExclusivityRequest, ::Google::Cloud::GkeHub::V1beta1::ValidateExclusivityResponse
            # GenerateExclusivityManifest generates the manifests to update the
            # exclusivity artifacts in the cluster if needed.
            #
            # Exclusivity artifacts include the Membership custom resource definition
            # (CRD) and the singleton Membership custom resource (CR). Combined with
            # ValidateExclusivity, exclusivity artifacts guarantee that a Kubernetes
            # cluster is only registered to a single GKE Hub.
            #
            # The Membership CRD is versioned, and may require conversion when the GKE
            # Hub API server begins serving a newer version of the CRD and
            # corresponding CR. The response will be the converted CRD and CR if there
            # are any differences between the versions.
            rpc :GenerateExclusivityManifest, ::Google::Cloud::GkeHub::V1beta1::GenerateExclusivityManifestRequest, ::Google::Cloud::GkeHub::V1beta1::GenerateExclusivityManifestResponse
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
