# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/gkehub/v1beta1/membership_pb"
require "google/cloud/gke_hub/v1beta1/gke_hub_membership_service/rest/service_stub"
require "google/cloud/location/rest"
require "google/iam/v1/rest"

module Google
  module Cloud
    module GkeHub
      module V1beta1
        module GkeHubMembershipService
          module Rest
            ##
            # REST client for the GkeHubMembershipService service.
            #
            # The GKE Hub MembershipService handles the registration of many Kubernetes
            # clusters to Google Cloud, represented with the
            # {::Google::Cloud::GkeHub::V1beta1::Membership Membership} resource.
            #
            # GKE Hub is currently available in the global region and all regions in
            # https://cloud.google.com/compute/docs/regions-zones.
            #
            # **Membership management may be non-trivial:** it is recommended to use one
            # of the Google-provided client libraries or tools where possible when working
            # with Membership resources.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "gkehub.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :gke_hub_membership_service_stub

              ##
              # Configure the GkeHubMembershipService Client class.
              #
              # See {::Google::Cloud::GkeHub::V1beta1::GkeHubMembershipService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all GkeHubMembershipService clients
              #   ::Google::Cloud::GkeHub::V1beta1::GkeHubMembershipService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "GkeHub", "V1beta1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.timeout = 60.0
                  default_config.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the GkeHubMembershipService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::GkeHub::V1beta1::GkeHubMembershipService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @gke_hub_membership_service_stub.universe_domain
              end

              ##
              # Create a new GkeHubMembershipService REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::GkeHub::V1beta1::GkeHubMembershipService::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::GkeHub::V1beta1::GkeHubMembershipService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the GkeHubMembershipService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::GkeHub::V1beta1::GkeHubMembershipService::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @gke_hub_membership_service_stub = ::Google::Cloud::GkeHub::V1beta1::GkeHubMembershipService::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @gke_hub_membership_service_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @gke_hub_membership_service_stub.endpoint
                  config.universe_domain = @gke_hub_membership_service_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @gke_hub_membership_service_stub.logger if config.respond_to? :logger=
                end

                @iam_policy_client = Google::Iam::V1::IAMPolicy::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @gke_hub_membership_service_stub.endpoint
                  config.universe_domain = @gke_hub_membership_service_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @gke_hub_membership_service_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::GkeHub::V1beta1::GkeHubMembershipService::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # Get the associated client for mix-in of the IAMPolicy.
              #
              # @return [Google::Iam::V1::IAMPolicy::Rest::Client]
              #
              attr_reader :iam_policy_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @gke_hub_membership_service_stub.logger
              end

              # Service calls

              ##
              # Lists Memberships in a given project and location.
              #
              # @overload list_memberships(request, options = nil)
              #   Pass arguments to `list_memberships` via a request object, either of type
              #   {::Google::Cloud::GkeHub::V1beta1::ListMembershipsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GkeHub::V1beta1::ListMembershipsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_memberships(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_memberships` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent (project and location) where the Memberships will be
              #     listed. Specified in the format `projects/*/locations/*`.
              #     `projects/*/locations/-` list memberships in all the regions.
              #   @param page_size [::Integer]
              #     Optional. When requesting a 'page' of resources, `page_size` specifies
              #     number of resources to return. If unspecified or set to 0, all resources
              #     will be returned.
              #   @param page_token [::String]
              #     Optional. Token returned by previous call to `ListMemberships` which
              #     specifies the position in the list from where to continue listing the
              #     resources.
              #   @param filter [::String]
              #     Optional. Lists Memberships that match the filter expression, following the
              #     syntax outlined in https://google.aip.dev/160.
              #
              #     Examples:
              #
              #       - Name is `bar` in project `foo-proj` and location `global`:
              #
              #           name = "projects/foo-proj/locations/global/membership/bar"
              #
              #       - Memberships that have a label called `foo`:
              #
              #           labels.foo:*
              #
              #       - Memberships that have a label called `foo` whose value is `bar`:
              #
              #           labels.foo = bar
              #
              #       - Memberships in the CREATING state:
              #
              #           state = CREATING
              #   @param order_by [::String]
              #     Optional. One or more fields to compare and use to sort the output.
              #     See https://google.aip.dev/132#ordering.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::GkeHub::V1beta1::Membership>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::GkeHub::V1beta1::Membership>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gke_hub/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GkeHub::V1beta1::GkeHubMembershipService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GkeHub::V1beta1::ListMembershipsRequest.new
              #
              #   # Call the list_memberships method.
              #   result = client.list_memberships request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::GkeHub::V1beta1::Membership.
              #     p item
              #   end
              #
              def list_memberships request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeHub::V1beta1::ListMembershipsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_memberships.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GkeHub::V1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_memberships.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_memberships.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @gke_hub_membership_service_stub.list_memberships request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @gke_hub_membership_service_stub, :list_memberships, "resources", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the details of a Membership.
              #
              # @overload get_membership(request, options = nil)
              #   Pass arguments to `get_membership` via a request object, either of type
              #   {::Google::Cloud::GkeHub::V1beta1::GetMembershipRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GkeHub::V1beta1::GetMembershipRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_membership(name: nil)
              #   Pass arguments to `get_membership` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The Membership resource name in the format
              #     `projects/*/locations/*/memberships/*`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::GkeHub::V1beta1::Membership]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::GkeHub::V1beta1::Membership]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gke_hub/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GkeHub::V1beta1::GkeHubMembershipService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GkeHub::V1beta1::GetMembershipRequest.new
              #
              #   # Call the get_membership method.
              #   result = client.get_membership request
              #
              #   # The returned object is of type Google::Cloud::GkeHub::V1beta1::Membership.
              #   p result
              #
              def get_membership request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeHub::V1beta1::GetMembershipRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_membership.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GkeHub::V1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_membership.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_membership.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @gke_hub_membership_service_stub.get_membership request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new Membership.
              #
              # **This is currently only supported for GKE clusters on Google Cloud**.
              # To register other clusters, follow the instructions at
              # https://cloud.google.com/anthos/multicluster-management/connect/registering-a-cluster.
              #
              # @overload create_membership(request, options = nil)
              #   Pass arguments to `create_membership` via a request object, either of type
              #   {::Google::Cloud::GkeHub::V1beta1::CreateMembershipRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GkeHub::V1beta1::CreateMembershipRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_membership(parent: nil, membership_id: nil, resource: nil, request_id: nil)
              #   Pass arguments to `create_membership` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent (project and location) where the Memberships will be
              #     created. Specified in the format `projects/*/locations/*`.
              #   @param membership_id [::String]
              #     Required. Client chosen ID for the membership. `membership_id` must be a
              #     valid RFC 1123 compliant DNS label:
              #
              #       1. At most 63 characters in length
              #       2. It must consist of lower case alphanumeric characters or `-`
              #       3. It must start and end with an alphanumeric character
              #
              #     Which can be expressed as the regex: `[a-z0-9]([-a-z0-9]*[a-z0-9])?`,
              #     with a maximum length of 63 characters.
              #   @param resource [::Google::Cloud::GkeHub::V1beta1::Membership, ::Hash]
              #     Required. The membership to create.
              #   @param request_id [::String]
              #     Optional. A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gke_hub/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GkeHub::V1beta1::GkeHubMembershipService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GkeHub::V1beta1::CreateMembershipRequest.new
              #
              #   # Call the create_membership method.
              #   result = client.create_membership request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_membership request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeHub::V1beta1::CreateMembershipRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_membership.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GkeHub::V1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_membership.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_membership.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @gke_hub_membership_service_stub.create_membership request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Removes a Membership.
              #
              # **This is currently only supported for GKE clusters on Google Cloud**.
              # To unregister other clusters, follow the instructions at
              # https://cloud.google.com/anthos/multicluster-management/connect/unregistering-a-cluster.
              #
              # @overload delete_membership(request, options = nil)
              #   Pass arguments to `delete_membership` via a request object, either of type
              #   {::Google::Cloud::GkeHub::V1beta1::DeleteMembershipRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GkeHub::V1beta1::DeleteMembershipRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_membership(name: nil, request_id: nil, force: nil)
              #   Pass arguments to `delete_membership` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The Membership resource name in the format
              #     `projects/*/locations/*/memberships/*`.
              #   @param request_id [::String]
              #     Optional. A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param force [::Boolean]
              #     Optional. If set to true, any subresource from this Membership will also be
              #     deleted. Otherwise, the request will only work if the Membership has no
              #     subresource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gke_hub/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GkeHub::V1beta1::GkeHubMembershipService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GkeHub::V1beta1::DeleteMembershipRequest.new
              #
              #   # Call the delete_membership method.
              #   result = client.delete_membership request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_membership request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeHub::V1beta1::DeleteMembershipRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_membership.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GkeHub::V1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_membership.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_membership.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @gke_hub_membership_service_stub.delete_membership request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates an existing Membership.
              #
              # @overload update_membership(request, options = nil)
              #   Pass arguments to `update_membership` via a request object, either of type
              #   {::Google::Cloud::GkeHub::V1beta1::UpdateMembershipRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GkeHub::V1beta1::UpdateMembershipRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_membership(name: nil, update_mask: nil, resource: nil, request_id: nil)
              #   Pass arguments to `update_membership` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The membership resource name in the format:
              #     `projects/[project_id]/locations/global/memberships/[membership_id]`
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Mask of fields to update. At least one field path must be
              #     specified in this mask.
              #   @param resource [::Google::Cloud::GkeHub::V1beta1::Membership, ::Hash]
              #     Required. Only fields specified in update_mask are updated.
              #     If you specify a field in the update_mask but don't specify its value here
              #     that field will be deleted.
              #     If you are updating a map field, set the value of a key to null or empty
              #     string to delete the key from the map. It's not possible to update a key's
              #     value to the empty string.
              #     If you specify the update_mask to be a special path "*", fully replaces all
              #     user-modifiable fields to match `resource`.
              #   @param request_id [::String]
              #     Optional. A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gke_hub/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GkeHub::V1beta1::GkeHubMembershipService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GkeHub::V1beta1::UpdateMembershipRequest.new
              #
              #   # Call the update_membership method.
              #   result = client.update_membership request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_membership request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeHub::V1beta1::UpdateMembershipRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_membership.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GkeHub::V1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_membership.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_membership.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @gke_hub_membership_service_stub.update_membership request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Generates the manifest for deployment of the GKE connect agent.
              #
              # **This method is used internally by Google-provided libraries.**
              # Most clients should not need to call this method directly.
              #
              # @overload generate_connect_manifest(request, options = nil)
              #   Pass arguments to `generate_connect_manifest` via a request object, either of type
              #   {::Google::Cloud::GkeHub::V1beta1::GenerateConnectManifestRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GkeHub::V1beta1::GenerateConnectManifestRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload generate_connect_manifest(name: nil, connect_agent: nil, version: nil, is_upgrade: nil, registry: nil, image_pull_secret_content: nil)
              #   Pass arguments to `generate_connect_manifest` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The Membership resource name the Agent will associate with, in
              #     the format `projects/*/locations/*/memberships/*`.
              #   @param connect_agent [::Google::Cloud::GkeHub::V1beta1::ConnectAgent, ::Hash]
              #     Optional. The connect agent to generate manifest for.
              #   @param version [::String]
              #     Optional. The Connect agent version to use. Defaults to the most current
              #     version.
              #   @param is_upgrade [::Boolean]
              #     Optional. If true, generate the resources for upgrade only. Some resources
              #     generated only for installation (e.g. secrets) will be excluded.
              #   @param registry [::String]
              #     Optional. The registry to fetch the connect agent image from. Defaults to
              #     gcr.io/gkeconnect.
              #   @param image_pull_secret_content [::String]
              #     Optional. The image pull secret content for the registry, if not public.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::GkeHub::V1beta1::GenerateConnectManifestResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::GkeHub::V1beta1::GenerateConnectManifestResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gke_hub/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GkeHub::V1beta1::GkeHubMembershipService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GkeHub::V1beta1::GenerateConnectManifestRequest.new
              #
              #   # Call the generate_connect_manifest method.
              #   result = client.generate_connect_manifest request
              #
              #   # The returned object is of type Google::Cloud::GkeHub::V1beta1::GenerateConnectManifestResponse.
              #   p result
              #
              def generate_connect_manifest request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeHub::V1beta1::GenerateConnectManifestRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.generate_connect_manifest.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GkeHub::V1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.generate_connect_manifest.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.generate_connect_manifest.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @gke_hub_membership_service_stub.generate_connect_manifest request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # ValidateExclusivity validates the state of exclusivity in the cluster.
              # The validation does not depend on an existing Hub membership resource.
              #
              # @overload validate_exclusivity(request, options = nil)
              #   Pass arguments to `validate_exclusivity` via a request object, either of type
              #   {::Google::Cloud::GkeHub::V1beta1::ValidateExclusivityRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GkeHub::V1beta1::ValidateExclusivityRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload validate_exclusivity(parent: nil, cr_manifest: nil, intended_membership: nil)
              #   Pass arguments to `validate_exclusivity` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent (project and location) where the Memberships will be
              #     created. Specified in the format `projects/*/locations/*`.
              #   @param cr_manifest [::String]
              #     Optional. The YAML of the membership CR in the cluster. Empty if the
              #     membership CR does not exist.
              #   @param intended_membership [::String]
              #     Required. The intended membership name under the `parent`. This method only
              #     does validation in anticipation of a CreateMembership call with the same
              #     name.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::GkeHub::V1beta1::ValidateExclusivityResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::GkeHub::V1beta1::ValidateExclusivityResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gke_hub/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GkeHub::V1beta1::GkeHubMembershipService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GkeHub::V1beta1::ValidateExclusivityRequest.new
              #
              #   # Call the validate_exclusivity method.
              #   result = client.validate_exclusivity request
              #
              #   # The returned object is of type Google::Cloud::GkeHub::V1beta1::ValidateExclusivityResponse.
              #   p result
              #
              def validate_exclusivity request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeHub::V1beta1::ValidateExclusivityRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.validate_exclusivity.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GkeHub::V1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.validate_exclusivity.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.validate_exclusivity.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @gke_hub_membership_service_stub.validate_exclusivity request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # GenerateExclusivityManifest generates the manifests to update the
              # exclusivity artifacts in the cluster if needed.
              #
              # Exclusivity artifacts include the Membership custom resource definition
              # (CRD) and the singleton Membership custom resource (CR). Combined with
              # ValidateExclusivity, exclusivity artifacts guarantee that a Kubernetes
              # cluster is only registered to a single GKE Hub.
              #
              # The Membership CRD is versioned, and may require conversion when the GKE
              # Hub API server begins serving a newer version of the CRD and
              # corresponding CR. The response will be the converted CRD and CR if there
              # are any differences between the versions.
              #
              # @overload generate_exclusivity_manifest(request, options = nil)
              #   Pass arguments to `generate_exclusivity_manifest` via a request object, either of type
              #   {::Google::Cloud::GkeHub::V1beta1::GenerateExclusivityManifestRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::GkeHub::V1beta1::GenerateExclusivityManifestRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload generate_exclusivity_manifest(name: nil, crd_manifest: nil, cr_manifest: nil)
              #   Pass arguments to `generate_exclusivity_manifest` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The Membership resource name in the format
              #     `projects/*/locations/*/memberships/*`.
              #   @param crd_manifest [::String]
              #     Optional. The YAML manifest of the membership CRD retrieved by
              #     `kubectl get customresourcedefinitions membership`.
              #     Leave empty if the resource does not exist.
              #   @param cr_manifest [::String]
              #     Optional. The YAML manifest of the membership CR retrieved by
              #     `kubectl get memberships membership`.
              #     Leave empty if the resource does not exist.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::GkeHub::V1beta1::GenerateExclusivityManifestResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::GkeHub::V1beta1::GenerateExclusivityManifestResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/gke_hub/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::GkeHub::V1beta1::GkeHubMembershipService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::GkeHub::V1beta1::GenerateExclusivityManifestRequest.new
              #
              #   # Call the generate_exclusivity_manifest method.
              #   result = client.generate_exclusivity_manifest request
              #
              #   # The returned object is of type Google::Cloud::GkeHub::V1beta1::GenerateExclusivityManifestResponse.
              #   p result
              #
              def generate_exclusivity_manifest request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::GkeHub::V1beta1::GenerateExclusivityManifestRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.generate_exclusivity_manifest.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::GkeHub::V1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.generate_exclusivity_manifest.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.generate_exclusivity_manifest.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @gke_hub_membership_service_stub.generate_exclusivity_manifest request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the GkeHubMembershipService REST API.
              #
              # This class represents the configuration for GkeHubMembershipService REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::GkeHub::V1beta1::GkeHubMembershipService::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # list_memberships to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::GkeHub::V1beta1::GkeHubMembershipService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_memberships.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::GkeHub::V1beta1::GkeHubMembershipService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_memberships.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "gkehub.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the GkeHubMembershipService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `list_memberships`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_memberships
                  ##
                  # RPC-specific configuration for `get_membership`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_membership
                  ##
                  # RPC-specific configuration for `create_membership`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_membership
                  ##
                  # RPC-specific configuration for `delete_membership`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_membership
                  ##
                  # RPC-specific configuration for `update_membership`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_membership
                  ##
                  # RPC-specific configuration for `generate_connect_manifest`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :generate_connect_manifest
                  ##
                  # RPC-specific configuration for `validate_exclusivity`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :validate_exclusivity
                  ##
                  # RPC-specific configuration for `generate_exclusivity_manifest`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :generate_exclusivity_manifest

                  # @private
                  def initialize parent_rpcs = nil
                    list_memberships_config = parent_rpcs.list_memberships if parent_rpcs.respond_to? :list_memberships
                    @list_memberships = ::Gapic::Config::Method.new list_memberships_config
                    get_membership_config = parent_rpcs.get_membership if parent_rpcs.respond_to? :get_membership
                    @get_membership = ::Gapic::Config::Method.new get_membership_config
                    create_membership_config = parent_rpcs.create_membership if parent_rpcs.respond_to? :create_membership
                    @create_membership = ::Gapic::Config::Method.new create_membership_config
                    delete_membership_config = parent_rpcs.delete_membership if parent_rpcs.respond_to? :delete_membership
                    @delete_membership = ::Gapic::Config::Method.new delete_membership_config
                    update_membership_config = parent_rpcs.update_membership if parent_rpcs.respond_to? :update_membership
                    @update_membership = ::Gapic::Config::Method.new update_membership_config
                    generate_connect_manifest_config = parent_rpcs.generate_connect_manifest if parent_rpcs.respond_to? :generate_connect_manifest
                    @generate_connect_manifest = ::Gapic::Config::Method.new generate_connect_manifest_config
                    validate_exclusivity_config = parent_rpcs.validate_exclusivity if parent_rpcs.respond_to? :validate_exclusivity
                    @validate_exclusivity = ::Gapic::Config::Method.new validate_exclusivity_config
                    generate_exclusivity_manifest_config = parent_rpcs.generate_exclusivity_manifest if parent_rpcs.respond_to? :generate_exclusivity_manifest
                    @generate_exclusivity_manifest = ::Gapic::Config::Method.new generate_exclusivity_manifest_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
