# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module GkeHub
      module V1
        # Request message for `GkeHub.ListMemberships` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent (project and location) where the Memberships will be
        #     listed. Specified in the format `projects/*/locations/*`.
        #     `projects/*/locations/-` list memberships in all the regions.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. When requesting a 'page' of resources, `page_size` specifies
        #     number of resources to return. If unspecified or set to 0, all resources
        #     will be returned.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Token returned by previous call to `ListMemberships` which
        #     specifies the position in the list from where to continue listing the
        #     resources.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Lists Memberships that match the filter expression, following the
        #     syntax outlined in https://google.aip.dev/160.
        #
        #     Examples:
        #
        #       - Name is `bar` in project `foo-proj` and location `global`:
        #
        #           name = "projects/foo-proj/locations/global/membership/bar"
        #
        #       - Memberships that have a label called `foo`:
        #
        #           labels.foo:*
        #
        #       - Memberships that have a label called `foo` whose value is `bar`:
        #
        #           labels.foo = bar
        #
        #       - Memberships in the CREATING state:
        #
        #           state = CREATING
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. One or more fields to compare and use to sort the output.
        #     See https://google.aip.dev/132#ordering.
        class ListMembershipsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for the `GkeHub.ListMemberships` method.
        # @!attribute [rw] resources
        #   @return [::Array<::Google::Cloud::GkeHub::V1::Membership>]
        #     The list of matching Memberships.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token to request the next page of resources from the
        #     `ListMemberships` method. The value of an empty string means that
        #     there are no more resources to return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     List of locations that could not be reached while fetching this list.
        class ListMembershipsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for `GkeHub.GetMembership` method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The Membership resource name in the format
        #     `projects/*/locations/*/memberships/*`.
        class GetMembershipRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for the `GkeHub.CreateMembership` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent (project and location) where the Memberships will be
        #     created. Specified in the format `projects/*/locations/*`.
        # @!attribute [rw] membership_id
        #   @return [::String]
        #     Required. Client chosen ID for the membership. `membership_id` must be a
        #     valid RFC 1123 compliant DNS label:
        #
        #       1. At most 63 characters in length
        #       2. It must consist of lower case alphanumeric characters or `-`
        #       3. It must start and end with an alphanumeric character
        #
        #     Which can be expressed as the regex: `[a-z0-9]([-a-z0-9]*[a-z0-9])?`,
        #     with a maximum length of 63 characters.
        # @!attribute [rw] resource
        #   @return [::Google::Cloud::GkeHub::V1::Membership]
        #     Required. The membership to create.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server will guarantee
        #     that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateMembershipRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for `GkeHub.DeleteMembership` method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The Membership resource name in the format
        #     `projects/*/locations/*/memberships/*`.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server will guarantee
        #     that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     Optional. If set to true, any subresource from this Membership will also be
        #     deleted. Otherwise, the request will only work if the Membership has no
        #     subresource.
        class DeleteMembershipRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for `GkeHub.UpdateMembership` method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The Membership resource name in the format
        #     `projects/*/locations/*/memberships/*`.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Mask of fields to update.
        # @!attribute [rw] resource
        #   @return [::Google::Cloud::GkeHub::V1::Membership]
        #     Required. Only fields specified in update_mask are updated.
        #     If you specify a field in the update_mask but don't specify its value here
        #     that field will be deleted.
        #     If you are updating a map field, set the value of a key to null or empty
        #     string to delete the key from the map. It's not possible to update a key's
        #     value to the empty string.
        #     If you specify the update_mask to be a special path "*", fully replaces all
        #     user-modifiable fields to match `resource`.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server will guarantee
        #     that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateMembershipRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for `GkeHub.GenerateConnectManifest`
        # method.
        # .
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The Membership resource name the Agent will associate with, in
        #     the format `projects/*/locations/*/memberships/*`.
        # @!attribute [rw] namespace
        #   @return [::String]
        #     Optional. Namespace for GKE Connect agent resources. Defaults to
        #     `gke-connect`.
        #
        #     The Connect Agent is authorized automatically when run in the default
        #     namespace. Otherwise, explicit authorization must be granted with an
        #     additional IAM binding.
        # @!attribute [rw] proxy
        #   @return [::String]
        #     Optional. URI of a proxy if connectivity from the agent to
        #     gkeconnect.googleapis.com requires the use of a proxy. Format must be in
        #     the form `http(s)://{proxy_address}`, depending on the HTTP/HTTPS protocol
        #     supported by the proxy. This will direct the connect agent's outbound
        #     traffic through a HTTP(S) proxy.
        # @!attribute [rw] version
        #   @return [::String]
        #     Optional. The Connect agent version to use. Defaults to the most current
        #     version.
        # @!attribute [rw] is_upgrade
        #   @return [::Boolean]
        #     Optional. If true, generate the resources for upgrade only. Some resources
        #     generated only for installation (e.g. secrets) will be excluded.
        # @!attribute [rw] registry
        #   @return [::String]
        #     Optional. The registry to fetch the connect agent image from. Defaults to
        #     gcr.io/gkeconnect.
        # @!attribute [rw] image_pull_secret_content
        #   @return [::String]
        #     Optional. The image pull secret content for the registry, if not public.
        class GenerateConnectManifestRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # GenerateConnectManifestResponse contains manifest information for
        # installing/upgrading a Connect agent.
        # @!attribute [rw] manifest
        #   @return [::Array<::Google::Cloud::GkeHub::V1::ConnectAgentResource>]
        #     The ordered list of Kubernetes resources that need to be applied to the
        #     cluster for GKE Connect agent installation/upgrade.
        class GenerateConnectManifestResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ConnectAgentResource represents a Kubernetes resource manifest for Connect
        # Agent deployment.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::GkeHub::V1::TypeMeta]
        #     Kubernetes type of the resource.
        # @!attribute [rw] manifest
        #   @return [::String]
        #     YAML manifest of the resource.
        class ConnectAgentResource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # TypeMeta is the type information needed for content unmarshalling of
        # Kubernetes resources in the manifest.
        # @!attribute [rw] kind
        #   @return [::String]
        #     Kind of the resource (e.g. Deployment).
        # @!attribute [rw] api_version
        #   @return [::String]
        #     APIVersion of the resource (e.g. v1).
        class TypeMeta
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for `GkeHub.ListFeatures` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent (project and location) where the Features will be
        #     listed. Specified in the format `projects/*/locations/*`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     When requesting a 'page' of resources, `page_size` specifies number of
        #     resources to return. If unspecified or set to 0, all resources will
        #     be returned.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Token returned by previous call to `ListFeatures` which
        #     specifies the position in the list from where to continue listing the
        #     resources.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Lists Features that match the filter expression, following the syntax
        #     outlined in https://google.aip.dev/160.
        #
        #     Examples:
        #
        #       - Feature with the name "servicemesh" in project "foo-proj":
        #
        #           name = "projects/foo-proj/locations/global/features/servicemesh"
        #
        #       - Features that have a label called `foo`:
        #
        #           labels.foo:*
        #
        #       - Features that have a label called `foo` whose value is `bar`:
        #
        #           labels.foo = bar
        # @!attribute [rw] order_by
        #   @return [::String]
        #     One or more fields to compare and use to sort the output.
        #     See https://google.aip.dev/132#ordering.
        class ListFeaturesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for the `GkeHub.ListFeatures` method.
        # @!attribute [rw] resources
        #   @return [::Array<::Google::Cloud::GkeHub::V1::Feature>]
        #     The list of matching Features
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token to request the next page of resources from the
        #     `ListFeatures` method. The value of an empty string means
        #     that there are no more resources to return.
        class ListFeaturesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for `GkeHub.GetFeature` method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The Feature resource name in the format
        #     `projects/*/locations/*/features/*`
        class GetFeatureRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for the `GkeHub.CreateFeature` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent (project and location) where the Feature will be
        #     created. Specified in the format `projects/*/locations/*`.
        # @!attribute [rw] feature_id
        #   @return [::String]
        #     The ID of the feature to create.
        # @!attribute [rw] resource
        #   @return [::Google::Cloud::GkeHub::V1::Feature]
        #     The Feature resource to create.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server will guarantee
        #     that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateFeatureRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for `GkeHub.DeleteFeature` method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The Feature resource name in the format
        #     `projects/*/locations/*/features/*`.
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     If set to true, the delete will ignore any outstanding resources for
        #     this Feature (that is, `FeatureState.has_resources` is set to true). These
        #     resources will NOT be cleaned up or modified in any way.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server will guarantee
        #     that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteFeatureRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for `GkeHub.UpdateFeature` method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The Feature resource name in the format
        #     `projects/*/locations/*/features/*`.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Mask of fields to update.
        # @!attribute [rw] resource
        #   @return [::Google::Cloud::GkeHub::V1::Feature]
        #     Only fields specified in update_mask are updated.
        #     If you specify a field in the update_mask but don't specify its value here
        #     that field will be deleted.
        #     If you are updating a map field, set the value of a key to null or empty
        #     string to delete the key from the map. It's not possible to update a key's
        #     value to the empty string.
        #     If you specify the update_mask to be a special path "*", fully replaces all
        #     user-modifiable fields to match `resource`.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server will guarantee
        #     that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateFeatureRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the metadata of the long-running operation.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation finished running.
        # @!attribute [r] target
        #   @return [::String]
        #     Output only. Server-defined resource path for the target of the operation.
        # @!attribute [r] verb
        #   @return [::String]
        #     Output only. Name of the verb executed by the operation.
        # @!attribute [r] status_detail
        #   @return [::String]
        #     Output only. Human-readable status of the operation, if any.
        # @!attribute [r] cancel_requested
        #   @return [::Boolean]
        #     Output only. Identifies whether the user has requested cancellation
        #     of the operation. Operations that have successfully been cancelled
        #     have [Operation.error][] value with a
        #     {::Google::Rpc::Status#code google.rpc.Status.code} of 1, corresponding to
        #     `Code.CANCELLED`.
        # @!attribute [r] api_version
        #   @return [::String]
        #     Output only. API version used to start the operation.
        class OperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
