# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module GkeHub
      module V1
        # Membership contains information about a member cluster.
        # @!attribute [rw] endpoint
        #   @return [::Google::Cloud::GkeHub::V1::MembershipEndpoint]
        #     Optional. Endpoint information to reach this member.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The full, unique name of this Membership resource in the
        #     format `projects/*/locations/*/memberships/{membership_id}`, set during
        #     creation.
        #
        #     `membership_id` must be a valid RFC 1123 compliant DNS label:
        #
        #       1. At most 63 characters in length
        #       2. It must consist of lower case alphanumeric characters or `-`
        #       3. It must start and end with an alphanumeric character
        #
        #     Which can be expressed as the regex: `[a-z0-9]([-a-z0-9]*[a-z0-9])?`,
        #     with a maximum length of 63 characters.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Labels for this membership.
        # @!attribute [r] description
        #   @return [::String]
        #     Output only. Description of this membership, limited to 63 characters.
        #     Must match the regex: `[a-zA-Z0-9][a-zA-Z0-9_\-\.\ ]*`
        #
        #     This field is present for legacy purposes.
        # @!attribute [r] state
        #   @return [::Google::Cloud::GkeHub::V1::MembershipState]
        #     Output only. State of the Membership resource.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. When the Membership was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. When the Membership was last updated.
        # @!attribute [r] delete_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. When the Membership was deleted.
        # @!attribute [rw] external_id
        #   @return [::String]
        #     Optional. An externally-generated and managed ID for this Membership. This
        #     ID may be modified after creation, but this is not recommended.
        #
        #     The ID must match the regex: `[a-zA-Z0-9][a-zA-Z0-9_\-\.]*`
        #
        #     If this Membership represents a Kubernetes cluster, this value should be
        #     set to the UID of the `kube-system` namespace object.
        # @!attribute [r] last_connection_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. For clusters using Connect, the timestamp of the most recent
        #     connection established with Google Cloud. This time is updated every
        #     several minutes, not continuously. For clusters that do not use GKE
        #     Connect, or that have never connected successfully, this field will be
        #     unset.
        # @!attribute [r] unique_id
        #   @return [::String]
        #     Output only. Google-generated UUID for this resource. This is unique across
        #     all Membership resources. If a Membership resource is deleted and another
        #     resource with the same name is created, it gets a different unique_id.
        # @!attribute [rw] authority
        #   @return [::Google::Cloud::GkeHub::V1::Authority]
        #     Optional. How to identify workloads from this Membership.
        #     See the documentation on Workload Identity for more details:
        #     https://cloud.google.com/kubernetes-engine/docs/how-to/workload-identity
        # @!attribute [rw] monitoring_config
        #   @return [::Google::Cloud::GkeHub::V1::MonitoringConfig]
        #     Optional. The monitoring config information for this membership.
        class Membership
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # MembershipEndpoint contains information needed to contact a Kubernetes API,
        # endpoint and any additional Kubernetes metadata.
        # @!attribute [rw] gke_cluster
        #   @return [::Google::Cloud::GkeHub::V1::GkeCluster]
        #     Optional. GKE-specific information. Only present if this Membership is a GKE cluster.
        # @!attribute [r] kubernetes_metadata
        #   @return [::Google::Cloud::GkeHub::V1::KubernetesMetadata]
        #     Output only. Useful Kubernetes-specific metadata.
        # @!attribute [rw] kubernetes_resource
        #   @return [::Google::Cloud::GkeHub::V1::KubernetesResource]
        #     Optional. The in-cluster Kubernetes Resources that should be applied for a
        #     correctly registered cluster, in the steady state. These resources:
        #
        #       * Ensure that the cluster is exclusively registered to one and only one
        #         Hub Membership.
        #       * Propagate Workload Pool Information available in the Membership
        #         Authority field.
        #       * Ensure proper initial configuration of default Hub Features.
        # @!attribute [r] google_managed
        #   @return [::Boolean]
        #     Output only. Whether the lifecycle of this membership is managed by a
        #     google cluster platform service.
        class MembershipEndpoint
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # KubernetesResource contains the YAML manifests and configuration for
        # Membership Kubernetes resources in the cluster. After CreateMembership or
        # UpdateMembership, these resources should be re-applied in the cluster.
        # @!attribute [rw] membership_cr_manifest
        #   @return [::String]
        #     Input only. The YAML representation of the Membership CR. This field is
        #     ignored for GKE clusters where Hub can read the CR directly.
        #
        #     Callers should provide the CR that is currently present in the cluster
        #     during CreateMembership or UpdateMembership, or leave this field empty if
        #     none exists. The CR manifest is used to validate the cluster has not been
        #     registered with another Membership.
        # @!attribute [r] membership_resources
        #   @return [::Array<::Google::Cloud::GkeHub::V1::ResourceManifest>]
        #     Output only. Additional Kubernetes resources that need to be applied to the
        #     cluster after Membership creation, and after every update.
        #
        #     This field is only populated in the Membership returned from a successful
        #     long-running operation from CreateMembership or UpdateMembership. It is not
        #     populated during normal GetMembership or ListMemberships requests. To get
        #     the resource manifest after the initial registration, the caller should
        #     make a UpdateMembership call with an empty field mask.
        # @!attribute [r] connect_resources
        #   @return [::Array<::Google::Cloud::GkeHub::V1::ResourceManifest>]
        #     Output only. The Kubernetes resources for installing the GKE Connect agent
        #
        #     This field is only populated in the Membership returned from a successful
        #     long-running operation from CreateMembership or UpdateMembership. It is not
        #     populated during normal GetMembership or ListMemberships requests. To get
        #     the resource manifest after the initial registration, the caller should
        #     make a UpdateMembership call with an empty field mask.
        # @!attribute [rw] resource_options
        #   @return [::Google::Cloud::GkeHub::V1::ResourceOptions]
        #     Optional. Options for Kubernetes resource generation.
        class KubernetesResource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ResourceOptions represent options for Kubernetes resource generation.
        # @!attribute [rw] connect_version
        #   @return [::String]
        #     Optional. The Connect agent version to use for connect_resources. Defaults
        #     to the latest GKE Connect version. The version must be a currently
        #     supported version, obsolete versions will be rejected.
        # @!attribute [rw] v1beta1_crd
        #   @return [::Boolean]
        #     Optional. Use `apiextensions/v1beta1` instead of `apiextensions/v1` for
        #     CustomResourceDefinition resources.
        #     This option should be set for clusters with Kubernetes apiserver versions
        #     <1.16.
        # @!attribute [rw] k8s_version
        #   @return [::String]
        #     Optional. Major and minor version of the Kubernetes cluster. This is only
        #     used to determine which version to use for the CustomResourceDefinition
        #     resources, `apiextensions/v1beta1` or`apiextensions/v1`.
        # @!attribute [rw] k8s_git_version
        #   @return [::String]
        #     Optional. Git version of the Kubernetes cluster. This is only used to gate
        #     the Connect Agent migration to svc.id.goog on GDC-SO 1.33.100 patch and
        #     above.
        class ResourceOptions
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ResourceManifest represents a single Kubernetes resource to be applied to
        # the cluster.
        # @!attribute [rw] manifest
        #   @return [::String]
        #     YAML manifest of the resource.
        # @!attribute [rw] cluster_scoped
        #   @return [::Boolean]
        #     Whether the resource provided in the manifest is `cluster_scoped`.
        #     If unset, the manifest is assumed to be namespace scoped.
        #
        #     This field is used for REST mapping when applying the resource in a
        #     cluster.
        class ResourceManifest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # GkeCluster contains information specific to GKE clusters.
        # @!attribute [rw] resource_link
        #   @return [::String]
        #     Immutable. Self-link of the Google Cloud resource for the GKE cluster. For
        #     example:
        #
        #     //container.googleapis.com/projects/my-project/locations/us-west1-a/clusters/my-cluster
        #
        #     Zonal clusters are also supported.
        # @!attribute [r] cluster_missing
        #   @return [::Boolean]
        #     Output only. If cluster_missing is set then it denotes that the GKE cluster
        #     no longer exists in the GKE Control Plane.
        class GkeCluster
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # KubernetesMetadata provides informational metadata for Memberships
        # representing Kubernetes clusters.
        # @!attribute [r] kubernetes_api_server_version
        #   @return [::String]
        #     Output only. Kubernetes API server version string as reported by
        #     `/version`.
        # @!attribute [r] node_provider_id
        #   @return [::String]
        #     Output only. Node providerID as reported by the first node in the list of
        #     nodes on the Kubernetes endpoint. On Kubernetes platforms that support
        #     zero-node clusters (like GKE-on-GCP), the node_count will be zero and the
        #     node_provider_id will be empty.
        # @!attribute [r] node_count
        #   @return [::Integer]
        #     Output only. Node count as reported by Kubernetes nodes resources.
        # @!attribute [r] vcpu_count
        #   @return [::Integer]
        #     Output only. vCPU count as reported by Kubernetes nodes resources.
        # @!attribute [r] memory_mb
        #   @return [::Integer]
        #     Output only. The total memory capacity as reported by the sum of all
        #     Kubernetes nodes resources, defined in MB.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which these details were last updated. This
        #     update_time is different from the Membership-level update_time since
        #     EndpointDetails are updated internally for API consumers.
        class KubernetesMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # This field informs Fleet-based applications/services/UIs with the necessary
        # information for where each underlying Cluster reports its metrics.
        # @!attribute [rw] project_id
        #   @return [::String]
        #     Immutable. Project used to report Metrics
        # @!attribute [rw] location
        #   @return [::String]
        #     Immutable. Location used to report Metrics
        # @!attribute [rw] cluster
        #   @return [::String]
        #     Immutable. Cluster name used to report metrics.
        #     For Anthos on VMWare/Baremetal, it would be in format
        #     `memberClusters/cluster_name`; And for Anthos on MultiCloud, it would be in
        #     format
        #     `{azureClusters, awsClusters}/cluster_name`.
        # @!attribute [rw] kubernetes_metrics_prefix
        #   @return [::String]
        #     Kubernetes system metrics, if available, are written to this prefix.
        #     This defaults to kubernetes.io for GKE, and kubernetes.io/anthos for Anthos
        #     eventually. Noted: Anthos MultiCloud will have kubernetes.io prefix today
        #     but will migration to be under kubernetes.io/anthos
        # @!attribute [rw] cluster_hash
        #   @return [::String]
        #     Immutable. Cluster hash, this is a unique string generated by google code,
        #     which does not contain any PII, which we can use to reference the cluster.
        #     This is expected to be created by the monitoring stack and persisted into
        #     the Cluster object as well as to GKE-Hub.
        class MonitoringConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # MembershipState describes the state of a Membership resource.
        # @!attribute [r] code
        #   @return [::Google::Cloud::GkeHub::V1::MembershipState::Code]
        #     Output only. The current state of the Membership resource.
        class MembershipState
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Code describes the state of a Membership resource.
          module Code
            # The code is not set.
            CODE_UNSPECIFIED = 0

            # The cluster is being registered.
            CREATING = 1

            # The cluster is registered.
            READY = 2

            # The cluster is being unregistered.
            DELETING = 3

            # The Membership is being updated.
            UPDATING = 4

            # The Membership is being updated by the Hub Service.
            SERVICE_UPDATING = 5
          end
        end

        # Authority encodes how Google will recognize identities from this Membership.
        # See the workload identity documentation for more details:
        # https://cloud.google.com/kubernetes-engine/docs/how-to/workload-identity
        # @!attribute [rw] issuer
        #   @return [::String]
        #     Optional. A JSON Web Token (JWT) issuer URI. `issuer` must start with
        #     `https://` and be a valid URL with length <2000 characters.
        #
        #     If set, then Google will allow valid OIDC tokens from this issuer to
        #     authenticate within the workload_identity_pool. OIDC discovery will be
        #     performed on this URI to validate tokens from the issuer.
        #
        #     Clearing `issuer` disables Workload Identity. `issuer` cannot be directly
        #     modified; it must be cleared (and Workload Identity disabled) before using
        #     a new issuer (and re-enabling Workload Identity).
        # @!attribute [r] workload_identity_pool
        #   @return [::String]
        #     Output only. The name of the workload identity pool in which `issuer` will
        #     be recognized.
        #
        #     There is a single Workload Identity Pool per Hub that is shared
        #     between all Memberships that belong to that Hub. For a Hub hosted in
        #     \\{PROJECT_ID}, the workload pool format is `{PROJECT_ID}.hub.id.goog`,
        #     although this is subject to change in newer versions of this API.
        # @!attribute [r] identity_provider
        #   @return [::String]
        #     Output only. An identity provider that reflects the `issuer` in the
        #     workload identity pool.
        # @!attribute [rw] oidc_jwks
        #   @return [::String]
        #     Optional. OIDC verification keys for this Membership in JWKS format (RFC
        #     7517).
        #
        #     When this field is set, OIDC discovery will NOT be performed on `issuer`,
        #     and instead OIDC tokens will be validated using this field.
        class Authority
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
