# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module GkeHub
      module ConfigManagement
        module V1
          # **Anthos Config Management**: State for a single cluster.
          # @!attribute [rw] cluster_name
          #   @return [::String]
          #     This field is set to the `cluster_name` field of the Membership Spec if it
          #     is not empty. Otherwise, it is set to the cluster's fleet membership name.
          # @!attribute [rw] membership_spec
          #   @return [::Google::Cloud::GkeHub::ConfigManagement::V1::MembershipSpec]
          #     Membership configuration in the cluster. This represents the actual state
          #     in the cluster, while the MembershipSpec in the FeatureSpec represents
          #     the intended state
          # @!attribute [rw] operator_state
          #   @return [::Google::Cloud::GkeHub::ConfigManagement::V1::OperatorState]
          #     Current install status of ACM's Operator
          # @!attribute [rw] config_sync_state
          #   @return [::Google::Cloud::GkeHub::ConfigManagement::V1::ConfigSyncState]
          #     Current sync status
          # @!attribute [rw] policy_controller_state
          #   @return [::Google::Cloud::GkeHub::ConfigManagement::V1::PolicyControllerState]
          #     PolicyController status
          # @!attribute [rw] hierarchy_controller_state
          #   @return [::Google::Cloud::GkeHub::ConfigManagement::V1::HierarchyControllerState]
          #     Hierarchy Controller status
          class MembershipState
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # **Anthos Config Management**: Configuration for a single cluster.
          # Intended to parallel the ConfigManagement CR.
          # @!attribute [rw] config_sync
          #   @return [::Google::Cloud::GkeHub::ConfigManagement::V1::ConfigSync]
          #     Config Sync configuration for the cluster.
          # @!attribute [rw] policy_controller
          #   @return [::Google::Cloud::GkeHub::ConfigManagement::V1::PolicyController]
          #     Policy Controller configuration for the cluster.
          # @!attribute [rw] hierarchy_controller
          #   @return [::Google::Cloud::GkeHub::ConfigManagement::V1::HierarchyControllerConfig]
          #     Hierarchy Controller configuration for the cluster.
          # @!attribute [rw] version
          #   @return [::String]
          #     Version of ACM installed.
          # @!attribute [rw] cluster
          #   @return [::String]
          #     The user-specified cluster name used by Config Sync cluster-name-selector
          #     annotation or ClusterSelector, for applying configs to only a subset
          #     of clusters.
          #     Omit this field if the cluster's fleet membership name is used by Config
          #     Sync cluster-name-selector annotation or ClusterSelector.
          #     Set this field if a name different from the cluster's fleet membership name
          #     is used by Config Sync cluster-name-selector annotation or ClusterSelector.
          # @!attribute [rw] management
          #   @return [::Google::Cloud::GkeHub::ConfigManagement::V1::MembershipSpec::Management]
          #     Enables automatic Feature management.
          class MembershipSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Whether to automatically manage the Feature.
            module Management
              # Unspecified
              MANAGEMENT_UNSPECIFIED = 0

              # Google will manage the Feature for the cluster.
              MANAGEMENT_AUTOMATIC = 1

              # User will manually manage the Feature for the cluster.
              MANAGEMENT_MANUAL = 2
            end
          end

          # Configuration for Config Sync
          # @!attribute [rw] git
          #   @return [::Google::Cloud::GkeHub::ConfigManagement::V1::GitConfig]
          #     Git repo configuration for the cluster.
          # @!attribute [rw] source_format
          #   @return [::String]
          #     Specifies whether the Config Sync Repo is
          #     in "hierarchical" or "unstructured" mode.
          # @!attribute [rw] enabled
          #   @return [::Boolean]
          #     Enables the installation of ConfigSync.
          #     If set to true, ConfigSync resources will be created and the other
          #     ConfigSync fields will be applied if exist.
          #     If set to false, all other ConfigSync fields will be ignored, ConfigSync
          #     resources will be deleted.
          #     If omitted, ConfigSync resources will be managed depends on the presence
          #     of the git or oci field.
          # @!attribute [rw] prevent_drift
          #   @return [::Boolean]
          #     Set to true to enable the Config Sync admission webhook to prevent drifts.
          #     If set to `false`, disables the Config Sync admission webhook and does not
          #     prevent drifts.
          # @!attribute [rw] oci
          #   @return [::Google::Cloud::GkeHub::ConfigManagement::V1::OciConfig]
          #     OCI repo configuration for the cluster
          # @!attribute [rw] metrics_gcp_service_account_email
          #   @return [::String]
          #     The Email of the Google Cloud Service Account (GSA) used for exporting
          #     Config Sync metrics to Cloud Monitoring when Workload Identity is enabled.
          #     The GSA should have the Monitoring Metric Writer
          #     (roles/monitoring.metricWriter) IAM role.
          #     The Kubernetes ServiceAccount `default` in the namespace
          #     `config-management-monitoring` should be bound to the GSA.
          class ConfigSync
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Git repo configuration for a single cluster.
          # @!attribute [rw] sync_repo
          #   @return [::String]
          #     The URL of the Git repository to use as the source of truth.
          # @!attribute [rw] sync_branch
          #   @return [::String]
          #     The branch of the repository to sync from. Default: master.
          # @!attribute [rw] policy_dir
          #   @return [::String]
          #     The path within the Git repository that represents the top level of the
          #     repo to sync. Default: the root directory of the repository.
          # @!attribute [rw] sync_wait_secs
          #   @return [::Integer]
          #     Period in seconds between consecutive syncs. Default: 15.
          # @!attribute [rw] sync_rev
          #   @return [::String]
          #     Git revision (tag or hash) to check out. Default HEAD.
          # @!attribute [rw] secret_type
          #   @return [::String]
          #     Type of secret configured for access to the Git repo. Must be one of ssh,
          #     cookiefile, gcenode, token, gcpserviceaccount or none. The
          #     validation of this is case-sensitive. Required.
          # @!attribute [rw] https_proxy
          #   @return [::String]
          #     URL for the HTTPS proxy to be used when communicating with the Git repo.
          # @!attribute [rw] gcp_service_account_email
          #   @return [::String]
          #     The Google Cloud Service Account Email used for auth when secret_type is
          #     gcpServiceAccount.
          class GitConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # OCI repo configuration for a single cluster
          # @!attribute [rw] sync_repo
          #   @return [::String]
          #     The OCI image repository URL for the package to sync from.
          #     e.g. `LOCATION-docker.pkg.dev/PROJECT_ID/REPOSITORY_NAME/PACKAGE_NAME`.
          # @!attribute [rw] policy_dir
          #   @return [::String]
          #     The absolute path of the directory that contains
          #     the local resources.  Default: the root directory of the image.
          # @!attribute [rw] sync_wait_secs
          #   @return [::Integer]
          #     Period in seconds between consecutive syncs. Default: 15.
          # @!attribute [rw] secret_type
          #   @return [::String]
          #     Type of secret configured for access to the Git repo.
          # @!attribute [rw] gcp_service_account_email
          #   @return [::String]
          #     The Google Cloud Service Account Email used for auth when secret_type is
          #     gcpServiceAccount.
          class OciConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Configuration for Policy Controller
          # @!attribute [rw] enabled
          #   @return [::Boolean]
          #     Enables the installation of Policy Controller.
          #     If false, the rest of PolicyController fields take no
          #     effect.
          # @!attribute [rw] template_library_installed
          #   @return [::Boolean]
          #     Installs the default template library along with Policy Controller.
          # @!attribute [rw] audit_interval_seconds
          #   @return [::Integer]
          #     Sets the interval for Policy Controller Audit Scans (in seconds).
          #     When set to 0, this disables audit functionality altogether.
          # @!attribute [rw] exemptable_namespaces
          #   @return [::Array<::String>]
          #     The set of namespaces that are excluded from Policy Controller checks.
          #     Namespaces do not need to currently exist on the cluster.
          # @!attribute [rw] referential_rules_enabled
          #   @return [::Boolean]
          #     Enables the ability to use Constraint Templates that reference to objects
          #     other than the object currently being evaluated.
          # @!attribute [rw] log_denies_enabled
          #   @return [::Boolean]
          #     Logs all denies and dry run failures.
          class PolicyController
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Configuration for Hierarchy Controller
          # @!attribute [rw] enabled
          #   @return [::Boolean]
          #     Whether Hierarchy Controller is enabled in this cluster.
          # @!attribute [rw] enable_pod_tree_labels
          #   @return [::Boolean]
          #     Whether pod tree labels are enabled in this cluster.
          # @!attribute [rw] enable_hierarchical_resource_quota
          #   @return [::Boolean]
          #     Whether hierarchical resource quota is enabled in this cluster.
          class HierarchyControllerConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Deployment state for Hierarchy Controller
          # @!attribute [rw] hnc
          #   @return [::Google::Cloud::GkeHub::ConfigManagement::V1::DeploymentState]
          #     The deployment state for open source HNC (e.g. v0.7.0-hc.0)
          # @!attribute [rw] extension
          #   @return [::Google::Cloud::GkeHub::ConfigManagement::V1::DeploymentState]
          #     The deployment state for Hierarchy Controller extension (e.g. v0.7.0-hc.1)
          class HierarchyControllerDeploymentState
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Version for Hierarchy Controller
          # @!attribute [rw] hnc
          #   @return [::String]
          #     Version for open source HNC
          # @!attribute [rw] extension
          #   @return [::String]
          #     Version for Hierarchy Controller extension
          class HierarchyControllerVersion
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # State for Hierarchy Controller
          # @!attribute [rw] version
          #   @return [::Google::Cloud::GkeHub::ConfigManagement::V1::HierarchyControllerVersion]
          #     The version for Hierarchy Controller
          # @!attribute [rw] state
          #   @return [::Google::Cloud::GkeHub::ConfigManagement::V1::HierarchyControllerDeploymentState]
          #     The deployment state for Hierarchy Controller
          class HierarchyControllerState
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # State information for an ACM's Operator
          # @!attribute [rw] version
          #   @return [::String]
          #     The semenatic version number of the operator
          # @!attribute [rw] deployment_state
          #   @return [::Google::Cloud::GkeHub::ConfigManagement::V1::DeploymentState]
          #     The state of the Operator's deployment
          # @!attribute [rw] errors
          #   @return [::Array<::Google::Cloud::GkeHub::ConfigManagement::V1::InstallError>]
          #     Install errors.
          class OperatorState
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Errors pertaining to the installation of ACM
          # @!attribute [rw] error_message
          #   @return [::String]
          #     A string representing the user facing error message
          class InstallError
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # State information for ConfigSync
          # @!attribute [rw] version
          #   @return [::Google::Cloud::GkeHub::ConfigManagement::V1::ConfigSyncVersion]
          #     The version of ConfigSync deployed
          # @!attribute [rw] deployment_state
          #   @return [::Google::Cloud::GkeHub::ConfigManagement::V1::ConfigSyncDeploymentState]
          #     Information about the deployment of ConfigSync, including the version
          #     of the various Pods deployed
          # @!attribute [rw] sync_state
          #   @return [::Google::Cloud::GkeHub::ConfigManagement::V1::SyncState]
          #     The state of ConfigSync's process to sync configs to a cluster
          # @!attribute [rw] errors
          #   @return [::Array<::Google::Cloud::GkeHub::ConfigManagement::V1::ConfigSyncError>]
          #     Errors pertaining to the installation of Config Sync.
          # @!attribute [rw] rootsync_crd
          #   @return [::Google::Cloud::GkeHub::ConfigManagement::V1::ConfigSyncState::CRDState]
          #     The state of the RootSync CRD
          # @!attribute [rw] reposync_crd
          #   @return [::Google::Cloud::GkeHub::ConfigManagement::V1::ConfigSyncState::CRDState]
          #     The state of the Reposync CRD
          # @!attribute [rw] state
          #   @return [::Google::Cloud::GkeHub::ConfigManagement::V1::ConfigSyncState::State]
          #     The state of CS
          #     This field summarizes the other fields in this message.
          class ConfigSyncState
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # CRDState representing the state of a CRD
            module CRDState
              # CRD's state cannot be determined
              CRD_STATE_UNSPECIFIED = 0

              # CRD is not installed
              NOT_INSTALLED = 1

              # CRD is installed
              INSTALLED = 2

              # CRD is terminating (i.e., it has been deleted and is cleaning up)
              TERMINATING = 3

              # CRD is installing
              INSTALLING = 4
            end

            module State
              # CS's state cannot be determined.
              STATE_UNSPECIFIED = 0

              # CS is not installed.
              CONFIG_SYNC_NOT_INSTALLED = 1

              # The expected CS version is installed successfully.
              CONFIG_SYNC_INSTALLED = 2

              # CS encounters errors.
              CONFIG_SYNC_ERROR = 3

              # CS is installing or terminating.
              CONFIG_SYNC_PENDING = 4
            end
          end

          # Errors pertaining to the installation of Config Sync
          # @!attribute [rw] error_message
          #   @return [::String]
          #     A string representing the user facing error message
          class ConfigSyncError
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Specific versioning information pertaining to ConfigSync's Pods
          # @!attribute [rw] importer
          #   @return [::String]
          #     Version of the deployed importer pod
          # @!attribute [rw] syncer
          #   @return [::String]
          #     Version of the deployed syncer pod
          # @!attribute [rw] git_sync
          #   @return [::String]
          #     Version of the deployed git-sync pod
          # @!attribute [rw] monitor
          #   @return [::String]
          #     Version of the deployed monitor pod
          # @!attribute [rw] reconciler_manager
          #   @return [::String]
          #     Version of the deployed reconciler-manager pod
          # @!attribute [rw] root_reconciler
          #   @return [::String]
          #     Version of the deployed reconciler container in root-reconciler pod
          # @!attribute [rw] admission_webhook
          #   @return [::String]
          #     Version of the deployed admission_webhook pod
          class ConfigSyncVersion
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The state of ConfigSync's deployment on a cluster
          # @!attribute [rw] importer
          #   @return [::Google::Cloud::GkeHub::ConfigManagement::V1::DeploymentState]
          #     Deployment state of the importer pod
          # @!attribute [rw] syncer
          #   @return [::Google::Cloud::GkeHub::ConfigManagement::V1::DeploymentState]
          #     Deployment state of the syncer pod
          # @!attribute [rw] git_sync
          #   @return [::Google::Cloud::GkeHub::ConfigManagement::V1::DeploymentState]
          #     Deployment state of the git-sync pod
          # @!attribute [rw] monitor
          #   @return [::Google::Cloud::GkeHub::ConfigManagement::V1::DeploymentState]
          #     Deployment state of the monitor pod
          # @!attribute [rw] reconciler_manager
          #   @return [::Google::Cloud::GkeHub::ConfigManagement::V1::DeploymentState]
          #     Deployment state of reconciler-manager pod
          # @!attribute [rw] root_reconciler
          #   @return [::Google::Cloud::GkeHub::ConfigManagement::V1::DeploymentState]
          #     Deployment state of root-reconciler
          # @!attribute [rw] admission_webhook
          #   @return [::Google::Cloud::GkeHub::ConfigManagement::V1::DeploymentState]
          #     Deployment state of admission-webhook
          class ConfigSyncDeploymentState
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # State indicating an ACM's progress syncing configurations to a cluster
          # @!attribute [rw] source_token
          #   @return [::String]
          #     Token indicating the state of the repo.
          # @!attribute [rw] import_token
          #   @return [::String]
          #     Token indicating the state of the importer.
          # @!attribute [rw] sync_token
          #   @return [::String]
          #     Token indicating the state of the syncer.
          # @!attribute [rw] last_sync
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::String]
          #     Deprecated: use last_sync_time instead.
          #     Timestamp of when ACM last successfully synced the repo
          #     The time format is specified in https://golang.org/pkg/time/#Time.String
          # @!attribute [rw] last_sync_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Timestamp type of when ACM last successfully synced the repo
          # @!attribute [rw] code
          #   @return [::Google::Cloud::GkeHub::ConfigManagement::V1::SyncState::SyncCode]
          #     Sync status code
          # @!attribute [rw] errors
          #   @return [::Array<::Google::Cloud::GkeHub::ConfigManagement::V1::SyncError>]
          #     A list of errors resulting from problematic configs.
          #     This list will be truncated after 100 errors, although it is
          #     unlikely for that many errors to simultaneously exist.
          class SyncState
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # An enum representing Config Sync's status of syncing configs to a cluster.
            module SyncCode
              # Config Sync cannot determine a sync code
              SYNC_CODE_UNSPECIFIED = 0

              # Config Sync successfully synced the git Repo with the cluster
              SYNCED = 1

              # Config Sync is in the progress of syncing a new change
              PENDING = 2

              # Indicates an error configuring Config Sync, and user action is required
              ERROR = 3

              # Config Sync has been installed but not configured
              NOT_CONFIGURED = 4

              # Config Sync has not been installed
              NOT_INSTALLED = 5

              # Error authorizing with the cluster
              UNAUTHORIZED = 6

              # Cluster could not be reached
              UNREACHABLE = 7
            end
          end

          # An ACM created error representing a problem syncing configurations
          # @!attribute [rw] code
          #   @return [::String]
          #     An ACM defined error code
          # @!attribute [rw] error_message
          #   @return [::String]
          #     A description of the error
          # @!attribute [rw] error_resources
          #   @return [::Array<::Google::Cloud::GkeHub::ConfigManagement::V1::ErrorResource>]
          #     A list of config(s) associated with the error, if any
          class SyncError
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Model for a config file in the git repo with an associated Sync error
          # @!attribute [rw] source_path
          #   @return [::String]
          #     Path in the git repo of the erroneous config
          # @!attribute [rw] resource_name
          #   @return [::String]
          #     Metadata name of the resource that is causing an error
          # @!attribute [rw] resource_namespace
          #   @return [::String]
          #     Namespace of the resource that is causing an error
          # @!attribute [rw] resource_gvk
          #   @return [::Google::Cloud::GkeHub::ConfigManagement::V1::GroupVersionKind]
          #     Group/version/kind of the resource that is causing an error
          class ErrorResource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A Kubernetes object's GVK
          # @!attribute [rw] group
          #   @return [::String]
          #     Kubernetes Group
          # @!attribute [rw] version
          #   @return [::String]
          #     Kubernetes Version
          # @!attribute [rw] kind
          #   @return [::String]
          #     Kubernetes Kind
          class GroupVersionKind
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # State for PolicyControllerState.
          # @!attribute [rw] version
          #   @return [::Google::Cloud::GkeHub::ConfigManagement::V1::PolicyControllerVersion]
          #     The version of Gatekeeper Policy Controller deployed.
          # @!attribute [rw] deployment_state
          #   @return [::Google::Cloud::GkeHub::ConfigManagement::V1::GatekeeperDeploymentState]
          #     The state about the policy controller installation.
          class PolicyControllerState
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The build version of Gatekeeper Policy Controller is using.
          # @!attribute [rw] version
          #   @return [::String]
          #     The gatekeeper image tag that is composed of ACM version, git tag, build
          #     number.
          class PolicyControllerVersion
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # State of Policy Controller installation.
          # @!attribute [rw] gatekeeper_controller_manager_state
          #   @return [::Google::Cloud::GkeHub::ConfigManagement::V1::DeploymentState]
          #     Status of gatekeeper-controller-manager pod.
          # @!attribute [rw] gatekeeper_audit
          #   @return [::Google::Cloud::GkeHub::ConfigManagement::V1::DeploymentState]
          #     Status of gatekeeper-audit deployment.
          class GatekeeperDeploymentState
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Enum representing the state of an ACM's deployment on a cluster
          module DeploymentState
            # Deployment's state cannot be determined
            DEPLOYMENT_STATE_UNSPECIFIED = 0

            # Deployment is not installed
            NOT_INSTALLED = 1

            # Deployment is installed
            INSTALLED = 2

            # Deployment was attempted to be installed, but has errors
            ERROR = 3

            # Deployment is installing or terminating
            PENDING = 4
          end
        end
      end
    end
  end
end
