# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/cloud/gkehub/v1/service.proto for package 'Google.Cloud.GkeHub.V1'
# Original file comments:
# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/cloud/gkehub/v1/service_pb'

module Google
  module Cloud
    module GkeHub
      module V1
        module GkeHub
          # The GKE Hub service handles the registration of many Kubernetes clusters to
          # Google Cloud, and the management of multi-cluster features over those
          # clusters.
          #
          # The GKE Hub service operates on the following resources:
          #
          # * [Membership][google.cloud.gkehub.v1.Membership]
          # * [Feature][google.cloud.gkehub.v1.Feature]
          #
          # GKE Hub is currently available in the global region and all regions in
          # https://cloud.google.com/compute/docs/regions-zones. Feature is only
          # available in global region while membership is global region and all the
          # regions.
          #
          # **Membership management may be non-trivial:** it is recommended to use one
          # of the Google-provided client libraries or tools where possible when working
          # with Membership resources.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.cloud.gkehub.v1.GkeHub'

            # Lists Memberships in a given project and location.
            rpc :ListMemberships, ::Google::Cloud::GkeHub::V1::ListMembershipsRequest, ::Google::Cloud::GkeHub::V1::ListMembershipsResponse
            # Lists Features in a given project and location.
            rpc :ListFeatures, ::Google::Cloud::GkeHub::V1::ListFeaturesRequest, ::Google::Cloud::GkeHub::V1::ListFeaturesResponse
            # Gets the details of a Membership.
            rpc :GetMembership, ::Google::Cloud::GkeHub::V1::GetMembershipRequest, ::Google::Cloud::GkeHub::V1::Membership
            # Gets details of a single Feature.
            rpc :GetFeature, ::Google::Cloud::GkeHub::V1::GetFeatureRequest, ::Google::Cloud::GkeHub::V1::Feature
            # Creates a new Membership.
            #
            # **This is currently only supported for GKE clusters on Google Cloud**.
            # To register other clusters, follow the instructions at
            # https://cloud.google.com/anthos/multicluster-management/connect/registering-a-cluster.
            rpc :CreateMembership, ::Google::Cloud::GkeHub::V1::CreateMembershipRequest, ::Google::Longrunning::Operation
            # Adds a new Feature.
            rpc :CreateFeature, ::Google::Cloud::GkeHub::V1::CreateFeatureRequest, ::Google::Longrunning::Operation
            # Removes a Membership.
            #
            # **This is currently only supported for GKE clusters on Google Cloud**.
            # To unregister other clusters, follow the instructions at
            # https://cloud.google.com/anthos/multicluster-management/connect/unregistering-a-cluster.
            rpc :DeleteMembership, ::Google::Cloud::GkeHub::V1::DeleteMembershipRequest, ::Google::Longrunning::Operation
            # Removes a Feature.
            rpc :DeleteFeature, ::Google::Cloud::GkeHub::V1::DeleteFeatureRequest, ::Google::Longrunning::Operation
            # Updates an existing Membership.
            rpc :UpdateMembership, ::Google::Cloud::GkeHub::V1::UpdateMembershipRequest, ::Google::Longrunning::Operation
            # Updates an existing Feature.
            rpc :UpdateFeature, ::Google::Cloud::GkeHub::V1::UpdateFeatureRequest, ::Google::Longrunning::Operation
            # Generates the manifest for deployment of the GKE connect agent.
            #
            # **This method is used internally by Google-provided libraries.**
            # Most clients should not need to call this method directly.
            rpc :GenerateConnectManifest, ::Google::Cloud::GkeHub::V1::GenerateConnectManifestRequest, ::Google::Cloud::GkeHub::V1::GenerateConnectManifestResponse
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
